// Persistence Of Vision raytracer version 3.5 
// Table include file
// Ron Gow 2003

#include "colors.inc" 
#include "woods.inc"

#ifndef(Ft)
    #local Ft=1;
    #local In=Ft/12;
#end

//  *****************************************************
  
#local t_tex = texture { T_Wood24 // 4,12,14,18,24,28
    finish { reflection .05 specular .2 phong .35 ambient 0}
}


#local TR = 2.5*Ft;

#local T_Top = union {
    difference { 
        cylinder { 0 <0,In,0> TR }
        torus { TR In/4 scale <1,1,1> translate y*In }
    }
    torus { TR In*.375 translate y*In*.375 }
    texture { t_tex scale .5 }
}

#local T_Leg = lathe {
	cubic_spline 11,
	<-.005,1.000>, <0.000,1.000>, <0.180,1.000>,
	<0.165,0.950>, <0.095,0.900>, <0.115,0.500>, 
	<0.160,0.125>, <0.275,0.100>, <0.290,0.000>, 
	<0.000,0.000>, <-.005,-.000>
    texture { t_tex scale <.13,.5,.10> rotate x*89 }
    scale <1,2.2,1> 
}

#local Foot = difference {
    sphere_sweep {
    	cubic_spline 6
    	<-.005,0.31,0>, 2.5*In, <0.00,0.30,0>, 2.5*In, 
    	<0.4,0.285,0>, 2*In, <0.90,0.15,0>, 1.1*In,
    	<1.30,0.07,0>, 2.25*In, <1.50,0.02,0>, 1*In
    	texture { t_tex scale <.13,.5,.10> rotate -z*98}
    }
    box { <-3*In,-2*In,-3*In> <21*In,0,3*In> }
}

#local T_Foot = union {
    object { Foot }
    object { Foot rotate y*180 }
    object { Foot rotate y*90 }
    object { Foot rotate -y*90 }
}

#declare Table = union {
    object { T_Foot }
    object { T_Leg translate y*3*In }
    object { T_Top translate y*2.5*Ft }
}

// table end