// Persistence Of Vision raytracer version 3.5 
// test file
// Ron Gow

#version 3.5;

// ****************   Textures   *********************

#declare P_Goblet = pigment { rgbft <1,1,1,.8,.2> }

#declare P_Bottle = pigment { rgbf <.177, .532, .238, 1> }

#declare F_Crystal =  finish {
    ambient 0 diffuse 0
    phong .45 phong_size 50
    reflection { .00, .85 fresnel on }
    conserve_energy
}

#declare F_Glass = finish { 
    ambient 0 diffuse 0 
    phong .4 phong_size 20 
    reflection {0,.65 fresnel on } 
}

#declare I_Crystal = interior { 
    ior 1.85
    fade_distance 10
    fade_power 1001
}

#declare I_Glass = interior { 
    ior 1.45
    fade_distance 5
    fade_power 1001
}

#declare T_Cork = texture {
    pigment { rgb <.75,.55,.15> } 
    normal { granite .3 }
    finish { ambient 0 }
}

// *************   Crystal Goblet   *******************
 
#declare Goblet = lathe {
    cubic_spline  17,
    <-.1,.535>, <.02,.57>, <.30, .682>, <.434, .85>, <.42,1.15>, <.387,1.310>, <.39,1.315>
    <.425,1.15>, <.44, .845>, <.33, .690>, <.13, .575>, <.08 .45>, <.08,.06>, <.25,.03>, <.35,0>
    <0,0>, <-1,0>
    texture { 
        pigment { P_Goblet }
        finish { F_Crystal }
    }
    interior { I_Crystal }
    scale <.23,.42,.23>
    translate y*.0035 
}

// ***********  Green Bottle w/ Cork  *****************

#declare Cork = cone { 0 .025 <0,.105,0> .032 texture { T_Cork } }

#declare Bottle = lathe{
    cubic_spline 20,
    <-.002,0.034>, <0.000,0.033>, <0.015,0.030>, <0.030,0.020>, <0.031,0.015>, <0.035,0.013>,
    <0.048,0.010>, <0.064,0.015>, <0.067,0.045>, <0.070,0.175>, <0.030,0.286>, <0.019,0.360>, 
    <0.024,0.370>, <0.022,0.384>, <0.014,0.380>, <0.023,0.291>,
    <0.059,0.185>, <0.052,0.030>, <0.000,0.045>, <-.003,0.043>
    texture { 
        pigment { P_Bottle }
        finish { F_Glass }
    }
    interior { I_Glass }
    translate -y*.01
    scale <2,3,2>
}

#declare BottleC = union {
    object { Bottle }
    object { Cork translate y*1.06 }
     
}

