global_settings { max_trace_level 20 assumed_gamma 2 }

//copyright 2003 Steve Bennett www.karmastorm.com

#include "colors.inc"
#include "finish.inc"
//#include "grid.inc"



sky_sphere
{
  pigment
  {
    gradient y
    color_map {

    [0.05 color Black]
    [0.5 color MidnightBlue]
    [1.0 color Cyan] } //Aquamarine
    turbulence .1
  }
}



//eggs
//milk  

#declare Nrrrg =
texture {
pigment {color Gray05}
finish {phong 0.115//increase to 1 to brighten
phong_size 1
brilliance .15
irid { .225 thickness  1.5 turbulence .065} //thicker film = larger areas of color
specular .1}}


#declare RottenStone =
texture {pigment {
 gradient y
    colour_map
     {
     [0.0 DustyRose]
     [0.10 Wheat]
     [0.15 DarkWood]
     [0.20 Wheat]
     [0.80 DustyRose]
     [0.90 Tan]
     [1.0 DarkBrown]
     }
     turbulence .145
     scale .2


      }
    finish {
 ambient 0.01
 crand 0.22175

 } }


camera {location  <0 ,0 ,-20> look_at <0, 11, 0> angle 90
 normal {
    waves 0.025
    frequency 0.9
    }
   }


light_source {0*x color Red area_light <8, 0, 0> <0, 0, 8>  4, 4 adaptive 0  jitter translate <40, -77, 22540>} //groundfarlight
light_source {0*x color rgb <.4, .6, 1> area_light <99, 99,99> <99,99, 99> 4, 4  adaptive 0  translate <30, 1140, -1110> }


height_field {
tga "c:\images\zscarve\outputz"
translate <-.5, 0, -.5>
scale <50, 4, 50>
smooth
texture {RottenStone scale .75 rotate 10*-z}
rotate 30*y
translate 1*-y 

}

#declare CrackedSky =
box {<0, 0, 0>  < 1,  1,  1>
translate <-.5, -.5, -.5>
scale <100,5,100>
 pigment {
      crackle
      turbulence 0.9
      octaves 4
      scale 0.5
      color_map {
         [0,   0.5 color Red 1 filter 0.5 color Blue 1 filter .03]
         [0.5, 1   color Clear           color Clear]
      }
   }

scale <150 , 50, 150>
 hollow
}

object {CrackedSky translate 95*y translate 30*z}




#declare Blocksize = 1 #declare Gap = Blocksize+.25

#declare Block =
box {<0, 0, 0>  < 1,  1,  .5>
translate <-.5, -.5, -.5>
scale Blocksize}


#declare Row = union {
object {Block translate <Gap*2, 00, 00>}
object {Block translate <Gap*1, 00, 00>}
object {Block translate <00, 00, 00>}
object {Block translate <-Gap*1, 00, 00>}
object {Block translate <-Gap*2, 00, 00>}
}



#declare Barrier = union {
//object {Row translate <00, Gap*3, 00>}
object {Row translate <00, Gap*2, 00>}
object {Row translate <00, Gap*1, 00>}
object {Row}
object {Row translate <00, -Gap*1, 00>}
object {Row translate <00, -Gap*2, 00>}
object {Row translate <00, -Gap*3, 00>}
}

object {Barrier scale 25 texture {Nrrrg scale 1}
translate <0, 125, 100> rotate 0*y
}


fog
{
  fog_type   2     
  distance   115    
  color      Aquamarine 
  fog_offset 1.1     
  fog_alt    0.1    
  turbulence 0.1     
}


fog
{
  fog_type   2
  distance   55       
  color      SpicyPink   
  fog_offset 0.1      
  fog_alt    0.5    
  turbulence 0.8      
}




#include "stones.inc"


#declare Z3_1 =
julia_fractal {
    <-0.883,-0.50,-0.03,-0.0325>
    max_iteration 8
    precision 12
   quaternion
    sqr
    scale 4

rotate <0, 15, 91> }

object {Z3_1  texture {T_Stone15 scale 5}
finish {reflection .7}
translate <0, 0, -15>}




















