// NB. this script has been quickly cleaned for publication
//     so there may be some errors and inconsistencies
//
// NB. include files and image maps not published

#include "colors.inc"
#include "stones.inc"
#include "golds.inc"
#include "woods.inc"
#include "consts.inc"
#include "textures.inc"
#include "glass.inc"
#include "metals.inc"
#include "sky.inc"

#include "instrum_f.inc"
#include "seat.inc"
#include "utensils.inc"

camera {
  location <0,0,0> 
  look_at <-0.2,-0.28,5>
  angle 40
  right 1.5*x
  translate <0,0,-9.2>
  }

global_settings {
  noise_generator 2
  ambient_light 0.0
  assumed_gamma 2.2
  max_trace_level 20
    radiosity{
      pretrace_start 0.08
      pretrace_end   0.01
      count 130
      nearest_count 5
      error_bound 0.3
      recursion_limit 1
      low_error_factor 0.5
      gray_threshold 0.0
      minimum_reuse 0.015
      brightness 1.0
      adc_bailout 0.01/2
      normal on
    }
  photons{
    spacing .003
    autostop 0
    load_file "galleries4c4_003.ph"
    }
  }
  
light_source { <101, 101, -100> White 
  area_light <4,0,0>, <0,4,0> 3, 3
  adaptive 1
  jitter
  }
light_source { <95, 95, -100> White 
  area_light <4,0,0>, <0,4,0> 3, 3
  adaptive 1
  jitter
  }
light_source { <-95, 95, -100> rgb <0.7,0.75,0.8> 
  area_light <4,0,0>, <0,4,0> 3, 3
  adaptive 1
  jitter
  }

sky_sphere { S_Cloud5W }

#declare GlassW = material {
  texture {
    pigment { color rgbf <0.98, 0.98, 0.98, 0.98> }
    finish  {
      diffuse 0.1
      reflection 0.1
      specular 0.3
      roughness 0.00003
      phong 0.5
      phong_size 1000
      }
    }
  interior {
    ior 1.5
    fade_distance 1
    fade_power 2
    }
  }

#macro Photo( I )
  box { <0,0,0>, <1,1,0.001> 
    pigment { image_map { tga I } }
    translate <-0.5,-0.5,0>
    scale <1,0.6666,1>
    }
#end

#declare Profile = union {
   box { <-1,-0.005,0>, <1,0.005,0.02> }
   difference {
     cylinder { <-1,0,0>, <1,0,0> 0.005 }
     box { <-1.1,-0.1,0>, <1.1,0.1,0.1> }
     }
   texture { T_Silver_3D }
   }

#macro FPiece ( L )
  #declare L = L/2;
  difference {
    object { Profile }
    box { <-2,-2,-0.1>, <0,2,0.3> rotate -45*z translate <-L,0,0> }
    box { <0,-2,-0.1>, <2,2,0.3> rotate 45*z translate <L,0,0> }
    }
#end

#macro Frame( W, H, D )
  #declare W = W/2;
  #declare H = H/2;
  union {
    difference {
      box { <-W-D,-H-D,0>, <W+D,H+D,0.002> }
      box { <-W+0.002, -H+0.002, -0.1>, <W-0.002, H-0.002, 0.1> }
      pigment { White }
      }
    box { <-W-D,-H-D,-0.001>, <W+D,H+D,-0.003> material { GlassW } }
    union {
      object { FPiece(2*(W+D)) rotate 180*z translate <0,H+D,-0.003> }
      object { FPiece(2*(W+D)) translate <0,-H-D,-0.003> }
      object { FPiece(2*(H+D)) rotate 90*z translate <W+D,0,-0.003> }
      object { FPiece(2*(H+D)) rotate -90*z translate <-W-D,0,-0.003> }
      photons{
        target
        reflection on
        }
      }
    }
#end

#macro Pic( I, S )
  union {
    object { Photo(I) scale <S,S,S> } 
    object { Frame( S, 0.6666*S, 0.1) translate -0.0021*z }
    }
#end

#declare M_W26 = material {
  texture { T_Wood26 scale 0.2
    rotate 90*x rotate 90*z
    normal {
      average
      normal_map {
        [0.9  bozo 0.01 scale <0.4,0.0012,0.0012> ]
        [0.08  bozo 0.03 scale <0.9,0.07,0.07> ]
        }
      }
    finish { ambient 0 diffuse 0.6 phong 0.5 phong_size 50
    specular 0.2 roughness 0.015 reflection 0.09 }
    }
  scale 0.3
  }

#declare CRad = 0.004;

#macro Beam ( LB, WB, TB, MB ) union {
  #declare HLB = LB/2;
  #declare HWB = WB/2;
  #declare HTB = TB/2;
  #declare HLBC = HLB-CRad;
  #declare HWBC = HWB-CRad;
  #declare HTBC = HTB-CRad;
  box { <-HLB,-HWBC,-HTBC>, <HLB,HWBC,HTBC> }
  box { <-HLBC,-HWB,-HTBC>, <HLBC,HWB,HTBC> }
  box { <-HLBC,-HWBC,-HTB>, <HLBC,HWBC,HTB> }
  sphere { <-HLBC,-HWBC,-HTBC> CRad }
  sphere { <-HLBC,-HWBC,HTBC> CRad }
  sphere { <-HLBC,HWBC,-HTBC> CRad }
  sphere { <-HLBC,HWBC,HTBC> CRad }
  sphere { <HLBC,-HWBC,-HTBC> CRad }
  sphere { <HLBC,-HWBC,HTBC> CRad }
  sphere { <HLBC,HWBC,-HTBC> CRad }
  sphere { <HLBC,HWBC,HTBC> CRad }
  cylinder { <-HLBC,-HWBC,-HTBC>, <HLBC,-HWBC,-HTBC> CRad }
  cylinder { <-HLBC,-HWBC,HTBC>, <HLBC,-HWBC,HTBC> CRad }
  cylinder { <-HLBC,HWBC,-HTBC>, <HLBC,HWBC,-HTBC> CRad }
  cylinder { <-HLBC,HWBC,HTBC>, <HLBC,HWBC,HTBC> CRad }
  cylinder { <-HLBC,-HWBC,-HTBC>, <-HLBC,-HWBC,HTBC> CRad }
  cylinder { <-HLBC,-HWBC,-HTBC>, <-HLBC,HWBC,-HTBC> CRad }
  cylinder { <-HLBC,HWBC,HTBC>, <-HLBC,HWBC,-HTBC> CRad }
  cylinder { <-HLBC,HWBC,HTBC>, <-HLBC,-HWBC,HTBC> CRad }
  cylinder { <HLBC,-HWBC,-HTBC>, <HLBC,-HWBC,HTBC> CRad }
  cylinder { <HLBC,-HWBC,-HTBC>, <HLBC,HWBC,-HTBC> CRad }
  cylinder { <HLBC,HWBC,HTBC>, <HLBC,HWBC,-HTBC> CRad }
  cylinder { <HLBC,HWBC,HTBC>, <HLBC,-HWBC,HTBC> CRad }
  material { MB }
  }
#end
  
#declare NIris = intersection {
  box { <0,0,0>, <1,1,0.01> pigment { image_map { tga "iris.tga" } } }
  cylinder { <0.5,0.5,-0.1>, <0.5,0.5,0.1> 0.50 }
  translate <-0.5,-0.5,0>
  }

#declare BPigm = pigment {
  bozo scale <0.18,0.18,0.1>
  turbulence 1.5
  octaves 10
  omega .5
  lambda 2.5
  color_map {
    [0 rgb <0.1,0.6,0.75>]
    [0.5 rgb <0.1,0.6,0.75>]
    [0.9 color Yellow ]
    [1 rgb <0.15,0.75,0.9>]
    }
  }

#declare BPigm2 = pigment {
  bozo scale <0.15,0.15,0.1>
  turbulence 1.5
  octaves 8
  omega .5
  lambda 2.5
  color_map {
  [0 rgb <0.15,0.75,0.9>]
  [0.4 rgb <0.15,0.75,0.9>]
  [1 color Yellow ]
  }
}

#declare Pigm2 = pigment { rgb <0.15,0.75,0.9> }
#declare Pigm3 = pigment { color Yellow }
#declare Pigm4 = pigment { color Brown }
#declare Pigm5 = pigment { color Gray90 }
#declare Pigm6 = pigment { color Black }

#declare MIris = intersection {
  box { <0,0,0>, <1,1,0.01> 
    texture {
      pigment { 
        mandel 100
        pigment_map {
          [0.0 BPigm ]
          [0.018 BPigm2 ]
  	  [0.04 Pigm3  ]
	  [0.3 Pigm4  ]
	  [0.97 Pigm5 ]
	  [1.0 Pigm6 ]
	  }
        scale 0.2
        translate <0.55,0.45,0>
        }
      }
    }
  cylinder { <0.5,0.5,-0.1>, <0.5,0.5,0.1> 0.50 }
  translate <-0.5,-0.5,0>
  }

#macro Eye ( Iris ) union {
  difference {
    sphere { <0,0,0> 1
      texture { T_Stone8 scale 0.3 }
      finish { ambient 0 diffuse 0.6
      irid { 0.15 }
      specular 0.23 roughness 0.01 reflection 0.01 }
      }
    box { <-2,-2,-2>, <2,2,-0.9115> }
    }
  object { Iris scale 0.83 translate -0.9115001*z }
  difference {
    sphere { <0,0,-0.345> 0.7 }
    box { <-2,-2,-0.90>, <2,2,2> }
    texture { T_Glass3 } interior { I_Glass }
    }
  }

#declare EyeA = Eye ( NIris )
#declare EyeB = Eye ( MIris )

#declare MER = 0.1;
#declare MEye = object { EyeA scale MER rotate 15*x rotate -90*y }

#declare SeatAndStuff = union {
  object { Seat
  object { Goblet translate <-0.3,0.85,-1.5> }
  #declare Count = 0;
  #while ( Count < 14 )
    object { MEye translate <0.3,0.85+MER,0.3*Count-1.95> }
    #declare Count = Count+1;
    #end
  rotate 90*y scale 0.6 translate <0.8,-1.5,-1.6>
  }

#declare M_PA = material { texture { PinkAlabaster } }
   
#declare Xyl = union {
  object { Xyli(M_PA, M_PA, M_PA) }
  object { EyeA scale 0.06 rotate 47*y translate <-0.14,2.06,-0.29> }
  object { EyeB scale 0.06 rotate 47*y translate <0.14,2.06,-0.29> }
  union {
    object { Flute(M_FlW2) translate -0.16*x scale 0.7 }
    object { Goblet translate <0.65,-0.02,0> }
    rotate 40*y
    translate <0,1.3,-0.25>
    }
  rotate <0,-65,0> scale 0.8 
  translate <-1.8,-1.5,-0.5>
  }

#declare Panel = box { <0,0,0>, <1,1,0.001> 
  pigment { image_map { tga "mind7_7620.tga" } }
  scale <6,2.6,1>
  }

#declare Tile = box { <0,0,0>, <1,1,0.001> 
  pigment { image_map { tga "mind6_7620.tga" } }
  scale <5.3,6,1>
  rotate 90*x
  }

#declare Room = union {
  union {
    box { <-2.1,-1.5,-6>, <-2.2,1.1,-0.01> }
    box { <3,-1.5,-6>, <3.1,-1.1,0> }
    cylinder { <3.05,-1.1,0>, <3.05,-1.1,-6> 0.05 }
    texture { T_Stone8
      finish { specular 0.05 roughness 0.002 reflection 0.03 }
      }
    }
  object { Panel rotate -90*y translate <-2.099,-1.5,-6> }
  box { <-2.2,-1.5,-6>, <3.1,-1.65,0>
    texture { T_Stone8
    finish { specular 0.05 roughness 0.002 reflection 0.02 } }
    }
  object { Tile translate <-2.2,-1.499,-6>
    finish { specular 0.5 roughness 0.002 reflection 0.2 }
    }
  object { Beam(6,0.09,0.04,M_W26) rotate 90*y translate <-2.1,-1.45,-3> }
  object { Beam(6,0.09,0.04,M_W26) rotate 90*y translate <3,-1.45,-3> }
  object { Xyl }
  object { SeatAndStuff }
  object { Cem (M_PA) rotate 80*y scale 0.6 translate <0.2,-1.5, -5.1> }
  object { Pic( "arietta_2.tga", 0.76 ) rotate -90*y translate <-2.077,0,-1> }
  object { Pic( "water.tga", 0.76 ) rotate -90*y translate <-2.077,0,-2.1> }
  object { Pic( "arietta.tga", 0.76 ) rotate -90*y translate <-2.077,0,-3.2> }
  }

object { Room }

#declare Count = 1;
#while ( Count < 100 )
  object { Room translate 6*Count+6 }
  #declare Count = Count+1;
  #end

#macro SFrame ( P ) union {
  sphere { <3.05,-1.1,0> 0.05 }
  cylinder { <-2.15,-1.65,0>, <-2.15,1.1,0> 0.05 }
  torus { 0.045 0.005 translate <-2.15,1.1,0> }
  torus { 0.045 0.005 translate <-2.15,-1.65,0> }
  cylinder { <-2.15,-1.55,0>, <3.05,-1.55,0> 0.05 }
  cylinder { <3.05,-1.65,0>, <3.05,-1.1,0> 0.05 }
  torus { 0.045 0.005 translate <3.05,-1.65,0> }
  texture { PinkAlabaster
    finish { specular 0.005 roughness 0.02 reflection 0.003 }
    }
  }
#end

object { SFrame ( 0 ) }
object { SFrame ( 6 ) }

cylinder { <-2.15,1.05,-0.1>, <-2.15,1.05,6.1> 0.01 texture { T_Gold_3A } }
cylinder { <-2.15,-1.55,-0.1>, <-2.15,-1.55,6.1> 0.01 texture { T_Gold_3A } }
cylinder { <-2.15,-1.6,-0.1>, <-2.15,-1.6,6.1> 0.01 texture { T_Gold_3A } }
cylinder { <3.05,-1.55,-0.1>, <3.05,-1.55,6.1> 0.01 texture { T_Gold_3A } }
cylinder { <3.05,-1.6,-0.1>, <3.05,-1.6,6.1> 0.01 texture { T_Gold_3A } }
cylinder { <0.45,-1.55,-0.1>, <0.45,-1.55,6.1> 0.01 texture { T_Gold_3A } }

torus { 0.05 0.01 translate <-2.15,1.05,0> texture { T_Gold_3A } }
torus { 0.05 0.01 translate <-2.15,-1.55,0> texture { T_Gold_3A } }
torus { 0.05 0.01 translate <-2.15,-1.6,0> texture { T_Gold_3A } }
torus { 0.05 0.01 rotate 90*z translate <0.45,-1.55,0> texture { T_Gold_3A } }
torus { 0.05 0.01 translate <3.05,-1.55,0> texture { T_Gold_3A } }
torus { 0.05 0.01 translate <3.05,-1.6,0> texture { T_Gold_3A } }

torus { 0.05 0.01 translate <-2.15,1.05,6> texture { T_Gold_3A } }
torus { 0.05 0.01 translate <-2.15,-1.55,6> texture { T_Gold_3A } }
torus { 0.05 0.01 translate <-2.15,-1.6,6> texture { T_Gold_3A } }
torus { 0.05 0.01 rotate 90*z translate <0.45,-1.55,6> texture { T_Gold_3A } }
torus { 0.05 0.01 translate <3.05,-1.55,6> texture { T_Gold_3A } }
torus { 0.05 0.01 translate <3.05,-1.6,6> texture { T_Gold_3A } }

#declare CTorii = union {
  torus { 0.05 0.01 }
  torus { 0.05 0.01 rotate 90*x }
  torus { 0.05 0.01 rotate 90*z }
  texture { T_Gold_3A }
  }

object { CTorii translate <3.05,-1.1,0> }
object { CTorii translate <3.05,-1.1,6> }

object { Flute(M_FlW2) translate <-0.63,-0.02,0> rotate -90*y
  scale <3,3,3> translate <-1.25,-1.5,1.0>
  }
object { Flute(M_FlW2) translate <-0.63,-0.02,0> rotate -90*y
  scale <3,3,3> translate <-1.25,-1.5,5.0> }

#declare MCem = object { Cem( CBMat ) translate -1.1*y
  scale 0.075 translate -1.5*y
  }
  
object { MCem rotate -47*y translate <-2.03,0,-3.1> }
object { MCem rotate 46*y translate <-2.1,0,-2.1> }
object { MCem rotate -12*z rotate -25*y translate <-1.25,0,-3.1> }
object { MCem rotate -12*z rotate -45*y translate <-0.75,0,-3.45> }
object { MCem rotate 120*y translate <0,0,-3.1> }

union {
  object { Cem ( CBMat ) rotate -27*z rotate -15*x rotate 64*y
    translate <6.9,3,8.9>
    }
  object { Cem ( CBMat ) rotate -19*z rotate -11.5*x rotate 41*y
    translate <3.1,2,5>
    }
  object { Cem ( CBMat ) rotate -12*z rotate -8*x rotate 23*y
    translate <1.2,1,2.95>
    }
  object { Cem ( CBMat ) rotate -5*z rotate -3*x rotate 10*y
    translate <0,0,0>
    }
  scale 0.05 rotate 5*y translate <-0.7,-1.5,-3.4>
  }

union {
  #declare Count = 0;
  #while ( Count < 12 )
    object {
      Cem( CBMat ) scale 0.05
      rotate (30*Count-70)*y
      translate vrotate(<0,0,-0.38>, <0,30*Count,0> )
      }
    #declare Count = Count+1;
    #end
  translate <0,-1.5,-0.6>
  }

