// Chain_Test.pov
/////////////////////////////////////////

global_settings { assumed_gamma 2.2 }
#declare Debug = 1;

#include "colors.inc"
#include "metals.inc"  
#include "golds.inc"
#include "Chain.inc" 
#include "gears.inc"     

//#declare ChainTexture = T_Chrome_2B; 
#declare ChainTexture = T_Gold_3B;
#declare SproketTexture = T_Silver_3B;

//#declare ChainTexture = pigment { color Red };
//#declare SproketTexture = pigment { color Yellow };

light_source { <800, 600, -200> color White }
light_source { <100, 50, -1000> color White }

camera {
   location <59, 20, -175>
//   location <0, 100, -150>
//   location <0, 20, -100>
//   location <0, 100, -150> *3
//   location <-50, 100, 50>
   location <-50, 200, -150> * 4
   location <70, 200, -150> * 4
   location <280, -500, -1500>
   direction <0, 0, 2>
   up <0, 1, 0>
   right <4/3, 0, 0>
   look_at <0, 0, 1>
}
   
   // radiosity (global illumination) settings
global_settings {
  radiosity {
    pretrace_start 0.08           // start pretrace at this size
    pretrace_end   0.04           // end pretrace at this size
    count 35                      // higher -> higher quality (1..1600) [35]
    nearest_count 5               // higher -> higher quality (1..10) [5]
    error_bound 1.8               // higher -> smoother, less accurate [1.8]
    recursion_limit 3             // how much interreflections are calculated (1..5+) [3]
    low_error_factor .5           // reduce error_bound during last pretrace step
    gray_threshold 0.0            // increase for weakening colors (0..1) [0]
    minimum_reuse 0.015           // reuse of old radiosity samples [0.015]
    brightness 1                  // brightness of radiosity effects (0..1) [1]

    adc_bailout 0.01/2
    //normal on                   // take surface normals into account [off]
    //media on                    // take media into account [off]
    //save_file "file_name"       // save radiosity data
    //load_file "file_name"       // load saved radiosity data
    //always_sample off           // turn sampling in final trace off [on]
    //max_sample 1.0              // maximum brightness of samples
  }
}

       
plane { y, -1000 pigment { checker color Green color White scale 10}}
  sky_sphere {
    pigment {
      gradient y
      color_map {
        [0.000 0.002 color rgb <0.0, 0.2, 1.0>
                     color rgb <0.0, 0.2, 1.0>]
        //[0.002 0.200 color rgb <0.0, 0.1, 0.8>        // blue background
        //             color rgb <0.2, 0.2, 0.3>]
        [0.002 0.200 color rgb <0.8, 0.1, 0.0>          // red background
                     color rgb <0.2, 0.2, 0.3>]
      }
      scale 2
      translate -1
    }
    pigment {
      bozo
      turbulence 0.65
      octaves 6
      omega 0.7
      lambda 2
      color_map {
          [0.0 0.1 color rgb <0.85, 0.85, 0.85>
                   color rgb <0.75, 0.75, 0.75>]
          [0.1 0.5 color rgb <0.75, 0.75, 0.75>
                   color rgbt <1, 1, 1, 1>]
          [0.5 1.0 color rgbt <1, 1, 1, 1>
                   color rgbt <1, 1, 1, 1>]
      }
      scale <0.2, 0.5, 0.2>
    }
    rotate -135*x
  }

#macro SproketChain (s)
union {
    object { Sproket(P,R,W, s) 
             texture { SproketTexture }
    }
    object { CurveChain(s, 0.5)
             texture { ChainTexture }
    }
    object { Chain                          
             translate <P/2,0,Sr>
             texture { ChainTexture }
    } 
    object { Chain
             translate <P*2,0,-Sr>
             texture { ChainTexture } 
    }
}
#end // macro

object { SproketChain(45)
         rotate -90*z
}

object { SproketChain(45)
         rotate -90*z
         translate -200*x
         rotate 90*y
         translate <80,100,0>
}

object { SproketChain(100)
         rotate z*-90
         translate -30*x
}

object { SproketChain(17)
         rotate -90*z
         rotate 135*y
         translate <210,200,0>
}
          
object { SproketChain(17)
         rotate -90*z
         translate -300*x
         rotate 45*y
         translate <250,400,0>
}

object { SproketChain(25)
         rotate -90*z
         rotate 30*y
         translate <350,-120,1000>
}

object { SproketChain(201)
         rotate -90*z
         rotate 90*y
         translate <0,1000,2000>
}

object { SproketChain(25)
	 rotate -90*z
	 rotate 125*y
	 translate <130, -450, -1200>
}	
