/*
City Scape
created by Toby Anderson
July / August 2003
based on concept by Marcus Anderson

created for the IRTC topic: Sureal
*/

// +w400 +h500 -A
// +w600 +h900 +A0.5
// +w640 +h960 +A0.1
// +w800 +h1200 +A0.0

#include "textures.inc"
#include "my_objects.inc"
#include "my_macros.inc"

// 0 for quick, 1 for detail
#declare detail = 1;

global_settings {max_trace_level 6}

// make everything shades of one colour
#declare pig = rgb <0.0095,0.0095,0.01>; // blue-grey

#declare MatSurface =
texture {
    finish {
        specular 0.05
        roughness 0.7
        diffuse 0.5
    }// finish
    pigment {pig*20}
}// texture

#declare ShinySurface =
texture {
    Silver_Metal
    pigment {pig*90}
}// texture

#declare VeryShinySurface =
texture {
    ShinySurface
    finish {
        reflection 0.6
    }// finish
}// texture

#declare GrassySurface =
texture {
    pigment {
        bozo
        color_map {
            [0 rgb <0.2,0.5,0.06>]
            [0.5 rgb <0.3,0.7,0.2>]
            [1 rgb <0.25,0.6,0.1>]
        }// color_map
        scale 8
    }// pigment
    normal {
        wrinkles
        scale 0.2
    }// normal
}// texture

#declare Leaves = 
texture {
    pigment {
        agate
        color_map {
            [0.79 color rgbt 1]
            [0.79 color rgb <0.2, 0.5, 0.10> ]
            [0.86 color rgb <0.3, 0.6, 0.15> ]
            [0.97 color rgb <0.4, 0.7, 0.15> ]
            [0.99 color rgb <0.3, 0.5, 0.08> ]
        }// color_map
        scale 1.5
        warp { turbulence 0.4 }
    }// pigment
    finish {
        diffuse 0.5
        brilliance 1.5
        ambient 0.1
    }// finish
}// texture

#declare ChasmFace =
texture {
    pigment {
        gradient y
        color_map {
            [0 rgb 0]
            [0.7 pig*80]
            [1 pig*90]
        }// color_map
        scale <1,22.02,1>
        translate y*2 // one rock sticks up above y=0
    }// pigment
    finish {ambient 0.05}
}// texture

camera {
    location  <-4, 32, -37>
    up        <0,  2.6,   0>
    look_at <2, 2, -20>
}// camera
/*
camera {
    location  <-15, 2, 2>
    up        <0,  1,   0>
    look_at <25, 5, 50>
}// camera
*/
/*
camera {
    orthographic
    up <0, 70, 0>
    right <93, 0, 0>
    location <-5, 50, -80>
    look_at <20, 0, 35>
}// camera
*/
/*
camera {
    up y
    location <20,250,-15>
    look_at <20,0,-10>
}// camera
*/
light_source { 
    <-150, 250, -130> 
    colour rgb 1
    #if (detail = 1)
        area_light <20, 0, 0>, <0, -10, 20>, 5, 5
        adaptive 1
        jitter
    #end
}// light source

sky_sphere {
    pigment {
        gradient y
        color_map {
            [0 rgb 0]
            [0.3 rgb 0]
            [0.6 pig*50]
            [1 pig*60]
        }// color map
        scale 2
        translate y*-1
    }// pigment
}// sky sphere

// ground
// north of chasm
plane {
    y, 0
    clipped_by {plane {-z, 5}}
    texture {ShinySurface}  
}// plane
// south of chasm
union {
    plane {
        y, -0.001
        clipped_by {plane {<0.15,0,1>, -35}}
    }// plane
    plane {
        y, -0.001
        clipped_by {plane {<-0.17,0,1>, -40}}
    }// plane
    texture {GrassySurface}
}// union

#declare rocky =
function {
    pigment {
        agate
        color_map {
            [0 color rgb 0]
            [1 color rgb 1]
        }
    }
}

#declare Rock =
isosurface {
    function {
        f_sphere(x/1.5,y,z/1.3,4)-f_noise3d(x/2,y/1.5,z/1.2)
        #if (detail = 1) -rocky(x/4, y/4, z/4).gray*0.5 #end
    }
    max_gradient 3.36
    contained_by {
        sphere {0 7.5}
    }
    #if (detail = 1) accuracy 0.05
    #else accuracy 0.2
    #end
}

#declare RockWall =
isosurface {
    function {
        -z+abs(pow(x,3))/200+abs(pow(y,3))/150
        #if (detail = 1) -rocky(x/2, y/6, z/3).gray*0.5 #end
    }
    contained_by {
        box { <-10,-2,-2> <8,7.95,10> }
    }
    max_gradient 5.198
    #if (detail = 1) accuracy 0.05
    #else accuracy 0.2
    #end
    translate y*-8
    scale <2.5,2,1.5> 
}

#declare WallTop = // useful for making top of wall different finish to face
isosurface {
    function {
        -z+abs(pow(x,3))/200+abs(pow(y,3))/150
        #if (detail = 1) -rocky(x/2, y/6, z/3).gray*0.5 #end
    }
    contained_by {
        box { <-10,7.95,-2> <8,8,10> }
    }
    max_gradient 4.672
    #if (detail = 1) accuracy 0.05
    #else accuracy 0.2
    #end
    translate y*-8
    scale <2.5,2,1.5> 
}

// north face of chasm
/*
camera {
    location  <10, 22, -45>
    up        <0,  1,   0>
    look_at <17, -5, -5>
}
*/
union {
    union {
        object {
            WallTop
            texture {ShinySurface}
        }
        object {
            RockWall
        }
        translate <-5,0,-16>
    }
    union {
        object {
            WallTop
            texture {ShinySurface}
        }
        object {
            RockWall
        }
        scale <0.5,0.8,0.6>
        rotate <0,-45,0>
        translate <25,0,-6>
    }
    union {
        object {
            WallTop
            texture {ShinySurface}
        }
        object {
            RockWall
        }
        scale <0.2,0.4,0.3>
        rotate <0,100,0>
        translate <20,0,-8>
    }
    union {
        object {
            WallTop
            texture {ShinySurface}
        }
        object {
            RockWall
        }
        rotate <0,-20,0>
        translate <50,0,-15.3>
    }
    union {
        object {
            WallTop
            texture {ShinySurface}
        }
        object {
            RockWall
        }
        translate <-35,0,-16>
    }
    union {
        object {
            WallTop
            texture {ShinySurface}
        }
        object {
            RockWall
        }
        translate <-70,0,-16>
    }
    union {
        object {
            WallTop
            texture {ShinySurface}
        }
        object {
            RockWall
        }
        scale <2.5,1,1>
        translate <-110,0,-16>
    }
    union {
        object {
            WallTop
            texture {ShinySurface}
        }
        object {
            RockWall
        }
        translate <75,0,-14>
    }
    union {
        object {
            WallTop
            texture {ShinySurface}
        }
        object {
            RockWall
        }
        scale <2,1,1>
        translate <125,0,-14>
    }
    // patch an area where the plane doesn't reach the cliff edge
    triangle {
        <25,0,-3> <24,0,-9.5> <40,0,-3>
        texture {ShinySurface}
    }
    // these rocks used to patch smooth areas of the cliff face
    object {
        Rock
        scale <0.5,1,0.6>
        translate <23.5,-4,-11>
    }
    object {
        Rock
        rotate <40,20,100>
        scale <0.8,0.6,0.4>
        translate <19,-7,-10.5>
    }
    object {
        Rock
        rotate <140,-20,-60>
        scale <0.4,0.9,0.5>
        translate <24,-10,-15>
    }
    object {
        Rock
        rotate <-40,120,10>
        scale <0.5,0.6,0.6>
        translate <21,-8,-12.5>
    }
    object {
        Rock
        rotate <0,100,50>
        scale <0.4,0.4,0.4>
        translate <18,-3,-10>
    }
    texture {ChasmFace}
}

// south face of chasm
/*
camera {
    location  <50, 22, 0>
    up        <0,  1,   0>
    look_at <40, -5, -15>
}
light_source {
    <70,50,50>
    colour rgb 1
}
*/
union {
    union {
        object {WallTop}
        object {
            RockWall
            texture {ChasmFace}
        }
        rotate y*180
        translate <5,0,-23>
    }
    union {
        object {WallTop}
        object {
            RockWall
            texture {ChasmFace}
        }
        rotate y*190
        translate <-25,0,-20>
    }
    union {
        object {WallTop}
        object {
            RockWall
            texture {ChasmFace}
        }
        scale <0.3,1,0.6>
        rotate y*110
        translate <25,0,-30>
    }
    union {
        object {WallTop}
        object {
            RockWall
            texture {ChasmFace}
        }
        rotate y*190
        translate <51,0,-22.5>
    }
    union {
        object {WallTop}
        object {
            RockWall
            texture {ChasmFace}
        }
        rotate y*170
        translate <70,0,-20>
    }
    union {
        object {WallTop}
        object {
            RockWall
            texture {ChasmFace}
        }
        scale <2,1,1>
        rotate y*170
        translate <110,0,-12>
    }
    union {
        object {WallTop}
        object {
            RockWall
            texture {ChasmFace}
        }
        scale <2,1,1>
        rotate y*187
        translate <-85,0,-12>
    }
    // patch an area where the plane doesn't reach the cliff edge
    triangle {
        <32,-0.001,-36> <36,-0.001,-34.5> <32,-0.001,-34>
    }
    // these rocks used to patch smooth areas of the cliff face
    object {
        Rock
        scale <0.3,1,0.4>
        translate <31,-5,-26>
        texture {ChasmFace}
    }
    object {
        Rock
        rotate y*100
        scale <0.3,1,0.4>
        translate <31,-11,-25>
        texture {ChasmFace}
    }
    texture {GrassySurface}
}

// west road
/*
camera {
    location  <-3, 12, -25>
    up        <0,  1,   0>
    look_at <0, 0, -10>
}
*/
mesh {
    triangle {<0,0.004,-8> <1,0.004,-8> <0,0.004,55>}
    triangle {<1,0.004,-8> <0,0.004,55> <1,0.004,55>}
    smooth_triangle {
        <0,0.004,-8> y
        <1,0.004,-8> y
        <0,0.2,-9> <0,1,0.2>
    }
    smooth_triangle {
        <1,0.004,-8> y
        <0,0.2,-9> <0,1,0.2>
        <1,0.2,-9> <0,1,0.2>
    }
    smooth_triangle {
        <0,0.2,-9> <0,1,0.2>
        <1,0.2,-9> <0,1,0.2>
        <0,0.4,-10> y
    }
    smooth_triangle {
        <1,0.2,-9> <0,1,0.2>
        <0,0.4,-10> y
        <1,0.4,-10> y
    }
    smooth_triangle {
        <0,0.4,-10> y
        <1,0.4,-10> y
        <0,-0.2,-12> <0,1,-0.2>
    }
    smooth_triangle {
        <1,0.4,-10> y
        <0,-0.2,-12> <0,1,-0.2>
        <1.3,-0.4,-13> <0.2,1,-0.2>
    }
    smooth_triangle {
        <0.65,-0.3,-12.5> <0.1,1,-0.2>
        <1.3,-0.4,-13> <0.2,1,-0.2>
        <1,-0.1,-14> <0.5,1,0>
    }
    smooth_triangle {
        <1.3,-0.4,-13> <0.2,1,-0.2>
        <1,-0.1,-14> <0.5,1,0>
        <1.7, 0.2,-14.7> <1,1,0.2>
    }
    smooth_triangle {
        <1,-0.1,-14> <0.5,1,0>
        <1.7, 0.2,-14.7> <1,1,0.2>
        <1.2, 0.5,-15> <1,0.5,0.5>
    }
    smooth_triangle {
        <1.7, 0.2,-14.7> <1,1,0.2>
        <1.2, 0.5,-15> <1,0.5,0.5>
        <2.3, 0.8, -15> <0.5,0.5,1>
    }
    smooth_triangle {
        <0,-0.2,-12> <0,1,-0.2>
        <0.6,-0.3,-12.5> <0.1,1,-0.2>
        <-0.2,-0.5,-13> <-0.1,1,1>
    }
    smooth_triangle {
        <0.6,-0.3,-12.5> <0.1,1,-0.2>
        <-0.2,-0.5,-13> <-0.1,1,1>
        <0,-0.7,-13.2> <-0.1,0.4,1>
    }
    texture {
        MatSurface
        pigment {pig*30}
    }
}

// west chips
object {
    Chip(MatSurface, ShinySurface)
    translate <3.6,0.004,0>
}
object {
    Chip(MatSurface, ShinySurface)
    translate <-2.6,0.004,0>
}
object {
    Chip(MatSurface, ShinySurface)
    translate <3.6,0.004,21>
}
object {
    Chip(MatSurface, ShinySurface)
    translate <-2.6,0.004,21>
}
object {
    Chip(MatSurface, ShinySurface)
    translate <3.6,0.004,42>
}
object {
    Chip(MatSurface, ShinySurface)
    translate <-2.6,0.004,42>
}

// east road
mesh {
    triangle {<49,0.004,35> <50,0.004,35> <49,0.004,85>}
    triangle {<50,0.004,35> <49,0.004,85> <50,0.004,85>}
    texture {
        MatSurface
        pigment {pig*30}
    }
}

// east chips
/*
camera {
    location <40, 35, 40>
    up        <0,  1,   0>
    look_at <53,2,65>
}
*/
object {
    Chip(MatSurface, ShinySurface)
    translate <52.6,0.004,49>
}
object {
    Chip(MatSurface, ShinySurface)
    translate <52.6,0.004,70>
}
object {
    Chip(MatSurface, ShinySurface)
    translate <52.6,0.004,91>
}

// middle building
/*
camera {
    location  <7, 8, 8>
    up        <0,  1,   0>
    look_at <19, 2, 20>
}
*/
union {
    union {
        // main structure
        difference {
            box {
                <0,0,0> <13,2.4,9>
            }
            cylinder {
                <5.5,-0.001,-0.1> <5.5,2.41,-0.1> 1
            }
            cylinder {
                <5.5,-0.001,0.9> <5.5,2.41,0.9> 0.3
            }
        }
        // top part
        difference {
            box {
                <8,2.4,0> <13,4.5,9>
            }
            box {
                <7.99,2.39,4> <13.01,4.51,5>
            }
        }
        texture {
            MatSurface
            pigment {pig*30}
        }
    }
    union {
        box {
            <10,0,4.2> <14,6,4.8>
            texture {
                MatSurface
                pigment {pig*10}
            }
        }
        #declare i = 10.2;
        #while (i < 11.9)
            box {
                <i,5.2,4.15> <i+0.25,5.5,4.85>
            }
            #declare i = i+0.45;
        #end
        mesh {
            triangle { <12.8,5.9,4.19> <12.8,5.7,4.19> <13.7,5.9,4.19> }
            triangle { <13.7,5.7,4.19> <12.8,5.7,4.19> <13.7,5.9,4.19> }
        }
        mesh {
            triangle { <12.3,5.3,4.19> <12.3,5.1,4.19> <13.7,5.3,4.19> }
            triangle { <13.7,5.1,4.19> <12.3,5.1,4.19> <13.7,5.3,4.19> }
        }
    }
    cylinder {
        <1.6,1.2,4.5> <5.7,1.2,4.5> 2.3
        texture {
            ShinySurface
            normal {
                gradient x
                //scallop_wave    // absolute value of sine wave
                //cubic_wave      // cubic curve from 0.00 to 1.0
                poly_wave 0.5   // exponential function
                scale <0.81,1.5,1>
            }
        }
    }
    mesh {
        triangle { <-0.2,1.3,-0.2> <13.2,1.3,-0.2> <-0.2,1.8,-0.2> }
        triangle { <13.2,1.8,-0.2> <13.2,1.3,-0.2> <-0.2,1.8,-0.2> }
        triangle { <13.2,1.3,-0.2> <13.2,1.3,9.2> <13.2,1.8,-0.2> }
        triangle { <13.2,1.8,9.2> <13.2,1.3,9.2> <13.2,1.8,-0.2> }
        triangle { <-0.2,1.3,9.2> <13.2,1.3,9.2> <-0.2,1.8,9.2> }
        triangle { <13.2,1.8,9.2> <13.2,1.3,9.2> <-0.2,1.8,9.2> }
        triangle { <-0.2,1.3,-0.2> <-0.2,1.3,9.2> <-0.2,1.8,-0.2> }
        triangle { <-0.2,1.8,9.2> <-0.2,1.3,9.2> <-0.2,1.8,-0.2> }
    }
    texture {ShinySurface}
    translate <13,0.004,19>
}

// east wall
/*
camera {
    location  <42, 25, 15>
    up        <0,  1,   0>
    look_at <44, 20, 31>
}
light_source {
    <200, 50, 20>
    colour rgb 1
}
*/
#declare WallA =
union {
    // base
    difference {
        box {
            <0,0,0> <35,2.5,7>
        }
        box {
            <-0.001,0.8,2.5> <35.01,2.51,4.5>
        }
        texture {
            MatSurface
            pigment {pig*95}
        }
    }
    box {
        <0,0.9,2.6> <35,2.5,4.4>
    }
    difference {
        box {
            <0,2.5,2.6> <35,27,3.3>
        }
        // corner cut-out
        box {
            <-0.001,15,2.59> <7,27.01,3.31>
        }
        // stripy cut-out
        box {
            <20,10,2.59> <30,16,3.31>
        }
        box {
            <25,8,2.59> <30,10.01,3.31>
        }
        box {
            <21.5,7,2.59> <21.6,10.01,3.31>
        }
    }
    box {
        <23,10.5,2.6> <25,14,3.3>
    }
    box {
        <19.99,6.99,3> <30.01,16.01,3.29>
        texture {
            pigment {pig*70}
            finish {Metallic_Finish}
            /*normal {
                gradient y
                triangle_wave
                scale 0.005
            }*/
            normal {
                gradient y
                poly_wave 0.5
                scale <1,0.5,1.5>
            }// normal
        }// texture
    }// box
    union {
        box {
            <0,2.5,4.5> <35,27,5.5>
            texture {
                MatSurface
                pigment {pig*10}
            }// texture
        }// box
        #declare i = 0;
        #while (i < 8)
            box {<1.4+i*0.4,21.25,4.49> <1.6+i*0.4,21.4,5.51>}
            #if (i < 5)
                box {<1.5+i*0.5,15.75,4.49> <1.92+i*0.5,15.9,5.51>}
            #end // if
            #if (i < 4)
                box {<6,15.9+i*0.45,4.49> <6.3,16.05+i*0.45,5.51>}
                box {<4.3+i*0.3,20.18,4.49> <4.4+i*0.3,20.25,5.51>}
            #end // if
            #if (i < 3)
                box {<3+i*0.6,17.25,4.49> <3.5+i*0.6,17.4,5.51>}
                box {<1.4+i*0.2,19.5-i*0.38,4.49> <1.7+i*0.2,19.65-i*0.38,5.51>}
                box {<1.9+i*0.2,19.5-i*0.38,4.49> <2.2+i*0.2,19.65-i*0.38,5.51>}
                box {<2.6+i*0.5,19.88+i*0.38,4.49> <3.2+i*0.5,19.95+i*0.38,5.51>}
                box {<1.4+i,17.93+i*0.38,4.49> <2+i,18.05+i*0.38,5.51>}
                box {<3+i*0.3,19.58,4.49> <3.1+i*0.3,19.65,5.51>}
            #end // if
            #if (i < 2)
                box {<1.4+i*0.3,18.26-i*1.28,4.49> <2+i*0.3,18.42-i*1.28,5.51>}
            #end // if
            #declare i = i+1;
        #end // while
        box {<4.3,15.9,4.49> <5.5,16.05,5.51>}
        box {<1.6,22,4.49> <6.3,22.2,5.51>}
        box {<1.4,20.13,4.49> <2.6,20.22,5.51>}
    }// union
    object {
        Chip(ShinySurface, VeryShinySurface)
        scale 0.2
        rotate <-90,0,90>
        translate <22.06,6.55,2.6>
    }
    texture {ShinySurface}
}// union

object {
    WallA
    translate <39,0.004,28>
}

object {
    WallA
    translate <9,0.004,128>
}

// Cylinder building
union {
    // base
    cylinder {
        <0,0,0> <0,0.3,0> 2.8
        texture {VeryShinySurface}
    }
    difference {
        cylinder {
            <0,0,0> <0,8,0> 2.5
        }
        cylinder {
            <0,-0.001,0> <0,8.01,0> 1.4
        }
        box {
            <-0.8,-0.001,-2.5> <0.8,8.01,-1.8>
        }
        box {
            <-0.8,-0.001,-2.5> <0.8,8.01,-1.8>
            rotate y*140
        }
    }// difference
    cylinder {
        <0,-0.001,0> <0,8.01,0> 1.4
        texture {ShinySurface}
    }
    intersection {
        cylinder {
            <0,0,0> <0,8.03,0> 2.5
        }
        prism {
            linear_sweep
            linear_spline
            0,8.02,
            4,
            <0,0>, <2.5,0.5>, <2,2.5>, <0,0>
        }
        texture {ShinySurface}
    }// intersection
    texture {
        MatSurface
        pigment {pig*20}
    }
    translate <8,0.004,48>
}// union

//west wall
/*
camera {
    location  <0, 12, 30>
    up        <0,  1,   0>
    look_at <-5, 10, 50>
}
*/
#declare WallB =
union {
    // base
    box {<0,0,0> <28,1,3>}
    difference {
        box {<0.5,1,1> <27.5,35,2>}
        // two grooves
        box {<8,0.99,0.99> <10,35.01,1.5>}
        box {<18,0.99,0.99> <20,35.01,1.5>}
        texture {
            MatSurface
            pigment {pig*20}
        }// texture
    }// difference
    // groove lining
    box {<7.7,1,0.6> <8,35.01,2.4>}
    box {<10,1,0.6> <10.3,35.01,2.4>}
    box {<17.7,1,0.6> <18,35.01,2.4>}
    box {<20,1,0.6> <20.3,35.01,2.4>}
    // left panel markings
    box {<4.5,1.4,0.99> <5.7,4.3,2.01>}
    box {<6,4.5,0.99> <7.2,6,2.01>}
    box {<1.5,5,0.99> <3.2,5.3,2.01>}
    box {<2,5.5,0.99> <4.7,5.8,2.01>}
    box {<4,7.5,0.99> <7,8.5,2.01>}
    box {<2,10,0.99> <5,10.5,2.01>}
    // center panel markings
    box {<11.5,1.4,0.99> <12.7,4.3,2.01>}
    box {<15,4,0.99> <16.2,5.7,2.01>}
    box {<10.5,5,0.99> <11.2,5.3,2.01>}
    box {<12,5.5,0.99> <12.7,5.8,2.01>}
    box {<11,7.5,0.99> <17,8.5,2.01>}
    box {<16,8.9,0.99> <17,9.1,2.01>}
    box {<12,9,0.99> <12.8,9.2,2.01>}
    box {<11.5,11.7,0.99> <12,15.5,2.01>}
    box {<15.5,11.7,0.99> <16.1,12,2.01>}
    box {<16.4,11.7,0.99> <16.6,12,2.01>}
    box {<16.4,12.7,0.99> <17,13,2.01>}
    box {<16.2,13.7,0.99> <16.8,14,2.01>}
    box {<16.2,15.2,0.99> <17,15.5,2.01>}
    box {<11.3,16.2,0.99> <12.3,16.6,2.01>}
    box {<13.5,17,0.99> <14.5,17.4,2.01>}
    box {<16.5,16.5,0.99> <17,16.7,2.01>}
    box {<10.5,17.6,0.99> <12.1,18,2.01>}
    box {<15.5,18,0.99> <17.1,18.4,2.01>}
    box {<10.5,19,0.99> <12.1,19.4,2.01>}
    box {<16,19.1,0.99> <16.4,19.3,2.01>}
    box {<15,20,0.99> <17,20.5,2.01>}
    box {<11,20.8,0.99> <17,21.5,2.01>}
    // right panel markings
    box {<20.3,1.3,0.99> <21,4,2.01>}
    box {<20.3,4,0.99> <21.7,5.5,2.01>}
    box {<22,1.3,0.99> <22.7,3.6,2.01>}
    box {<23,1.3,0.99> <24.3,5,2.01>}
    box {<25,1.8,0.99> <25.5,2.5,2.01>}
    box {<25,2.7,0.99> <25.5,2.9,2.01>}
    box {<26.2,2.3,0.99> <26.9,3.7,2.01>}
    box {<25.3,4.8,0.99> <26.2,5,2.01>}
    box {<20.3,6.1,0.99> <21.2,9.3,2.01>}
    box {<21.7,8.5,0.99> <22.7,9.3,2.01>}
    box {<22.2,6.5,0.99> <22.7,8,2.01>}
    box {<22.7,5.6,0.99> <23.7,6.7,2.01>}
    box {<23.2,6.7,0.99> <23.7,7.5,2.01>}
    box {<22.7,7.2,0.99> <23.2,7.5,2.01>}
    box {<24.1,5.6,0.99> <24.8,7,2.01>}
    box {<25.5,5.6,0.99> <26,7,2.01>}
    box {<26.3,5.4,0.99> <27,6.4,2.01>}
    box {<25.3,8,0.99> <25.5,10.5,2.01>}
    box {<20.6,10.6,0.99> <20.9,10.9,2.01>}
    box {<23.3,10.6,0.99> <23.6,11,2.01>}
    box {<21.7,11.8,0.99> <22.6,12.5,2.01>}
    box {<25.7,12,0.99> <25.9,12.7,2.01>}
    box {<21,13.3,0.99> <21.4,14.3,2.01>}
    box {<21.6,13.3,0.99> <21.9,13.8,2.01>}
    box {<23.3,14.2,0.99> <23.5,15.1,2.01>}
    box {<25,13.4,0.99> <25.3,14.5,2.01>}
    box {<23.2,16,0.99> <23.8,20.3,2.01>}
    box {<24,15.4,0.99> <24.4,15.9,2.01>}
    box {<24,16.4,0.99> <24.3,17.2,2.01>}
    box {<24.8,16.4,0.99> <25.1,17.2,2.01>}
    box {<25.8,16.3,0.99> <26.2,16.8,2.01>}
    box {<26,17,0.99> <26.4,17.3,2.01>}
    box {<26.2,18,0.99> <26.5,19,2.01>}
    box {<21.5,20.5,0.99> <26.2,21,2.01>}
    texture {ShinySurface}
}// union

object {
    WallB
    translate <-23,0.004,55>
}

object {
    WallB
    scale <1.8,0.9,1>
    rotate y*90
    translate <55,0.004,160>
}

//North building
/*
camera {
    location  <8, 12, 60>
    up        <0,  1,   0>
    look_at <13, 3, 70>
}
light_source {
    <10, 20, 60>
    colour rgb 1
}
*/
#declare curve =
mesh {
    smooth_triangle {
        <0,0.2,1.6>, y,
        <1,0.2,1.6>, y,
        <0,0.2,0.6>, <0,1,-0.4>
    }
    smooth_triangle {
        <1,0.2,1.6>, y,
        <0,0.2,0.6>, <0,1,-0.4>,
        <1,0.2,0.6>, <0,1,-0.4>
    }
    smooth_triangle {
        <0,0.2,0.6>, <0,1,-0.4>,
        <1,0.2,0.6>, <0,1,-0.4>,
        <0,0,0>, <0,1,-1>
    }
    smooth_triangle {
        <1,0.2,0.6>, <0,1,-0.4>,
        <0,0,0>, <0,1,-1>,
        <1,0,0>, <0,1,-1>
    }
    smooth_triangle {
        <0,0,0>, <0,1,-1>,
        <1,0,0>, <0,1,-1>,
        <0,-0.6,-0.2>, <0,0.4,-1>
    }
    smooth_triangle {
        <1,0,0>, <0,1,-1>,
        <0,-0.6,-0.2>, <0,0.4,-1>,
        <1,-0.6,-0.2>, <0,0.4,-1>
    }
    smooth_triangle {
        <0,-0.6,-0.2>, <0,0.4,-1>,
        <1,-0.6,-0.2>, <0,0.4,-1>,
        <0,-1.6,-0.2>, -z
    }
    smooth_triangle {
        <1,-0.6,-0.2>, <0,0.4,-1>,
        <0,-1.6,-0.2>, -z,
        <1,-1.6,-0.2>, -z
    }
}
#declare blockBuilding =    
union {
    box {
        <0,0,0> <8.5,4.5,8>
        texture {
            MatSurface
            pigment {pig*25}
        }// texture
    }// box
    box {
        <11,0,0> <19.5,4.5,8>
        texture {
            MatSurface
            pigment {pig*25}
        }// texture
    }// box
    box {
        <8.5,0,0.3> <11,4.2,7.7>
        texture {
            MatSurface
            pigment {pig*60}
            normal {
                gradient y
                poly_wave 0.5
                scale <1,0.8,1.5>
            }// normal
        }// texture
    }// box
    #declare i = 0.5;
    #while (i <= 7.3)
        object {
            curve
            scale <0.7,1,1>
            translate <i,4.6,-0.1>
        }// object
        mesh {
            triangle {<i,3,-0.3> <i+0.7,3,-0.3> <i,0,-0.3>}
            triangle {<i+0.7,0,-0.3> <i+0.7,3,-0.3> <i,0,-0.3>}
        }// mesh
        #declare i = i + 1.575;
    #end// while loop
    #declare i = 11.5;
    #while (i <= 18.3)
        object {
            curve
            scale <0.7,1,1>
            translate <i,4.6,-0.1>
        }// object
        #declare i = i + 1.575;
    #end// while loop
    texture {ShinySurface}
}// union

object {
    blockBuilding
    translate <10,0.004,70>
}// object

// south east building
union {
    difference {
        object {
            blockBuilding
            scale 0.9
        }// object
        object {
            Rock
            scale 0.8
            rotate y*40
            translate <15,4,1>
        }// object
    }// difference
    object {
        curve
        scale <0.7,1,1>
        rotate z*70
        rotate y*20
        translate <11,2,0>
    }// object
    texture {ShinySurface}
    translate <35,0.004,7>
}// union

#declare SmallWall =
union {
    box {
        <0.2,0.2,0> <1,9,25>
        texture {
            MatSurface
            pigment {pig*30}
        }
    }
    difference {
        box {
            <0,0,0.2> <1.2,9.2,24.8>
        }
        box {
            <-0.001,3.6,0.19> <0.3,5.6,24.81>
        }
    }
    #declare i = 0.4;
    #while (i <= 22.6)
        box {
            <0,4.2,i> <0.3,5,i+2>
        }
        #declare i = i + 3.17;
    #end
    texture {
        MatSurface
        pigment {pig*40}
    }
}

object {
    SmallWall
    translate <35,0.004,45>
}

object {
    SmallWall
    rotate y*180
    translate <40,0.004,65>
}

object {
    SmallWall
    translate <62,0.004,89>
}

object {
    SmallWall
    rotate y*180
    translate <67,0.004,109>
}

object {
    SmallWall
    translate <89,0.004,133>
}

object {
    SmallWall
    rotate y*180
    translate <94,0.004,153>
}

#declare trackData = array[6] {
    <65,0.001,200>, <65,0.001,83>, <67.5,0.001,81>,
    <62.5,0.001,79>, <65,0.001,77>, <65,0.001,50>
}
Track(trackData, 0.3, y)

// west domes
/*
camera {
    location <-20, 20, 25>
    up        <0,  1,   0>
    look_at <-12,0,35>
}
*/
// small dome
sphere {
    <-12,-1,44>, 2
    texture {
        ShinySurface
        pigment {pig*35}
    }
}
// tracks between small and larger domes
union {
    #declare trackData = array[8] {
        <-16.65,0.002,25.7>, <-16,0.002,27>, <-16,0.002,38>,
        <-15,0.002,42>, <-9,0.002,42>,
        <-8,0.002,38>, <-8,0.002,27>, <-7.35,0.002,25.7>
    }
    Track(trackData, 0.1, y)
    #declare trackData = array[8] {
        <-16.25,0.002,25.7>, <-15.6,0.002,27>, <-15.6,0.002,38>,
        <-14.6,0.002,41.9>, <-9.4,0.002,41.9>,
        <-8.4,0.002,38>, <-8.4,0.002,27>, <-7.75,0.002,25.7>
    }
    Track(trackData, 0.1, y)
    #declare trackData = array[12] {
        <-15.55,0.002,25.7>, <-14.9,0.002,27>, <-14.9,0.002,30>,
        <-14.3,0.002,34>, <-14.3,0.002,38>, <-13,0.002,41.8>,
        <-11,0.002,41.8>, <-9.7,0.002,38>, <-9.7,0.002,34>,
        <-9.1,0.002,30>, <-9.1,0.002,27>, <-8.45,0.002,25.7>
    }
    Track(trackData, 0.1, y)
    #declare trackData = array[10] {
        <-14.4,0.002,25.7>, <-14.4,0.002,31>,
        <-13.9,0.002,34>, <-13.9,0.002,38.7>, <-12.9,0.002,41.7>,
        <-11.1,0.002,41.7>, <-10.1,0.002,38.7>, <-10.1,0.002,34>,
        <-9.6,0.002,31>, <-9.6,0.002,25.7>
    }
    Track(trackData, 0.1, y)
    #declare trackData = array[8] {
        <-14,0.002,25.7>, <-14,0.002,31.8>,
        <-12.8,0.002,35>, <-12.8,0.002,41.6>,
        <-11.2,0.002,41.6>, <-11.2,0.002,35>,
        <-10,0.002,31.8>, <-10,0.002,25.7>
    }
    Track(trackData, 0.1, y)
    #declare trackData = array[8] {
        <-13.7,0.002,25.7>, <-13.7,0.002,31.8>,
        <-12.5,0.002,35>, <-12.5,0.002,41.5>,
        <-11.5,0.002,41.5>, <-11.5,0.002,35>,
        <-10.3,0.002,31.8>, <-10.3,0.002,25.7>
    }
    Track(trackData, 0.1, y)
    #declare trackData = array[6] {
        <-13.4,0.002,25.7>, <-12.2,0.002,28.9>, <-12.2,0.002,41.4>,
        <-11.8,0.002,41.4>, <-11.8,0.002,28.9>, <-10.6,0.002,25.7>
    }
    Track(trackData, 0.1, y)
    texture {MatSurface}
}
union {
    // larger dome
    sphere {
        <0,-2,0>, 4.5
        texture {ShinySurface}
    }
    mesh {
        triangle {<-4.7,0.001,-4.7> <4.7,0.002,-4.7> <4.7,0.001,4.7>}
        triangle {<-4.7,0.001,-4.7> <-4.7,0.002,4.7> <4.7,0.001,4.7>}
        texture {VeryShinySurface}
    }
    // radial tracks coming from dome
    #declare a = -4.2;
    #declare b = -45;
    #while (b < 45)
        #declare trackData = array[3] {<0,0.003,0>, <a,0.003,-4.2>, <4.7*tan(radians(b)),0.003,-4.7>}
        Track(trackData, 0.1, y)
        #declare trackData = array[3] {<0,0.003,0>, <4.2,0.003,a>, <4.7,0.003,4.7*tan(radians(b))>}
        Track(trackData, 0.1, y)
        #declare trackData = array[3] {<0,0.003,0>, <-a,0.003,4.2>, <-4.7*tan(radians(b)),0.003,4.7>}
        Track(trackData, 0.1, y)
        #declare trackData = array[3] {<0,0.003,0>, <-4.2,0.003,-a>, <-4.7,0.003,-4.7*tan(radians(b))>}
        Track(trackData, 0.1, y)
        #declare a = a+ 0.7;
        #declare b = b + 7.5;
    #end
    texture {MatSurface}
    translate <-12,0,21>
}

// north dome
/*
camera {
    location <30, 35, 50>
    up        <0,  1,   0>
    look_at <37,2,93>
}
*/
difference {
    union {
        sphere {
            <0,0,0> 20
            texture {
                ShinySurface
                pigment {pig*35}
            }// texture
        }// sphere
        sphere {
            <0,0,0> 18.5
        }// sphere
    }// union
    difference {
        cylinder {
            <3,19,0> <3,20.1,0> 3
        }// cylinder
        cylinder {
            <3.7,18.99,0> <3.7,20.15,0> 1.5
        }// cylinder
    }// difference
    clipped_by {
        plane {-y, 0.001}
    }// clipped_by
    texture {ShinySurface}
    rotate y*30
    translate <37,-17.5,98>
}// difference
mesh {
    triangle {<24,0.001,113> <50,0.001,113> <50,0.001,92>}
    triangle {<24,0.001,113> <24,0.001,92> <50,0.001,92>}
    triangle {<24,0.001,92> <31,0.001,92> <31,0.001,85>}
    triangle {<31,0.001,85> <31,0.001,92> <50,0.001,92>}
    triangle {<31,0.001,85> <50,0.001,85> <50,0.001,92>}
    texture {
        MatSurface
        pigment {pig*15}
    }// texture
}// mesh

// south west shelter
cylinder {
    <-25,-0.3,0.2> <-17,-0.3,0.2> 1.5
    texture {
        ShinySurface
        normal {
            gradient x
            triangle_wave
        }// normal
    }// texture
}// cylinder

// broken cylinder
/*
camera {
    location <0,10,-10>
    up        <0,  1,   0>
    look_at <10,0,0>
}// camera
*/
union {
    difference {
        cylinder {
            <0,0,0> <0,4,0> 1
        }
        object {
            Rock
            scale 0.5
            translate y*4
        }
    }// difference
    difference {
        cylinder {<0,-1,0> <0,4,0> 1}
        object {
            Rock
            scale 0.5
            translate y*4
        }// object
        object {
            Rock
            scale 0.5
            translate y*-2
        }// object
        rotate y*100
        rotate x*70
        translate <0.2,2,-2>
    }// difference
    difference {
        cylinder { <0,0,0> <0,4,0> 1}
        object {
            Rock
            scale 0.5
            translate y*4
        }// object
        rotate y*-50
        rotate x*80
        rotate y*10
        translate <-0.1,1,-3.7>
    }// difference
    texture {ShinySurface}
    rotate y*-15
    translate <10,0,-3>
}

// small complex
union {
    box {
        <0,0,0> <8,0.8,7>
        texture {
            MatSurface
            pigment {pig*30}
        }// texture
    }// box
    box {
        <8,0,0> <12,0.8,0.5>
        texture {
            MatSurface
            pigment {pig*60}
        }// texture
    }// box
    difference {
        box {<12,0,-8> <16,1.1,0.5>}
        object {
            Rock
            translate <13,3,-11>
        }// object
        texture {ShinySurface}
    }// difference
    translate <14.5,0.004,0>
}// union

// reflected building
box {
    <0,0,0> <12,2,6>
    texture {VeryShinySurface}
    translate <60,0.004,12>
}// box

// central courtyard
/*
camera {
    location <10, 25, 30>
    up        <0,  1,   0>
    look_at <17,0,50>
}// camera
*/
union {
    mesh {
        triangle {<14.3,0.001,40> <35,0.001,40> <35,0.001,80>}
        triangle {<14.3,0.001,40> <14.3,0.001,80> <35,0.001,80>}
        texture {
            MatSurface
            pigment {pig*50}
        }// texture
    }// mesh
    mesh {
        triangle {<14.3,0.002,40> <14.3,0.002,41> <35,0.002,41>}
        triangle {<14.3,0.002,40> <35,0.002,40> <35,0.002,41>}
        triangle {<14.3,0.002,41> <14.3,0.002,44> <24,0.002,44>}
        triangle {<14.3,0.002,41> <24,0.002,41> <24,0.002,44>}
        triangle {<14.3,0.002,44> <27,0.002,54> <27,0.002,44>}
        triangle {<23,0.002,48> <26,0.002,60> <31,0.002,48>}
        triangle {<21,0.002,51> <26,0.002,60> <26,0.002,51>}
        triangle {<21,0.002,51> <21,0.002,60> <26,0.002,60>}
        triangle {<21,0.002,60> <22.5,0.002,62.5> <24,0.002,60>}
    }// mesh
    #declare trackData = array[2] {<10.5,0.001,48> <14.3,0.001,48>}
    Track(trackData, 0.3, y)
    #declare trackData = array[5] {
        <10.5,0.001,48> <13,0.001,45.5> <13,0.001,39>
        <16,0.001,39> <16,0.001,40>
    }// array
    Track(trackData, 0.3, y)
    #declare trackData = array[5] {
        <8,0.001,45.5> <10.5,0.001,43> <10.5,0.001,36.5>
        <16,0.001,36.5> <16,0.001,28>
    }// array
    Track(trackData, 0.3, y)
    #declare trackData = array[3] {
        <14.3,0.002,56> <17.3,0.002,53> <21,0.002,53>
    }// array
    Track(trackData, 0.3, y)
    #declare trackData = array[3] {
        <17.45,0.002,70> <17.45,0.002,53.4> <21,0.002,53.4>
    }// array
    Track(trackData, 0.3, y)
    #declare trackData = array[4] {
        <18.5,0.002,70> <18.5,0.002,64> <20.5,0.002,62> <22.5,0.002,62>
    }// array
    Track(trackData, 0.3, y)
    #declare trackData = array[4] {
        <26,0.002,59.9> <31,0.002,59.9> <31,0.002,56> <30.3,0.002,55.3>
    }// array
    Track(trackData, 0.3, y)
    disc {<30.3,0.002,55.3> y 0.25}
    #declare trackData = array[4] {
        <27,0.002,45> <29,0.002,43> <31,0.002,43> <31,0.002,40>
    }// array
    Track(trackData, 0.3, y)
    #declare trackData = array[5] {
        <27,0.002,47> <30,0.002,44> <32,0.002,44>
        <32,0.002,42.5> <34.5,0.002,40>
    }// array
    Track(trackData, 0.3, y)
    #declare trackData = array[4] {
        <29,0.002,48> <29,0.002,46> <33,0.002,46> <35,0.002,44>
    }// array
    Track(trackData, 0.3, y)
    texture {VeryShinySurface}
}// union

// south courtyard
/*
camera {
    location <10, 20, 16>
    up        <0,  1,   0>
    look_at <12,0,20>
}
*/
mesh {
    triangle {<13,0.002,7> <12,0.002,21> <26,0.002,21>}
    triangle {<13,0.002,7> <26,0.002,7> <26,0.002,21>}
    triangle {<6.5,0.002,9.5> <6.5,0.002,28> <13,0.002,28>}
    triangle {<6.5,0.002,9.5> <13,0.002,9.5> <13,0.002,28>}
    texture {VeryShinySurface}
}
difference {
    box {<11,-0.001,7> <26,0.003,19>}
    box {<16,0,13> <24.5,0.004,17>}
    box {<23.5,0,16.99> <26.01,0.004,19.01>}
    box {<18.5,0,6.99> <19.5,0.004,14>}
    box {<22.5,0,10.5> <24.5,0.004,14>}
    box {<10.99,0,16> <18,0.004,17>}
    box {<22.5,0,16> <22.8,0.004,19.01>}
    box {<15,0,15> <17.5,0.004,16.5>}
    box {
        <0,0,0> <1.6,0.004,5>
        rotate y*40
        translate <15.75,0,17>
    }
    box {
        <0,0,0> <1.5,0.004,2>
        rotate y*45
        translate <18.5,0,13>
    }
    texture {
        MatSurface
        pigment {pig*50}
    }
}
union {
    disc {<12.5,0.004,8.5> y 0.2 }
    #declare trackArray = array[5] {
        <12.5,0.004,8.5>, <14,0.004,10>, <17.5,0.004,10>, <18.5,0.0031,11>, <18.7,0.002,10.8>
    }
    Track(trackArray, 0.2, y)
    disc {<12.5,0.004,11.5> y 0.2 }
    #declare trackArray = array[4] {
        <12.5,0.004,11.5>, <17.5,0.004,11.5>, <18.5,0.0031,12.5>, <18.7,0.002,12.3>
    }
    Track(trackArray, 0.2, y)
    disc {<20.5,0.004,10.5> y 0.2 }
    #declare trackArray = array[3] {
        <20.5,0.004,10.5>, <21.5,0.004,11.5>, <22.5,0.0031,11.5>
    }
    Track(trackArray, 0.2, y)
    texture {VeryShinySurface}
}
union {
    mesh {
        triangle {<6.5,0.003,11> <6.5,0.003,12.5> <8,0.003,12.5>}
        triangle {<6.5,0.003,11> <8,0.003,11> <8,0.003,12.5>}
        triangle {<6.5,0.003,12.5> <6.5,0.003,14> <9.5,0.003,14>}
        triangle {<6.5,0.003,12.5> <9.5,0.003,12.5> <9.5,0.003,14>}
        triangle {<6.5,0.003,14> <6.5,0.003,27> <11,0.003,27>}
        triangle {<6.5,0.003,14> <11,0.003,14> <11,0.003,27>}
        triangle {<11,0.003,19> <11,0.003,27> <13,0.003,27>}
        triangle {<11,0.003,19> <13,0.003,19> <13,0.003,27>}
        triangle {<6.5,0.003,27> <7.5,0.003,27> <7.5,0.003,28>}
        triangle {<7.5,0.003,27> <7.5,0.003,28> <13,0.003,28>}
        triangle {<7.5,0.003,27> <13,0.003,27> <13,0.003,28>}
        texture {
            MatSurface
            pigment {pig*20}
        }
    }
    #declare trackArray = array[4] {
        <13,0.004,27.8>, <7.6,0.004,27.8>, <6.7,0.004,26.9>, <6.7,0.0031,11>
    }
    Track(trackArray, 0.2, y)
    #declare trackArray = array[5] {
        <13,0.004,27.5>, <11,0.004,27.5>, <9,0.004,25>, <7,0.004,25>, <7,0.0031,11>
    }
    Track(trackArray, 0.2, y)
    #declare trackArray = array[8] {
        <13,0.004,27.2>, <11.5,0.004,27.2>, <9.5,0.004,24.7>,
        <7.8,0.004,24.7>, <7.3,0.004,24>, <7.3,0.004,12.5>,
        <7.5,0.004,12.2>, <7.5,0.0031,11>
    }
    Track(trackArray, 0.2, y)
    #declare trackArray = array[7] {
        <13,0.004,26.5>, <11.3,0.004,26.5>, <9,0.004,23.625>,
        <7.6,0.004,23.625>, <7.6,0.004,19>, <7.8,0.004,18.7>,
        <7.8,0.0031,11>
    }
    Track(trackArray, 0.2, y)
    #declare trackArray = array[8] {
        <13,0.004,26.2>, <11.5,0.004,26.2>, <9.2,0.004,23.33>,
        <9.2,0.004,22>, <8.1,0.004,20.75>, <8.1,0.004,15>,
        <8.2,0.004,14.8>, <8.2,0.0031,12.5>
    }
    Track(trackArray, 0.2, y)
    #declare trackArray = array[10] {
        <13,0.004,25.9>, <12.7,0.004,25.9>, <11.7,0.004,24.6>,
        <10.7,0.004,24.6>, <9.5,0.004,23.1>, <9.5,0.004,18.7>,
        <9.8,0.004,18.7>, <9.8,0.004,17>, <8.8,0.004,15.75>, <8.8,0.0031,12.5>
    }
    Track(trackArray, 0.2, y)
    #declare trackArray = array[8] {
        <13,0.004,24.3>, <11,0.004,24.3>, <9.8,0.004,22.8>,
        <9.8,0.004,19>, <10.1,0.004,19>, <10.1,0.004,15>,
        <9.3,0.004,14>, <9.3,0.0031,12.5>
    }
    Track(trackArray, 0.2, y)
    #declare trackArray = array[6] {
        <13,0.004,24>, <11.3,0.004,24>, <10.1,0.004,22.5>,
        <10.1,0.004,19.3>, <10.4,0.004,19.3>, <10.4,0.004,14>
    }
    Track(trackArray, 0.2, y)
    #declare trackArray = array[6] {
        <13,0.004,23.5>, <12.4,0.004,23.5>, <10.7,0.004,21.5>,
        <10.7,0.004,17>, <10.8,0.004,16.8>, <10.8,0.004,14>
    }
    Track(trackArray, 0.2, y)
    texture {VeryShinySurface}
}

// west road details
/*
camera {
    location <0, 35, -1>
    up        <0,  1,   0>
    look_at <2,0,20>
}
*/
mesh {
    triangle {<1,0.001,7> <5.4,0.001,7> <5.4,0.001,27>}
    triangle {<1,0.001,7> <1,0.001,27> <5.4,0.001,27>}
    triangle {<-4.4,0.001,9.5> <0,0.001,9.5> <0,0.001,25>}
    triangle {<-4.4,0.001,9.5> <-4.4,0.001,25> <0,0.001,25>}
    triangle {<-6,0.001,11> <-6,0.001,25> <-4.4,0.001,27>}
    triangle {<-6,0.001,11> <-4.4,0.001,9.5> <-4.4,0.001,27>}
    texture {
        MatSurface
        pigment {pig*50}
    }
}
// spiral track
#declare spiral = array[16] {
    <-1,0.002,17.8>, <-1,0.002,17.4>, <-4.2,0.002,17.4>,
    <-4.2,0.002,13.8>, <-0.6,0.002,13.8>, <-0.6,0.002,17>,
    <-3.8,0.002,17>, <-3.8,0.002,14.2>, <-1,0.002,14.2>,
    <-1,0.002,16.6>, <-3.4,0.002,16.6>, <-3.4,0.002,14.6>,
    <-1.4,0.002,14.6>, <-1.4,0.002,16.2> <-3,0.002,16.2>,
    <-3,0.002,15.9>
}
object {
    Track(spiral,0.2,y)
    texture {MatSurface}
}
box {
    <-3.1,0.002,14.9> <-1.7,0.3,15.9>
    texture {
        MatSurface
        pigment {pig*30}
    }
}
#declare resistor = 
union {
    cylinder {
        x*-0.6 x*0.6 0.15
        texture {
            MatSurface
            pigment {pig*20}
        }
    }
    sphere {x*-0.6 0.15}
    sphere {x*0.6 0.15}
    texture {ShinySurface}
}
union {
    #declare trackData = array[3] {
        <7.95,0.003,11>, <7.95,0.002,6.5>, <7.5,0.002,4.95>
    }
    Track(trackData,0.1,y)
    #declare trackData = array[3] {
        <9.45,0.003,12.5>, <9.45,0.002,3>, <7,0.002,-1>
    }
    Track(trackData,0.1,y)
    #declare trackData = array[5] {
        <10.95,0.003,14>, <10.95,0.002,7>, <10.3,0.002,6>,
        <10.3,0.002,3>, <7,0.002,-2>
    }
    Track(trackData,0.1,y)
    #declare trackData = array[15] {
        <7,0.002,0>, <7.5,0.002,1>, <7.5,0.002,4.95>,
        <5.1,0.002,9.5>, <-4.4,0.002,9.5>, <-6,0.002,11>,
        <-6,0.002,25>, <-2,0.002,30>, <2.6,0.002,30>,
        <3,0.15,30>, <4.2,0.15,30>, <4.6,0.002,30>,
        <9.5,0.002,39>, <9.5,0.002,42>, <14,0.002,48>
    }
    Track(trackData,0.1,y)
    disc {<14,0.002,48> y 0.2}
    object {
        resistor
        translate <3.6,0.15,30>
    }
    #declare trackData = array[14] {
        <5.1,0.002,7>, <-4.4,0.002,7>, <-6.5,0.002,8.9>,
        <-6.5,0.002,27>, <-2,0.002,32.6>, <2.2,0.002,32.6>,
        <2.6,0.15,32.6>, <3.8,0.15,32.6>, <4.2,0.002,32.6>,
        <5,0.002,32.6>, <9,0.002,39.9>, <9,0.002,42.5>,
        <14,0.002,49.3>, <14,0.002,53>
    }
    Track(trackData,0.1,y)
    disc {<14,0.002,53> y 0.2}
    object {
        resistor
        translate <3.2,0.15,32.6>
    }
    #declare trackData = array[20] {
        <5.1,0.002,17.8>, <5.1,0.002,7>, <7,0.002,3.4>,
        <7,0.002,-3.15>, <5.4,0.003,-4.5>, <-7.3,0.004,-4.5>,
        <-7.3,0.004,-3>, <-7.3,0.15,-2.6>, <-7.3,0.15,-1.4>,
        <-7.3,0.004,-1>, <-7.3,0.004,28.6>, <-2,0.002,35.2>,
        <1.8,0.002,35.2>, <2.2,0.15,35.2>, <3.4,0.15,35.2>,
        <3.8,0.002,35.2>, <5.4,0.002,35.2>, <8.5,0.002,40.8>,
        <8.5,0.002,42.5>, <6.5,0.002,45>
    }
    Track(trackData,0.1,y)
    disc {<6.5,0.002,45> y 0.2}
    object {
        resistor
        translate <2.8,0.15,35.2>
    }
    object {
        resistor
        rotate y*90
        translate <-7.3,0.15,-2>
    }
    texture {MatSurface}
}

// southwest area
/*
camera {
    location <-10, 25, 3>
    up        <0,  1,  0>
    look_at <-10,0,8>
}// camera
*/
union {    
    mesh {
        triangle {<-25.5,0.001,-1.5> <-25.5,0.001,20> <-7.3,0.001,20>}
        triangle {<-25.5,0.001,-1.5> <-7.3,0.001,-1.5> <-7.3,0.001,20>}
        texture {
            MatSurface
            pigment {pig*25}
        }// texture
    }// mesh
    
    #declare trackData = array[5] {
        <-7.3,0.002,12> <-7.7,0.002,12> <-7.7,0.002,8>
        <-7.5,0.002,7.8> <-7.5,0.002,5>
    }// array
    Track(trackData,0.2,y)
    
    #declare trackData = array[5] {
        <-7.3,0.002,12.3> <-8.2,0.002,12.3> <-8.2,0.002,8>
        <-7.8,0.002,7.6> <-7.8,0.002,5>
    }// array
    Track(trackData,0.2,y)
    
    #declare trackData = array[5] {
        <-7.3,0.002,12.6> <-8.5,0.002,12.6> <-8.5,0.002,8>
        <-9.3,0.002,7.2> <-9.3,0.002,5>
    }// array
    Track(trackData,0.2,y)
    
    #declare trackData = array[5] {
        <-7.3,0.002,16.3> <-9,0.002,14.6> <-9,0.002,8>
        <-9.8,0.002,7.2> <-9.8,0.002,5>
    }// array
    Track(trackData,0.2,y)
    
    #declare trackData = array[5] {
        <-7.7,0.002,16.3> <-9.3,0.002,14.7> <-9.3,0.002,10>
        <-10.5,0.002,8.8> <-10.5,0.002,5>
    }// array
    Track(trackData,0.2,y)
    
    #declare trackData = array[4] {
        <-9.7,0.002,16.3> <-9.7,0.002,10.2>
        <-11.1,0.002,8.8> <-11.1,0.002,5>
    }// array
    Track(trackData,0.2,y)
    
    #declare trackData = array[6] {
        <-10.1,0.002,16.3> <-10.1,0.002,10.4> <-10.8,0.002,9.7>
        <-11.5,0.002,9.7> <-11.5,0.002,5.5> <-12,0.002,5>
    }// array
    Track(trackData,0.2,y)
    
    #declare trackData = array[5] {
        <-11.1,0.002,16.3> <-11.1,0.002,14.7> <-11.8,0.002,14>
        <-11.8,0.002,5.6> <-12.4,0.002,5>
    }// array
    Track(trackData,0.2,y)
    
    #declare trackData = array[2] {<-12.7,0.002,16.3> <-12.7,0.002,5>}
    Track(trackData,0.2,y)
    
    #declare trackData = array[7] {
        <-13,0.002,16.3> <-13,0.002,13> <-13.5,0.002,12.5>
        <-13.9,0.002,12.9> <-13.9,0.002,14.4> <-13.5,0.002,14.8>
        <-13.5,0.002,16.3>
    }// array
    Track(trackData,0.2,y)
    
    #declare trackData = array[4] {
        <-14.2,0.002,16.3> <-14.2,0.002,12.8> <-13,0.002,11.6>
        <-13,0.002,5>
    }// array
    Track(trackData,0.2,y)
    
    #declare trackData = array[6] {
        <-14.5,0.002,16.3> <-14.5,0.002,13.2> <-15,0.002,12.7>
        <-15,0.002,12.2> <-13.4,0.002,10.6> <-13.4,0.002,5>
    }// array
    Track(trackData,0.2,y)
    
    #declare trackData = array[6] {
        <-14.8,0.002,16.3> <-14.8,0.002,14.4> <-15.3,0.002,13.9>
        <-15.3,0.002,12.1> <-13.7,0.002,10.5> <-13.7,0.002,5>
    }// array
    Track(trackData,0.2,y)
    
    #declare trackData = array[6] {
        <-16,0.002,16.3> <-16,0.002,14.4> <-15.6,0.002,13.9>
        <-15.6,0.002,12> <-14.1,0.002,10.5> <-14.1,0.002,5>
    }// array
    Track(trackData,0.2,y)
    
    #declare trackData = array[6] {
        <-16.3,0.002,16.3> <-16.3,0.002,14.4> <-15.9,0.002,13.8>
        <-15.9,0.002,11.9> <-15.3,0.002,11.3> <-15.3,0.002,5>
    }// array
    Track(trackData,0.2,y)
    
    #declare trackData = array[4] {
        <-16.6,0.002,16.3> <-16.6,0.002,14.3>
        <-16.4,0.002,14.1> <-16.4,0.002,5>
    }// array
    Track(trackData,0.2,y)
    
    #declare trackData = array[6] {
        <-16.7,0.002,17.2> <-17.6,0.002,17.2> <-17.6,0.002,11>
        <-17,0.002,10.4> <-17,0.002,5.5> <-16.5,0.002,5>
    }// array
    Track(trackData,0.2,y)
    
    #declare trackData = array[4] {
        <-16.7,0.002,17.5> <-17.9,0.002,17.5> <-17.9,0.002,4.8>
        <-16.5,0.002,4.8>
    }// array
    Track(trackData,0.2,y)
    
    #declare trackData = array[5] {
        <-16.7,0.002,19> <-18.9,0.002,16.8> <-18.9,0.002,5.5>
        <-17.9,0.002,4.5> <-16.5,0.002,4.5>
    }// array
    Track(trackData,0.2,y)
    
    #declare trackData = array[9] {
        <-16.7,0.002,19.5> <-19.2,0.002,19.5> <-19.2,0.002,16.5>
        <-19.7,0.002,16> <-19.7,0.002,11> <-19.4,0.002,10.7>
        <-19.4,0.002,5.2> <-18.4,0.002,4.2> <-16.5,0.002,4.2>
    }// array
    Track(trackData,0.2,y)
    
    texture {VeryShinySurface}
}// union

union {
    mesh {
        triangle {<-16.5,0.002,-5> <-16.5,0.002,5> <-6.55,0.002,5>}
        triangle {<-16.5,0.002,-5> <-6.55,0.002,-5> <-6.55,0.002,5>}
        texture {
            MatSurface
            pigment {pig*50}
        }// texture
    }// mesh
    
    #declare trackData = array[4] {
        <-16.5,0.003,-4.6> <-16.1,0.003,-4.6> <-16.1,0.003,-3.5>
        <-15,0.003,-4.6>
    }
    Track(trackData,0.1,y)
    disc {<-15,0.003,-4.6> y 0.15}
    
    #declare trackData = array[6] {
        <-16.5,0.003,0> <-16.1,0.003,-0.4> <-16.1,0.003,-3>
        <-14.5,0.003,-4.6> <-10.1,0.003,-4.6> <-9.5,0.003,-4>
    }
    Track(trackData,0.1,y)
    disc {<-9.5,0.003,-4> y 0.15}
    
    #declare trackData = array[3] {
        <-16.1,0.003,4.5> <-16.1,0.003,0.5> <-13.6,0.003,-2>
    }
    Track(trackData,0.1,y)
    disc {<-16.1,0.003,4.5> y 0.15}
    disc {<-13.6,0.003,-2> y 0.15}
    
    #declare trackData = array[5] {
        <-15.6,0.003,-1.6> <-14.6,0.003,-2.6> <-12.5,0.003,-2.6>
        <-12.5,0.003,-2> <-14.4,0.003,-0.1>
    }
    Track(trackData,0.1,y)
    disc {<-15.6,0.003,-1.6> y 0.15}
    disc {<-14.4,0.003,-0.1> y 0.15}
    
    #declare trackData = array[4] {
        <-11,0.003,4.5> <-15.2,0.003,4.5> <-15.2,0.003,1.1>
        <-11.5,0.003,-2.6>
    }
    Track(trackData,0.1,y)
    disc {<-11,0.003,4.5> y 0.15}
    disc {<-11.5,0.003,-2.6> y 0.15}
    
    #declare trackData = array[4] {
        <-11.5,0.003,4> <-14.2,0.003,4> <-14.2,0.003,1.1>
        <-13.2,0.003,0.1>
    }
    Track(trackData,0.1,y)
    disc {<-11.5,0.003,4> y 0.15}
    disc {<-13.2,0.003,0.1> y 0.15}
    
    #declare trackData = array[5] {
        <-8.2,0.003,5> <-9,0.003,4.2> <-10.7,0.003,4.2>
        <-10.7,0.003,1.9> <-13,0.003,-0.4>
    }
    Track(trackData,0.1,y)
    disc {<-13,0.003,-0.4> y 0.15}
    
    #declare trackData = array[7] {
        <-7.9,0.003,5> <-7.9,0.003,1.4> <-10,0.003,1.4>
        <-11,0.003,0.4> <-11,0.003,-3> <-11.8,0.003,-3.8>
        <-14.6,0.003,-3.8>
    }
    Track(trackData,0.1,y)
    disc {<-14.6,0.003,-3.8> y 0.15}
    
    #declare trackData = array[6] {
        <-8.9,0.003,1> <-10,0.003,1> <-10.7,0.003,0.3>
        <-10.7,0.003,-3.1> <-11.8,0.003,-4.2> <-12.6,0.003,-4.2>
    }
    Track(trackData,0.1,y)
    disc {<-8.9,0.003,1> y 0.15}
    disc {<-12.6,0.003,-4.2> y 0.15}
    
    #declare trackData = array[3] {
        <-9.4,0.003,0.6> <-10.2,0.003,-0.2> <-10.2,0.003,-3.5>
    }
    Track(trackData,0.1,y)
    disc {<-9.4,0.003,0.6> y 0.15}
    disc {<-10.2,0.003,-3.5> y 0.15}
    
    #declare trackData = array[6] {
        <-8.9,0.003,0.6> <-8.9,0.003,-0.6> <-9.5,0.003,-1.2>
        <-9.5,0.003,-3.5> <-10.2,0.003,-4.2> <-11,0.003,-4.2>
    }
    Track(trackData,0.1,y)
    disc {<-8.9,0.003,0.6> y 0.15}
    disc {<-11,0.003,-4.2> y 0.15}
    
    #declare trackData = array[3] {
        <-8.5,0.003,-1> <-8.9,0.003,-1.4> <-8.9,0.003,-4.6>
    }
    Track(trackData,0.1,y)
    disc {<-8.9,0.003,-4.6> y 0.15}
    texture {MatSurface}
}
mesh {
    triangle {<-8.5,0.003,-4> <-8.5,0.003,1> <-6.55,0.003,1>}
    triangle {<-8.5,0.003,-4> <-6.55,0.003,-4> <-6.55,0.003,1>}
    triangle {<-8,0.003,-5> <-8,0.003,-3> <-6,0.003,-3>}
    triangle {<-8,0.003,-5> <-6,0.003,-5> <-6,0.003,-3>}
    texture {VeryShinySurface}
}


// forest
/*
camera {
    location <10, 155, -90>
    up        <0,  1,   0>
    look_at <10,0,-80>
}
*/
/*
camera {
    location <10, 1, -100>
    up        <0,  1,   0>
    look_at <10,1,-70>
}
*/
#if (detail = 1)
    #declare MyTree =
    union {
        object {
            TreeTrunk
            pigment {rgb <0.4, 0.2, 0.05>}
            normal {
              bozo 0.6
              scale <0.1, 0.1, 0.5>
            }
        }
        object {
            TreeFoliage
            texture {Leaves}
        }
        object {
            TreeFoliage
            translate y*-12
            scale 0.85
            translate y*12
            texture {
                Leaves
                finish {ambient 0.2}
            }
        }
        object {
            TreeFoliage
            translate y*-12
            scale 0.7
            translate y*12
            texture {
                Leaves
                finish {ambient 0.3}
            }
        }
        object {
            TreeFoliage
            translate y*-12
            scale 0.65
            translate y*12
            texture {
                Leaves
                finish {ambient 0.4}
            }
        }
        bounded_by {sphere {<-0.3,9,0> 11.5}}
        scale 0.2
    }
#else
    #declare MyTree =
    union {
        cylinder {
            <0,-1,0> <0,10,0> 2.5
            pigment {rgb <0.4, 0.2, 0.05>}
        
        }
        sphere {
            <0,0,0> 1
            scale <11,4.6,7.2>
            translate y*12.5
            pigment {rgb <0.2, 0.6, 0.10>}
        }
        scale 0.2
    }
#end

#declare randSeed = seed(445);
Scatter2D(MyTree, <-25,-55>, <22,-32>, 60, -1, randSeed)

// the rest of the trees are placed for the reflection in the east wall
// forest gets denser further from the cliff
#if (detail=1)
    #declare randSeed = seed(654);
    Scatter2D(MyTree, <120,-110>, <170,-65>, 120, -2, randSeed)
    #declare randSeed = seed(765);
    Scatter2D(MyTree, <100,-70>, <150,-50>, 60, -1, randSeed)
    #declare randSeed = seed(876);
    Scatter2D(MyTree, <80,-55>, <150,-30>, 40, 1, randSeed)
#end // if statement

