/* This file contains objects created by Toby Anderson

StreetLight
TreeTrunk
TreeFoliage
Tree
Hat
Rock
RockWall
SmoothRock
SmoothWall
MagnifyingGlass

*/

#include "textures.inc"
#include "functions.inc"
#include "glass.inc"

#ifdef(View_POV_Include_Stack)
    #debug "including my_objects.inc\n"
#end

#declare StreetLight =
union {

    // bottom
    cylinder {
        <0,0,0>,
        <0,5,0>,
        1
    }

    cone {
        <0,5,0>, 1
        <0,7,0>, 0.5
    }

    // pole
    sphere_sweep {
        b_spline
        6
        <0,-10,0>, 0.5
        <0,7,0>, 0.5
        <0,15,0>, 0.5
        <0.2,22,0>, 0.3
        <-3,22,0>, 0.2
        <-7,22,0>, 0.2
    }
  
    // bulb case
    difference {
        superellipsoid {
            <0.5,0.5>
            scale <1.7,0.6,0.8>
            translate <-5,22,0>
        }
        box {
            <-7.2, 21, -0.8>,
            <-3.3, 22, 0.8>
        }
    }
    
    // glass cover and light
    light_source {
        <-5, 22, 0>
        colour rgb 1
        spotlight
        radius 55
        falloff 80
        tightness 5
        point_at <-5.2, 0, 0>
        looks_like {
            difference {
                superellipsoid {
                    <0.4,0.3>
                    scale <1.6,0.8,0.7>
                }
                superellipsoid {
                    <0.4,0.3>
                    scale <1.45,0.65,0.55>
                }
                box {
                    <-2.2, 0, -0.8>,
                    <2.3, 1, 0.8>
                }
                material {M_NB_Glass}
                finish {ambient 0.7}
            }
        }
    }

    texture{ Chrome_Texture }
}

#declare TreeTrunk =
blob {
    threshold 0.65                                                 
    cylinder { <0, 0, 0> <-0.2, 5, 0>, 2.5, 1 }                       //trunk
    cylinder { <-0.2, 5, 0> <-0.6, 8.5, 0>, 1.5, 1 }
    cylinder { <-0.6, 8.5, 0> <-0.8, 10.5, 2> 0.8, 1 }
    cylinder { <-0.6, 8.5, 0> <-0.2, 10.7, 0> 1, 1 }
    cylinder { <-0.6, 8.5, 0> <-1.2, 10.7, -3> 0.5, 1 }
    cylinder { <3,   -0.5, -1.4> <0, 0.8, 0   > 1, 1 }              // roots
    cylinder { <2.3, -0.4, -1.5> <0, 1,   0.2 > 1, 1 rotate 30*y}
    cylinder { <3.5, -0.6, -1.5> <0, 0.5, -0.1> 1, 1 rotate 70*y}
    cylinder { <2.8, -0.5, -1.6> <0, 1.3, 0   > 1, 1 rotate 130*y}
    cylinder { <5.4, -0.5, -1.5> <0, 0.9, 0.1 > 1, 1 rotate 175*y}
    cylinder { <2.6, -0.7, -1.5> <0, 0.6, 0   > 1, 1 rotate 200*y}
    cylinder { <4.2, -0.5, -1.4> <0, 0.8, -0.2> 1, 1 rotate 250*y}
    cylinder { <2.7, -0.3, -1.5> <0, 1.2, 0   > 1, 1 rotate 285*y}
    cylinder { <2.5, -0.5, -1.5> <0, 0.7, 0   > 1, 1 rotate 325*y}
    cylinder { <-0.2, 5, 0> <3, 7, -1> 1.3, 1 }                          // branches
    cylinder { <3, 7, -1> <4, 9, 1> 1, 1 }
    cylinder { <3, 7, -1> <5.5, 9.5, -2.7> 1, 1 }
    cylinder { <-0.4, 6.7, 0> <-3.5, 9, -0.5> 0.7, 1 }
    cylinder { <-3.5, 9, -0.5> <-3.7, 9.2, -0.6> 0.7, 1 }
    cylinder { <-3.7, 9.2, -0.6> <-6, 10.2, -1> 0.7, 1}
    sphere   { <-0.6, 8.5, 0> 1, -1 }
    sphere   { <-0.2, 5, 0> 1.3, -2.5 }
    sphere   { <3, 7, -1> 1, -1.5 }
    sphere   { <-3.7, 9.2, -0.6> 0.7, -1 }
    sphere   { <-3.5, 9, -0.5> 0.7, -1 }
    bounded_by {
        sphere {
            <0,0,0> 8.3
            translate y*5
        }
    }
}

#declare TreeFoliage = 
blob {
      threshold 0.65
      sphere { <0, 14, 0> 7, 1 }
      sphere { <4, 12, 0> 4, 1 }
      sphere { <-5, 12, 2> 4.5, 1 }
      sphere { <-4.5, 13, -3> 5, 1 }
      sphere { <-8.5, 11.5, 0> 4, 1 }
      sphere { <2, 11, -3> 3, 1 }
      sphere { <5, 10.8, -2.5> 3.5, 1 }
      sphere { <7, 12, 0> 2, 1 }
      sphere { <6.5, 13, -2> 3, 1 }
      sphere { <0, 12, 3> 3, 1 }
      sphere { <-7, 10.5, 0> 2, 1 }
      sphere { <-5, 10.3, 1> 2, 1 }
      sphere { <-1, 10.7, 0> 2, 1 }
      sphere { <-1.5, 11.2, 4> 3.5, 1 }
      sphere { <4, 11, 4> 4.5, 1 }
      sphere { <6, 12, 2> 2.5, 1 }
      sphere { <6, 10, 1.6> 2.3, 1 }
      sphere { <5, 9.5, 1.4> 1.7, 1 }
      sphere { <-1, 10.8, -4> 3, 1 }
      sphere { <-3, 10, -2> 2, 1 }
      sphere { <0, 10, -2> 2, 1 }
      sphere { <-6, 11, -1> 3.5, 1 }
      sphere { <-9, 11.3, -4> 4, 1 }
      sphere { <-4.7, 10, -5.3> 3, 1 }
      sphere { <2, 12, -5> 4, 1 }
      sphere { <3.5, 11.2, -4.7> 3.8, 1 }
      sphere { <6, 11, -5> 3, 1 }
      sphere { <7, 11.5, -3> 2.5, 1 }
      sphere { <8, 12, -3.5> 2, 1 }
      sphere { <8, 11, 3> 3.5, 1 }
      sphere { <8.5, 10.5, 0> 4, 1 }
      bounded_by {     
        sphere {
            <-0.7,18,-0.7> 11.8
            scale <1,0.6,0.7>
        }
      }
}

#declare Tree =
union {
    object {
        TreeTrunk
        pigment {rgb <0.4, 0.2, 0.05>}
    }
    object {
        TreeFoliage
        pigment {rgb <0.2, 0.6, 0.05>}
    }
}

#declare Hat =
union {
    bicubic_patch { // left rim front
        type 1
        flatness 0.01
        u_steps 3
        v_steps 3
        <-4.7, 0, 0>     <-4.7, 0, -2>       <-3.5, 0, -3>    <-2.1, 0, -3.5>
        <-4.85, -0.1, 0> <-4.85, -0.1, -2>   <-3.7, 0, -4>    <-2.1, 0, -4>
        <-5.6, -0.3, 0>   <-5.6, -0.3, -2.3> <-3.85, 0, -4.5> <-2.1, 0, -4.5>
        <-6.7, -0.7, 0>   <-6.7, -0.7, -2.5> <-4.2, 0, -5>    <-2.1, 0.5, -5>
    }
    bicubic_patch { // left rim middle
        type 1
        flatness 0.01
        u_steps 3
        v_steps 3
        <-2.1, 0, -3.5> <-0.7, 0, -4>    <0.7, 0, -4>   <2.1, 0, -3.5>
        <-2.1, 0, -4>   <-0.7, 0, -4.3>  <0.7, 0, -4.3> <2.1, 0, -4>
        <-2.1, 0, -4.5> <-0.7, 0, -4.5>  <0.7, 0, -4.5> <2.1, 0, -4.5>
        <-2.1, 0.5, -5> <-0.7, 0.83, -5> <0.7, 1, -5>   <2.1, 1, -5>
    }
    bicubic_patch { // left rim back
        type 1
        flatness 0.01
        u_steps 4
        v_steps 4
        <2.1, 0, -3.5> <3.5, 0, -3>    <4.55, 0, -2>    <4.55, 0, 0>
        <2.1, 0, -4>   <3.7, 0, -4>    <5.25, 0, -2>    <5.25, 0, 0>
        <2.1, 0, -4.5> <3.85, 0, -4.5> <5.6, 0, -2.3>   <5.6, 0, 0>
        <2.1, 1, -5>   <4.2, 1, -5>    <6.3, 0.2, -2.5> <6.3, 0.2, 0>
    }
    bicubic_patch { // left side front
        type 1
        flatness 0.01
        u_steps 3
        v_steps 3
        <-4.7, 0, 0> <-4.7, 0, -2>   <-3.5, 0, -3>      <-2.1, 0, -3.5>
        <-4, 0.5, 0> <-4, 0.5, -1.5> <-3.5, 0, -2>      <-2.1, 0, -2>
        <-2.8, 3, 0> <-2.8, 3, -1>   <-2.45, 3, -1.875> <-2.1, 3, -2>
        <-2.8, 3, 0> <-2.8, 3, -0.5> <-2.45, 3, -0.875> <-2.1, 3, -1>
    }
    bicubic_patch { // left side middle
        type 1
        flatness 0.05
        u_steps 3
        v_steps 3
        <-2.1, 0, -3.5> <-0.7, 0, -4>   <0.7, 0, -4>   <2.1, 0, -3.5>
        <-2.1, 0, -2>   <-0.7, 0, -2>   <0.7, 0, -2>   <2.1, 0, -2>
        <-2.1, 3, -2>   <-0.7, 3, -2>   <0.7, 3, -2>   <2.1, 3, -2>
        <-2.1, 3, -1>   <-0.7, 3, -1.5> <0.7, 3, -1.5> <2.1, 3, -1>
    }
    bicubic_patch { // left side back
        type 1
        flatness 0.01
        u_steps 4
        v_steps 4
        <4.55, 0, 0> <4.55, 0, -2>  <3.5, 0, -3>      <2.1, 0, -3.5>
        <4, 0, 0>    <4, 0, -1.5>   <3.5, 0, -2>      <2.1, 0, -2>
        <3, 3, 0>    <3, 3, -1>     <2.45, 3, -1.875> <2.1, 3, -2>
        <2.8, 3, 0>  <2.8, 3, -0.5> <2.45, 3, -0.875> <2.1, 3, -1>
    }
    bicubic_patch { // left top front
        type 1
        flatness 0.01
        u_steps 4
        v_steps 4
        <-2.1, 2.6, 0> <-2.1, 2.6, 0>     <-2.1, 2.6, 0>     <-2.1, 2.6, 0>
        <-2.3, 2.6, 0> <-2.3, 2.6, -0.15> <-2.2, 2.6, -0.3>  <-2.1, 2.6, -0.3>
        <-2.45, 3, 0>  <-2.45, 3, -0.25>  <-2.28, 3, -0.5>   <-2.1, 3, -0.5>
        <-2.8, 3, 0>   <-2.8, 3, -0.5>    <-2.45, 3, -0.875> <-2.1, 3, -1>
    }
    bicubic_patch { // left top middle
        type 1
        flatness 0.05
        u_steps 3
        v_steps 3
        <-2.1, 2.6, 0>    <-0.7, 2, 0>    <0.7, 2, 0>    <2.1, 2.6, 0>
        <-2.1, 2.6, -0.3> <-0.7, 2, -0.3> <0.7, 2, -0.3> <2.1, 2.6, -0.3>
        <-2.1, 3, -0.5>   <-0.7, 3, -0.5> <0.7, 3, -0.5> <2.1, 3, -0.5>
        <-2.1, 3, -1>     <-0.7, 3, -1.5> <0.7, 3, -1.5> <2.1, 3, -1>
    }
    bicubic_patch { // left top back
        type 1
        flatness 0.01
        u_steps 4
        v_steps 4
        <2.1, 2.6, 0>  <2.1, 2.6, 0>    <2.1, 2.6, 0>     <2.1, 2.6, 0>
        <2.3, 2.6, 0> <2.3, 2.6, -0.15> <2.2, 2.6, -0.3>  <2.1, 2.6, -0.3>
        <2.45, 3, 0>  <2.45, 3, -0.25>  <2.3, 3, -0.5>    <2.1, 3, -0.5>
        <2.8, 3, 0>   <2.8, 3, -0.5>    <2.45, 3, -0.875> <2.1, 3, -1>
    }
    bicubic_patch { // right top front
        type 1
        flatness 0.01
        u_steps 4
        v_steps 4
        <-2.1, 2.6, 0> <-2.1, 2.6, 0>    <-2.1, 2.6, 0>    <-2.1, 2.6, 0>
        <-2.3, 2.6, 0> <-2.3, 2.6, 0.15> <-2.2, 2.6, 0.3>  <-2.1, 2.6, 0.3>
        <-2.45, 3, 0>  <-2.45, 3, 0.25>  <-2.3, 3, 0.5>    <-2.1, 3, 0.5>
        <-2.8, 3, 0>   <-2.8, 3, 0.5>    <-2.45, 3, 0.875> <-2.1, 3, 1>
    }
    bicubic_patch { // right top middle
        type 1
        flatness 0.05
        u_steps 3
        v_steps 3
        <-2.1, 2.6, 0>   <-0.7, 2, 0>   <0.7, 2, 0>   <2.1, 2.6, 0>
        <-2.1, 2.6, 0.3> <-0.7, 2, 0.3> <0.7, 2, 0.3> <2.1, 2.6, 0.3>
        <-2.1, 3, 0.5>   <-0.7, 3, 0.5> <0.7, 3, 0.5> <2.1, 3, 0.5>
        <-2.1, 3, 1>     <-0.7, 3, 1.5> <0.7, 3, 1.5> <2.1, 3, 1>
    }
    bicubic_patch { // right top back
        type 1
        flatness 0.01
        u_steps 4
        v_steps 4
        <2.1, 2.6, 0> <2.1, 2.6, 0>    <2.1, 2.6, 0>    <2.1, 2.6, 0>
        <2.3, 2.6, 0> <2.3, 2.6, 0.15> <2.2, 2.6, 0.3>  <2.1, 2.6, 0.3>
        <2.45, 3, 0>  <2.45, 3, 0.25>  <2.3, 3, 0.5>    <2.1, 3, 0.5>
        <2.8, 3, 0>   <2.8, 3, 0.5>    <2.45, 3, 0.875> <2.1, 3, 1>
    }
    bicubic_patch { // right side front
        type 1
        flatness 0.01
        u_steps 3
        v_steps 3
        <-4.7, 0, 0> <-4.7, 0, 2>   <-3.5, 0, 3>      <-2.1, 0, 3.5>
        <-4, 0.5, 0> <-4, 0.5, 1.5> <-3.5, 0, 2>      <-2.1, 0, 2>
        <-2.8, 3, 0> <-2.8, 3, 1>   <-2.45, 3, 1.875> <-2.1, 3, 2>
        <-2.8, 3, 0> <-2.8, 3, 0.5> <-2.45, 3, 0.875> <-2.1, 3, 1>
    }
    bicubic_patch { // right side middle
        type 1
        flatness 0.05
        u_steps 3
        v_steps 3
        <-2.1, 0, 3.5> <-0.7, 0, 4>   <0.7, 0, 4>   <2.1, 0, 3.5>
        <-2.1, 0, 2>   <-0.7, 0, 2>   <0.7, 0, 2>   <2.1, 0, 2>
        <-2.1, 3, 2>   <-0.7, 3, 2>   <0.7, 3, 2>   <2.1, 3, 2>
        <-2.1, 3, 1>   <-0.7, 3, 1.5> <0.7, 3, 1.5> <2.1, 3, 1>
    }
    bicubic_patch { // right side back
        type 1
        flatness 0.01
        u_steps 4
        v_steps 4
        <4.55, 0, 0> <4.55, 0, 2>  <3.5, 0, 3>      <2.1, 0, 3.5>
        <4, 0, 0>    <4, 0, 1.5>   <3.5, 0, 2>      <2.1, 0, 2>
        <3, 3, 0>    <3, 3, 1>     <2.45, 3, 1.875> <2.1, 3, 2>
        <2.8, 3, 0>  <2.8, 3, 0.5> <2.45, 3, 0.875> <2.1, 3, 1>
    }
    bicubic_patch { // right rim front
        type 1
        flatness 0.01
        u_steps 3
        v_steps 3
        <-4.7, 0, 0>     <-4.7, 0, 2>       <-3.5, 0, 3>    <-2.1, 0, 3.5>
        <-4.85, -0.1, 0> <-4.85, -0.1, 2>   <-3.7, 0, 4>    <-2.1, 0, 4>
        <-5.6, -0.3, 0>   <-5.6, -0.3, 2.3> <-3.85, 0, 4.5> <-2.1, 0, 4.5>
        <-6.7, -0.7, 0>   <-6.7, -0.7, 2.5> <-4.2, 0, 5>    <-2.1, 0.5, 5>
    }
    bicubic_patch { // right rim middle
        type 1
        flatness 0.01
        u_steps 3
        v_steps 3
        <-2.1, 0, 3.5> <-0.7, 0, 4>    <0.7, 0, 4>   <2.1, 0, 3.5>
        <-2.1, 0, 4>   <-0.7, 0, 4.3>  <0.7, 0, 4.3> <2.1, 0, 4>
        <-2.1, 0, 4.5> <-0.7, 0, 4.5>  <0.7, 0, 4.5> <2.1, 0, 4.5>
        <-2.1, 0.5, 5> <-0.7, 0.83, 5> <0.7, 1, 5>   <2.1, 1, 5>
    }
    bicubic_patch { // right rim back
        type 1
        flatness 0.01
        u_steps 4
        v_steps 4
        <2.1, 0, 3.5> <3.5, 0, 3>    <4.55, 0, 2>    <4.55, 0, 0>
        <2.1, 0, 4>   <3.7, 0, 4>    <5.25, 0, 2>    <5.25, 0, 0>
        <2.1, 0, 4.5> <3.85, 0, 4.5> <5.6, 0, 2.3>   <5.6, 0, 0>
        <2.1, 1, 5>   <4.2, 1, 5>    <6.3, 0.2, 2.5> <6.3, 0.2, 0>
    }
}

#declare MagnifyingGlass =
union {
    intersection {
        sphere {
            <0,-4.8,0> 5
        }
        sphere {
            <0,4.8,0> 5
        }
        texture {
            pigment {Col_Glass_General}
            finish {F_Glass5}
        }
        interior {I_Glass1}
    }
    torus {
        1.47, 0.07
        scale <1,2,1>
        texture {Silver_Metal}
    }
    cone {
        <0,0,-1.54> 0.1
        <0,0,-2> 0.3
        texture {Silver_Metal}
    }
    cylinder {
        <0,0,-2> <0,0,-3.7> 0.3
            pigment {rgb <0.4,0.4,0.4>}
    }
}