// PoVRay 3.5 Scene File " ddd.pov"
// created by Paolo Gibellini     
// Date: 29/08/2003
// Desc: Main file
//--------------------------------------------------------------------------
#version 3.5;

// Defaults ----------------------------------------------------------------
//global_settings {  assumed_gamma 1.0 }
global_settings {
    adc_bailout 0.003922
    ambient_light <1.0,1.0,1.0>
    assumed_gamma 1.9
    hf_gray_16 off
    irid_wavelength <0.247059,0.176471,0.137255>
    max_intersections 64
    max_trace_level 10
    number_of_waves 10
}
default {
    texture {
        pigment { rgb <1,0,0> }
    }
}
//--------------------------------------------------------------------------

// Includes ----------------------------------------------------------------
#include "colors.inc"
#include "textures.inc"
#include "stones.inc"

// My own include
#include "ddd_c.inc"    // Textures
#include "ddd_h.inc"    // Homuncolo
#include "ddd_hs.inc"   // Homuncolo 02
#include "dddclock.inc" // Clock

//--------------------------------------------------------------------------

// Cameras -----------------------------------------------------------------
// perspective (default) camera
#declare Camera_0 =camera {
  location  <0.0, 2.0, -40.0>
  look_at   <0.0, 0.0,  0.0>
  right     x*image_width/image_height
}

//  Camera StdCam
#declare Camera_1 = camera {
  location  <      5.781,     -52.596,       7.868>
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.38262,         0.0,         0.0> // Right Vector is adjusted to compensate for spherical (Moray) vs. planar (POV-Ray) aspect ratio
  angle         54.75517    // Vertical      41.066
  look_at   <      4.010,      -1.569,       1.179>
}

#declare Camera_2 =camera {
  location  <6.0, 5.0, -18.0>
  look_at   <0, 1,  0.0>
  right     x*image_width/image_height
}


camera{Camera_2}
//--------------------------------------------------------------------------
  
// Lights ------------------------------------------------------------------
// Without shadow
light_source {
    <10, 50, -100> White 
    translate  <-20.0, -20.0, 20.0>
    shadowless
}
// For the shadows
light_source {
    <10, 50, -100> White 
//    <0.0, 0.0, 0.0>
    //color rgb <1.000, 1.000, 1.000>
    translate  <-60.0, -20.0, 80.0>
}
//--------------------------------------------------------------------------

// sky ---------------------------------------------------------------------
plane{ <0,1,0>,1 hollow  
       texture{
               pigment{ bozo turbulence 0.76
                        color_map { [0.5  rgb <0.4,0.3,0.8> ]
                                    [0.6  rgb <1.0,1.0,1.0> ]
                                    [0.65 rgb <1.5,1.5,1.5> ]
                                    [1.0  rgb <0.5,0.5,0.5> ] 
                        }
               }
               finish { ambient .5 diffuse 0} 
              }      
       scale 300}
//--------------------------------------------------------------------------

// fog ---------------------------------------------------------------------
fog{fog_type   2
    distance   50
    color      White
    fog_offset 0.1
    fog_alt    2.0
    turbulence 0.8}
//--------------------------------------------------------------------------
    
// ground ------------------------------------------------------------------
plane{ <0,1,0>, 0 
       texture{ pigment {color rgb <0.85,0.6,0.4>}
                finish  {ambient 0.1 diffuse 0.8 } 
              } 
     } 
 
//--------------------------------------------------------------------------

// Scene -------------------------------------------------------------------
// A sphere
sphere {
    <0,0,0>,1
    texture{
        pigment{White_Marble}
    }
    translate  <-14, 1, 2>
}
  
// A pyramid with pool
#declare TaperSweep001 = prism {
    conic_sweep
    linear_spline
    0.0,1.0
    5  // control points
    <-1.0, -1.0>,
    <1.0, -1.0>,
    <1.0, 1.0>,
    <-1.0, 1.0>,
    <-1.0, -1.0>
    rotate <90,0,90>
    material {
        gcrack01
    }
    scale <-4.166383, -3.149406, -8.287991>
    translate  <-0.194853, 0.0, 9.677697>
}
// Group002
#declare Group002 = union { 
    object { TaperSweep001 }
    box {
        <-1, -1, -1>, <1, 1, 1>
        scale <5.082195, 3.745498, 0.685985>
    }
    box {
        <-1, -1, -1>, <1, 1, 1>
        scale <4.297158, 3.166937, 0.580022>
        translate  <-0.157007, 0.0, 0.839249>
    }
    material {
        gcrack02
    }
}

// The pool
#declare CSG001 = difference {
    box {
        <-1, -1, -1>, <1, 1, 1>
        scale <5.082195, 3.745498, 0.685985>
        translate  -8.465284*y
    }
    box {
        <-1, -1, -1>, <1, 1, 1>
        scale <4.297158, 3.284484, 0.427864>
        translate  <-0.157007, -8.465284, 0.366343>
    }
}
// Group001
#declare Group001 = union { 
    object { CSG001 }
    box {
        <-1, -1, -1>, <1, 1, 1>
        material {
            Water
        }
        scale <4.297158, 3.284484, 0.233011>
        translate  <-0.157007, -8.465284, 0.236441>
    }
    texture {
        White_Marble
    }
    translate  <-0.064951, 0.0, -0.714461>
}

// The pool
object { Group001
    rotate<0,90,90>
    translate<-8.5,0.3,-9.5>
    scale<1,1,0.7>
}
// The pyramid
object { Group002
    rotate<0,90,90>
    translate<0,0.5,0>
}
// The man
object { homo02
    rotate<10,15,-6>
    translate<-0.5,6,-4.5>
    material {
        gcrack02
    }
}
// The clock
object { clock01
    translate<3,6,-10>
    scale<0.5,0.5,0.5>
}

    
// Some people
object { homo
    rotate<0,90,0>
    scale<0.3,0.3,0.3>
    translate<7,1.4,-12>
    material {
        ghomo
    }
}   
object { homo
    rotate<0,90,0>
    scale<0.3,0.3,0.3>
    translate<7,1.4,-10>
    material {
        ghomo
    }
}        
object { homo
    rotate<0,90,20>
    scale<0.3,0.3,0.3>
    translate<7,1.4,12>
    material {
        ghomo
    }
}
object { homo
    rotate<0,-90,0>
    scale<0.3,0.3,0.3>
    translate<6,1.4,14>
    material {
        ghomo
    }
}
object { homo
    rotate<0,90,0>
    scale<0.3,0.3,0.3>
    translate<4,1.4,20>
    material {
        ghomo
    }
}               
