global_settings {
   adc_bailout 0.0039216
   assumed_gamma 1.5
   
   radiosity {
      brightness 2
   }
}

#declare Gardinenstoff = texture {
   finish {
      ambient rgb <0.1, 0.1, 0.1>
      diffuse 0.8
      brilliance 1.5
   }
   
   pigment {
      bozo
      turbulence <0.2, 0.5, 0.2>
      
      color_map {
         [ 0 color rgbt <0.435294, 0.686275, 0.784314, 0.4>
         ]
         [ 0.4 color rgbt <0.43529, 0.68627, 0.78431, 0.2>
         ]
         [ 1 color rgbt <1, 1, 1, 0.9>
         ]
      }
   }
   scale 0.01
}

#declare Wand = texture {
   finish {
      ambient rgb <0, 0, 0>
      diffuse 0.9
      specular 0.5
      roughness 0.4
   }
   // finish {
   //    ambient rgb <0, 0, 0>
   //    diffuse 0.9
   //    specular 0.5
   //    roughness 0.4
   // }
   pigment {
      color rgb <0.823529, 0.823529, 0.823529>
   }
}

#declare T_Grnt12 = texture {
   pigment {
      granite
      turbulence <0.6, 0.6, 0.6>
      
      color_map {
         [ 0 color rgb <0.996, 0.969, 0.8>
         ]
         [ 0.154 color rgb <0.996, 0.682, 0.604>
         ]
         [ 0.308 color rgb <0.906, 0.82, 0.714>
         ]
         [ 0.444 color rgb <0.816, 0.631, 0.537>
         ]
         [ 0.615 color rgb <0.89, 0.792, 0.675>
         ]
         [ 0.812 color rgb <0.973, 0.627, 0.627>
         ]
         [ 1.001 color rgb <0.996, 0.969, 0.8>
         ]
      }
   }
}

#declare T_Grnt17a = texture {
   pigment {
      granite
      turbulence <0.6, 0.6, 0.6>
      
      color_map {
         [ 0 color rgb <0.027, 0.012, 0.012>
         ]
         [ 0.034 color rgbt <0.851, 0.812, 0.741, 0.235>
         ]
         [ 0.342 color rgbt <0.792, 0.694, 0.69, 0.839>
         ]
         [ 0.462 color rgbt <0.631, 0.506, 0.471, 0.608>
         ]
         [ 0.632 color rgbt <0.851, 0.812, 0.741, 0.922>
         ]
         [ 0.983 color rgbt <0.647, 0.655, 0.655, 0.282>
         ]
         [ 1.001 color rgb <0.027, 0.012, 0.012>
         ]
      }
   }
}

#declare T_Crack1 = texture {
   pigment {
      marble
      turbulence <0.85, 0.85, 0.85>
      
      color_map {
         [ 0 color rgbt <0, 0, 0, 0.6>
         ]
         [ 0.04 color rgbt <0, 0, 0, 1>
         ]
         [ 0.04 color rgbt <0.55, 0.09, 0.09, 0.8>
         ]
         [ 0.97 color rgbt <0.329412, 0.329412, 0.329412, 0.9>
         ]
         [ 0.97 color rgbt <0, 0, 0, 0.9>
         ]
         [ 1.001 color rgbt <0, 0, 0, 1>
         ]
      }
   }
}

#declare T_Stone5 = texture {
   T_Grnt12
   scale <2, 3, 2>
   rotate z*40
}

texture {
   T_Grnt17a
   scale <2, 3, 2>
   rotate z*(-30)
}

texture {
   T_Crack1
   scale <1, 2, 1.4>
   rotate <10, 0, -20>
   
   finish {
      ambient rgb <0.254902, 0.254902, 0.254902>
      phong 1
      phong_size 90
   }
}

#declare Sterne = pigment {
   granite
   turbulence <1, 1, 1>
   
   color_map {
      [ 0 color rgbt <0.0039216, 0.015686, 0.086275, 1>
      ]
      [ 0.27 color rgbt <0.0039216, 0.015686, 0.086275, 1>
      ]
      [ 0.27 color rgb <0.5, 0.5, 0.4>
      ]
      [ 0.275 color rgb <0.8, 0.8, 0.4>
      ]
      [ 0.275 color rgbt <0.0039216, 0.015686, 0.086275, 1>
      ]
      [ 0.47 color rgbt <0.0039216, 0.015686, 0.086275, 1>
      ]
      [ 0.47 color rgb <0.4, 0.4, 0.5>
      ]
      [ 0.475 color rgb <0.4, 0.4, 0.8>
      ]
      [ 0.475 color rgbt <0.0039216, 0.015686, 0.086275, 1>
      ]
      [ 0.68 color rgbt <0.0039216, 0.015686, 0.086275, 1>
      ]
      [ 0.68 color rgb <0.5, 0.4, 0.4>
      ]
      [ 0.68 color rgb <0.8, 0.4, 0.4>
      ]
      [ 0.685 color rgbt <0.0039216, 0.015686, 0.086275, 1>
      ]
      [ 0.85 color rgbt <0.0039216, 0.015686, 0.086275, 1>
      ]
      [ 0.85 color rgb <0.5, 0.5, 0.5>
      ]
      [ 0.88 color rgb <1, 1, 1>
      ]
      [ 0.88 color rgbt <0, 0, 0, 1>
      ]
      [ 0.9 color rgbt <0.0039216, 0.015686, 0.086275, 1>
      ]
      [ 1 color rgbt <0.0039216, 0.015686, 0.086275, 1>
      ]
   }
   sine_wave
   scale 0.2
}

#declare Farbe_Nachttisch = texture {
   finish {
      ambient rgb <0.0431373, 0.0431373, 0.0431373>
      diffuse 0.7
      brilliance 1
      specular 0.4
      roughness 0.05
   }
   
   normal {
      wood
      0.1
      turbulence <0.02, 0.02, 0.02>
      translate x*10
      rotate <90, 0.2, 0>
      scale 0.01
   }
   
   pigment {
      color rgb <0.580392, 0.619608, 0.792157>
   }
}

#declare Kiefernholz = texture {
   pigment {
      wood
      turbulence <0.02, 0.02, 0.02>
      
      color_map {
         [ 0.222 color rgb <0.808, 0.671, 0.251>
         ]
         [ 0.342 color rgb <0.6, 0.349, 0.043>
         ]
         [ 0.393 color rgb <0.808, 0.671, 0.251>
         ]
         [ 0.709 color rgb <0.808, 0.671, 0.251>
         ]
         [ 0.821 color rgb <0.533, 0.298, 0.027>
         ]
         [ 1 color rgb <0.808, 0.671, 0.251>
         ]
      }
      scale 0.1
      translate x*10
   }
   scale 10
}

texture {
   pigment {
      wood
      turbulence <0.01, 0.01, 0.01>
      
      color_map {
         [ 0 color rgbt <1, 1, 1, 1>
         ]
         [ 0.12 color rgbt <0.702, 0.467, 0.118, 0.608>
         ]
         [ 0.496 color rgbt <1, 1, 1, 1>
         ]
         [ 0.701 color rgbt <1, 1, 1, 1>
         ]
         [ 0.829 color rgbt <0.702, 0.467, 0.118, 0.608>
         ]
         [ 1 color rgbt <1, 1, 1, 1>
         ]
      }
      scale 0.5
      translate x*10
   }
   scale 10
   
   finish {
      ambient rgb <0.1, 0.1, 0.1>
      diffuse 0.9
      phong 0.4
      phong_size 10
   }
}

#declare weisse_Plaste = texture {
   finish {
      ambient rgb <0.14902, 0.14902, 0.14902>
      diffuse 0.7
   }
   
   pigment {
      color rgb <1, 1, 1>
   }
}

#declare Messing = texture {
   finish {
      ambient rgb <0, 0, 0>
      diffuse 0.7
      brilliance 6
      metallic 1
      specular 0.7
      roughness 0.01
      reflection rgb <0.7, 0.7, 0.7>
   }
   
   pigment {
      color rgb <0.65, 0.5, 0.25>
   }
}

#declare Messing_durchsichtig = texture {
   finish {
      ambient rgb <0.454902, 0.454902, 0.454902>
      diffuse 0.7
      brilliance 6
      metallic 1
      specular 0.3
      roughness 0.01
      reflection rgb <0.411765, 0.411765, 0.411765>
   }
   
   pigment {
      color rgbt <0.65, 0.5, 0.25, 0.9>
   }
}

#declare Dunkles_Metall = texture {
   finish {
      ambient rgb <0, 0, 0>
      diffuse 0.7
      brilliance 6
      metallic 1
      specular 0.7
      roughness 0.01
      reflection rgb <0.7, 0.7, 0.7>
   }
   
   pigment {
      color rgb <0.0745098, 0.054902, 0.0313725>
   }
}

#declare Helles_Metall = texture {
   finish {
      ambient rgb <0.172549, 0.172549, 0.172549>
      diffuse 0.7
      brilliance 6
      metallic 1
      specular 0.7
      roughness 0.01
      reflection rgb <0.7, 0.7, 0.7>
   }
   
   pigment {
      color rgb <0.705882, 0.654902, 0.615686>
   }
}

#declare Phosphor = texture {
   finish {
      ambient rgb <0.698039, 0.698039, 0.698039>
   }
   
   pigment {
      color rgb <0.968627, 1, 0.756863>
   }
}

#declare grosse_ziffern = texture {
   finish {
      ambient rgb <0.223529, 0.223529, 0.223529>
   }
   
   pigment {
      color rgb <0.439216, 0.439216, 0.478431>
   }
}

#declare Plaste_durchsichtig = texture {
   finish {
      ambient rgb <0, 0, 0>
      diffuse 0.4
      brilliance 6
      specular 0.3
      roughness 0.02
      reflection rgb <0.2, 0.2, 0.2>
   }
   
   pigment {
      color rgbf <0.97255, 0.98039, 0.97255, 0.9>
   }
}

#declare Stahl = texture {
   finish {
      ambient rgb <0.054902, 0.054902, 0.054902>
      diffuse 0.3
      brilliance 5
      metallic 1
      specular 1
      roughness 0.02
      reflection rgb <0.454902, 0.454902, 0.454902>
   }
   
   pigment {
      color rgb <0.592157, 0.592157, 0.592157>
   }
}

#declare Plaste_schwarz = texture {
   finish {
      ambient rgb <0, 0, 0>
      diffuse 0.6
      specular 0.6
   }
   
   pigment {
      color rgb <0.172549, 0.172549, 0.172549>
   }
}

#declare Glanzparenz = texture {
   finish {
      ambient rgb <0.905882, 0.905882, 0.905882>
      diffuse 0.9
      specular 0.6
      roughness 0.2
   }
   
   pigment {
      color rgbt <1, 1, 1, 0.9>
   }
}

#declare Pille = sphere {
   <0, 0, 0>, 0.25
   scale <1, 0.5, 1>
   rotate <0, 0, 0>
   translate y*0.26
   
   texture {
      finish {
         diffuse 0.7
         phong 0.5
         phong_size 30
      }
      
      pigment {
         color rgb <1, 0.984314, 0.972549>
      }
   }
}

#declare Pillendeckel_gedrueckt = merge {
   difference {
      sphere {
         <0, 0, 0>, 0.26
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      box {
         <-0.5, -0.5, -0.5>, <0.5, 0.5, 0.5>
         scale 0.3
         rotate <10, 45, 45>
         translate <0, 0.253998, -0.0101231>
      }
      
      plane {
         <0, 1, 0>, 0
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
   }
   
   difference {
      torus {
         0.3, 0.04
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      plane {
         <0, 1, 0>, 0
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      cylinder {
         <0, 0.05, 0>, <0, -0.05, 0>, 0.3
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
         inverse
      }
   }
   scale <1.2, 1.1, 1.2>
   translate y*0.16
}

#declare Pillendeckel = merge {
   difference {
      sphere {
         <0, 0, 0>, 0.26
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      sphere {
         <0, 0, 0>, 0.26
         scale 0.95
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      plane {
         <0, 1, 0>, 0
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
   }
   
   difference {
      torus {
         0.3, 0.04
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      plane {
         <0, 1, 0>, 0
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      cylinder {
         <0, 0.05, 0>, <0, -0.05, 0>, 0.3
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
         inverse
      }
   }
   scale <1.2, 1.1, 1.2>
   translate y*0.16
}

#declare Pillenreihe = union {
   object {
      Pille
      scale 1
      rotate <0, 0, 0>
      translate x*(-2)
   }
   
   object {
      Pille
      scale 1
      rotate <0, 0, 0>
      translate x*(-1)
   }
   
   object {
      Pille
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   object {
      Pille
      scale 1
      rotate <0, 0, 0>
      translate x*1
   }
   
   object {
      Pille
      scale 1
      rotate <0, 0, 0>
      translate x*2
   }
}

#declare Deckelreihe = union {
   object {
      Pillendeckel
      scale 1
      rotate <0, 0, 0>
      translate x*(-2)
   }
   
   object {
      Pillendeckel
      scale 1
      rotate <0, 0, 0>
      translate x*(-1)
   }
   
   object {
      Pillendeckel
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   object {
      Pillendeckel
      scale 1
      rotate <0, 0, 0>
      translate x*1
   }
   
   object {
      Pillendeckel
      scale 1
      rotate <0, 0, 0>
      translate x*2
   }
}

#declare Pillenpackung = union {
   difference {
      //*PMName Aluboden
      
      superellipsoid {
         //*PMName Aluboden
         <0.2, 0.2>
         scale <2.8, 0.02, 2.2>
         rotate <0, 0, 0>
         translate y*0.09
      }
      
      plane {
         <0, 1, 0>, 0.1
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      prism {
         linear_spline
         linear_sweep
         0, 1,
         7,
         <0.5, 1>, <0.261905, 0.285714>, <0.428571, -0.714286>, <0.166667, 0.047619>, <-0.761905, 0.571429>, <0.0952381, 0.380952>, <0.5, 1>
         scale <0.5, 0.2, 0.5>
         rotate <0, 0, 0>
         translate <-1.06942, 0, -1.13883>
      }
      
      prism {
         linear_spline
         linear_sweep
         0, 1,
         7,
         <0.5, 1>, <0.261905, 0.285714>, <0.428571, -0.714286>, <0.166667, 0.047619>, <-0.761905, 0.571429>, <0.0952381, 0.380952>, <0.5, 1>
         scale <0.5, 0.2, 0.5>
         rotate y*33
         translate <1.92191, 0, -1.06942>
      }
      
      texture {
         normal {
            crackle
            0.3
            turbulence <0.4, 0.4, 0.4>
            scale 0.5
         }
         
         pigment {
            color rgb <0.941176, 0.941176, 0.941176>
         }
         
         finish {
            ambient rgb <0.0470588, 0.0470588, 0.0470588>
            diffuse 0.4
            brilliance 4
            phong 0.7
            phong_size 80
            metallic 1
            reflection rgb <0.627451, 0.627451, 0.627451>
         }
      }
   }
   
   merge {
      //*PMName Abdeckung
      
      difference {
         superellipsoid {
            <0.2, 0.2>
            scale <2.8, 0.02, 2.2>
            rotate <0, 0, 0>
            translate y*0.11
         }
         
         plane {
            <0, -1, 0>, -0.1
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
      }
      
      object {
         Deckelreihe
         scale 1
         rotate <0, 0, 0>
         translate z*1
      }
      
      object {
         Deckelreihe
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      // No prototype for object link
      object {
         Pillendeckel
         scale 1
         rotate <0, 0, 0>
         translate <-2, 0, -1>
      }
      
      object {
         Pillendeckel
         scale 1
         rotate <0, 0, 0>
         translate z*(-1)
      }
      
      object {
         Pillendeckel
         scale 1
         rotate <0, 0, 0>
         translate <1, 0, -1>
      }
      
      object {
         Pillendeckel_gedrueckt
         scale 1
         rotate <0, 0, 0>
         translate <-1, 0, -1>
      }
      
      object {
         Pillendeckel_gedrueckt
         scale 1
         rotate <0, 0, 0>
         translate <2, 0, -1>
      }
      
      pigment {
         color rgbt <0.980392, 0.980392, 0.980392, 0.9>
      }
      
      finish {
         phong 0.6
         phong_size 40
         reflection rgb <0.168627, 0.168627, 0.168627>
      }
   }
   
   object {
      Pillenreihe
      scale 1
      rotate <0, 0, 0>
      translate z*1
   }
   
   object {
      Pillenreihe
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   object {
      Pille
      scale 1
      rotate <0, 0, 0>
      translate <-2, 0, -1>
   }
   
   object {
      Pille
      scale 1
      rotate <0, 0, 0>
      translate z*(-1)
   }
   
   object {
      Pille
      scale 1
      rotate <0, 0, 0>
      translate <1, 0, -1>
   }
   translate y*(-0.07)
}

#declare Ziffer_0 = prism {
   linear_spline
   linear_sweep
   0, 1,
   60,
   <204, 90>, <217, 92>, <230, 97>, <243, 104>, <256, 115>, <262, 122>, <274, 141>, <279, 158>, <281, 179>, <278, 196>, <273, 212>, <264, 227>, <252, 241>, <236, 251>, <224, 256>, <211, 259>, <195, 260>, <179, 258>, <159, 249>, <146, 240>, <136, 229>, <127, 214>, <122, 198>, <120, 183>, <120, 167>, <123, 152>, <128, 138>, <135, 125>, <144, 114>, <157, 103>, <168, 97>, <188, 92>, <204, 90>,
   <200, 97>, <213, 98>, <225, 105>, <232, 111>, <238, 123>, <242, 136>, <245, 158>, <247, 181>, <246, 203>, <243, 221>, <236, 235>, <227, 243>, <219, 248>, <208, 252>, <196, 253>, <181, 249>, <170, 241>, <162, 226>, <156, 204>, <153, 178>, <154, 149>, <157, 129>, <163, 115>, <171, 106>, <181, 100>, <192, 98>, <200, 97>
   scale <0.007, 0.1, 0.007>
   rotate x*90
   translate <-0.861008, 1.84963, -1.1001>
   rotate z*(-3)
}

#declare Ziffer_1 = prism {
   linear_spline
   linear_sweep
   0, 1,
   25,
   <226, 124>, <259, 115>, <261, 116>, <262, 129>, <268, 246>, <271, 260>, <274, 266>, <278, 269>, <281, 271>, <288, 273>, <288, 276>, <278, 277>, <223, 279>, <222, 276>, <229, 273>, <235, 266>, <238, 254>, <236, 160>, <234, 139>, <230, 134>, <225, 131>, <219, 131>, <218, 128>, <220, 125>, <226, 124>
   scale <0.007, 0.1, 0.007>
   rotate x*90
   translate <-1.54759, 1.95682, -1.1001>
   rotate z*(-2)
}

#declare Ziffer_2 = prism {
   linear_spline
   linear_sweep
   0, 1,
   70,
   <103, 147>, <95, 122>, <96, 118>, <103, 114>, <114, 110>, <129, 105>, <141, 102>, <152, 101>, <167, 101>, <185, 104>, <197, 108>, <209, 115>, <218, 126>, <224, 138>, <226, 153>, <224, 165>, <216, 177>, <204, 189>, <190, 197>, <174, 204>, <163, 207>, <151, 212>, <141, 218>, <132, 226>, <125, 236>, <126, 240>, <130, 241>, <158, 240>, <187, 238>, <204, 237>, <210, 235>, <218, 231>, <224, 227>, <229, 222>, <232, 219>, <234, 219>, <232, 228>, <224, 260>, <221, 263>, <101, 268>, <100, 265>, <101, 258>, <104, 250>, <107, 243>, <111, 236>, <119, 227>, <128, 219>, <141, 209>, <158, 199>, <170, 190>, <177, 184>, <185, 174>, <188, 167>, <192, 156>, <191, 145>, <189, 132>, <184, 123>, <178, 116>, <169, 111>, <159, 109>, <150, 109>, <139, 110>, <130, 114>, <121, 119>, <115, 125>, <111, 133>, <108, 143>, <105, 147>, <103, 146>, <103, 147>
   scale <0.007, 0.1, 0.007>
   rotate x*90
   translate <-0.6944, 1.8768, -1.1001>
   rotate z*(-2.8)
}

#declare Ziffer_3 = prism {
   linear_spline
   linear_sweep
   0, 1,
   89,
   <84, 121>, <85, 117>, <94, 113>, <103, 109>, <119, 105>, <138, 103>, <161, 102>, <182, 104>, <193, 109>, <202, 114>, <209, 122>, <213, 130>, <214, 141>, <213, 147>, <212, 152>, <207, 160>, <200, 167>, <192, 172>, <182, 176>, <178, 178>, <178, 180>, <189, 182>, <203, 187>, <214, 195>, <220, 202>, <224, 210>, <225, 219>, <225, 225>, <223, 235>, <218, 245>, <208, 255>, <196, 262>, <184, 266>, <171, 269>, <158, 271>, <141, 271>, <124, 270>, <106, 267>, <89, 263>, <80, 258>, <76, 253>, <84, 226>, <87, 224>, <89, 225>, <92, 233>, <99, 243>, <107, 251>, <114, 256>, <123, 260>, <130, 262>, <141, 262>, <155, 262>, <164, 260>, <173, 254>, <180, 247>, <186, 238>, <188, 227>, <189, 217>, <184, 204>, <176, 195>, <167, 189>, <159, 186>, <148, 185>, <133, 185>, <126, 186>, <122, 186>, <121, 183>, <122, 176>, <124, 175>, <138, 176>, <150, 175>, <164, 170>, <171, 165>, <176, 157>, <179, 150>, <179, 135>, <176, 125>, <167, 116>, <157, 112>, <147, 110>, <135, 111>, <123, 113>, <117, 116>, <107, 125>, <100, 135>, <97, 146>, <94, 148>, <92, 148>, <84, 121>
   scale <0.007, 0.1, 0.007>
   rotate x*90
   translate <-0.539307, 1.91911, -1.1001>
   rotate z*(-2)
}

#declare Ziffer_4 = prism {
   linear_spline
   linear_sweep
   0, 1,
   51,
   <188, 98>, <190, 99>, <193, 208>, <198, 210>, <208, 209>, <215, 207>, <225, 202>, <233, 195>, <237, 190>, <240, 191>, <239, 196>, <231, 223>, <228, 227>, <223, 227>, <196, 227>, <195, 229>, <196, 243>, <198, 253>, <202, 257>, <206, 260>, <216, 263>, <216, 266>, <211, 267>, <148, 268>, <145, 267>, <145, 265>, <149, 262>, <154, 260>, <157, 256>, <160, 249>, <162, 243>, <162, 229>, <161, 228>, <80, 228>, <77, 227>, <78, 219>, <80, 216>, <84, 210>, <185, 98>, <188, 98>,
   <160, 141>, <162, 142>, <161, 209>, <159, 211>, <100, 212>, <99, 210>, <103, 204>, <112, 192>, <154, 145>, <158, 141>, <160, 141>
   scale <0.007, 0.1, 0.007>
   rotate x*90
   translate <-0.535995, 1.88733, -1.1001>
   rotate z*(-0.5)
}

#declare Ziffer_5 = prism {
   linear_spline
   linear_sweep
   0, 1,
   69,
   <228, 100>, <222, 124>, <220, 125>, <135, 129>, <128, 130>, <120, 133>, <117, 138>, <115, 147>, <114, 176>, <116, 178>, <124, 175>, <143, 171>, <160, 169>, <179, 170>, <195, 171>, <214, 177>, <229, 186>, <237, 193>, <242, 203>, <245, 213>, <244, 224>, <241, 235>, <234, 246>, <227, 253>, <218, 259>, <211, 263>, <200, 266>, <191, 268>, <175, 270>, <160, 270>, <143, 269>, <125, 267>, <110, 263>, <96, 257>, <94, 253>, <95, 248>, <101, 226>, <104, 223>, <107, 226>, <113, 238>, <121, 248>, <136, 256>, <151, 261>, <167, 261>, <183, 259>, <196, 252>, <206, 238>, <209, 221>, <207, 207>, <200, 195>, <192, 187>, <183, 182>, <176, 180>, <166, 179>, <152, 178>, <135, 181>, <120, 186>, <111, 190>, <105, 190>, <105, 178>, <108, 107>, <111, 105>, <131, 104>, <214, 100>, <220, 99>, <224, 96>, <227, 95>, <229, 96>, <228, 100>
   scale <0.007, 0.1, 0.007>
   rotate x*90
   translate <-0.662421, 1.91313, -1.1001>
   rotate z*(-2.6)
}

#declare Ziffer_6 = prism {
   linear_spline
   linear_sweep
   0, 1,
   82,
   <236, 119>, <229, 145>, <226, 146>, <224, 140>, <221, 132>, <214, 123>, <205, 116>, <197, 112>, <188, 109>, <176, 107>, <162, 109>, <152, 113>, <142, 121>, <136, 129>, <131, 136>, <127, 151>, <126, 169>, <126, 176>, <128, 176>, <133, 169>, <140, 163>, <147, 158>, <157, 153>, <170, 151>, <185, 150>, <199, 153>, <211, 157>, <223, 164>, <235, 173>, <243, 186>, <248, 198>, <247, 216>, <244, 230>, <237, 242>, <229, 250>, <218, 258>, <204, 264>, <188, 268>, <174, 270>, <161, 269>, <145, 265>, <129, 258>, <116, 247>, <104, 232>, <96, 214>, <92, 197>, <91, 178>, <94, 164>, <99, 149>, <108, 133>, <120, 120>, <133, 110>, <153, 102>, <173, 99>, <192, 99>, <214, 104>, <235, 111>, <237, 114>, <236, 119>,
   <171, 160>, <185, 161>, <196, 166>, <206, 177>, <213, 192>, <215, 208>, <214, 226>, <209, 241>, <201, 252>, <191, 258>, <181, 262>, <171, 262>, <162, 261>, <151, 257>, <141, 250>, <133, 236>, <129, 219>, <129, 201>, <133, 184>, <141, 172>, <151, 164>, <161, 161>, <171, 160>
   scale <0.007, 0.1, 0.007>
   rotate x*90
   translate <-0.643627, 1.89438, -1.1001>
   rotate z*(-0.6)
}

#declare Ziffer_7 = prism {
   linear_spline
   linear_sweep
   0, 1,
   41,
   <110, 107>, <236, 105>, <238, 107>, <239, 111>, <236, 119>, <229, 130>, <223, 139>, <217, 147>, <209, 157>, <200, 166>, <188, 182>, <179, 199>, <174, 218>, <170, 238>, <171, 257>, <171, 262>, <168, 266>, <149, 266>, <135, 267>, <131, 264>, <132, 253>, <135, 240>, <142, 226>, <149, 210>, <162, 192>, <170, 182>, <186, 167>, <199, 155>, <207, 145>, <214, 133>, <213, 130>, <118, 132>, <110, 134>, <104, 138>, <99, 142>, <95, 147>, <92, 148>, <91, 144>, <101, 110>, <105, 107>, <110, 107>
   scale <0.007, 0.1, 0.007>
   rotate x*90
   translate <-0.648904, 1.87599, -1.1001>
   rotate z*(-1.2)
}

#declare Ziffer_8 = prism {
   linear_spline
   linear_sweep
   0, 1,
   88,
   <173, 100>, <190, 100>, <204, 102>, <216, 106>, <222, 109>, <228, 114>, <233, 120>, <237, 132>, <237, 143>, <232, 153>, <225, 160>, <214, 167>, <205, 170>, <204, 174>, <217, 177>, <235, 184>, <245, 193>, <251, 205>, <254, 219>, <251, 232>, <244, 243>, <233, 253>, <219, 260>, <203, 265>, <182, 268>, <169, 268>, <154, 267>, <141, 265>, <127, 260>, <114, 251>, <105, 239>, <102, 225>, <105, 212>, <114, 201>, <127, 192>, <139, 188>, <144, 186>, <144, 184>, <134, 180>, <124, 174>, <115, 164>, <110, 151>, <109, 140>, <115, 125>, <123, 115>, <136, 108>, <153, 102>, <173, 100>,
   <167, 107>, <179, 107>, <191, 109>, <199, 113>, <206, 119>, <210, 129>, <210, 142>, <206, 151>, <200, 158>, <189, 166>, <183, 168>, <168, 165>, <155, 160>, <144, 153>, <136, 142>, <135, 129>, <141, 120>, <150, 113>, <160, 109>, <167, 107>,
   <167, 190>, <191, 194>, <206, 200>, <217, 208>, <223, 222>, <223, 231>, <219, 243>, <208, 253>, <193, 259>, <177, 261>, <162, 259>, <147, 254>, <136, 244>, <132, 232>, <132, 220>, <136, 210>, <143, 200>, <154, 193>, <162, 190>, <167, 190>
   scale <0.007, 0.1, 0.007>
   rotate x*90
   translate <-0.730116, 1.90038, -1.1001>
   rotate z*(-2)
}

#declare Ziffer_9 = prism {
   linear_spline
   linear_sweep
   0, 1,
   84,
   <160, 96>, <179, 98>, <194, 103>, <209, 111>, <221, 123>, <228, 132>, <234, 144>, <239, 157>, <242, 177>, <241, 190>, <238, 205>, <232, 220>, <223, 234>, <210, 247>, <195, 257>, <177, 263>, <156, 266>, <138, 265>, <119, 262>, <107, 258>, <105, 255>, <106, 249>, <110, 230>, <112, 228>, <115, 230>, <118, 238>, <123, 244>, <132, 252>, <145, 258>, <160, 259>, <175, 256>, <188, 249>, <197, 240>, <205, 228>, <209, 211>, <210, 193>, <209, 179>, <208, 176>, <206, 177>, <199, 188>, <189, 197>, <176, 204>, <162, 208>, <146, 209>, <134, 207>, <121, 203>, <109, 197>, <97, 187>, <89, 174>, <86, 160>, <88, 148>, <92, 136>, <99, 125>, <107, 116>, <118, 109>, <128, 103>, <145, 98>, <160, 96>,
   <160, 104>, <169, 104>, <179, 107>, <189, 114>, <196, 124>, <200, 132>, <203, 144>, <203, 155>, <202, 166>, <198, 176>, <191, 187>, <183, 194>, <171, 199>, <159, 200>, <149, 199>, <137, 194>, <127, 183>, <121, 170>, <119, 154>, <120, 139>, <123, 129>, <129, 118>, <137, 111>, <145, 106>, <155, 104>, <160, 104>
   scale <0.007, 0.1, 0.007>
   rotate x*90
   translate <-0.624276, 1.877, -1.1001>
   rotate z*(-1.4)
}

#declare Zeitskala = union {
   union {
      //*PMName Striche
      //*PMRawBegin
      #declare N = 0;
      #while (N < 13)
         box {<-0.05,3.7,-1><0.05,3.9,-1.1001>
              rotate -N*360/13*z
              }
         #declare M = 1;
         #while (M < 5)
            box{<-0.01,3.7,-1><0.01,3.9,-1.1001>
               rotate (-N*360/13-M*360/13/5)*z
               }
            #declare M = M+1;
         #end
         #declare N = N+1;
      #end
      //*PMRawEnd
      
      pigment {
         color rgb <0, 0, 0>
      }
   }
   
   union {
      //*PMName Leuchtstriche
      //*PMRawBegin
      #declare N = 0;
      #while (N < 13)
         box {<-0.025,3.725,-1><0.025,3.875,-1.1002>
              rotate -N*360/13*z
              }
         #declare N = N+1;
      #end
      //*PMRawEnd
      
      texture {
         Phosphor
      }
   }
   
   union {
      //*PMName Ziffern
      
      object {
         //*PMName 1
         Ziffer_1
         scale 1
         translate <1.25162, 2.14865, 0>
         rotate <0, 0, 0>
      }
      
      object {
         //*PMName 2
         Ziffer_2
         scale 1
         rotate <0, 0, 0>
         translate <1.91691, 1.31438, 0>
      }
      
      object {
         //*PMName 3
         Ziffer_3
         scale 1
         rotate <0, 0, 0>
         translate <2.55831, -0.187075, 0>
      }
      
      object {
         //*PMName 4
         Ziffer_4
         scale 1
         rotate <0, 0, 0>
         translate <2.29349, -1.56463, 0>
      }
      
      object {
         //*PMName 5
         Ziffer_5
         scale 1
         rotate <0, 0, 0>
         translate <1.59864, -2.71866, 0>
      }
      
      object {
         //*PMName 6
         Ziffer_6
         scale 1
         rotate <0, 0, 0>
         translate <0.085034, -3.56657, 0>
      }
      
      object {
         //*PMName 7
         Ziffer_7
         scale 1
         rotate <0, 0, 0>
         translate <-1.33382, -3.49368, 0>
      }
      
      object {
         //*PMName 8
         Ziffer_8
         scale 1
         rotate <0, 0, 0>
         translate <-2.5243, -2.81584, 0>
      }
      
      object {
         //*PMName 9
         Ziffer_9
         scale 1
         rotate <0, 0, 0>
         translate <-3.35277, -1.75413, 0>
      }
      
      union {
         //*PMName 10
         
         object {
            Ziffer_1
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         object {
            Ziffer_0
            scale 1
            rotate <0, 0, 0>
            translate x*0.4
         }
         translate <-3.63217, -0.364431, 0>
      }
      
      union {
         //*PMName 11
         
         object {
            Ziffer_1
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         object {
            Ziffer_1
            scale 1
            rotate <0, 0, 0>
            translate x*0.6
         }
         translate <-3.03693, 0.983965, 0>
      }
      
      union {
         //*PMName 12
         
         object {
            Ziffer_1
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         object {
            Ziffer_2
            scale 1
            rotate <0, 0, 0>
            translate x*0.5
         }
         translate <-2.01652, 1.99223, 0>
      }
      
      union {
         //*PMName 13
         
         object {
            Ziffer_1
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         object {
            Ziffer_3
            scale 1
            rotate <0, 0, 0>
            translate x*0.4
         }
         translate <-0.5345, 2.4174, 0>
      }
      
      pigment {
         color rgb <0, 0, 0>
      }
   }
   translate z*1.1002
}

#declare Zeitskala2 = union {
   union {
      //*PMName Striche
      //*PMRawBegin
      #declare N = 0;
      #while (N < 13)
         box {<-0.05,3.7,-1><0.05,3.9,-1.1001>
              rotate -N*360/13*z
              }
         #declare M = 1;
         #while (M < 5)
            box{<-0.01,3.7,-1><0.01,3.9,-1.1001>
               rotate (-N*360/13-M*360/13/5)*z
               }
            #declare M = M+1;
         #end
         #declare N = N+1;
      #end
      //*PMRawEnd
      
      pigment {
         color rgb <0, 0, 0>
      }
   }
   
   union {
      //*PMName Leuchtstriche
      //*PMRawBegin
      #declare N = 0;
      #while (N < 13)
         box {<-0.025,3.725,-1><0.025,3.875,-1.1002>
              rotate -N*360/13*z
              }
         #declare N = N+1;
      #end
      //*PMRawEnd
      
      texture {
         Phosphor
      }
   }
   
   union {
      //*PMName Ziffern
      
      object {
         //*PMName 1
         Ziffer_1
         scale 1
         translate <1.25162, 2.14865, 0>
         rotate <0, 0, 0>
      }
      
      object {
         //*PMName 2
         Ziffer_2
         scale 1
         rotate <0, 0, 0>
         translate <1.91691, 1.31438, 0>
      }
      
      object {
         //*PMName 3
         Ziffer_3
         scale 1
         rotate <0, 0, 0>
         translate <2.55831, -0.187075, 0>
      }
      
      object {
         //*PMName 4
         Ziffer_4
         scale 1
         rotate <0, 0, 0>
         translate <2.29349, -1.56463, 0>
      }
      
      object {
         //*PMName 5
         Ziffer_5
         scale 1
         rotate <0, 0, 0>
         translate <1.59864, -2.71866, 0>
      }
      
      object {
         //*PMName 6
         Ziffer_6
         scale 1
         rotate <0, 0, 0>
         translate <0.085034, -3.56657, 0>
      }
      
      object {
         //*PMName 7
         Ziffer_7
         scale 1
         rotate <0, 0, 0>
         translate <-1.33382, -3.49368, 0>
      }
      
      object {
         //*PMName 8
         Ziffer_8
         scale 1
         rotate <0, 0, 0>
         translate <-2.5243, -2.81584, 0>
      }
      
      object {
         //*PMName 9
         Ziffer_9
         scale 1
         rotate <0, 0, 0>
         translate <-3.35277, -1.75413, 0>
      }
      
      union {
         //*PMName 10
         
         object {
            Ziffer_1
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         object {
            Ziffer_0
            scale 1
            rotate <0, 0, 0>
            translate x*0.4
         }
         translate <-3.63217, -0.364431, 0>
      }
      
      union {
         //*PMName 11
         
         object {
            Ziffer_1
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         object {
            Ziffer_1
            scale 1
            rotate <0, 0, 0>
            translate x*0.6
         }
         translate <-3.03693, 0.983965, 0>
      }
      
      union {
         //*PMName 12
         
         object {
            Ziffer_1
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         object {
            Ziffer_2
            scale 1
            rotate <0, 0, 0>
            translate x*0.5
         }
         translate <-2.01652, 1.99223, 0>
      }
      
      union {
         //*PMName 13
         
         object {
            Ziffer_1
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         object {
            Ziffer_3
            scale 1
            rotate <0, 0, 0>
            translate x*0.4
         }
         translate <-0.5345, 2.4174, 0>
      }
      
      texture {
         grosse_ziffern
      }
   }
   translate z*1.1002
}

#declare Stundenzeiger = union {
   prism {
      linear_spline
      linear_sweep
      0, 1,
      116,
      <204, 301>, <209, 294>, <213, 280>, <212, 263>, <208, 255>, <203, 246>, <198, 240>, <185, 232>, <173, 229>, <163, 229>, <150, 232>, <140, 238>, <136, 237>, <132, 234>, <44, 174>, <43, 171>, <43, 163>, <40, 150>, <34, 139>, <25, 129>, <17, 124>, <6, 121>, <-8, 119>, <-22, 119>, <-32, 118>, <-44, 116>, <-56, 113>, <-70, 107>, <-82, 100>, <-92, 93>, <-96, 93>, <-96, 95>, <-96, 97>, <-85, 105>, <-80, 109>, <-71, 117>, <-58, 132>, <-49, 147>, <-41, 169>, <-35, 180>, <-25, 191>, <-15, 196>, <-1, 200>, <12, 200>, <22, 197>, <27, 195>, <31, 196>, <121, 257>, <124, 261>, <122, 272>, <122, 280>, <124, 289>, <128, 298>, <135, 306>, <144, 314>, <154, 318>, <167, 320>, <179, 318>, <190, 314>, <200, 307>, <204, 301>,
      <-49, 125>, <-26, 127>, <-21, 145>, <-40, 146>, <-49, 125>,
      <-17, 129>, <-6, 128>, <3, 129>, <12, 132>, <20, 137>, <26, 143>, <30, 150>, <32, 155>, <24, 157>, <20, 157>, <14, 156>, <6, 154>, <-2, 150>, <-8, 145>, <-13, 139>, <-16, 133>, <-17, 129>,
      <-35.9443, 155.658>, <-27.7185, 155.32>, <-18.286, 156.888>, <-8.92151, 160.957>, <-1.10902, 166.694>, <3.00959, 172.322>, <7, 180>, <9.14232, 189.063>, <1.34625, 188.562>, <-3.39919, 188.188>, <-9.14554, 187.679>, <-16.6373, 184.797>, <-23.0575, 179.958>, <-27.802, 174.721>, <-30.7322, 169.492>, <-33.9694, 162.237>, <-35.9443, 155.658>,
      <12, 167>, <19, 189>, <25, 186>, <29, 183>, <60, 205>, <64, 199>, <33, 178>, <35, 173>, <36, 168>, <12, 167>,
      <77, 207>, <72, 214>, <102, 234>, <108, 233>, <107, 227>, <77, 207>
      
      texture {
         Dunkles_Metall
      }
   }
   
   prism {
      linear_spline
      linear_sweep
      0, 1,
      55,
      <-49, 125>, <-26, 127>, <-21, 145>, <-40, 146>, <-49, 125>,
      <-17, 129>, <-6, 128>, <3, 129>, <12, 132>, <20, 137>, <26, 143>, <30, 150>, <32, 155>, <24, 157>, <20, 157>, <14, 156>, <6, 154>, <-2, 150>, <-8, 145>, <-13, 139>, <-16, 133>, <-17, 129>,
      <-35.944, 155.66>, <-27.718, 155.32>, <-18.286, 156.89>, <-8.9215, 160.96>, <-1.109, 166.69>, <3.0096, 172.32>, <7, 180>, <9.1423, 189.06>, <1.3462, 188.56>, <-3.3992, 188.19>, <-9.1455, 187.68>, <-16.637, 184.8>, <-23.058, 179.96>, <-27.802, 174.72>, <-30.732, 169.49>, <-33.969, 162.24>, <-35.944, 155.66>,
      <12, 167>, <19, 189>, <25, 186>, <29, 183>, <60, 205>, <64, 199>, <33, 178>, <35, 173>, <36, 168>, <12, 167>,
      <77, 207>, <72, 214>, <102, 234>, <108, 233>, <107, 227>, <77, 207>
      
      texture {
         Phosphor
      }
   }
   scale <0.009, 0.1, 0.009>
   rotate x*90
   translate <-1.5199, 2.4749, -1.36>
   rotate z*(-55.6)
}

#declare Weckzeiger = union {
   cylinder {
      <0, 0, 0>, <0, 1, 0>, 45
      scale 1
      rotate <0, 0, 0>
   }
   
   box {
      <-6.5, 0, 13>, <6.5, 1, 350>
      scale 1
      rotate <0, 0, 0>
   }
   scale <0.009, 0.1, 0.009>
   rotate x*(-90)
   translate z*(-1.125)
   rotate <0, 0, 0>
   
   texture {
      Dunkles_Metall
   }
}

#declare Minutenzeiger = union {
   prism {
      linear_spline
      linear_sweep
      0, 1,
      43,
      <-32, 236>, <260, 273>, <271, 286>, <336, 296>, <339, 300>, <335, 303>, <270, 295>, <255, 305>, <-35, 262>, <-42, 273>, <-53, 282>, <-69, 287>, <-84, 286>, <-94, 282>, <-103, 275>, <-109, 268>, <-115, 254>, <-115, 235>, <-107, 218>, <-95, 208>, <-82, 203>, <-66, 202>, <-53, 207>, <-41, 217>, <-34, 228>, <-32, 236>,
      <-12, 251>, <-5, 246>, <73, 256>, <71, 271>, <-7, 259>, <-12, 251>,
      <80, 257>, <165, 268>, <163, 284>, <78, 272>, <80, 257>,
      <174, 269>, <253, 279>, <262, 290>, <251, 298>, <172, 285>, <174, 269>
      
      texture {
         Dunkles_Metall
      }
   }
   
   prism {
      linear_spline
      linear_sweep
      0, 1,
      17,
      <-12, 251>, <-5, 246>, <73, 256>, <71, 271>, <-7, 259>, <-12, 251>,
      <80, 257>, <165, 268>, <163, 284>, <78, 272>, <80, 257>,
      <174, 269>, <253, 279>, <262, 290>, <251, 298>, <172, 285>, <174, 269>
      
      texture {
         Phosphor
      }
   }
   scale <0.009, 0.1, 0.009>
   rotate x*90
   translate <0.654758, 2.19407, -1.5>
   rotate z*97.8
}

#declare Stundenzeiger2 = union {
   prism {
      linear_spline
      linear_sweep
      0, 1,
      116,
      <204, 301>, <209, 294>, <213, 280>, <212, 263>, <208, 255>, <203, 246>, <198, 240>, <185, 232>, <173, 229>, <163, 229>, <150, 232>, <140, 238>, <136, 237>, <132, 234>, <44, 174>, <43, 171>, <43, 163>, <40, 150>, <34, 139>, <25, 129>, <17, 124>, <6, 121>, <-8, 119>, <-22, 119>, <-32, 118>, <-44, 116>, <-56, 113>, <-70, 107>, <-82, 100>, <-92, 93>, <-96, 93>, <-96, 95>, <-96, 97>, <-85, 105>, <-80, 109>, <-71, 117>, <-58, 132>, <-49, 147>, <-41, 169>, <-35, 180>, <-25, 191>, <-15, 196>, <-1, 200>, <12, 200>, <22, 197>, <27, 195>, <31, 196>, <121, 257>, <124, 261>, <122, 272>, <122, 280>, <124, 289>, <128, 298>, <135, 306>, <144, 314>, <154, 318>, <167, 320>, <179, 318>, <190, 314>, <200, 307>, <204, 301>,
      <-49, 125>, <-26, 127>, <-21, 145>, <-40, 146>, <-49, 125>,
      <-17, 129>, <-6, 128>, <3, 129>, <12, 132>, <20, 137>, <26, 143>, <30, 150>, <32, 155>, <24, 157>, <20, 157>, <14, 156>, <6, 154>, <-2, 150>, <-8, 145>, <-13, 139>, <-16, 133>, <-17, 129>,
      <-35.9443, 155.658>, <-27.7185, 155.32>, <-18.286, 156.888>, <-8.92151, 160.957>, <-1.10902, 166.694>, <3.00959, 172.322>, <7, 180>, <9.14232, 189.063>, <1.34625, 188.562>, <-3.39919, 188.188>, <-9.14554, 187.679>, <-16.6373, 184.797>, <-23.0575, 179.958>, <-27.802, 174.721>, <-30.7322, 169.492>, <-33.9694, 162.237>, <-35.9443, 155.658>,
      <12, 167>, <19, 189>, <25, 186>, <29, 183>, <60, 205>, <64, 199>, <33, 178>, <35, 173>, <36, 168>, <12, 167>,
      <77, 207>, <72, 214>, <102, 234>, <108, 233>, <107, 227>, <77, 207>
      
      texture {
         Helles_Metall
      }
   }
   
   prism {
      linear_spline
      linear_sweep
      0, 1,
      55,
      <-49, 125>, <-26, 127>, <-21, 145>, <-40, 146>, <-49, 125>,
      <-17, 129>, <-6, 128>, <3, 129>, <12, 132>, <20, 137>, <26, 143>, <30, 150>, <32, 155>, <24, 157>, <20, 157>, <14, 156>, <6, 154>, <-2, 150>, <-8, 145>, <-13, 139>, <-16, 133>, <-17, 129>,
      <-35.944, 155.66>, <-27.718, 155.32>, <-18.286, 156.89>, <-8.9215, 160.96>, <-1.109, 166.69>, <3.0096, 172.32>, <7, 180>, <9.1423, 189.06>, <1.3462, 188.56>, <-3.3992, 188.19>, <-9.1455, 187.68>, <-16.637, 184.8>, <-23.058, 179.96>, <-27.802, 174.72>, <-30.732, 169.49>, <-33.969, 162.24>, <-35.944, 155.66>,
      <12, 167>, <19, 189>, <25, 186>, <29, 183>, <60, 205>, <64, 199>, <33, 178>, <35, 173>, <36, 168>, <12, 167>,
      <77, 207>, <72, 214>, <102, 234>, <108, 233>, <107, 227>, <77, 207>
      
      texture {
         Phosphor
      }
   }
   scale <0.009, 0.1, 0.009>
   rotate x*90
   translate <-1.5199, 2.4749, -1.36>
   rotate z*(-55.6)
}

#declare Weckzeiger2 = union {
   cylinder {
      <0, 0, 0>, <0, 1, 0>, 45
      scale 1
      rotate <0, 0, 0>
   }
   
   box {
      <-6.5, 0, 13>, <6.5, 1, 350>
      scale 1
      rotate <0, 0, 0>
   }
   scale <0.009, 0.1, 0.009>
   rotate x*(-90)
   translate z*(-1.125)
   rotate <0, 0, 0>
   
   texture {
      Helles_Metall
   }
}

#declare Minutenzeiger2 = union {
   prism {
      linear_spline
      linear_sweep
      0, 1,
      43,
      <-32, 236>, <260, 273>, <271, 286>, <336, 296>, <339, 300>, <335, 303>, <270, 295>, <255, 305>, <-35, 262>, <-42, 273>, <-53, 282>, <-69, 287>, <-84, 286>, <-94, 282>, <-103, 275>, <-109, 268>, <-115, 254>, <-115, 235>, <-107, 218>, <-95, 208>, <-82, 203>, <-66, 202>, <-53, 207>, <-41, 217>, <-34, 228>, <-32, 236>,
      <-12, 251>, <-5, 246>, <73, 256>, <71, 271>, <-7, 259>, <-12, 251>,
      <80, 257>, <165, 268>, <163, 284>, <78, 272>, <80, 257>,
      <174, 269>, <253, 279>, <262, 290>, <251, 298>, <172, 285>, <174, 269>
      
      texture {
         Helles_Metall
      }
   }
   
   prism {
      linear_spline
      linear_sweep
      0, 1,
      17,
      <-12, 251>, <-5, 246>, <73, 256>, <71, 271>, <-7, 259>, <-12, 251>,
      <80, 257>, <165, 268>, <163, 284>, <78, 272>, <80, 257>,
      <174, 269>, <253, 279>, <262, 290>, <251, 298>, <172, 285>, <174, 269>
      
      texture {
         Phosphor
      }
   }
   scale <0.009, 0.1, 0.009>
   rotate x*90
   translate <0.654758, 2.19407, -1.5>
   rotate z*97.8
}

#declare Kloeppel = union {
   //*PMName Klppel
   
   cylinder {
      <0, 0, 0>, <0, 5.5, 0>, 0.04
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   cylinder {
      <0, 0, -0.1>, <0, 0, 0.1>, 0.5
      scale 1
      rotate <0, 0, 0>
      translate y*5.99
   }
}

#declare Glocke = difference {
   merge {
      cylinder {
         <0, 0, 0>, <0, 0.5, 0>, 2.2
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      sphere {
         <0, 0, 0>, 2.2
         scale <1, 0.4, 1>
         rotate <0, 0, 0>
         translate y*0.5
      }
      
      cylinder {
         <0, -0.1, 0>, <0, 0.5, 0>, 0.2
         scale 1
         translate y*1.4
         rotate <0, 0, 0>
      }
      
      sphere {
         <0, 0, 0>, 0.2
         scale <1, 0.2, 1>
         translate y*1.9
         rotate <0, 0, 0>
      }
   }
   
   sphere {
      <0, 0, 0>, 2.1
      scale <1, 0.55, 1>
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
}

#declare Wecker = union {
   //*PMName Wecker
   
   difference {
      //*PMName Korpus
      
      union {
         //*PMName Korpus
         
         difference {
            cylinder {
               <0, 0, -2>, <0, 0, 2>, 4.5
               scale 1
               rotate <0, 0, 0>
               translate <0, 0, 0>
            }
            
            cylinder {
               <0, 0, -2.01>, <0, 0, 2.01>, 4.1
               scale 1
               rotate <0, 0, 0>
               translate <0, 0, 0>
            }
            
            cylinder {
               <0, 0, -1.8>, <0, 0, 2.01>, 4.45
               scale 1
               rotate <0, 0, 0>
               translate <0, 0, 0>
            }
         }
         
         torus {
            4.3, 0.2
            scale 1
            rotate x*90
            translate z*(-2)
         }
         
         torus {
            3.85, 0.6
            scale 1
            rotate x*90
            translate z*2
         }
         
         cylinder {
            <0, 0, 2.6>, <0, 0, 2.5>, 3.9
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
      }
      
      box {
         <-0.5, -4, -0.25>, <0.5, 0.1, 0.25>
         scale 1
         rotate <0, 0, 0>
         translate <0, 4.5, 1.65>
      }
      
      cylinder {
         <0, 0, -0.1>, <0, 0, 0.1>, 0.3
         scale 1
         rotate <0, 0, 0>
         translate z*2.55
      }
      
      cylinder {
         <0, 0, -0.1>, <0, 0, 0.1>, 0.3
         scale 1
         rotate <0, 0, 0>
         translate <0, 1.5, 2.55>
      }
      
      cylinder {
         <0, 0, -0.1>, <0, 0, 0.1>, 0.3
         scale 1
         rotate <0, 0, 0>
         translate <1.5, 0.5, 2.55>
      }
      
      cylinder {
         <0, 0, -0.1>, <0, 0, 0.1>, 0.3
         scale 1
         rotate <0, 0, 0>
         translate <-1.5, 0.5, 2.55>
      }
      
      difference {
         cylinder {
            <0, 0, -0.1>, <0, 0, 0.1>, 1
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         cylinder {
            <0, 0, -0.1>, <0, 0, 0.1>, 0.8
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         sphere {
            <0, 0, 0>, 1
            scale <1, 0.5, 1>
            rotate <0, 0, 0>
            translate y*0.6
            inverse
         }
         translate <0.5, -2.5, 2.55>
      }
   }
   
   union {
      //*PMName Klingelapparat
      
      union {
         //*PMName Klingelhalter
         
         difference {
            //*PMName Mittelstck
            
            cylinder {
               <0, 0, 0>, <0, 0, 1.2>, 4.6
               scale 1
               rotate <0, 0, 0>
               translate <0, 0, 0>
            }
            
            cylinder {
               <0, 0, -0.01>, <0, 0, 1.21>, 4.53
               scale 1
               rotate <0, 0, 0>
               translate <0, 0, 0>
            }
            
            plane {
               <-1, 0, 0>, 0
               scale 1
               translate y*4.5
               rotate z*(-25)
            }
            
            plane {
               <1, 0, 0>, 0
               scale 1
               translate y*4.5
               rotate z*25
            }
         }
         
         box {
            <-0.025, 0, 0>, <0.025, 2, 1.2>
            scale 1
            translate y*4.55
            rotate z*(-25)
         }
         
         box {
            <-0.025, 0, 0>, <0.025, 2, 1.2>
            scale 1
            translate y*4.55
            rotate z*25
         }
      }
      
      object {
         //*PMName Glocke
         Glocke
         scale 1
         translate <0, 5.5, 0.6>
         rotate z*(-30)
      }
      
      union {
         //*PMName Glocke durchsichtig
         
         object {
            //*PMName Glocke
            Glocke
            rotate <-0, 0.2, 0.9>
            scale 1.7
            translate <0.499955, 8.75726, 0.192811>
            rotate z*(-30)
         }
         
         object {
            //*PMName Glocke
            Glocke
            rotate <1.7, -2.1, -17>
            scale 1.3
            translate <0.360099, 6.69815, 0.464173>
            rotate z*(-30)
         }
         
         texture {
            Messing_durchsichtig
         }
      }
      
      object {
         //*PMName Glocke
         Glocke
         scale 1
         translate <0, 5.5, 0.6>
         rotate z*30
      }
      
      union {
         //*PMName Glocke durchsichtig
         
         object {
            //*PMName Glocke
            Glocke
            rotate <-0.7, -1.7, -11.6>
            scale 1.7
            translate <-0.502144, 9.1375, 0.140834>
            rotate z*30
         }
         
         object {
            //*PMName Glocke
            Glocke
            rotate <-0.3, -0.6, -4.4>
            scale 1.3
            translate <-0.20944, 6.94631, 0.418202>
            rotate z*30
         }
         
         texture {
            Messing_durchsichtig
         }
      }
      
      union {
         //*PMName Feststeller
         
         cylinder {
            <0, 0, 0>, <0, 0.05, 0>, 0.6
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         box {
            <-0.2, 0.05, 0>, <0.2, 0, -2.9>
            scale 1
            translate <0, 0, 0>
         }
         
         cylinder {
            <0, 0, -0.6>, <0, 0, -2.5>, 0.05
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         box {
            <-0.2, 0, 0>, <0.2, 0.5, 0.2>
            scale 1
            translate z*(-2.9)
         }
         
         box {
            <-0.06, 0.05, 0.35>, <0.06, 0, 1.2>
            rotate x*(-1)
            scale 1
            translate x*(-0.4)
         }
         rotate y*(-34)
         translate <0, 4.6, 0.6>
      }
      
      difference {
         //*PMName Schraube
         
         union {
            cylinder {
               <0, -0.1, 0>, <0, 0.05, 0>, 0.3
               scale 1
               rotate <0, 0, 0>
               translate <0, 0, 0>
            }
            
            sphere {
               <0, 0, 0>, 0.3
               scale <1, 0.3, 1>
               rotate <0, 0, 0>
               translate y*0.05
            }
         }
         
         box {
            <-0.31, -0.025, -0.04>, <0.31, 0.1, 0.04>
            scale 1
            rotate y*(-15)
            translate y*0.05
         }
         translate <0, 4.65, 0.6>
      }
      
      union {
         //*PMName Klppel
         
         object {
            Kloeppel
            scale 1
            translate <0, 0, 0>
            rotate z*(-5.1)
         }
         
         object {
            Kloeppel
            scale <1, 1, 1.001>
            rotate z*(-4.001)
            translate <0, 0, 0>
         }
         
         object {
            Kloeppel
            scale <1, 1, 0.999>
            translate <0, 0, 0>
            rotate z*(-0.2)
         }
         
         object {
            Kloeppel
            scale 1
            translate <0, 0, 0>
            rotate z*4.5
         }
         
         object {
            Kloeppel
            scale <1, 1, 1.002>
            translate <0, 0, 0>
            rotate z*5.1
         }
         
         texture {
            Messing_durchsichtig
         }
         scale 1.7
         translate z*1.65
      }
      
      union {
         //*PMName Griffansatz
         
         cylinder {
            <0, -0.025, 0>, <0, 0.1, 0>, 0.21
            scale <2, 1, 1>
            translate <0, 6.9, 0.6>
            rotate z*(-30)
         }
         
         cylinder {
            <0, -0.025, 0>, <0, 0.1, 0>, 0.21
            scale <2, 1, 1>
            translate <0, 6.9, 0.6>
            rotate z*30
         }
      }
      
      union {
         //*PMName Griffbgel
         
         difference {
            //*PMName Mittelstck
            
            torus {
               8.5, 0.15
               scale 1
               rotate x*90
               translate z*0.6
            }
            
            plane {
               <1, 0, 0>, 0
               scale 1
               translate y*8.5
               rotate z*15
            }
            
            plane {
               <-1, 0, 0>, 0
               scale 1
               translate y*8.5
               rotate z*(-15)
            }
         }
         
         difference {
            torus {
               1, 0.15
               scale 1
               rotate x*90
               translate <0, 7.5, 0.6>
            }
            
            plane {
               <-1, 0, 0>, 0
               scale 1
               translate y*8.5
            }
            
            plane {
               <1, 0, 0>, 0
               scale 1
               translate y*1
               rotate z*80
               translate y*7.5
            }
            rotate z*15
         }
         
         difference {
            torus {
               1, 0.15
               scale 1
               rotate x*90
               translate <0, 7.5, 0.6>
            }
            
            plane {
               <1, 0, 0>, 0
               scale 1
               translate y*8.5
            }
            
            plane {
               <-1, 0, 0>, 0
               scale 1
               translate y*1
               rotate z*(-80)
               translate y*7.5
            }
            rotate z*(-15)
         }
         
         difference {
            torus {
               1, 0.15
               scale 1
               rotate x*90
            }
            
            plane {
               <1, 0, 0>, 0
               scale 1
               translate x*0.7
               rotate z*(-10)
            }
            
            plane {
               <1, 0, 0>, 0
               scale 1
               translate y*1
               rotate z*(-90)
            }
            translate x*(-2)
            rotate z*(-10)
            translate <0, 7.5, 0.6>
            rotate z*15
         }
         
         difference {
            torus {
               1, 0.15
               scale 1
               rotate x*90
            }
            
            plane {
               <-1, 0, 0>, 0
               scale 1
               translate x*(-0.7)
               rotate z*10
            }
            
            plane {
               <-1, 0, 0>, 0
               scale 1
               translate y*1
               rotate z*90
            }
            translate x*2
            rotate z*10
            translate <0, 7.5, 0.6>
            rotate z*(-15)
         }
         translate y*(-0.15)
      }
   }
   
   union {
      //*PMName Drehknpfe
      
      cylinder {
         <0, 0, 0>, <0, 0, 3>, 0.2
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      cylinder {
         <0, 0, 2.9>, <0, 0, 3.6>, 0.3
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      cylinder {
         <0, 0, 0>, <0, 0, 3>, 0.2
         scale 1
         rotate <0, 0, 0>
         translate y*1.5
      }
      
      cylinder {
         <0, 0, 2.9>, <0, 0, 3.6>, 0.3
         scale 1
         rotate <0, 0, 0>
         translate y*1.5
      }
      
      cylinder {
         <0, 0, 0>, <0, 0, 3.7>, 0.2
         scale 1
         rotate <0, 0, 0>
         translate <1.5, 0.5, 0>
      }
      
      box {
         <-1, -0.025, 3.1>, <1, 0.025, 3.9>
         scale 1
         rotate z*30
         translate <1.5, 0.5, 0>
      }
      
      cylinder {
         <0, 0, 0>, <0, 0, 3.7>, 0.2
         scale 1
         rotate <0, 0, 0>
         translate <-1.5, 0.5, 0>
      }
      
      box {
         <-1, -0.025, 3.1>, <1, 0.025, 3.9>
         scale 1
         rotate z*115
         translate <-1.5, 0.5, 0>
      }
   }
   
   union {
      //*PMName Stnder
      
      cylinder {
         <0, 0.1, 0>, <0, -1.4, 0>, 0.2
         scale 1
         translate <0, -4.5, -0.5>
         rotate z*30
      }
      
      cylinder {
         <0, 0.1, 0>, <0, -1.4, 0>, 0.2
         scale 1
         translate <0, -4.5, -0.5>
         rotate z*(-30)
      }
      
      difference {
         cylinder {
            <0, 0, -0.9>, <0, 0, 3.7>, 4.6
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         cylinder {
            <0, 0, -0.71>, <0, 0, 3.71>, 4.53
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         plane {
            <-1, 0, 0>, 0
            scale 1
            translate y*4.5
            rotate z*(-215)
         }
         
         plane {
            <1, 0, 0>, 0
            scale 1
            translate y*4.5
            rotate z*215
         }
         
         box {
            <0, -0.5, 0>, <4, 0.5, 4>
            scale 1
            rotate z*25
            translate y*(-4.6)
            rotate z*5
         }
         
         box {
            <0, -0.5, 0>, <-4, 0.5, 4>
            scale 1
            rotate z*(-25)
            translate y*(-4.6)
            rotate z*(-5)
         }
      }
   }
   
   union {
      //*PMName Ziffernblatt
      
      difference {
         //*PMName Rahmen
         
         cylinder {
            <0, 0, -1>, <0, 0, -2>, 4.4
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         cylinder {
            <0, 0, -0.99>, <0, 0, -2.01>, 4.099
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
      }
      
      cylinder {
         //*PMName Scheibe
         <0, 0, -1.9>, <0, 0, -2>, 4.21
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
         
         texture {
            Plaste_durchsichtig
         }
      }
      
      cylinder {
         //*PMName Blatt
         <0, 0, -0.9>, <0, 0, -1.1>, 4.2
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      union {
         //*PMName Striche
         //*PMRawBegin
         #declare N = 0;
         #while (N < 13)
            box {<-0.05,3.7,-1><0.05,3.9,-1.1001>
                 rotate -N*360/13*z
                 }
            #declare M = 1;
            #while (M < 5)
               box{<-0.01,3.7,-1><0.01,3.9,-1.1001>
                  rotate (-N*360/13-M*360/13/5)*z
                  }
               #declare M = M+1;
            #end
            #declare N = N+1;
         #end
         //*PMRawEnd
         
         pigment {
            color rgb <0, 0, 0>
         }
      }
      
      union {
         //*PMName Leuchtstriche
         //*PMRawBegin
         #declare N = 0;
         #while (N < 13)
            box {<-0.025,3.725,-1><0.025,3.875,-1.1002>
                 rotate -N*360/13*z
                 }
            #declare N = N+1;
         #end
         //*PMRawEnd
         
         texture {
            Phosphor
         }
      }
      
      union {
         //*PMName Ziffern
         
         object {
            //*PMName 1
            Ziffer_1
            scale 1
            translate <1.25162, 2.14865, 0>
            rotate <0, 0, 0>
         }
         
         object {
            //*PMName 2
            Ziffer_2
            scale 1
            rotate <0, 0, 0>
            translate <1.91691, 1.31438, 0>
         }
         
         object {
            //*PMName 3
            Ziffer_3
            scale 1
            rotate <0, 0, 0>
            translate <2.55831, -0.187075, 0>
         }
         
         object {
            //*PMName 4
            Ziffer_4
            scale 1
            rotate <0, 0, 0>
            translate <2.29349, -1.56463, 0>
         }
         
         object {
            //*PMName 5
            Ziffer_5
            scale 1
            rotate <0, 0, 0>
            translate <1.59864, -2.71866, 0>
         }
         
         object {
            //*PMName 6
            Ziffer_6
            scale 1
            rotate <0, 0, 0>
            translate <0.085034, -3.56657, 0>
         }
         
         object {
            //*PMName 7
            Ziffer_7
            scale 1
            rotate <0, 0, 0>
            translate <-1.33382, -3.49368, 0>
         }
         
         object {
            //*PMName 8
            Ziffer_8
            scale 1
            rotate <0, 0, 0>
            translate <-2.5243, -2.81584, 0>
         }
         
         object {
            //*PMName 9
            Ziffer_9
            scale 1
            rotate <0, 0, 0>
            translate <-3.35277, -1.75413, 0>
         }
         
         union {
            //*PMName 10
            
            object {
               Ziffer_1
               scale 1
               rotate <0, 0, 0>
               translate <0, 0, 0>
            }
            
            object {
               Ziffer_0
               scale 1
               rotate <0, 0, 0>
               translate x*0.4
            }
            translate <-3.63217, -0.364431, 0>
         }
         
         union {
            //*PMName 11
            
            object {
               Ziffer_1
               scale 1
               rotate <0, 0, 0>
               translate <0, 0, 0>
            }
            
            object {
               Ziffer_1
               scale 1
               rotate <0, 0, 0>
               translate x*0.6
            }
            translate <-3.03693, 0.983965, 0>
         }
         
         union {
            //*PMName 12
            
            object {
               Ziffer_1
               scale 1
               rotate <0, 0, 0>
               translate <0, 0, 0>
            }
            
            object {
               Ziffer_2
               scale 1
               rotate <0, 0, 0>
               translate x*0.5
            }
            translate <-2.01652, 1.99223, 0>
         }
         
         union {
            //*PMName 13
            
            object {
               Ziffer_1
               scale 1
               rotate <0, 0, 0>
               translate <0, 0, 0>
            }
            
            object {
               Ziffer_3
               scale 1
               rotate <0, 0, 0>
               translate x*0.4
            }
            translate <-0.5345, 2.4174, 0>
         }
         
         pigment {
            color rgb <0, 0, 0>
         }
      }
      
      texture {
         weisse_Plaste
      }
   }
   
   union {
      //*PMName Zeiger
      
      cylinder {
         //*PMName Achse
         <0, 0, 0>, <0, 0, -1.58>, 0.05
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      object {
         //*PMName Stdzeiger
         Stundenzeiger
         scale 1
         rotate z*(-133)
         translate <0, 0, 0>
      }
      
      object {
         //*PMName Minzeiger
         Minutenzeiger
         scale 1
         rotate z*12.9
         translate <0, 0, 0>
      }
      
      object {
         //*PMName Weckzeiger
         Weckzeiger
         scale 1
         rotate z*(-133)
         translate <0, 0, 0>
      }
   }
   
   texture {
      Messing
   }
   rotate x*9
   translate y*5.1
}

#declare Haus = difference {
   union {
      box {
         <-1000, -20, -500>, <1000, 500, 500>
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      prism {
         linear_spline
         linear_sweep
         0, 1,
         4,
         <1, 1>, <0, 0>, <-1, 1>, <1, 1>
         rotate <90, 90, 0>
         translate <-0.5, 2, 0>
         scale <2000, 500, 500>
      }
   }
   
   box {
      <-580, 0, -480>, <380, 480, 480>
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
      
      texture {
         finish {
            ambient rgb <0.505882, 0.490196, 0.478431>
         }
         
         pigment {
            color rgb <1, 0.976471, 0.737255>
         }
      }
   }
   
   union {
      //*PMName Fenster oben
      
      box {
         //*PMName Fenster
         <-40, 0, -11>, <40, 80, 11>
         scale 1
         rotate <0, 0, 0>
         translate <-800, 350, 0>
      }
      
      box {
         //*PMName Fenster
         <-40, 0, -11>, <40, 80, 11>
         scale 1
         rotate <0, 0, 0>
         translate <-600, 350, 0>
      }
      
      box {
         //*PMName Fenster
         <-40, 0, -11>, <40, 80, 11>
         scale <1.5, 1, 1>
         rotate <0, 0, 0>
         translate <-300, 350, 0>
      }
      
      box {
         //*PMName Fenster
         <-40, 0, -11>, <40, 80, 11>
         scale <0.8, 1, 1>
         rotate <0, 0, 0>
         translate <-150, 350, 0>
      }
      
      box {
         //*PMName Fenster
         <-40, 0, -11>, <40, 80, 11>
         scale 1
         rotate <0, 0, 0>
         translate <200, 350, 0>
      }
      
      box {
         //*PMName Fenster
         <-40, 0, -11>, <40, 80, 11>
         scale <1.5, 1, 1>
         rotate <0, 0, 0>
         translate <400, 350, 0>
      }
      
      box {
         //*PMName Fenster
         <-40, 0, -11>, <40, 80, 11>
         scale 1
         rotate <0, 0, 0>
         translate <600, 350, 0>
      }
      
      box {
         //*PMName Fenster
         <-40, 0, -11>, <40, 80, 11>
         scale <0.5, 1, 1>
         rotate <0, 0, 0>
         translate <800, 350, 0>
      }
      
      box {
         //*PMName Fenster
         <-40, 0, -11>, <40, 80, 11>
         scale <0.5, 1, 1>
         rotate <0, 0, 0>
         translate <850, 350, 0>
      }
      
      box {
         //*PMName Fenster
         <-40, 0, -11>, <40, 80, 11>
         scale <0.5, 1, 1>
         rotate <0, 0, 0>
         translate <900, 350, 0>
      }
      translate z*(-490)
   }
   
   union {
      //*PMName Fenster unten
      
      box {
         //*PMName Fenster
         <-40, 0, -11>, <40, 80, 11>
         scale 1
         rotate <0, 0, 0>
         translate <-800, 150, 0>
      }
      
      box {
         //*PMName Fenster
         <-40, 0, -11>, <40, 80, 11>
         scale <1.5, 1, 1>
         rotate <0, 0, 0>
         translate <-300, 150, 0>
      }
      
      box {
         //*PMName Fenster
         <-40, 0, -11>, <40, 80, 11>
         scale <0.8, 1, 1>
         rotate <0, 0, 0>
         translate <-150, 150, 0>
      }
      
      box {
         //*PMName Fenster
         <-40, 0, -11>, <40, 80, 11>
         scale 1
         rotate <0, 0, 0>
         translate <200, 150, 0>
      }
      
      box {
         //*PMName Fenster
         <-40, 0, -11>, <40, 80, 11>
         scale <1.5, 1, 1>
         rotate <0, 0, 0>
         translate <630, 150, 0>
      }
      
      box {
         //*PMName Fenster
         <-40, 0, -11>, <40, 80, 11>
         scale 1
         rotate <0, 0, 0>
         translate <420, 150, 0>
      }
      
      box {
         //*PMName Fenster
         <-40, 0, -11>, <40, 80, 11>
         scale 1
         rotate <0, 0, 0>
         translate <870, 150, 0>
      }
      translate z*(-490)
   }
}

#declare Baum = merge {
   merge {
      // level 0 
      cone {
         <0, 0, 0>, 0.7787,
         <0, 0.0085, 0>, 0.77511
      }
      
      cone {
         <0, 0.0085, 0>, 0.77511,
         <0, 0.0169, 0>, 0.77161
      }
      
      cone {
         <0, 0.0169, 0>, 0.77161,
         <0, 0.0339, 0>, 0.76481
      }
      
      cone {
         <0, 0.0339, 0>, 0.76481,
         <0, 0.0677, 0>, 0.75207
      }
      
      cone {
         <0, 0.0677, 0>, 0.75207,
         <0, 0.1354, 0>, 0.72959
      }
      
      cone {
         <0, 0.1354, 0>, 0.72959,
         <0, 0.2708, 0>, 0.69427
      }
      
      cone {
         <0, 0.2708, 0>, 0.69427,
         <0, 0.5417, 0>, 0.64851
      }
      
      cone {
         <0, 0.5417, 0>, 0.64851,
         <0, 1.0833, 0>, 0.60017
      }
      
      cone {
         <0, 1.0833, 0>, 0.60017,
         <0, 2.1667, 0>, 0.54082
      }
      
      cone {
         <0, 2.1667, 0>, 0.54082,
         <0, 4.3333, 0>, 0.43247
      }
      
      sphere {
         <0, 4.3333, 0>, 0.43237
      }
      
      cone {
         <0, 4.3333, 0>, 0.43247,
         <0, 4.711, -4.3168>, 0.21623
      }
      
      sphere {
         <0, 4.711, -4.3168>, 0.21613
      }
      
      cone {
         <0, 4.711, -4.3168>, 0.21623,
         <0, 5.4635, -8.5843>, 0
      }
      
      sphere {
         <0, 5.4635, -8.5843>, -0.0001
      }
      
      merge {
         // level 1 
         cone {
            <0, 2.856, 0>, 0.30895,
            <0.1556, 2.8988, 0.5127>, 0.28964
         }
         
         sphere {
            <0.1556, 2.8988, 0.5127>, 0.28954
         }
         
         cone {
            <0.1556, 2.8988, 0.5127>, 0.28964,
            <0.3079, 3.0602, 1.0022>, 0.27033
         }
         
         sphere {
            <0.3079, 3.0602, 1.0022>, 0.27023
         }
         
         cone {
            <0.3079, 3.0602, 1.0022>, 0.27033,
            <0.445, 3.3252, 1.4492>, 0.25102
         }
         
         sphere {
            <0.445, 3.3252, 1.4492>, 0.25092
         }
         
         cone {
            <0.445, 3.3252, 1.4492>, 0.25102,
            <0.559, 3.6831, 1.8337>, 0.23171
         }
         
         sphere {
            <0.559, 3.6831, 1.8337>, 0.23161
         }
         
         cone {
            <0.559, 3.6831, 1.8337>, 0.23171,
            <0.6517, 4.1177, 2.1361>, 0.2124
         }
         
         sphere {
            <0.6517, 4.1177, 2.1361>, 0.2123
         }
         
         cone {
            <0.6517, 4.1177, 2.1361>, 0.2124,
            <0.888, 4.553, 2.3448>, 0.19309
         }
         
         sphere {
            <0.888, 4.553, 2.3448>, 0.19299
         }
         
         cone {
            <0.888, 4.553, 2.3448>, 0.19309,
            <1.0301, 5.0499, 2.4923>, 0.17378
         }
         
         sphere {
            <1.0301, 5.0499, 2.4923>, 0.17368
         }
         
         cone {
            <1.0301, 5.0499, 2.4923>, 0.17378,
            <1.0734, 5.5814, 2.5597>, 0.15447
         }
         
         sphere {
            <1.0734, 5.5814, 2.5597>, 0.15437
         }
         
         cone {
            <1.0734, 5.5814, 2.5597>, 0.15447,
            <1.1076, 6.1125, 2.6351>, 0.13516
         }
         
         sphere {
            <1.1076, 6.1125, 2.6351>, 0.13506
         }
         
         cone {
            <1.1076, 6.1125, 2.6351>, 0.13516,
            <1.1244, 6.6426, 2.7219>, 0.11586
         }
         
         sphere {
            <1.1244, 6.6426, 2.7219>, 0.11576
         }
         
         cone {
            <1.1244, 6.6426, 2.7219>, 0.11586,
            <1.1178, 7.1718, 2.8159>, 0.09655
         }
         
         sphere {
            <1.1178, 7.1718, 2.8159>, 0.09645
         }
         
         cone {
            <1.1178, 7.1718, 2.8159>, 0.09655,
            <1.0933, 7.6988, 2.9185>, 0.07724
         }
         
         sphere {
            <1.0933, 7.6988, 2.9185>, 0.07714
         }
         
         cone {
            <1.0933, 7.6988, 2.9185>, 0.07724,
            <1.042, 8.2219, 3.0311>, 0.05793
         }
         
         sphere {
            <1.042, 8.2219, 3.0311>, 0.05783
         }
         
         cone {
            <1.042, 8.2219, 3.0311>, 0.05793,
            <0.961, 8.7398, 3.1499>, 0.03862
         }
         
         sphere {
            <0.961, 8.7398, 3.1499>, 0.03852
         }
         
         cone {
            <0.961, 8.7398, 3.1499>, 0.03862,
            <0.8531, 9.2509, 3.2762>, 0.01931
         }
         
         sphere {
            <0.8531, 9.2509, 3.2762>, 0.01921
         }
         
         cone {
            <0.8531, 9.2509, 3.2762>, 0.01931,
            <0.7296, 9.757, 3.4085>, 0
         }
         
         sphere {
            <0.7296, 9.757, 3.4085>, -0.0001
         }
         
         merge {
            // level 1 
            cone {
               <0.6517, 4.1177, 2.1361>, 0.2124,
               <0.5107, 4.5505, 2.4219>, 0.19309
            }
            
            sphere {
               <0.5107, 4.5505, 2.4219>, 0.19299
            }
            
            cone {
               <0.5107, 4.5505, 2.4219>, 0.19309,
               <0.4398, 5.0482, 2.6122>, 0.17378
            }
            
            sphere {
               <0.4398, 5.0482, 2.6122>, 0.17368
            }
            
            cone {
               <0.4398, 5.0482, 2.6122>, 0.17378,
               <0.4296, 5.5806, 2.6847>, 0.15447
            }
            
            sphere {
               <0.4296, 5.5806, 2.6847>, 0.15437
            }
            
            cone {
               <0.4296, 5.5806, 2.6847>, 0.15447,
               <0.4432, 6.1127, 2.7592>, 0.13516
            }
            
            sphere {
               <0.4432, 6.1127, 2.7592>, 0.13506
            }
            
            cone {
               <0.4432, 6.1127, 2.7592>, 0.13516,
               <0.4832, 6.6432, 2.8361>, 0.11586
            }
            
            sphere {
               <0.4832, 6.6432, 2.8361>, 0.11576
            }
            
            cone {
               <0.4832, 6.6432, 2.8361>, 0.11586,
               <0.5556, 7.1706, 2.9103>, 0.09655
            }
            
            sphere {
               <0.5556, 7.1706, 2.9103>, 0.09645
            }
            
            cone {
               <0.5556, 7.1706, 2.9103>, 0.09655,
               <0.66, 7.6923, 2.9863>, 0.07724
            }
            
            sphere {
               <0.66, 7.6923, 2.9863>, 0.07714
            }
            
            cone {
               <0.66, 7.6923, 2.9863>, 0.07724,
               <0.7966, 8.2073, 3.0574>, 0.05793
            }
            
            sphere {
               <0.7966, 8.2073, 3.0574>, 0.05783
            }
            
            cone {
               <0.7966, 8.2073, 3.0574>, 0.05793,
               <0.9663, 8.7138, 3.1171>, 0.03862
            }
            
            sphere {
               <0.9663, 8.7138, 3.1171>, 0.03852
            }
            
            cone {
               <0.9663, 8.7138, 3.1171>, 0.03862,
               <1.1687, 9.2098, 3.1608>, 0.01931
            }
            
            sphere {
               <1.1687, 9.2098, 3.1608>, 0.01921
            }
            
            cone {
               <1.1687, 9.2098, 3.1608>, 0.01931,
               <1.4024, 9.6934, 3.1803>, 0
            }
            
            sphere {
               <1.4024, 9.6934, 3.1803>, -0.0001
            }
            
            cone {
               <1.1687, 9.2098, 3.1608>, 0.01931,
               <1.3927, 9.6966, 3.2018>, 0
            }
            
            sphere {
               <1.3927, 9.6966, 3.2018>, -0.0001
            }
         }
         
         cone {
            <0.8531, 9.2509, 3.2762>, 0.01931,
            <0.7186, 9.7575, 3.3952>, 0
         }
      }
      
      merge {
         // level 1 
         cone {
            <0, 3.4728, 0>, 0.30543,
            <-0.3863, 3.6378, 0.3298>, 0.28634
         }
         
         sphere {
            <-0.3863, 3.6378, 0.3298>, 0.28624
         }
         
         cone {
            <-0.3863, 3.6378, 0.3298>, 0.28634,
            <-0.7386, 3.9042, 0.6301>, 0.26725
         }
         
         sphere {
            <-0.7386, 3.9042, 0.6301>, 0.26715
         }
         
         cone {
            <-0.7386, 3.9042, 0.6301>, 0.26725,
            <-1.04, 4.2667, 0.881>, 0.24816
         }
         
         sphere {
            <-1.04, 4.2667, 0.881>, 0.24806
         }
         
         cone {
            <-1.04, 4.2667, 0.881>, 0.24816,
            <-1.2766, 4.7042, 1.0754>, 0.22907
         }
         
         sphere {
            <-1.2766, 4.7042, 1.0754>, 0.22897
         }
         
         cone {
            <-1.2766, 4.7042, 1.0754>, 0.22907,
            <-1.435, 5.1979, 1.2038>, 0.20998
         }
         
         sphere {
            <-1.435, 5.1979, 1.2038>, 0.20988
         }
         
         cone {
            <-1.435, 5.1979, 1.2038>, 0.20998,
            <-1.5025, 5.7247, 1.2594>, 0.19089
         }
         
         sphere {
            <-1.5025, 5.7247, 1.2594>, 0.19079
         }
         
         cone {
            <-1.5025, 5.7247, 1.2594>, 0.19089,
            <-1.6602, 6.219, 1.3863>, 0.1718
         }
         
         sphere {
            <-1.6602, 6.219, 1.3863>, 0.1717
         }
         
         cone {
            <-1.6602, 6.219, 1.3863>, 0.1718,
            <-1.7336, 6.745, 1.4423>, 0.15271
         }
         
         sphere {
            <-1.7336, 6.745, 1.4423>, 0.15261
         }
         
         cone {
            <-1.7336, 6.745, 1.4423>, 0.15271,
            <-1.8133, 7.2698, 1.501>, 0.13362
         }
         
         sphere {
            <-1.8133, 7.2698, 1.501>, 0.13352
         }
         
         cone {
            <-1.8133, 7.2698, 1.501>, 0.13362,
            <-1.9037, 7.7922, 1.5656>, 0.11454
         }
         
         sphere {
            <-1.9037, 7.7922, 1.5656>, 0.11444
         }
         
         cone {
            <-1.9037, 7.7922, 1.5656>, 0.11454,
            <-1.8408, 8.2584, 1.8184>, 0.09545
         }
         
         sphere {
            <-1.8408, 8.2584, 1.8184>, 0.09535
         }
         
         cone {
            <-1.8408, 8.2584, 1.8184>, 0.09545,
            <-1.8051, 8.7385, 2.0497>, 0.07636
         }
         
         sphere {
            <-1.8051, 8.7385, 2.0497>, 0.07626
         }
         
         cone {
            <-1.8051, 8.7385, 2.0497>, 0.07636,
            <-1.8004, 9.2281, 2.2629>, 0.05727
         }
         
         sphere {
            <-1.8004, 9.2281, 2.2629>, 0.05717
         }
         
         cone {
            <-1.8004, 9.2281, 2.2629>, 0.05727,
            <-1.8271, 9.7275, 2.4504>, 0.03818
         }
         
         sphere {
            <-1.8271, 9.7275, 2.4504>, 0.03808
         }
         
         cone {
            <-1.8271, 9.7275, 2.4504>, 0.03818,
            <-1.8862, 10.2331, 2.6121>, 0.01909
         }
         
         sphere {
            <-1.8862, 10.2331, 2.6121>, 0.01899
         }
         
         cone {
            <-1.8862, 10.2331, 2.6121>, 0.01909,
            <-1.9673, 10.7427, 2.7497>, -0
         }
         
         merge {
            // level 1 
            cone {
               <-1.9037, 7.7922, 1.5656>, 0.11454,
               <-2.1551, 8.2459, 1.4383>, 0.09545
            }
            
            sphere {
               <-2.1551, 8.2459, 1.4383>, 0.09535
            }
            
            cone {
               <-2.1551, 8.2459, 1.4383>, 0.09545,
               <-2.3855, 8.7176, 1.3405>, 0.07636
            }
            
            sphere {
               <-2.3855, 8.7176, 1.3405>, 0.07626
            }
            
            cone {
               <-2.3855, 8.7176, 1.3405>, 0.07636,
               <-2.596, 9.2043, 1.2767>, 0.05727
            }
            
            sphere {
               <-2.596, 9.2043, 1.2767>, 0.05717
            }
            
            cone {
               <-2.596, 9.2043, 1.2767>, 0.05727,
               <-2.7893, 9.7012, 1.2443>, 0.03818
            }
            
            sphere {
               <-2.7893, 9.7012, 1.2443>, 0.03808
            }
            
            cone {
               <-2.7893, 9.7012, 1.2443>, 0.03818,
               <-2.9656, 10.2052, 1.2502>, 0.01909
            }
            
            sphere {
               <-2.9656, 10.2052, 1.2502>, 0.01899
            }
            
            cone {
               <-2.9656, 10.2052, 1.2502>, 0.01909,
               <-3.1216, 10.7144, 1.291>, 0
            }
         }
         
         cone {
            <-1.8862, 10.2331, 2.6121>, 0.01909,
            <-1.9854, 10.7416, 2.7414>, 0
         }
      }
      
      merge {
         // level 0 
         cone {
            <0, 4.3333, 0>, 0.43247,
            <-0, 4.711, 4.3168>, 0.21623
         }
         
         sphere {
            <-0, 4.711, 4.3168>, 0.21613
         }
         
         cone {
            <-0, 4.711, 4.3168>, 0.21623,
            <-0, 5.4635, 8.5843>, 0
         }
         
         sphere {
            <-0, 5.4635, 8.5843>, -0.0001
         }
         
         merge {
            // level 1 
            cone {
               <-0, 4.4656, 1.5113>, 0.25868,
               <-0.2781, 4.068, 1.5533>, 0.24251
            }
            
            sphere {
               <-0.2781, 4.068, 1.5533>, 0.24241
            }
            
            cone {
               <-0.2781, 4.068, 1.5533>, 0.24251,
               <-0.6374, 3.7433, 1.605>, 0.22635
            }
            
            sphere {
               <-0.6374, 3.7433, 1.605>, 0.22625
            }
            
            cone {
               <-0.6374, 3.7433, 1.605>, 0.22635,
               <-1.0566, 3.5031, 1.666>, 0.21018
            }
            
            sphere {
               <-1.0566, 3.5031, 1.666>, 0.21008
            }
            
            cone {
               <-1.0566, 3.5031, 1.666>, 0.21018,
               <-1.5171, 3.3599, 1.7336>, 0.19401
            }
            
            sphere {
               <-1.5171, 3.3599, 1.7336>, 0.19391
            }
            
            cone {
               <-1.5171, 3.3599, 1.7336>, 0.19401,
               <-1.9974, 3.3198, 1.8033>, 0.17784
            }
            
            sphere {
               <-1.9974, 3.3198, 1.8033>, 0.17774
            }
            
            cone {
               <-1.9974, 3.3198, 1.8033>, 0.17784,
               <-2.4746, 3.3849, 1.8756>, 0.16168
            }
            
            sphere {
               <-2.4746, 3.3849, 1.8756>, 0.16158
            }
            
            cone {
               <-2.4746, 3.3849, 1.8756>, 0.16168,
               <-2.9263, 3.5536, 1.9439>, 0.14551
            }
            
            sphere {
               <-2.9263, 3.5536, 1.9439>, 0.14541
            }
            
            cone {
               <-2.9263, 3.5536, 1.9439>, 0.14551,
               <-3.3319, 3.8162, 2.0044>, 0.12934
            }
            
            sphere {
               <-3.3319, 3.8162, 2.0044>, 0.12924
            }
            
            cone {
               <-3.3319, 3.8162, 2.0044>, 0.12934,
               <-3.7422, 4.0701, 2.0701>, 0.11317
            }
            
            sphere {
               <-3.7422, 4.0701, 2.0701>, 0.11307
            }
            
            cone {
               <-3.7422, 4.0701, 2.0701>, 0.11317,
               <-4.1581, 4.3146, 2.137>, 0.09701
            }
            
            sphere {
               <-4.1581, 4.3146, 2.137>, 0.09691
            }
            
            cone {
               <-4.1581, 4.3146, 2.137>, 0.09701,
               <-4.5274, 4.5527, 2.3469>, 0.08084
            }
            
            sphere {
               <-4.5274, 4.5527, 2.3469>, 0.08074
            }
            
            cone {
               <-4.5274, 4.5527, 2.3469>, 0.08084,
               <-4.9147, 4.7857, 2.5283>, 0.06467
            }
            
            sphere {
               <-4.9147, 4.7857, 2.5283>, 0.06457
            }
            
            cone {
               <-4.9147, 4.7857, 2.5283>, 0.06467,
               <-5.318, 5.0106, 2.6828>, 0.0485
            }
            
            sphere {
               <-5.318, 5.0106, 2.6828>, 0.0484
            }
            
            cone {
               <-5.318, 5.0106, 2.6828>, 0.0485,
               <-5.7356, 5.2256, 2.8116>, 0.03234
            }
            
            sphere {
               <-5.7356, 5.2256, 2.8116>, 0.03224
            }
            
            cone {
               <-5.7356, 5.2256, 2.8116>, 0.03234,
               <-6.168, 5.4252, 2.9131>, 0.01617
            }
            
            sphere {
               <-6.168, 5.4252, 2.9131>, 0.01607
            }
            
            cone {
               <-6.168, 5.4252, 2.9131>, 0.01617,
               <-6.6108, 5.6114, 2.9934>, -0
            }
            
            merge {
               // level 1 
               cone {
                  <-4.1581, 4.3146, 2.137>, 0.09701,
                  <-4.5666, 4.5303, 1.9831>, 0.08084
               }
               
               sphere {
                  <-4.5666, 4.5303, 1.9831>, 0.08074
               }
               
               cone {
                  <-4.5666, 4.5303, 1.9831>, 0.08084,
                  <-4.9874, 4.7479, 1.87>, 0.06467
               }
               
               sphere {
                  <-4.9874, 4.7479, 1.87>, 0.06457
               }
               
               cone {
                  <-4.9874, 4.7479, 1.87>, 0.06467,
                  <-5.4199, 4.9603, 1.7994>, 0.0485
               }
               
               sphere {
                  <-5.4199, 4.9603, 1.7994>, 0.0484
               }
               
               cone {
                  <-5.4199, 4.9603, 1.7994>, 0.0485,
                  <-5.8592, 5.1688, 1.7737>, 0.03234
               }
               
               sphere {
                  <-5.8592, 5.1688, 1.7737>, 0.03224
               }
               
               cone {
                  <-5.8592, 5.1688, 1.7737>, 0.03234,
                  <-6.302, 5.3709, 1.7892>, 0.01617
               }
               
               sphere {
                  <-6.302, 5.3709, 1.7892>, 0.01607
               }
               
               cone {
                  <-6.302, 5.3709, 1.7892>, 0.01617,
                  <-6.7457, 5.5627, 1.8484>, 0
               }
               
               sphere {
                  <-6.7457, 5.5627, 1.8484>, -0.0001
               }
            }
            
            cone {
               <-6.168, 5.4252, 2.9131>, 0.01617,
               <-6.6114, 5.6139, 2.9838>, 0
            }
         }
         
         merge {
            // level 1 
            cone {
               <-0, 4.6495, 3.6143>, 0.18504,
               <-0.3736, 4.8036, 3.6249>, 0.17347
            }
            
            sphere {
               <-0.3736, 4.8036, 3.6249>, 0.17337
            }
            
            cone {
               <-0.3736, 4.8036, 3.6249>, 0.17347,
               <-0.7057, 5.034, 3.6347>, 0.16191
            }
            
            sphere {
               <-0.7057, 5.034, 3.6347>, 0.16181
            }
            
            cone {
               <-0.7057, 5.034, 3.6347>, 0.16191,
               <-0.9812, 5.3297, 3.6447>, 0.15034
            }
            
            sphere {
               <-0.9812, 5.3297, 3.6447>, 0.15024
            }
            
            cone {
               <-0.9812, 5.3297, 3.6447>, 0.15034,
               <-1.1889, 5.6765, 3.652>, 0.13878
            }
            
            sphere {
               <-1.1889, 5.6765, 3.652>, 0.13868
            }
            
            cone {
               <-1.1889, 5.6765, 3.652>, 0.13878,
               <-1.3155, 6.0604, 3.6585>, 0.12721
            }
            
            sphere {
               <-1.3155, 6.0604, 3.6585>, 0.12711
            }
            
            cone {
               <-1.3155, 6.0604, 3.6585>, 0.12721,
               <-1.3558, 6.4626, 3.6624>, 0.11565
            }
            
            sphere {
               <-1.3558, 6.4626, 3.6624>, 0.11555
            }
            
            cone {
               <-1.3558, 6.4626, 3.6624>, 0.11565,
               <-1.4817, 6.8466, 3.6745>, 0.10408
            }
            
            sphere {
               <-1.4817, 6.8466, 3.6745>, 0.10398
            }
            
            cone {
               <-1.4817, 6.8466, 3.6745>, 0.10408,
               <-1.5209, 7.2489, 3.6787>, 0.09252
            }
            
            sphere {
               <-1.5209, 7.2489, 3.6787>, 0.09242
            }
            
            cone {
               <-1.5209, 7.2489, 3.6787>, 0.09252,
               <-1.5677, 7.6505, 3.6844>, 0.08095
            }
            
            sphere {
               <-1.5677, 7.6505, 3.6844>, 0.08085
            }
            
            cone {
               <-1.5677, 7.6505, 3.6844>, 0.08095,
               <-1.6238, 8.0508, 3.6881>, 0.06939
            }
            
            sphere {
               <-1.6238, 8.0508, 3.6881>, 0.06929
            }
            
            cone {
               <-1.6238, 8.0508, 3.6881>, 0.06939,
               <-1.7162, 8.4083, 3.8527>, 0.05782
            }
            
            sphere {
               <-1.7162, 8.4083, 3.8527>, 0.05772
            }
            
            cone {
               <-1.7162, 8.4083, 3.8527>, 0.05782,
               <-1.8065, 8.7762, 3.9939>, 0.04626
            }
            
            sphere {
               <-1.8065, 8.7762, 3.9939>, 0.04616
            }
            
            cone {
               <-1.8065, 8.7762, 3.9939>, 0.04626,
               <-1.8951, 9.1528, 4.1112>, 0.03469
            }
            
            sphere {
               <-1.8951, 9.1528, 4.1112>, 0.03459
            }
            
            cone {
               <-1.8951, 9.1528, 4.1112>, 0.03469,
               <-1.981, 9.5374, 4.2017>, 0.02313
            }
            
            sphere {
               <-1.981, 9.5374, 4.2017>, 0.02303
            }
            
            cone {
               <-1.981, 9.5374, 4.2017>, 0.02313,
               <-2.063, 9.928, 4.2658>, 0.01156
            }
            
            sphere {
               <-2.063, 9.928, 4.2658>, 0.01146
            }
            
            cone {
               <-2.063, 9.928, 4.2658>, 0.01156,
               <-2.1361, 10.3239, 4.3024>, 0
            }
            
            merge {
               // level 1 
               cone {
                  <-1.6238, 8.0508, 3.6881>, 0.06939,
                  <-1.6736, 8.4194, 3.5297>, 0.05782
               }
               
               sphere {
                  <-1.6736, 8.4194, 3.5297>, 0.05772
               }
               
               cone {
                  <-1.6736, 8.4194, 3.5297>, 0.05782,
                  <-1.7286, 8.7954, 3.3917>, 0.04626
               }
               
               sphere {
                  <-1.7286, 8.7954, 3.3917>, 0.04616
               }
               
               cone {
                  <-1.7286, 8.7954, 3.3917>, 0.04626,
                  <-1.7861, 9.1785, 3.2761>, 0.03469
               }
               
               sphere {
                  <-1.7861, 9.1785, 3.2761>, 0.03459
               }
               
               cone {
                  <-1.7861, 9.1785, 3.2761>, 0.03469,
                  <-1.851, 9.5658, 3.18>, 0.02313
               }
               
               sphere {
                  <-1.851, 9.5658, 3.18>, 0.02303
               }
               
               cone {
                  <-1.851, 9.5658, 3.18>, 0.02313,
                  <-1.9227, 9.957, 3.1075>, 0.01156
               }
               
               sphere {
                  <-1.9227, 9.957, 3.1075>, 0.01146
               }
               
               cone {
                  <-1.9227, 9.957, 3.1075>, 0.01156,
                  <-2.0019, 10.3506, 3.0599>, -0
               }
            }
            
            cone {
               <-2.063, 9.928, 4.2658>, 0.01156,
               <-2.1462, 10.3226, 4.2947>, 0
            }
         }
         
         merge {
            // level 1 
            cone {
               <-0, 4.7986, 4.8136>, 0.13746,
               <0.0189, 5.1385, 4.7739>, 0.12886
            }
            
            sphere {
               <0.0189, 5.1385, 4.7739>, 0.12876
            }
            
            cone {
               <0.0189, 5.1385, 4.7739>, 0.12886,
               <0.068, 5.4607, 4.6679>, 0.12027
            }
            
            sphere {
               <0.068, 5.4607, 4.6679>, 0.12017
            }
            
            cone {
               <0.068, 5.4607, 4.6679>, 0.12027,
               <0.0832, 5.8006, 4.6269>, 0.11168
            }
            
            sphere {
               <0.0832, 5.8006, 4.6269>, 0.11158
            }
            
            cone {
               <0.0832, 5.8006, 4.6269>, 0.11168,
               <0.1227, 6.1235, 4.5188>, 0.10309
            }
            
            sphere {
               <0.1227, 6.1235, 4.5188>, 0.10299
            }
            
            cone {
               <0.1227, 6.1235, 4.5188>, 0.10309,
               <0.1381, 6.4634, 4.4774>, 0.0945
            }
            
            sphere {
               <0.1381, 6.4634, 4.4774>, 0.0944
            }
            
            cone {
               <0.1381, 6.4634, 4.4774>, 0.0945,
               <0.1796, 6.7854, 4.3677>, 0.08591
            }
            
            sphere {
               <0.1796, 6.7854, 4.3677>, 0.08581
            }
            
            cone {
               <0.1796, 6.7854, 4.3677>, 0.08591,
               <0.1919, 7.1252, 4.3251>, 0.07732
            }
            
            sphere {
               <0.1919, 7.1252, 4.3251>, 0.07722
            }
            
            cone {
               <0.1919, 7.1252, 4.3251>, 0.07732,
               <0.2261, 7.4468, 4.2115>, 0.06873
            }
            
            sphere {
               <0.2261, 7.4468, 4.2115>, 0.06863
            }
            
            cone {
               <0.2261, 7.4468, 4.2115>, 0.06873,
               <0.2599, 7.7665, 4.0925>, 0.06014
            }
            
            sphere {
               <0.2599, 7.7665, 4.0925>, 0.06004
            }
            
            cone {
               <0.2599, 7.7665, 4.0925>, 0.06014,
               <0.2975, 8.0822, 3.9646>, 0.05155
            }
            
            sphere {
               <0.2975, 8.0822, 3.9646>, 0.05145
            }
            
            cone {
               <0.2975, 8.0822, 3.9646>, 0.05155,
               <0.1993, 8.3776, 3.8213>, 0.04295
            }
            
            sphere {
               <0.1993, 8.3776, 3.8213>, 0.04285
            }
            
            cone {
               <0.1993, 8.3776, 3.8213>, 0.04295,
               <0.1238, 8.6774, 3.6732>, 0.03436
            }
            
            sphere {
               <0.1238, 8.6774, 3.6732>, 0.03426
            }
            
            cone {
               <0.1238, 8.6774, 3.6732>, 0.03436,
               <0.0706, 8.9785, 3.5184>, 0.02577
            }
            
            sphere {
               <0.0706, 8.9785, 3.5184>, 0.02567
            }
            
            cone {
               <0.0706, 8.9785, 3.5184>, 0.02577,
               <0.04, 9.281, 3.3603>, 0.01718
            }
            
            sphere {
               <0.04, 9.281, 3.3603>, 0.01708
            }
            
            cone {
               <0.04, 9.281, 3.3603>, 0.01718,
               <0.0345, 9.5829, 3.1979>, 0.00859
            }
            
            sphere {
               <0.0345, 9.5829, 3.1979>, 0.00849
            }
            
            cone {
               <0.0345, 9.5829, 3.1979>, 0.00859,
               <0.0509, 9.8831, 3.0334>, -0
            }
            
            merge {
               // level 1 
               cone {
                  <0.2975, 8.0822, 3.9646>, 0.05155,
                  <0.5012, 8.3442, 3.879>, 0.04295
               }
               
               sphere {
                  <0.5012, 8.3442, 3.879>, 0.04285
               }
               
               cone {
                  <0.5012, 8.3442, 3.879>, 0.04295,
                  <0.6819, 8.6181, 3.78>, 0.03436
               }
               
               sphere {
                  <0.6819, 8.6181, 3.78>, 0.03426
               }
               
               cone {
                  <0.6819, 8.6181, 3.78>, 0.03436,
                  <0.8407, 8.9, 3.6669>, 0.02577
               }
               
               sphere {
                  <0.8407, 8.9, 3.6669>, 0.02567
               }
               
               cone {
                  <0.8407, 8.9, 3.6669>, 0.02577,
                  <0.9747, 9.1891, 3.5408>, 0.01718
               }
               
               sphere {
                  <0.9747, 9.1891, 3.5408>, 0.01708
               }
               
               cone {
                  <0.9747, 9.1891, 3.5408>, 0.01718,
                  <1.0794, 9.4843, 3.4015>, 0.00859
               }
               
               sphere {
                  <1.0794, 9.4843, 3.4015>, 0.00849
               }
               
               cone {
                  <1.0794, 9.4843, 3.4015>, 0.00859,
                  <1.1569, 9.7803, 3.2471>, -0
               }
            }
            
            cone {
               <0.0345, 9.5829, 3.1979>, 0.00859,
               <0.0589, 9.8825, 3.0333>, 0
            }
         }
         
         merge {
            // level 1 
            cone {
               <-0, 5.2406, 7.3206>, 0.04773,
               <0.1741, 5.3119, 7.3501>, 0.04474
            }
            
            sphere {
               <0.1741, 5.3119, 7.3501>, 0.04464
            }
            
            cone {
               <0.1741, 5.3119, 7.3501>, 0.04474,
               <0.3288, 5.4196, 7.3768>, 0.04176
            }
            
            sphere {
               <0.3288, 5.4196, 7.3768>, 0.04166
            }
            
            cone {
               <0.3288, 5.4196, 7.3768>, 0.04176,
               <0.4564, 5.5594, 7.3985>, 0.03878
            }
            
            sphere {
               <0.4564, 5.5594, 7.3985>, 0.03868
            }
            
            cone {
               <0.4564, 5.5594, 7.3985>, 0.03878,
               <0.551, 5.7238, 7.4147>, 0.03579
            }
            
            sphere {
               <0.551, 5.7238, 7.4147>, 0.03569
            }
            
            cone {
               <0.551, 5.7238, 7.4147>, 0.03579,
               <0.6076, 5.9053, 7.4261>, 0.03281
            }
            
            sphere {
               <0.6076, 5.9053, 7.4261>, 0.03271
            }
            
            cone {
               <0.6076, 5.9053, 7.4261>, 0.03281,
               <0.6234, 6.0951, 7.4295>, 0.02983
            }
            
            sphere {
               <0.6234, 6.0951, 7.4295>, 0.02973
            }
            
            cone {
               <0.6234, 6.0951, 7.4295>, 0.02983,
               <0.6797, 6.2767, 7.4397>, 0.02685
            }
            
            sphere {
               <0.6797, 6.2767, 7.4397>, 0.02675
            }
            
            cone {
               <0.6797, 6.2767, 7.4397>, 0.02685,
               <0.6958, 6.4664, 7.4432>, 0.02386
            }
            
            sphere {
               <0.6958, 6.4664, 7.4432>, 0.02376
            }
            
            cone {
               <0.6958, 6.4664, 7.4432>, 0.02386,
               <0.7159, 6.6557, 7.4475>, 0.02088
            }
            
            sphere {
               <0.7159, 6.6557, 7.4475>, 0.02078
            }
            
            cone {
               <0.7159, 6.6557, 7.4475>, 0.02088,
               <0.7392, 6.8446, 7.453>, 0.0179
            }
            
            sphere {
               <0.7392, 6.8446, 7.453>, 0.0178
            }
            
            cone {
               <0.7392, 6.8446, 7.453>, 0.0179,
               <0.7609, 7.013, 7.3667>, 0.01491
            }
            
            sphere {
               <0.7609, 7.013, 7.3667>, 0.01481
            }
            
            cone {
               <0.7609, 7.013, 7.3667>, 0.01491,
               <0.7827, 7.1872, 7.2929>, 0.01193
            }
            
            sphere {
               <0.7827, 7.1872, 7.2929>, 0.01183
            }
            
            cone {
               <0.7827, 7.1872, 7.2929>, 0.01193,
               <0.8066, 7.3661, 7.2323>, 0.00895
            }
            
            sphere {
               <0.8066, 7.3661, 7.2323>, 0.00885
            }
            
            cone {
               <0.8066, 7.3661, 7.2323>, 0.00895,
               <0.8319, 7.549, 7.1855>, 0.00597
            }
            
            sphere {
               <0.8319, 7.549, 7.1855>, 0.00587
            }
            
            cone {
               <0.8319, 7.549, 7.1855>, 0.00597,
               <0.8598, 7.7344, 7.1527>, 0.00298
            }
            
            sphere {
               <0.8598, 7.7344, 7.1527>, 0.00288
            }
            
            cone {
               <0.8598, 7.7344, 7.1527>, 0.00298,
               <0.8877, 7.9219, 7.134>, 0
            }
            
            sphere {
               <0.8877, 7.9219, 7.134>, -0.0001
            }
            
            merge {
               // level 1 
               cone {
                  <0.7392, 6.8446, 7.453>, 0.0179,
                  <0.7368, 7.0143, 7.5395>, 0.01491
               }
               
               sphere {
                  <0.7368, 7.0143, 7.5395>, 0.01481
               }
               
               cone {
                  <0.7368, 7.0143, 7.5395>, 0.01491,
                  <0.7396, 7.189, 7.6152>, 0.01193
               }
               
               sphere {
                  <0.7396, 7.189, 7.6152>, 0.01183
               }
               
               cone {
                  <0.7396, 7.189, 7.6152>, 0.01193,
                  <0.7475, 7.3681, 7.6794>, 0.00895
               }
               
               sphere {
                  <0.7475, 7.3681, 7.6794>, 0.00885
               }
               
               cone {
                  <0.7475, 7.3681, 7.6794>, 0.00895,
                  <0.7606, 7.5506, 7.7323>, 0.00597
               }
               
               sphere {
                  <0.7606, 7.5506, 7.7323>, 0.00587
               }
               
               cone {
                  <0.7606, 7.5506, 7.7323>, 0.00597,
                  <0.7797, 7.7355, 7.7734>, 0.00298
               }
               
               sphere {
                  <0.7797, 7.7355, 7.7734>, 0.00288
               }
               
               cone {
                  <0.7797, 7.7355, 7.7734>, 0.00298,
                  <0.8049, 7.9223, 7.8008>, 0
               }
               
               sphere {
                  <0.8049, 7.9223, 7.8008>, -0.0001
               }
            }
            
            cone {
               <0.8598, 7.7344, 7.1527>, 0.00298,
               <0.8921, 7.9216, 7.1387>, 0
            }
            
            sphere {
               <0.8921, 7.9216, 7.1387>, -0.0001
            }
         }
      }
      
      merge {
         // level 1 
         cone {
            <0, 4.4632, -1.4844>, 0.25947,
            <-0.2514, 4.867, -1.5925>, 0.24325
         }
         
         sphere {
            <-0.2514, 4.867, -1.5925>, 0.24315
         }
         
         cone {
            <-0.2514, 4.867, -1.5925>, 0.24325,
            <-0.4195, 5.3191, -1.6658>, 0.22704
         }
         
         sphere {
            <-0.4195, 5.3191, -1.6658>, 0.22694
         }
         
         cone {
            <-0.4195, 5.3191, -1.6658>, 0.22704,
            <-0.4938, 5.8001, -1.6981>, 0.21082
         }
         
         sphere {
            <-0.4938, 5.8001, -1.6981>, 0.21072
         }
         
         cone {
            <-0.4938, 5.8001, -1.6981>, 0.21082,
            <-0.6609, 6.2521, -1.7737>, 0.1946
         }
         
         sphere {
            <-0.6609, 6.2521, -1.7737>, 0.1945
         }
         
         cone {
            <-0.6609, 6.2521, -1.7737>, 0.1946,
            <-0.7377, 6.7327, -1.8062>, 0.17839
         }
         
         sphere {
            <-0.7377, 6.7327, -1.8062>, 0.17829
         }
         
         cone {
            <-0.7377, 6.7327, -1.8062>, 0.17839,
            <-0.9059, 7.1848, -1.8793>, 0.16217
         }
         
         sphere {
            <-0.9059, 7.1848, -1.8793>, 0.16207
         }
         
         cone {
            <-0.9059, 7.1848, -1.8793>, 0.16217,
            <-0.977, 7.6662, -1.9129>, 0.14595
         }
         
         sphere {
            <-0.977, 7.6662, -1.9129>, 0.14585
         }
         
         cone {
            <-0.977, 7.6662, -1.9129>, 0.14595,
            <-1.1393, 8.1196, -1.9903>, 0.12974
         }
         
         sphere {
            <-1.1393, 8.1196, -1.9903>, 0.12964
         }
         
         cone {
            <-1.1393, 8.1196, -1.9903>, 0.12974,
            <-1.3097, 8.5686, -2.0763>, 0.11352
         }
         
         sphere {
            <-1.3097, 8.5686, -2.0763>, 0.11342
         }
         
         cone {
            <-1.3097, 8.5686, -2.0763>, 0.11352,
            <-1.4876, 9.0143, -2.164>, 0.0973
         }
         
         sphere {
            <-1.4876, 9.0143, -2.164>, 0.0972
         }
         
         cone {
            <-1.4876, 9.0143, -2.164>, 0.0973,
            <-1.7644, 9.3931, -2.0306>, 0.08108
         }
         
         sphere {
            <-1.7644, 9.3931, -2.0306>, 0.08098
         }
         
         cone {
            <-1.7644, 9.3931, -2.0306>, 0.08108,
            <-2.0372, 9.7863, -1.9359>, 0.06487
         }
         
         sphere {
            <-2.0372, 9.7863, -1.9359>, 0.06477
         }
         
         cone {
            <-2.0372, 9.7863, -1.9359>, 0.06487,
            <-2.3036, 10.1911, -1.8801>, 0.04865
         }
         
         sphere {
            <-2.3036, 10.1911, -1.8801>, 0.04855
         }
         
         cone {
            <-2.3036, 10.1911, -1.8801>, 0.04865,
            <-2.5621, 10.6043, -1.8606>, 0.03243
         }
         
         sphere {
            <-2.5621, 10.6043, -1.8606>, 0.03233
         }
         
         cone {
            <-2.5621, 10.6043, -1.8606>, 0.03243,
            <-2.8111, 11.0231, -1.8842>, 0.01622
         }
         
         sphere {
            <-2.8111, 11.0231, -1.8842>, 0.01612
         }
         
         cone {
            <-2.8111, 11.0231, -1.8842>, 0.01622,
            <-3.0465, 11.4465, -1.9416>, -0
         }
         
         merge {
            // level 1 
            cone {
               <-1.4876, 9.0143, -2.164>, 0.0973,
               <-1.5062, 9.4409, -2.3998>, 0.08108
            }
            
            sphere {
               <-1.5062, 9.4409, -2.3998>, 0.08098
            }
            
            cone {
               <-1.5062, 9.4409, -2.3998>, 0.08108,
               <-1.5577, 9.8723, -2.6215>, 0.06487
            }
            
            sphere {
               <-1.5577, 9.8723, -2.6215>, 0.06477
            }
            
            cone {
               <-1.5577, 9.8723, -2.6215>, 0.06487,
               <-1.6404, 10.306, -2.8291>, 0.04865
            }
            
            sphere {
               <-1.6404, 10.306, -2.8291>, 0.04855
            }
            
            cone {
               <-1.6404, 10.306, -2.8291>, 0.04865,
               <-1.759, 10.7394, -3.0189>, 0.03243
            }
            
            sphere {
               <-1.759, 10.7394, -3.0189>, 0.03233
            }
            
            cone {
               <-1.759, 10.7394, -3.0189>, 0.03243,
               <-1.9138, 11.1694, -3.1896>, 0.01622
            }
            
            sphere {
               <-1.9138, 11.1694, -3.1896>, 0.01612
            }
            
            cone {
               <-1.9138, 11.1694, -3.1896>, 0.01622,
               <-2.1046, 11.5927, -3.3392>, -0
            }
         }
         
         cone {
            <-2.8111, 11.0231, -1.8842>, 0.01622,
            <-3.0446, 11.445, -1.9581>, 0
         }
         
         sphere {
            <-3.0446, 11.445, -1.9581>, -0.0001
         }
      }
      
      merge {
         // level 1 
         cone {
            <0, 4.7016, -4.2094>, 0.16162,
            <-0.3613, 4.6474, -4.2939>, 0.15152
         }
         
         sphere {
            <-0.3613, 4.6474, -4.2939>, 0.15142
         }
         
         cone {
            <-0.3613, 4.6474, -4.2939>, 0.15152,
            <-0.7255, 4.6743, -4.3792>, 0.14142
         }
         
         sphere {
            <-0.7255, 4.6743, -4.3792>, 0.14132
         }
         
         cone {
            <-0.7255, 4.6743, -4.3792>, 0.14142,
            <-1.0765, 4.7785, -4.4599>, 0.13132
         }
         
         sphere {
            <-1.0765, 4.7785, -4.4599>, 0.13122
         }
         
         cone {
            <-1.0765, 4.7785, -4.4599>, 0.13132,
            <-1.3977, 4.9586, -4.5312>, 0.12121
         }
         
         sphere {
            <-1.3977, 4.9586, -4.5312>, 0.12111
         }
         
         cone {
            <-1.3977, 4.9586, -4.5312>, 0.12121,
            <-1.673, 5.2056, -4.5926>, 0.11111
         }
         
         sphere {
            <-1.673, 5.2056, -4.5926>, 0.11101
         }
         
         cone {
            <-1.673, 5.2056, -4.5926>, 0.11111,
            <-1.8899, 5.5079, -4.6394>, 0.10101
         }
         
         sphere {
            <-1.8899, 5.5079, -4.6394>, 0.10091
         }
         
         cone {
            <-1.8899, 5.5079, -4.6394>, 0.10101,
            <-2.038, 5.8512, -4.6693>, 0.09091
         }
         
         sphere {
            <-2.038, 5.8512, -4.6693>, 0.09081
         }
         
         cone {
            <-2.038, 5.8512, -4.6693>, 0.09091,
            <-2.1099, 6.219, -4.6836>, 0.08081
         }
         
         sphere {
            <-2.1099, 6.219, -4.6836>, 0.08071
         }
         
         cone {
            <-2.1099, 6.219, -4.6836>, 0.08081,
            <-2.1905, 6.5849, -4.6985>, 0.07071
         }
         
         sphere {
            <-2.1905, 6.5849, -4.6985>, 0.07061
         }
         
         cone {
            <-2.1905, 6.5849, -4.6985>, 0.07071,
            <-2.2767, 6.9495, -4.7132>, 0.06061
         }
         
         sphere {
            <-2.2767, 6.9495, -4.7132>, 0.06051
         }
         
         cone {
            <-2.2767, 6.9495, -4.7132>, 0.06061,
            <-2.4331, 7.269, -4.5945>, 0.05051
         }
         
         sphere {
            <-2.4331, 7.269, -4.5945>, 0.05041
         }
         
         cone {
            <-2.4331, 7.269, -4.5945>, 0.05051,
            <-2.5825, 7.5993, -4.4984>, 0.0404
         }
         
         sphere {
            <-2.5825, 7.5993, -4.4984>, 0.0403
         }
         
         cone {
            <-2.5825, 7.5993, -4.4984>, 0.0404,
            <-2.7272, 7.937, -4.423>, 0.0303
         }
         
         sphere {
            <-2.7272, 7.937, -4.423>, 0.0302
         }
         
         cone {
            <-2.7272, 7.937, -4.423>, 0.0303,
            <-2.8686, 8.2798, -4.3673>, 0.0202
         }
         
         sphere {
            <-2.8686, 8.2798, -4.3673>, 0.0201
         }
         
         cone {
            <-2.8686, 8.2798, -4.3673>, 0.0202,
            <-3.0024, 8.6284, -4.333>, 0.0101
         }
         
         sphere {
            <-3.0024, 8.6284, -4.333>, 0.01
         }
         
         cone {
            <-3.0024, 8.6284, -4.333>, 0.0101,
            <-3.1292, 8.9809, -4.3159>, -0
         }
         
         merge {
            // level 1 
            cone {
               <-2.2767, 6.9495, -4.7132>, 0.06061,
               <-2.3596, 7.284, -4.8611>, 0.05051
            }
            
            sphere {
               <-2.3596, 7.284, -4.8611>, 0.05041
            }
            
            cone {
               <-2.3596, 7.284, -4.8611>, 0.05051,
               <-2.4485, 7.6242, -4.9917>, 0.0404
            }
            
            sphere {
               <-2.4485, 7.6242, -4.9917>, 0.0403
            }
            
            cone {
               <-2.4485, 7.6242, -4.9917>, 0.0404,
               <-2.5469, 7.9689, -5.1016>, 0.0303
            }
            
            sphere {
               <-2.5469, 7.9689, -5.1016>, 0.0302
            }
            
            cone {
               <-2.5469, 7.9689, -5.1016>, 0.0303,
               <-2.6522, 8.3177, -5.1903>, 0.0202
            }
            
            sphere {
               <-2.6522, 8.3177, -5.1903>, 0.0201
            }
            
            cone {
               <-2.6522, 8.3177, -5.1903>, 0.0202,
               <-2.7658, 8.668, -5.261>, 0.0101
            }
            
            sphere {
               <-2.7658, 8.668, -5.261>, 0.01
            }
            
            cone {
               <-2.7658, 8.668, -5.261>, 0.0101,
               <-2.8857, 9.0194, -5.3135>, -0
            }
         }
         
         cone {
            <-3.0024, 8.6284, -4.333>, 0.0101,
            <-3.1277, 8.9819, -4.3283>, 0
         }
      }
      
      merge {
         // level 1 
         cone {
            <0, 4.9819, -5.8531>, 0.0971,
            <-0.0068, 4.7143, -5.9437>, 0.09103
         }
         
         sphere {
            <-0.0068, 4.7143, -5.9437>, 0.09093
         }
         
         cone {
            <-0.0068, 4.7143, -5.9437>, 0.09103,
            <-0.0201, 4.4729, -6.0899>, 0.08496
         }
         
         sphere {
            <-0.0201, 4.4729, -6.0899>, 0.08486
         }
         
         cone {
            <-0.0201, 4.4729, -6.0899>, 0.08496,
            <-0.0386, 4.2687, -6.2843>, 0.0789
         }
         
         sphere {
            <-0.0386, 4.2687, -6.2843>, 0.0788
         }
         
         cone {
            <-0.0386, 4.2687, -6.2843>, 0.0789,
            <-0.061, 4.1114, -6.518>, 0.07283
         }
         
         sphere {
            <-0.061, 4.1114, -6.518>, 0.07273
         }
         
         cone {
            <-0.061, 4.1114, -6.518>, 0.07283,
            <-0.0853, 4.0101, -6.7806>, 0.06676
         }
         
         sphere {
            <-0.0853, 4.0101, -6.7806>, 0.06666
         }
         
         cone {
            <-0.0853, 4.0101, -6.7806>, 0.06676,
            <-0.1113, 3.9701, -7.0591>, 0.06069
         }
         
         sphere {
            <-0.1113, 3.9701, -7.0591>, 0.06059
         }
         
         cone {
            <-0.1113, 3.9701, -7.0591>, 0.06069,
            <-0.1371, 3.9919, -7.3397>, 0.05462
         }
         
         sphere {
            <-0.1371, 3.9919, -7.3397>, 0.05452
         }
         
         cone {
            <-0.1371, 3.9919, -7.3397>, 0.05462,
            <-0.1614, 4.0746, -7.6088>, 0.04855
         }
         
         sphere {
            <-0.1614, 4.0746, -7.6088>, 0.04845
         }
         
         cone {
            <-0.1614, 4.0746, -7.6088>, 0.04855,
            <-0.1864, 4.1521, -7.8793>, 0.04248
         }
         
         sphere {
            <-0.1864, 4.1521, -7.8793>, 0.04238
         }
         
         cone {
            <-0.1864, 4.1521, -7.8793>, 0.04248,
            <-0.2128, 4.221, -8.1521>, 0.03641
         }
         
         sphere {
            <-0.2128, 4.221, -8.1521>, 0.03631
         }
         
         cone {
            <-0.2128, 4.221, -8.1521>, 0.03641,
            <-0.3746, 4.2527, -8.3816>, 0.03034
         }
         
         sphere {
            <-0.3746, 4.2527, -8.3816>, 0.03024
         }
         
         cone {
            <-0.3746, 4.2527, -8.3816>, 0.03034,
            <-0.5129, 4.2861, -8.6257>, 0.02428
         }
         
         sphere {
            <-0.5129, 4.2861, -8.6257>, 0.02418
         }
         
         cone {
            <-0.5129, 4.2861, -8.6257>, 0.02428,
            <-0.6264, 4.3227, -8.8818>, 0.01821
         }
         
         sphere {
            <-0.6264, 4.3227, -8.8818>, 0.01811
         }
         
         cone {
            <-0.6264, 4.3227, -8.8818>, 0.01821,
            <-0.7136, 4.3632, -9.1475>, 0.01214
         }
         
         sphere {
            <-0.7136, 4.3632, -9.1475>, 0.01204
         }
         
         cone {
            <-0.7136, 4.3632, -9.1475>, 0.01214,
            <-0.7733, 4.4051, -9.4205>, 0.00607
         }
         
         sphere {
            <-0.7733, 4.4051, -9.4205>, 0.00597
         }
         
         cone {
            <-0.7733, 4.4051, -9.4205>, 0.00607,
            <-0.8032, 4.4484, -9.6981>, 0
         }
         
         sphere {
            <-0.8032, 4.4484, -9.6981>, -0.0001
         }
         
         merge {
            // level 1 
            cone {
               <-0.2128, 4.221, -8.1521>, 0.03641,
               <-0.093, 4.3029, -8.3946>, 0.03034
            }
            
            sphere {
               <-0.093, 4.3029, -8.3946>, 0.03024
            }
            
            cone {
               <-0.093, 4.3029, -8.3946>, 0.03034,
               <-0.0015, 4.3778, -8.6512>, 0.02428
            }
            
            sphere {
               <-0.0015, 4.3778, -8.6512>, 0.02418
            }
            
            cone {
               <-0.0015, 4.3778, -8.6512>, 0.02428,
               <0.0625, 4.4436, -8.9184>, 0.01821
            }
            
            sphere {
               <0.0625, 4.4436, -8.9184>, 0.01811
            }
            
            cone {
               <0.0625, 4.4436, -8.9184>, 0.01821,
               <0.0996, 4.4991, -9.193>, 0.01214
            }
            
            sphere {
               <0.0996, 4.4991, -9.193>, 0.01204
            }
            
            cone {
               <0.0996, 4.4991, -9.193>, 0.01214,
               <0.1087, 4.5428, -9.472>, 0.00607
            }
            
            sphere {
               <0.1087, 4.5428, -9.472>, 0.00597
            }
            
            cone {
               <0.1087, 4.5428, -9.472>, 0.00607,
               <0.0895, 4.5742, -9.7521>, -0
            }
         }
         
         cone {
            <-0.7733, 4.4051, -9.4205>, 0.00607,
            <-0.8053, 4.4492, -9.6978>, 0
         }
      }
      
      merge {
         // level 1 
         cone {
            <0, 5.188, -7.0219>, 0.05676,
            <0.183, 5.1178, -7.0964>, 0.05321
         }
         
         sphere {
            <0.183, 5.1178, -7.0964>, 0.05311
         }
         
         cone {
            <0.183, 5.1178, -7.0964>, 0.05321,
            <0.3758, 5.0939, -7.1753>, 0.04966
         }
         
         sphere {
            <0.3758, 5.0939, -7.1753>, 0.04956
         }
         
         cone {
            <0.3758, 5.0939, -7.1753>, 0.04966,
            <0.5687, 5.1156, -7.2547>, 0.04611
         }
         
         sphere {
            <0.5687, 5.1156, -7.2547>, 0.04601
         }
         
         cone {
            <0.5687, 5.1156, -7.2547>, 0.04611,
            <0.7528, 5.1832, -7.3287>, 0.04257
         }
         
         sphere {
            <0.7528, 5.1832, -7.3287>, 0.04247
         }
         
         cone {
            <0.7528, 5.1832, -7.3287>, 0.04257,
            <0.9193, 5.292, -7.3951>, 0.03902
         }
         
         sphere {
            <0.9193, 5.292, -7.3951>, 0.03892
         }
         
         cone {
            <0.9193, 5.292, -7.3951>, 0.03902,
            <1.0597, 5.4373, -7.4512>, 0.03547
         }
         
         sphere {
            <1.0597, 5.4373, -7.4512>, 0.03537
         }
         
         cone {
            <1.0597, 5.4373, -7.4512>, 0.03547,
            <1.168, 5.6116, -7.4941>, 0.03193
         }
         
         sphere {
            <1.168, 5.6116, -7.4941>, 0.03183
         }
         
         cone {
            <1.168, 5.6116, -7.4941>, 0.03193,
            <1.2386, 5.8071, -7.5217>, 0.02838
         }
         
         sphere {
            <1.2386, 5.8071, -7.5217>, 0.02828
         }
         
         cone {
            <1.2386, 5.8071, -7.5217>, 0.02838,
            <1.3137, 6.0005, -7.552>, 0.02483
         }
         
         sphere {
            <1.3137, 6.0005, -7.552>, 0.02473
         }
         
         cone {
            <1.3137, 6.0005, -7.552>, 0.02483,
            <1.3925, 6.1919, -7.5855>, 0.02128
         }
         
         sphere {
            <1.3925, 6.1919, -7.5855>, 0.02118
         }
         
         cone {
            <1.3925, 6.1919, -7.5855>, 0.02128,
            <1.4303, 6.3653, -7.6971>, 0.01774
         }
         
         sphere {
            <1.4303, 6.3653, -7.6971>, 0.01764
         }
         
         cone {
            <1.4303, 6.3653, -7.6971>, 0.01774,
            <1.4793, 6.5429, -7.7972>, 0.01419
         }
         
         sphere {
            <1.4793, 6.5429, -7.7972>, 0.01409
         }
         
         cone {
            <1.4793, 6.5429, -7.7972>, 0.01419,
            <1.5389, 6.723, -7.8866>, 0.01064
         }
         
         sphere {
            <1.5389, 6.723, -7.8866>, 0.01054
         }
         
         cone {
            <1.5389, 6.723, -7.8866>, 0.01064,
            <1.6112, 6.9043, -7.9632>, 0.00709
         }
         
         sphere {
            <1.6112, 6.9043, -7.9632>, 0.00699
         }
         
         cone {
            <1.6112, 6.9043, -7.9632>, 0.00709,
            <1.6951, 7.0861, -8.0256>, 0.00355
         }
         
         sphere {
            <1.6951, 7.0861, -8.0256>, 0.00345
         }
         
         cone {
            <1.6951, 7.0861, -8.0256>, 0.00355,
            <1.7875, 7.2673, -8.0763>, 0
         }
         
         merge {
            // level 1 
            cone {
               <1.3925, 6.1919, -7.5855>, 0.02128,
               <1.5046, 6.3604, -7.5306>, 0.01774
            }
            
            sphere {
               <1.5046, 6.3604, -7.5306>, 0.01764
            }
            
            cone {
               <1.5046, 6.3604, -7.5306>, 0.01774,
               <1.6151, 6.5341, -7.4908>, 0.01419
            }
            
            sphere {
               <1.6151, 6.5341, -7.4908>, 0.01409
            }
            
            cone {
               <1.6151, 6.5341, -7.4908>, 0.01419,
               <1.7249, 6.711, -7.4661>, 0.01064
            }
            
            sphere {
               <1.7249, 6.711, -7.4661>, 0.01054
            }
            
            cone {
               <1.7249, 6.711, -7.4661>, 0.01064,
               <1.8325, 6.8908, -7.4575>, 0.00709
            }
            
            sphere {
               <1.8325, 6.8908, -7.4575>, 0.00699
            }
            
            cone {
               <1.8325, 6.8908, -7.4575>, 0.00709,
               <1.9365, 7.0726, -7.4663>, 0.00355
            }
            
            sphere {
               <1.9365, 7.0726, -7.4663>, 0.00345
            }
            
            cone {
               <1.9365, 7.0726, -7.4663>, 0.00355,
               <2.0377, 7.2545, -7.4917>, 0
            }
         }
         
         cone {
            <1.6951, 7.0861, -8.0256>, 0.00355,
            <1.7905, 7.2675, -8.0696>, 0
         }
      }
   }
}

#declare Kissen = height_field {
   png "/home/wolfram/bilder/Nachttisch/kissen2.png"
   smooth
   scale <3, 1, 3>
   
   pigment {
      color rgb <1, 1, 1>
   }
}

#declare Wimpern = cylinder {
   <0, 0.2, 0>, <0, 0, 0>, 0.001
   scale <1, 1, 30>
   
   pigment {
      wood
      turbulence <0.1, 0, 0.05>
      
      color_map {
         [ 0 color rgb <0.811765, 0.811765, 0.811765>
         ]
         [ 0.3 color rgb <0.811765, 0.811765, 0.811765>
         ]
         [ 0.3 color rgbt <1, 1, 1, 1>
         ]
         [ 1 color rgbt <1, 1, 1, 1>
         ]
      }
      scale 0.01
      rotate x*90
   }
}

#declare Bueschelhaare = sphere {
   <0, 0, 0>, 0.005
   scale <15, 30, 1>
   rotate <0, 0, 0>
   translate <0, 0, 0>
   
   pigment {
      wood
      turbulence <0.1, 0, 0.05>
      
      color_map {
         [ 0 color rgb <0.811765, 0.811765, 0.811765>
         ]
         [ 0.3 color rgb <0.811765, 0.811765, 0.811765>
         ]
         [ 0.35 color rgbt <1, 1, 1, 1>
         ]
         [ 1 color rgbt <1, 1, 1, 1>
         ]
      }
      scale 0.01
      rotate x*90
   }
}

#declare Bueschel = union {
   //*PMName Bschel
   
   object {
      Bueschelhaare
      scale <1, 1.5, 2>
      rotate <-169.3, 44, 162>
      translate <0.322135, 0.691146, 0>
   }
   
   object {
      Bueschelhaare
      scale <1, 1.3, 2>
      rotate <-6.9, 35, 2.7>
      translate <0.310751, 0.704427, 0.0158108>
   }
   
   object {
      Bueschelhaare
      scale <1, 1.2, 2>
      rotate <-0, -38.8, -4.4>
      translate <0.3, 0.7, 0>
   }
   
   object {
      Bueschelhaare
      scale <1, 1, 2>
      rotate <11.5, 90, 0>
      translate <0.3, 0.7, 0>
   }
}

#declare Giraffe = union {
   //*PMName Giraffe
   
   difference {
      blob {
         //*PMName Kopf
         threshold 0.5
         
         cylinder {
            //*PMName Hals
            <0, -0.5, 0>, <0, -7, 0>, 0.8,
            strength 1
            rotate <-10, 0, 2>
            scale <0.7, 1, 1>
            translate y*(-0.5)
         }
         
         sphere {
            <0, 0, 0>, 1,
            strength 1
         }
         
         cylinder {
            <0, 0.3, 0>, <0, 0, -1>, 0.4,
            strength 1
            rotate y*(-1)
         }
         
         cylinder {
            <0, 0.3, 0>, <0, 0, -1>, 0.2,
            strength 1
            rotate y*(-0.5)
            translate <0, 0.1, -0.2>
         }
         
         sphere {
            <0, 0.4, -0.3>, 0.4,
            strength 1
            scale <0.6, 1, 1>
         }
         
         sphere {
            //*PMName Nase
            <0, 0, 0>, 0.2,
            strength 1
            scale <1, 0.4, 1>
            rotate x*(-30)
            translate <0.02, 0.15, -1.3>
         }
         
         sphere {
            <0, 0, 0>, 0.2,
            strength -1
            scale <0.4, 0.3, 1>
            rotate <-10, -0.5, 0>
            translate <0.1, 0.15, -1.3>
         }
         
         sphere {
            <0, 0, 0>, 0.2,
            strength -1
            scale <0.4, 0.3, 1>
            rotate <-10, -0.5, 0>
            translate <-0.1, 0.15, -1.3>
         }
         
         sphere {
            <0, 0, 0>, 0.5,
            strength 1
            translate <0, -0.1, -0.8>
         }
         
         sphere {
            //*PMName Schnauze
            <0, 0, 0>, 0.6,
            strength 1
            scale <0.9, 0.6, 1.2>
            rotate <-20, 0, -1>
            translate z*(-1.2)
         }
         
         sphere {
            <0, 0, 0>, 0.5,
            strength 1
            scale <1, 0.3, 1>
            rotate <9, 0, -20>
            translate <-0.2, 0.2, -0.2>
         }
         
         sphere {
            <0, 0, 0>, 0.5,
            strength 1
            scale <1, 0.3, 1>
            rotate <10, 0, 20>
            translate <0.2, 0.2, -0.2>
         }
         
         sphere {
            //*PMName Ohr
            <0, 0, 0>, 0.25,
            strength 1
            scale <2, 1, 1>
            rotate z*35
            translate <0.6, 0.4, 0>
         }
         
         sphere {
            <0, 0, 0>, 0.15,
            strength -1
            scale <1.7, 1, 1>
            rotate z*34
            translate <0.65, 0.45, -0.1>
         }
         
         sphere {
            //*PMName Ohr
            <0, 0, 0>, 0.25,
            strength 1
            scale <2, 1, 1>
            rotate z*(-30)
            translate <-0.6, 0.4, 0>
         }
         
         sphere {
            <0, 0, 0>, 0.15,
            strength -1
            scale <1.7, 1, 1>
            rotate z*(-30)
            translate <-0.65, 0.45, -0.1>
         }
         
         sphere {
            //*PMName Horn
            <0, 0, 0>, 0.2,
            strength 1
            scale <1, 1.5, 1>
            rotate <20, 0, -22>
            translate <0.2, 0.5, 0>
         }
         
         sphere {
            //*PMName Horn
            <0, 0, 0>, 0.13,
            strength 1
            scale <1, 1.3, 1>
            rotate <20, 0, 10>
            translate <0.3, 0.73, 0>
            
            pigment {
               color rgbt <0.94118, 0.94118, 0.94118, 0.8>
            }
         }
         
         sphere {
            //*PMName Horn
            <0, 0, 0>, 0.2,
            strength 1
            scale <1, 1.5, 1>
            rotate <20, 0, 20>
            translate <-0.2, 0.5, 0>
         }
         
         sphere {
            //*PMName Horn
            <0, 0, 0>, 0.13,
            strength 1
            scale <1, 1.3, 1>
            rotate <18, 0, -12>
            translate <-0.3, 0.73, 0>
            
            pigment {
               color rgbt <0.94118, 0.94118, 0.94118, 0.8>
            }
         }
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      box {
         <-0.5, -0.5, -0.5>, <0.5, 0.5, 0.5>
         scale 2
         rotate z*45
         scale <1, 0.4, 1>
         translate <1.4, -1.5, 0>
      }
      
      texture {
         finish {
            ambient rgb <0.666667, 0.666667, 0.666667>
            diffuse 0.9
            specular 0.6
            roughness 0.2
         }
         
         pigment {
            bozo
            
            color_map {
               [ 0 color rgbf <1, 1, 1, 0.5>
               ]
               [ 0.4 color rgbf <1, 1, 1, 0.5>
               ]
               [ 0.9 color rgbf <0.011765, 0.011765, 0.011765, 0.5>
               ]
               [ 1 color rgbf <0.011765, 0.011765, 0.011765, 0.5>
               ]
            }
            scale 0.2
         }
      }
   }
   
   union {
      //*PMName Braue
      // No prototype for object link
      object {
         Wimpern
         rotate y*(-10)
         rotate <-38.2, -4.4, -99.4>
         translate <0.424707, 0.29, -0.380004>
      }
      
      object {
         Wimpern
         rotate <-31.7, -3.5, -98.3>
         translate <0.458892, 0.3, -0.345649>
      }
      
      object {
         Wimpern
         rotate y*(-20)
         rotate <-45, 0, -95>
         translate <0.39478, 0.26, -0.41205>
      }
      
      object {
         Wimpern
         rotate <-21.2, -2.8, -99.6>
         translate <0.468378, 0.3, -0.303162>
      }
   }
   
   union {
      //*PMName Bart
      
      cylinder {
         <0, 0.24, 0>, <0, 0, 0>, 0.002
         scale 1
         rotate z*(-80)
         translate <0.19, 0.06, -1.5>
      }
      
      cylinder {
         <0, 0.25, 0>, <0, 0, 0>, 0.003
         scale 1
         rotate <7, 0, -58>
         translate <0.23, 0.1, -1.4>
      }
      
      cylinder {
         <0, 0.3, 0>, <0, 0, 0>, 0.001
         scale 1
         rotate <-5, 0, -65>
         translate <0.22, 0.1, -1.6>
      }
      
      cylinder {
         <0, 0.24, 0>, <0, 0, 0>, 0.002
         scale 1
         rotate z*80
         translate <-0.1, 0.02, -1.5>
      }
      
      cylinder {
         <0, 0.25, 0>, <0, 0, 0>, 0.003
         scale 1
         rotate <7, 0, 58>
         translate <-0.2, -0.1, -1.4>
      }
      
      cylinder {
         <0, 0.2, 0>, <0, 0, 0>, 0.001
         scale 1
         rotate <-5, 0, 62>
         translate <-0.03, 0.08, -1.6>
      }
      
      pigment {
         color rgb <0.854902, 0.854902, 0.854902>
      }
   }
   
   object {
      Bueschel
      scale 1
      rotate <0, 0, 0>
      translate <-0.00867694, 0.0780925, 0>
   }
   
   object {
      Bueschel
      scale 1
      rotate y*170
      translate <0.0460652, 0.0847078, 0.0774347>
   }
   
   sphere {
      //*PMName Auge
      <0, 0, 0>, 0.17
      scale <1, 0.7, 1>
      rotate x*(-20)
      translate <0.4, 0.2, -0.3>
      
      texture {
         finish {
            phong 0.9
            phong_size 5
            reflection rgb <0.2, 0.2, 0.2>
         }
         
         pigment {
            color rgb <0.027451, 0.027451, 0.027451>
         }
      }
   }
   
   sphere {
      //*PMName Auge
      <0, 0, 0>, 0.17
      scale <1, 0.7, 1>
      rotate x*(-20)
      translate <-0.4, 0.2, -0.3>
      
      texture {
         finish {
            phong 0.9
            phong_size 5
            reflection rgb <0.2, 0.2, 0.2>
         }
         
         pigment {
            color rgb <0.027451, 0.027451, 0.027451>
         }
      }
   }
}

#declare Risse = prism {
   linear_spline
   conic_sweep
   1, 0.9,
   52,
   <411, 221>, <501, 161>, <495, 217>, <618, 143>, <493, 220>, <499, 164>, <405, 227>, <447, 244>, <414, 251>, <493, 285>, <490, 263>, <607, 303>, <491, 265>, <495, 286>, <489, 297>, <552, 328>, <529, 339>, <591, 349>, <524, 340>, <547, 328>, <487, 298>, <492, 286>, <408, 251>, <439, 243>, <403, 229>, <363, 249>, <353, 268>, <310, 274>, <295, 328>, <245, 375>, <294, 326>, <307, 273>, <255, 264>, <128, 304>, <254, 262>, <303, 269>, <292, 249>, <305, 235>, <266, 176>, <307, 235>, <295, 249>, <306, 271>, <352, 266>, <361, 248>, <401, 228>, <367, 185>, <348, 184>, <294, 77>, <349, 182>, <368, 184>, <403, 226>, <411, 221>
   translate <-403, -1, -227>
   scale <0.2, 100, 0.2>
   rotate <-90, -90, 0>
}

#declare Tropfen = union {
   sphere {
      <0, 0, 0>, 0.001
      scale <3.916, 0.891, 0.847>
      translate x*0.617
      rotate <0, 8.51, 17.581>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.822, 0.843, 0.936>
      translate x*0.817
      rotate <0, 10.431, 2.701>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.812, 0.865, 0.916>
      translate x*0.581
      rotate <0, 2.56, 16.736>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.962, 0.871, 0.926>
      translate x*0.204
      rotate <0, 15.476, -20.51>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.964, 0.837, 0.94>
      translate x*0.423
      rotate <0, -4.129, 3.627>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.901, 0.812, 0.956>
      translate x*0.22
      rotate <0, -18.574, 0.348>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.854, 0.847, 0.815>
      translate x*0.042
      rotate <0, 1.012, 3.447>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.935, 0.982, 0.871>
      translate x*0.489
      rotate <0, -7.736, -8.155>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.845, 0.967, 0.96>
      translate x*0.659
      rotate <0, 8.261, 1.261>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.899, 0.896, 0.952>
      translate x*0.326
      rotate <0, 8.562, -12.051>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.838, 0.841, 0.963>
      translate x*0.689
      rotate <0, -6.957, -10.543>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.817, 0.948, 0.869>
      translate x*0.817
      rotate <0, -8.017, -0.801>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.823, 0.928, 0.953>
      translate x*0.974
      rotate <0, -3.445, -22.887>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.922, 0.88, 0.822>
      translate x*0.788
      rotate <0, -3.648, -5.988>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.825, 0.875, 0.888>
      translate x*0.736
      rotate <0, 4.832, 8.248>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.903, 0.935, 0.996>
      translate x*0.653
      rotate <0, 7.506, -11.889>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.915, 0.954, 0.859>
      translate x*0.884
      rotate <0, 17.444, 1.92>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.827, 0.916, 0.843>
      translate x*0.399
      rotate <0, 16.15, 4.042>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.888, 0.895, 0.892>
      translate x*0.538
      rotate <0, -16.939, 1.144>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.913, 0.947, 0.999>
      translate x*0.176
      rotate <0, 9.936, -7.267>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.97, 0.949, 0.851>
      translate x*0.891
      rotate <0, -6.903, -4.4>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.905, 0.85, 0.866>
      translate x*0.279
      rotate <0, -3.024, -16.913>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.872, 0.804, 0.816>
      translate x*0.794
      rotate <0, 2.652, -10.91>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.915, 0.832, 0.969>
      translate x*0.482
      rotate <0, -0.981, -0.443>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.839, 0.904, 0.849>
      translate x*0.656
      rotate <0, 21.978, 4.728>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.98, 0.915, 0.994>
      translate x*0.984
      rotate <0, -5.497, -10.314>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.907, 0.88, 0.819>
      translate x*0.565
      rotate <0, 11.67, -21.18>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.921, 0.882, 0.952>
      translate x*0.471
      rotate <0, -10.297, 9.571>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.942, 0.948, 0.891>
      translate x*0.723
      rotate <0, 4.828, 16.409>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.824, 0.879, 0.844>
      translate x*0.03
      rotate <0, -17.803, -14.772>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.948, 0.883, 0.865>
      translate x*0.58
      rotate <0, 1.376, -12.553>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.851, 0.952, 0.991>
      translate x*0.905
      rotate <0, -5.142, -6.181>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.926, 0.93, 0.861>
      translate x*0.291
      rotate <0, 1.793, -7.428>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.992, 0.952, 0.897>
      translate x*0.362
      rotate <0, 4.612, -13.284>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.875, 0.943, 0.827>
      translate x*0.349
      rotate <0, 13.437, 5.452>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.963, 0.987, 0.909>
      translate x*0.139
      rotate <0, 4.15, -17.633>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.915, 0.838, 0.889>
      translate x*0.542
      rotate <0, 12.715, 4.662>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.974, 0.957, 0.841>
      translate x*0.233
      rotate <0, 8.845, -13.066>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.823, 0.93, 0.896>
      translate x*0.577
      rotate <0, -15.707, 18.078>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.853, 0.852, 0.929>
      translate x*0.032
      rotate <0, -4.93, 10.674>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.856, 0.949, 0.9>
      translate x*0.015
      rotate <0, 8.576, 0.736>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.968, 0.848, 0.988>
      translate x*0.015
      rotate <0, -9.857, 14.025>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.864, 0.809, 0.807>
      translate x*0.376
      rotate <0, 2.68, 1.137>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.921, 0.974, 0.826>
      translate x*0.536
      rotate <0, -23.875, 7.375>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.855, 0.812, 0.84>
      translate x*0.534
      rotate <0, 10.101, 8.97>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.963, 0.898, 0.892>
      translate x*0.433
      rotate <0, 7.672, -5.526>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.925, 0.88, 0.973>
      translate x*0.781
      rotate <0, 8.313, 11.212>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.804, 0.893, 0.921>
      translate x*0.452
      rotate <0, -9.819, -4.536>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.806, 0.971, 0.846>
      translate x*0.18
      rotate <0, 9.512, -2.425>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.853, 0.84, 0.842>
      translate x*0.734
      rotate <0, -1.566, 7.494>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.853, 0.801, 0.836>
      translate x*0.065
      rotate <0, -24.284, -1.721>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.885, 0.821, 0.811>
      translate x*0.871
      rotate <0, 17.96, -5.115>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.815, 0.909, 0.895>
      translate x*0.828
      rotate <0, -0.553, 15.108>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.854, 0.867, 0.95>
      translate x*0.265
      rotate <0, -10.654, -17.178>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.921, 0.891, 0.924>
      translate x*0.352
      rotate <0, -4.784, 0.723>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.955, 0.91, 0.932>
      translate x*0.787
      rotate <0, -2.303, -1.469>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.916, 0.941, 0.801>
      translate x*0.717
      rotate <0, 13.024, -0.799>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.95, 0.995, 0.918>
      translate x*0.994
      rotate <0, 23.478, -6.079>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.881, 0.825, 0.923>
      translate x*0.039
      rotate <0, -12.905, 2.768>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.962, 0.925, 0.862>
      translate x*0.384
      rotate <0, 8.954, -14.352>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.98, 0.928, 0.884>
      translate x*0.585
      rotate <0, 7.074, -14.308>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.855, 0.873, 0.801>
      translate x*0.446
      rotate <0, 16.439, 6.584>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.854, 0.999, 0.858>
      translate x*0.509
      rotate <0, -3.111, -5.688>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.907, 0.834, 0.859>
      translate x*0.5
      rotate <0, -15.413, -3.356>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.917, 0.931, 0.992>
      translate x*0.849
      rotate <0, -3.482, -13.84>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.985, 0.967, 0.849>
      translate x*0.567
      rotate <0, -1.074, -17.048>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.966, 0.896, 0.89>
      translate x*0.651
      rotate <0, 3.852, -6.838>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.828, 0.995, 0.938>
      translate x*0.771
      rotate <0, 6.872, -6.693>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.869, 0.895, 0.992>
      translate x*0.334
      rotate <0, 7.908, 1.867>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.962, 0.994, 0.938>
      translate x*0.018
      rotate <0, -22.575, -7.072>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.829, 0.918, 0.822>
      translate x*0.679
      rotate <0, -1.429, 5.687>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.938, 0.864, 0.985>
      translate x*0.944
      rotate <0, 23.783, 32.428>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.902, 0.875, 0.818>
      translate x*0.054
      rotate <0, -3.878, 6.111>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.922, 0.91, 0.889>
      translate x*0.387
      rotate <0, 1.072, 9.009>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.96, 0.816, 0.813>
      translate x*0.751
      rotate <0, 5.741, 9.865>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.834, 0.902, 1>
      translate x*0.869
      rotate <0, 5.432, -15.171>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.88, 0.881, 0.982>
      translate x*0.551
      rotate <0, 12.218, -21.021>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.952, 0.969, 0.973>
      translate x*0.837
      rotate <0, -9.334, -15.486>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.848, 0.995, 0.815>
      translate x*0.893
      rotate <0, -7.907, -3.257>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.882, 0.993, 0.989>
      translate x*0.668
      rotate <0, 12.665, -12.204>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.848, 0.869, 0.849>
      translate x*0.27
      rotate <0, -1.566, -5.492>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.934, 0.932, 0.903>
      translate x*0.668
      rotate <0, 1.845, 11.223>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.959, 0.804, 0.806>
      translate x*0.714
      rotate <0, 7.48, -1.694>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.858, 0.874, 0.982>
      translate x*0.577
      rotate <0, 9.803, -1.071>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.99, 0.963, 0.969>
      translate x*0.5
      rotate <0, 2.362, 0.257>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.92, 0.932, 0.809>
      translate x*0.315
      rotate <0, -13.591, -7.576>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.993, 0.914, 0.95>
      translate x*0.435
      rotate <0, -4.878, 17.74>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.963, 0.872, 0.897>
      translate x*0.969
      rotate <0, -2.441, -12.622>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.894, 0.804, 0.977>
      translate x*0.356
      rotate <0, 6.258, 9.278>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.914, 0.909, 0.91>
      translate x*0.268
      rotate <0, 11.807, -16.64>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.868, 0.872, 0.958>
      translate x*0.707
      rotate <0, 14.996, 18.12>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.909, 0.846, 0.93>
      translate x*0.043
      rotate <0, -1.909, 18.506>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.801, 0.944, 0.947>
      translate x*0.315
      rotate <0, 7.526, 20.495>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.976, 0.892, 0.957>
      translate x*0.413
      rotate <0, 2.776, 11.09>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.965, 0.947, 0.966>
      translate x*0.738
      rotate <0, 16.402, -6.516>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.965, 0.841, 0.992>
      translate x*0.699
      rotate <0, 12.227, 3.947>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.955, 0.961, 0.915>
      translate x*0.804
      rotate <0, -9.653, -8.502>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.947, 0.845, 0.979>
      translate x*0.308
      rotate <0, 13.139, -2.25>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.904, 0.953, 0.822>
      translate x*0.216
      rotate <0, -0.338, 2.329>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.882, 0.953, 0.876>
      translate x*0.084
      rotate <0, 8.835, 17.071>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.938, 0.818, 0.86>
      translate x*0.336
      rotate <0, 4.469, 7.729>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.884, 0.971, 0.804>
      translate x*0.877
      rotate <0, 7.756, -8.775>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.968, 0.96, 0.889>
      translate x*0.533
      rotate <0, 14.998, -4.495>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.97, 0.895, 0.865>
      translate x*0.315
      rotate <0, 6.358, 9.856>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.902, 0.95, 0.846>
      translate x*0.699
      rotate <0, 3.15, -11.917>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.923, 0.976, 0.872>
      translate x*0.036
      rotate <0, -5.364, 19.223>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.865, 0.984, 0.851>
      translate x*0.816
      rotate <0, -1.456, -21.482>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.862, 0.98, 0.873>
      translate x*0.874
      rotate <0, -5.502, -12.828>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.997, 0.984, 0.829>
      translate x*0.694
      rotate <0, 16.263, -5.083>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.852, 0.988, 0.832>
      translate x*0.737
      rotate <0, 3.199, 22.755>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.943, 0.965, 0.843>
      translate x*0.246
      rotate <0, 21.535, -19.761>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.831, 0.808, 0.825>
      translate x*0.186
      rotate <0, -3.938, 2.461>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.884, 0.801, 0.822>
      translate x*0.926
      rotate <0, -1.45, -3.544>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.906, 0.837, 0.831>
      translate x*0.946
      rotate <0, -7.3, 1.03>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.934, 0.928, 0.982>
      translate x*0.194
      rotate <0, 4.639, -3.981>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.981, 0.959, 0.974>
      translate x*0.865
      rotate <0, 4.96, 22.83>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.846, 0.815, 0.926>
      translate x*0.144
      rotate <0, 1.037, 5.619>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.877, 0.994, 0.984>
      translate x*0.041
      rotate <0, -9.194, -16.256>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.954, 0.823, 0.815>
      translate x*0.644
      rotate <0, 1.445, -10.792>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.806, 0.804, 0.852>
      translate x*0.143
      rotate <0, 4.361, -24.447>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.996, 0.806, 0.915>
      translate x*0.633
      rotate <0, 5.605, -16.765>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.847, 0.867, 0.931>
      translate x*0.14
      rotate <0, 6.33, -13.219>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.84, 0.957, 0.979>
      translate x*0.423
      rotate <0, -16.881, -0.915>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.815, 0.914, 0.962>
      translate x*0.968
      rotate <0, 17.009, 11.967>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.867, 0.969, 0.896>
      translate x*0.153
      rotate <0, -1.283, -14.322>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.834, 0.955, 0.986>
      translate x*0.85
      rotate <0, -7.878, -0.675>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.926, 0.899, 0.966>
      translate x*0.734
      rotate <0, 0.203, 19.194>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.93, 0.982, 0.904>
      translate x*0.286
      rotate <0, -4.317, -7.211>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.908, 0.908, 0.914>
      translate x*0.938
      rotate <0, -3.704, 16.906>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.857, 0.968, 0.966>
      translate x*0.948
      rotate <0, -9.885, -9.631>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.971, 0.978, 0.913>
      translate x*0.482
      rotate <0, -22.423, -5.922>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.945, 0.959, 0.834>
      translate x*0.986
      rotate <0, 9.833, -5.169>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.959, 0.859, 0.835>
      translate x*0.233
      rotate <0, 7.77, 4.899>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.919, 0.989, 0.811>
      translate x*0.479
      rotate <0, 2.529, -5.366>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.925, 0.861, 0.89>
      translate x*0.91
      rotate <0, 18.575, -5.572>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.955, 0.886, 0.971>
      translate x*0.037
      rotate <0, 8.352, 3.12>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.834, 0.845, 0.977>
      translate x*0.893
      rotate <0, -12.737, 10.511>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.814, 0.817, 0.892>
      translate x*0.792
      rotate <0, 9.228, 1.901>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.835, 0.913, 0.806>
      translate x*0.028
      rotate <0, 6.261, 6.639>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.857, 0.948, 0.826>
      translate x*0.286
      rotate <0, -1.484, 12.432>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.883, 0.869, 0.813>
      translate x*0.527
      rotate <0, -0.053, -3.274>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.841, 0.948, 0.899>
      translate x*0.987
      rotate <0, -12.763, 21.734>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <4, 0.841, 0.829>
      translate x*0.35
      rotate <0, 13.856, -3.238>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.816, 0.826, 0.882>
      translate x*0.442
      rotate <0, -6.92, -1.777>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.856, 0.837, 0.829>
      translate x*0.691
      rotate <0, -8.45, -1.681>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.941, 0.927, 0.826>
      translate x*0.303
      rotate <0, 4.415, -0.371>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.865, 0.925, 0.812>
      translate x*0.423
      rotate <0, 12.325, 20.875>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.999, 0.867, 0.999>
      translate x*0.731
      rotate <0, 1.524, -15.03>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.96, 0.916, 0.847>
      translate x*0.642
      rotate <0, -10.98, -4.074>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.96, 0.953, 0.928>
      translate x*0.918
      rotate <0, 3.278, -7.452>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.961, 0.93, 0.835>
      translate x*0.666
      rotate <0, -8.885, 9.852>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.873, 0.952, 0.863>
      translate x*0.726
      rotate <0, -6.538, 7.925>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.998, 0.828, 0.911>
      translate x*0.126
      rotate <0, -11.653, 10.513>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.913, 0.85, 0.983>
      translate x*0.687
      rotate <0, 6.989, -20.122>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.985, 0.999, 0.956>
      translate x*0.002
      rotate <0, -11.938, -3.463>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.981, 0.985, 0.967>
      translate x*0.859
      rotate <0, 2.202, -7.738>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.92, 0.97, 0.828>
      translate x*0.736
      rotate <0, -14.467, -13.735>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.984, 0.882, 0.925>
      translate x*0.294
      rotate <0, 3.494, -18.214>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.922, 0.836, 0.878>
      translate x*0.797
      rotate <0, -7.564, -6.664>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.879, 0.876, 0.835>
      translate x*0.099
      rotate <0, 8.465, -6.358>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.847, 0.878, 0.88>
      translate x*0.304
      rotate <0, 6.732, 13.865>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.929, 0.944, 0.973>
      translate x*0.342
      rotate <0, -0.177, -7.021>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.916, 0.867, 0.822>
      translate x*0.596
      rotate <0, -2.844, -11.802>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.936, 0.948, 0.977>
      translate x*0.313
      rotate <0, -23.737, 8.175>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.901, 0.916, 0.992>
      translate x*0.854
      rotate <0, -6.465, 6.192>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.807, 0.999, 0.942>
      translate x*0.856
      rotate <0, 18.536, 19.878>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.979, 0.887, 0.914>
      translate x*0.16
      rotate <0, -3.842, -0.984>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.917, 0.841, 0.881>
      translate x*0.803
      rotate <0, -7.077, -0.202>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.925, 0.904, 0.86>
      translate x*0.602
      rotate <0, -0.585, 2.417>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.925, 0.879, 0.844>
      translate x*0.724
      rotate <0, 0.34, 5.193>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.841, 0.89, 0.988>
      translate x*0.306
      rotate <0, -13.083, 6.432>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.816, 0.83, 0.943>
      translate x*0.515
      rotate <0, -2.717, 13.051>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.992, 0.974, 0.948>
      translate x*0.509
      rotate <0, 1.329, -3.487>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.902, 0.943, 0.87>
      translate x*0.553
      rotate <0, 20.849, -12.097>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.851, 0.983, 0.893>
      translate x*0.046
      rotate <0, 26.124, 5.037>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.874, 0.85, 0.84>
      translate x*0.424
      rotate <0, -3.972, 23.263>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.815, 0.968, 0.838>
      translate x*0.879
      rotate <0, -1.524, -1.839>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.946, 0.896, 0.87>
      translate x*0.461
      rotate <0, -18.493, 6.646>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.811, 0.883, 0.816>
      translate x*0.526
      rotate <0, -9.475, 16.997>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.852, 0.927, 0.824>
      translate x*0.599
      rotate <0, -11.807, -7.857>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.937, 0.861, 0.85>
      translate x*0.519
      rotate <0, 14.21, 2.075>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.861, 0.861, 0.806>
      translate x*0.285
      rotate <0, -1.331, 10.515>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.862, 0.9, 0.919>
      translate x*0.268
      rotate <0, -9.087, 20.065>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.876, 0.928, 0.87>
      translate x*0.44
      rotate <0, 5.819, 8.78>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.832, 0.922, 0.817>
      translate x*0.937
      rotate <0, 1.111, 9.719>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.857, 0.818, 0.903>
      translate x*0.723
      rotate <0, 14.828, -6.743>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.907, 0.898, 0.984>
      translate x*0.213
      rotate <0, -0.726, -17.987>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.954, 0.904, 0.952>
      translate x*0.59
      rotate <0, -5.233, 0.042>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.979, 0.909, 0.924>
      translate x*0.096
      rotate <0, -14.79, -4.555>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.889, 0.892, 0.976>
      translate x*0.894
      rotate <0, 0.012, 2.879>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.879, 0.945, 0.968>
      translate x*0.06
      rotate <0, 9.092, 1.467>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.858, 0.954, 0.954>
      translate x*0.026
      rotate <0, -8.318, 18.393>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.846, 0.995, 0.911>
      translate x*0.226
      rotate <0, -6.627, -14.978>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.811, 0.808, 0.858>
      translate x*0.834
      rotate <0, 11.331, 14.665>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.952, 0.946, 0.977>
      translate x*0.411
      rotate <0, -15.188, 3.142>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.87, 0.894, 0.921>
      translate x*0.827
      rotate <0, -2.88, -20.896>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.857, 0.931, 0.938>
      translate x*0.173
      rotate <0, 15.838, -17.412>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.844, 0.802, 0.998>
      translate x*0.405
      rotate <0, 2.672, -8.407>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.995, 0.955, 0.945>
      translate x*0.218
      rotate <0, -15.547, -28.507>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.903, 0.828, 0.95>
      translate x*0.11
      rotate <0, -11.168, 10.879>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.855, 0.936, 0.801>
      translate x*0.81
      rotate <0, -8.087, 9.99>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.868, 0.883, 0.96>
      translate x*0.142
      rotate <0, -3.433, 0.163>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.969, 0.879, 0.924>
      translate x*0.024
      rotate <0, -0.615, 2.766>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.885, 0.942, 0.809>
      translate x*0.65
      rotate <0, -20.803, -8.118>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.959, 0.834, 0.83>
      translate x*0.994
      rotate <0, -1.177, 30.548>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.829, 0.969, 0.902>
      translate x*0.518
      rotate <0, -5.797, -2.374>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.965, 0.855, 0.896>
      translate x*0.508
      rotate <0, -32.744, -4.545>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.915, 0.992, 0.802>
      translate x*0.672
      rotate <0, -3.184, -0.824>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.909, 0.905, 0.928>
      translate x*0.574
      rotate <0, -16.277, -14.789>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.961, 0.967, 0.94>
      translate x*0.135
      rotate <0, -4.402, -13.374>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.991, 0.819, 0.982>
      translate x*0.835
      rotate <0, -5.923, -12.831>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.879, 0.808, 0.963>
      translate x*0.322
      rotate <0, 4.264, -8.442>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.813, 0.989, 0.883>
      translate x*0.95
      rotate <0, -13.143, 13.128>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.933, 0.918, 0.901>
      translate x*0.346
      rotate <0, 21.923, -2.759>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.993, 0.958, 0.974>
      translate x*0.303
      rotate <0, -6.531, -2.097>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.848, 0.905, 0.893>
      translate x*0.305
      rotate <0, 3.995, -14.186>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.978, 0.91, 0.844>
      translate x*0.684
      rotate <0, 15.881, 16.622>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.808, 0.904, 0.969>
      translate x*0.801
      rotate <0, -28.009, 4.438>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.825, 0.936, 0.875>
      translate x*0.786
      rotate <0, 15.055, -8.285>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.927, 0.905, 0.929>
      translate x*0.211
      rotate <0, -3.597, -5.632>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.94, 0.943, 0.847>
      translate x*0.66
      rotate <0, -8.663, -1.431>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.923, 0.804, 0.905>
      translate x*0.413
      rotate <0, 8.896, 8.927>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.864, 0.82, 0.947>
      translate x*0.488
      rotate <0, -9.983, -7.19>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.888, 0.864, 0.952>
      translate x*0.009
      rotate <0, 6.044, 0.344>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.982, 0.805, 0.915>
      translate x*0.297
      rotate <0, 15.288, 8.187>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.986, 0.82, 0.962>
      translate x*0.255
      rotate <0, 12.809, 5.427>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.958, 0.973, 0.979>
      translate x*0.49
      rotate <0, -2.192, 8.029>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.858, 0.807, 0.932>
      translate x*0.218
      rotate <0, -15.995, 6.035>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.851, 0.889, 0.812>
      translate x*0.31
      rotate <0, -8.895, 7.229>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.888, 0.849, 0.99>
      translate x*0.887
      rotate <0, -16.068, -5.669>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.832, 0.844, 0.86>
      translate x*0.603
      rotate <0, -13.983, -16.252>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.983, 0.976, 0.909>
      translate x*0.254
      rotate <0, -17.56, -1.231>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.96, 0.825, 0.966>
      translate x*0.522
      rotate <0, 10.413, 4.58>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.941, 0.826, 0.815>
      translate x*0.596
      rotate <0, 15.604, -11.211>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.821, 0.929, 0.963>
      translate x*0.014
      rotate <0, -0.608, 1.176>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.956, 0.885, 0.909>
      translate x*0.455
      rotate <0, 1.256, -9.804>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.993, 0.877, 0.84>
      translate x*0.233
      rotate <0, 7.193, -8.735>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.825, 0.921, 0.819>
      translate x*0.076
      rotate <0, 17.572, -6.816>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.856, 0.83, 0.849>
      translate x*0.243
      rotate <0, 6.023, 14.069>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.917, 0.881, 0.9>
      translate x*0.278
      rotate <0, -1.045, 8.97>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.992, 0.876, 0.882>
      translate x*0.629
      rotate <0, 11.037, -0.14>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.959, 0.886, 0.997>
      translate x*0.025
      rotate <0, 5.408, 1.023>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.994, 0.883, 0.971>
      translate x*0.893
      rotate <0, 4.671, 4.841>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.815, 0.913, 0.885>
      translate x*0.176
      rotate <0, -4.363, 10.837>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.847, 0.982, 0.928>
      translate x*0.751
      rotate <0, 3.564, 0.31>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.987, 0.877, 0.806>
      translate x*0.17
      rotate <0, -3.912, 12.232>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.982, 0.883, 0.902>
      translate x*0.704
      rotate <0, 5.268, 7.086>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.943, 0.82, 0.825>
      translate x*0.644
      rotate <0, 4.15, 18.14>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.873, 0.983, 0.96>
      translate x*0.509
      rotate <0, 1.99, -19.846>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.881, 0.819, 0.898>
      translate x*0.217
      rotate <0, 13.727, -14.144>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.974, 0.978, 0.962>
      translate x*0.407
      rotate <0, 2.558, -17.492>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.94, 0.81, 0.908>
      translate x*0.951
      rotate <0, -6.59, 8.716>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.979, 0.823, 0.942>
      translate x*0.251
      rotate <0, -14.147, 17.154>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.969, 0.841, 0.84>
      translate x*0.229
      rotate <0, 1.468, -19.833>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.883, 0.862, 0.97>
      translate x*0.881
      rotate <0, 2.907, -3.75>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.961, 0.864, 0.85>
      translate x*0.039
      rotate <0, -20.136, -1.789>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.936, 0.872, 0.803>
      translate x*0.383
      rotate <0, -9.101, -3.665>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.97, 0.863, 0.92>
      translate x*0.929
      rotate <0, 11.531, 12.177>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.88, 0.941, 0.997>
      translate x*0.104
      rotate <0, -15.74, 6.64>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.909, 0.938, 0.929>
      translate x*0.101
      rotate <0, 7.116, 3.796>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.833, 0.822, 0.889>
      translate x*0.53
      rotate <0, 10.114, 15.425>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.954, 0.842, 0.945>
      translate x*0.426
      rotate <0, 1.414, -3.444>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.938, 0.986, 0.833>
      translate x*0.415
      rotate <0, 5.259, 13.331>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.847, 0.88, 0.866>
      translate x*0.335
      rotate <0, -10.291, -2.713>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.826, 0.918, 0.975>
      translate x*0.765
      rotate <0, 1.926, 2.704>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.924, 0.982, 0.917>
      translate x*0.871
      rotate <0, -19.75, -8.038>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.913, 0.97, 0.872>
      translate x*0.568
      rotate <0, 7.517, -0.141>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.868, 0.95, 0.83>
      translate x*0.372
      rotate <0, -14.939, -8.324>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.884, 0.826, 0.938>
      translate x*0.372
      rotate <0, 5.554, -0.736>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.903, 0.995, 0.905>
      translate x*0.538
      rotate <0, -10.672, -1.231>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.874, 0.987, 0.903>
      translate x*0.092
      rotate <0, -16.953, -17.402>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.934, 0.856, 0.893>
      translate x*0.885
      rotate <0, -6.44, 9.067>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.821, 0.831, 0.995>
      translate x*0.67
      rotate <0, -20.487, -22.334>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.851, 0.928, 0.994>
      translate x*0.824
      rotate <0, -11.24, 16.208>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.971, 0.957, 0.912>
      translate x*0.448
      rotate <0, -9.153, -1.873>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.99, 0.988, 0.808>
      translate x*0.865
      rotate <0, -5.187, -21.983>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.931, 0.87, 0.998>
      translate x*0.385
      rotate <0, -12.717, 13.011>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.894, 0.84, 0.83>
      translate x*0.688
      rotate <0, 10.312, -13.09>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.949, 0.812, 0.997>
      translate x*0.489
      rotate <0, -1.356, 4.999>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.838, 0.973, 0.837>
      translate x*0.082
      rotate <0, -7.95, 16.283>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.904, 0.899, 0.892>
      translate x*0.072
      rotate <0, 10.122, 14.414>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.975, 0.849, 0.846>
      translate x*0.001
      rotate <0, 0.383, 12.86>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.804, 0.868, 0.899>
      translate x*0.722
      rotate <0, -6.213, -0.079>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.88, 0.827, 0.903>
      translate x*0.215
      rotate <0, 4.69, -5.024>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.948, 0.893, 0.839>
      translate x*0.089
      rotate <0, -0.949, 0.882>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.818, 0.824, 0.874>
      translate x*0.334
      rotate <0, 1.152, -9.251>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.883, 0.878, 0.84>
      translate x*0.87
      rotate <0, 3.31, 12.338>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.838, 0.825, 0.993>
      translate x*0.161
      rotate <0, -2.942, 4.123>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.99, 0.979, 0.9>
      translate x*0.618
      rotate <0, -2.022, -2.396>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.913, 0.849, 0.852>
      translate x*0.664
      rotate <0, 21.87, -1.257>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.927, 0.87, 0.969>
      translate x*0.23
      rotate <0, -0.866, -22.58>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.926, 0.974, 0.881>
      translate x*0.02
      rotate <0, -16.743, -8.368>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.882, 0.804, 0.973>
      translate x*0.246
      rotate <0, 1.994, 8.645>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.819, 0.935, 0.903>
      translate x*0.512
      rotate <0, 8.316, -5.353>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.951, 0.873, 0.932>
      translate x*0.338
      rotate <0, -11.56, 15.46>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.807, 0.994, 0.904>
      translate x*0.253
      rotate <0, -3.795, 3.665>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.893, 0.836, 0.909>
      translate x*0.585
      rotate <0, -5.188, 6.04>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.884, 0.898, 0.918>
      translate x*0.997
      rotate <0, 18.403, -10.512>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.88, 0.813, 0.84>
      translate x*0.435
      rotate <0, 1.189, -10.323>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.804, 0.915, 0.862>
      translate x*0.519
      rotate <0, -7.184, 6.418>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.998, 0.899, 0.871>
      translate x*0.451
      rotate <0, -2.627, 19.306>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.883, 0.889, 0.912>
      translate x*0.328
      rotate <0, -8.055, -11.511>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.813, 0.912, 0.958>
      translate x*0.228
      rotate <0, -13.197, -1.576>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.889, 0.971, 0.964>
      translate x*0.687
      rotate <0, -4.654, 9.304>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.855, 0.837, 0.866>
      translate x*0.092
      rotate <0, -4.398, 1.349>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.877, 0.89, 0.873>
      translate x*0.213
      rotate <0, -33.42, -12.535>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.84, 0.853, 0.803>
      translate x*0.456
      rotate <0, -20.001, 1.804>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.934, 0.913, 0.903>
      translate x*0.522
      rotate <0, -11.105, -2.451>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.981, 0.823, 0.939>
      translate x*0.962
      rotate <0, 11.319, -1.215>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.984, 0.861, 0.996>
      translate x*0.696
      rotate <0, -4.157, -23.387>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.9, 0.84, 0.951>
      translate x*0.757
      rotate <0, 7.783, 10.689>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.93, 0.826, 0.975>
      translate x*0.547
      rotate <0, -4.941, -1.816>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.814, 0.988, 0.922>
      translate x*0.556
      rotate <0, 4.315, 2.663>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.972, 0.854, 0.806>
      translate x*0.925
      rotate <0, -2.592, -0.287>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.979, 0.834, 0.86>
      translate x*0.334
      rotate <0, 1.597, -13.85>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.881, 0.953, 0.929>
      translate x*0.585
      rotate <0, -14.255, -8.547>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.978, 0.893, 0.849>
      translate x*0.785
      rotate <0, 13.572, 7.596>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.972, 0.975, 0.866>
      translate x*0.334
      rotate <0, -0.529, -7.262>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.952, 0.882, 0.802>
      translate x*0.921
      rotate <0, -9.376, -10.711>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.855, 0.833, 0.854>
      translate x*0.471
      rotate <0, -2.861, -8.376>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.83, 0.928, 0.932>
      translate x*0.409
      rotate <0, -2.349, -8.703>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.801, 0.914, 0.968>
      translate x*0.763
      rotate <0, -6.699, -22.134>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.974, 0.817, 0.807>
      translate x*0.554
      rotate <0, -11.751, -18.52>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.912, 0.84, 0.809>
      translate x*0.444
      rotate <0, -0.169, -2.799>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.804, 0.955, 0.802>
      translate x*0.014
      rotate <0, -1.774, -17.474>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.816, 0.931, 0.919>
      translate x*0.999
      rotate <0, 3.94, 0.898>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.901, 0.851, 0.922>
      translate x*0.639
      rotate <0, 3.672, -16.986>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.997, 0.84, 0.883>
      translate x*0.712
      rotate <0, 5.094, 14.552>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.854, 0.868, 0.905>
      translate x*0.05
      rotate <0, 26.784, 1.433>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.969, 0.998, 0.806>
      translate x*0.239
      rotate <0, 7.064, 4.086>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.869, 0.952, 0.876>
      translate x*0.822
      rotate <0, 10.689, -21.845>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.898, 0.847, 0.994>
      translate x*0.692
      rotate <0, -24.677, 10.934>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.881, 0.806, 0.964>
      translate x*0.409
      rotate <0, -1.53, -7.681>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.996, 0.999, 0.853>
      translate x*0.984
      rotate <0, -8.001, 6.366>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.905, 0.898, 0.858>
      translate x*0.158
      rotate <0, -6.386, -13.407>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.979, 0.993, 0.924>
      translate x*0.432
      rotate <0, -5.372, 0.932>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.857, 0.882, 0.803>
      translate x*0.06
      rotate <0, -10.897, 12.794>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.816, 0.895, 0.961>
      translate x*0.86
      rotate <0, 14.891, 14.993>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.885, 0.918, 0.916>
      translate x*0.085
      rotate <0, -1.631, 13.314>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.97, 0.909, 0.892>
      translate x*0.703
      rotate <0, 3.586, 14.297>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.943, 0.959, 0.832>
      translate x*0.236
      rotate <0, -0.67, -16.651>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.846, 0.943, 0.839>
      translate x*0.857
      rotate <0, 26.034, -7.412>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.937, 0.817, 0.851>
      translate x*0.694
      rotate <0, 8.724, -3.131>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.94, 0.807, 0.964>
      translate x*0.266
      rotate <0, -25.856, -6.804>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.897, 0.949, 0.892>
      translate x*0.663
      rotate <0, 5.956, 17.326>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.939, 0.871, 0.813>
      translate x*0.501
      rotate <0, -0.645, -12.409>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.981, 0.887, 0.937>
      translate x*0.803
      rotate <0, -4.305, -15.95>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.922, 0.975, 1>
      translate x*0.818
      rotate <0, -15.32, 2.865>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.879, 0.956, 0.963>
      translate x*0.352
      rotate <0, -11.588, -0.696>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.839, 0.915, 0.835>
      translate x*0.45
      rotate <0, 4.054, -3.888>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.919, 0.896, 0.947>
      translate x*0.33
      rotate <0, -3.898, -9.021>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.917, 0.986, 0.831>
      translate x*0.117
      rotate <0, -8.773, 11.67>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.944, 0.942, 0.837>
      translate x*0.43
      rotate <0, 14.393, 19.881>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.853, 0.82, 0.968>
      translate x*0.015
      rotate <0, 2.401, -0.799>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.962, 0.865, 0.989>
      translate x*0.471
      rotate <0, -7.727, -5.408>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.964, 0.902, 0.986>
      translate x*0.77
      rotate <0, -9.157, -3.426>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.934, 0.837, 0.847>
      translate x*0.535
      rotate <0, 0.643, -25.132>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.839, 0.885, 0.86>
      translate x*0.105
      rotate <0, -2.313, -4.485>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.806, 0.925, 0.861>
      translate x*0.168
      rotate <0, 0.919, 6.539>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.972, 1, 0.841>
      translate x*0.215
      rotate <0, 1.143, 2.007>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.854, 0.972, 0.958>
      translate x*0.246
      rotate <0, 12.904, 8.89>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.814, 0.981, 0.908>
      translate x*0.102
      rotate <0, 4.335, 5.392>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.942, 0.963, 0.807>
      translate x*0.393
      rotate <0, 11.15, -10.516>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.828, 0.899, 0.918>
      translate x*0.361
      rotate <0, 11.987, -3.85>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.855, 0.954, 0.929>
      translate x*0.076
      rotate <0, -10.985, 15.392>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.882, 0.823, 0.806>
      translate x*0.16
      rotate <0, -15.832, -1.665>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.822, 0.945, 0.992>
      translate x*0.721
      rotate <0, 11.658, -0.184>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.869, 0.802, 0.809>
      translate x*0.418
      rotate <0, -18.674, 4.615>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.891, 0.873, 0.823>
      translate x*0.512
      rotate <0, -10.833, 17.049>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.978, 0.995, 0.98>
      translate x*0.426
      rotate <0, 24.824, 19.904>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.954, 0.827, 0.99>
      translate x*0.706
      rotate <0, -0.946, -7.236>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.821, 0.933, 0.847>
      translate x*0.394
      rotate <0, 7.194, 5.541>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.99, 0.937, 0.988>
      translate x*0.607
      rotate <0, -10.676, -1.416>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.927, 0.841, 0.809>
      translate x*0.694
      rotate <0, 4.338, -9.998>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.847, 0.951, 0.978>
      translate x*0.564
      rotate <0, 3.356, 9.915>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.909, 0.903, 0.803>
      translate x*0.77
      rotate <0, -8.126, -5.912>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.999, 0.849, 0.8>
      translate x*0.616
      rotate <0, -2.215, 7.994>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.926, 0.912, 0.938>
      translate x*0.979
      rotate <0, 1.877, 12.585>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.906, 0.817, 0.944>
      translate x*0.648
      rotate <0, -1.36, -6.855>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.831, 0.866, 0.934>
      translate x*0.851
      rotate <0, 10.202, 12.345>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.935, 0.811, 0.86>
      translate x*0.192
      rotate <0, -9.083, -13.819>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.94, 0.87, 0.967>
      translate x*0.517
      rotate <0, -9.371, -15.236>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.951, 0.949, 0.812>
      translate x*0.23
      rotate <0, 10.844, -7.048>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.904, 0.995, 0.85>
      translate x*0.297
      rotate <0, 26.039, -11.365>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.825, 0.863, 0.96>
      translate x*0.63
      rotate <0, -7.969, 8.986>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.922, 0.954, 0.841>
      translate x*0.698
      rotate <0, -11.152, 5.319>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.899, 0.934, 0.967>
      translate x*0.082
      rotate <0, -9.27, 3.196>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.877, 0.959, 0.934>
      translate x*0.32
      rotate <0, 12.899, 10.237>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.933, 0.859, 0.91>
      translate x*0.658
      rotate <0, -6.571, 17.633>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.94, 0.9, 0.81>
      translate x*0.411
      rotate <0, -26.94, -13.38>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.876, 0.957, 0.904>
      translate x*0.358
      rotate <0, -8.004, -1.759>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.909, 0.918, 0.99>
      translate x*0.068
      rotate <0, 10.721, 21.507>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.893, 0.974, 0.92>
      translate x*0.281
      rotate <0, 9.59, -14.417>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.936, 0.824, 0.892>
      translate x*0.332
      rotate <0, 9.421, 5.952>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.881, 0.902, 0.883>
      translate x*0.272
      rotate <0, -5.444, -7.484>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.819, 0.916, 0.826>
      translate x*0.675
      rotate <0, 10.818, 3.405>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.82, 0.843, 0.857>
      translate x*0.18
      rotate <0, -2.471, -6.219>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.99, 0.961, 0.913>
      translate x*0.621
      rotate <0, 15.23, 4.247>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.88, 0.958, 0.893>
      translate x*0.089
      rotate <0, 8.963, 2.466>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.899, 0.989, 0.884>
      translate x*0.496
      rotate <0, -7.042, -1.567>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.927, 0.835, 0.847>
      translate x*0.155
      rotate <0, -7.7, 10.327>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.81, 0.963, 0.834>
      translate x*0.558
      rotate <0, 2.605, -3.776>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.86, 0.99, 0.835>
      translate x*0.902
      rotate <0, 18, -5.078>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.805, 0.881, 0.992>
      translate x*0.006
      rotate <0, -5.374, 16.974>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.924, 0.963, 0.952>
      translate x*0.12
      rotate <0, -10.34, 22.537>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.936, 0.859, 0.871>
      translate x*0.597
      rotate <0, 0.308, -0.068>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.912, 0.805, 0.808>
      translate x*0.718
      rotate <0, -16.58, -10.133>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <4, 0.868, 0.968>
      translate x*0.89
      rotate <0, -3.581, 5.043>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.921, 0.926, 0.804>
      translate x*0.157
      rotate <0, -4.106, 17.421>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.969, 0.965, 0.891>
      translate x*0.348
      rotate <0, -10.273, 9.701>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.865, 0.997, 0.815>
      translate x*0.347
      rotate <0, -22.159, -6.38>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.881, 0.988, 0.949>
      translate x*0.794
      rotate <0, -4.383, 5.438>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.913, 0.979, 0.898>
      translate x*0.107
      rotate <0, 4.784, 2.562>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.903, 0.862, 0.81>
      translate x*0.984
      rotate <0, -0.976, 0.501>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.957, 0.874, 0.978>
      translate x*0.584
      rotate <0, -2.193, -9.585>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.865, 0.984, 0.962>
      translate x*0.263
      rotate <0, -8.103, 8.303>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.967, 0.95, 0.853>
      translate x*0.225
      rotate <0, -26.254, 31.406>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.895, 0.929, 0.862>
      translate x*0.58
      rotate <0, 7.422, -0.298>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.854, 0.974, 0.958>
      translate x*0.199
      rotate <0, -2.009, 4.392>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.944, 0.853, 0.83>
      translate x*0.344
      rotate <0, 5.207, -4.909>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.993, 0.874, 0.927>
      translate x*0.375
      rotate <0, 3.119, -7.049>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.933, 0.932, 0.863>
      translate x*0.865
      rotate <0, -4.335, -13.752>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.913, 0.863, 0.899>
      translate x*0.224
      rotate <0, 2.571, -8.005>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.808, 0.905, 0.919>
      translate x*0.38
      rotate <0, -6.199, -16.06>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.821, 0.973, 0.902>
      translate x*0.285
      rotate <0, -1.393, 5.847>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.939, 0.975, 0.963>
      translate x*0.913
      rotate <0, -1.374, -10.772>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.977, 0.909, 0.972>
      translate x*0.04
      rotate <0, -18.257, 8.771>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.842, 0.827, 0.813>
      translate x*0.461
      rotate <0, -3.579, 16.452>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.856, 0.867, 0.824>
      translate x*0.346
      rotate <0, -7.114, -11.095>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.977, 0.91, 0.979>
      translate x*0.25
      rotate <0, 16.066, -22.136>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.831, 0.952, 0.841>
      translate x*0.769
      rotate <0, -14.591, 14.583>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.88, 0.861, 0.837>
      translate x*0.067
      rotate <0, 18.647, 13.877>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.834, 0.914, 0.907>
      translate x*0.464
      rotate <0, -1.646, 16.005>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.889, 0.902, 0.822>
      translate x*0.896
      rotate <0, 21.567, 10.894>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.984, 0.949, 0.93>
      translate x*0.46
      rotate <0, -5.992, 1.223>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.835, 0.988, 0.904>
      translate x*0.378
      rotate <0, -0.611, 6.702>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.974, 0.987, 0.9>
      translate x*0.467
      rotate <0, -8.95, 3.417>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.839, 0.853, 0.902>
      translate x*0.82
      rotate <0, -2.4, 9.37>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.902, 0.903, 0.813>
      translate x*0.587
      rotate <0, 2.509, 10.43>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.897, 0.817, 0.812>
      translate x*0.761
      rotate <0, 1.551, -6.344>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.816, 0.985, 0.816>
      translate x*0.551
      rotate <0, 1.725, 25.523>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.886, 0.993, 0.824>
      translate x*0.337
      rotate <0, -15.237, 16.858>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.986, 0.982, 0.805>
      translate x*0.334
      rotate <0, 13.561, -29.675>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.992, 0.89, 0.866>
      translate x*0.937
      rotate <0, 2.837, -5.894>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.855, 0.979, 0.918>
      translate x*0.293
      rotate <0, -21.938, -25.051>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.866, 0.916, 0.877>
      translate x*0.915
      rotate <0, 13.172, 11.044>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.987, 0.913, 0.873>
      translate x*0.189
      rotate <0, -0.206, -1.763>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.821, 0.891, 0.944>
      translate x*0.318
      rotate <0, -5.278, -18.126>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.867, 0.884, 0.874>
      translate x*0.702
      rotate <0, -5.933, 7.102>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.893, 0.984, 0.997>
      translate x*0.919
      rotate <0, -11.995, -13.251>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.967, 0.966, 0.955>
      translate x*0.339
      rotate <0, 15.282, 5.947>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.951, 0.862, 0.899>
      translate x*0.02
      rotate <0, -6.422, 12.449>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.832, 0.977, 0.967>
      translate x*0.825
      rotate <0, 2.6, 5.112>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.987, 0.987, 0.929>
      translate x*0.777
      rotate <0, -2.79, 10.348>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.905, 0.818, 0.991>
      translate x*0.366
      rotate <0, 0.161, -12.665>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.889, 0.932, 0.993>
      translate x*0.06
      rotate <0, 11.953, 3.61>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.944, 0.934, 0.871>
      translate x*0.406
      rotate <0, -16.925, -2.817>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.907, 0.962, 0.864>
      translate x*0.068
      rotate <0, -2.643, 5.598>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.842, 0.804, 0.964>
      translate x*0.735
      rotate <0, -1.602, 4.43>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.817, 0.852, 0.874>
      translate x*0.218
      rotate <0, 2.009, -14.54>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.818, 0.916, 0.887>
      translate x*0.091
      rotate <0, 16.311, -21.654>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.911, 0.872, 0.875>
      translate x*0.042
      rotate <0, 5.659, 14.866>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.871, 0.846, 0.86>
      translate x*0.597
      rotate <0, -3.274, -8.131>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.893, 0.838, 0.984>
      translate x*0.085
      rotate <0, -12.886, 3.854>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.987, 0.975, 0.941>
      translate x*0.69
      rotate <0, -1.463, -11.376>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.93, 0.836, 0.829>
      translate x*0.064
      rotate <0, -5.858, -0.23>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.87, 0.974, 0.827>
      translate x*0.379
      rotate <0, -15.274, 3.765>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.824, 0.825, 0.91>
      translate x*0.773
      rotate <0, -2.405, 1.247>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.997, 0.901, 0.842>
      translate x*0.983
      rotate <0, 2.557, 3.599>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.862, 0.83, 0.893>
      translate x*0.48
      rotate <0, 13.973, -2.776>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.877, 0.921, 0.86>
      translate x*0.688
      rotate <0, -3.933, 2.973>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.806, 0.828, 0.963>
      translate x*0.818
      rotate <0, 14.643, -13.062>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.99, 0.803, 0.908>
      translate x*0.582
      rotate <0, 26.072, -2.617>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.883, 0.937, 0.924>
      translate x*0.414
      rotate <0, -14.059, -5.112>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.811, 0.909, 0.886>
      translate x*0.002
      rotate <0, 10.912, -3.226>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.932, 0.911, 0.905>
      translate x*0.745
      rotate <0, -5.63, 4.724>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.88, 0.92, 0.844>
      translate x*0.342
      rotate <0, 3.153, -13.994>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.874, 0.857, 0.843>
      translate x*0.986
      rotate <0, 9.105, -5.973>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.83, 0.916, 0.968>
      translate x*0.674
      rotate <0, -4.537, 2.953>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.965, 0.866, 0.902>
      translate x*0.816
      rotate <0, -3.962, -6.037>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.826, 0.965, 0.992>
      translate x*0.82
      rotate <0, -17.124, -20.804>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.873, 0.982, 0.902>
      translate x*0.462
      rotate <0, -0.42, 7.77>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.839, 0.923, 0.917>
      translate x*0.729
      rotate <0, -5.322, 14.291>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.983, 0.901, 0.82>
      translate x*0.449
      rotate <0, -17.577, 0.039>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.895, 0.909, 0.831>
      translate x*0.293
      rotate <0, -4.889, -3.427>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.834, 0.921, 0.932>
      translate x*0.822
      rotate <0, 3.5, -5.216>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.835, 0.854, 0.818>
      translate x*0.966
      rotate <0, 14.136, 9.463>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.994, 0.834, 0.956>
      translate x*0.819
      rotate <0, 0.353, 14.235>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.819, 0.893, 0.853>
      translate x*0.813
      rotate <0, -12.537, -19.746>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.812, 0.987, 0.879>
      translate x*0.259
      rotate <0, 8.122, -7.649>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.801, 0.89, 0.968>
      translate x*0.855
      rotate <0, 15.061, -1.661>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.809, 0.897, 0.906>
      translate x*0.128
      rotate <0, 9.392, 7.009>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.94, 0.972, 0.888>
      translate x*0.83
      rotate <0, -22.619, 11.851>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.868, 0.946, 0.932>
      translate x*0.107
      rotate <0, -16.909, 16.843>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.835, 0.868, 0.919>
      translate x*0.746
      rotate <0, 10.499, -6.31>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.893, 0.849, 0.869>
      translate x*0.056
      rotate <0, -5.315, -1.314>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.863, 0.801, 0.995>
      translate x*0.849
      rotate <0, 11.407, 5.889>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.981, 0.918, 0.928>
      translate x*0.68
      rotate <0, 19.863, 7.618>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.829, 0.871, 0.946>
      translate x*0.864
      rotate <0, 10.657, 5.309>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.88, 0.902, 0.887>
      translate x*0.885
      rotate <0, 3.957, -24.456>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.879, 0.945, 0.82>
      translate x*0.65
      rotate <0, 15.595, 7.619>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.889, 0.945, 0.951>
      translate x*0.56
      rotate <0, 5.284, 6.312>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.99, 0.895, 0.811>
      translate x*0.618
      rotate <0, 9.391, 20.528>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.857, 0.942, 0.926>
      translate x*0.799
      rotate <0, 24.669, -0.687>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.902, 0.925, 0.909>
      translate x*0.554
      rotate <0, -6.918, 3.247>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.945, 0.909, 0.819>
      translate x*0.786
      rotate <0, -6.678, -28.461>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.898, 0.897, 0.953>
      translate x*0.703
      rotate <0, 11.859, -16.855>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.913, 0.975, 0.889>
      translate x*0.861
      rotate <0, -10.669, -5.921>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.988, 0.907, 0.884>
      translate x*0.239
      rotate <0, -7.191, -1.437>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.885, 0.911, 0.95>
      translate x*0.49
      rotate <0, 2.957, 8.999>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.817, 0.937, 0.979>
      translate x*0.503
      rotate <0, 7.323, 10.762>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.861, 0.873, 0.865>
      translate x*0.164
      rotate <0, -19.03, -21.403>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.948, 0.91, 0.98>
      translate x*0.608
      rotate <0, -6.591, -6.026>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.825, 0.815, 0.92>
      translate x*0.444
      rotate <0, 10.231, -3.009>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.938, 0.891, 0.974>
      translate x*0.303
      rotate <0, 7.107, 10.518>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.824, 0.925, 0.921>
      translate x*0.663
      rotate <0, 2.754, -11.995>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.958, 0.856, 0.852>
      translate x*0.207
      rotate <0, 14.242, 11.954>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.962, 0.842, 0.809>
      translate x*0.038
      rotate <0, -9.552, -0.666>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.875, 0.86, 0.916>
      translate x*0.788
      rotate <0, 3.72, 13.244>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.988, 0.909, 0.925>
      translate x*0.17
      rotate <0, 19.775, 8.945>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.855, 0.954, 0.931>
      translate x*0.698
      rotate <0, -14.406, -3.111>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.909, 0.926, 0.831>
      translate x*0.19
      rotate <0, 10.533, -10.31>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.894, 0.951, 0.912>
      translate x*0.355
      rotate <0, 7.122, 2.008>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.83, 0.957, 0.908>
      translate x*0.044
      rotate <0, -15.016, 24.096>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.837, 0.914, 0.848>
      translate x*0.873
      rotate <0, 2.023, 19.332>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.934, 0.933, 0.948>
      translate x*0.668
      rotate <0, 11.548, -20.699>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.997, 0.951, 0.933>
      translate x*0.72
      rotate <0, 14.162, -8.923>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.905, 0.942, 0.859>
      translate x*0.037
      rotate <0, -6.715, 10.108>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.841, 0.897, 0.823>
      translate x*0.731
      rotate <0, 10.873, -7.332>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.823, 0.826, 0.982>
      translate x*0.35
      rotate <0, -10.633, -3.878>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.936, 0.976, 0.976>
      translate x*0.328
      rotate <0, -4.846, -4.717>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.908, 0.868, 0.867>
      translate x*0.831
      rotate <0, -0.214, 20.942>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.932, 0.899, 0.91>
      translate x*0.096
      rotate <0, -8.07, -17.819>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.865, 0.907, 0.895>
      translate x*0.905
      rotate <0, 9.496, -0.63>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.881, 0.816, 0.923>
      translate x*0.06
      rotate <0, 5.627, -14.208>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.899, 0.964, 0.884>
      translate x*0.741
      rotate <0, 2.206, -3.381>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.964, 0.866, 0.807>
      translate x*0.294
      rotate <0, 4.251, 2.526>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.845, 0.8, 0.976>
      translate x*0.401
      rotate <0, -3.935, -6.528>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.821, 0.846, 0.82>
      translate x*0.745
      rotate <0, -8.781, 0.281>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.997, 0.999, 0.842>
      translate x*0.102
      rotate <0, -8.567, 5.375>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.855, 0.842, 0.925>
      translate x*0.369
      rotate <0, -7.867, -0.389>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.964, 0.903, 0.801>
      translate x*0.333
      rotate <0, 2.966, -6.576>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.818, 0.838, 0.87>
      translate x*0.972
      rotate <0, -6.266, 11.526>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.847, 0.888, 0.991>
      translate x*0.821
      rotate <0, -5.755, -4.781>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.939, 0.859, 0.822>
      translate x*0.365
      rotate <0, -13.751, 16.888>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.972, 0.996, 0.883>
      translate x*0.59
      rotate <0, 7.146, 9.553>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.998, 0.947, 0.827>
      translate x*0.703
      rotate <0, 2.349, -13.614>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.949, 0.927, 0.984>
      translate x*0.618
      rotate <0, 4.186, 2.901>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.921, 0.847, 0.897>
      translate x*0.144
      rotate <0, -8.064, -5.961>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.821, 0.906, 0.912>
      translate x*0.831
      rotate <0, 4.064, 3.688>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.985, 0.98, 0.914>
      translate x*0.18
      rotate <0, 13.983, -8.794>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.955, 0.918, 0.996>
      translate x*0.43
      rotate <0, -7.403, -7.714>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.917, 0.891, 0.844>
      translate x*0.269
      rotate <0, 8.64, 2.079>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.936, 0.933, 0.879>
      translate x*0.8
      rotate <0, -2.7, 8.735>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.878, 0.855, 0.945>
      translate x*0.647
      rotate <0, -21.177, 7.611>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.838, 0.915, 0.978>
      translate x*0.5
      rotate <0, -0.201, -17.87>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.896, 0.912, 0.973>
      translate x*0.424
      rotate <0, 24.519, 2.863>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.803, 0.934, 0.985>
      translate x*0.064
      rotate <0, 2.318, 3.661>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.874, 0.935, 0.962>
      translate x*0.357
      rotate <0, 3, -1.275>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.827, 0.874, 0.95>
      translate x*0.637
      rotate <0, 6.441, 7.268>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.806, 0.885, 0.886>
      translate x*0.895
      rotate <0, -13.804, 8.996>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.974, 0.963, 0.843>
      translate x*0.667
      rotate <0, 4.389, -0.12>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.833, 0.957, 0.879>
      translate x*0.392
      rotate <0, 4.422, -2.224>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.81, 0.909, 0.829>
      translate x*0.156
      rotate <0, -19, -2.795>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.897, 0.892, 0.819>
      translate x*0.595
      rotate <0, -16.319, -15.85>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.993, 0.973, 0.858>
      translate x*0.227
      rotate <0, 14.669, -20.953>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.882, 0.833, 0.848>
      translate x*0.777
      rotate <0, -2.226, -8.875>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.902, 0.863, 0.894>
      translate x*0.987
      rotate <0, -4.568, -7.89>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.94, 0.908, 0.946>
      translate x*0.146
      rotate <0, -9.57, 11.792>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.939, 0.877, 0.9>
      translate x*0.943
      rotate <0, -27.566, 6.263>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.967, 0.838, 0.822>
      translate x*0.395
      rotate <0, 0.66, 27.687>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.89, 0.882, 0.989>
      translate x*0.465
      rotate <0, -11.009, 0.228>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.834, 0.817, 0.941>
      translate x*0.509
      rotate <0, 10.582, -23.69>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.884, 0.861, 0.964>
      translate x*0.036
      rotate <0, 9.468, 14.678>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.844, 0.89, 0.847>
      translate x*0.21
      rotate <0, -19.092, -9.228>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.831, 0.901, 0.962>
      translate x*0.296
      rotate <0, -3.809, 12.684>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.907, 0.968, 0.908>
      translate x*0.66
      rotate <0, -14.666, -7.447>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.972, 0.867, 0.912>
      translate x*0.115
      rotate <0, 8.61, 5.508>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.818, 0.8, 0.947>
      translate x*0.279
      rotate <0, 1.033, 4.318>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.935, 0.936, 0.839>
      translate x*0.198
      rotate <0, 10.936, -4.301>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.814, 0.956, 0.964>
      translate x*0.824
      rotate <0, -1.515, -0.225>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.818, 0.922, 0.806>
      translate x*0.966
      rotate <0, 4.461, 3.452>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.918, 0.817, 0.937>
      translate x*0.074
      rotate <0, -16.148, -2.459>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.803, 0.885, 0.838>
      translate x*0.713
      rotate <0, 14.797, 4.218>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.921, 0.949, 0.993>
      translate x*0.76
      rotate <0, 1.126, 19.981>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.916, 0.836, 0.923>
      translate x*0.271
      rotate <0, -1.764, 19.518>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.823, 0.948, 0.838>
      translate x*0.603
      rotate <0, -24.741, -0.012>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.938, 0.943, 0.918>
      translate x*0.703
      rotate <0, 1.454, -3.064>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.888, 0.833, 0.853>
      translate x*0.586
      rotate <0, 3.497, -11.316>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.979, 0.952, 0.967>
      translate x*0.747
      rotate <0, 2.787, -14.742>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.822, 0.969, 0.809>
      translate x*0.827
      rotate <0, -7.849, 2.992>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.827, 0.916, 0.964>
      translate x*0.018
      rotate <0, -2.716, 0.73>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.941, 0.906, 0.953>
      translate x*0.671
      rotate <0, -10.01, -1.932>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.882, 0.857, 0.952>
      translate x*0.216
      rotate <0, 5.768, 6.401>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.927, 0.815, 0.885>
      translate x*0.885
      rotate <0, 19.518, 11.543>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.882, 0.95, 0.908>
      translate x*0.833
      rotate <0, 18.114, -11.491>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.943, 0.994, 0.887>
      translate x*0.063
      rotate <0, -10.685, 4.557>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.935, 0.952, 0.886>
      translate x*0.1
      rotate <0, 18.968, 11.904>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.818, 0.851, 0.833>
      translate x*0.616
      rotate <0, 0.684, 22.552>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.961, 0.968, 0.891>
      translate x*0.178
      rotate <0, -1.873, -13.548>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.948, 0.906, 0.827>
      translate x*0.978
      rotate <0, -24.182, -15.216>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.967, 0.979, 0.935>
      translate x*0.838
      rotate <0, -2.208, -1.6>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.942, 0.938, 0.813>
      translate x*0.879
      rotate <0, 12.701, 13.534>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.945, 0.916, 0.958>
      translate x*0.122
      rotate <0, -9.077, -9.33>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.958, 0.922, 0.986>
      translate x*0.832
      rotate <0, -14.038, -0.022>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.929, 0.812, 0.971>
      translate x*0.732
      rotate <0, 14.902, 18.053>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.847, 0.967, 0.962>
      translate x*0.179
      rotate <0, 2.909, -10.309>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.892, 0.915, 0.989>
      translate x*0.151
      rotate <0, -5.262, -6.738>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.966, 0.814, 0.835>
      translate x*0.333
      rotate <0, 5.953, 0.748>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.919, 0.994, 0.818>
      translate x*0.722
      rotate <0, -19.985, 5.826>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.862, 0.991, 0.974>
      translate x*0.09
      rotate <0, -1.357, -6.601>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.852, 0.821, 0.971>
      translate x*0.213
      rotate <0, -10.181, -2.217>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.997, 0.901, 0.985>
      translate x*0.113
      rotate <0, 2.534, -15.725>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.92, 0.95, 0.869>
      translate x*0.577
      rotate <0, -2.147, 10.147>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.818, 0.829, 0.804>
      translate x*0.983
      rotate <0, -1.897, 16.107>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.86, 0.898, 0.901>
      translate x*0.939
      rotate <0, 7.956, 0.115>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.836, 0.839, 0.831>
      translate x*0.42
      rotate <0, -11.071, -0.086>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.957, 0.94, 0.803>
      translate x*0.022
      rotate <0, 8.257, -13.014>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.917, 0.862, 0.98>
      translate x*0.551
      rotate <0, 10.373, -7.361>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.983, 0.9, 0.831>
      translate x*0.542
      rotate <0, -5.833, 6.75>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.957, 0.838, 0.857>
      translate x*0.354
      rotate <0, 5.943, 3.197>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.976, 0.89, 0.883>
      translate x*0.285
      rotate <0, 4.446, -14.662>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.838, 0.907, 0.826>
      translate x*0.633
      rotate <0, 4.604, 9.902>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.945, 0.852, 0.947>
      translate x*0.891
      rotate <0, -23.457, -5.529>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.936, 0.823, 0.9>
      translate x*0.16
      rotate <0, -5.781, -9.753>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.934, 0.963, 0.939>
      translate x*0.571
      rotate <0, 13.445, -7.89>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.988, 0.879, 0.895>
      translate x*0.846
      rotate <0, -3.65, -1.999>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.821, 0.852, 0.985>
      translate x*0.261
      rotate <0, -7.753, 3.446>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.867, 0.82, 0.886>
      translate x*0.066
      rotate <0, -22.346, 4.595>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.814, 0.802, 0.942>
      translate x*0.963
      rotate <0, -17.342, 0.419>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <4, 0.933, 0.92>
      translate x*0.51
      rotate <0, -4.943, 7.762>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.89, 0.974, 0.884>
      translate x*0.259
      rotate <0, -26.329, 3.726>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.859, 0.881, 0.91>
      translate x*0.175
      rotate <0, 5.968, -7.595>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.853, 0.926, 0.864>
      translate x*0.25
      rotate <0, -7.395, 1.287>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.965, 0.991, 0.968>
      translate x*0.379
      rotate <0, 16.713, -5.343>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.964, 0.98, 0.975>
      translate x*0.422
      rotate <0, 2.747, 3.145>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.937, 0.838, 0.997>
      translate x*0.908
      rotate <0, 0.431, -13.897>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.892, 0.984, 0.918>
      translate x*0.172
      rotate <0, 15.81, 6.754>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.919, 0.953, 0.913>
      translate x*0.673
      rotate <0, 5.651, -2.862>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.881, 0.945, 0.807>
      translate x*0.999
      rotate <0, 9.417, -11.362>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.83, 0.993, 0.809>
      translate x*0.496
      rotate <0, -5.255, -7.583>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.939, 0.97, 0.9>
      translate x*0.605
      rotate <0, -10.15, -3.613>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.86, 0.893, 0.919>
      translate x*0.902
      rotate <0, 13.512, 1.38>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.87, 0.888, 0.913>
      translate x*0.4
      rotate <0, -5.743, 12.951>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.954, 0.846, 0.824>
      translate x*0.023
      rotate <0, -8.919, -19.184>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.854, 0.897, 0.895>
      translate x*0.16
      rotate <0, 12.558, 3.205>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.817, 0.933, 0.831>
      translate x*0.005
      rotate <0, 11.362, 8.425>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.879, 0.908, 0.806>
      translate x*0.827
      rotate <0, -4.744, 18.764>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.884, 0.944, 0.873>
      translate x*0.522
      rotate <0, 19.277, 8.364>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.85, 0.824, 0.896>
      translate x*0.712
      rotate <0, -0.622, 2.997>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.862, 0.908, 0.981>
      translate x*0.279
      rotate <0, -17.037, 15.732>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.971, 0.933, 0.919>
      translate x*0.576
      rotate <0, -9.242, -23.774>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.828, 0.982, 0.938>
      translate x*0.62
      rotate <0, 15.189, 0.97>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.915, 0.95, 0.986>
      translate x*0.358
      rotate <0, -9.112, 3.064>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.958, 0.91, 0.907>
      translate x*0.612
      rotate <0, 11.201, -2.859>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.896, 0.981, 0.975>
      translate x*0.521
      rotate <0, 2.551, -2.118>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.983, 0.816, 0.913>
      translate x*0.233
      rotate <0, -1.803, 19.057>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.847, 0.86, 0.822>
      translate x*0.293
      rotate <0, -5.538, -17.652>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.955, 0.815, 0.881>
      translate x*0.518
      rotate <0, -2.322, 13.234>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.918, 0.818, 0.898>
      translate x*0.265
      rotate <0, 3.119, -0.977>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.894, 0.931, 0.823>
      translate x*0.812
      rotate <0, -4.13, -12.377>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.809, 0.833, 0.9>
      translate x*0.12
      rotate <0, -15.894, 6.982>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.831, 0.898, 0.948>
      translate x*0.47
      rotate <0, -12.552, -3.892>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.825, 0.937, 0.962>
      translate x*0.476
      rotate <0, 11.047, -4.575>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.897, 0.826, 0.813>
      translate x*0.646
      rotate <0, -8.216, 6.72>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.906, 0.908, 0.908>
      translate x*0.083
      rotate <0, -1.561, -6.758>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.871, 0.825, 0.981>
      translate x*0.037
      rotate <0, 6.918, -35.448>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.992, 0.938, 0.87>
      translate x*0.892
      rotate <0, 2.584, 6.513>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.96, 0.843, 0.993>
      translate x*0.701
      rotate <0, 4.501, -5.667>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.875, 0.805, 0.865>
      translate x*0.718
      rotate <0, -11.167, 17.9>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.892, 0.937, 0.843>
      translate x*0.32
      rotate <0, 2.9, 21.632>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.822, 0.821, 0.879>
      translate x*0.506
      rotate <0, -0.638, -4.09>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.818, 0.921, 0.841>
      translate x*0.529
      rotate <0, -2.298, 5.666>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.993, 0.812, 0.944>
      translate x*0.445
      rotate <0, 17.708, 11.989>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.806, 0.909, 0.964>
      translate x*0.188
      rotate <0, 2.826, 26.676>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.853, 0.883, 0.852>
      translate x*0.424
      rotate <0, 8.268, 5.415>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.898, 0.995, 0.877>
      translate x*0.71
      rotate <0, -6.528, 16.837>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.905, 0.924, 0.891>
      translate x*0.574
      rotate <0, 14.991, 1.974>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.84, 0.9, 0.827>
      translate x*0.819
      rotate <0, -19.889, 9.679>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.83, 0.926, 0.956>
      translate x*0.9
      rotate <0, -6.52, 2.367>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.939, 0.916, 0.89>
      translate x*0.359
      rotate <0, -7.251, -11.022>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.871, 0.943, 0.917>
      translate x*0.239
      rotate <0, -19.282, 10.329>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.876, 0.88, 0.869>
      translate x*0.032
      rotate <0, 12.677, 8.097>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.848, 0.878, 0.889>
      translate x*0.047
      rotate <0, 12.647, 4.428>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.802, 0.813, 0.834>
      translate x*0.171
      rotate <0, 26.923, 8.735>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.929, 0.836, 0.991>
      translate x*0.761
      rotate <0, 9.803, 11.513>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.86, 0.846, 0.892>
      translate x*0.934
      rotate <0, 2.633, -13.94>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.861, 0.912, 0.948>
      translate x*0.724
      rotate <0, 1.242, -10.232>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.976, 0.985, 0.881>
      translate x*0.53
      rotate <0, 4.594, 13.188>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.874, 0.854, 0.807>
      translate x*0.934
      rotate <0, -5.039, 15.366>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.931, 0.818, 0.882>
      translate x*0.356
      rotate <0, 13.113, -8.013>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.862, 0.985, 0.833>
      translate x*0.097
      rotate <0, 9.051, -11.343>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.877, 0.83, 0.934>
      translate x*0.158
      rotate <0, 1.487, -12.836>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.961, 0.906, 0.948>
      translate x*0.739
      rotate <0, -8.22, -10.101>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.807, 0.921, 0.948>
      translate x*0.594
      rotate <0, 10.262, 2.607>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.825, 0.877, 0.887>
      translate x*0.376
      rotate <0, 24.839, -15.54>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.837, 0.902, 0.911>
      translate x*0.818
      rotate <0, -14.48, 20.961>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.819, 0.894, 0.93>
      translate x*0.979
      rotate <0, -2.036, -4.504>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.911, 0.85, 0.867>
      translate x*0.951
      rotate <0, -5.609, 17.384>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.924, 0.847, 0.875>
      translate x*0.233
      rotate <0, -22.844, -3.955>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.891, 0.808, 0.878>
      translate x*0.572
      rotate <0, 9.033, 12.481>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.889, 0.905, 0.834>
      translate x*0.347
      rotate <0, -1.285, 14.524>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.938, 0.815, 0.938>
      translate x*0.582
      rotate <0, -19.724, -4.645>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.91, 0.985, 0.993>
      translate x*0.388
      rotate <0, 7.307, -6.409>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.85, 0.833, 0.954>
      translate x*0.085
      rotate <0, 4.168, -2.233>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.875, 0.963, 0.829>
      translate x*0.414
      rotate <0, 2.284, 4.34>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.963, 0.877, 0.858>
      translate x*0.133
      rotate <0, -17.378, -5.635>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.962, 0.988, 0.826>
      translate x*0.874
      rotate <0, -5.523, -4.197>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.973, 0.802, 0.874>
      translate x*0.479
      rotate <0, 9.408, 5.944>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.917, 0.842, 0.877>
      translate x*0.045
      rotate <0, 5.673, 5.717>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.999, 0.96, 0.898>
      translate x*0.688
      rotate <0, 30.68, 8.718>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.908, 0.831, 0.926>
      translate x*0.481
      rotate <0, 13.012, -35.46>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.931, 0.875, 0.911>
      translate x*0.243
      rotate <0, -12.724, -9.432>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.979, 0.828, 0.923>
      translate x*0.741
      rotate <0, 10.496, 18.667>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.893, 0.853, 0.896>
      translate x*0.512
      rotate <0, -3.985, -14.773>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.905, 0.858, 0.946>
      translate x*0.87
      rotate <0, -6.142, 0.838>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.961, 0.975, 0.863>
      translate x*0.69
      rotate <0, 1.181, -6.614>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.957, 0.953, 0.88>
      translate x*0.405
      rotate <0, -19.011, 29.674>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.863, 0.89, 0.966>
      translate x*0.101
      rotate <0, 1.445, 17.674>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.897, 0.969, 0.992>
      translate x*0.869
      rotate <0, -5.85, -9.651>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.912, 0.95, 0.805>
      translate x*0.465
      rotate <0, 7.427, 12.493>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.803, 0.976, 0.892>
      translate x*0.036
      rotate <0, -3.813, -1.669>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.984, 0.815, 0.81>
      translate x*0.02
      rotate <0, 7.117, -0.328>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.936, 0.83, 0.927>
      translate x*0.436
      rotate <0, -5.034, 6.183>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.896, 0.965, 0.892>
      translate x*0.602
      rotate <0, -5.62, 6.903>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.969, 0.831, 0.99>
      translate x*0.85
      rotate <0, -3.749, -4.613>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.911, 0.937, 0.949>
      translate x*0.06
      rotate <0, 1.756, 19.94>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.87, 0.978, 0.9>
      translate x*0.81
      rotate <0, -16.767, 29.153>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.81, 0.839, 0.935>
      translate x*0.639
      rotate <0, 12.784, 1.521>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.868, 0.827, 0.828>
      translate x*0.321
      rotate <0, -1.05, 12.195>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.951, 0.857, 0.961>
      translate x*0.179
      rotate <0, -4.942, -0.021>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.9, 0.948, 0.821>
      translate x*0.327
      rotate <0, 5.786, 17.43>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.875, 0.999, 0.836>
      translate x*0.275
      rotate <0, -10.76, -19.475>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.854, 0.912, 0.813>
      translate x*0.651
      rotate <0, 6.302, -6.426>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.971, 0.891, 0.833>
      translate x*0.753
      rotate <0, 3.248, -9.845>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.911, 0.892, 0.866>
      translate x*0.415
      rotate <0, 15.588, 13.606>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.85, 0.982, 0.975>
      translate x*0.085
      rotate <0, -5.164, -10.844>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.816, 0.893, 0.92>
      translate x*0.172
      rotate <0, 9.372, 10.065>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.855, 0.864, 0.925>
      translate x*0.625
      rotate <0, 3.789, -15.811>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.857, 0.824, 0.922>
      translate x*0.269
      rotate <0, -9.895, 1.155>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.847, 0.961, 0.877>
      translate x*0.776
      rotate <0, -15.059, -12.097>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.895, 0.912, 0.888>
      translate x*0.162
      rotate <0, 19.225, 5.609>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.8, 1, 0.843>
      translate x*0.458
      rotate <0, 15.25, -15.944>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.928, 0.962, 0.87>
      translate x*0.696
      rotate <0, -2.16, 2.312>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.84, 0.812, 0.821>
      translate x*0.509
      rotate <0, 6.142, 23.112>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.819, 0.887, 0.907>
      translate x*0.594
      rotate <0, -7.968, 8.617>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.96, 0.985, 0.93>
      translate x*0.882
      rotate <0, 2.329, 15.283>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.981, 0.884, 0.998>
      translate x*0.638
      rotate <0, 9.013, 9.349>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.96, 0.807, 0.926>
      translate x*0.756
      rotate <0, 6.353, 5.984>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.95, 0.806, 0.897>
      translate x*0.312
      rotate <0, -3.661, -21.547>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.924, 0.922, 0.859>
      translate x*0.948
      rotate <0, -9.968, -15.338>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.932, 0.989, 0.862>
      translate x*0.874
      rotate <0, 2.413, -10.742>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.893, 0.848, 0.991>
      translate x*0.219
      rotate <0, 4.068, -12.01>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.955, 0.983, 0.862>
      translate x*0.129
      rotate <0, 10.487, 7.326>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.947, 0.865, 0.846>
      translate x*0.381
      rotate <0, 3.006, 4.362>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.823, 0.968, 0.87>
      translate x*0.388
      rotate <0, 8.39, 9.849>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.859, 0.93, 0.998>
      translate x*0.291
      rotate <0, 4.777, 8.691>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.992, 0.97, 0.841>
      translate x*0.351
      rotate <0, -1.811, -10.42>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.818, 0.833, 0.973>
      translate x*0.132
      rotate <0, 10.038, -5.548>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.86, 0.986, 0.916>
      translate x*0.928
      rotate <0, -7.983, -4.759>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.898, 0.937, 0.977>
      translate x*0.579
      rotate <0, -11.466, 7.958>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.915, 0.828, 0.94>
      translate x*0.23
      rotate <0, -13.732, 18.399>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.871, 0.82, 0.918>
      translate x*0.735
      rotate <0, 17.695, 3.827>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.908, 0.872, 0.941>
      translate x*0.228
      rotate <0, -3.601, 10.769>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.934, 0.877, 0.934>
      translate x*0.963
      rotate <0, 4.686, -5.393>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.999, 0.859, 0.954>
      translate x*0.837
      rotate <0, -11.46, -2.089>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.844, 0.875, 0.804>
      translate x*0.959
      rotate <0, 1.136, 13.542>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.963, 0.809, 0.937>
      translate x*0.407
      rotate <0, 18.142, 9.296>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.945, 0.842, 0.94>
      translate x*0.722
      rotate <0, 13.754, 3.431>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.877, 0.895, 0.871>
      translate x*0.87
      rotate <0, 15.871, -5.297>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.874, 0.971, 0.854>
      translate x*0.264
      rotate <0, -3.934, 2.555>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.891, 0.849, 0.881>
      translate x*0.052
      rotate <0, -1.02, 22.925>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.919, 0.813, 0.88>
      translate x*0.196
      rotate <0, 4.471, 20.649>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.801, 0.845, 0.971>
      translate x*0.877
      rotate <0, 4.368, -3.26>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.938, 0.962, 0.959>
      translate x*0.559
      rotate <0, 3.858, -0.131>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.929, 0.921, 0.916>
      translate x*0.472
      rotate <0, 5.551, 8.128>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.9, 0.986, 0.965>
      translate x*0.511
      rotate <0, 1.979, -14.251>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.919, 1, 0.802>
      translate x*0.414
      rotate <0, -14.25, -8.307>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.842, 0.915, 0.863>
      translate x*0.759
      rotate <0, 9.822, -8.913>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.862, 0.857, 0.855>
      translate x*0.621
      rotate <0, -2.66, 4.269>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.837, 0.94, 0.907>
      translate x*0.843
      rotate <0, 15.179, 1.751>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.867, 0.8, 0.949>
      translate x*0.622
      rotate <0, 7.853, -7.333>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.843, 0.933, 0.848>
      translate x*0.644
      rotate <0, 6.64, -8.632>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.963, 0.921, 0.936>
      translate x*0.211
      rotate <0, -25.231, -6.457>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.92, 0.94, 0.855>
      translate x*0.746
      rotate <0, -16.762, -2.14>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.985, 0.957, 0.89>
      translate x*0.732
      rotate <0, -2.692, 11.345>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.821, 0.958, 0.842>
      translate x*0.514
      rotate <0, 10.945, -3.203>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.801, 0.952, 0.903>
      translate x*0.486
      rotate <0, 3.447, 14.316>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.904, 0.861, 0.989>
      translate x*0.017
      rotate <0, -14.745, 8.543>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.846, 0.834, 0.832>
      translate x*0.002
      rotate <0, -3.631, 14.525>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.893, 0.857, 0.838>
      translate x*0.155
      rotate <0, 13.067, -5.848>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.819, 0.81, 0.928>
      translate x*0.185
      rotate <0, 18.578, -24.125>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.935, 0.865, 0.883>
      translate x*0.626
      rotate <0, 5.08, 0.996>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.805, 0.99, 0.845>
      translate x*0.566
      rotate <0, 17.891, -3.919>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.97, 0.894, 0.913>
      translate x*0.594
      rotate <0, 3.932, -6.918>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.98, 0.837, 0.871>
      translate x*0.169
      rotate <0, -2.479, -9.423>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.967, 0.894, 0.924>
      translate x*0.181
      rotate <0, -4.71, -16.969>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.863, 0.974, 0.971>
      translate x*0.724
      rotate <0, -1.521, 8.311>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.952, 0.883, 0.974>
      translate x*0.161
      rotate <0, -4.886, 8.693>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.976, 0.819, 0.975>
      translate x*0.235
      rotate <0, -3.49, -0.585>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.866, 0.906, 0.893>
      translate x*0.459
      rotate <0, 0.32, 7.357>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.957, 0.889, 0.826>
      translate x*0.146
      rotate <0, -6.222, 8.705>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.877, 0.929, 0.907>
      translate x*0.354
      rotate <0, 8.046, 6.534>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.916, 0.962, 0.895>
      translate x*0.595
      rotate <0, -8.473, -13.017>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.912, 0.941, 0.811>
      translate x*0.478
      rotate <0, 2.755, 0.276>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.958, 0.803, 0.99>
      translate x*0.51
      rotate <0, 3.927, -9.885>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.899, 0.846, 0.836>
      translate x*0.002
      rotate <0, -15.613, 1.999>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.968, 0.975, 0.971>
      translate x*0.538
      rotate <0, 3.335, 17.846>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.997, 0.925, 0.945>
      translate x*0.622
      rotate <0, -27.226, 2.785>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.89, 0.926, 0.88>
      translate x*0.057
      rotate <0, 5.173, 22.328>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.819, 0.964, 0.804>
      translate x*0.221
      rotate <0, -10.451, -9.876>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.88, 0.964, 0.827>
      translate x*0.765
      rotate <0, -9.335, 10.321>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.805, 0.902, 0.873>
      translate x*0.319
      rotate <0, -11.249, -3.925>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.875, 0.842, 0.809>
      translate x*0.585
      rotate <0, -4.371, 1.05>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.858, 0.817, 0.952>
      translate x*0.69
      rotate <0, -10.631, -6.202>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.863, 0.829, 0.821>
      translate x*0.903
      rotate <0, 3.558, 3.665>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.901, 0.801, 0.918>
      translate x*0.768
      rotate <0, 9.011, -4.551>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.883, 0.906, 0.938>
      translate x*0.354
      rotate <0, 19.201, -7.703>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.969, 0.819, 0.92>
      translate x*0.707
      rotate <0, 3.951, 2.379>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.945, 0.873, 0.818>
      translate x*0.688
      rotate <0, 8.866, 6.661>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.994, 0.84, 0.833>
      translate x*0.217
      rotate <0, 14.746, 4.637>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.809, 0.887, 0.807>
      translate x*0.427
      rotate <0, 11.664, 8.183>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.992, 0.813, 0.957>
      translate x*0.557
      rotate <0, 2.656, 4.713>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.893, 0.923, 0.805>
      translate x*0.333
      rotate <0, -12.092, 3.619>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.911, 0.862, 0.86>
      translate x*0.291
      rotate <0, -3.916, -25.478>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.966, 0.984, 0.958>
      translate x*0.93
      rotate <0, -15.104, -5.871>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.958, 0.816, 0.842>
      translate x*0.684
      rotate <0, 8.249, -3.436>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.997, 0.852, 0.847>
      translate x*0.561
      rotate <0, 6.281, 21.783>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.952, 0.901, 0.837>
      translate x*0.872
      rotate <0, -2.683, 6.268>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.894, 0.891, 0.943>
      translate x*0.747
      rotate <0, -2.732, 3.463>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.829, 0.841, 0.913>
      translate x*0.151
      rotate <0, 14.206, 10.445>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.832, 0.815, 0.875>
      translate x*0.825
      rotate <0, 3.831, -3.867>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.944, 0.885, 0.883>
      translate x*0.031
      rotate <0, 5.282, -17.139>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.988, 0.822, 0.816>
      translate x*0.13
      rotate <0, 6.194, 19.438>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.987, 0.903, 0.916>
      translate x*0.912
      rotate <0, 3.171, -0.139>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.881, 0.896, 0.807>
      translate x*0.195
      rotate <0, 0.775, -4.389>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.881, 0.974, 0.929>
      translate x*0.507
      rotate <0, -19.102, 9.047>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.846, 0.8, 0.821>
      translate x*0.74
      rotate <0, -1.172, 0.65>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.957, 0.909, 0.96>
      translate x*0.382
      rotate <0, -5.424, -14.049>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.927, 0.852, 0.916>
      translate x*0.424
      rotate <0, -12.017, 6.737>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.871, 0.829, 0.818>
      translate x*0.239
      rotate <0, 9.865, 15.687>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.83, 0.897, 0.952>
      translate x*0.617
      rotate <0, 4.927, 17.865>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.885, 0.934, 0.884>
      translate x*0.804
      rotate <0, 1.414, -13.454>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.913, 0.881, 0.926>
      translate x*0.693
      rotate <0, -6.583, 6.642>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.856, 0.912, 0.873>
      translate x*0.45
      rotate <0, -3.486, -7.492>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.952, 0.939, 0.913>
      translate x*0.57
      rotate <0, 15.869, 14.248>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.85, 0.977, 0.937>
      translate x*0.921
      rotate <0, 16.168, -20.376>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.973, 0.888, 0.95>
      translate x*0.525
      rotate <0, 24.722, -10.5>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.844, 0.928, 0.81>
      translate x*0.781
      rotate <0, -7.188, -14.734>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.972, 0.963, 0.96>
      translate x*0.494
      rotate <0, 1.816, -6.994>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.921, 0.901, 0.87>
      translate x*0.451
      rotate <0, 13.894, 21.175>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.927, 0.96, 0.958>
      translate x*0.382
      rotate <0, -4.024, 6.372>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.922, 0.893, 0.932>
      translate x*0.973
      rotate <0, 10.53, 1.316>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.817, 0.941, 0.925>
      translate x*0.115
      rotate <0, -8.949, -15.57>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.86, 0.859, 0.939>
      translate x*0.851
      rotate <0, -3.533, 1.473>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.947, 0.959, 0.892>
      translate x*0.431
      rotate <0, 10.598, 14.454>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.966, 0.936, 0.869>
      translate x*0.604
      rotate <0, 12.559, 3.584>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.814, 0.857, 0.935>
      translate x*0.661
      rotate <0, 7.457, 8.345>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.964, 0.904, 0.92>
      translate x*0.897
      rotate <0, 5.978, 11.756>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.886, 0.909, 0.907>
      translate x*0.991
      rotate <0, -7.591, 3.73>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.945, 0.94, 0.99>
      translate x*0.373
      rotate <0, 11.389, 4.951>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.849, 0.841, 0.912>
      translate x*0.955
      rotate <0, -1.841, 7.971>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.95, 0.877, 0.832>
      translate x*0.556
      rotate <0, -0.712, 1.304>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.984, 0.906, 0.856>
      translate x*0.152
      rotate <0, -3.151, 29.032>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.915, 0.912, 0.971>
      translate x*0.441
      rotate <0, -1.259, -12.966>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.936, 0.865, 0.963>
      translate x*0.438
      rotate <0, 3.32, -16.817>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.991, 0.886, 0.882>
      translate x*0.659
      rotate <0, 3.736, -3.066>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.831, 0.825, 0.909>
      translate x*0.076
      rotate <0, 2.355, 3.506>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.808, 0.986, 0.826>
      translate x*0.312
      rotate <0, 6.357, 3.386>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.906, 0.899, 0.953>
      translate x*0.615
      rotate <0, -7.904, -12.821>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.979, 0.865, 0.91>
      translate x*0.877
      rotate <0, 14.013, -3.105>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.907, 0.944, 0.81>
      translate x*0.463
      rotate <0, 9.889, -2.511>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.915, 0.963, 0.903>
      translate x*0.776
      rotate <0, 9.94, -0.911>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.919, 0.824, 0.966>
      translate x*0.428
      rotate <0, 12.74, 10.564>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.951, 0.912, 0.853>
      translate x*0.499
      rotate <0, 26.177, 7.169>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.986, 0.972, 0.865>
      translate x*0.704
      rotate <0, 6.628, -1.219>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.959, 0.886, 0.938>
      translate x*0.396
      rotate <0, 0.262, -17.235>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.885, 0.996, 0.96>
      translate x*0.057
      rotate <0, -3.126, -19.179>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.938, 0.921, 0.914>
      translate x*0.505
      rotate <0, -19.161, -7.819>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.907, 0.987, 0.98>
      translate x*0.204
      rotate <0, -2.196, 10.337>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.862, 0.938, 0.869>
      translate x*0.048
      rotate <0, 5.418, -1.015>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.912, 0.986, 0.894>
      translate x*0.638
      rotate <0, 9.905, 9.209>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.974, 0.99, 0.955>
      translate x*0.448
      rotate <0, 11.494, 3.916>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.815, 0.981, 0.819>
      translate x*0.379
      rotate <0, -1.292, 5.354>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.908, 0.989, 0.919>
      translate x*0.013
      rotate <0, 16.241, -2.914>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.864, 0.961, 0.856>
      translate x*0.419
      rotate <0, -12.393, -2.947>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.935, 0.913, 0.987>
      translate x*0.629
      rotate <0, 2.015, -2.567>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.97, 0.918, 0.811>
      translate x*0.836
      rotate <0, -1.158, -20.228>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.995, 0.863, 0.833>
      translate x*0.115
      rotate <0, -17.131, -7.601>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.945, 0.83, 0.869>
      translate x*0.836
      rotate <0, -9.147, 5.445>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.93, 0.859, 0.882>
      translate x*0.079
      rotate <0, 13.303, -7.197>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.822, 0.994, 0.889>
      translate x*0.22
      rotate <0, -5.765, -17.823>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.879, 0.849, 0.981>
      translate x*0.418
      rotate <0, 2.476, 3.878>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.993, 0.856, 0.887>
      translate x*0.01
      rotate <0, -5.495, -3.647>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.93, 0.93, 0.99>
      translate x*0.834
      rotate <0, 19.087, -4.565>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.857, 0.811, 0.866>
      translate x*0.244
      rotate <0, 3.906, 13.108>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.918, 0.936, 0.821>
      translate x*0.965
      rotate <0, -9.849, 20.133>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.999, 0.813, 0.877>
      translate x*0.177
      rotate <0, 2.461, -10.867>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.942, 0.908, 0.978>
      translate x*0.025
      rotate <0, 6.889, -13.184>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.907, 0.961, 0.949>
      translate x*0.39
      rotate <0, -1.503, 9.78>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.8, 0.892, 0.828>
      translate x*0.07
      rotate <0, -3.059, 5.881>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.938, 0.814, 0.89>
      translate x*0.544
      rotate <0, -3.139, -3.552>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.823, 0.883, 0.964>
      translate x*0.249
      rotate <0, 12.139, -2.337>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.834, 0.907, 0.887>
      translate x*0.79
      rotate <0, -6.954, 0.2>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.974, 0.867, 0.974>
      translate x*0.67
      rotate <0, 11.039, -15.213>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.822, 0.889, 0.813>
      translate x*0.063
      rotate <0, -2.56, 3.597>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.842, 0.862, 0.881>
      translate x*0.759
      rotate <0, 1.447, -0.53>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.873, 0.889, 0.86>
      translate x*0.777
      rotate <0, 3.928, -29.297>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.861, 0.834, 0.883>
      translate x*0.212
      rotate <0, -1.857, -5.273>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.869, 0.824, 0.914>
      translate x*0.64
      rotate <0, -8.951, -8.756>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.883, 0.866, 0.939>
      translate x*0.942
      rotate <0, -10.964, -1.531>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.952, 0.929, 0.998>
      translate x*0.618
      rotate <0, 13.949, 10.88>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.97, 0.966, 0.939>
      translate x*0.604
      rotate <0, 0.958, -0.557>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.893, 0.962, 0.872>
      translate x*0.263
      rotate <0, 7.324, 1.558>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.988, 0.806, 0.906>
      translate x*0.608
      rotate <0, 2.323, -4.004>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.874, 0.841, 0.846>
      translate x*0.92
      rotate <0, -6.406, 3.925>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.801, 0.843, 0.86>
      translate x*0.71
      rotate <0, 9.863, -3.381>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.805, 0.859, 0.988>
      translate x*0.558
      rotate <0, -7.487, -4.243>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.943, 0.85, 0.899>
      translate x*0.571
      rotate <0, -7.334, -4.741>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.871, 0.961, 0.86>
      translate x*0.209
      rotate <0, 14.436, -9.619>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.844, 0.991, 0.828>
      translate x*0.897
      rotate <0, -11.27, -1.654>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.942, 0.9, 0.894>
      translate x*0.274
      rotate <0, 9.464, -4.941>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.816, 0.964, 0.984>
      translate x*0.034
      rotate <0, 15.258, -5.482>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.824, 0.875, 0.834>
      translate x*0.189
      rotate <0, 22.692, -6.706>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.965, 0.859, 0.889>
      translate x*0.136
      rotate <0, -4.1, 4.01>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.903, 0.969, 0.836>
      translate x*0.19
      rotate <0, -16.239, 13.04>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.925, 0.943, 0.892>
      translate x*0.279
      rotate <0, 6.182, 14.67>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.847, 0.865, 0.978>
      translate x*0.179
      rotate <0, -7.05, -11.227>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.894, 0.929, 0.909>
      translate x*0.146
      rotate <0, 16.316, 1.577>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.814, 0.89, 0.856>
      translate x*0.945
      rotate <0, -7.979, 19.397>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.959, 0.827, 0.945>
      translate x*0.149
      rotate <0, 8.626, 5.234>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.949, 0.952, 0.923>
      translate x*0.215
      rotate <0, 6.035, 9.956>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.897, 0.855, 0.992>
      translate x*0.103
      rotate <0, -3.189, -2.715>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.901, 0.91, 0.95>
      translate x*0.303
      rotate <0, 0.353, -4.884>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.934, 0.992, 0.892>
      translate x*0.841
      rotate <0, -3.755, 12.753>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.853, 0.858, 0.96>
      translate x*0.34
      rotate <0, 11.049, 0.386>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.947, 0.944, 0.862>
      translate x*0.378
      rotate <0, -11.445, 13.742>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.888, 0.953, 0.918>
      translate x*0.335
      rotate <0, -11.043, 7.052>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.901, 0.834, 0.96>
      translate x*0.491
      rotate <0, 1.684, 11.592>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.891, 0.973, 0.825>
      translate x*0.563
      rotate <0, -8.449, 16.786>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.888, 0.859, 0.905>
      translate x*0.852
      rotate <0, -11.345, -3.564>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.91, 0.929, 0.802>
      translate x*0.03
      rotate <0, 6.899, 1.906>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.887, 0.933, 0.813>
      translate x*0.065
      rotate <0, -1.737, 21.151>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.864, 0.828, 0.914>
      translate x*0.998
      rotate <0, -16.098, -10.753>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.885, 0.867, 0.974>
      translate x*0.256
      rotate <0, -3.089, -11.356>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.842, 0.999, 0.81>
      translate x*0.835
      rotate <0, 1.027, 3.618>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.989, 0.998, 0.926>
      translate x*0.048
      rotate <0, 2.806, 17.474>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.965, 0.982, 0.838>
      translate x*0.67
      rotate <0, -4.231, -1.183>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.876, 0.914, 0.854>
      translate x*0.084
      rotate <0, 11.734, -13.251>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.953, 0.902, 0.819>
      translate x*0.612
      rotate <0, -4.951, -17.842>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.902, 0.899, 0.869>
      translate x*0.436
      rotate <0, 3.638, 23.279>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.883, 0.812, 0.812>
      translate x*0.511
      rotate <0, 4.775, 4.502>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.913, 0.834, 0.891>
      translate x*0.541
      rotate <0, 13.211, 3.966>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.97, 0.839, 0.98>
      translate x*0.532
      rotate <0, -5.229, -6.269>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.995, 0.882, 0.802>
      translate x*0.527
      rotate <0, -10.27, 4.375>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.959, 0.914, 0.983>
      translate x*0.016
      rotate <0, 1.315, -8.333>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.893, 0.996, 0.879>
      translate x*0.049
      rotate <0, 5.337, 6.474>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.862, 0.816, 0.895>
      translate x*0.386
      rotate <0, 3.482, 4.378>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.832, 0.869, 0.884>
      translate x*0.013
      rotate <0, 9.005, 16.504>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.922, 0.814, 0.992>
      translate x*0.089
      rotate <0, 15.525, 13.85>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.988, 0.879, 0.915>
      translate x*0.803
      rotate <0, 9.39, 9.951>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.848, 0.943, 0.889>
      translate x*0.825
      rotate <0, 3.507, 8.998>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.826, 0.934, 0.895>
      translate x*0.877
      rotate <0, -8.202, 2.579>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.889, 0.886, 0.879>
      translate x*0.555
      rotate <0, 20.405, -4.025>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.861, 0.882, 0.909>
      translate x*0.875
      rotate <0, -3.521, 0.515>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.912, 0.801, 0.865>
      translate x*0.029
      rotate <0, -0.097, -10.241>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.951, 0.875, 0.96>
      translate x*0.581
      rotate <0, -0.525, -3.674>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.931, 0.979, 0.815>
      translate x*0.85
      rotate <0, -0.902, -5.025>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.986, 0.872, 0.857>
      translate x*0.377
      rotate <0, -24.769, 4.079>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.951, 0.952, 0.848>
      translate x*0.293
      rotate <0, -5.676, 1.93>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.982, 0.958, 0.9>
      translate x*0.065
      rotate <0, -13.799, 12.343>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.907, 0.85, 0.978>
      translate x*0.394
      rotate <0, 32.333, 17.824>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.943, 0.961, 0.984>
      translate x*0.16
      rotate <0, 6.648, 4.102>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.82, 0.922, 0.916>
      translate x*0.05
      rotate <0, -2.968, -8.889>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.99, 0.953, 0.882>
      translate x*0.042
      rotate <0, 9.877, -5.446>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.872, 0.913, 0.867>
      translate x*0.125
      rotate <0, 10.012, 8.97>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.829, 0.815, 0.833>
      translate x*0.579
      rotate <0, 26.109, -16.248>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.82, 0.934, 0.815>
      translate x*0.809
      rotate <0, 5.072, 1.869>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.969, 0.948, 0.886>
      translate x*0.094
      rotate <0, -7.783, 3.075>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.948, 0.988, 0.943>
      translate x*0.723
      rotate <0, 10.967, 7.176>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.838, 0.805, 0.833>
      translate x*0.8
      rotate <0, 0.541, 8.474>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.882, 0.905, 0.963>
      translate x*0.527
      rotate <0, -5.402, -2.211>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.918, 0.848, 0.885>
      translate x*0.068
      rotate <0, -12, -8.513>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.958, 0.96, 0.92>
      translate x*0.006
      rotate <0, -5.143, 3.769>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.956, 0.879, 0.815>
      translate x*0.16
      rotate <0, 24.732, 0.967>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.98, 0.997, 0.939>
      translate x*0.905
      rotate <0, 11.356, -11.082>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.857, 0.861, 0.831>
      translate x*0.278
      rotate <0, 3.458, -9.487>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.942, 0.856, 0.98>
      translate x*0.993
      rotate <0, -5.76, 6.296>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.831, 0.882, 0.997>
      translate x*0.078
      rotate <0, -15.189, 0.559>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.864, 0.829, 0.962>
      translate x*0.104
      rotate <0, 11.328, -13.372>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.886, 0.864, 0.962>
      translate x*0.997
      rotate <0, -12.163, 2.099>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.824, 0.818, 0.834>
      translate x*0.157
      rotate <0, -21.218, 7.58>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.947, 0.995, 0.929>
      translate x*0.019
      rotate <0, 0.882, -4.999>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.803, 0.847, 0.851>
      translate x*0.394
      rotate <0, 3.526, -22.128>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.993, 0.952, 0.91>
      translate x*0.764
      rotate <0, -25.894, 11.906>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.962, 0.889, 0.917>
      translate x*0.341
      rotate <0, -8.359, -19.811>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.988, 0.821, 0.901>
      translate x*0.001
      rotate <0, -7.191, -3.348>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.85, 0.954, 0.979>
      translate x*0.227
      rotate <0, 2.946, 14.864>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.902, 0.873, 0.93>
      translate x*0.978
      rotate <0, 8.824, -11.791>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.857, 0.914, 0.816>
      translate x*0.862
      rotate <0, 5.99, -7.691>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.894, 0.995, 0.907>
      translate x*0.164
      rotate <0, 1.163, 27.087>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.927, 0.897, 0.908>
      translate x*0.231
      rotate <0, -14.326, 0.146>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.86, 0.846, 0.933>
      translate x*0.304
      rotate <0, 3.162, 11.194>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.931, 0.838, 0.839>
      translate x*0.276
      rotate <0, 5.71, 13.023>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.908, 0.831, 0.882>
      translate x*0.88
      rotate <0, -8.677, -1.904>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.825, 0.911, 0.811>
      translate x*0.637
      rotate <0, -9.844, -4.927>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.874, 0.862, 0.838>
      translate x*0.371
      rotate <0, 9.085, 4.67>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.878, 0.926, 0.82>
      translate x*0.333
      rotate <0, 2.229, -5.006>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.925, 0.904, 0.885>
      translate x*0.919
      rotate <0, 28.735, -6.903>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.822, 0.928, 0.985>
      translate x*0.629
      rotate <0, -7.382, -4.295>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.885, 0.97, 0.929>
      translate x*0.278
      rotate <0, -3.316, 18.184>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.877, 0.976, 0.861>
      translate x*0.599
      rotate <0, 11.526, 6.562>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.819, 0.863, 0.961>
      translate x*0.166
      rotate <0, 9.323, -11.041>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.822, 0.834, 0.948>
      translate x*0.114
      rotate <0, 0.643, 4.094>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.992, 0.841, 0.931>
      translate x*0.394
      rotate <0, -15.327, 3.542>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.972, 0.856, 0.909>
      translate x*0.259
      rotate <0, 3.284, 5.234>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.878, 0.98, 0.951>
      translate x*0.386
      rotate <0, 1.061, -9.78>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.907, 0.897, 0.821>
      translate x*0.429
      rotate <0, 4.904, -1.005>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.806, 0.928, 0.888>
      translate x*0.966
      rotate <0, -15.969, -2.265>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.932, 0.838, 0.868>
      translate x*0.591
      rotate <0, 14.204, 8.595>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.822, 0.929, 0.97>
      translate x*0.539
      rotate <0, 8.701, -24.28>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.813, 0.844, 0.899>
      translate x*0.464
      rotate <0, 5.058, -2.038>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.865, 0.895, 0.963>
      translate x*0.02
      rotate <0, -5.189, 4.275>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.862, 0.849, 0.956>
      translate x*0.617
      rotate <0, -6.529, 2.614>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.921, 0.905, 0.847>
      translate x*0.153
      rotate <0, 1.65, 5.64>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.817, 0.899, 0.909>
      translate x*0.715
      rotate <0, 1.789, -5.129>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.974, 0.836, 0.843>
      translate x*0.071
      rotate <0, -15.898, -7.065>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.894, 0.924, 0.988>
      translate x*0.433
      rotate <0, 4.382, -4.634>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.897, 0.967, 0.823>
      translate x*0.238
      rotate <0, 1.016, -3.058>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.95, 0.885, 0.854>
      translate x*0.762
      rotate <0, 3.015, 0.835>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.804, 0.984, 0.857>
      translate x*0.126
      rotate <0, 1.138, 5.89>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.842, 0.97, 0.904>
      translate x*0.715
      rotate <0, 14.127, 0.145>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.928, 0.926, 0.816>
      translate x*0.258
      rotate <0, -14.203, -16.781>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.818, 0.874, 0.942>
      translate x*0.676
      rotate <0, -3.759, -3.471>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.82, 0.992, 0.908>
      translate x*0.491
      rotate <0, 9.582, -1.721>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.924, 0.942, 0.826>
      translate x*0.892
      rotate <0, 3.72, 20.003>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.842, 0.856, 0.943>
      translate x*0.649
      rotate <0, 2.234, 6.953>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.955, 0.908, 0.905>
      translate x*0.844
      rotate <0, -16.919, -12.074>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.861, 0.903, 0.915>
      translate x*0.885
      rotate <0, 12.947, 13.154>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.854, 0.92, 0.965>
      translate x*0.507
      rotate <0, -9.898, 9.681>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <4, 0.945, 0.805>
      translate x*0.394
      rotate <0, -3.677, 4.174>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.976, 0.867, 0.803>
      translate x*0.729
      rotate <0, 15.926, -2.567>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.861, 0.909, 0.867>
      translate x*0.342
      rotate <0, -18.815, 6.853>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.803, 0.805, 0.845>
      translate x*0.244
      rotate <0, 8.384, 6.949>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.978, 0.98, 0.835>
      translate x*0.14
      rotate <0, 5.471, -6.47>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.865, 0.806, 0.814>
      translate x*0.047
      rotate <0, 8.77, 2.434>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.81, 0.98, 0.987>
      translate x*0.423
      rotate <0, -1.571, -3.236>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.921, 0.913, 0.984>
      translate x*0.139
      rotate <0, -5.744, 1.358>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.937, 0.96, 0.808>
      translate x*0.372
      rotate <0, 13.323, 29.76>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.869, 0.839, 0.912>
      translate x*0.879
      rotate <0, 6.2, -10.755>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.863, 0.893, 0.909>
      translate x*0.229
      rotate <0, 7.89, -8.492>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.938, 0.983, 0.895>
      translate x*0.457
      rotate <0, -25.454, -3.61>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.992, 0.949, 0.811>
      translate x*0.141
      rotate <0, 19.735, 5.574>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.92, 0.897, 0.931>
      translate x*0.201
      rotate <0, -13.468, 2.469>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.886, 0.931, 0.973>
      translate x*0.708
      rotate <0, -6.086, -8.477>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.921, 0.895, 0.938>
      translate x*0.755
      rotate <0, -10.058, 1.021>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.864, 0.857, 0.974>
      translate x*0.832
      rotate <0, -10.095, -2.056>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.861, 0.826, 0.916>
      translate x*0.341
      rotate <0, 3.107, -2.241>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.95, 0.972, 0.916>
      translate x*0.77
      rotate <0, 13.19, 0.048>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.911, 0.993, 0.895>
      translate x*0.615
      rotate <0, 13.868, -1.314>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.937, 0.861, 0.865>
      translate x*0.489
      rotate <0, 18.667, -17.208>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.807, 0.961, 0.86>
      translate x*0.868
      rotate <0, 15.747, 25.986>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.868, 0.863, 0.893>
      translate x*0.7
      rotate <0, -8.883, -3.476>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.918, 0.919, 0.995>
      translate x*0.553
      rotate <0, 11.509, 13.652>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <4, 0.95, 0.847>
      translate x*0.197
      rotate <0, 1.931, 22.092>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.911, 0.846, 0.932>
      translate x*0.4
      rotate <0, -11.637, -7.178>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.866, 0.971, 0.898>
      translate x*0.369
      rotate <0, -20.671, -7.602>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.99, 0.852, 0.863>
      translate x*0.604
      rotate <0, 19.004, -13.201>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.982, 0.917, 0.896>
      translate x*0.002
      rotate <0, 3.286, -0.626>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.853, 0.823, 0.882>
      translate x*0.838
      rotate <0, 12.72, 1.714>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.915, 0.827, 0.897>
      translate x*0.751
      rotate <0, -13.625, 13.327>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.844, 0.863, 0.918>
      translate x*0.085
      rotate <0, -9.215, 0.803>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.984, 0.871, 0.975>
      translate x*0.891
      rotate <0, -16.24, 7.641>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.945, 0.965, 0.944>
      translate x*0.532
      rotate <0, 2.356, -15.725>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.983, 0.943, 0.982>
      translate x*0.236
      rotate <0, 17.549, 7.796>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.976, 0.871, 0.897>
      translate x*0.032
      rotate <0, 3.083, 2.726>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.903, 0.992, 0.884>
      translate x*0.321
      rotate <0, 22.729, 9.678>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.96, 0.887, 0.917>
      translate x*0.865
      rotate <0, -11.333, -13.919>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.953, 0.923, 0.825>
      translate x*0.248
      rotate <0, -0.108, -5.861>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.924, 0.908, 0.824>
      translate x*0.812
      rotate <0, 9.575, -3.98>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.946, 0.813, 0.852>
      translate x*0.794
      rotate <0, 9.992, 6.786>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.969, 0.898, 0.941>
      translate x*0.769
      rotate <0, -0.868, -8.129>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.863, 0.948, 0.95>
      translate x*0.661
      rotate <0, 12.329, 13.964>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.812, 0.802, 0.907>
      translate x*0.414
      rotate <0, -10.794, -6.075>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.94, 0.944, 0.813>
      translate x*0.992
      rotate <0, 8.993, -4.096>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.906, 0.823, 0.849>
      translate x*0.662
      rotate <0, 9.713, -1.848>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.807, 0.952, 0.918>
      translate x*0.516
      rotate <0, 4.982, -0.008>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.855, 0.953, 0.883>
      translate x*0.91
      rotate <0, 6.15, 10.28>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.931, 0.918, 0.821>
      translate x*0.953
      rotate <0, 7.208, 3.154>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.939, 0.976, 0.815>
      translate x*0.315
      rotate <0, -28.609, 9.214>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.967, 0.979, 0.921>
      translate x*0.539
      rotate <0, 3.626, -9.708>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.935, 0.936, 0.891>
      translate x*0.599
      rotate <0, 1.939, -8.255>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.986, 0.884, 0.946>
      translate x*0.803
      rotate <0, -22.32, -10.224>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.977, 0.999, 0.987>
      translate x*0.14
      rotate <0, 6.88, 4.551>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.891, 0.82, 0.885>
      translate x*0.96
      rotate <0, 19.309, 4.928>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.941, 0.993, 0.982>
      translate x*0.321
      rotate <0, -8.258, 15.417>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.872, 0.82, 0.92>
      translate x*0.54
      rotate <0, -0.285, 2.486>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.975, 0.852, 0.8>
      translate x*0.41
      rotate <0, -14.522, 9.683>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.917, 0.841, 0.993>
      translate x*0.135
      rotate <0, 11.121, -18.985>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.982, 0.951, 0.971>
      translate x*0.448
      rotate <0, 16.802, 19.861>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.942, 0.991, 0.85>
      translate x*0.366
      rotate <0, -5.266, 4.224>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.969, 0.867, 0.888>
      translate x*0.899
      rotate <0, 0.084, -5.605>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.838, 0.889, 0.91>
      translate x*0.465
      rotate <0, -13.87, 6.172>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.964, 0.837, 0.923>
      translate x*0.055
      rotate <0, -2.968, 5.548>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.909, 0.935, 0.888>
      translate x*0.069
      rotate <0, 1.283, -2.681>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.927, 0.959, 0.869>
      translate x*0.45
      rotate <0, -17.626, -5.634>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.906, 0.982, 0.828>
      translate x*0.116
      rotate <0, -3.54, -1.606>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.84, 0.907, 0.972>
      translate x*0.762
      rotate <0, -12.238, 8.695>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.811, 0.879, 0.97>
      translate x*0.956
      rotate <0, 5.19, -4.941>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.918, 0.896, 0.926>
      translate x*0.971
      rotate <0, 16.122, -11.777>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.889, 0.884, 0.816>
      translate x*0.044
      rotate <0, -14.462, -3.683>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.819, 0.982, 0.985>
      translate x*0.751
      rotate <0, 24.647, -7.489>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.869, 0.902, 0.908>
      translate x*0.845
      rotate <0, -3.108, 21.661>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.895, 0.925, 0.873>
      translate x*0.352
      rotate <0, -7.311, -2.015>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.857, 0.866, 0.987>
      translate x*0.817
      rotate <0, -12.508, -8.102>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.855, 0.994, 0.952>
      translate x*0.464
      rotate <0, 0.728, 15.854>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.945, 0.911, 0.952>
      translate x*0.592
      rotate <0, 15.909, 20.655>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.801, 0.86, 0.806>
      translate x*0.811
      rotate <0, 12.665, 16.925>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.827, 0.944, 0.975>
      translate x*0.735
      rotate <0, -4.297, 1.5>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.892, 0.837, 0.824>
      translate x*0.472
      rotate <0, 19.65, -4.712>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.883, 0.973, 0.908>
      translate x*0.684
      rotate <0, 38.474, -4.328>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.892, 0.927, 0.839>
      translate x*0.168
      rotate <0, 21.658, -19.17>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.935, 0.906, 0.821>
      translate x*0.763
      rotate <0, -7.482, -8.621>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.984, 0.83, 0.881>
      translate x*0.023
      rotate <0, 13.038, -3.447>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.848, 0.864, 0.92>
      translate x*0.374
      rotate <0, 8.325, 11.632>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.974, 0.868, 0.833>
      translate x*0.537
      rotate <0, -23.746, -13.329>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.864, 0.824, 0.975>
      translate x*0.748
      rotate <0, -15.885, 5.584>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.985, 0.889, 0.934>
      translate x*0.764
      rotate <0, -9.97, 11.436>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.96, 0.957, 0.813>
      translate x*0.868
      rotate <0, -1.349, -3.652>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.864, 0.803, 0.807>
      translate x*0.954
      rotate <0, 0.125, -9.316>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.806, 0.942, 0.906>
      translate x*0.448
      rotate <0, -19.471, 4.256>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.898, 0.906, 0.875>
      translate x*0.138
      rotate <0, 6.958, -11.949>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.917, 0.947, 0.898>
      translate x*0.067
      rotate <0, 1.187, 14.53>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.963, 0.952, 0.935>
      translate x*0.421
      rotate <0, 2.29, 17.843>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.874, 0.854, 0.825>
      translate x*0.86
      rotate <0, -7.173, -11.663>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.801, 0.833, 0.849>
      translate x*0.959
      rotate <0, 1.198, -5.48>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.912, 0.905, 0.941>
      translate x*0.355
      rotate <0, -9.519, 18.195>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.853, 0.913, 0.831>
      translate x*0.884
      rotate <0, 17.543, -17.242>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.849, 0.866, 0.826>
      translate x*0.349
      rotate <0, -0.552, -9.31>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.837, 0.985, 0.976>
      translate x*0.662
      rotate <0, -6.833, 0.073>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.944, 0.967, 0.987>
      translate x*0.939
      rotate <0, -0.7, -2.51>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.806, 0.801, 0.824>
      translate x*0.632
      rotate <0, -14.975, -2.038>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.979, 0.835, 0.923>
      translate x*0.071
      rotate <0, -22.306, -18.388>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.97, 0.838, 0.9>
      translate x*0.727
      rotate <0, -3.522, 29.538>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.824, 0.957, 0.956>
      translate x*0.24
      rotate <0, 1.202, 3.912>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.916, 0.945, 0.914>
      translate x*0.62
      rotate <0, -15.038, 17.618>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.913, 0.802, 0.917>
      translate x*0.206
      rotate <0, 12.375, 0.769>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.815, 0.848, 0.88>
      translate x*0.783
      rotate <0, -3.746, 7.248>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.966, 0.843, 0.887>
      translate x*0.839
      rotate <0, -3.736, -2.061>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.946, 0.844, 0.92>
      translate x*0.225
      rotate <0, -2.446, 16.62>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.885, 0.897, 0.962>
      translate x*0.489
      rotate <0, -10.382, -0.475>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.828, 0.97, 0.919>
      translate x*0.882
      rotate <0, 7.597, -1.647>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.88, 0.928, 0.962>
      translate x*0.466
      rotate <0, 11.966, 1.068>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.992, 0.878, 0.908>
      translate x*0.922
      rotate <0, 0.022, -2.887>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.832, 0.837, 0.95>
      translate x*0.538
      rotate <0, 3.825, -6.315>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.973, 0.992, 0.821>
      translate x*0.453
      rotate <0, -1.79, -4.467>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.855, 0.873, 0.972>
      translate x*0.542
      rotate <0, -4.776, 12.261>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.87, 0.886, 0.816>
      translate x*0.385
      rotate <0, -6.19, 2.408>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.967, 0.901, 0.999>
      translate x*0.488
      rotate <0, 13.79, -1.362>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.948, 0.968, 0.898>
      translate x*0.432
      rotate <0, 11.18, 7.124>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.933, 0.853, 0.96>
      translate x*0.78
      rotate <0, 3.591, 0.787>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.916, 0.89, 0.952>
      translate x*0.519
      rotate <0, -14.054, -5.691>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.883, 0.895, 0.966>
      translate x*0.421
      rotate <0, 19.974, 10.913>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.884, 0.875, 0.8>
      translate x*0.066
      rotate <0, 19.916, 2.645>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.876, 0.949, 0.916>
      translate x*0.325
      rotate <0, -0.396, -0.516>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.905, 0.892, 0.896>
      translate x*0.915
      rotate <0, 8.554, -10.154>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.907, 0.993, 0.86>
      translate x*0.102
      rotate <0, 6.932, 0.134>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.815, 0.961, 0.993>
      translate x*0.889
      rotate <0, 7.241, 15.734>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.829, 0.873, 0.84>
      translate x*0.949
      rotate <0, 4.297, -1.581>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.989, 0.816, 0.87>
      translate x*0.226
      rotate <0, -15.469, 13.413>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.995, 0.968, 0.869>
      translate x*0.507
      rotate <0, -13.1, -16.609>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.805, 0.915, 0.965>
      translate x*0.385
      rotate <0, -7.359, 8.49>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.975, 0.924, 0.864>
      translate x*0.805
      rotate <0, -2.144, 10.957>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.953, 0.921, 0.907>
      translate x*0.979
      rotate <0, 3.369, -3.686>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.872, 0.905, 0.906>
      translate x*0.668
      rotate <0, 0.538, 14.002>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.859, 0.942, 0.877>
      translate x*0.815
      rotate <0, -4.326, 1.219>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.88, 0.881, 0.935>
      translate x*0.215
      rotate <0, 11.449, 12.231>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.89, 0.962, 0.907>
      translate x*0.305
      rotate <0, -0.858, 7.71>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.911, 0.894, 0.956>
      translate x*0.298
      rotate <0, 2.825, 12.701>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.885, 0.839, 0.943>
      translate x*0.726
      rotate <0, 7.53, 11.591>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.835, 0.927, 0.961>
      translate x*0.026
      rotate <0, 14.195, -9.972>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.989, 0.814, 0.872>
      translate x*0.095
      rotate <0, 6.647, -11.019>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.858, 0.812, 0.944>
      translate x*0.732
      rotate <0, -5.883, -6.787>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.836, 0.993, 0.851>
      translate x*0.633
      rotate <0, -17.25, -4.801>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.888, 0.909, 0.919>
      translate x*0.006
      rotate <0, -8.698, 0.074>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.948, 0.859, 0.833>
      translate x*0.086
      rotate <0, 11.701, -0.515>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.9, 0.884, 0.808>
      translate x*0.666
      rotate <0, 0.356, 10.248>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.914, 0.975, 0.921>
      translate x*0.38
      rotate <0, -4.901, -8.477>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.869, 0.828, 0.823>
      translate x*0.793
      rotate <0, -2.65, -2.273>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.899, 0.822, 0.962>
      translate x*0.371
      rotate <0, -4.41, 1.732>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.971, 0.932, 0.889>
      translate x*0.19
      rotate <0, 10.436, 9.9>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.949, 0.852, 0.896>
      translate x*0.675
      rotate <0, 5.6, -4.693>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.913, 0.869, 0.855>
      translate x*0.897
      rotate <0, 16.74, -1.925>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.955, 0.977, 0.974>
      translate x*0.832
      rotate <0, -18.317, 1.958>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.812, 0.802, 0.927>
      translate x*0.63
      rotate <0, 2.729, 2.441>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.833, 0.901, 0.874>
      translate x*0.297
      rotate <0, -1.278, -2.664>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.969, 0.857, 0.961>
      translate x*0.254
      rotate <0, 3.296, 12.443>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.872, 0.998, 0.91>
      translate x*0.002
      rotate <0, -11.806, -5.896>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.861, 0.882, 0.975>
      translate x*0.686
      rotate <0, 0.762, -18.461>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.935, 0.838, 0.876>
      translate x*0.489
      rotate <0, 18.719, 14.621>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.803, 0.848, 0.999>
      translate x*0.821
      rotate <0, 3.02, 1.306>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.934, 0.984, 0.814>
      translate x*0.854
      rotate <0, -4.894, -4.789>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.895, 0.993, 0.921>
      translate x*0.373
      rotate <0, 2.052, -14.132>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.981, 0.846, 0.949>
      translate x*0.012
      rotate <0, 10.132, -10.01>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.803, 0.964, 0.96>
      translate x*0.738
      rotate <0, -11.993, -0.395>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.945, 0.926, 0.986>
      translate x*0.009
      rotate <0, -2.754, 4.208>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.91, 0.978, 0.919>
      translate x*0.262
      rotate <0, 20.101, 15.129>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.892, 0.924, 0.903>
      translate x*0.391
      rotate <0, 2.446, 5.088>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.862, 0.944, 0.943>
      translate x*0.525
      rotate <0, -10.486, 6.472>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.854, 0.951, 0.935>
      translate x*0.878
      rotate <0, -12.477, -7.881>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.95, 0.86, 0.841>
      translate x*0.52
      rotate <0, 11.542, -7.519>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.906, 0.832, 0.994>
      translate x*0.823
      rotate <0, -9.097, 2.781>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.867, 0.943, 0.997>
      translate x*0.841
      rotate <0, -9.811, 11.362>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.887, 0.808, 0.908>
      translate x*0.226
      rotate <0, -9.686, 19.665>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.968, 0.893, 0.83>
      translate x*0.255
      rotate <0, 12.445, 1.37>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.855, 0.955, 0.833>
      translate x*0.271
      rotate <0, 5.468, 2.962>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.874, 0.858, 0.92>
      translate x*0.285
      rotate <0, -4.55, 0.586>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.9, 0.92, 0.911>
      translate x*0.661
      rotate <0, 1.014, 14.281>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.845, 0.993, 0.871>
      translate x*0.657
      rotate <0, 3.775, -7.227>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.916, 0.972, 0.838>
      translate x*0.224
      rotate <0, -4.047, 7.773>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.878, 0.889, 0.921>
      translate x*0.757
      rotate <0, -3.973, -7.74>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.85, 0.898, 0.914>
      translate x*0.549
      rotate <0, 11.739, -1.468>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.836, 0.855, 0.872>
      translate x*0.443
      rotate <0, -1.989, -5.157>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.929, 0.826, 0.925>
      translate x*0.644
      rotate <0, 1.301, 4.226>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.875, 0.836, 0.849>
      translate x*0.861
      rotate <0, 13.655, -8.35>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.886, 0.805, 0.948>
      translate x*0.858
      rotate <0, -8.818, 1.945>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.973, 0.85, 0.96>
      translate x*0.103
      rotate <0, -1.079, -3.04>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.982, 0.919, 0.924>
      translate x*0.578
      rotate <0, 3.024, -19.772>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.922, 0.822, 0.874>
      translate x*0.865
      rotate <0, 1.926, -13.073>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.953, 0.886, 0.98>
      translate x*0.423
      rotate <0, 22.63, -7.767>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.901, 0.805, 0.879>
      translate x*0.444
      rotate <0, -9.514, 0.191>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.966, 0.999, 0.849>
      translate x*0.954
      rotate <0, -9.208, 2.024>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.879, 0.959, 0.939>
      translate x*0.711
      rotate <0, 22.297, -2.666>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.822, 0.855, 0.882>
      translate x*0.138
      rotate <0, 12.138, -6.058>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.863, 0.978, 0.814>
      translate x*0.935
      rotate <0, 14.991, 6.157>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.994, 0.864, 0.887>
      translate x*0.05
      rotate <0, 12.186, -18.968>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.956, 0.845, 0.867>
      translate x*0.567
      rotate <0, -0.746, -18.253>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.828, 0.836, 0.986>
      translate x*0.58
      rotate <0, -13.148, 10.489>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.924, 0.898, 0.912>
      translate x*0.36
      rotate <0, 4.264, -19.702>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.995, 0.975, 0.839>
      translate x*0.132
      rotate <0, -9.396, 6.094>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.946, 0.986, 0.834>
      translate x*0.448
      rotate <0, -21.37, 15.656>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.834, 0.868, 0.92>
      translate x*0.549
      rotate <0, -0.5, 13.616>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.942, 0.802, 0.829>
      translate x*0.258
      rotate <0, 0.076, 5.56>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.965, 0.877, 0.886>
      translate x*0.783
      rotate <0, 7.322, 5.13>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.852, 0.866, 0.903>
      translate x*0.367
      rotate <0, 1.083, 4.543>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.909, 0.865, 0.837>
      translate x*0.038
      rotate <0, 23.024, 12.246>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.975, 0.954, 0.974>
      translate x*0.68
      rotate <0, 7.695, 14.468>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <4, 0.922, 0.999>
      translate x*0.392
      rotate <0, -8.288, -15.805>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.81, 0.939, 0.915>
      translate x*0.553
      rotate <0, -1.271, 13.665>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.826, 0.941, 0.93>
      translate x*0.135
      rotate <0, -8.618, -15.251>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.841, 0.943, 0.98>
      translate x*0.73
      rotate <0, -25.406, -0.374>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.983, 0.812, 0.884>
      translate x*0.33
      rotate <0, -4.38, 3.951>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.998, 0.861, 0.852>
      translate x*0.21
      rotate <0, 2.931, -9.745>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.876, 0.982, 0.93>
      translate x*0.336
      rotate <0, -13.498, -1.392>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.914, 0.868, 0.871>
      translate x*0.423
      rotate <0, -9.679, 6.606>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.851, 0.841, 0.961>
      translate x*0.292
      rotate <0, 19.894, 1.535>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.847, 0.852, 0.949>
      translate x*0.332
      rotate <0, -8.758, 6.114>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.901, 0.988, 0.892>
      translate x*0.802
      rotate <0, -4.613, 25.497>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.862, 0.903, 0.857>
      translate x*0.332
      rotate <0, -12.476, -6.747>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.919, 0.949, 0.881>
      translate x*0.328
      rotate <0, -6.929, 9.84>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.84, 0.892, 0.879>
      translate x*0.067
      rotate <0, 9.507, 0.621>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.844, 0.87, 0.971>
      translate x*0.027
      rotate <0, 5.382, -20.237>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.833, 0.955, 0.824>
      translate x*0.539
      rotate <0, 12.124, -0.605>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.981, 0.888, 0.885>
      translate x*0.034
      rotate <0, -1.777, -17.797>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.803, 0.854, 0.889>
      translate x*0.128
      rotate <0, 5.123, 8.144>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.922, 0.998, 0.881>
      translate x*0.437
      rotate <0, -6.403, 16.314>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.981, 0.892, 0.852>
      translate x*0.391
      rotate <0, -5.344, -9.043>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.875, 0.991, 0.891>
      translate x*0.432
      rotate <0, 3.955, -21.511>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.989, 0.868, 0.81>
      translate x*0.766
      rotate <0, 7.448, -6.142>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.908, 0.822, 0.944>
      translate x*0.418
      rotate <0, 2.484, -4.086>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.836, 0.862, 0.83>
      translate x*0.552
      rotate <0, 6.761, 2.481>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.816, 0.852, 0.822>
      translate x*0.018
      rotate <0, -0.44, 4.599>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.861, 0.815, 0.82>
      translate x*0.78
      rotate <0, -16.621, 5.966>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.837, 0.839, 0.821>
      translate x*0.268
      rotate <0, -22.43, -10.116>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.815, 0.802, 0.896>
      translate x*0.855
      rotate <0, -17.17, 2.054>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.996, 0.815, 0.875>
      translate x*0.489
      rotate <0, -5.665, -2.636>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.859, 0.865, 0.867>
      translate x*0.084
      rotate <0, -7.933, -15.663>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.83, 0.825, 0.832>
      translate x*0.566
      rotate <0, 3.349, -11.79>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.978, 0.814, 0.977>
      translate x*0.461
      rotate <0, -1.186, -5.355>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.955, 0.972, 0.815>
      translate x*0.646
      rotate <0, 13.046, 2.863>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.869, 0.936, 0.863>
      translate x*0.331
      rotate <0, 14.812, -6.465>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.935, 0.825, 0.967>
      translate x*0.486
      rotate <0, -10.673, 11.054>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.927, 0.942, 0.949>
      translate x*0.811
      rotate <0, 4.179, -8.16>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.818, 0.965, 0.821>
      translate x*0.969
      rotate <0, 3.552, 8.134>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.873, 0.994, 0.932>
      translate x*0.075
      rotate <0, 12.091, 4.267>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.885, 0.996, 0.878>
      translate x*0.513
      rotate <0, 6.227, -12.325>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.947, 0.82, 0.903>
      translate x*0.887
      rotate <0, -8.974, 15.991>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.898, 0.907, 0.954>
      translate x*0.376
      rotate <0, -19.408, 2.303>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.909, 0.887, 0.822>
      translate x*0.994
      rotate <0, -20.239, 3.232>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.874, 0.82, 0.959>
      translate x*0.109
      rotate <0, -11.654, -9.244>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.889, 0.912, 0.829>
      translate x*0.262
      rotate <0, -11.633, 6.769>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.974, 0.9, 0.975>
      translate x*0.646
      rotate <0, -26.286, 3.106>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.806, 0.809, 0.98>
      translate x*0.659
      rotate <0, 16.405, 11.373>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.851, 0.963, 0.813>
      translate x*0.781
      rotate <0, 2.074, -13.864>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.902, 0.829, 0.806>
      translate x*0.468
      rotate <0, 13.548, 2.12>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.925, 0.867, 0.987>
      translate x*0.027
      rotate <0, 7.375, 0.829>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.825, 0.9, 0.985>
      translate x*0.355
      rotate <0, -6.157, -13.455>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.836, 0.902, 0.807>
      translate x*0.098
      rotate <0, -11.442, -2.055>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.894, 0.833, 0.807>
      translate x*0.147
      rotate <0, 4.84, 29.633>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.848, 0.993, 0.823>
      translate x*0.52
      rotate <0, 5.188, -12.352>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.885, 0.88, 0.848>
      translate x*0.455
      rotate <0, -29.206, 18.577>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.949, 0.804, 0.814>
      translate x*0.112
      rotate <0, 0.539, -6.845>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.857, 0.828, 0.813>
      translate x*0.512
      rotate <0, -24.823, 8.31>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.926, 0.874, 0.868>
      translate x*0.329
      rotate <0, -9.672, 0.377>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.888, 0.812, 0.87>
      translate x*0.838
      rotate <0, 5.696, -11.251>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.854, 0.969, 0.837>
      translate x*0.723
      rotate <0, 9.332, 1.523>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.913, 0.924, 0.941>
      translate x*0.611
      rotate <0, 3.058, 8.743>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.98, 0.875, 0.817>
      translate x*0.002
      rotate <0, -5.905, 8.623>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.834, 0.905, 0.962>
      translate x*0.867
      rotate <0, -7.316, -10.325>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.936, 0.928, 0.829>
      translate x*0.458
      rotate <0, -22.037, 2.957>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.818, 0.899, 0.884>
      translate x*0.887
      rotate <0, 0.6, -16.3>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.978, 0.994, 0.869>
      translate x*0.732
      rotate <0, 8.632, 8.344>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.827, 0.85, 0.928>
      translate x*0.411
      rotate <0, 0.721, -6.416>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.873, 0.901, 0.987>
      translate x*0.181
      rotate <0, 20.472, 2.271>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.805, 0.832, 0.961>
      translate x*0.535
      rotate <0, -9.254, -10.89>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.819, 0.936, 0.861>
      translate x*0.342
      rotate <0, -4.2, -15.182>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.877, 0.98, 0.809>
      translate x*0.419
      rotate <0, -12.114, 5.019>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.948, 0.912, 0.844>
      translate x*0.226
      rotate <0, -0.638, 3.362>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.866, 0.824, 0.879>
      translate x*0.173
      rotate <0, -18.363, -4.536>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.878, 0.901, 0.834>
      translate x*0.452
      rotate <0, -11.791, -2.986>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.996, 0.978, 0.991>
      translate x*0.549
      rotate <0, -5.177, 1.933>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.965, 0.866, 0.844>
      translate x*0.46
      rotate <0, -10.79, 2.778>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.982, 0.907, 0.909>
      translate x*0.3
      rotate <0, 2.13, 9.618>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.827, 0.969, 0.939>
      translate x*0.305
      rotate <0, 18.405, 23.373>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.881, 0.808, 0.967>
      translate x*0.34
      rotate <0, 13.338, 13.196>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.889, 0.883, 0.9>
      translate x*0.766
      rotate <0, 10.429, 2.71>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.994, 0.831, 0.968>
      translate x*0.061
      rotate <0, -25.518, 14.996>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.818, 0.805, 0.982>
      translate x*0.785
      rotate <0, -3.787, -11.01>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.899, 0.984, 0.871>
      translate x*0.443
      rotate <0, 10.158, -15.494>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.901, 0.986, 0.844>
      translate x*0.457
      rotate <0, 5.194, 19.372>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.815, 0.836, 0.923>
      translate x*0.815
      rotate <0, 0.183, 6.211>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.935, 0.967, 0.897>
      translate x*0.1
      rotate <0, -21.761, 10.209>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.856, 0.871, 0.87>
      translate x*0.398
      rotate <0, -14.154, -3.292>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.974, 0.856, 0.86>
      translate x*0.113
      rotate <0, -16.482, 2.798>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.89, 0.907, 0.994>
      translate x*0.997
      rotate <0, 14.947, -1.916>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.816, 0.921, 0.866>
      translate x*0.65
      rotate <0, 1.524, 4.62>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.864, 0.922, 0.911>
      translate x*0.46
      rotate <0, 8.868, -15.482>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.864, 0.939, 0.808>
      translate x*0.343
      rotate <0, 3.484, -7.954>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.995, 0.816, 0.979>
      translate x*0.787
      rotate <0, 12.864, 9.071>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.943, 0.872, 0.97>
      translate x*0.561
      rotate <0, 9.356, -1.537>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.802, 0.944, 0.942>
      translate x*0.985
      rotate <0, -3.175, 11.652>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.821, 0.815, 0.93>
      translate x*0.976
      rotate <0, 9.641, 13.802>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.878, 0.843, 0.983>
      translate x*0.078
      rotate <0, 11.701, -4.903>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.897, 0.892, 0.878>
      translate x*0.402
      rotate <0, 13.238, -8.566>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.865, 0.903, 0.883>
      translate x*0.853
      rotate <0, 0.829, 10.365>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.916, 0.925, 0.843>
      translate x*0.177
      rotate <0, -2.457, 0.394>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.846, 0.885, 0.969>
      translate x*0.244
      rotate <0, -0.636, 9.795>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.88, 0.87, 0.87>
      translate x*0.575
      rotate <0, -0.982, -9.09>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.909, 0.958, 0.866>
      translate x*0.455
      rotate <0, -14.954, 5.396>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.891, 0.952, 0.926>
      translate x*0.985
      rotate <0, 0.459, -20.789>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.995, 0.843, 0.808>
      translate x*0.206
      rotate <0, -6.485, 15.156>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.816, 0.96, 0.902>
      translate x*0.879
      rotate <0, -26.838, -12.435>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.892, 0.834, 0.836>
      translate x*0.72
      rotate <0, -10.61, -5.688>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.817, 0.97, 0.98>
      translate x*0.78
      rotate <0, 6.227, 5.533>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.982, 0.999, 0.949>
      translate x*0.308
      rotate <0, 10.344, -9.424>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.904, 0.842, 0.807>
      translate x*0.758
      rotate <0, 5.198, 4.402>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.902, 0.821, 0.81>
      translate x*0.703
      rotate <0, 3.374, 0.266>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.881, 0.845, 0.89>
      translate x*0.177
      rotate <0, -3.726, 6.758>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.836, 0.873, 0.999>
      translate x*0.481
      rotate <0, 2.502, -7.68>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.947, 0.89, 0.924>
      translate x*0.71
      rotate <0, 26.304, 3.185>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.88, 0.913, 0.9>
      translate x*0.214
      rotate <0, -4.883, 21.162>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.986, 0.992, 0.965>
      translate x*0.842
      rotate <0, -1.218, 6.041>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.919, 0.863, 0.915>
      translate x*0.217
      rotate <0, 6.181, -4.616>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.954, 0.953, 0.878>
      translate x*0.388
      rotate <0, -3.937, -3.713>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.94, 0.978, 1>
      translate x*0.006
      rotate <0, -0.49, -4.781>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.866, 0.999, 0.863>
      translate x*0.738
      rotate <0, 12.02, -6.656>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.928, 0.969, 0.906>
      translate x*0.845
      rotate <0, 5.361, 9.766>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.9, 0.84, 0.984>
      translate x*0.864
      rotate <0, -18.636, -20.068>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.976, 0.864, 0.83>
      translate x*0.006
      rotate <0, -10.466, -1.054>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.825, 0.803, 0.81>
      translate x*0.294
      rotate <0, 1.83, -4.121>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.836, 0.905, 0.948>
      translate x*0.598
      rotate <0, -6.793, -8.855>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.96, 0.81, 0.995>
      translate x*0.58
      rotate <0, -8.53, 0.85>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.865, 0.933, 0.846>
      translate x*0.105
      rotate <0, -1.264, 5.525>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.989, 0.928, 0.999>
      translate x*0.997
      rotate <0, 9.259, -12.027>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.878, 0.885, 0.812>
      translate x*0.99
      rotate <0, 14.62, 1.964>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.911, 0.984, 0.884>
      translate x*0.461
      rotate <0, 1.231, 8.339>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.964, 0.935, 0.909>
      translate x*0.991
      rotate <0, -9.136, 7.596>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.979, 0.877, 0.88>
      translate x*0.921
      rotate <0, 8.367, 0.326>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.884, 0.807, 0.898>
      translate x*0.988
      rotate <0, -14.047, 10.92>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.995, 0.95, 0.963>
      translate x*0.718
      rotate <0, 6.461, -4.268>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.998, 0.91, 0.817>
      translate x*0.54
      rotate <0, -7.345, -11.551>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.902, 0.988, 0.834>
      translate x*0.664
      rotate <0, -17.831, -3.318>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.848, 0.902, 0.992>
      translate x*0.492
      rotate <0, -12.126, 2.86>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.964, 0.886, 0.841>
      translate x*0.818
      rotate <0, 3.469, 11.267>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.839, 0.831, 0.997>
      translate x*0.251
      rotate <0, 9.777, 5.625>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.958, 0.85, 0.936>
      translate x*0.23
      rotate <0, -11.249, 21.905>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.846, 0.984, 0.821>
      translate x*0.608
      rotate <0, -0.608, -8.916>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.976, 0.891, 0.913>
      translate x*0.131
      rotate <0, 12.748, 2.368>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.887, 0.871, 0.863>
      translate x*0.236
      rotate <0, -10.066, 2.924>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.962, 0.965, 0.905>
      translate x*0.322
      rotate <0, 1.536, -2.536>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.994, 0.974, 0.929>
      translate x*0.222
      rotate <0, 9.033, 16.054>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.873, 0.819, 0.895>
      translate x*0.757
      rotate <0, -9.185, 9.33>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.929, 0.811, 0.93>
      translate x*0.261
      rotate <0, 1.123, 10.812>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.898, 0.988, 0.934>
      translate x*0.568
      rotate <0, -8.302, 4.316>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.95, 0.811, 0.964>
      translate x*0.384
      rotate <0, 11.179, -1.492>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.921, 0.929, 0.885>
      translate x*0.023
      rotate <0, -9.787, 0.412>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.806, 0.879, 0.992>
      translate x*0.336
      rotate <0, 1.046, -8.759>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.968, 0.807, 0.917>
      translate x*0.17
      rotate <0, 0.751, -2.794>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.855, 0.841, 0.872>
      translate x*0.981
      rotate <0, -4.442, 10.982>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.913, 0.837, 0.866>
      translate x*0.159
      rotate <0, 15.667, -3.67>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.965, 0.925, 0.867>
      translate x*0.354
      rotate <0, -10.318, -13.125>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.883, 0.993, 0.959>
      translate x*0.483
      rotate <0, -12.729, -5.636>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.826, 0.801, 0.906>
      translate x*0.221
      rotate <0, 25.894, 7.738>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.952, 0.883, 0.952>
      translate x*0.65
      rotate <0, -3.605, -19.832>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.804, 0.821, 0.992>
      translate x*0.288
      rotate <0, -6.988, -25.281>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.853, 0.908, 0.865>
      translate x*0.013
      rotate <0, -0.203, 10.614>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.881, 0.873, 0.948>
      translate x*0.408
      rotate <0, -0.292, -2.905>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.993, 1, 0.856>
      translate x*0.765
      rotate <0, -5.421, 0.682>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.911, 0.807, 0.994>
      translate x*0.428
      rotate <0, 9.903, 12.156>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.808, 0.963, 0.928>
      translate x*0.346
      rotate <0, -8.129, 9.888>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.818, 0.934, 0.841>
      translate x*0.526
      rotate <0, -10.716, 8.172>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.852, 0.996, 0.908>
      translate x*0.753
      rotate <0, 25.984, 1.02>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.899, 0.863, 0.908>
      translate x*0.18
      rotate <0, -5.855, 15.39>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.929, 0.945, 0.895>
      translate x*0.501
      rotate <0, 11.245, -2.857>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.926, 0.879, 0.829>
      translate x*0.12
      rotate <0, -0.219, 8.035>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.991, 0.944, 0.905>
      translate x*0.231
      rotate <0, 20.749, -3.155>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.929, 0.815, 0.97>
      translate x*0.906
      rotate <0, 3.647, -13.704>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.999, 0.898, 0.825>
      translate x*0.211
      rotate <0, -16.764, 9.691>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.847, 0.936, 0.818>
      translate x*0.978
      rotate <0, 8.508, -14.755>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.963, 0.979, 0.895>
      translate x*0.231
      rotate <0, 8.313, -8.138>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.829, 0.877, 0.863>
      translate x*0.323
      rotate <0, -11.211, 3.675>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.875, 0.862, 0.929>
      translate x*0.625
      rotate <0, -11.756, -4.072>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.877, 0.859, 0.938>
      translate x*0.114
      rotate <0, 9.354, 19.82>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.83, 0.804, 0.802>
      translate x*0.434
      rotate <0, -1.483, -9.246>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.905, 0.923, 0.928>
      translate x*0.947
      rotate <0, -12.073, -9.082>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.974, 0.969, 0.9>
      translate x*0.939
      rotate <0, 1.424, -10.527>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.814, 0.906, 0.925>
      translate x*0.551
      rotate <0, -9.626, 27.602>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.847, 0.807, 0.983>
      translate x*0.074
      rotate <0, 2.849, 1.525>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.948, 0.999, 0.836>
      translate x*0.088
      rotate <0, -1.938, -7.929>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.88, 0.803, 0.83>
      translate x*0.454
      rotate <0, -17.488, 2.713>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.843, 0.905, 0.812>
      translate x*0.41
      rotate <0, 0.528, 7.022>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.911, 0.884, 0.832>
      translate x*0.022
      rotate <0, 15.854, 15.247>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.926, 0.959, 0.823>
      translate x*0.904
      rotate <0, 0.654, 8.308>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.966, 0.915, 0.809>
      translate x*0.557
      rotate <0, 3.812, 11.755>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.969, 0.896, 0.83>
      translate x*0.789
      rotate <0, 5.585, 8.284>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.885, 0.87, 0.903>
      translate x*0.54
      rotate <0, -7.311, -12.787>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.877, 0.947, 0.985>
      translate x*0.99
      rotate <0, 10.602, -5.18>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.936, 0.997, 0.92>
      translate x*0.128
      rotate <0, -15.667, 8.78>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.89, 0.859, 0.819>
      translate x*0.954
      rotate <0, -10.83, 16.944>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.885, 0.882, 0.889>
      translate x*0.219
      rotate <0, 2.852, -0.503>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.893, 0.998, 0.933>
      translate x*0.037
      rotate <0, 4.375, -5.91>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.985, 0.814, 0.908>
      translate x*0.877
      rotate <0, 14.087, 1.812>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.815, 0.835, 0.861>
      translate x*0.325
      rotate <0, -13.02, 3.904>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.835, 0.867, 0.925>
      translate x*0.585
      rotate <0, -3.952, 4.923>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.897, 0.888, 0.919>
      translate x*0.023
      rotate <0, -8.697, 9.597>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.876, 0.996, 0.849>
      translate x*0.099
      rotate <0, -15.457, 9.881>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.925, 0.912, 0.812>
      translate x*0.762
      rotate <0, -5.849, -14.197>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.989, 0.861, 0.93>
      translate x*0.882
      rotate <0, 8.222, 4.438>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.906, 0.903, 0.908>
      translate x*0.47
      rotate <0, -11.981, 3.908>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.836, 0.986, 0.895>
      translate x*0.364
      rotate <0, 1.235, 5.604>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.973, 0.814, 0.852>
      translate x*0.657
      rotate <0, -26.223, -0.173>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.93, 0.854, 0.89>
      translate x*0.538
      rotate <0, 15.751, -2.114>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.9, 0.853, 0.928>
      translate x*0.244
      rotate <0, 4.063, -14.812>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.97, 0.853, 0.813>
      translate x*0.623
      rotate <0, 18.528, 21.165>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.932, 0.959, 0.947>
      translate x*0.318
      rotate <0, 14.595, 4.908>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.922, 0.969, 0.976>
      translate x*0.798
      rotate <0, 1.781, -3.802>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.975, 0.815, 0.969>
      translate x*0.405
      rotate <0, 2.637, 2.108>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.889, 0.853, 0.806>
      translate x*0.249
      rotate <0, -7.462, -2.298>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.986, 0.91, 0.922>
      translate x*0.166
      rotate <0, -22.185, 21.35>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.942, 0.841, 0.994>
      translate x*0.035
      rotate <0, 18.73, -1.015>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.889, 0.904, 0.952>
      translate x*0.611
      rotate <0, -19.479, -0.833>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.863, 0.861, 0.922>
      translate x*0.499
      rotate <0, 0.211, -9.893>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.958, 0.902, 0.844>
      translate x*0.22
      rotate <0, -10.885, -7.159>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.873, 0.914, 0.876>
      translate x*0.243
      rotate <0, 6.945, -14.47>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.904, 0.993, 0.856>
      translate x*0.575
      rotate <0, -0.857, 0.413>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.987, 0.952, 0.955>
      translate x*0.899
      rotate <0, 0.56, 19.221>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.888, 0.963, 0.817>
      translate x*0.393
      rotate <0, 11.792, -5.115>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.974, 0.94, 0.911>
      translate x*0.195
      rotate <0, -6.489, 3.195>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.82, 0.847, 0.907>
      translate x*0.064
      rotate <0, 10.804, -2.422>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.868, 0.84, 0.92>
      translate x*0.062
      rotate <0, -5.951, 15.444>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.848, 0.905, 0.894>
      translate x*0.081
      rotate <0, 13.06, 9.634>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.904, 0.986, 0.805>
      translate x*0.785
      rotate <0, 23.224, -6.765>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.903, 0.807, 0.931>
      translate x*0.961
      rotate <0, -3.939, -1.392>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.924, 0.89, 0.83>
      translate x*0.428
      rotate <0, -7.855, -2.253>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.906, 0.91, 0.993>
      translate x*0.559
      rotate <0, -8.484, 11.131>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.826, 0.859, 0.882>
      translate x*0.046
      rotate <0, 1.71, 2.007>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.803, 0.899, 0.962>
      translate x*0.864
      rotate <0, 4.266, 8.613>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.809, 0.965, 0.848>
      translate x*0.425
      rotate <0, 13.02, -15.905>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.929, 0.994, 0.929>
      translate x*0.674
      rotate <0, 9.753, -11.048>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.875, 0.827, 0.923>
      translate x*0.337
      rotate <0, 14.712, 9.599>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.969, 0.878, 0.824>
      translate x*0.749
      rotate <0, 1.261, 3.214>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.851, 0.857, 0.934>
      translate x*0.568
      rotate <0, 7.408, -6.73>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.927, 0.857, 0.856>
      translate x*0.338
      rotate <0, 16.138, -5.738>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.89, 0.954, 0.938>
      translate x*0.211
      rotate <0, 19.522, -12.142>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.852, 0.907, 0.96>
      translate x*0.174
      rotate <0, 4.231, 2.295>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.809, 0.956, 0.869>
      translate x*0.968
      rotate <0, 14.621, -5.899>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.847, 0.814, 0.826>
      translate x*0.329
      rotate <0, 19.737, -19.729>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.924, 0.952, 0.98>
      translate x*0.459
      rotate <0, -11.421, 7.821>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.807, 0.968, 0.835>
      translate x*0.54
      rotate <0, -0.293, 4.172>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.849, 0.887, 0.978>
      translate x*0.782
      rotate <0, -3.277, 6.109>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.904, 0.912, 0.949>
      translate x*0.88
      rotate <0, -5.598, 1.101>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.809, 0.822, 0.887>
      translate x*0.828
      rotate <0, -10.785, 0.562>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.98, 0.909, 0.993>
      translate x*0.897
      rotate <0, -7.265, 8.154>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.836, 0.808, 0.83>
      translate x*0.079
      rotate <0, -13.144, -8.455>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.954, 0.929, 0.876>
      translate x*0.583
      rotate <0, -7.987, -10.943>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.9, 0.826, 0.873>
      translate x*0.914
      rotate <0, -4.436, 11.437>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.899, 0.82, 0.881>
      translate x*0.808
      rotate <0, -4.807, -6.478>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.845, 0.86, 0.828>
      translate x*0.634
      rotate <0, -12.278, -5.154>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.817, 0.959, 0.886>
      translate x*0.081
      rotate <0, -15.121, 10.303>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.88, 0.849, 0.843>
      translate x*0.735
      rotate <0, 8.622, 23.74>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.847, 0.851, 0.929>
      translate x*0.758
      rotate <0, 1.269, -1.092>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.991, 0.88, 0.985>
      translate x*0.15
      rotate <0, -7.772, -10.511>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.837, 0.878, 0.889>
      translate x*0.074
      rotate <0, 13.287, 2.948>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.936, 0.883, 0.952>
      translate x*0.473
      rotate <0, -7.533, -0.241>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.933, 0.952, 0.997>
      translate x*0.616
      rotate <0, 10.092, 14.081>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.875, 0.871, 0.992>
      translate x*0.401
      rotate <0, 18.279, -3.745>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.986, 0.992, 0.84>
      translate x*0.11
      rotate <0, 2.217, -6.467>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.805, 0.908, 0.902>
      translate x*0.897
      rotate <0, -13.367, -4.751>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.958, 0.857, 0.883>
      translate x*0.644
      rotate <0, 11.522, 8.143>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.951, 0.929, 0.861>
      translate x*0.81
      rotate <0, -22.266, 4.899>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.812, 0.976, 0.862>
      translate x*0.692
      rotate <0, 3.208, -12.069>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.983, 0.896, 0.87>
      translate x*0.964
      rotate <0, -1.359, 23.297>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.97, 0.996, 0.986>
      translate x*0.568
      rotate <0, -4.906, -1.875>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.906, 0.933, 0.868>
      translate x*0.942
      rotate <0, -8.489, -0.772>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.929, 0.987, 0.984>
      translate x*0.176
      rotate <0, -26.62, 16.646>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.802, 0.806, 0.979>
      translate x*0.084
      rotate <0, -11.312, -20.39>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.812, 0.84, 0.843>
      translate x*0.183
      rotate <0, -5.881, 1.994>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.962, 0.89, 0.874>
      translate x*0.426
      rotate <0, -1.143, -10.421>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.952, 0.87, 0.987>
      translate x*0.974
      rotate <0, 15.613, 10.523>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.885, 0.904, 0.998>
      translate x*0.579
      rotate <0, -5.514, 13.192>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.97, 0.986, 0.816>
      translate x*0.026
      rotate <0, -15.054, 8.065>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.996, 0.84, 0.936>
      translate x*0.81
      rotate <0, 4.764, -7.289>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.971, 0.936, 0.87>
      translate x*0.556
      rotate <0, -0.113, -1.134>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.853, 0.879, 0.986>
      translate x*0.8
      rotate <0, 12.266, -13.559>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.8, 0.868, 0.846>
      translate x*0.583
      rotate <0, 13.368, 8.82>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.977, 0.817, 0.903>
      translate x*0.834
      rotate <0, 5.554, 7.096>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.875, 0.839, 0.815>
      translate x*0.753
      rotate <0, -6.232, -6.047>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.813, 0.879, 0.971>
      translate x*0.429
      rotate <0, -6.065, 4.645>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.865, 0.805, 0.971>
      translate x*0.565
      rotate <0, -15.799, 15.131>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.819, 0.974, 0.9>
      translate x*0.627
      rotate <0, 12.607, -4.374>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.809, 0.821, 0.974>
      translate x*0.863
      rotate <0, -9.94, 17.968>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.909, 0.943, 0.963>
      translate x*0.46
      rotate <0, 8.384, -13.114>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.851, 0.884, 0.899>
      translate x*0.715
      rotate <0, -9.999, -9.11>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.953, 0.961, 0.8>
      translate x*0.339
      rotate <0, 6.253, 7.714>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.883, 0.851, 0.965>
      translate x*0.053
      rotate <0, -0.391, -3.665>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.839, 0.953, 0.803>
      translate x*0.345
      rotate <0, 2.957, 6.349>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.981, 0.971, 0.951>
      translate x*0.685
      rotate <0, -9.046, -15.952>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.922, 0.867, 0.981>
      translate x*0.69
      rotate <0, -12.177, -3.19>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.818, 0.944, 0.977>
      translate x*0.569
      rotate <0, 5.262, 21.455>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.847, 0.987, 0.957>
      translate x*0.824
      rotate <0, 5.079, 20.041>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.829, 0.966, 0.857>
      translate x*0.449
      rotate <0, -2.088, 10.058>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.886, 0.812, 0.868>
      translate x*0.95
      rotate <0, 9.845, -6.68>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.84, 0.964, 0.991>
      translate x*0.239
      rotate <0, 4.987, 2.855>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.87, 0.985, 0.934>
      translate x*0.931
      rotate <0, -27.963, -4.088>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.812, 0.979, 0.921>
      translate x*0.773
      rotate <0, 2.588, -12.279>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.95, 0.909, 0.964>
      translate x*0.844
      rotate <0, 4.406, 8.934>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.913, 0.807, 0.806>
      translate x*0.782
      rotate <0, 0.142, -0.261>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.971, 0.822, 0.855>
      translate x*0.67
      rotate <0, 8.912, 17.387>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.887, 0.949, 0.843>
      translate x*0.238
      rotate <0, -9.094, 3.445>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.808, 0.876, 0.87>
      translate x*0.877
      rotate <0, 33.67, -3.645>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.814, 0.878, 0.989>
      translate x*0.415
      rotate <0, -23.092, -12.053>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.923, 0.888, 0.843>
      translate x*0.872
      rotate <0, 6.677, 5.297>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.938, 0.992, 0.908>
      translate x*0.308
      rotate <0, -8.487, -20.094>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.807, 0.809, 0.986>
      translate x*0.595
      rotate <0, 14.545, 20.441>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.959, 0.937, 0.819>
      translate x*0.263
      rotate <0, 0.873, 9.321>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.87, 0.879, 0.963>
      translate x*0.725
      rotate <0, -3.551, 5.222>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.956, 0.985, 0.829>
      translate x*0.955
      rotate <0, -8.562, -14.883>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.926, 0.815, 0.803>
      translate x*0.265
      rotate <0, -2.483, -7.254>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.859, 0.843, 0.961>
      translate x*0.069
      rotate <0, -7.224, 7.475>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.955, 0.897, 0.996>
      translate x*0.483
      rotate <0, -4.114, 8.242>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.907, 0.882, 0.956>
      translate x*0.326
      rotate <0, 6.913, -6.101>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.976, 0.802, 0.881>
      translate x*0.479
      rotate <0, 15.626, 13.474>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.932, 0.867, 0.939>
      translate x*0.701
      rotate <0, -10.599, 9.971>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.815, 0.954, 0.94>
      translate x*0.845
      rotate <0, -16.239, 1.085>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.801, 0.863, 0.952>
      translate x*0.974
      rotate <0, -14.649, 1.766>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.914, 0.928, 0.813>
      translate x*0.191
      rotate <0, -4.387, -11.167>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.949, 0.906, 0.927>
      translate x*0.97
      rotate <0, 1.635, -15.093>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.844, 0.992, 0.96>
      translate x*0.516
      rotate <0, 14.67, -18.306>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.848, 0.82, 0.818>
      translate x*0.126
      rotate <0, -5.52, 11.21>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.983, 0.811, 0.875>
      translate x*0.674
      rotate <0, -4.786, -12.198>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.829, 0.863, 0.948>
      translate x*0.235
      rotate <0, -14.321, 7.904>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.923, 0.906, 0.872>
      translate x*0.44
      rotate <0, -6.086, -23.811>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.813, 0.873, 0.995>
      translate x*0.51
      rotate <0, -9.372, 10.391>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.956, 0.991, 0.865>
      translate x*0.904
      rotate <0, 10.613, 18.299>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.869, 0.922, 0.988>
      translate x*0.32
      rotate <0, -24.588, 7.503>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.918, 0.874, 0.854>
      translate x*0.211
      rotate <0, 0.525, -2.759>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.852, 0.821, 0.813>
      translate x*0.232
      rotate <0, 6.167, 16.243>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.816, 0.957, 0.827>
      translate x*0.871
      rotate <0, -9.947, 2.755>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.928, 0.802, 0.918>
      translate x*0.225
      rotate <0, 3.917, -11.034>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.85, 0.905, 0.909>
      translate x*0.157
      rotate <0, -5.542, 15.85>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.959, 0.823, 0.811>
      translate x*0.2
      rotate <0, -11.878, -10.027>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.936, 0.833, 0.961>
      translate x*0.315
      rotate <0, 5.597, -10.901>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.845, 0.899, 0.934>
      translate x*0.145
      rotate <0, -5.843, -7.513>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.829, 0.882, 0.953>
      translate x*0.603
      rotate <0, -12.068, 6.535>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.889, 0.826, 0.818>
      translate x*0.603
      rotate <0, 7.921, -27.022>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.89, 0.815, 0.823>
      translate x*0.387
      rotate <0, 7.055, 9.147>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.8, 0.803, 1>
      translate x*0.279
      rotate <0, 2.816, 1.808>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.856, 0.827, 0.844>
      translate x*0.807
      rotate <0, -3.074, -6.081>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.882, 0.803, 0.893>
      translate x*0.94
      rotate <0, 2.31, -12.84>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.978, 0.878, 0.908>
      translate x*0.739
      rotate <0, -1.943, -7.607>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.929, 0.907, 0.81>
      translate x*0.951
      rotate <0, 13.287, 7.234>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.992, 0.865, 0.849>
      translate x*0.073
      rotate <0, 0.844, 4.729>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.883, 0.951, 0.825>
      translate x*0.094
      rotate <0, -6.572, -0.349>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.965, 0.829, 0.92>
      translate x*0.532
      rotate <0, 10.291, -0.786>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.866, 1, 0.96>
      translate x*0.521
      rotate <0, -2.179, -16.932>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.8, 0.803, 0.842>
      translate x*0.541
      rotate <0, 30.319, -2.795>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.945, 0.902, 0.902>
      translate x*0.968
      rotate <0, -3.973, 11.944>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.942, 0.827, 0.834>
      translate x*0.884
      rotate <0, -4.107, 17.473>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.941, 0.931, 0.827>
      translate x*0.61
      rotate <0, 8.829, 7.442>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.953, 0.81, 0.95>
      translate x*0.152
      rotate <0, 11.185, -16.097>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.937, 0.876, 0.834>
      translate x*0.162
      rotate <0, -16.141, -2.57>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.809, 0.864, 0.837>
      translate x*0.225
      rotate <0, -2.012, 6.536>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.911, 0.876, 0.867>
      translate x*0.113
      rotate <0, -0.65, -3.447>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.901, 0.915, 0.922>
      translate x*0.285
      rotate <0, 0.602, -0.085>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.832, 0.872, 0.941>
      translate x*0.203
      rotate <0, -0.788, 11.34>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.864, 0.893, 0.86>
      translate x*0.097
      rotate <0, 11.403, 8.692>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.945, 0.871, 0.822>
      translate x*0.52
      rotate <0, 8.66, 1.317>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.925, 0.807, 0.944>
      translate x*0.576
      rotate <0, -12.665, -23.508>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.901, 0.983, 0.905>
      translate x*0.831
      rotate <0, 9.607, 5.097>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.821, 0.925, 0.999>
      translate x*0.862
      rotate <0, 1.516, 3.973>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.941, 0.939, 0.932>
      translate x*0.033
      rotate <0, -6.952, -1.586>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.838, 0.844, 0.987>
      translate x*0.411
      rotate <0, 0.195, 12.073>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.892, 0.95, 0.978>
      translate x*0.825
      rotate <0, 3.648, -6.932>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.943, 0.982, 0.916>
      translate x*0.85
      rotate <0, 9.277, 0.395>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.893, 0.898, 0.871>
      translate x*0.991
      rotate <0, 9.749, -8.248>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.867, 0.975, 0.995>
      translate x*0.589
      rotate <0, -3.373, -3.281>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.901, 0.849, 0.958>
      translate x*0.896
      rotate <0, 2.03, 7.729>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.99, 0.808, 0.932>
      translate x*0.428
      rotate <0, 6.38, -0.411>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.997, 0.95, 0.887>
      translate x*0.09
      rotate <0, -13.977, 4.329>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.803, 0.865, 0.805>
      translate x*0.672
      rotate <0, -0.533, -6.043>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.842, 0.814, 0.822>
      translate x*0.113
      rotate <0, 19.705, -12.769>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.89, 0.835, 0.908>
      translate x*0.487
      rotate <0, 4.588, -6.15>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.804, 0.958, 0.854>
      translate x*0.902
      rotate <0, -2.598, -3.495>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.91, 0.934, 0.908>
      translate x*0.497
      rotate <0, 1.839, 12.025>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.805, 0.886, 0.923>
      translate x*0.391
      rotate <0, 3.198, 3.375>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.82, 0.915, 0.805>
      translate x*0.869
      rotate <0, 11.218, 6.585>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.911, 0.901, 0.934>
      translate x*0.203
      rotate <0, -0.912, -1.319>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.911, 0.998, 0.941>
      translate x*0.378
      rotate <0, 12.225, -19.473>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.811, 0.907, 0.848>
      translate x*0.529
      rotate <0, 7.085, 1.995>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.815, 0.904, 0.839>
      translate x*0.208
      rotate <0, -1.217, 8.174>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.902, 0.821, 0.96>
      translate x*0.592
      rotate <0, 6.503, 2.38>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.938, 0.827, 0.826>
      translate x*0.471
      rotate <0, -0.318, 16.494>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.852, 0.934, 0.837>
      translate x*0.292
      rotate <0, 9.628, 3.739>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.987, 0.811, 0.921>
      translate x*0.703
      rotate <0, -27.213, -4.77>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.822, 0.943, 0.819>
      translate x*0.919
      rotate <0, -6.994, 5.739>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.949, 0.901, 0.835>
      translate x*0.825
      rotate <0, -8.789, -16.149>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.938, 0.9, 0.868>
      translate x*0.053
      rotate <0, 3.56, 21.268>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.869, 0.995, 0.876>
      translate x*0.316
      rotate <0, 5.678, 17.268>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.904, 0.889, 0.956>
      translate x*0.01
      rotate <0, -15.245, -2.595>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.916, 0.888, 0.895>
      translate x*0.601
      rotate <0, 21.297, 14.289>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.822, 0.998, 0.895>
      translate x*0.478
      rotate <0, 14.032, -7.146>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.965, 0.935, 0.963>
      translate x*0.89
      rotate <0, -3.041, 6.786>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.831, 0.868, 0.88>
      translate x*0.189
      rotate <0, -7.268, 22.837>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.88, 0.917, 0.834>
      translate x*0.973
      rotate <0, -6.412, 9.542>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.925, 0.906, 0.958>
      translate x*0.768
      rotate <0, -16.284, -15.617>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.836, 0.845, 0.967>
      translate x*0.705
      rotate <0, 11.45, 0.741>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.849, 0.95, 0.994>
      translate x*0.112
      rotate <0, -14.078, -2.986>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.971, 0.971, 0.86>
      translate x*0.199
      rotate <0, -5.255, -14.924>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.957, 0.942, 0.848>
      translate x*0.945
      rotate <0, 5.057, -24.231>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.986, 0.858, 0.987>
      translate x*0.946
      rotate <0, -4.289, 9.442>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.814, 0.931, 0.827>
      translate x*0.388
      rotate <0, 13.65, -4.447>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.9, 0.877, 0.974>
      translate x*0.376
      rotate <0, 16.438, -4.821>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.925, 0.85, 0.834>
      translate x*0.696
      rotate <0, 11.694, -0.227>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.877, 0.862, 0.809>
      translate x*0.605
      rotate <0, -11.376, -11.158>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.888, 0.874, 0.977>
      translate x*0.51
      rotate <0, -2.927, 4.227>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.819, 0.817, 0.827>
      translate x*0.357
      rotate <0, -2.499, 11.458>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.837, 0.928, 0.955>
      translate x*0.261
      rotate <0, -14.976, 9.224>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.959, 0.895, 0.963>
      translate x*0.309
      rotate <0, 10.12, 0.242>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.98, 0.835, 0.88>
      translate x*0.586
      rotate <0, 5.824, -9.108>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.842, 0.838, 0.908>
      translate x*0.36
      rotate <0, -5.752, 6.744>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <4, 0.98, 0.971>
      translate x*0.881
      rotate <0, -8.066, 0.653>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.818, 0.806, 0.969>
      translate x*0.568
      rotate <0, 0.073, -6.607>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.82, 0.876, 0.867>
      translate x*0.366
      rotate <0, 11.823, -0.175>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.946, 0.877, 0.968>
      translate x*0.743
      rotate <0, -1.059, 4.402>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.804, 0.808, 0.879>
      translate x*0.281
      rotate <0, -6.322, -1.671>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.938, 0.862, 0.87>
      translate x*0.957
      rotate <0, -0.65, 5.015>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.987, 0.855, 0.859>
      translate x*0.075
      rotate <0, -15.768, -31.539>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.926, 0.989, 0.988>
      translate x*0.453
      rotate <0, 6.411, 9.048>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.912, 0.936, 0.885>
      translate x*0.725
      rotate <0, 13.919, -5.299>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.991, 0.826, 0.951>
      translate x*0.713
      rotate <0, -2.995, 4.712>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.973, 0.911, 0.949>
      translate x*0.544
      rotate <0, 13.577, -13.463>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.934, 0.887, 0.975>
      translate x*0.661
      rotate <0, 16.842, -1.33>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.93, 0.866, 0.942>
      translate x*0.102
      rotate <0, 5.923, 3.248>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.935, 0.985, 0.94>
      translate x*0.272
      rotate <0, 7.649, -11.697>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.995, 0.917, 0.817>
      translate x*0.139
      rotate <0, 21.014, -22.351>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.869, 0.891, 0.898>
      translate x*0.062
      rotate <0, 10.709, -9.84>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.875, 0.967, 0.95>
      translate x*0.575
      rotate <0, 6.911, 19.735>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.832, 0.843, 0.81>
      translate x*0.217
      rotate <0, -17.044, -5.451>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.844, 0.833, 0.842>
      translate x*0.001
      rotate <0, 12.767, -8.789>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.946, 0.985, 0.865>
      translate x*0.354
      rotate <0, -20.133, -1.752>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.942, 0.903, 0.916>
      translate x*0.275
      rotate <0, 3.566, -12.126>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.89, 0.965, 0.849>
      translate x*0.16
      rotate <0, -10.659, -2.705>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.882, 0.827, 0.832>
      translate x*0.075
      rotate <0, -8.291, 12.814>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.933, 0.88, 0.829>
      translate x*0.4
      rotate <0, -21.191, -4.159>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.85, 0.891, 0.976>
      translate x*0.552
      rotate <0, -11.303, 9.394>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.814, 0.888, 0.929>
      translate x*0.052
      rotate <0, 3.784, 9.012>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.881, 0.895, 0.863>
      translate x*0.444
      rotate <0, 6.103, -22.998>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.948, 0.988, 0.938>
      translate x*0.554
      rotate <0, -7.937, 7.775>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.897, 0.887, 0.98>
      translate x*0.267
      rotate <0, 5.061, -5.487>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.986, 0.981, 0.859>
      translate x*0.412
      rotate <0, -0.185, -0.249>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.802, 0.85, 0.936>
      translate x*0.468
      rotate <0, 11.502, -17.549>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.933, 0.807, 0.815>
      translate x*0.671
      rotate <0, 1.759, 1.967>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.995, 0.817, 0.935>
      translate x*0.644
      rotate <0, -3.666, 0.819>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.947, 0.979, 0.926>
      translate x*0.984
      rotate <0, -0.343, -8.502>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.82, 0.805, 0.936>
      translate x*0.217
      rotate <0, 1.805, 1.548>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.892, 0.81, 0.882>
      translate x*0.289
      rotate <0, 15.347, -14.024>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.804, 0.934, 0.816>
      translate x*0.168
      rotate <0, -6.749, 12.559>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.915, 0.853, 0.917>
      translate x*0.324
      rotate <0, 8.519, 3.937>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.894, 0.836, 0.81>
      translate x*0.712
      rotate <0, 13.464, -3.617>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.993, 0.943, 0.812>
      translate x*0.491
      rotate <0, -18.528, -3.033>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.86, 0.809, 0.832>
      translate x*0.035
      rotate <0, -1.114, 0.329>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.811, 0.964, 0.933>
      translate x*0.807
      rotate <0, -0.948, 7.621>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.971, 0.927, 0.855>
      translate x*0.457
      rotate <0, 2.853, 9.148>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.846, 0.837, 0.828>
      translate x*0.937
      rotate <0, 14.005, -2.913>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.993, 0.857, 0.859>
      translate x*0.652
      rotate <0, 5.107, -2.823>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.899, 0.951, 0.891>
      translate x*0.562
      rotate <0, 5.954, -7.45>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.945, 0.901, 0.817>
      translate x*0.783
      rotate <0, -7.207, -1.067>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.844, 0.82, 0.928>
      translate x*0.574
      rotate <0, 0.227, 10.244>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.939, 0.899, 0.931>
      translate x*0.69
      rotate <0, 20.168, -24.895>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.955, 0.9, 0.807>
      translate x*0.836
      rotate <0, 6.74, 20.146>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.85, 0.834, 0.898>
      translate x*0.485
      rotate <0, 20.227, -11.057>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.871, 0.848, 0.955>
      translate x*0.526
      rotate <0, -2.822, 8.289>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.844, 0.853, 0.897>
      translate x*0.186
      rotate <0, -0.526, -10.016>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.848, 0.854, 0.969>
      translate x*0.279
      rotate <0, 8.662, -17.349>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <4, 0.853, 0.987>
      translate x*0.261
      rotate <0, -6.94, -15.894>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.882, 0.832, 0.802>
      translate x*0.654
      rotate <0, -11.847, -9.389>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.964, 0.859, 0.931>
      translate x*0.195
      rotate <0, -8.51, -5.132>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.835, 0.992, 0.9>
      translate x*0.653
      rotate <0, -6.216, 5.914>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.969, 0.815, 0.986>
      translate x*0.457
      rotate <0, -3.853, -4.901>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.849, 0.887, 0.848>
      translate x*0.293
      rotate <0, 7.359, 5.133>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.855, 0.943, 0.817>
      translate x*0.493
      rotate <0, -17.187, 17.723>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.885, 0.961, 0.998>
      translate x*0.478
      rotate <0, -1.778, -4.406>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.92, 0.973, 0.961>
      translate x*0.604
      rotate <0, 2.445, 12.771>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.973, 0.978, 0.939>
      translate x*0.668
      rotate <0, 8.728, -9.281>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.956, 0.908, 0.885>
      translate x*0.836
      rotate <0, -5.603, 7.555>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.907, 0.871, 0.978>
      translate x*0.09
      rotate <0, -22.472, -5.228>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.969, 0.924, 0.996>
      translate x*0.263
      rotate <0, -14.684, 16.981>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.866, 0.885, 0.801>
      translate x*0.483
      rotate <0, 6.883, -7.023>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.866, 0.964, 0.911>
      translate x*0.26
      rotate <0, 8.938, 8.949>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.808, 0.848, 0.981>
      translate x*0.633
      rotate <0, 22.24, -3.044>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.897, 0.94, 0.868>
      translate x*0.668
      rotate <0, 11.987, -4.164>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.804, 0.964, 0.988>
      translate x*0.185
      rotate <0, -13.733, -14.516>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.818, 0.986, 0.883>
      translate x*0.94
      rotate <0, 5.411, -6.993>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.865, 0.838, 0.889>
      translate x*0.477
      rotate <0, -0.413, -5.493>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.904, 0.985, 0.823>
      translate x*0.669
      rotate <0, -5.833, -0.663>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.939, 0.832, 0.874>
      translate x*0.406
      rotate <0, 10.419, 4.405>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.835, 0.912, 0.92>
      translate x*0.096
      rotate <0, 4.766, -7.296>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.91, 0.981, 0.914>
      translate x*0.554
      rotate <0, 1.343, -13.536>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.907, 0.912, 0.971>
      translate x*0.48
      rotate <0, -4.181, -0.568>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.99, 0.846, 0.973>
      translate x*0.081
      rotate <0, -8.585, 20.522>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.89, 0.967, 0.867>
      translate x*0.452
      rotate <0, 6.777, -9.36>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.84, 0.838, 0.98>
      translate x*0.13
      rotate <0, -10.154, -6.228>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.878, 0.947, 0.992>
      translate x*0.72
      rotate <0, -5.905, -11.525>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.894, 0.9, 0.901>
      translate x*0.739
      rotate <0, -16.538, -7.331>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.956, 0.828, 0.834>
      translate x*0.745
      rotate <0, -1.948, 3.2>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.941, 0.974, 0.988>
      translate x*0.499
      rotate <0, -13.831, -2.073>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.928, 0.954, 0.849>
      translate x*0.264
      rotate <0, 17.415, 4.091>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.927, 0.829, 0.873>
      translate x*0.471
      rotate <0, -7.358, -5.427>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.842, 0.821, 0.813>
      translate x*0.78
      rotate <0, 19.198, 1.129>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.932, 0.803, 0.868>
      translate x*0.095
      rotate <0, -3.554, 7.016>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.831, 0.985, 0.819>
      translate x*0.385
      rotate <0, -11.288, 8.446>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.996, 0.915, 0.839>
      translate x*0.079
      rotate <0, -1.174, -4.893>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.934, 0.845, 0.843>
      translate x*0.544
      rotate <0, -20.863, 14.498>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.828, 0.995, 0.924>
      translate x*0.544
      rotate <0, 0.361, -2.832>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.895, 0.814, 0.933>
      translate x*0.707
      rotate <0, -6.17, 5.926>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.994, 0.813, 0.954>
      translate x*0.888
      rotate <0, -2.27, 11.935>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.92, 0.937, 0.851>
      translate x*0.869
      rotate <0, -3.414, 2.09>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.912, 0.932, 0.955>
      translate x*0.133
      rotate <0, -10.22, -6.587>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.873, 0.954, 0.926>
      translate x*0.453
      rotate <0, -20.922, -8.78>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.929, 0.976, 0.882>
      translate x*0.749
      rotate <0, 3.136, 2.582>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.809, 0.971, 0.838>
      translate x*0.136
      rotate <0, -3.314, -10.816>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.94, 0.933, 0.871>
      translate x*0.201
      rotate <0, 9.557, -10.053>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.816, 0.855, 0.998>
      translate x*0.489
      rotate <0, -18.059, 15.81>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.912, 0.892, 0.848>
      translate x*0.708
      rotate <0, 9.269, -3.109>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.949, 0.983, 0.942>
      translate x*0.545
      rotate <0, 2.796, 5.752>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.853, 0.928, 0.895>
      translate x*0.969
      rotate <0, -3.519, -2.204>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.97, 0.991, 0.897>
      translate x*0.683
      rotate <0, -5.051, -11.133>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.923, 0.831, 0.91>
      translate x*0.851
      rotate <0, -14.678, 2.905>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.929, 0.838, 0.854>
      translate x*0.425
      rotate <0, -16.567, 5.055>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.907, 0.901, 0.847>
      translate x*0.28
      rotate <0, 28.387, -20.102>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.823, 0.928, 0.996>
      translate x*0.048
      rotate <0, 2.694, -7.445>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.841, 0.999, 0.986>
      translate x*0.833
      rotate <0, -13.851, -1.86>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.88, 0.925, 0.9>
      translate x*0.097
      rotate <0, -13.625, 2.647>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.93, 0.981, 0.819>
      translate x*0.779
      rotate <0, -0.58, 9.581>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.98, 0.873, 0.897>
      translate x*0.2
      rotate <0, 12.018, 7.737>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.837, 0.999, 0.899>
      translate x*0.569
      rotate <0, -4.894, -5.729>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.87, 0.987, 0.878>
      translate x*0.791
      rotate <0, 7.92, 3.792>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.984, 0.899, 0.934>
      translate x*0.007
      rotate <0, -18.542, -7.545>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.994, 0.809, 0.841>
      translate x*0.608
      rotate <0, 15.341, -1.906>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.843, 0.904, 0.976>
      translate x*0.616
      rotate <0, 3.051, -4.774>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.884, 0.99, 0.968>
      translate x*0.109
      rotate <0, 5.298, 7.279>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.958, 0.902, 0.895>
      translate x*0.93
      rotate <0, -12.309, 7.701>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.835, 0.914, 0.828>
      translate x*0.146
      rotate <0, 7.157, 4.641>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.984, 0.838, 0.873>
      translate x*0.72
      rotate <0, -0.501, 4.682>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.91, 0.912, 0.992>
      translate x*0.545
      rotate <0, -7.758, -10.353>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.969, 0.823, 0.818>
      translate x*0.389
      rotate <0, 14.353, -15.22>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.902, 0.966, 0.952>
      translate x*0.449
      rotate <0, 5.683, -13.341>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.879, 0.961, 0.937>
      translate x*0.043
      rotate <0, -4.061, -1.031>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.802, 0.984, 0.943>
      translate x*0.549
      rotate <0, 1.715, 1.813>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.885, 0.811, 0.852>
      translate x*0.976
      rotate <0, 12.612, -0.467>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.88, 0.824, 0.845>
      translate x*0.57
      rotate <0, -4.34, 9.028>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.911, 0.971, 0.813>
      translate x*0.565
      rotate <0, -2.706, -2.619>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.853, 0.848, 0.874>
      translate x*0.645
      rotate <0, 11.791, 18.115>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.867, 0.822, 0.886>
      translate x*0.834
      rotate <0, 6.618, 13.697>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.936, 0.898, 0.936>
      translate x*0.43
      rotate <0, -3.684, 19.963>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.964, 0.805, 0.975>
      translate x*0.161
      rotate <0, 17.553, 1.893>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.945, 0.959, 0.848>
      translate x*0.101
      rotate <0, 2.693, -6.252>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.829, 0.966, 0.845>
      translate x*0.893
      rotate <0, -2.292, 17.828>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.96, 0.907, 0.816>
      translate x*0.582
      rotate <0, 2.484, -0.835>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.929, 0.856, 0.91>
      translate x*0.856
      rotate <0, -4.449, -1.719>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.803, 0.915, 0.85>
      translate x*0.649
      rotate <0, -11.009, -1.38>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.912, 0.812, 0.867>
      translate x*0.014
      rotate <0, 2.759, 13.62>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.952, 0.807, 0.823>
      translate x*0.762
      rotate <0, 2.87, 8.374>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.875, 0.998, 0.819>
      translate x*0.754
      rotate <0, -5.097, -5.344>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.839, 0.825, 0.959>
      translate x*0.754
      rotate <0, 2.953, -16.399>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.878, 0.954, 0.874>
      translate x*0.576
      rotate <0, -13.291, 15.643>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.849, 0.819, 0.932>
      translate x*0.75
      rotate <0, 3.491, -23.678>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.993, 0.912, 0.974>
      translate x*0.143
      rotate <0, 4.099, -10.606>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.884, 0.807, 0.888>
      translate x*0.933
      rotate <0, -6.952, -4.81>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.928, 0.932, 0.825>
      translate x*0.979
      rotate <0, 13.228, 0.479>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.89, 0.826, 0.859>
      translate x*0.028
      rotate <0, -3.749, -13.898>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.803, 0.829, 0.996>
      translate x*0.275
      rotate <0, 20.755, -11.519>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.922, 0.92, 0.978>
      translate x*0.631
      rotate <0, -2.382, -1.417>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.824, 0.82, 0.954>
      translate x*0.576
      rotate <0, 1.542, 7.267>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.839, 0.868, 0.875>
      translate x*0.742
      rotate <0, 16.691, 8.941>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.93, 0.983, 0.985>
      translate x*0.325
      rotate <0, 0.019, -23.74>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.911, 0.832, 0.955>
      translate x*0.141
      rotate <0, -6.312, -6.858>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.848, 0.957, 0.902>
      translate x*0.529
      rotate <0, 13.422, 5.656>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.931, 0.803, 0.836>
      translate x*0.459
      rotate <0, 26.884, 8.374>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.953, 0.859, 0.968>
      translate x*0.023
      rotate <0, 15.132, 19.584>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.997, 0.921, 0.956>
      translate x*0.079
      rotate <0, 8.952, -11.718>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.858, 0.955, 0.829>
      translate x*0.094
      rotate <0, 2.321, -12.844>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.878, 0.87, 0.922>
      translate x*0.231
      rotate <0, -16.514, 6.828>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.816, 0.969, 0.803>
      translate x*0.459
      rotate <0, -17.855, 13.379>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.822, 0.906, 0.909>
      translate x*0.906
      rotate <0, 4.9, 7.755>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.982, 0.853, 0.814>
      translate x*0.828
      rotate <0, -3.328, 3.91>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.808, 0.822, 0.985>
      translate x*0.455
      rotate <0, 18.954, -5.385>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.907, 0.817, 0.806>
      translate x*0.571
      rotate <0, 4.797, -20.393>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.825, 0.915, 0.973>
      translate x*0.003
      rotate <0, -0.894, -9.659>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.811, 0.931, 0.844>
      translate x*0.222
      rotate <0, -2.661, -13.144>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.851, 0.95, 0.814>
      translate x*0.037
      rotate <0, -8.092, -6.677>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.909, 0.991, 0.822>
      translate x*0.806
      rotate <0, -4.453, 7.64>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.838, 0.889, 0.952>
      translate x*0.8
      rotate <0, -5.323, 6.954>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.83, 0.889, 0.889>
      translate x*0.265
      rotate <0, -2.768, 3.309>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.867, 0.888, 0.808>
      translate x*0.355
      rotate <0, -9.347, -2.374>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.919, 0.849, 0.827>
      translate x*0.449
      rotate <0, 12.754, 4.041>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.872, 0.813, 0.955>
      translate x*0.448
      rotate <0, 4.853, -9.861>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.947, 0.88, 0.962>
      translate x*0.43
      rotate <0, -8.937, -6.062>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.817, 0.898, 0.963>
      translate x*0.526
      rotate <0, -10.137, 11.486>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.926, 0.92, 0.974>
      translate x*0.141
      rotate <0, 6.03, -4.253>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.997, 0.882, 0.83>
      translate x*0.55
      rotate <0, 4.762, -4.009>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.854, 0.899, 0.867>
      translate x*0.58
      rotate <0, -0.723, -14.841>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.877, 0.949, 0.868>
      translate x*0.465
      rotate <0, 4.414, -1.231>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.974, 0.915, 0.969>
      translate x*0.065
      rotate <0, 13.733, 2.663>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.814, 0.911, 0.853>
      translate x*0.438
      rotate <0, 2.338, 2.468>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.901, 0.837, 0.933>
      translate x*0.313
      rotate <0, -1.876, 20.925>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.994, 0.867, 0.816>
      translate x*0.258
      rotate <0, 8.377, -11.729>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.872, 0.842, 0.888>
      translate x*0.306
      rotate <0, 20.626, -4.345>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.822, 0.862, 0.981>
      translate x*0.499
      rotate <0, 12.386, 24.12>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.987, 0.888, 0.836>
      translate x*0.221
      rotate <0, -4.106, 5.933>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.989, 0.88, 0.924>
      translate x*0.324
      rotate <0, 3.162, -2.861>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.993, 0.934, 0.926>
      translate x*0.893
      rotate <0, 3.687, 11.961>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.976, 0.816, 0.967>
      translate x*0.058
      rotate <0, -6.185, 15.215>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.974, 0.817, 0.807>
      translate x*0.58
      rotate <0, -8.692, 0.223>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.895, 0.834, 0.968>
      translate x*0.885
      rotate <0, -5.17, 12.711>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.82, 0.883, 0.992>
      translate x*0.01
      rotate <0, -1.92, -4.005>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.941, 0.875, 0.835>
      translate x*0.309
      rotate <0, -9.987, 5.281>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.908, 0.991, 0.929>
      translate x*0.966
      rotate <0, 6.068, 5.201>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.849, 0.808, 0.822>
      translate x*0.232
      rotate <0, -11.452, 8.751>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.982, 0.884, 0.827>
      translate x*0.893
      rotate <0, 15.279, -10.433>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.935, 0.901, 0.819>
      translate x*0.791
      rotate <0, 4.391, -0.958>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.974, 0.855, 0.812>
      translate x*0.294
      rotate <0, -12.448, 9.05>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.814, 0.998, 0.82>
      translate x*0.297
      rotate <0, 0.207, -3.904>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.839, 0.984, 0.972>
      translate x*0.887
      rotate <0, 5.349, 23.504>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.867, 0.979, 0.863>
      translate x*0.927
      rotate <0, -4.922, 12.776>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.852, 0.986, 0.968>
      translate x*0.786
      rotate <0, 1.683, -8.439>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.857, 0.992, 0.924>
      translate x*0.019
      rotate <0, 13.198, -0.287>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.943, 0.847, 0.865>
      translate x*0.195
      rotate <0, 7.382, -25.318>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.867, 0.927, 0.979>
      translate x*0.101
      rotate <0, -11.23, 7.063>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.806, 0.987, 0.963>
      translate x*0.364
      rotate <0, -16.066, 20.365>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.859, 0.932, 0.997>
      translate x*0.019
      rotate <0, 24.335, -1.849>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.873, 0.819, 0.976>
      translate x*0.795
      rotate <0, -3.908, 24.458>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.914, 0.93, 0.976>
      translate x*0.795
      rotate <0, 1.737, -8.047>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.98, 0.952, 0.856>
      translate x*0.964
      rotate <0, 8.508, -5.432>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.976, 0.849, 0.903>
      translate x*0.069
      rotate <0, -1.05, 5.411>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.922, 0.808, 0.881>
      translate x*0.028
      rotate <0, 0.564, 2.512>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.846, 0.81, 0.839>
      translate x*0.27
      rotate <0, -4.01, -7.472>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.817, 0.986, 0.833>
      translate x*0.286
      rotate <0, 7.662, 7.8>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.939, 0.892, 0.904>
      translate x*0.862
      rotate <0, 11.126, -16.784>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.972, 0.868, 0.97>
      translate x*0.375
      rotate <0, -8.839, -19.902>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.875, 0.829, 0.877>
      translate x*0.305
      rotate <0, -9.4, -5.119>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.895, 0.879, 0.918>
      translate x*0.459
      rotate <0, -14.807, -13.338>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.896, 0.935, 0.876>
      translate x*0.59
      rotate <0, -6.9, 3.688>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.817, 0.998, 0.893>
      translate x*0.896
      rotate <0, 2.583, -11.307>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.887, 0.93, 0.934>
      translate x*0.48
      rotate <0, -7.828, -19.503>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.882, 0.847, 0.874>
      translate x*0.137
      rotate <0, 16.075, 8.587>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.9, 0.867, 0.839>
      translate x*0.815
      rotate <0, 5.818, -9.57>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.87, 0.84, 0.843>
      translate x*0.852
      rotate <0, 1.092, -7.939>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.841, 0.907, 0.956>
      translate x*0.515
      rotate <0, -3.519, 13.035>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.907, 0.825, 0.997>
      translate x*0.523
      rotate <0, -15.742, -8.9>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.939, 0.871, 0.891>
      translate x*0.142
      rotate <0, 10.643, 10.019>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.929, 0.997, 0.975>
      translate x*0.006
      rotate <0, -0.12, 15.72>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.951, 0.806, 0.823>
      translate x*0.153
      rotate <0, 1.256, -6.475>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.851, 0.821, 0.883>
      translate x*0.811
      rotate <0, 6.623, 24.49>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.808, 0.981, 0.86>
      translate x*0.198
      rotate <0, 6.222, 9.903>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.913, 0.846, 0.863>
      translate x*0.088
      rotate <0, 2.602, 25.811>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.976, 0.869, 0.944>
      translate x*0.104
      rotate <0, 6.133, 7.968>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.852, 0.829, 0.897>
      translate x*0.566
      rotate <0, -4.912, -8.115>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.925, 0.824, 0.965>
      translate x*0.403
      rotate <0, -9.487, -13.302>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.869, 0.975, 0.891>
      translate x*0.95
      rotate <0, -20.932, 13.381>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.887, 0.903, 0.909>
      translate x*0.53
      rotate <0, -12.252, 7.339>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.937, 1, 0.818>
      translate x*0.515
      rotate <0, 12.872, 12.733>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.988, 0.848, 0.991>
      translate x*0.055
      rotate <0, 11.959, 8.902>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.94, 0.917, 0.883>
      translate x*0.887
      rotate <0, -6.922, -3.934>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.839, 0.985, 0.909>
      translate x*0.586
      rotate <0, 5.999, 20>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.859, 0.969, 0.976>
      translate x*0.275
      rotate <0, 8.922, -6.306>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.978, 0.932, 0.87>
      translate x*0.197
      rotate <0, -14.172, -1.99>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.81, 0.895, 0.872>
      translate x*0.634
      rotate <0, 2.429, 21.184>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.931, 0.803, 0.812>
      translate x*0.51
      rotate <0, -2.542, 8.519>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.862, 0.849, 0.971>
      translate x*0.505
      rotate <0, 10.486, -21.07>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.804, 0.878, 0.985>
      translate x*0.804
      rotate <0, -4.297, -11.97>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.91, 0.88, 0.898>
      translate x*0.547
      rotate <0, 3.068, -21.77>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.859, 0.928, 0.807>
      translate x*0.766
      rotate <0, 11.944, -5.109>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.862, 0.972, 0.886>
      translate x*0.979
      rotate <0, 5.849, 15.811>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.889, 0.887, 0.87>
      translate x*0.76
      rotate <0, 0.132, 11.417>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.894, 0.854, 0.951>
      translate x*0.451
      rotate <0, 1.403, 12.786>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.959, 0.921, 0.9>
      translate x*0.734
      rotate <0, -7.754, 10.174>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.942, 0.896, 0.88>
      translate x*0.085
      rotate <0, -26.777, -7.984>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.801, 0.923, 0.839>
      translate x*0.135
      rotate <0, 12.427, -16.599>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.884, 0.98, 0.947>
      translate x*0.668
      rotate <0, -5.225, 5.824>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.953, 0.97, 0.982>
      translate x*0.454
      rotate <0, -14.994, -11.478>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.871, 0.972, 0.871>
      translate x*0.262
      rotate <0, 7.797, 8.053>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.826, 0.856, 0.809>
      translate x*0.27
      rotate <0, 9.634, 4.734>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.982, 0.985, 0.84>
      translate x*0.718
      rotate <0, 8.08, -9.574>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.876, 0.967, 0.954>
      translate x*0.92
      rotate <0, 2.76, -10.371>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.935, 0.961, 0.804>
      translate x*0.841
      rotate <0, 6.931, 1.174>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.984, 0.889, 0.853>
      translate x*0.156
      rotate <0, -9.358, -9.173>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.951, 0.85, 0.973>
      translate x*0.2
      rotate <0, -5.45, 17.909>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.904, 0.916, 0.813>
      translate x*0.422
      rotate <0, -6.867, 29.577>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.99, 0.822, 0.808>
      translate x*0.834
      rotate <0, -6.474, 12.703>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.991, 0.968, 0.947>
      translate x*0.615
      rotate <0, -8.543, -4.69>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.961, 0.903, 0.962>
      translate x*0.346
      rotate <0, 8.692, -10.65>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.971, 0.967, 0.801>
      translate x*0.446
      rotate <0, 23.185, -11.904>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.829, 0.945, 0.937>
      translate x*0.134
      rotate <0, -2.467, 6.768>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.858, 0.882, 0.843>
      translate x*0.788
      rotate <0, -14.364, 15.99>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.908, 0.833, 0.824>
      translate x*0.751
      rotate <0, 3.382, 4.524>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.882, 0.8, 0.916>
      translate x*0.615
      rotate <0, 6.926, -11.779>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.976, 0.953, 1>
      translate x*0.646
      rotate <0, 23.624, -3.562>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.837, 0.936, 0.945>
      translate x*0.414
      rotate <0, 5.87, 3.209>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.996, 0.899, 0.831>
      translate x*0.777
      rotate <0, 7.11, 4.244>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.813, 0.824, 0.884>
      translate x*0.189
      rotate <0, 7.976, 12.361>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.984, 0.959, 0.975>
      translate x*0.844
      rotate <0, -2.977, 21.27>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.811, 0.917, 0.902>
      translate x*0.419
      rotate <0, 6.725, 10.626>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.891, 0.857, 0.813>
      translate x*0.138
      rotate <0, 9.392, -9.89>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.914, 0.925, 0.893>
      translate x*0.61
      rotate <0, -22.616, 2.778>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.964, 0.982, 0.917>
      translate x*0.253
      rotate <0, -0.51, 0.258>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.822, 0.837, 0.807>
      translate x*0.295
      rotate <0, 8.541, 8.386>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.939, 0.891, 0.985>
      translate x*0.156
      rotate <0, -1.672, -6.337>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.896, 0.837, 0.988>
      translate x*0.605
      rotate <0, -17.392, -9.54>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.824, 0.816, 0.839>
      translate x*0.358
      rotate <0, 3.46, -11.809>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.849, 0.966, 0.914>
      translate x*0.795
      rotate <0, 6.487, 18.708>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.953, 0.854, 0.822>
      translate x*0.193
      rotate <0, 30.324, 22.944>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.913, 0.853, 0.829>
      translate x*0.329
      rotate <0, 3.643, 0.414>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.93, 0.872, 0.895>
      translate x*0.435
      rotate <0, -7.662, -4.583>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.921, 0.842, 0.961>
      translate x*0.412
      rotate <0, 4.771, -2.129>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.874, 0.918, 0.863>
      translate x*0.763
      rotate <0, 19.962, -13.539>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.841, 0.965, 0.912>
      translate x*0.069
      rotate <0, 16.314, 21.357>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.881, 0.859, 0.938>
      translate x*0.814
      rotate <0, -13.044, 7.011>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.883, 0.968, 0.813>
      translate x*0.171
      rotate <0, -3.992, 16.616>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.991, 0.933, 0.957>
      translate x*0.815
      rotate <0, -5.963, 2.563>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.845, 0.944, 0.945>
      translate x*0.995
      rotate <0, -21.282, -8.185>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.906, 0.843, 0.973>
      translate x*0.059
      rotate <0, -9.821, 9.353>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.891, 0.892, 0.902>
      translate x*0.219
      rotate <0, 5.741, 6.944>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.832, 0.99, 0.839>
      translate x*0.693
      rotate <0, 5.74, 2.219>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.941, 0.844, 0.897>
      translate x*0.457
      rotate <0, 8.828, -5.371>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.98, 0.95, 0.99>
      translate x*0.588
      rotate <0, 5.671, 0.108>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.965, 0.974, 0.998>
      translate x*0.709
      rotate <0, 22.123, -24.674>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.828, 0.902, 0.953>
      translate x*0.275
      rotate <0, 21, -30.8>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.853, 0.85, 0.995>
      translate x*0.344
      rotate <0, -2.751, 11.866>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.951, 0.833, 0.89>
      translate x*0.199
      rotate <0, -1.181, 5.616>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.873, 0.928, 0.973>
      translate x*0.495
      rotate <0, 2.752, 10.319>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.836, 0.883, 0.8>
      translate x*0.781
      rotate <0, 4.991, 1.676>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.86, 0.952, 0.997>
      translate x*0.981
      rotate <0, 11.13, 8.141>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.99, 0.8, 0.99>
      translate x*0.04
      rotate <0, 15.805, -14.314>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.869, 0.858, 0.892>
      translate x*0.122
      rotate <0, 6.66, 0.586>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.84, 0.943, 0.933>
      translate x*0.766
      rotate <0, -7.22, 3.209>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.935, 0.955, 0.815>
      translate x*0.086
      rotate <0, 13.238, -5.666>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.862, 0.9, 0.826>
      translate x*0.497
      rotate <0, -19.151, -2.202>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.961, 0.869, 0.905>
      translate x*0.615
      rotate <0, -28.534, 23.322>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.911, 0.887, 0.88>
      translate x*0.782
      rotate <0, 12.144, -0.841>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.882, 0.925, 0.806>
      translate x*0.273
      rotate <0, -11.817, -0.272>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.906, 0.86, 0.929>
      translate x*0.503
      rotate <0, -24.41, -3.291>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.832, 0.966, 0.856>
      translate x*0.574
      rotate <0, -0.322, -12.906>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.938, 0.828, 0.91>
      translate x*0.215
      rotate <0, 2.536, -1.504>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.959, 0.965, 0.825>
      translate x*0.611
      rotate <0, 7.797, 12.542>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.845, 0.992, 0.898>
      translate x*0.785
      rotate <0, -19.361, -10.534>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.904, 0.938, 0.903>
      translate x*0.069
      rotate <0, 2.153, -6.929>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.834, 0.901, 0.936>
      translate x*0.803
      rotate <0, -5.787, 13.014>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.904, 0.824, 0.932>
      translate x*0.725
      rotate <0, 7.678, 8.875>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.898, 0.949, 0.858>
      translate x*0.524
      rotate <0, 3.279, -6.174>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.836, 0.92, 0.85>
      translate x*0.828
      rotate <0, 6.715, -13.319>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.894, 0.895, 0.846>
      translate x*0.327
      rotate <0, 7.513, -6.048>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.842, 0.848, 0.875>
      translate x*0.956
      rotate <0, 6.884, -1.945>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.93, 0.848, 1>
      translate x*0.949
      rotate <0, 3.327, 4.085>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.974, 0.945, 0.887>
      translate x*0.239
      rotate <0, -8.071, 7.654>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.841, 0.884, 0.983>
      translate x*0.977
      rotate <0, -3.705, -1.97>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.992, 0.95, 0.82>
      translate x*0.067
      rotate <0, 14.779, -11.606>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.899, 0.843, 0.912>
      translate x*0.355
      rotate <0, -22.856, 36.306>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.842, 0.973, 0.846>
      translate x*0.641
      rotate <0, 14.026, -5.511>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.822, 0.972, 0.852>
      translate x*0.895
      rotate <0, 3.531, -5.124>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.869, 0.927, 0.849>
      translate x*0.006
      rotate <0, -2.951, -18.647>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.938, 0.863, 0.996>
      translate x*0.044
      rotate <0, -16.186, -11.044>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.972, 0.911, 0.87>
      translate x*0.422
      rotate <0, -9.003, 19.312>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.881, 0.848, 0.972>
      translate x*0.394
      rotate <0, 1.058, 11.875>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.871, 0.807, 0.926>
      translate x*0.208
      rotate <0, -3.141, -5.894>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.946, 0.806, 0.873>
      translate x*0.696
      rotate <0, 17.465, -9.04>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.981, 0.909, 0.987>
      translate x*0.414
      rotate <0, 19.826, 17.151>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.804, 0.844, 0.953>
      translate x*0.352
      rotate <0, -10.52, 4.411>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.968, 0.921, 0.81>
      translate x*0.961
      rotate <0, 3.176, 2.517>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.998, 0.894, 0.868>
      translate x*0.661
      rotate <0, 1.757, 1.139>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.989, 0.847, 0.903>
      translate x*0.097
      rotate <0, 14.894, 17.613>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.818, 0.808, 0.922>
      translate x*0.281
      rotate <0, -13.765, -32.476>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.977, 0.823, 0.844>
      translate x*0.315
      rotate <0, -1.753, 8.521>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.875, 0.881, 0.892>
      translate x*0.682
      rotate <0, 2.521, 3.079>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.882, 0.9, 0.903>
      translate x*0.088
      rotate <0, -12.468, 2.969>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.874, 0.88, 0.982>
      translate x*0.573
      rotate <0, 9.81, 0.97>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.933, 0.932, 0.9>
      translate x*0.043
      rotate <0, 4.226, -8.093>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.812, 0.824, 0.803>
      translate x*0.542
      rotate <0, -13.443, -8.615>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.916, 0.886, 0.961>
      translate x*0.452
      rotate <0, -5.269, 4.64>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.986, 0.879, 0.802>
      translate x*0.425
      rotate <0, -11.883, -8.313>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.853, 0.814, 0.981>
      translate x*0.155
      rotate <0, -3.032, 10.515>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.959, 0.915, 0.955>
      translate x*0.132
      rotate <0, 14.584, 1.358>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.964, 0.907, 0.97>
      translate x*0.292
      rotate <0, 21.008, 6.098>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.945, 1, 0.848>
      translate x*0.932
      rotate <0, -12.975, 5.668>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.994, 0.991, 0.993>
      translate x*0.458
      rotate <0, 22.974, -19.164>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.871, 0.865, 0.839>
      translate x*0.451
      rotate <0, -7.646, -9.934>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.907, 0.957, 0.974>
      translate x*0.157
      rotate <0, 9.432, -23.836>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.895, 0.919, 0.956>
      translate x*0.862
      rotate <0, -8.956, -14.761>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.9, 0.995, 0.975>
      translate x*0.674
      rotate <0, -8.512, 27.014>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.902, 0.951, 0.902>
      translate x*0.031
      rotate <0, 11.911, -11.172>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.867, 0.834, 0.922>
      translate x*0.74
      rotate <0, -6.197, -3.28>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.885, 0.802, 0.93>
      translate x*0.604
      rotate <0, 4.174, 11.748>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.946, 0.944, 0.89>
      translate x*0.602
      rotate <0, 5.759, -5.74>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.827, 0.823, 0.86>
      translate x*0.283
      rotate <0, -0.98, -12.896>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.985, 0.815, 0.821>
      translate x*0.383
      rotate <0, 19.983, 4.824>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.881, 0.931, 0.89>
      translate x*0.794
      rotate <0, -21.103, -18.348>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.871, 0.955, 0.878>
      translate x*0.835
      rotate <0, -14.549, 10.67>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.979, 0.962, 0.994>
      translate x*0.277
      rotate <0, -1.263, -8.213>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.838, 0.832, 0.815>
      translate x*0.878
      rotate <0, 0.394, 13.229>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.951, 0.831, 0.843>
      translate x*0.116
      rotate <0, 5.342, -7.983>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.812, 0.897, 0.872>
      translate x*0.525
      rotate <0, 8.219, -2.552>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.802, 0.907, 0.936>
      translate x*0.437
      rotate <0, -4.851, 9.903>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.806, 0.819, 0.863>
      translate x*0.076
      rotate <0, -6.335, 5.312>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.915, 0.809, 0.801>
      translate x*0.777
      rotate <0, 16.59, -16.578>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.92, 0.965, 0.875>
      translate x*0.701
      rotate <0, -9.573, -12.46>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.928, 0.932, 0.834>
      translate x*0.672
      rotate <0, 9.264, 2.725>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.87, 0.95, 0.938>
      translate x*0.784
      rotate <0, -14.567, -3.592>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.966, 0.802, 0.934>
      translate x*0.158
      rotate <0, -5.854, 8.268>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.877, 0.803, 0.996>
      translate x*0.638
      rotate <0, 15.038, -7.332>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.862, 0.886, 0.817>
      translate x*0.427
      rotate <0, -4.948, 15.276>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.967, 0.86, 0.83>
      translate x*0.48
      rotate <0, -1.693, 9.547>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.954, 0.833, 0.855>
      translate x*0.144
      rotate <0, 1.564, -15.501>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.802, 0.846, 0.957>
      translate x*0.774
      rotate <0, 10.649, 6.772>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.994, 0.892, 0.832>
      translate x*0.161
      rotate <0, 1.656, 1.258>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.981, 0.943, 0.872>
      translate x*0.313
      rotate <0, -9.017, 1.606>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.846, 0.973, 0.947>
      translate x*0.627
      rotate <0, -13.775, -9.283>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.853, 0.807, 0.948>
      translate x*0.677
      rotate <0, 5.686, 1.863>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.826, 0.8, 0.978>
      translate x*0.751
      rotate <0, -10.255, 15.373>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.87, 0.842, 0.86>
      translate x*0.911
      rotate <0, -9.481, 15.857>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.845, 0.918, 0.821>
      translate x*0.687
      rotate <0, -2.723, -1.281>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.818, 0.987, 0.953>
      translate x*0.572
      rotate <0, -14.241, -11.724>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.915, 0.906, 0.823>
      translate x*0.323
      rotate <0, -1.968, 5.057>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.854, 0.819, 0.906>
      translate x*0.494
      rotate <0, -10.238, 8.925>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.883, 0.865, 0.821>
      translate x*0.941
      rotate <0, -8.271, -8.573>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.804, 0.932, 0.838>
      translate x*0.907
      rotate <0, 2.163, 7.332>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.839, 0.82, 0.809>
      translate x*0.006
      rotate <0, -12.055, 5.617>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.927, 0.906, 0.884>
      translate x*0.776
      rotate <0, 5.938, 0.158>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.981, 0.809, 0.85>
      translate x*0.583
      rotate <0, -3.302, -13.769>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.914, 0.908, 0.896>
      translate x*0.475
      rotate <0, 3.549, -3.591>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.872, 0.804, 0.84>
      translate x*0.115
      rotate <0, -9.544, -5.223>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.824, 0.947, 0.999>
      translate x*0.18
      rotate <0, -11.612, -8.607>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.972, 0.935, 0.85>
      translate x*0.583
      rotate <0, 15.817, 11.74>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.82, 0.925, 0.955>
      translate x*0.588
      rotate <0, 2.738, -5.588>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.886, 0.857, 0.961>
      translate x*0.257
      rotate <0, 3.061, -5.373>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.924, 0.812, 0.964>
      translate x*0.846
      rotate <0, -16.529, -6.863>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.903, 0.831, 0.805>
      translate x*0.575
      rotate <0, 3.797, 1.929>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.93, 0.979, 0.952>
      translate x*0.799
      rotate <0, 2.702, -8.344>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.97, 0.868, 0.825>
      translate x*0.863
      rotate <0, -15.072, -11.015>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.806, 0.908, 0.888>
      translate x*0.943
      rotate <0, -31.383, -10.853>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.99, 1, 0.988>
      translate x*0.912
      rotate <0, 5.146, -20.292>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.84, 0.843, 0.861>
      translate x*0.68
      rotate <0, 5.694, 0.153>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.859, 0.922, 0.839>
      translate x*0.648
      rotate <0, -1.814, 16.153>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.931, 0.864, 0.978>
      translate x*0.78
      rotate <0, -20.464, 7.425>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.856, 0.985, 0.943>
      translate x*0.4
      rotate <0, 1.041, -10.12>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.994, 0.88, 0.893>
      translate x*0.14
      rotate <0, -2.464, -15.696>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.891, 0.866, 0.904>
      translate x*0.498
      rotate <0, 3.381, 5.093>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.987, 0.902, 0.951>
      translate x*0.223
      rotate <0, -9.412, 21.61>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.925, 0.805, 0.903>
      translate x*0.212
      rotate <0, -19.637, -2.48>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.822, 0.997, 0.845>
      translate x*0.807
      rotate <0, 3.068, 0.001>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.973, 0.835, 0.842>
      translate x*0.274
      rotate <0, 5.087, -8.999>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.961, 0.993, 0.86>
      translate x*0.9
      rotate <0, 16.304, -17.217>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.891, 0.992, 0.946>
      translate x*0.468
      rotate <0, -5.118, 3.753>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.877, 0.825, 0.923>
      translate x*0.951
      rotate <0, 8.746, 14.128>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.875, 0.834, 0.801>
      translate x*0.054
      rotate <0, -4.332, 2.287>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.861, 0.896, 0.824>
      translate x*0.725
      rotate <0, 2.066, 5.674>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.955, 0.948, 0.985>
      translate x*0.001
      rotate <0, 6.599, -17.065>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.868, 0.842, 0.919>
      translate x*0.464
      rotate <0, -19.602, 4.477>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.932, 0.884, 0.96>
      translate x*0.292
      rotate <0, -2.797, 2.966>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.982, 0.98, 0.985>
      translate x*0.207
      rotate <0, 7.942, 1.279>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.923, 0.896, 0.899>
      translate x*0.789
      rotate <0, 7.25, -10.749>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.882, 0.92, 0.85>
      translate x*0.385
      rotate <0, 0.143, -19.935>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.869, 0.817, 0.807>
      translate x*0.405
      rotate <0, -2.441, -1.547>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.81, 0.93, 0.957>
      translate x*0.067
      rotate <0, 1.68, 3.879>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.88, 0.953, 0.899>
      translate x*0.577
      rotate <0, 13.958, 0.707>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.898, 0.817, 0.968>
      translate x*0.479
      rotate <0, 6.458, -6.143>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.847, 0.838, 0.915>
      translate x*0.29
      rotate <0, -3.37, 4.761>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.875, 0.837, 0.905>
      translate x*0.658
      rotate <0, 4.854, 4.468>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.928, 0.805, 0.825>
      translate x*0.154
      rotate <0, -10.952, -7.461>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.899, 0.886, 0.813>
      translate x*0.372
      rotate <0, 1.403, 3.899>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.817, 0.944, 0.898>
      translate x*0.259
      rotate <0, 18.727, 13.111>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.842, 0.971, 0.925>
      translate x*0.676
      rotate <0, 4.169, -13.411>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.896, 0.89, 0.893>
      translate x*0.829
      rotate <0, -3.987, 0.019>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.871, 0.937, 0.851>
      translate x*0.722
      rotate <0, 5.005, -9.149>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.904, 0.9, 0.856>
      translate x*0.906
      rotate <0, -4.88, -2.055>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.947, 0.937, 0.839>
      translate x*0.687
      rotate <0, 11.923, -3.43>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.907, 0.993, 0.962>
      translate x*0.562
      rotate <0, -8.359, 14.676>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.999, 0.917, 0.953>
      translate x*0.959
      rotate <0, -3.201, -4.065>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.899, 0.873, 0.805>
      translate x*0.396
      rotate <0, 20.747, 4.344>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.878, 0.915, 0.899>
      translate x*0.937
      rotate <0, -0.377, 8.176>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.928, 0.946, 0.853>
      translate x*0.288
      rotate <0, -1.705, 13.912>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.957, 0.933, 0.849>
      translate x*0.063
      rotate <0, -11.479, 19.282>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.976, 0.825, 0.998>
      translate x*0.686
      rotate <0, 13.068, 2.856>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.992, 0.888, 0.907>
      translate x*0.979
      rotate <0, 4.758, 1.655>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.979, 0.942, 0.995>
      translate x*0.9
      rotate <0, 8.351, -7.96>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.984, 0.903, 0.84>
      translate x*0.897
      rotate <0, -0.044, 18.685>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.924, 0.968, 0.828>
      translate x*0.161
      rotate <0, -14.916, 3.726>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.984, 0.942, 0.846>
      translate x*0.589
      rotate <0, 14.726, -6.8>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.909, 0.95, 0.909>
      translate x*0.428
      rotate <0, 4.789, -7.289>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.863, 0.943, 0.867>
      translate x*0.588
      rotate <0, -2.048, 8.767>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.996, 0.973, 0.82>
      translate x*0.208
      rotate <0, -3.494, -1.463>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.895, 0.965, 0.918>
      translate x*0.49
      rotate <0, -0.073, 2.815>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.845, 0.945, 0.835>
      translate x*0.871
      rotate <0, -10.054, -1.237>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.883, 0.991, 0.849>
      translate x*0.467
      rotate <0, -21.42, 8.543>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.875, 0.837, 0.81>
      translate x*0.206
      rotate <0, 11.085, -6.747>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.96, 0.816, 0.9>
      translate x*0.373
      rotate <0, 23.996, -3.416>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.807, 0.844, 0.988>
      translate x*0.225
      rotate <0, -1.58, 3.46>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.903, 0.954, 0.978>
      translate x*0.05
      rotate <0, 12.455, -18.602>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.865, 0.918, 0.808>
      translate x*0.447
      rotate <0, 8.096, -11.332>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.801, 0.887, 0.907>
      translate x*0.721
      rotate <0, -0.792, -4.65>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.986, 0.849, 0.955>
      translate x*0.172
      rotate <0, -1.866, -0.843>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.801, 0.903, 0.879>
      translate x*0.576
      rotate <0, 13.211, -4.535>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.993, 0.815, 0.851>
      translate x*0.48
      rotate <0, 11.975, -7.73>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.87, 0.942, 0.869>
      translate x*0.932
      rotate <0, 11.029, -10.202>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.803, 0.904, 0.925>
      translate x*0.956
      rotate <0, 3.552, -20.651>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.822, 0.99, 0.928>
      translate x*0.589
      rotate <0, -2.864, 16.417>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.928, 0.816, 0.943>
      translate x*0.386
      rotate <0, -19.88, -10.504>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.821, 0.946, 0.821>
      translate x*0.242
      rotate <0, 11.827, 9.946>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.819, 0.953, 0.862>
      translate x*0.925
      rotate <0, -18.944, 2.145>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.916, 0.803, 0.834>
      translate x*0.082
      rotate <0, 5.958, 4.652>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.826, 0.801, 0.977>
      translate x*0.471
      rotate <0, -7.156, -5.594>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.935, 0.969, 0.9>
      translate x*0.954
      rotate <0, -12.26, -10.962>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.827, 0.913, 0.911>
      translate x*0.256
      rotate <0, 14.476, 3.141>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.969, 0.856, 0.982>
      translate x*0.683
      rotate <0, -7.206, 4.901>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.984, 0.904, 0.949>
      translate x*0.89
      rotate <0, -10.522, -0.239>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.889, 0.883, 0.958>
      translate x*0.46
      rotate <0, -1.301, -2.149>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.802, 0.854, 0.937>
      translate x*0.353
      rotate <0, 10.777, -6.307>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.828, 0.91, 0.84>
      translate x*0.389
      rotate <0, -4.754, 0.226>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.818, 0.838, 0.957>
      translate x*0.695
      rotate <0, -25.357, 18.499>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.961, 0.938, 0.887>
      translate x*0.572
      rotate <0, 7.608, -2.599>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.828, 0.884, 0.908>
      translate x*0.42
      rotate <0, -10.097, 20.608>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.819, 0.827, 0.925>
      translate x*0.363
      rotate <0, 7.663, -1.562>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.856, 0.967, 0.885>
      translate x*0.813
      rotate <0, -1.33, -11.369>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.98, 0.92, 0.952>
      translate x*0.646
      rotate <0, 2.676, 10.061>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.885, 0.847, 0.808>
      translate x*0.711
      rotate <0, -1.222, -4.766>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.857, 0.863, 0.829>
      translate x*0.271
      rotate <0, -3.446, 14.912>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.85, 0.853, 0.875>
      translate x*0.442
      rotate <0, 8.175, -2.472>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.927, 0.995, 0.838>
      translate x*0.012
      rotate <0, 28.914, 1.075>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.809, 0.929, 0.996>
      translate x*0.956
      rotate <0, -2.542, -8.045>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.848, 0.888, 0.812>
      translate x*0.672
      rotate <0, -0.845, -12.19>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.905, 0.945, 0.888>
      translate x*0.375
      rotate <0, -25.203, 21.628>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.865, 0.935, 0.91>
      translate x*0.204
      rotate <0, -3.22, -1.506>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.918, 0.87, 0.886>
      translate x*0.462
      rotate <0, 5.449, -15.898>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.887, 0.842, 0.853>
      translate x*0.965
      rotate <0, 17.161, -2.284>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.93, 0.938, 0.845>
      translate x*0.76
      rotate <0, 2.087, -14.459>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.924, 0.833, 0.982>
      translate x*0.489
      rotate <0, -12.014, 7.506>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.805, 0.885, 0.884>
      translate x*0.391
      rotate <0, 4.169, 1.254>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.951, 0.928, 0.864>
      translate x*0.376
      rotate <0, -6.399, -0.331>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.899, 0.889, 0.865>
      translate x*0.768
      rotate <0, -9.448, 20.561>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.822, 0.992, 0.9>
      translate x*0.197
      rotate <0, 2.455, -4.825>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.803, 1, 0.843>
      translate x*0.71
      rotate <0, -8.42, 23.963>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.972, 0.83, 0.965>
      translate x*0.505
      rotate <0, -7.116, -8.394>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.839, 0.986, 0.879>
      translate x*0.704
      rotate <0, -11.138, -1.413>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.833, 0.906, 0.835>
      translate x*0.354
      rotate <0, 10.441, 5.589>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.811, 0.884, 0.965>
      translate x*0.323
      rotate <0, -3.038, -12.13>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.821, 0.877, 0.922>
      translate x*0.921
      rotate <0, -4.009, -4.783>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.828, 0.88, 0.939>
      translate x*0.03
      rotate <0, 7.207, -2.55>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.897, 0.82, 0.987>
      translate x*0.116
      rotate <0, 9.801, 9.411>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.998, 0.903, 0.841>
      translate x*0.873
      rotate <0, -4.146, 5.239>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.873, 0.828, 0.843>
      translate x*0.304
      rotate <0, 6.826, -6.807>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.919, 0.875, 0.907>
      translate x*0.822
      rotate <0, 0.812, -6.357>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.968, 0.975, 0.808>
      translate x*0.496
      rotate <0, -7.574, 3.84>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.863, 0.874, 0.92>
      translate x*0.725
      rotate <0, 1.15, -0.109>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.869, 0.8, 0.843>
      translate x*0.644
      rotate <0, 1.723, -9.109>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.873, 0.877, 0.838>
      translate x*0.154
      rotate <0, -0.389, -5.539>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.915, 0.838, 0.822>
      translate x*0.904
      rotate <0, -0.177, 14.972>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.973, 0.83, 0.919>
      translate x*0.618
      rotate <0, -5.658, 3.544>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.967, 0.825, 0.962>
      translate x*0.989
      rotate <0, -1.887, 10.405>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.816, 0.802, 0.943>
      translate x*0.899
      rotate <0, 0.07, 9.545>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.856, 0.813, 0.973>
      translate x*0.981
      rotate <0, -8.139, 14.578>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.863, 0.893, 0.873>
      translate x*0.5
      rotate <0, 20.931, -14.438>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.895, 0.937, 0.851>
      translate x*0.237
      rotate <0, 14.339, 5.036>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.917, 0.937, 0.842>
      translate x*0.463
      rotate <0, 3.178, -18.166>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.841, 0.938, 0.974>
      translate x*0.231
      rotate <0, 20.668, 3.273>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.81, 0.961, 0.915>
      translate x*0.034
      rotate <0, -30.012, -3.891>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.886, 0.907, 0.919>
      translate x*0.489
      rotate <0, 4.637, -5.825>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.972, 0.969, 0.806>
      translate x*0.945
      rotate <0, -17.419, -10.081>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.975, 0.861, 0.972>
      translate x*0.959
      rotate <0, -10.318, 8.106>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.964, 0.891, 0.9>
      translate x*0.283
      rotate <0, -2.127, -13.29>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.914, 0.892, 0.837>
      translate x*0.449
      rotate <0, -26.733, -13.412>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.819, 0.966, 0.876>
      translate x*0.218
      rotate <0, 10.882, 1.812>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.886, 0.809, 0.822>
      translate x*0.01
      rotate <0, 5.868, -5.45>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.962, 0.907, 0.956>
      translate x*0.065
      rotate <0, 12.108, -7.785>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.92, 0.932, 0.91>
      translate x*0.369
      rotate <0, 15.8, 4.113>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.864, 0.817, 0.985>
      translate x*0.439
      rotate <0, 4.095, 8.11>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.836, 0.829, 0.879>
      translate x*0.804
      rotate <0, 17.081, 4.891>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.895, 0.901, 0.882>
      translate x*0.494
      rotate <0, -20.589, 2.175>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.928, 0.975, 0.805>
      translate x*0.055
      rotate <0, 23.568, 25.754>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.825, 0.834, 0.949>
      translate x*0.488
      rotate <0, -27.751, 6.573>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.973, 0.82, 0.991>
      translate x*0.175
      rotate <0, -5.413, -4.958>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.954, 0.954, 0.879>
      translate x*0.185
      rotate <0, 1.88, -10.381>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.962, 0.936, 0.95>
      translate x*0.413
      rotate <0, 11.257, 20.191>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.999, 0.81, 0.859>
      translate x*0.821
      rotate <0, 8.16, 6.108>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.825, 0.847, 0.814>
      translate x*0.514
      rotate <0, 12.748, 5.741>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.839, 0.96, 0.912>
      translate x*0.645
      rotate <0, 5.338, 1.241>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.846, 0.893, 0.877>
      translate x*0.058
      rotate <0, -0.325, -5.31>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.939, 0.835, 0.952>
      translate x*0.267
      rotate <0, 14.347, 2.155>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.944, 0.842, 0.935>
      translate x*0.704
      rotate <0, -2.144, -3.828>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.838, 0.861, 0.819>
      translate x*0.33
      rotate <0, -12.166, -3.011>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.808, 0.908, 0.851>
      translate x*0.461
      rotate <0, 29.655, 0.42>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.855, 0.971, 0.867>
      translate x*0.23
      rotate <0, -15.886, -4.517>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.982, 0.976, 0.904>
      translate x*0.362
      rotate <0, -25.881, -0.015>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.869, 0.986, 0.849>
      translate x*0.89
      rotate <0, -11.703, 15.064>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.963, 0.992, 0.837>
      translate x*0.155
      rotate <0, -16.865, 10.181>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.833, 0.891, 0.998>
      translate x*0.838
      rotate <0, 8.78, 18.39>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.92, 0.832, 0.88>
      translate x*0.886
      rotate <0, -9.18, 3.723>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.997, 0.806, 0.938>
      translate x*0.076
      rotate <0, 3.348, -21.674>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.803, 0.898, 0.946>
      translate x*0.492
      rotate <0, 3.376, -7.47>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.969, 0.965, 0.821>
      translate x*0.497
      rotate <0, -12.925, 12.313>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.937, 0.851, 0.992>
      translate x*0.788
      rotate <0, -5.39, 15.656>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.917, 0.993, 0.826>
      translate x*0.833
      rotate <0, 20.272, -5.897>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.975, 0.846, 0.833>
      translate x*0.444
      rotate <0, -21.648, 14.323>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.922, 0.917, 0.918>
      translate x*0.39
      rotate <0, -27.32, -11.166>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.815, 0.961, 0.905>
      translate x*0.848
      rotate <0, -5.021, -22.979>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.899, 0.885, 0.904>
      translate x*0.065
      rotate <0, 10.138, -4.596>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.842, 0.888, 0.962>
      translate x*0.962
      rotate <0, -4.719, 23.652>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.985, 0.932, 0.979>
      translate x*0.387
      rotate <0, 7.936, 6.111>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <4, 0.894, 0.904>
      translate x*0.548
      rotate <0, -17.135, -16.332>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.912, 0.868, 0.903>
      translate x*0.577
      rotate <0, 1.083, -16.452>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.958, 0.998, 0.828>
      translate x*0.382
      rotate <0, 14.329, -14.801>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.975, 0.928, 0.9>
      translate x*0.886
      rotate <0, 7.699, 8.693>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.992, 0.886, 0.984>
      translate x*0.326
      rotate <0, -1.569, -9.887>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.802, 0.958, 0.921>
      translate x*0.688
      rotate <0, 3.75, -3.811>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.914, 0.805, 0.844>
      translate x*0.385
      rotate <0, 9.452, 7.992>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.839, 0.878, 0.861>
      translate x*0.087
      rotate <0, -6.644, -1.24>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.991, 0.859, 0.857>
      translate x*0.114
      rotate <0, 11.994, 3.995>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.854, 0.894, 0.876>
      translate x*0.03
      rotate <0, 4.877, 4.752>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.89, 0.852, 0.994>
      translate x*0.001
      rotate <0, 0.411, 9.563>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.882, 0.9, 0.889>
      translate x*0.176
      rotate <0, -7, -25.245>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.875, 0.987, 0.968>
      translate x*0.689
      rotate <0, 2.111, -9.055>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.806, 0.845, 0.913>
      translate x*0.01
      rotate <0, -6.948, -6.724>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <4, 0.89, 0.933>
      translate x*0.172
      rotate <0, -12.069, -15.482>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.905, 0.801, 0.816>
      translate x*0.952
      rotate <0, -8.248, 9.436>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.828, 0.944, 0.823>
      translate x*0.319
      rotate <0, -21.181, 5.853>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.846, 0.817, 0.83>
      translate x*0.46
      rotate <0, 4.617, -21.341>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.921, 0.911, 0.868>
      translate x*0.362
      rotate <0, 20.025, 13.514>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.972, 0.979, 0.92>
      translate x*0.366
      rotate <0, -7.749, 11.319>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.91, 0.939, 0.928>
      translate x*0.21
      rotate <0, -11.963, -1.453>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.86, 0.875, 0.853>
      translate x*0.951
      rotate <0, -2.272, -3.684>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.924, 0.808, 0.885>
      translate x*0.714
      rotate <0, 5.467, 0.635>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.884, 0.984, 0.945>
      translate x*0.493
      rotate <0, 5.29, 21.543>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.864, 0.834, 0.84>
      translate x*0.255
      rotate <0, 25.115, -10.122>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.869, 0.872, 0.843>
      translate x*0.295
      rotate <0, -13.422, 3.234>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.996, 0.973, 0.847>
      translate x*0.267
      rotate <0, -17.575, 3.182>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.88, 0.839, 0.822>
      translate x*0.431
      rotate <0, 6.617, 2.127>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.876, 0.843, 0.835>
      translate x*0.585
      rotate <0, 1.551, -17.792>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.914, 0.983, 0.842>
      translate x*0.713
      rotate <0, -8.231, -13.555>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.95, 0.922, 0.95>
      translate x*0.715
      rotate <0, 14.253, 13.865>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.848, 0.821, 0.963>
      translate x*0.619
      rotate <0, -8.118, -8.358>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.968, 0.915, 0.875>
      translate x*0.419
      rotate <0, -19.149, 0.307>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.918, 0.954, 0.848>
      translate x*0.182
      rotate <0, -1.159, 12.893>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.834, 0.866, 0.84>
      translate x*0.221
      rotate <0, -11.568, -0.596>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.962, 0.995, 0.853>
      translate x*0.086
      rotate <0, 9.751, 4.289>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.942, 0.905, 0.802>
      translate x*0.714
      rotate <0, -0.441, -13.343>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.822, 0.954, 0.942>
      translate x*0.46
      rotate <0, 8.964, -7.283>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.928, 0.901, 0.995>
      translate x*0.781
      rotate <0, -21.326, -8.471>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.83, 0.81, 0.821>
      translate x*0.127
      rotate <0, -30.829, -3.622>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.963, 0.82, 0.832>
      translate x*0.116
      rotate <0, 1.432, -4.844>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.874, 0.94, 0.833>
      translate x*0.285
      rotate <0, 1.779, 7.933>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.841, 0.943, 0.864>
      translate x*0.64
      rotate <0, -17.822, -9.598>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.864, 0.858, 0.899>
      translate x*0.898
      rotate <0, 0.789, 32.218>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.882, 0.861, 0.868>
      translate x*0.715
      rotate <0, 4.778, -24.759>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.8, 0.825, 0.956>
      translate x*0.248
      rotate <0, 2.396, 6.528>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.992, 0.891, 0.876>
      translate x*0.253
      rotate <0, 16.043, 4.425>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.966, 0.881, 0.873>
      translate x*0.445
      rotate <0, 4.53, 13.412>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.811, 0.934, 0.92>
      translate x*0.098
      rotate <0, -13.056, -1.598>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.936, 0.961, 0.997>
      translate x*0.844
      rotate <0, 0.553, 13.959>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.992, 0.922, 0.999>
      translate x*0.309
      rotate <0, -15.156, -1.531>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.834, 0.949, 0.812>
      translate x*0.653
      rotate <0, 15.335, 3.555>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.832, 0.959, 0.939>
      translate x*0.202
      rotate <0, -10.028, 3.111>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.828, 0.828, 0.958>
      translate x*0.2
      rotate <0, 9.928, 22.053>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.811, 0.827, 0.968>
      translate x*0.29
      rotate <0, 15.349, 2.505>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.986, 0.884, 0.994>
      translate x*0.623
      rotate <0, -4.951, -3.652>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.95, 0.849, 0.961>
      translate x*0.47
      rotate <0, -8.607, -5.842>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.801, 0.826, 0.859>
      translate x*0.974
      rotate <0, -8.395, -0.68>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.847, 0.873, 0.879>
      translate x*0.096
      rotate <0, 10.409, -3.359>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.995, 0.856, 0.908>
      translate x*0.975
      rotate <0, -13.536, 3.103>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <4, 0.885, 0.869>
      translate x*0.805
      rotate <0, 8.198, 0.392>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.801, 0.887, 0.975>
      translate x*0.936
      rotate <0, 1.701, -13.332>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.982, 0.903, 0.834>
      translate x*0.208
      rotate <0, -6.006, -19.438>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.856, 0.823, 0.85>
      translate x*0.574
      rotate <0, -6.471, 3.668>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.976, 0.965, 0.853>
      translate x*0.83
      rotate <0, 1.949, -5.139>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.993, 0.988, 0.911>
      translate x*0.721
      rotate <0, -0.853, -33.47>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.929, 0.966, 0.952>
      translate x*0.91
      rotate <0, -12.612, -0.617>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.956, 0.945, 0.805>
      translate x*0.187
      rotate <0, -4.295, 0.752>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.929, 0.843, 0.9>
      translate x*0.941
      rotate <0, 5.051, 17.371>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.839, 0.871, 0.816>
      translate x*0.256
      rotate <0, 9.624, -2.614>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.981, 0.984, 0.85>
      translate x*0.061
      rotate <0, -7.461, 5.902>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.972, 0.84, 0.913>
      translate x*0.563
      rotate <0, 0.478, -2.343>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.881, 0.846, 0.98>
      translate x*0.671
      rotate <0, 0.187, -16.557>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.94, 0.876, 0.826>
      translate x*0.367
      rotate <0, -2.342, 1.705>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.843, 0.954, 0.87>
      translate x*0.911
      rotate <0, -1.428, -8.735>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.981, 0.817, 0.822>
      translate x*0.435
      rotate <0, 2.037, -16.586>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.906, 0.982, 0.852>
      translate x*0.842
      rotate <0, -15.102, -4.326>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.938, 0.982, 0.853>
      translate x*0.061
      rotate <0, -1.134, -0.717>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.863, 0.976, 0.983>
      translate x*0.479
      rotate <0, -0.555, 0.029>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.896, 0.95, 0.832>
      translate x*0.953
      rotate <0, -21.904, -14.668>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.837, 0.922, 0.978>
      translate x*0.029
      rotate <0, -18.67, 5.515>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.804, 0.957, 0.808>
      translate x*0.981
      rotate <0, -27.631, -6.009>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.952, 0.821, 0.843>
      translate x*0.97
      rotate <0, -1.224, 5.642>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.907, 0.923, 0.918>
      translate x*0.044
      rotate <0, -3.118, 8.947>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.923, 0.975, 0.854>
      translate x*0.821
      rotate <0, 15.128, 13.443>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.973, 0.91, 0.954>
      translate x*0.539
      rotate <0, 9.348, -6.071>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.904, 0.935, 0.912>
      translate x*0.752
      rotate <0, -10.186, -5.679>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.854, 0.925, 0.949>
      translate x*0.191
      rotate <0, 2.273, -2.623>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.931, 0.94, 0.843>
      translate x*0.378
      rotate <0, 3.492, -20.453>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.863, 0.963, 0.906>
      translate x*0.225
      rotate <0, 9.765, -15.011>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.997, 0.968, 0.939>
      translate x*0.378
      rotate <0, 6.576, -6.662>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.807, 0.915, 0.985>
      translate x*0.144
      rotate <0, -2.905, -9.91>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.984, 0.945, 0.833>
      translate x*0.797
      rotate <0, -3.611, -27.482>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.853, 0.924, 0.961>
      translate x*0.59
      rotate <0, 3.236, -10.183>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.802, 0.942, 0.906>
      translate x*0.163
      rotate <0, 6.133, -4.287>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.972, 0.929, 0.968>
      translate x*0.053
      rotate <0, -11.422, -10.932>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.852, 0.971, 0.995>
      translate x*0.776
      rotate <0, -21.082, -6.954>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.835, 0.866, 0.864>
      translate x*0.407
      rotate <0, -13.934, 8.191>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.871, 0.954, 0.931>
      translate x*0.808
      rotate <0, -21.945, 9.317>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.809, 0.964, 0.894>
      translate x*0.53
      rotate <0, 7.958, 12.388>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.972, 0.95, 0.956>
      translate x*0.071
      rotate <0, -21.165, 11.619>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.827, 0.924, 0.919>
      translate x*0.504
      rotate <0, -5.569, 18.794>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.828, 0.909, 0.842>
      translate x*0.577
      rotate <0, -18.985, 2.373>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.872, 0.904, 0.976>
      translate x*0.133
      rotate <0, 12.252, -12.797>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.926, 0.962, 0.888>
      translate x*0.267
      rotate <0, -12.77, 16.737>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.962, 0.993, 0.927>
      translate x*0.782
      rotate <0, -6.272, 6.407>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.944, 0.99, 0.898>
      translate x*0.524
      rotate <0, -13.457, -2.629>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.864, 0.816, 0.887>
      translate x*0.781
      rotate <0, -7.83, 22.127>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.852, 0.802, 0.807>
      translate x*0.341
      rotate <0, -7.636, -10.479>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.936, 0.836, 0.864>
      translate x*0.893
      rotate <0, 16.066, 2.491>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.916, 0.955, 0.986>
      translate x*0.271
      rotate <0, -14.058, 1.385>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.812, 0.9, 0.804>
      translate x*0.586
      rotate <0, 10.201, 15.034>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.901, 0.838, 0.976>
      translate x*0.526
      rotate <0, -17.338, -3.259>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.835, 0.903, 0.998>
      translate x*0.11
      rotate <0, 5.932, -4.807>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.931, 0.977, 0.972>
      translate x*0.84
      rotate <0, 0.357, 24.797>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.859, 1, 0.919>
      translate x*0.624
      rotate <0, 12.842, -11.743>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.836, 0.852, 0.933>
      translate x*0.981
      rotate <0, 2.86, -5.763>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.817, 0.957, 0.944>
      translate x*0.865
      rotate <0, -2.007, -3.253>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.921, 0.911, 0.915>
      translate x*0.025
      rotate <0, 18.005, -15.572>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.976, 0.966, 0.954>
      translate x*0.117
      rotate <0, -7.011, -0.805>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.88, 0.959, 0.819>
      translate x*0.756
      rotate <0, 11.311, 12.758>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.976, 0.808, 0.945>
      translate x*0.459
      rotate <0, -8.926, 4.285>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.92, 0.898, 0.843>
      translate x*0.831
      rotate <0, 2.551, 7.075>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.887, 0.99, 0.951>
      translate x*0.553
      rotate <0, 10.486, 10.328>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.893, 0.917, 0.927>
      translate x*0.562
      rotate <0, -5.559, -5.803>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.859, 0.856, 0.907>
      translate x*0.458
      rotate <0, 22.277, 10.05>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.806, 0.996, 0.991>
      translate x*0.45
      rotate <0, 8.651, 5.453>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.917, 0.98, 0.86>
      translate x*0.223
      rotate <0, 10.827, -5.366>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.81, 0.917, 0.951>
      translate x*0.837
      rotate <0, 2.372, -13.759>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.966, 0.944, 0.854>
      translate x*0.255
      rotate <0, 9.263, -10.977>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.941, 0.957, 0.802>
      translate x*0.294
      rotate <0, 8.648, -21.452>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.859, 0.914, 0.997>
      translate x*0.693
      rotate <0, 6.012, 0.417>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.807, 0.957, 0.863>
      translate x*0.621
      rotate <0, 9.693, -0.575>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.905, 0.818, 0.93>
      translate x*0.314
      rotate <0, -3.31, 7.953>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.999, 0.826, 0.985>
      translate x*0.579
      rotate <0, 18.42, -7.632>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.95, 0.835, 0.909>
      translate x*0.688
      rotate <0, 5.567, 19.538>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.918, 0.897, 0.887>
      translate x*0.721
      rotate <0, -2.613, -17.416>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.924, 0.895, 0.835>
      translate x*0.589
      rotate <0, 2.806, 23.787>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.892, 0.875, 0.943>
      translate x*0.955
      rotate <0, -5.61, -2.894>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.877, 0.814, 0.911>
      translate x*0.918
      rotate <0, -2.287, 7.055>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.99, 0.903, 0.89>
      translate x*0.688
      rotate <0, -8.081, -11.276>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.906, 0.843, 0.996>
      translate x*0.613
      rotate <0, -5.8, -16.484>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.886, 0.981, 0.853>
      translate x*0.697
      rotate <0, -6.311, 8.71>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.891, 0.972, 0.813>
      translate x*0.317
      rotate <0, 4.695, -7.733>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.89, 0.972, 0.887>
      translate x*0.083
      rotate <0, 25.478, 3.292>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.936, 0.864, 0.978>
      translate x*0.772
      rotate <0, -11.294, 9.421>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.809, 0.924, 0.915>
      translate x*0.933
      rotate <0, -2.523, 6.858>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.946, 0.854, 0.936>
      translate x*0.215
      rotate <0, -3.735, 17.162>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.841, 0.838, 0.958>
      translate x*0.556
      rotate <0, 5.377, 10.852>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.929, 0.992, 0.83>
      translate x*0.246
      rotate <0, 10.467, -2.273>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.859, 0.925, 0.859>
      translate x*0.432
      rotate <0, -2.584, -18.666>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.95, 0.868, 0.917>
      translate x*0.932
      rotate <0, 21.323, -1.719>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.813, 0.965, 0.869>
      translate x*0.216
      rotate <0, -3.4, -11.831>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.835, 0.894, 0.862>
      translate x*0.134
      rotate <0, -6.849, 10.666>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.891, 0.922, 0.816>
      translate x*0.444
      rotate <0, -2.691, -5.181>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.841, 0.88, 0.993>
      translate x*0.302
      rotate <0, 17.714, 15.974>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.854, 0.923, 0.915>
      translate x*0.804
      rotate <0, -6.477, -8.299>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.905, 0.884, 0.975>
      translate x*0.247
      rotate <0, -20.67, 9.937>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.915, 0.867, 0.849>
      translate x*0.083
      rotate <0, 1.88, 10.084>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.973, 0.867, 0.879>
      translate x*0.615
      rotate <0, 8.179, -0.926>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.859, 0.846, 0.869>
      translate x*0.176
      rotate <0, -3.226, 15.493>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.928, 0.842, 0.805>
      translate x*0.082
      rotate <0, -7.993, 11.588>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.871, 0.972, 0.847>
      translate x*0.769
      rotate <0, 4.729, -14.414>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.926, 0.932, 0.928>
      translate x*0.494
      rotate <0, 10.468, -7.028>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.886, 0.876, 0.94>
      translate x*0.57
      rotate <0, -0.743, 3.479>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.938, 0.944, 0.826>
      translate x*0.47
      rotate <0, -1.695, -9.713>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.806, 0.976, 0.879>
      translate x*0.211
      rotate <0, 11.424, 11.478>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.832, 0.969, 0.88>
      translate x*0.192
      rotate <0, 9.602, 3.098>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.917, 0.888, 0.853>
      translate x*0.187
      rotate <0, 1.335, -7.805>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.88, 0.899, 0.873>
      translate x*0.4
      rotate <0, 1.311, 13.011>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.941, 0.955, 0.91>
      translate x*0.455
      rotate <0, 1.766, 18.018>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.918, 0.899, 0.9>
      translate x*0.818
      rotate <0, -7.706, 1.811>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.957, 1, 0.928>
      translate x*0.57
      rotate <0, -4.841, 11.889>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.957, 0.999, 0.811>
      translate x*0.52
      rotate <0, -3.926, 14.138>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.932, 0.954, 0.983>
      translate x*0.469
      rotate <0, -0.804, -7.613>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.969, 0.957, 0.995>
      translate x*0.983
      rotate <0, -16.468, 2.694>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.981, 0.968, 0.881>
      translate x*0.281
      rotate <0, 14.169, 22.045>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.936, 0.866, 0.835>
      translate x*0.809
      rotate <0, 5.762, -8.058>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.822, 0.968, 0.957>
      translate x*0.784
      rotate <0, 19.374, 7.915>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.805, 0.935, 0.929>
      translate x*0.381
      rotate <0, 25.305, -1.746>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.819, 0.961, 0.83>
      translate x*0.378
      rotate <0, -4.265, 13.309>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.921, 0.826, 0.916>
      translate x*0.931
      rotate <0, 17.976, 2.501>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.991, 0.944, 0.906>
      translate x*0.691
      rotate <0, -6.106, -18.288>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.883, 0.89, 0.912>
      translate x*0.786
      rotate <0, 13.503, 1.028>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.887, 0.824, 0.816>
      translate x*0.199
      rotate <0, -15.037, -12.176>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.904, 0.971, 0.87>
      translate x*0.763
      rotate <0, 13.214, 11.003>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.991, 0.919, 0.889>
      translate x*0.476
      rotate <0, 5.178, 0.702>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.911, 0.81, 0.987>
      translate x*0.984
      rotate <0, 4.956, -15.903>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.862, 0.919, 0.937>
      translate x*0.94
      rotate <0, -4.341, -2.031>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.972, 0.848, 0.974>
      translate x*0.593
      rotate <0, 1.501, -3.533>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.98, 0.999, 0.969>
      translate x*0.223
      rotate <0, -7.495, -19.933>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.98, 0.933, 0.997>
      translate x*0.122
      rotate <0, -13.362, -14.991>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.995, 0.856, 0.989>
      translate x*0.538
      rotate <0, 8.439, -8.493>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.888, 0.843, 0.818>
      translate x*0.506
      rotate <0, 7.167, -2.139>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.848, 0.861, 0.806>
      translate x*0.652
      rotate <0, 9.214, 10.101>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.917, 0.829, 0.841>
      translate x*0.991
      rotate <0, -4.969, 1.101>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.974, 0.803, 0.922>
      translate x*0.352
      rotate <0, 10.013, 15.135>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.939, 0.982, 0.889>
      translate x*0.432
      rotate <0, 1.785, -6.364>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.937, 0.899, 0.901>
      translate x*0.514
      rotate <0, -0.95, 11.458>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.955, 0.942, 0.917>
      translate x*0.726
      rotate <0, 9.635, 0.232>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.824, 0.879, 0.808>
      translate x*0.148
      rotate <0, 1.601, 20.445>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.957, 0.836, 0.994>
      translate x*0.378
      rotate <0, -10.738, -1.342>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.846, 0.891, 0.808>
      translate x*0.043
      rotate <0, 3.673, 6.819>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.821, 0.884, 0.848>
      translate x*0.442
      rotate <0, 4.642, -13.078>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.954, 0.939, 0.819>
      translate x*0.881
      rotate <0, -11.468, -7.714>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.995, 0.837, 0.82>
      translate x*0.338
      rotate <0, 3.095, 6.549>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.843, 0.915, 0.809>
      translate x*0.944
      rotate <0, -2.677, 12.96>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.939, 0.998, 0.803>
      translate x*0.287
      rotate <0, -9.235, 3.896>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.843, 0.828, 0.921>
      translate x*0.78
      rotate <0, 10.976, 3.54>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.985, 0.9, 0.933>
      translate x*0.366
      rotate <0, -8.231, 5.439>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.958, 0.984, 0.942>
      translate x*0.45
      rotate <0, -15.361, -14.778>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.859, 0.868, 0.895>
      translate x*0.423
      rotate <0, 11.217, -14.963>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.872, 0.833, 0.969>
      translate x*0.236
      rotate <0, 11.846, 4.294>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.856, 0.858, 0.91>
      translate x*0.345
      rotate <0, 12.327, -4.886>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.871, 0.926, 0.903>
      translate x*0.913
      rotate <0, 13.636, -5.601>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.991, 0.895, 0.973>
      translate x*0.439
      rotate <0, -28.14, -12.259>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.998, 0.808, 0.929>
      translate x*0.983
      rotate <0, -14.146, 5.428>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.823, 0.8, 0.907>
      translate x*0.909
      rotate <0, 0.083, -6.418>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.901, 0.988, 0.901>
      translate x*0.457
      rotate <0, -16.163, 12.017>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.972, 0.831, 0.896>
      translate x*0.679
      rotate <0, 1.492, -11.32>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.975, 0.893, 0.899>
      translate x*0.092
      rotate <0, 13.719, 8.603>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.94, 0.825, 0.968>
      translate x*0.059
      rotate <0, -9.501, -14.963>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.977, 0.882, 0.975>
      translate x*0.176
      rotate <0, -6.439, 0.032>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.938, 0.97, 0.996>
      translate x*0.004
      rotate <0, -1.691, 10.975>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.806, 0.903, 0.848>
      translate x*0.252
      rotate <0, 1.535, -5.342>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.83, 0.894, 0.97>
      translate x*0.948
      rotate <0, 1.214, 13.231>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.911, 0.961, 0.877>
      translate x*0.385
      rotate <0, 2.371, -7.07>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.821, 0.895, 0.83>
      translate x*0.48
      rotate <0, -17.494, -5.233>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.953, 0.913, 0.964>
      translate x*0.862
      rotate <0, 13.294, -5.588>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.869, 0.902, 0.9>
      translate x*0.338
      rotate <0, -5.764, 0.254>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.857, 0.826, 0.815>
      translate x*0.425
      rotate <0, 8.671, 16.227>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.964, 0.891, 0.912>
      translate x*0.483
      rotate <0, -4.953, -0.796>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.982, 0.922, 0.918>
      translate x*0.423
      rotate <0, -3.433, -22.128>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.953, 0.849, 0.973>
      translate x*0.237
      rotate <0, 2.28, -1.28>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.866, 0.868, 0.956>
      translate x*0.508
      rotate <0, 22.467, -2.612>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.951, 0.907, 0.94>
      translate x*0.74
      rotate <0, -1.412, -8.173>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.948, 0.899, 0.931>
      translate x*0.722
      rotate <0, -6.664, -18.151>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.922, 0.829, 0.886>
      translate x*0.216
      rotate <0, -12.729, 13.358>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.837, 0.851, 0.993>
      translate x*0.127
      rotate <0, 1.28, -6.861>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.957, 0.988, 0.802>
      translate x*0.794
      rotate <0, -15.45, 5.363>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.832, 0.911, 0.967>
      translate x*0.326
      rotate <0, -4.01, 7.981>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.956, 0.917, 0.911>
      translate x*0.89
      rotate <0, -5.001, 4.008>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.956, 0.816, 0.872>
      translate x*0.507
      rotate <0, -10.784, -10.803>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.915, 0.854, 0.874>
      translate x*0.383
      rotate <0, -13.643, -10.07>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.912, 0.844, 0.918>
      translate x*0.877
      rotate <0, 0.471, 15.157>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.841, 0.875, 0.917>
      translate x*0.088
      rotate <0, -18.069, 22.028>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.927, 0.826, 0.98>
      translate x*0.609
      rotate <0, -8.808, -7.605>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.999, 0.944, 0.902>
      translate x*0.267
      rotate <0, -1.176, 8.642>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.983, 0.997, 0.923>
      translate x*0.677
      rotate <0, -19.422, 6.352>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.998, 0.957, 0.838>
      translate x*0.188
      rotate <0, -1.819, 0.104>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.906, 0.845, 0.901>
      translate x*0.187
      rotate <0, -21.683, 7.223>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.932, 0.819, 0.974>
      translate x*0.956
      rotate <0, -4.294, -15.379>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.918, 0.863, 0.88>
      translate x*0.09
      rotate <0, -0.571, -6.131>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.985, 0.931, 0.87>
      translate x*0.134
      rotate <0, 18.632, -12.536>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.813, 0.851, 0.822>
      translate x*0.392
      rotate <0, 0.435, 4.77>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.804, 0.821, 0.874>
      translate x*0.884
      rotate <0, -2.602, -4.58>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.87, 0.998, 0.878>
      translate x*0.228
      rotate <0, 2.079, -1.018>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.962, 0.804, 0.913>
      translate x*0.631
      rotate <0, 10.221, 2.502>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.952, 0.875, 0.915>
      translate x*0.43
      rotate <0, 9.817, -7.929>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.911, 0.893, 0.926>
      translate x*0.497
      rotate <0, -3.201, -1.154>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.822, 0.866, 0.844>
      translate x*0.451
      rotate <0, -2.71, 1.99>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.832, 0.958, 0.941>
      translate x*0.002
      rotate <0, -4.63, -17.192>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.811, 0.883, 0.967>
      translate x*0.773
      rotate <0, -3.989, -22.133>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.913, 0.852, 0.824>
      translate x*0.77
      rotate <0, 7.321, 10.193>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.972, 0.974, 0.895>
      translate x*0.163
      rotate <0, 4.463, 22.677>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.937, 0.994, 0.814>
      translate x*0.243
      rotate <0, -8.411, 0.605>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.963, 0.988, 0.98>
      translate x*0.41
      rotate <0, 11.854, -9.237>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.811, 0.832, 0.949>
      translate x*0.652
      rotate <0, 5.064, -1.118>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.872, 0.989, 0.902>
      translate x*0.402
      rotate <0, 5.722, -16.824>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.836, 0.984, 0.825>
      translate x*0.732
      rotate <0, 7.215, -0.416>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.958, 0.894, 0.835>
      translate x*0.666
      rotate <0, -17.369, 5.799>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.836, 0.971, 0.871>
      translate x*0.934
      rotate <0, 5.146, -3.498>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.998, 0.932, 0.972>
      translate x*0.747
      rotate <0, -12.843, 1.237>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.842, 0.835, 0.887>
      translate x*0.128
      rotate <0, 21.325, 1.159>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.91, 0.876, 0.905>
      translate x*0.051
      rotate <0, -5.601, 7.421>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.964, 0.87, 0.939>
      translate x*0.042
      rotate <0, -3.819, -3.733>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.87, 0.97, 0.938>
      translate x*0.007
      rotate <0, -14.777, -2.088>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.83, 0.854, 0.848>
      translate x*0.938
      rotate <0, 7.799, 12.118>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.868, 0.992, 0.948>
      translate x*0.682
      rotate <0, 17.461, -3.134>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.941, 0.9, 0.861>
      translate x*0.26
      rotate <0, -3.072, -20.134>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.818, 0.875, 0.957>
      translate x*0.224
      rotate <0, -5.708, -24.369>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.811, 0.829, 0.856>
      translate x*0.266
      rotate <0, 15.531, 17.682>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.894, 0.829, 0.942>
      translate x*0.736
      rotate <0, 13, 3.945>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.935, 0.875, 0.963>
      translate x*0.875
      rotate <0, 7.078, -0.268>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.881, 0.88, 0.926>
      translate x*0.473
      rotate <0, -0.634, 6.697>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.978, 0.92, 0.846>
      translate x*0.234
      rotate <0, 4.813, -0.027>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.922, 0.884, 1>
      translate x*0.467
      rotate <0, -9.134, -4.763>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.898, 0.981, 0.841>
      translate x*0.749
      rotate <0, -3.785, -7.291>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.956, 0.81, 0.806>
      translate x*0.961
      rotate <0, 13.943, -7.821>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.916, 0.846, 0.878>
      translate x*0.577
      rotate <0, -8.14, -18.11>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.916, 0.875, 0.833>
      translate x*0.269
      rotate <0, -5.477, 2.69>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.946, 0.862, 0.899>
      translate x*0.818
      rotate <0, -9.08, -2.872>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.891, 0.801, 0.959>
      translate x*0.929
      rotate <0, 15.04, -16.783>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.882, 0.896, 0.998>
      translate x*0.917
      rotate <0, -26.501, -11.62>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.82, 0.891, 0.883>
      translate x*0.286
      rotate <0, 13.148, -7.374>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.868, 0.965, 0.873>
      translate x*0.011
      rotate <0, -3.961, 5.29>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.817, 0.9, 0.996>
      translate x*0.851
      rotate <0, 3.372, -3.271>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.851, 0.841, 0.947>
      translate x*0.215
      rotate <0, 4.012, -2.868>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <4, 0.872, 0.813>
      translate x*0.082
      rotate <0, 0.892, 3.152>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.836, 0.848, 0.836>
      translate x*0.107
      rotate <0, -9.896, 3.355>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.823, 0.851, 0.838>
      translate x*0.441
      rotate <0, -15.309, 9.528>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.835, 0.851, 0.802>
      translate x*0.892
      rotate <0, 4.136, -1.337>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.879, 0.919, 0.863>
      translate x*0.855
      rotate <0, -8.71, 9.977>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.848, 0.941, 0.802>
      translate x*0.003
      rotate <0, 6.91, 6.634>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.878, 0.964, 0.887>
      translate x*0.954
      rotate <0, 16.272, -1.159>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.96, 0.931, 0.851>
      translate x*0.129
      rotate <0, 10.222, -2.183>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.867, 0.948, 0.959>
      translate x*0.7
      rotate <0, 6.834, 0.642>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.981, 0.868, 0.807>
      translate x*0.919
      rotate <0, 3.251, -17.706>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.892, 0.966, 0.811>
      translate x*0.289
      rotate <0, 18.566, -6.762>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.825, 0.956, 0.812>
      translate x*0.85
      rotate <0, 11.541, 4.671>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.88, 0.968, 0.9>
      translate x*0.431
      rotate <0, 3.698, 5.141>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.961, 0.826, 0.979>
      translate x*0.023
      rotate <0, 16.807, 19.462>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.822, 0.937, 0.836>
      translate x*0.398
      rotate <0, 12.005, 1.963>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.814, 0.818, 0.878>
      translate x*0.864
      rotate <0, 11.758, 14.843>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.956, 0.895, 0.887>
      translate x*0.446
      rotate <0, 7.621, -1.033>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.959, 0.927, 0.894>
      translate x*0.985
      rotate <0, -9.806, -9.262>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.92, 0.828, 0.856>
      translate x*0.489
      rotate <0, -1.044, -9.319>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.889, 0.983, 0.913>
      translate x*0.701
      rotate <0, -9.446, 3.209>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.864, 0.802, 0.928>
      translate x*0.145
      rotate <0, 20.945, -9.448>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.895, 0.994, 0.923>
      translate x*0.952
      rotate <0, -6.832, -10.882>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.823, 0.866, 0.854>
      translate x*0.53
      rotate <0, 6.846, -12.387>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.941, 0.954, 0.87>
      translate x*0.613
      rotate <0, -6.591, 15.027>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.8, 0.904, 0.801>
      translate x*0.403
      rotate <0, -11.189, 5.114>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.969, 0.917, 0.86>
      translate x*0.456
      rotate <0, 26.978, 4.316>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.99, 0.94, 0.924>
      translate x*0.562
      rotate <0, 4.432, 8.101>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.818, 0.948, 0.955>
      translate x*0.25
      rotate <0, -22.465, -5.534>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.884, 0.966, 0.875>
      translate x*0.586
      rotate <0, 4.51, 0.914>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.9, 0.867, 0.942>
      translate x*0.741
      rotate <0, -1.112, 14.5>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.979, 0.87, 0.823>
      translate x*0.305
      rotate <0, 3.229, -10.443>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.908, 0.871, 0.829>
      translate x*0.522
      rotate <0, 1.975, 10.538>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.945, 0.86, 0.897>
      translate x*0.624
      rotate <0, -2.01, -6.078>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.995, 0.871, 0.951>
      translate x*0.021
      rotate <0, -1.156, 1.428>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.864, 0.86, 0.918>
      translate x*0.563
      rotate <0, -15.903, 0.832>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.809, 0.914, 0.934>
      translate x*0.124
      rotate <0, 5.851, 4.444>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.9, 0.946, 0.839>
      translate x*0.634
      rotate <0, -0.477, 6.876>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.925, 0.843, 0.903>
      translate x*0.158
      rotate <0, 2.305, -3.007>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.903, 0.837, 0.856>
      translate x*0.94
      rotate <0, -3.018, 5.989>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.946, 0.849, 0.875>
      translate x*0.247
      rotate <0, 2.766, -5.679>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.826, 0.984, 0.908>
      translate x*0.592
      rotate <0, -5.482, -1.233>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.925, 0.975, 0.832>
      translate x*0.273
      rotate <0, -4.775, 17.174>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.939, 0.972, 0.837>
      translate x*0.345
      rotate <0, 13.819, 10.475>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.873, 0.935, 0.92>
      translate x*0.955
      rotate <0, 19.374, 5.391>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.826, 0.89, 0.814>
      translate x*0.552
      rotate <0, -6.495, 2.712>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.911, 0.985, 0.947>
      translate x*0.774
      rotate <0, 5.196, -8.608>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.853, 0.882, 0.808>
      translate x*0.809
      rotate <0, -9.423, 1.711>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.931, 0.937, 0.949>
      translate x*0.751
      rotate <0, 6.09, 13.53>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.986, 0.818, 0.806>
      translate x*0.928
      rotate <0, -6.737, -19.757>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.814, 0.928, 0.887>
      translate x*0.322
      rotate <0, 2.741, 11.279>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.955, 0.821, 0.859>
      translate x*0.091
      rotate <0, 6.479, 8.078>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.983, 0.949, 0.938>
      translate x*0.805
      rotate <0, -16.03, 10.227>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.93, 0.875, 0.961>
      translate x*0.313
      rotate <0, 9.112, -7.999>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.833, 0.855, 0.958>
      translate x*0.207
      rotate <0, -3.231, 10.839>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.82, 0.949, 0.938>
      translate x*0.593
      rotate <0, 0.363, 0.315>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.912, 0.929, 0.871>
      translate x*0.365
      rotate <0, -16.257, 8.96>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.856, 0.973, 0.848>
      translate x*0.357
      rotate <0, 10.353, 0.835>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.905, 0.849, 0.857>
      translate x*0.666
      rotate <0, 12.185, -5.97>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.862, 0.988, 0.977>
      translate x*0.077
      rotate <0, 4.211, 7.318>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.986, 0.835, 0.801>
      translate x*0.846
      rotate <0, -7.007, -7.025>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.982, 0.916, 0.836>
      translate x*0.19
      rotate <0, -13.124, 3.307>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.892, 0.897, 0.982>
      translate x*0.612
      rotate <0, 9.653, 5.745>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.962, 0.963, 0.923>
      translate x*0.674
      rotate <0, 9.819, -9.644>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.993, 0.882, 0.941>
      translate x*0.086
      rotate <0, 19.506, -3.529>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.869, 0.814, 0.98>
      translate x*0.908
      rotate <0, -9.089, -2.394>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.992, 0.94, 0.834>
      translate x*0.304
      rotate <0, -0.481, 14.2>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.825, 0.92, 0.991>
      translate x*0.702
      rotate <0, -3.356, -8.321>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.849, 0.999, 0.891>
      translate x*0.289
      rotate <0, -5.228, 7.191>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.949, 0.938, 0.96>
      translate x*0.59
      rotate <0, 9.947, -20.138>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.857, 0.972, 0.995>
      translate x*0.424
      rotate <0, 1.891, -7.272>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.992, 0.936, 0.818>
      translate x*0.782
      rotate <0, 0.788, -6.458>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.96, 0.992, 0.903>
      translate x*0.133
      rotate <0, -2.364, 14.422>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.939, 0.904, 0.984>
      translate x*0.384
      rotate <0, -5.2, 4.873>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.939, 0.895, 0.806>
      translate x*0.102
      rotate <0, -3.132, 8.98>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.986, 0.905, 0.84>
      translate x*0.755
      rotate <0, -2.853, 3.631>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.868, 0.929, 0.885>
      translate x*0.562
      rotate <0, 6.112, -13.605>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.848, 0.891, 0.95>
      translate x*0.135
      rotate <0, 6.838, -0.763>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.953, 0.843, 0.821>
      translate x*0.347
      rotate <0, 8.934, 9.535>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.909, 0.816, 0.969>
      translate x*0.898
      rotate <0, 14.72, -5.098>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.857, 0.814, 0.84>
      translate x*0.751
      rotate <0, 5.354, 17.099>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.881, 0.994, 0.976>
      translate x*0.065
      rotate <0, 16.365, 10.885>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.946, 0.855, 0.951>
      translate x*0.414
      rotate <0, 1.506, 7.909>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.974, 0.805, 0.891>
      translate x*0.943
      rotate <0, 17.065, 23.812>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.824, 0.888, 0.84>
      translate x*0.741
      rotate <0, -16.223, -5.503>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.936, 0.812, 0.986>
      translate x*0.004
      rotate <0, 12.161, -4.97>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.906, 0.81, 0.999>
      translate x*0.596
      rotate <0, 1.631, -8.023>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.887, 0.897, 0.872>
      translate x*0.395
      rotate <0, -8.081, -13.025>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.923, 0.83, 0.84>
      translate x*0.264
      rotate <0, 9.342, 2.147>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.987, 0.964, 0.859>
      translate x*0.673
      rotate <0, 2.175, 12.509>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.965, 0.923, 0.876>
      translate x*0.94
      rotate <0, -13.146, -17.199>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.967, 0.93, 0.974>
      translate x*0.657
      rotate <0, -14.031, -11.794>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.879, 0.965, 0.824>
      translate x*0.226
      rotate <0, -22.01, -9.769>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.868, 0.845, 0.841>
      translate x*0.514
      rotate <0, 25.377, 0.544>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.936, 0.895, 0.804>
      translate x*0.389
      rotate <0, 2.223, -7.142>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.91, 0.964, 0.989>
      translate x*0.441
      rotate <0, 0.781, -16.014>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.862, 0.982, 0.994>
      translate x*0.38
      rotate <0, -17.765, 11.994>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.944, 0.913, 0.918>
      translate x*0.576
      rotate <0, -29.234, 3.902>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.865, 0.823, 0.813>
      translate x*0.85
      rotate <0, -20.53, 3.68>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.899, 0.869, 0.974>
      translate x*1
      rotate <0, 1.89, 3.322>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.839, 0.866, 0.892>
      translate x*0.669
      rotate <0, 15.918, 5.581>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.984, 0.806, 0.853>
      translate x*0.952
      rotate <0, -16.467, 2.463>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.894, 0.973, 0.812>
      translate x*0.688
      rotate <0, 2.333, -1.1>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.955, 0.804, 0.909>
      translate x*0.641
      rotate <0, -6.962, -5.976>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.881, 0.931, 0.956>
      translate x*0.743
      rotate <0, -0.89, -14.712>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.911, 0.8, 0.975>
      translate x*0.256
      rotate <0, -5.619, -16.804>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.953, 0.906, 0.962>
      translate x*0.145
      rotate <0, 10.042, -7.297>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.825, 0.869, 0.961>
      translate x*0.056
      rotate <0, -12.429, 3.376>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.953, 0.866, 0.821>
      translate x*0.156
      rotate <0, -8.828, -5.787>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.965, 0.896, 0.848>
      translate x*0.666
      rotate <0, 16.004, 4.536>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.957, 0.863, 0.82>
      translate x*0.188
      rotate <0, -5.041, -6.32>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.929, 0.854, 0.858>
      translate x*0.939
      rotate <0, -15.002, -26.775>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.86, 0.888, 0.848>
      translate x*0.736
      rotate <0, 3.98, 22.321>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.941, 0.837, 0.883>
      translate x*0.009
      rotate <0, 18.715, -10.825>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.837, 0.913, 0.984>
      translate x*0.277
      rotate <0, -13.623, -11.905>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.828, 0.959, 0.881>
      translate x*0.415
      rotate <0, 0.698, 1.469>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.869, 0.905, 0.991>
      translate x*0.634
      rotate <0, 15.292, -2.096>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.829, 0.97, 0.82>
      translate x*0.397
      rotate <0, 9.238, 1.253>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.869, 0.955, 0.913>
      translate x*0.562
      rotate <0, 0.469, 14.553>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.955, 0.807, 0.961>
      translate x*0.763
      rotate <0, -7.211, 1.951>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.89, 0.985, 0.912>
      translate x*0.54
      rotate <0, -9.714, -3.539>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.95, 0.827, 0.977>
      translate x*0.916
      rotate <0, -11.346, -24.043>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.844, 0.882, 0.844>
      translate x*0.011
      rotate <0, -7.601, 18.077>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.878, 0.833, 0.993>
      translate x*0.943
      rotate <0, -1.849, -1.233>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.936, 0.835, 0.813>
      translate x*0.589
      rotate <0, 7.243, 18.972>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.876, 0.952, 0.949>
      translate x*0.864
      rotate <0, -6.503, 5.528>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.932, 0.8, 0.885>
      translate x*0.95
      rotate <0, 14.589, 23.587>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.806, 0.965, 0.857>
      translate x*0.423
      rotate <0, 9.604, -1.032>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.944, 0.992, 0.922>
      translate x*0.429
      rotate <0, 7.391, 11.584>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.848, 0.855, 0.876>
      translate x*0.042
      rotate <0, -7.98, -6.329>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.985, 0.811, 0.805>
      translate x*0.546
      rotate <0, -6.864, 4.793>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.846, 0.877, 0.855>
      translate x*0.806
      rotate <0, -9.757, -4.32>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.862, 0.815, 0.908>
      translate x*0.976
      rotate <0, -15.093, -5.295>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.988, 0.801, 0.977>
      translate x*0.597
      rotate <0, -4.4, 10.376>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.946, 0.845, 0.803>
      translate x*0.7
      rotate <0, -13.604, 12.488>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.892, 0.941, 0.858>
      translate x*0.759
      rotate <0, 0.935, -6.375>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.912, 0.994, 0.934>
      translate x*0.333
      rotate <0, 5.069, 1.498>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.802, 0.932, 0.83>
      translate x*0.906
      rotate <0, -10.687, -8.861>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.876, 0.863, 0.968>
      translate x*0.878
      rotate <0, -10.287, -13.754>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.865, 0.946, 0.861>
      translate x*0.743
      rotate <0, -27.039, -2.956>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.914, 0.862, 0.845>
      translate x*0.397
      rotate <0, 14.574, -6.21>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.876, 0.824, 0.935>
      translate x*0.027
      rotate <0, -6.339, 4.596>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.906, 0.911, 0.927>
      translate x*0.359
      rotate <0, -5.687, -6.466>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.992, 0.914, 0.86>
      translate x*0.039
      rotate <0, 1.825, -3.963>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.979, 0.814, 0.995>
      translate x*0.634
      rotate <0, -4.001, -4.622>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.867, 0.98, 0.819>
      translate x*0.184
      rotate <0, -6.548, 8.555>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.999, 0.931, 0.971>
      translate x*0.416
      rotate <0, 12.348, -3.78>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.834, 0.893, 0.928>
      translate x*0.586
      rotate <0, -1.79, 11.299>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.874, 0.944, 0.813>
      translate x*0.531
      rotate <0, -13.566, -1.253>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.882, 0.948, 0.817>
      translate x*0.816
      rotate <0, 9.839, 6.445>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.836, 0.836, 0.98>
      translate x*0.915
      rotate <0, 8.099, 20.5>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.944, 0.832, 0.81>
      translate x*0.104
      rotate <0, 4.102, -6.735>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.951, 0.979, 0.998>
      translate x*0.225
      rotate <0, -3.743, -18.808>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.955, 0.981, 0.804>
      translate x*0.67
      rotate <0, 3.516, 4.163>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.92, 0.942, 0.826>
      translate x*0.85
      rotate <0, 11.338, -1.783>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.885, 0.847, 0.931>
      translate x*0.035
      rotate <0, 10.055, -4.333>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.944, 0.83, 0.859>
      translate x*0.809
      rotate <0, -3.927, 6.351>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.918, 0.929, 0.8>
      translate x*0.445
      rotate <0, -6.93, 7.326>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.989, 0.855, 0.964>
      translate x*0.29
      rotate <0, -7.159, -0.405>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.876, 0.964, 0.911>
      translate x*0.768
      rotate <0, 29.627, -0.511>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.937, 0.847, 0.886>
      translate x*0.811
      rotate <0, -4.193, 15.133>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.958, 0.859, 0.926>
      translate x*0.49
      rotate <0, 4.489, 10.938>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.86, 0.921, 0.916>
      translate x*0.267
      rotate <0, 6.058, -6.621>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.991, 0.845, 0.894>
      translate x*0.679
      rotate <0, -13.038, 11.335>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.998, 0.885, 0.863>
      translate x*0.348
      rotate <0, -0.042, 2.069>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.973, 0.92, 0.825>
      translate x*0.047
      rotate <0, -4.179, -6.542>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.981, 0.933, 0.929>
      translate x*0.077
      rotate <0, 6.947, -1.619>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.995, 0.804, 0.99>
      translate x*0.463
      rotate <0, 5.533, -7.803>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.978, 0.879, 0.81>
      translate x*0.463
      rotate <0, 6.997, -10.951>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.821, 0.928, 0.853>
      translate x*0.556
      rotate <0, -2.999, 23.269>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.806, 0.997, 0.936>
      translate x*0.516
      rotate <0, -0.051, 2.427>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.926, 0.802, 0.924>
      translate x*0.27
      rotate <0, -5.959, 0.634>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.987, 0.821, 0.872>
      translate x*0.126
      rotate <0, 16.937, 0.486>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.956, 0.992, 0.917>
      translate x*0.495
      rotate <0, -3.179, -14.435>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.886, 0.854, 0.889>
      translate x*0.535
      rotate <0, -5.863, -15.286>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.919, 0.925, 0.806>
      translate x*0.14
      rotate <0, 5.468, -1.644>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.824, 0.858, 0.833>
      translate x*0.422
      rotate <0, 11.045, -8.13>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.966, 0.877, 0.885>
      translate x*0.283
      rotate <0, -2.931, -2.368>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.98, 0.965, 0.989>
      translate x*0.825
      rotate <0, -2.492, -6.42>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.975, 0.849, 0.899>
      translate x*0.243
      rotate <0, 1.288, 2.216>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.893, 0.987, 0.979>
      translate x*0.41
      rotate <0, -12.275, 31.737>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.895, 0.991, 0.859>
      translate x*0.731
      rotate <0, -18.189, 12.547>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.88, 0.852, 0.895>
      translate x*0.828
      rotate <0, 13.438, 15.666>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.966, 0.983, 0.914>
      translate x*0.413
      rotate <0, 4.837, -29.4>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.867, 0.864, 0.987>
      translate x*0.155
      rotate <0, 6.538, 5.04>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.864, 0.916, 0.998>
      translate x*0.541
      rotate <0, 17.842, -8.726>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.858, 0.997, 0.826>
      translate x*0.667
      rotate <0, 3.288, 8.496>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.994, 0.804, 0.904>
      translate x*0.491
      rotate <0, -16.171, 0.237>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.836, 0.823, 0.956>
      translate x*0.44
      rotate <0, 0.4, 1.932>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.883, 0.961, 0.819>
      translate x*0.358
      rotate <0, -29.718, -4.831>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.827, 0.999, 0.847>
      translate x*0.516
      rotate <0, 7.173, 0.457>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.985, 0.867, 0.877>
      translate x*0.959
      rotate <0, 2.044, 5.401>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.814, 0.996, 0.876>
      translate x*0.653
      rotate <0, -20.083, -12.054>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.957, 0.863, 0.845>
      translate x*0.872
      rotate <0, 9.34, 6.893>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.929, 0.896, 0.84>
      translate x*0.877
      rotate <0, 2.881, 18.191>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.824, 0.804, 0.818>
      translate x*0.385
      rotate <0, 4.158, 19.534>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.921, 0.853, 0.831>
      translate x*0.351
      rotate <0, 5.893, 3.592>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.981, 0.906, 0.924>
      translate x*0.471
      rotate <0, -11.78, -28.269>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.826, 0.935, 0.868>
      translate x*0.3
      rotate <0, 6.954, -14.615>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.945, 0.806, 0.825>
      translate x*0.162
      rotate <0, 1.737, -8.743>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.924, 0.841, 0.836>
      translate x*0.992
      rotate <0, 13.977, -18.651>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.933, 0.988, 0.907>
      translate x*0.945
      rotate <0, -15.802, -12.684>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.822, 0.911, 0.813>
      translate x*0.016
      rotate <0, -2.083, 0.976>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.847, 0.884, 0.852>
      translate x*0.049
      rotate <0, 0.384, -13.193>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.851, 0.835, 0.821>
      translate x*0.356
      rotate <0, 19.483, -27.927>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.858, 0.907, 0.984>
      translate x*0.742
      rotate <0, -25.155, -18.244>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.898, 0.957, 0.818>
      translate x*0.007
      rotate <0, -14.325, -11.244>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.87, 0.82, 0.97>
      translate x*0.015
      rotate <0, -7.955, -5.134>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.978, 0.899, 0.838>
      translate x*0.13
      rotate <0, 18.353, 12.809>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.946, 0.999, 0.989>
      translate x*0.27
      rotate <0, 5.409, 8.178>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.965, 0.896, 0.801>
      translate x*0.99
      rotate <0, 11.054, -9.615>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.898, 0.9, 0.835>
      translate x*0.881
      rotate <0, 0.469, 5.799>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.874, 0.854, 0.814>
      translate x*0.174
      rotate <0, -7.715, 8.001>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.998, 0.988, 0.964>
      translate x*0.756
      rotate <0, -4.645, 3.664>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.833, 0.85, 0.964>
      translate x*0.837
      rotate <0, -20.494, 9.813>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.921, 0.926, 0.868>
      translate x*0.265
      rotate <0, -0.176, -6.694>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.818, 0.955, 0.942>
      translate x*0.965
      rotate <0, -5.986, -3.878>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.992, 0.989, 0.875>
      translate x*0.153
      rotate <0, 0.062, -3.396>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.803, 0.814, 0.986>
      translate x*0.914
      rotate <0, 0.968, 9.102>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.926, 0.815, 0.851>
      translate x*0.325
      rotate <0, 6.473, -9.529>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.89, 0.974, 0.997>
      translate x*0.708
      rotate <0, 12.746, -2.303>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.839, 0.932, 0.812>
      translate x*0.597
      rotate <0, 15.671, 18.453>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.974, 0.875, 1>
      translate x*0.85
      rotate <0, -12.121, -4.336>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.837, 0.886, 0.828>
      translate x*0.809
      rotate <0, -4.101, -15.781>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.818, 0.999, 0.905>
      translate x*0.637
      rotate <0, 3.756, -3.257>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.83, 0.923, 0.922>
      translate x*0.913
      rotate <0, -12.908, 7.889>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.967, 0.805, 0.863>
      translate x*0.23
      rotate <0, 11.348, 8.895>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.802, 0.921, 0.826>
      translate x*0.896
      rotate <0, -7.205, 12.187>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.905, 0.832, 0.837>
      translate x*0.974
      rotate <0, -1.865, -16.392>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.878, 0.844, 0.832>
      translate x*0.679
      rotate <0, -4.828, -4.617>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.968, 0.9, 0.808>
      translate x*0.711
      rotate <0, -0.513, 6.218>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.914, 0.918, 0.878>
      translate x*0.346
      rotate <0, 10.304, -6.013>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.916, 0.901, 0.939>
      translate x*0.082
      rotate <0, -7.304, -0.78>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.854, 0.879, 0.811>
      translate x*0.334
      rotate <0, -0.988, 4.173>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.989, 0.989, 0.986>
      translate x*0.072
      rotate <0, 13.889, -3.46>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.883, 0.82, 0.866>
      translate x*0.449
      rotate <0, -5.584, 28.892>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.836, 0.983, 0.812>
      translate x*0.28
      rotate <0, -19.964, 0.739>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.914, 0.874, 0.808>
      translate x*0.836
      rotate <0, -2.555, -8.352>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.849, 0.888, 0.987>
      translate x*0.678
      rotate <0, -11.727, 1.106>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.945, 0.941, 0.873>
      translate x*0.269
      rotate <0, 1.526, -4.088>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.995, 0.83, 0.811>
      translate x*0.838
      rotate <0, -13.242, -7.379>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.919, 0.838, 0.847>
      translate x*0.38
      rotate <0, -2.334, -0.872>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.969, 0.829, 0.861>
      translate x*0.882
      rotate <0, -2.72, -2.241>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.919, 0.953, 0.942>
      translate x*0.702
      rotate <0, 9.141, -7.71>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.863, 0.804, 0.895>
      translate x*0.653
      rotate <0, -0.16, 3.081>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.848, 0.872, 0.88>
      translate x*0.653
      rotate <0, 7.022, 6.062>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.885, 0.929, 0.912>
      translate x*0.844
      rotate <0, -0.578, 4.615>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.903, 0.985, 0.958>
      translate x*0.817
      rotate <0, 7.747, -9.604>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.809, 0.828, 0.903>
      translate x*0.093
      rotate <0, -14.828, -10.033>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.909, 0.829, 0.81>
      translate x*0.154
      rotate <0, 11.96, -7.371>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.988, 0.838, 0.988>
      translate x*0.278
      rotate <0, 14.199, 3.139>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.916, 0.877, 0.928>
      translate x*0.013
      rotate <0, 1.838, -2.972>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.933, 0.934, 0.977>
      translate x*0.52
      rotate <0, -1.763, 12.039>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.831, 0.815, 0.966>
      translate x*0.053
      rotate <0, 4.124, -17.262>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.968, 0.826, 0.955>
      translate x*0.629
      rotate <0, -10.645, -11.378>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.979, 0.941, 0.983>
      translate x*0.468
      rotate <0, 4.087, -4.878>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.863, 0.931, 0.815>
      translate x*0.993
      rotate <0, -9.039, 5.656>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.865, 0.816, 0.951>
      translate x*0.109
      rotate <0, 17.615, -4.557>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.883, 0.842, 0.855>
      translate x*0.168
      rotate <0, 6.307, 4.072>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.944, 0.892, 0.987>
      translate x*0.396
      rotate <0, -13.313, 3.868>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.819, 0.874, 0.858>
      translate x*0.638
      rotate <0, -1.291, 6.865>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.962, 0.965, 0.938>
      translate x*0.132
      rotate <0, -2.596, 12.762>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.953, 0.827, 0.855>
      translate x*0.521
      rotate <0, 19.718, 1.513>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.964, 0.866, 0.86>
      translate x*0.592
      rotate <0, 17.842, 5.231>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.845, 0.843, 0.923>
      translate x*0.198
      rotate <0, -12.56, 2.899>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.855, 0.939, 0.943>
      translate x*0.504
      rotate <0, 2.902, -0.099>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.956, 0.986, 0.881>
      translate x*0.117
      rotate <0, -4.765, -13.321>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.9, 0.823, 0.91>
      translate x*0.797
      rotate <0, 7.415, 12.877>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.916, 0.935, 0.966>
      translate x*0.266
      rotate <0, -2.979, 13.085>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.932, 0.988, 0.945>
      translate x*0.242
      rotate <0, 2.687, 1.881>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.956, 0.916, 0.836>
      translate x*0.067
      rotate <0, 13.378, 15.125>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.985, 0.833, 0.88>
      translate x*0.344
      rotate <0, 9.732, -4.494>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.8, 0.956, 0.883>
      translate x*0.68
      rotate <0, -7.302, -8.853>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.998, 0.905, 0.981>
      translate x*0.118
      rotate <0, -19.614, 16.581>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.842, 0.896, 0.91>
      translate x*0.965
      rotate <0, 3.583, 3.739>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.815, 0.946, 0.801>
      translate x*0.618
      rotate <0, 3.543, 2.597>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.802, 0.933, 0.848>
      translate x*0.603
      rotate <0, -11.286, -19.07>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.83, 0.82, 0.891>
      translate x*0.328
      rotate <0, 3.714, -7.824>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.988, 0.838, 0.872>
      translate x*0.115
      rotate <0, -15.589, -18.335>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.994, 0.94, 0.968>
      translate x*0.812
      rotate <0, 13.14, 0.547>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.863, 0.923, 0.888>
      translate x*0.779
      rotate <0, -11.901, -26.481>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.834, 0.933, 0.833>
      translate x*0.21
      rotate <0, 4.67, -3.011>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.929, 0.988, 0.852>
      translate x*0.689
      rotate <0, 5.904, 0.623>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.916, 0.865, 0.914>
      translate x*0.484
      rotate <0, -5.373, -4.77>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.939, 0.839, 0.994>
      translate x*0.458
      rotate <0, 2.598, 5.767>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.883, 0.881, 0.855>
      translate x*0.514
      rotate <0, -9.116, -14.254>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.954, 0.894, 0.908>
      translate x*0.303
      rotate <0, 10.1, 16.647>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.997, 0.857, 0.904>
      translate x*0.417
      rotate <0, -8.646, 8.952>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.937, 0.979, 0.872>
      translate x*0.507
      rotate <0, 8.771, -15.767>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.852, 0.837, 0.833>
      translate x*0.725
      rotate <0, -7.867, 2.237>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.92, 0.927, 0.879>
      translate x*0.524
      rotate <0, -6.296, -4.781>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.839, 0.945, 0.84>
      translate x*0.273
      rotate <0, 18.499, -4.183>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.927, 0.97, 0.822>
      translate x*0.186
      rotate <0, 8.241, 14.524>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.955, 0.843, 0.867>
      translate x*0.933
      rotate <0, 5.995, -9.616>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.986, 0.865, 0.826>
      translate x*0.802
      rotate <0, -7.08, 11.818>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.847, 0.934, 0.877>
      translate x*0.558
      rotate <0, -11.189, 7.499>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.921, 0.815, 0.867>
      translate x*0.105
      rotate <0, 0.098, 24.038>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.959, 0.874, 0.838>
      translate x*0.757
      rotate <0, -9.322, 29.72>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.955, 0.835, 0.964>
      translate x*0.326
      rotate <0, -1.57, -12.134>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.985, 0.884, 0.847>
      translate x*0.38
      rotate <0, -20.491, -14.582>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.911, 0.946, 0.805>
      translate x*0.861
      rotate <0, -2.536, 10.125>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.801, 0.943, 0.833>
      translate x*0.818
      rotate <0, 0.988, -0.739>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.944, 0.907, 0.968>
      translate x*0.307
      rotate <0, 4.537, -13.911>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.972, 0.853, 0.801>
      translate x*0.51
      rotate <0, 0.336, -16.676>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.891, 0.998, 0.908>
      translate x*0.84
      rotate <0, -7.788, 13.641>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.901, 0.931, 0.923>
      translate x*0.261
      rotate <0, 23.469, -10.198>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.871, 0.856, 0.98>
      translate x*0.189
      rotate <0, -11.538, -2.721>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.831, 0.846, 0.96>
      translate x*0.246
      rotate <0, -5.231, 16.289>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.93, 0.976, 0.953>
      translate x*0.708
      rotate <0, -0.165, -2.082>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.858, 0.854, 0.811>
      translate x*0.833
      rotate <0, -33.313, -11.398>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.852, 0.977, 0.996>
      translate x*0.28
      rotate <0, -0.205, 22.465>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.866, 0.829, 0.976>
      translate x*0.574
      rotate <0, -9.612, -7.9>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.828, 0.945, 0.889>
      translate x*0.064
      rotate <0, 4.485, 5.136>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.844, 0.866, 0.833>
      translate x*0.007
      rotate <0, -1.324, 0.489>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.825, 0.86, 0.938>
      translate x*0.314
      rotate <0, 0.107, 6.484>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.994, 0.939, 0.806>
      translate x*0.13
      rotate <0, 2.396, -10.936>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.826, 0.914, 0.845>
      translate x*0.781
      rotate <0, -3.845, 2.102>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.994, 0.893, 0.831>
      translate x*0.66
      rotate <0, -4.457, 17.366>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.888, 0.823, 0.918>
      translate x*0.436
      rotate <0, -7.288, -5.028>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.919, 0.968, 0.899>
      translate x*0.468
      rotate <0, 2.3, 4.217>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.896, 0.843, 0.969>
      translate x*0.514
      rotate <0, 16.025, -8.564>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.886, 0.801, 0.979>
      translate x*0.796
      rotate <0, -26.782, 4.116>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.855, 0.904, 0.984>
      translate x*0.118
      rotate <0, -13.409, -1.256>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.838, 0.84, 0.994>
      translate x*0.125
      rotate <0, -0.251, -24.064>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.894, 0.85, 0.809>
      translate x*0.891
      rotate <0, -6.042, 4.161>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.811, 0.996, 0.873>
      translate x*0.831
      rotate <0, 2.375, -3.072>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.931, 0.915, 0.853>
      translate x*0.49
      rotate <0, -1.532, -2.408>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.808, 0.965, 0.828>
      translate x*0.984
      rotate <0, -14.478, -15.036>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.876, 0.925, 0.927>
      translate x*0.87
      rotate <0, -9.84, -2.298>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.94, 0.961, 0.989>
      translate x*0.916
      rotate <0, 2.5, -9.982>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.803, 0.844, 0.937>
      translate x*0.609
      rotate <0, 9.048, -0.512>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.836, 0.977, 0.858>
      translate x*0.44
      rotate <0, 23.678, -14.166>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.89, 0.86, 0.852>
      translate x*0.786
      rotate <0, 0.994, -4.71>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.885, 0.825, 0.992>
      translate x*0.819
      rotate <0, 3.115, -5.242>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.85, 0.932, 0.948>
      translate x*0.145
      rotate <0, -6.598, -12.812>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.829, 0.961, 0.892>
      translate x*0.874
      rotate <0, -11.138, -7.295>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.936, 0.885, 0.868>
      translate x*0.556
      rotate <0, 12.941, 10.772>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.949, 0.864, 0.812>
      translate x*0.854
      rotate <0, -3.838, 19.217>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.974, 0.891, 0.99>
      translate x*0.997
      rotate <0, 1.518, 4.245>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.877, 0.856, 0.938>
      translate x*0.915
      rotate <0, -7.239, 23.602>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.984, 0.905, 0.94>
      translate x*0.578
      rotate <0, 4.731, 10.827>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.971, 0.839, 0.987>
      translate x*0.365
      rotate <0, 3.545, -19.901>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.944, 0.996, 0.846>
      translate x*0.333
      rotate <0, -10.999, -15.567>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.982, 0.947, 0.954>
      translate x*0.01
      rotate <0, -24.272, 19.06>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.971, 0.858, 0.877>
      translate x*0.792
      rotate <0, -6.378, 10.591>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.864, 0.865, 0.958>
      translate x*0.254
      rotate <0, 11.818, -8.902>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.959, 0.924, 0.944>
      translate x*0.56
      rotate <0, 21.934, -3.431>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.932, 0.938, 0.821>
      translate x*0.796
      rotate <0, 11.549, -0.818>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.86, 0.873, 0.83>
      translate x*0.423
      rotate <0, 5.839, 14.682>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.945, 0.911, 0.832>
      translate x*0.068
      rotate <0, -9.957, 7.648>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.935, 0.857, 0.91>
      translate x*0.709
      rotate <0, -8.108, -19.255>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.81, 0.912, 0.822>
      translate x*0.77
      rotate <0, -6.625, -8.911>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.872, 0.937, 0.828>
      translate x*0.901
      rotate <0, 7.164, 7.64>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.963, 0.843, 0.905>
      translate x*0.13
      rotate <0, 2.795, 4.09>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.999, 0.946, 0.81>
      translate x*0.762
      rotate <0, -18.884, -4.029>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.859, 0.87, 0.928>
      translate x*0.759
      rotate <0, 8.807, 14.792>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.977, 0.978, 0.851>
      translate x*0.451
      rotate <0, -2.311, 5.766>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.908, 0.888, 0.847>
      translate x*0.222
      rotate <0, -1.675, -0.764>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.912, 0.826, 0.981>
      translate x*0.389
      rotate <0, 17.838, -4.787>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.978, 0.954, 0.81>
      translate x*0.694
      rotate <0, -11.861, 19.463>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.964, 0.846, 0.938>
      translate x*0.863
      rotate <0, 6.72, -9.631>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.928, 0.844, 0.847>
      translate x*0.324
      rotate <0, 3.882, 2.345>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.901, 0.897, 0.945>
      translate x*0.62
      rotate <0, 1.765, 15.849>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.968, 0.86, 0.847>
      translate x*0.18
      rotate <0, 5.755, 10.107>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.968, 0.911, 0.834>
      translate x*0.94
      rotate <0, -0.16, -1.577>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.827, 0.913, 0.824>
      translate x*0.894
      rotate <0, -15.813, 11.505>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.817, 0.859, 0.907>
      translate x*0.942
      rotate <0, 3.724, -6.475>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.816, 0.926, 0.855>
      translate x*0.375
      rotate <0, 22.685, 4.651>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.977, 0.964, 0.871>
      translate x*0.115
      rotate <0, -1.873, -13.378>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.864, 0.874, 0.992>
      translate x*0.214
      rotate <0, 11.068, -7.582>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.905, 0.81, 0.948>
      translate x*0.318
      rotate <0, 3.452, 3.417>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.928, 0.808, 0.824>
      translate x*0.658
      rotate <0, 6.314, 13.433>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.995, 0.931, 0.991>
      translate x*0.75
      rotate <0, 1.531, -3.146>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.939, 0.887, 0.898>
      translate x*0.266
      rotate <0, 24.246, -18.406>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.893, 0.997, 0.801>
      translate x*0.634
      rotate <0, 13.554, 4.902>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.997, 0.843, 0.971>
      translate x*0.612
      rotate <0, -4.75, 17.098>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.982, 0.894, 0.997>
      translate x*0.607
      rotate <0, 4.402, -12.931>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.874, 0.834, 0.811>
      translate x*0.678
      rotate <0, -0.718, -10.052>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.902, 0.927, 0.907>
      translate x*0.073
      rotate <0, -10.389, 13.634>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.826, 0.985, 0.999>
      translate x*0.79
      rotate <0, 13.346, 2.897>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.856, 0.917, 0.949>
      translate x*0.998
      rotate <0, 7.18, -12.443>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.893, 0.886, 0.976>
      translate x*0.213
      rotate <0, 6.681, -5.19>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.87, 0.942, 0.869>
      translate x*0.914
      rotate <0, 6.444, -6.974>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.979, 0.837, 0.87>
      translate x*0.803
      rotate <0, 12.88, -0.598>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.866, 0.987, 0.994>
      translate x*0.108
      rotate <0, 12.233, 6.636>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.982, 0.815, 0.837>
      translate x*0.304
      rotate <0, 6.142, -15.667>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.998, 0.948, 0.985>
      translate x*0.255
      rotate <0, -7.466, -6.864>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.985, 0.858, 0.991>
      translate x*0.189
      rotate <0, -21.108, -10.384>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.834, 0.961, 0.929>
      translate x*0.991
      rotate <0, 3.867, 21.743>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.855, 0.927, 0.909>
      translate x*0.146
      rotate <0, 11.98, -5.686>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.91, 1, 0.97>
      translate x*0.162
      rotate <0, -5.393, -15.033>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.984, 0.857, 0.913>
      translate x*0.595
      rotate <0, -21.325, 2.497>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.961, 0.816, 0.807>
      translate x*0.754
      rotate <0, -3.531, -4.066>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.804, 0.939, 0.82>
      translate x*0.843
      rotate <0, -18.31, 5.417>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.835, 0.852, 0.966>
      translate x*0.748
      rotate <0, 0.36, 14.163>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.913, 0.87, 0.837>
      translate x*0.759
      rotate <0, 0.423, -13.116>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.905, 0.918, 0.875>
      translate x*0.399
      rotate <0, 18.832, 15.78>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.949, 0.884, 0.816>
      translate x*0.091
      rotate <0, -20.323, 0.801>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.899, 0.96, 0.938>
      translate x*0.673
      rotate <0, -20.645, 2.118>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.938, 0.921, 0.834>
      translate x*0.783
      rotate <0, 1.035, 19.831>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.826, 0.992, 0.952>
      translate x*0.857
      rotate <0, 10.615, 10.688>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.973, 0.949, 0.819>
      translate x*0.928
      rotate <0, -19.862, -7.838>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.851, 0.848, 0.953>
      translate x*0.571
      rotate <0, -13.933, -1.511>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.824, 0.968, 0.878>
      translate x*0.22
      rotate <0, -4.925, -2.653>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.894, 0.903, 0.939>
      translate x*0.687
      rotate <0, -9.032, 13.611>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.858, 0.952, 0.958>
      translate x*0.025
      rotate <0, 17.099, -9.826>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.886, 0.93, 0.851>
      translate x*0.903
      rotate <0, 13.085, -14.882>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.956, 0.927, 0.991>
      translate x*0.452
      rotate <0, -7.107, -16.455>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.974, 0.944, 0.971>
      translate x*0.957
      rotate <0, -4.68, -20.829>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.909, 0.948, 0.854>
      translate x*0.029
      rotate <0, -2.389, 3.335>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.903, 0.889, 0.803>
      translate x*0.739
      rotate <0, 2.468, -0.645>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.892, 0.885, 0.997>
      translate x*0.874
      rotate <0, -8.106, -17.811>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.971, 0.936, 0.905>
      translate x*0.795
      rotate <0, -3.692, 11.19>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.973, 0.866, 0.967>
      translate x*0.462
      rotate <0, -5.897, 29.229>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.875, 0.922, 0.847>
      translate x*0.959
      rotate <0, 27.269, 0.789>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.974, 0.996, 0.987>
      translate x*0.378
      rotate <0, 20.968, -5.344>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.95, 0.833, 0.84>
      translate x*0.124
      rotate <0, 0.876, -8.374>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.947, 0.891, 0.908>
      translate x*0.664
      rotate <0, -4.113, -9.817>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.831, 0.932, 0.925>
      translate x*0.386
      rotate <0, 7.199, 9.393>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.863, 0.96, 0.802>
      translate x*0.635
      rotate <0, -13.922, 4.302>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.915, 0.94, 0.977>
      translate x*0.064
      rotate <0, -12.478, 2.911>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.887, 0.865, 0.813>
      translate x*0.289
      rotate <0, -4.178, -2.666>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.969, 0.989, 0.892>
      translate x*0.34
      rotate <0, 2.456, -0.94>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.938, 0.984, 0.824>
      translate x*0.679
      rotate <0, 0.998, 7.232>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.964, 0.832, 0.921>
      translate x*0.515
      rotate <0, -16.296, -28.298>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.803, 0.83, 0.873>
      translate x*0.858
      rotate <0, 16.138, 31.111>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.973, 0.944, 0.824>
      translate x*0.124
      rotate <0, -18.288, 2.561>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.816, 0.927, 0.971>
      translate x*0.294
      rotate <0, 15.218, 5.476>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.91, 0.89, 0.906>
      translate x*0.416
      rotate <0, -4.594, -13.966>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.848, 0.806, 0.935>
      translate x*0.849
      rotate <0, 1.406, -1.894>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.86, 0.903, 0.901>
      translate x*0.928
      rotate <0, -11.748, -4.102>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.937, 0.93, 0.82>
      translate x*0.703
      rotate <0, -1.012, -1.425>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.867, 0.941, 0.871>
      translate x*0.174
      rotate <0, -7.151, 1.882>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.804, 0.897, 0.853>
      translate x*0.854
      rotate <0, 10.677, -3.632>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.834, 0.863, 0.99>
      translate x*0.665
      rotate <0, -3.73, -5.929>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.873, 0.832, 0.929>
      translate x*0.049
      rotate <0, 13.541, 9.57>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.905, 0.907, 0.868>
      translate x*0.781
      rotate <0, 24.375, -16.878>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.953, 0.833, 0.912>
      translate x*0.276
      rotate <0, 0.765, -2.908>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.869, 0.997, 0.803>
      translate x*0.23
      rotate <0, -2.678, -13.759>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.891, 0.862, 0.872>
      translate x*0.187
      rotate <0, -1.55, -10.6>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.878, 0.964, 0.899>
      translate x*0.089
      rotate <0, -9.529, 6.911>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.854, 0.85, 0.807>
      translate x*0.075
      rotate <0, 4.696, -1.278>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.902, 0.91, 0.946>
      translate x*0.683
      rotate <0, 4.935, -1.684>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.858, 0.922, 0.892>
      translate x*0.27
      rotate <0, -3.844, -16.3>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.913, 0.907, 0.901>
      translate x*0.78
      rotate <0, 1.959, -1.539>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.896, 0.993, 0.887>
      translate x*0.079
      rotate <0, 21.308, 5.451>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.943, 0.944, 0.959>
      translate x*0.866
      rotate <0, -10.624, 6.924>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.983, 0.949, 0.861>
      translate x*0.643
      rotate <0, 21.645, 34.014>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.871, 0.828, 0.964>
      translate x*0.494
      rotate <0, 2.339, 19.228>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.962, 0.964, 0.957>
      translate x*0.329
      rotate <0, -11.991, 10.14>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.813, 0.847, 0.837>
      translate x*0.934
      rotate <0, -5.435, 4.805>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.909, 0.865, 0.852>
      translate x*0.528
      rotate <0, -2.713, -6.59>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.871, 0.997, 0.881>
      translate x*0.648
      rotate <0, 10.289, 4.5>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.868, 0.997, 0.945>
      translate x*0.983
      rotate <0, -7.31, -6.369>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.988, 0.895, 0.936>
      translate x*0.318
      rotate <0, -6.836, -10.393>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.845, 0.805, 0.822>
      translate x*0.016
      rotate <0, 4.825, 0.497>
   }
   
   sphere {
      <0, 0, 0>, 0.001
      scale <3.993, 0.857, 0.94>
      translate x*0.422
      rotate <0, 10.321, 6.395>
   }
}

sky_sphere {
   pigment {
      color rgbt <0.0039216, 0.015686, 0.086275, 1>
   }
   
   pigment {
      Sterne
   }
   
   pigment {
      bozo
      turbulence <0.1, 0, 0.1>
      
      color_map {
         [ 0 color rgbt <0.0039216, 0.015686, 0.086275, 1>
         ]
         [ 0.1 color rgb <0.00392157, 0.0156863, 0.0862745>
         ]
         [ 0.5 color rgb <0.00392157, 0.0156863, 0.0862745>
         ]
         [ 0.5 color rgbt <0.0039216, 0.015686, 0.086275, 1>
         ]
         [ 0.6 color rgb <0.00392157, 0.0156863, 0.0862745>
         ]
         [ 1 color rgb <0.00392157, 0.0156863, 0.0862745>
         ]
      }
      scale 0.01
   }
}

sphere {
   //*PMName Mond
   <0, 0, 0>, 0.5
   
   texture {
      finish {
         ambient rgb <0.909804, 0.894118, 0.85098>
      }
      
      pigment {
         granite
         
         color_map {
            [ 0 color rgb <0.909804, 0.905882, 0.870588>
            ]
            [ 1 color rgb <0.309804, 0.309804, 0.309804>
            ]
         }
      }
   }
   scale 3000
   scale <1, 0.9, 1>
   rotate z*(-45)
   translate <-800, 6900, 28000>
}

object {
   //*PMName Baum
   Baum
   scale <25, 30, 25>
   rotate y*80
   translate <-250, -2, 400>
}

object {
   //*PMName Baum
   Baum
   scale <25, 30, 25>
   rotate y*80
   translate <-5, -3, 5>
   translate <-250, -2, 400>
   
   texture {
      Glanzparenz
   }
}

object {
   //*PMName Giraffe
   Giraffe
   scale 30
   rotate y*10
   translate <-170, 80, 310>
}

object {
   //*PMName Tropfen
   Tropfen
   scale 400
   rotate y*70
   translate <-162.621, 36.0999, 312.066>
   
   texture {
      finish {
         phong 0.7
         phong_size 40
         reflection rgb <0.486275, 0.486275, 0.486275>
      }
      
      pigment {
         color rgbf <0.97255, 0, 0, 0.5>
      }
   }
}

object {
   //*PMName Stdzeiger
   Stundenzeiger2
   scale 50
   rotate <90, 133, 0>
   translate <-250, -30, 400>
}

object {
   //*PMName Weckzeiger
   Weckzeiger2
   scale 50
   rotate <90, 133, 0>
   translate <-250, -40, 400>
}

object {
   //*PMName Minutenzeiger
   Minutenzeiger2
   scale 50
   rotate <90, 12.9, 0>
   translate <-250, -20, 400>
}

object {
   //*PMName Pillenpackung
   Pillenpackung
   scale 10
   rotate <-10, 50, 0>
   translate <-99.6069, 0, 170.582>
}

object {
   //*PMName Pille
   Pille
   scale 4
   rotate <-10, -0, -7.1>
   translate <-135.3, 65.2561, -1.1>
   
   texture {
      finish {
         ambient rgb <0.666667, 0.666667, 0.666667>
         diffuse 0.9
         specular 0.6
         roughness 0.2
      }
      
      pigment {
         bozo
         
         color_map {
            [ 0 color rgbf <1, 1, 1, 0.5>
            ]
            [ 0.4 color rgbf <1, 1, 1, 0.5>
            ]
            [ 0.9 color rgbf <0.011765, 0.011765, 0.011765, 0.5>
            ]
            [ 1 color rgbf <0.011765, 0.011765, 0.011765, 0.5>
            ]
         }
         scale 0.2
      }
   }
}

object {
   //*PMName Wecker
   Wecker
   scale 5
   rotate y*(-30)
   translate <-179.053, 0, 110.551>
}

union {
   //*PMName Landschaft
   
   difference {
      //*PMName Erde
      
      union {
         plane {
            //*PMName Erde
            <0, 1, 0>, 0
            scale <10000, 1, 10000>
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         object {
            //*PMName Zeitskala2
            Zeitskala2
            rotate x*90
            scale <70, 10, 70>
            translate <-250, 0.01, 400>
         }
      }
      
      object {
         //*PMName Risse
         Risse
         rotate z*90
         rotate y*60
         scale <30, 1, 30>
         translate <-160, 1, 315>
         
         pigment {
            color rgb <0, 0, 0>
         }
      }
      
      box {
         <-0.5, -0.5, -0.5>, <0.5, 0.5, 0.5>
         scale <50, 60, 50>
         rotate <-8.5, 9.9, -1.5>
         scale <0.8, 1, 1>
         translate <-162.46, -20, 320.399>
         
         pigment {
            color rgb <0, 0, 0>
         }
      }
      
      box {
         <-0.5, -0.5, -0.5>, <0.5, 0.5, 0.5>
         scale <50, 60, 50>
         rotate <-8.5, 44, -1.5>
         scale <0.3, 1, 1>
         translate <-162.46, -20, 320.399>
         
         pigment {
            color rgb <0, 0, 0>
         }
      }
   }
   
   object {
      //*PMName Haus
      Haus
      scale 1
      rotate y*(-10)
      translate <-5000, 0, 9600>
   }
   
   object {
      //*PMName Haus
      Haus
      scale 1
      rotate y*(-5)
      translate <-9000, 0, 12000>
   }
   
   object {
      //*PMName Haus
      Haus
      scale 1
      rotate y*12
      translate <2000, 0, 18000>
   }
   
   texture {
      finish {
         ambient rgb <0.141176, 0.141176, 0.141176>
         diffuse 0.8
         specular 0.3
         roughness 0.1
      }
      
      pigment {
         color rgb <0.141176, 0.117647, 0.392157>
      }
   }
}

union {
   //*PMName Bett
   
   superellipsoid {
      <0.5, 0.05>
      rotate x*90
      scale <3, 35, 3>
      
      texture {
         Kiefernholz
         rotate <90, 10, 0>
      }
      translate <-45, 35, 100>
   }
   
   superellipsoid {
      <0.5, 0.05>
      rotate x*90
      scale <3, 35, 3>
      
      texture {
         Kiefernholz
         rotate <90, 8, 0>
         translate <15, 0, 2>
      }
      translate <45, 35, 100>
   }
   
   union {
      box {
         <-45, 0, -1>, <45, 15, 1>
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      cylinder {
         <-44, 0, 0>, <44, 0, 0>, 1
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      cylinder {
         <-44, 15, 0>, <44, 15, 0>, 1
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      texture {
         Kiefernholz
         rotate <0, 90.5, 0.5>
      }
      translate <0, 45, 100>
   }
   
   box {
      <-1, 0, -100>, <1, 30, 100>
      
      texture {
         Kiefernholz
      }
      scale 1
      rotate <0, 0, 0>
      translate <-45, 25, 0>
   }
   
   object {
      //*PMName Kissen
      Kissen
      scale 20
      rotate <0, 0, 0>
      translate <-43.465, 50, 37.796>
   }
   translate <-110, 0, -90>
}

light_source {
   <-742.83, 6867.5, 25963>, rgb <1, 1, 1>
   spotlight
   radius 10
   falloff 70
   point_at <-131.65, 90.219, 28.469>
   area_light <1000, 0, 100>, <0, 1000, -200>, 2, 2
}

camera {
   perspective
   location <-103.996, 94.1718, -43.2244>
   sky <0, 1, 0>
   direction <0, 0, 1>
   right <1.33333, 0, 0>
   up <0, 1, 0>
   look_at <-135.95, 86.2936, 28.6576>
}