#declare image_width_Old = 2048; 

#declare g_red           = 1.0;
#declare g_green         = 1.0;
#declare g_blue          = 1.0; 

global_settings {assumed_gamma 2.2}

camera {
        orthographic
        location <0,0,-2>
        look_at 0
        right x*image_width
        up y*image_height
}

#declare image_ratio = image_width/image_height;
#declare image_height_Old = image_width_Old/image_ratio;
#declare mosaic_pixel = image_width_Old/image_width;
#declare pixels = mosaic_pixel*mosaic_pixel;

#declare xmin_col = <1,1,1>;
#declare xmax_col = <0,0,0>;
#declare ymin_col = <1,1,1>;
#declare ymax_col = <0,0,0>;
#declare zmin_col = <1,1,1>;
#declare zmax_col = <0,0,0>;

#declare pig_map = function {pigment {image_map {png "discovery"} translate -0.5 scale <image_width_Old,image_height_Old,1>}}
#declare nx = 0;
#while (nx < image_width)
        #declare ny = 0;
        #while (ny < image_height)
                #declare color_sum = 0;
                #declare mx = 0;
                #while (mx < mosaic_pixel)                        
                        #declare my = 0;
                        #while (my < mosaic_pixel)                
                                #declare X = mx+nx*mosaic_pixel-image_width_Old*0.5+0.5;
                                #declare Y = my+ny*mosaic_pixel-image_height_Old*0.5+0.5;
                                #declare color_sum = color_sum+(pig_map(X,Y,0));
                                #declare my = my+1;
                        #end
                        #declare mx = mx+1;
                #end
                #declare pixel_color = color_sum/pixels;
                #if (pixel_color.x < xmin_col.x) #declare xmin_col = pixel_color; #end
                #if (pixel_color.x > xmax_col.x) #declare xmax_col = pixel_color; #end
                #if (pixel_color.y < ymin_col.y) #declare ymin_col = pixel_color; #end
                #if (pixel_color.y > ymax_col.y) #declare ymax_col = pixel_color; #end
                #if (pixel_color.z < zmin_col.z) #declare zmin_col = pixel_color; #end
                #if (pixel_color.z > zmax_col.z) #declare zmax_col = pixel_color; #end
                #declare ny = ny+1;
        #end
        #declare nx = nx+1;
        #debug concat(str(nx,0,0)," columns preprocessed \n")
#end

#declare min_col = <xmin_col.x,ymin_col.y,zmin_col.z>;
#declare max_col = <xmax_col.x,ymax_col.y,zmax_col.z>;
#declare col_diff = max_col-min_col;
#declare mean_col = col_diff*0.5+min_col; 

#declare nx = 0;
#while (nx < image_width)
        #declare ny = 0;
        #while (ny < image_height)
                #declare color_sum = 0;
                #declare mx = 0;
                #while (mx < mosaic_pixel)                        
                        #declare my = 0;
                        #while (my < mosaic_pixel)                
                                #declare X = mx+nx*mosaic_pixel-image_width_Old*0.5+0.5;
                                #declare Y = my+ny*mosaic_pixel-image_height_Old*0.5+0.5;
                                #declare color_sum = color_sum+(pig_map(X,Y,0));
                                #declare my = my+1;
                        #end
                        #declare mx = mx+1;
                #end
                #declare pixel_col = color_sum/pixels;     
                #declare pixel_color = (pixel_col-mean_col+0.5)/col_diff; 
                box {
                        0 1
                        pigment {color rgb <pow(pixel_color.x,g_red),pow(pixel_color.y,g_green),pow(pixel_color.z,g_blue)>}
                        finish {ambient 1 diffuse 0}
                        translate <nx-image_width*0.5,ny-image_height*0.5,0>
                }
                #declare ny = ny+1;
        #end
        #declare nx = nx+1;
        #debug concat(str(nx,0,0)," columns processed \n")
#end