global_settings {noise_generator 2}
#include "functions.inc"        
        
#declare ftname = "stone2.inc"
#warning concat (ftname," stone1 file creation start\n")
#fopen filehandle ftname write

#declare amb = 0;

#declare default_normal =
normal {
	average 
	normal_map {
                [bumps 1.4 warp {turbulence 1} scale 0.03]
                [bumps 1 warp {turbulence 0.5} scale 0.0003]
        }
}  

#declare hfscalx = 1;
#declare hfscaly = 0.2;
#declare hfscalz = 1;

#declare hftranx = 0+0.5*hfscalx;
#declare hftrany = 0+0.5*hfscaly;
#declare hftranz = 0+0.5*hfscalz;


#declare File = 1;

//___________________________________________________________________________

#declare RX=2;
#declare RY=0.5;
#declare stone1 = 
isosurface{
        function{
                f_sphere(x,y,z, RY)
                +f_granite(x*0.3,y*0.3,z*0.3)*0.4
                -f_granite(x*0.05,y*0.05,z*0.05+RX)
        }
        contained_by{sphere{0,RY*2}}
        max_gradient 3     
        scale 0.001
}

#if (File = 0) 
        #declare stone1 = sphere {<0,0,0> 0.0001 scale <0.3,1,0.3> pigment {color rgb <1,0,0>}}
#end

//___________________________________________________________________________

#if (File = 0) 
#declare Land = height_field {tga "moon" smooth translate -0.5 scale <hfscalx,hfscaly,hfscalz>}                             //heightfield

#local rfac = 97698*200;
#local eR = seed(60410+rfac*3);  
#local eR2 = seed(30195+rfac*565);
#local eR3 = seed(27419+rfac*9);

#macro stone_macro (G1,G2,Gnum,Maxheight,DispObject)

#local V = 0;
union {
        #local GW = G2.x-G1.x;
        #local GD = G2.y-G1.y;
        #while(V < Gnum)
                #local X = rand(eR)*GW;
                #local Z = rand(eR)*GD;                      
                #local Norm = <X+G1.x,0,Z+G1.y>;
                #local Start = <X+G1.x,Maxheight,Z+G1.y>;
                #local Inter = trace(DispObject,Start,Norm-Start,Norm);
                #if (Norm.x != 0|Norm.y != 0|Norm.z != 0)      
                        #if (pow(atan2(Norm.x,Norm.y),2)+pow(atan2(Norm.z,Norm.y),2)*pow(rand(eR3),2)*2 < 0.4) 
                                #local ab = (0.1+pow(rand(eR3),3)*14)/7.1;
                                #local ac = 360*rand(eR);
                                #local ad = 360*rand(eR2);//+0.3*degrees(atan2(Norm.z,Norm.y));
                                #local ae = 360*rand(eR2);//-0.3*degrees(atan2(Norm.x,Norm.y));
                                #local af = X+G1.x;
                                #local ag = Inter.y;
                                #local ah = Z+G1.y;
                                object {stone1
                                        scale ab
                                        rotate y*ac
                                        rotate z*ad
                                        rotate x*ae
                                        translate <af,ag,ah>
                                        #write (filehandle,"object {stone1 scale ",ab," rotate y*",ac," rotate <",ad,",0,",ae,"> translate <",af+hftranx-RY*0.0005*ab,",",ag+hftrany,",",ah+hftranz,"> } // ",V+1,"\n")
                                }
                        #else
                                #local V = V-1; 
                        #end
                        #local V = V+1;
                        #if(mod(V,10)=0)
                                #debug concat(str(V,0,0)," stone1 placed.\n")
                        #end        
                #end      
        #end
}
#end  

stone_macro (<hfscalx*-1,hfscalz*-1>,<hfscalx,hfscalz>,10000,hfscaly*0.5+hftrany+0.01+10,Land)
#end

//__________________________________________________________

union {
        object {  
                height_field {
                        tga "moon"
                        water_level 0.0
                        smooth
                }
        }
        union {
                #include "stone4.inc"
                scale <1/hfscalx,1/hfscaly,1/hfscalz>
                texture {  
                        pigment {rgb 0.7}
                        normal {
                                average
                                normal_map {
                                        [       
                                                bumps 0.7
                                                warp {turbulence 1}
                                                scale 0.001
                                        ]
                                        [
                                                bumps 0.5
                                                warp {turbulence 0.5}
                                                scale 0.000005
                                        ]
                                }
                        }
                        finish {ambient 0 diffuse 0.3}       
                }
        }
        rotate    <-90, 0, 0> 
        scale     <  2, 2,-2> 
        translate < -1,-1,-1>
        scale <10,10,2>
        rotate -3.0*y
        translate  <0.511301,-0.965913,-1.532159>
        texture {  
                pigment {rgb 0.7}
                normal {
                        average
                        normal_map {
                                [       
                                        bumps 0.7
                                        warp {turbulence 1}
                                        scale 0.001
                                ]
                                [
                                        bumps 0.5
                                        warp {turbulence 0.5}
                                        scale 0.000005
                                ]
                        }
                }
                finish {ambient 0 diffuse 0.24}       
        }
}

//__________________________________________________________

camera {  
        location  <  13.098,  0.111,  1.969>
        direction <     0.0,    0.0, 1.6095> 
        sky       <-0.00673,0.34135,0.93991> 
        up        <     0.0,    0.0,    1.0> 
        right     < 1.33333,    0.0,    0.0> 
        look_at   <  -4.039, -0.409,  0.936>
}

light_source {
        <10000,-20000,15000> 
        color rgb 5   
} 