global_settings {
        #declare a_g = 1.4;
        assumed_gamma a_g
        max_trace_level 15
}

#include "functions.inc"        
#include "VenusStone_mesh.inc"
        
#declare ftname = "stoneVenus.inc"
#warning concat (ftname," stoneVenus file creation start\n")
#fopen filehandle ftname write

#declare amb = 0;

#declare default_normal =
normal {
	average 
	normal_map {
                [bumps 1.4 warp {turbulence 1} scale 0.03]
                [bumps 1 warp {turbulence 0.5} scale 0.0003]
        }
}  

#declare hfscalx = 25;
#declare hfscaly = 25;
#declare hfscalz = 25;

#declare hftranx = 0;
#declare hftrany = 0;
#declare hftranz = 0;


#declare File = 0;

//___________________________________________________________________________

#declare RX=1;
#declare RY=0.5;

#declare stoneVenus = 
isosurface{
        function{
                f_sphere(x,y,z, RY)
                +f_granite(x*0.3,y*0.3,z*0.3)*0.4
                -f_granite(x*0.05,y*0.05,z*0.05+RX)
        }
        contained_by{sphere{0,RY*2}}
        max_gradient 3     
        scale 0.015
}

#if (File = 0) 
        #declare stoneVenus = sphere {<0,0,0> 0.00001 scale <0.3,1,0.3> pigment {color rgb <1,0,0>}}
#end

//___________________________________________________________________________

#if (File = 0) 
#declare Land = object {venus}                          

#local rfac = 97698*1;
#local eR = seed(60410+rfac*3);  
#local eR2 = seed(30195+rfac*565);
#local eR3 = seed(27419+rfac*9);

#macro stone_macro (G1,G2,Gnum,Maxheight,DispObject)

#local V = 0;
union {
        #local GW = G2.x-G1.x;
        #local GD = G2.y-G1.y;
        #while(V < Gnum)
                #local X = rand(eR)*GW;
                #local Z = rand(eR)*GD;                      
                #local Norm = <X+G1.x,0,Z+G1.y>;
                #local Start = <X+G1.x,Maxheight,Z+G1.y>;
                #local Inter = trace(DispObject,Start,Norm-Start,Norm);
                #if (Norm.x != 0|Norm.y != 0|Norm.z != 0)               
                        #if (pow(atan2(Norm.x,Norm.y),2)+pow(atan2(Norm.z,Norm.y),2)*pow(rand(eR3),2)*2 < 0.5)  // wenn wahrscheinlich nicht zu steil
                                #local ab = (0.1+rand(eR3)*4)/2.1;
                                #local ac = 360*rand(eR);
                                #local ad = 360*rand(eR2);
                                #local ae = 360*rand(eR2);
                                #local af = X+G1.x;
                                #local ag = Inter.y;
                                #local ah = Z+G1.y;
                                object {stoneVenus
                                        scale ab
                                        rotate y*ac
                                        rotate z*ad
                                        rotate x*ae
                                        translate <af,ag,ah>
                                        #write (filehandle,"object {stoneVenus scale ",ab," rotate y*",ac," rotate <",ad,",0,",ae,"> translate <",af+hftranx,",",ag+hftrany,",",ah+hftranz,"> } // ",V+1,"\n")
                                }
                        #else
                                #local V = V-1; 
                        #end
                        #local V = V+1;
                        ///*
                        #if(mod(V,10)=0)
                                #debug concat(str(V,0,0)," stoneVenus placed.\n")
                        #end
                        //*/              
                #end    
        #end
}
#end  

stone_macro (<hfscalx*-1,hfscalz*-1>,<hfscalx,hfscalz>,20000,hfscaly*0.5+hftrany+0.01+10,Land)
#end

//__________________________________________________________

#declare venus =
union {
        object {venusMesh rotate -30*y texture {Tex}}
        union {
                #include "stoneVenus2.inc"
                texture {  
                        pigment {rgb 0.7}
                        normal {
                                average
                                normal_map {
                                        [       
                                                bumps 0.7
                                                warp {turbulence 1}
                                                scale 0.001
                                        ]
                                        [
                                                bumps 0.5
                                                warp {turbulence 0.5}
                                                scale 0.000005
                                        ]
                                }
                        }
                        finish {ambient 0 diffuse 0.3}       
                }
        }
}

object {
        venus
        scale <-1,1,1>*0.37
        Reorient_Trans(<0,5,-35>,<13.098+4.039,0.111+0.409,1.969-0.936>)
        rotate x*60
        rotate y*-15
        translate <-5.6,-1.9,-2.3>        
}

//__________________________________________________________

///*
camera {  
        location  <  13.098,  0.111,  1.969>
        direction <     0.0,    0.0, 1.6095> 
        sky       <-0.00673,0.34135,0.93991> 
        up        <     0.0,    0.0,    1.0> 
        right     < 1.33333,    0.0,    0.0> 
        look_at   <  -4.039, -0.409,  0.936>
}

light_source {
        <10000,-20000,15000> 
        color rgb 5   
}
//*/
/*
camera {
        orthographic 
        location  <0, 25,0>
        direction <0, 1.5, 0>
        up        <0, 0, 18>
        right     <24, 0, 0>
        look_at 0
}

#declare lights = <80000,150000,-5000>;
light_source {
        lights,
        <1,0.836,0.567>*7 
}
*/  