//1024x678 aa 0.3

#version 3.5; 

#include "colors.inc"      
#include "units.inc"
#include "stones.inc"
#include "metals.inc"
#include "woods.inc"
#include "functions.inc" 


#macro Rotate_Around_Trans(Rotation, Point)
   transform {
      translate -Point
      rotate Rotation
      translate Point
   }
#end

#declare BuildingTex=  
material {
          texture { T_Wood10 
          normal{crackle 50 scale .05 }
          finish{ambient .2 diffuse .5} 
         } 
} 

#declare fn_Pigm=function {
    pigment {
      agate
      color_map {
        [0 color rgb 0]
        [1 color rgb 1]
      }
    }
  }

#declare Isosfc1 = 
isosurface {
    function { f_rounded_box(x,y,z, .8, 1, 1, 1) - fn_Pigm(x, y, z).gray*.5}

    contained_by { box { -1, 1 } } 
    max_gradient 10.996                 
    texture{T_Stone8 scale .8}
  } 

#declare Isosfc2 = 
isosurface {
    function { f_rounded_box(x,y,z, .8, 1, 1, 1) - fn_Pigm(x, y, z).gray*.5}

    contained_by { box { -1, 1 } } 
    max_gradient 9.932                 
  } 

#declare PreTrace = 1;
#declare R1 = seed(34534);
#declare TREES = true;
#include "DOH_Ground.inc"

#declare CloudBrightness1 = .8;
#declare CloudScale1 = 20;
#declare CloudScale2 = 150;
#declare High_MSamples = false;
#declare CloudLocation1 = <-400 * Feet, 200 * Feet, 2500 * Feet>;  
#declare CloudLocation2 = <-7500 * Feet, 50 * Feet, 22000 * Feet>;
#declare CloudLocation3 =  <1800 * Feet, 300 * Feet, 10000 * Feet>; 
#declare LanternLoc =  <20 * Feet,198 * Feet, -10 * Feet>; 
#declare ChimesLoc = <-20 * Feet,198.5 * Feet, -8 * Feet>;

#include "DOH_Cities.inc"

     

#global_settings{assumed_gamma 1  
                 max_trace_level 100
}
                 
camera {
   location <0 * Feet,200 * Feet,-50 * Feet> //z was -20 y was 200
   up       y
   right    x
   angle    65
   look_at  <0 * Feet,195 * Feet,200 * Feet>  //x was -20  y was 170
} 

//global light               
light_source {
              <1000 * Feet,850 * Feet,-300 * Feet>    
              color rgb <1,1,1>  * 3  //3 
              media_interaction off
              media_attenuation off
} 

//fill light
light_source {
              <0 * Feet,216 * Feet,25 * Feet>   
              color rgb  <1,.5,.5> * .3 shadowless  //.3      
              media_interaction off
              media_attenuation off
} 


//lantern light
light_source {
              <30 * Feet,210 * Feet,-30 * Feet>   
              color rgb <1,1,1> * 2  //<1,.25,0> 
              spotlight
              point_at LanternLoc 
              radius    8 
              falloff   9 
              tightness 100                                            
              fade_distance 30 * Feet
              fade_power 2
              media_interaction off
              media_attenuation off
}
      

sky_sphere { 
  pigment {
   pigment_pattern {
    crackle
    form <1,0,0>

    pigment_map {
     [0
      crackle
      solid
      pigment_map {
       [0
         bozo
         scale 30
         colour_map {
           [0 rgb .7]
           [1 rgb 1.3]
         }
       ]
       [1 rgb 0]
      }
     ]
     [1 rgb 0]
    }
   }

   colour_map {
    [.5 rgb 0]
    [1 rgb 3]
   }

   scale 0.004  //.001 
  }
 }
 
 
 fog {
     fog_type 2
     distance 600 * Feet   //400
     color rgbt<0.3, 0.3, 0.5,.35> //.2
     fog_offset 130 * Feet
     fog_alt 130 * Feet
     turbulence 10 * Feet scale 100 * Feet
    } 


plane{y,0 
      pigment{color Black}
      finish{ambient .2 diffuse .2}
}
     
#declare DMFWood4 =
pigment {
    wood
    turbulence 0.04
    octaves 3
    scale <0.05, .05, 1>
    color_map {
        [0.1 rgb <0.888, 0.600, 0.3>]
        [0.9 rgb <0.600, 0.400, 0.2>]
    }
}


//Crystal Ball

#union{
     sphere{<0 * Feet, 0 * Feet, 0 * Feet>, 4 * Feet    
            pigment{color rgbf <1, 1, 1, .85>} 

            finish {
                     specular 0.5
                     roughness 0.00001
                     ambient 0
                     diffuse 0
                     reflection {  .3 }
                     conserve_energy
            }
            hollow
            interior{ior 1.0 caustics 1.0}
     }   

     torus {  2 * Feet,
              .3 * Feet
              texture{T_Silver_1A}
              translate <0 * Feet, -3.6 * Feet, 0 * Feet>
     }

     

#declare Stand1=          
     sphere_sweep {
                    b_spline
                    18,   //16                        
                   <1.00, 1.00, 0>, .1                
                   <0.50, 1.50, 0>, .1                
                   <0.00, 1.00, 0>, .1                
                   <0.50, 0.50, 0>, .1                  
                   <1.00, 1.00, 0>, .2                
                   <1.25, 0.50, 0>, .2               
                   <1.50, 0.00, 0>, .3                
                   <2.00, 0.00, 0>, .3                
                   <2.50, 0.50, 0>, .3                
                   <2.50, 1.50, 0>, .3                
                   <2.25, 2.50, 0>, .3                
                   <3.00, 3.00, 0>, .3               
                   <3.50, 3.50, 0>, .3                
                   <2.50, 3.50, 0>, .3 
                                  
                   <2.00, 4.00, 0>, .4                
                   <1.50, 4.50, 0>, .5                
                   <1.00, 4.00, 0>, .6                
                   <0.50, 3.50, 0>, .6                
                   tolerance 0.001             
                   texture{T_Silver_1A}
                   scale <1 * Feet, .78 * Feet, 1 * Feet>
                   translate <-5.3 * Feet,-6.3 * Feet, 0 * Feet>
     }
     #object {Stand1 rotate <0,-10,0>}
     #object {Stand1 rotate <0,110,0>}
     #object {Stand1 rotate <0,230,0>}

     
translate <0 * Feet, 190 * Feet, -15 * Feet>    
} 


  sphere{<0,0,0>,1 
           texture{pigment{rgbt <1,1,1,1>}}
           texture{
                    pigment{
                    image_map{ gif "grimrx2.gif"
                               map_type 1
                               interpolate 2
                               once
                               transmit 0,1
                               transmit 1,0.80
                               transmit 2,0.80
                               transmit 3,0.80
                               transmit 4,0.80
                               transmit 5,0.80
                               transmit 6,0.80
                               transmit 7,0.80 
                             } 
                    }
           } 
           finish{ambient .5}  //.25 
           rotate<0,260,0> 
           scale 3.9 * Feet      
           translate<0 * Feet,190 * Feet,-15 * Feet>
      }  
     
 

//floor
#declare Floor =
#declare X = -40;
#while (X<40)
#object{Isosfc2 
        material{BuildingTex translate<rand(R1)*30 * Feet,rand(R1)*3 * Feet,rand(R1)*3 * Feet>}
        scale <3 * Feet,1 * Feet,90 * Feet>
        translate <X * Feet, 180 * Feet, -80 * Feet>
}
   #declare X = X + 6;
#end

#object{Floor 
}


//Celing

#object{Isosfc2 
        material{BuildingTex rotate x * -90 translate<rand(R1)*30 * Feet,rand(R1)*3 * Feet,rand(R1)*3 * Feet>}
        scale <60 * Feet,2 * Feet,2 * Feet>
        translate <-30 * Feet, 215 * Feet, 0 * Feet>
}
     

#declare X = -40;
#while (X<40)
#object{Isosfc2 
        material{BuildingTex translate<rand(R1)*30 * Feet,rand(R1)*3 * Feet,rand(R1)*3 * Feet>}
        scale <2 * Feet,1.7 * Feet,80 * Feet>
        translate <X * Feet, 215.3 * Feet, -80 * Feet>
}
  #declare X = X + 10;
#end 

//Roof

#declare X = -40;
#declare RoofHalf =
union{
   #while (X<40)
       #object{Isosfc2 
               material{BuildingTex rotate<0,0,180> translate<rand(R1)*30 * Feet,rand(R1)*3 * Feet,rand(R1)*3 * Feet>}
               scale <3 * Feet, 2 * Feet, 90 * Feet>
               translate<X* Feet, 215 * Feet, -80 * Feet>
       }
      #local X = X + 6.5;
   #end
} 
            

#object{RoofHalf
        translate<0* Feet, 0 * Feet, 0 * Feet>
        Rotate_Around_Trans(<0,0,+30>, <-40 * Feet,215 * Feet,0 * Feet>)
}
#object{RoofHalf
        translate<30* Feet, 0 * Feet, 0 * Feet>
        Rotate_Around_Trans(<0,0,-30>, <40 * Feet,215 * Feet,0 * Feet>)
}
/*box{<-30 * Feet,-1 * Feet,-30 * Feet>,<30 * Feet,1 * Feet,10 * Feet>
    pigment{color Black}
    translate <0, 240 * Feet, 0>
   } */

        
//Posts

#object{Isosfc2 
        material{BuildingTex translate<rand(R1)*30 * Feet,rand(R1)*3 * Feet,rand(R1)*3 * Feet>}
        scale <2 * Feet,35 * Feet,2 * Feet>
        translate <-30 * Feet, 180 * Feet, 0 * Feet>
}
#object{Isosfc2 
        material{BuildingTex translate<rand(R1)*30 * Feet,rand(R1)*3 * Feet,rand(R1)*3 * Feet>}
        scale <2 * Feet,35 * Feet,2 * Feet>
        translate <30 * Feet, 180 * Feet, 0 * Feet>
}

//Bench

#declare Bench =
union{  
#object{Isosfc1 
        scale <4 * Feet,.5 * Feet,2 * Feet>
        translate <0 * Feet, 0 * Feet, 0 * Feet>
}
#object{Isosfc1                                                     
        scale <.5 * Feet,2 * Feet,2 * Feet>
        translate <-2 * Feet, -2 * Feet, 0 * Feet>
}
#object{Isosfc1 
        scale <.5 * Feet,2 * Feet,2 * Feet>
        translate <2 * Feet, -2 * Feet, 0 * Feet>
} 
}

#object{Bench
        translate<-20 * Feet,185 * Feet,-0 * Feet>
} 
#object{Bench
        translate<20 * Feet,185 * Feet,-0 * Feet>
} 

#declare Table = 
union{
   isosurface {
    function { f_rounded_box(x,y,z, .8, 1, 1, 1) - fn_Pigm(x, y, z).gray*0.8 }
    contained_by { box { -1, 1 } }       
    max_gradient 19.185                 
    texture{T_Stone8 scale .8}                 
    scale <12 * Feet,.5 * Feet,6 * Feet>  //z was 4
   }
   #object{Isosfc1                                                     
        scale <.5 * Feet,2 * Feet,4 * Feet>
        translate <-6 * Feet, -2.5 * Feet, 0 * Feet>
   }
   #object{Isosfc1 
        scale <.5 * Feet,2 * Feet,4 * Feet>
        translate <6 * Feet, -2.5 * Feet, 0 * Feet>
   } 
}  
#object{Table
        translate<0 * Feet,183 * Feet, -15 * Feet>
} 

          
#declare Lantern= 

   difference{
              sphere{<0,0,0>,3
                     scale <1,.80,1>
                     hollow        
              } 
              
              cylinder{-3.1 * y, 3.1 * y, 2 
                       } 
                       
    pigment{ gradient y
            color_map{ 
                       [0.0 Red]   
                       [0.2 IndianRed]
                       [0.4 Red]
                       [0.6 Firebrick]
                       [0.8 Red]
                       [1.0 OrangeRed]
                     } scale 2 //translate y-10            
   }
   finish{ambient .5 diffuse .5}

   normal{crackle 10 scale .6
    }      

               
   scale 1 * Feet
   hollow
   } 


  light_source {
     LanternLoc 
     color rgb  <1,.5,.5> * .7
     area_light         
     <4 * Feet, 0, 0> <0, 0, 4 * Feet> // lights spread out across this distance (x * z)
     4, 4                // total number of lights in grid (4x*4z = 16 lights)
     adaptive 0          // 0,1,2,3...
     jitter              // adds random softening of light 
     orient
     fade_distance 40 * Feet
     fade_power 2
     looks_like {Lantern}               
   }
   
//lamp roap and links
union{   
  cylinder { 0*y, 1*y, 1
               pigment{spiral1  1 
                       pigment_map{
                                    [0.0 Tan]
                                    [0.5 Tan]
                                    [0.5 DarkBrown]
                                    [1.0 DarkBrown]
                                  } scale .1 translate 5 * y  
                      }
                      normal{spiral1 1 scale 0.1}
               scale <.2 * Feet, 12.5 * Feet, .2 * Feet>
               translate LanternLoc + <0,1.5 * Feet,0> 
  } 
        
   torus {
           0.8,                         
           0.2         
           texture{T_Copper_1C}
           scale <.8,.8,1>
           rotate <90,0,0>
           scale 1 * Feet
           translate LanternLoc + <0,14.2*Feet,0> 
   } 
   torus {
           0.8,                         
           0.2         
           texture{T_Copper_1C}
           scale <.8,.8,1>
           rotate <90,90,0>
           scale 1 * Feet
           translate LanternLoc + <0,15.3*Feet,0>  
   } 

} 

#declare Chime= 
union{
difference{
            sphere{<0,0,0>, 2  
                   texture{T_Copper_1C} 
                   hollow
           }
            box{<-3,1.5,-3>,<3,3,3>}
            box{<-3,-0,-3>,<3,-3,3>}
            cutaway_textures
          }
      sphere{<0,0,0>,1
             texture{T_Copper_1C}
            } 
}

#declare Chimes=
union{
      #object{Chime
               scale 0.7 
               translate <0,10 ,0>
        }
       #object{Chime
               scale 1 
               translate <0,5,0>
        }
       #object{Chime
               scale 1.5 
               translate <0,0,0>
        }
       cylinder{0*y,20*y,.08
               texture{T_Copper_1C}
               Rotate_Around_Trans(<5,0,0>, <0 ,15 ,0 >)
               translate<0,0,-.7>
        } 
       cylinder{0*y,20*y,.08
               texture{T_Copper_1C}
               Rotate_Around_Trans(<-5,0,0>, <0 ,15 ,0 >)
               translate<0,0,.7>
        } 
       cylinder{0*y,20*y,.08
               texture{T_Copper_1C}
               Rotate_Around_Trans(<0,0,5>, <0 ,15 ,0 >)
               translate<+.7,0,0>
        } 
       cylinder{0*y,20*y,.08
               texture{T_Copper_1C}
               Rotate_Around_Trans(<0,0,-5>, <0 ,15 ,0 >) 
               translate<-.7,0,0>
        }   
   torus {
           0.8,                         
           0.2         
           texture{T_Copper_1C}
           scale <.8,.8,1>
           rotate <90,0,0>
           translate <0,20.5,0>
   } 
   torus {
           0.8,                         
           0.2         
           texture{T_Copper_1C}
           scale <.8,.8,1>
           rotate <90,90,0>
           translate <0,21.5,0>
   }
   difference{ 
               box {  <-1, -1, -1>, <1, 1, 1>
                      texture{T_Copper_1C}
                      scale <1, 3, .1>
                   }
               sphere{<0,2,0>,.35}
               translate<0, -8 ,0 >
               cutaway_textures
   }  
   cylinder{0*y,5*y,.2
            texture{T_Copper_1C}
            translate<0,-6,0>
            rotate<0,30,0>
   } 

}          
#object{Chimes
        rotate<0,30,0> 
        scale .7 * Feet
        translate ChimesLoc
} 


            
#declare FringTex =
    texture {  pigment{ 
                       wood
                       turbulence 0.8*Feet  
                       octaves 3*Feet
                       scale <0.05*Feet, .05*Feet, 1*Feet>
                       color_map { 
                               [0.0, 0.1 color rgbt <1,1,1,1>
                                         color rgbt <1,1,1,1>]
                               [0.1, 0.9 color Gray70 
                                         color rgbt <1,1,1,1>]
                               [0.9, 1.0 color Gray20 
                                         color rgbt <1,1,1,1>]
                                  }
                      }
             }

#declare Rug =
union {
    box{<-1.5*Feet, .08*Feet, -2*Feet> , <1.5*Feet, 0.001*Feet, 2*Feet>
    scale 3 
    texture{FringTex scale 10*Feet rotate y*90 }
   } 
   box{<-1.2*Feet, 0*Feet, -2*Feet> , <1.2*Feet, 0.002*Feet, 2*Feet>
       scale 3
       texture{pigment{
                        gradient x scale .5 * Feet
                        color_map{
                                   [0 Black ]
                                   [1 White * 5 ]
                                 }
                        turbulence 0}}
   
       texture{pigment{
                        gradient z scale .5 * Feet
                        color_map{
                                   [0 Black transmit .5]
                                   [1 White * 5 transmit .5]
                                 }
                        turbulence 0}}
   } 
}  

#object {  Rug 
           rotate y*90
           translate <16 * Feet, 181 * Feet, -16 * Feet>
         }  
   
#object {  Rug 
           rotate y*90
           translate <-16 * Feet, 181 * Feet, -16 * Feet>
         }

      
#declare Reaper =
   box{<-1,-1,-.00001>,<1,1,.00001> 
           texture{pigment{rgbt <1,1,1,1>}}
           texture{
                    pigment{
                    image_map{ gif "reaper2.gif"
                               map_type 0
                               interpolate 2
                               once
                               transmit 0,1
                               transmit 1,0.95
                               transmit 2,0.95
                               transmit 3,0.95
                               transmit 4,0.95
                               transmit 5,0.95
                               transmit 6,0.95
                               transmit 7,0.95 
                             } 
                    }
           } 
           finish{ambient .1 diffuse .1} 
           rotate<0,-45,0> 
           scale <48 * Feet, 98 * Feet, .1 * Feet>
      } 
      
Trace_It(<20 * Feet,   
         0 * Feet,
         100 * Feet>,         
         #object{Reaper }, 
         0
        ) 

      
      
      
      
