#declare Media1 =
media {
	scattering {3, <1,1,1> * .001 extinction CloudBrightness1/CloudScale1}
	absorption rgb<1,1,1> *.002
	method 3
	intervals 1
        #if (High_MSamples) samples 35,250 #else samples 5,10 #end
	density {
		crackle
		turbulence 1  //1 = convective 10 = stratiform
		color_map {
			[0.0 color rgb <0, 0, 0>]
			[0.5 color rgb <.5, .5, .5>]
			[1.0 color rgb <1, 1, 1>]
		}
	}
	scale 800  
}

#macro Nuke1 (CloudScale) 
union{
        cylinder {  0 * y * Feet,  5 * y * Feet,  3 * Feet
                    open
                    pigment{color rgbf <1.0, 1.0, 1.0, 1>} 
        }
        torus {  5 * Feet,
                 2 * Feet
                 translate <0 * Feet, 6 * Feet, 0 * Feet>
                 pigment{color rgbf<1,1,1,1>}
        } 
        sphere{ <0 * Feet, 14 * Feet, 0 * Feet> , 8 * Feet
                 pigment{color rgbf<1,1,1,1>}
        }
        scale CloudScale                                                                     
        hollow
        interior { media { Media1 }}
}
#end

#declare Nuke2 = 
union{
        cylinder {  0 * y * Feet,  2 * y * Feet,  3 * Feet
                    open
                    pigment{color rgbf <1.0, 1.0, 1.0, 1>} 
        }
        torus {  5 * Feet, 
                 2 * Feet  
                 translate <0 * Feet, 5 * Feet, 0 * Feet>
                 pigment{color rgbf<1,1,1,1>}
        } 
        scale CloudScale2                                                                     
        hollow
        interior { media { Media1 }}
}

//draw Nuke 1
   light_source {
                  0*x
                  color rgb <5,2,0> * .8  //was 3
                  media_interaction on
                  media_attenuation on 
                  translate CloudLocation1  + <-10 * Feet,-10 * Feet,150 * Feet>
                  fade_distance 800 * Feet
                  fade_power 2
   } 

   light_source {
                  <-400 * Feet, 400 * Feet, 2000 * Feet>
                  color rgb <5,2,0> * 15 
                  spotlight
                  point_at <-340 * Feet, 0 * Feet,2500 * Feet> 
                  radius    150
                  falloff   100
                  tightness 50                                                          
//                  fade_distance 200 * Feet
//                  fade_power 2
   }
   
 
   light_source {
                  0*x
                  color rgb <1,1,1>  * .3    //was .5 with fog
                  media_interaction on
                  media_attenuation on 
                  translate CloudLocation1  + <-75 * Feet,400 * Feet,200 * Feet>
   } 
   light_source {
                  0*x
                  color rgb <1,1,1>  * .3    //was .5 with fog
                  media_interaction on
                  media_attenuation on 
                  translate CloudLocation1  + <50 * Feet,400 * Feet,200 * Feet>
   } 
 
 
#object{ Nuke1(CloudScale1)
         translate CloudLocation1
       }
       

//draw Nuke 2
   light_source {
                  0*x
                  color rgb <1,1,1>  * 3
                  media_interaction on
                  media_attenuation on 
                  translate CloudLocation2  + <1 * Feet,5 * Feet,1 * Feet>
                  fade_distance 500 * Feet
                  fade_power 1
   } 

#object{ Nuke2
         translate CloudLocation2
       } 

//draw Nuke 3
union{
light_source {
  0*x                     
  color rgb <1,1,1> * 10     
  media_interaction on
  media_attenuation on
  fade_distance 70 * Feet  
  fade_power 1
}

sphere{<-30 * Feet, 0 * Feet, 0 * Feet> 30 * Feet
  pigment{color rgbf <1, .5, 0, .8>} 
  hollow 
  interior { media { Media1 }}
} 

   isosurface {
    function { f_sphere(x,y,z, 1) - f_noise3d(x , y , z ) * 4 }
    contained_by { box { -4, 4 } }       
    max_gradient 4.769  //17.562                                   
    pigment{color rgbf <1, 1, 1, 1>} 
    hollow 
    interior { media { Media1 }}                    
     scale <150 * Feet, 15 * Feet, 15 * Feet>
    translate<500 * Feet,0,0>
   } 
 
  rotate<0,0,135>       
  translate CloudLocation3
} 

#declare CityLight =
     sphere{<1 * Feet, 1 * Feet, 1 * Feet>, 2 * Feet
            pigment{color rgb <1, 1, 1>} 

            finish {
                     roughness 0.001
                     ambient 1
                     diffuse 1
                     reflection {
                                  0.01, .2
                                  fresnel on
                                }
                     conserve_energy
            }
            no_shadow 
     }

// Background City 2 Left
#declare X = -10000;
#declare Z = 18000;

#while (X < -6000) 
  #declare Z =18000;
  #while (Z < 30000)
     sphere{<X * Feet, 1 * Feet, Z * Feet>, 10 * Feet
            pigment{color rgb <1, 1, 0.0> * 2} 

            finish {
                     roughness 0.001
                     ambient 1
                     diffuse 1
                     reflection {
                                  0.01, .2
                                  fresnel on
                                }
                     conserve_energy
            }
            no_shadow 
     }
     #declare Z = Z + 300;
  #end
  #declare X = X + 200;
#end  
 
// Background City 3 Right
#declare X = 2500;
#declare Z = 14000;

#while (X < 3500) 
  #declare Z =14000;
  #while (Z < 25000)
     sphere{<X * Feet, 1 * Feet, Z * Feet>, 10 * Feet
            pigment{color rgb <1, 1, 0> * 2} 

            finish {
                     roughness 0.001
                     ambient 1
                     diffuse 1
                     reflection {
                                  0.01, .2
                                  fresnel on
                                }
                     conserve_energy
            }
            no_shadow 
     }
     #declare Z = Z + 300;
  #end
  #declare X = X + 200;
#end 
 
// Left City 1
#declare X = -600;
#declare Z = 2000;

#while (X < -300) 
  #declare Z= 2000;
  #while (Z < 3000)

     Trace_It(<(X + (rand(R1) * 150)) * Feet,
               0 * Feet,
               (Z + (rand(R1) * 50)) * Feet>, 
               #object{CityLight}, 2)
   
     #declare Z = Z + 30;
  #end
  #declare X = X + 30;
#end  
