//////////////////////////////////////////////////////////////////////////
// Door.inc  Copyright(c) 2003, K.E. Ayers Designs                      //
//////////////////////////////////////////////////////////////////////////
// The door is the central element in this scene.  All other components //
// are built relative to the location and dimensions of the door.       //
// The door is position so that, looking at it from the front, its left //
// bottom back corner is at the origin.                                 //
//////////////////////////////////////////////////////////////////////////

// This file should only be included once!
#ifndef (_Door_Inc_)
#declare _Door_Inc = true;

#debug "\nParsing: Door.inc\n"

#include "Textures.inc"
#include "SceneConstants.inc"


// These are the dimensions for the door's panels.

#declare DoorPanelWid           = DoorWid * 0.3;
#declare DoorTopPanelHgt        = DoorPanelWid * 3 / 4;
#declare DoorPanelSep           = (DoorWid - 2 * DoorPanelWid) / 3;
#declare DoorMidPanelHgt        = (DoorHgt
                                    - 4 * DoorPanelSep
                                    - DoorTopPanelHgt) / 2;
#declare DoorBotPanelHgt        = DoorMidPanelHgt - DoorPanelSep * 0.5;
#declare DoorPanelChannelWid    = DoorTopPanelHgt * 0.2;
#declare DoorPanelChannelDepth  = 3/8;
#declare DoorPanelWallAngle     = 60;


// This macro defines a "punch" that will be used to emboss the panels
// into the door's surface.

#macro DoorPanelPunch(wid, hgt)
intersection {
    union {
        plane {
            < -1, 0, 0 >, 0
            rotate < 0, DoorPanelWallAngle, 0 >
            translate < (wid / 2) - DoorPanelChannelWid, 0, 0 >
        }
        plane {
            < 1, 0, 0 >, 0
            rotate < 0, -DoorPanelWallAngle, 0 >
            translate < -(wid / 2) + DoorPanelChannelWid, 0, 0 >
        }
        plane {
            < 0, -1, 0 >, 0
            rotate < -DoorPanelWallAngle, 0, 0 >
            translate < 0, (hgt / 2) - DoorPanelChannelWid, 0 >
        }
        plane {
            < 0, 1, 0 >, 0
            rotate < DoorPanelWallAngle, 0, 0 >
            translate < 0, -(hgt / 2) + DoorPanelChannelWid, 0 >
        }
    }
    plane {
        < 1, 0, 0 >, 0
        rotate < 0, -DoorPanelWallAngle, 0 >
        translate < wid / 2, 0, 0 >
    }
    plane {
        < -1, 0, 0 >, 0
        rotate < 0, DoorPanelWallAngle, 0 >
        translate < -wid / 2, 0, 0 >
    }
    plane {
        < 0, 1, 0 >, 0
        rotate < DoorPanelWallAngle, 0, 0 >
        translate < 0, hgt / 2, 0 >
    }
    plane {
        < 0, -1, 0 >, 0
        rotate < -DoorPanelWallAngle, 0, 0 >
        translate < 0, -hgt / 2, 0 >
    }
    plane { < 0, 0, -1 >, DoorPanelChannelDepth }
    plane { < 0, 0,  1 >, DoorPanelChannelDepth }
}
#end


// The punches for a six-panel door pattern.

#declare DoorPanelPunches =
union {
    object {
        DoorPanelPunch(DoorPanelWid, DoorTopPanelHgt)
        translate < -(DoorPanelWid + DoorPanelSep) / 2,
                    DoorHgt - DoorPanelSep - DoorTopPanelHgt / 2,
                    0 >
    }
    object {
        DoorPanelPunch(DoorPanelWid, DoorTopPanelHgt)
        translate < (DoorPanelWid + DoorPanelSep) / 2,
                    DoorHgt - DoorPanelSep - DoorTopPanelHgt / 2,
                    0 >
    }
    object {
        DoorPanelPunch(DoorPanelWid, DoorMidPanelHgt)
        translate < -(DoorPanelWid + DoorPanelSep) / 2,
                    DoorHgt - 2 * DoorPanelSep
                        - DoorTopPanelHgt
                        - DoorMidPanelHgt / 2,
                    0 >
    }
    object {
        DoorPanelPunch(DoorPanelWid, DoorMidPanelHgt)
        translate < (DoorPanelWid + DoorPanelSep) / 2,
                    DoorHgt - 2 * DoorPanelSep
                        - DoorTopPanelHgt
                        - DoorMidPanelHgt / 2,
                    0 >
    }
    object {
        DoorPanelPunch(DoorPanelWid, DoorBotPanelHgt)
        translate < -(DoorPanelWid + DoorPanelSep) / 2,
                    DoorHgt - 3 * DoorPanelSep
                        - DoorTopPanelHgt
                        - DoorMidPanelHgt
                        - DoorBotPanelHgt / 2,
                    0 >
    }
    object {
        DoorPanelPunch(DoorPanelWid, DoorBotPanelHgt)
        translate < (DoorPanelWid + DoorPanelSep) / 2,
                    DoorHgt - 3 * DoorPanelSep
                        - DoorTopPanelHgt
                        - DoorMidPanelHgt
                        - DoorBotPanelHgt / 2,
                    0 >
    }
}


// This is the basic door shape -- a rectangular slab.

#declare DoorSlab =
box {
    < -DoorWid / 2, 0, -DoorThick / 2 >,
    <  DoorWid / 2, DoorHgt, DoorThick / 2 >
}


// Include the door's hardware -- hinges, a handle, and a knocker.
#include "Hardware.inc"


// The composite door has the panels punched into it and the
// hardware -- hinges, handle and knocker -- attached.
#declare Door =
union {
    difference {
        object { DoorSlab }
        object { DoorPanelPunches translate < 0, 0, -DoorThick / 2 > }
        texture { DoorTexture }
    }
    object { DoorHardware }
    translate < DoorXOfs, DoorYOfs, DoorZOfs >
    rotate < 0, DoorOpenAngle, 0 >
}

#end    // _Door_Inc_

