//////////////////////////////////////////////////////////////////////////
// Hardware.inc  Copyright(c) 2003, K.E. Ayers Designs                  //
//////////////////////////////////////////////////////////////////////////
// The door's hardware components: A set of three hinges, a brass       //
// handle, and a brass knocker.                                         //
//////////////////////////////////////////////////////////////////////////

// This file should only be included once!
#ifndef (_Hardware_Inc_)
#declare _Hardware_Inc = true;

#include "Hinge.inc"
#include "Latch.inc"
#include "Knocker.inc"

#declare HingeXOfs      = -DoorWid / 2;
#declare HingeYOfs      = DoorYOfs + DoorHgt / 2;
#declare HingeZOfs      = DoorThick / 2;

#declare LatchXOfs      = (DoorWid - DoorPanelSep) / 2;
#declare LatchYOfs      = DoorHgt
                            - 2 * DoorPanelSep
                            - DoorTopPanelHgt
                            - DoorMidPanelHgt
                            - DoorPanelSep / 2;
#declare LatchZOfs      = -DoorThick / 2;

#declare KnockerXOfs    = 0;
#declare KnockerYOfs    = DoorHgt
                            - DoorPanelSep
                            - DoorTopPanelHgt
                            - DoorPanelSep / 2
                            + KnockerArmLen / 2;
#declare KnockerZOfs    = -DoorThick / 2;

#declare DoorHardware =
union {
    object {
        Hinges
        translate < HingeXOfs, HingeYOfs, HingeZOfs >
    }
    object {
        Latch
        translate < LatchXOfs, LatchYOfs, LatchZOfs >
    }
    object {
        Knocker
        translate < KnockerXOfs, KnockerYOfs, KnockerZOfs >
    }
}

#end    // _Hardware_Inc_

