//////////////////////////////////////////////////////////////////////////
// Knocker.inc  Copyright(c) 2003, K.E. Ayers Designs                   //
//////////////////////////////////////////////////////////////////////////
// Defines the door's latch handle.                                     //
//////////////////////////////////////////////////////////////////////////

// This file should only be included once!
#ifndef (_Knocker_Inc_)
#declare _Knocker_Inc = true;

#include "SceneConstants.inc"
#include "Textures.inc"


// This is just a place holder, for now ... we'll add detail later.

#declare KnockerPivotSep        = 3.0;

#declare KnockerArmLen          = 3.0;
#declare KnockerArmRodRad       = 3/16;
#declare KnockerArmDist         = 3/16;

#declare KnockerHammerRad       = 1/2;
#declare KnockerHammerHgt       = 1/2;
#declare KnockerHammerKnobRad   = 3/8;

#declare KnockerPlateEndRad     = 3/4;
#declare KnockerPlateThick      = 3/16;

#declare KnockerPivotRad        = KnockerArmRodRad + KnockerArmDist;
#declare KnockerPivotWid        = 3/8;

#declare KnockerArm =
union {
    cylinder {
        < -KnockerPivotSep / 2, 0, 0 >,
        <  KnockerPivotSep / 2, 0, 0 >,
        KnockerArmRodRad
    }
    cylinder {
        < 0, 0, 0 >,
        < 0, -KnockerArmLen, 0 >,
        KnockerArmRodRad
    }
}

#declare KnockerHammer =
union {
    cylinder {
        < 0, 0, 0 >,
        < 0, 0, -KnockerHammerHgt >,
        KnockerHammerRad
    }
    cylinder {
        < 0, 0, -KnockerHammerHgt >,
        < 0, 0, -(KnockerHammerHgt + 1/2) >,
        KnockerHammerRad / 2
    }
    sphere {
        < 0, 0, 0 >, KnockerHammerKnobRad
        scale < 1, 1, 0.5 >
        translate < 0, 0, -(KnockerHammerHgt + 1/2) >
    }
}

#declare KnockerArmPivot =
union {
    box {
        < -KnockerPivotWid / 2,
          -KnockerPivotRad,
          -(KnockerArmRodRad + KnockerArmDist) >,
        <  KnockerPivotWid / 2,
           KnockerPivotRad,
           0 >
    }
    cylinder {
        < -KnockerPivotWid / 2, 0, -(KnockerArmRodRad + KnockerArmDist) >,
        <  KnockerPivotWid / 2, 0, -(KnockerArmRodRad + KnockerArmDist) >,
        KnockerPivotRad
    }
}


#declare KnockerPlateFillet =
difference {
    box {
        < 0, 0,  -KnockerPlateThick >,
        < KnockerPlateEndRad, KnockerPlateEndRad, 0 >
    }
    cylinder { < 0, 0, 1 >, < 0, 0, -1 >, KnockerPlateEndRad }
}

#declare KnockerPlate =
union {
    box {
        < -KnockerPivotSep / 2, -KnockerPlateEndRad, -KnockerPlateThick >,
        <  KnockerPivotSep / 2,  KnockerPlateEndRad, 0 >
    }
    cylinder {
        < -KnockerPivotSep / 2, 0, -KnockerPlateThick >,
        < -KnockerPivotSep / 2, 0, 0 >,
        KnockerPlateEndRad
    }
    cylinder {
        < KnockerPivotSep / 2, 0, -KnockerPlateThick >,
        < KnockerPivotSep / 2, 0, 0 >,
        KnockerPlateEndRad
    }
    box {
        < -KnockerPlateEndRad, 0, -KnockerPlateThick >,
        <  KnockerPlateEndRad, -KnockerArmLen, 0 >
    }
    cylinder {
        < 0, -KnockerArmLen, -KnockerPlateThick >,
        < 0, -KnockerArmLen, 0 >,
        KnockerPlateEndRad
    }
    object {
        KnockerPlateFillet
        translate < -2 * KnockerPlateEndRad, -2 * KnockerPlateEndRad, 0 >
    }
    object {
        KnockerPlateFillet
        scale < -1, 1, 1 >
        translate < 2 * KnockerPlateEndRad, -2 * KnockerPlateEndRad, 0 >
    }
}

#declare Knocker =
union {
    object { KnockerPlate }
    object {
        KnockerArm
        translate < 0, 0, -(KnockerArmRodRad
                                + KnockerPlateThick
                                + KnockerArmDist) >
    }
    object {
        KnockerHammer
        translate < 0, -KnockerArmLen, -KnockerPlateThick >
    }
    object {
        KnockerArmPivot
        translate < -KnockerPivotSep / 2, 0, -KnockerPlateThick >
    }
    object {
        KnockerArmPivot
        translate < KnockerPivotSep / 2, 0, -KnockerPlateThick >
    }
    texture { PolishedBrass }
}


#end    // _Knocker_Inc_

