//////////////////////////////////////////////////////////////////////////
// Latch.inc  Copyright(c) 2003, K.E. Ayers Designs                     //
//////////////////////////////////////////////////////////////////////////
// Defines the door's latch handle.                                     //
//////////////////////////////////////////////////////////////////////////

// This file should only be included once!
#ifndef (_Latch_Inc_)
#declare _Latch_Inc = true;

#include "SceneConstants.inc"
#include "Textures.inc"


// This is just a place holder, for now ... we'll add detail later.
#declare LatchHgt               = 8.0;
#declare LatchBarrelRad         = 1.25;
#declare LatchBarrelDepth       = 2.0;
#declare LatchHandleRad         = 1/2;

#declare Latch =
difference {
    union {
        cylinder {
            < 0, 0, 0 >, < 0, 0, -LatchBarrelDepth >, LatchBarrelRad
            scale < 1.0, 0.75, 1.0 >
        }
        cylinder {
            < 0, 0, 0 >, < 0, -LatchHgt, 0 >, LatchHandleRad
            translate < 0, -LatchBarrelRad * 0.75, -LatchBarrelDepth * 0.5 >
        }
    }
    // Punch out a key slot.
    box {
        < -(LatchBarrelRad * 0.1),
          -(LatchBarrelRad * 0.5),
          -(LatchBarrelDepth + 0.1) >,
        < (LatchBarrelRad * 0.1),
          (LatchBarrelRad * 0.5),
          0.01 >
    }
    texture { PolishedBrass }
}


#end    // _Latch_Inc_

