//////////////////////////////////////////////////////////////////////////
// Porch.inc  Copyright(c) 2003, K.E. Ayers Designs                     //
//////////////////////////////////////////////////////////////////////////
// This file constructs the porch and steps leading up to the door.     //
//////////////////////////////////////////////////////////////////////////

// This file should only be included once!
#ifndef (_Porch_Inc_)
#declare _Porch_Inc = true;

#debug "\nParsing: Porch.inc\n"

#include "SceneConstants.inc"
#include "Textures.inc"
#include "Shrubbery.inc"


#declare PorchWid               = EntryWid;
#declare PorchDepth             = 36;
#declare PorchThick             = 4;

#declare PorchLeft              = FrameLeft;
#declare PorchRight             = FrameRight;
#declare PorchTop               = FrameBottom - EntryStepHgt;
#declare PorchBottom            = PorchTop - PorchThick;
#declare PorchBack              = FoundationFront;
#declare PorchFront             = PorchBack - PorchDepth;

#declare PorchCenterX           = (PorchLeft + PorchRight) / 2;
#declare PorchCenterZ           = (PorchBack + PorchFront) / 2;

#declare StepWid                = 36;
#declare StepDepth              = 6;
#declare StepThick              = 1.5;
#declare StepRise               = 5;

#declare StepLeft               = PorchCenterX - StepWid / 2;
#declare StepRight              = StepLeft + StepWid;
#declare StepTop                = 0;
#declare StepBottom             = StepTop - StepThick;
#declare StepBack               = 0;
#declare StepFront              = StepBack - StepDepth;


// The porch slab has beveled front edges.
#declare PorchSlab =
intersection {
    box {
        < PorchLeft,  PorchBottom, PorchFront >,
        < PorchRight, PorchTop,    PorchBack >
    }
    plane {
        < 0, 0, -1 >, 0
        rotate < 45, 0, 0 >
        translate < 0, PorchTop - 1/4, PorchFront + 1/4 >
    }
    plane {
        < 0, 0, -1 >, 0
        rotate < -45, 0, 0 >
        translate < 0, PorchBottom + 1/4, PorchFront + 1/4 >
    }
    plane {
        < 0, 0, -1 >, 0
        rotate < 0, 45, 0 >
        translate < PorchLeft + 1/4, 0, PorchFront + 1/4 >
    }
    plane {
        < 0, 0, -1 >, 0
        rotate < 0, -45, 0 >
        translate < PorchRight - 1/4, 0, PorchFront + 1/4 >
    }
    texture { PorchTexture }
}


// For now, the steps are unconnected concrete slabs.

#declare Step =
box {
    < StepLeft,  StepBottom, StepFront >,
    < StepRight, StepTop,    StepBack >
    texture { PorchTexture }
}

#local YOfs     = PorchTop - StepRise;
#local ZOfs     = PorchFront;
#local StepNum  = 1;
#local RPlant   = seed(23);

#declare Steps  =
union {
    #while (StepNum <= 4)
        object { Step translate < 0, YOfs, ZOfs > }
        object {
            FloweringBush
            rotate (rand(RPlant) * 360 - 180) * y
            scale 1.7 - (rand(RPlant) * 0.4)
            translate < StepRight + (FloweringBushStemLen * 2.5),
                        YOfs - StepThick,
                        ZOfs - StepDepth >
        }
        object {
            FloweringBush
            rotate (rand(RPlant) * 360 - 180) * y
            scale 1.7 - (rand(RPlant) * 0.4)
            translate < StepLeft - (FloweringBushStemLen * 2.5),
                        YOfs - StepThick,
                        ZOfs - StepDepth >
        }

        #local YOfs    = YOfs - StepRise;
        #local ZOfs    = ZOfs - StepDepth;
        #local StepNum = StepNum + 1;
    #end
}


// Our porch will have a mat on it.

#declare DoorMatWid         = DoorWid * 0.75;
#declare DoorMatDepth       = DoorMatWid * 0.75;
#declare DoorMatThick       = 3/4;

#declare DoorMatBack        = PorchBack - 6;
#declare DoorMatFront       = DoorMatBack - DoorMatDepth;

#declare DoorMatCenterZ     = (DoorMatBack + DoorMatFront) / 2;

#declare DoorMatSloganText  = "WELCOME"
#declare DoorMatSloganFont  = "cyrvetic.ttf"
#declare DoorMatSloganThick = DoorMatThick * 1.1;

#declare DoorMatSlogan =
text {
    ttf DoorMatSloganFont,
    DoorMatSloganText,
    DoorMatSloganThick,
    0.0
}

//////////////////////////////////////////////////////////////
// These values need to be adjusted if the text string or   //
// font is changed.

#declare SloganXScale   = DoorMatWid * strlen(DoorMatSloganText) * 0.025;
#declare SloganYScale   = SloganXScale * 2.5;
#declare SloganXOfs     = PorchCenterX - (DoorMatWid * 0.425);
#declare SloganYOfs     = PorchTop + DoorMatSloganThick;
#declare SloganZOfs     = DoorMatCenterZ - (DoorMatDepth * 0.225);

// Use crosshairs to align the text.
#local UseCrosshairs    = false;

//////////////////////////////////////////////////////////////

#declare DoorMat =
union {
    box {
        < PorchCenterX - DoorMatWid / 2, PorchTop, DoorMatFront >,
        < PorchCenterX + DoorMatWid / 2, PorchTop + DoorMatThick, DoorMatBack >
        texture {
            pigment {
                granite
                turbulence 0.25
                color_map {
                    [ 0.0   color rgb < 0.6,  0.3,  0.1  > ]
                    [ 0.25  color rgb < 0.9,  0.45, 0.3  > ]
                    [ 0.45  color rgb < 0.6,  0.3,  0.1  > ]
                    [ 0.5   color rgb < 0.0,  1.0,  0.0  > ]
                    [ 0.55  color rgb < 0.6,  0.3,  0.1  > ]
                    [ 1.01  color rgb < 0.6,  0.3,  0.1  > ]
                }
                scale DoorMatWid * 0.05
            }
        }
    }
    object {
        DoorMatSlogan
        scale < SloganXScale, SloganYScale, 1.0 >
        rotate 90 * x
        translate < SloganXOfs, SloganYOfs, SloganZOfs >
        texture { pigment { color rgb < 0.2, 0, 0 > } }
    }

    #if (UseCrosshairs)
        // The crosshairs help in aligning the text if the
        // door mat slogan text or font is changed.
        box {
            < PorchCenterX - DoorMatWid / 2, PorchTop, DoorMatCenterZ - 0.1 >,
            < PorchCenterX + DoorMatWid / 2, PorchTop + DoorMatThick + 0.25, DoorMatCenterZ + 0.1 >
            texture {
                pigment { color rgb < 1, 1, 1 > }
                finish { ambient 1 diffuse 0 }
            }
        }
        box {
            < PorchCenterX - 0.1, PorchTop, DoorMatFront >,
            < PorchCenterX + 0.1, PorchTop + DoorMatThick + 0.25, DoorMatBack >
            texture {
                pigment { color rgb < 1, 1, 1 > }
                finish { ambient 1 diffuse 0 }
            }
        }
    #end
}

#if (IncludePorchFoliage)
    #declare PorchFoliage =
    union {
        object {
            BushyShrub
            scale < 1.5, 2.0, 1.5 >
            translate < PorchRight + (BushyShrubStemLen * 2.5),
                        PorchBottom,
                        PorchBack - (BushyShrubStemLen * 2.0) >
        }
        object {
            BushyShrub
            scale < 1.5, 2.0, 1.5 >
            translate < PorchLeft - (BushyShrubStemLen * 2.5),
                        PorchBottom,
                        PorchBack - (BushyShrubStemLen * 2.0) >
        }
        object {
            FloweringBush
            rotate (rand(RPlant) * 360 - 180) * y
            scale 1.7 - (rand(RPlant) * 0.4)
            translate < PorchRight + (FloweringBushStemLen * 2.25),
                        PorchBottom,
                        PorchFront + (FloweringBushStemLen * 2.25) >
        }
        object {
            FloweringBush
            rotate (rand(RPlant) * 360 - 180) * y
            scale 1.7 - (rand(RPlant) * 0.4)
            translate < PorchLeft - (FloweringBushStemLen * 2.25),
                        PorchBottom,
                        PorchFront + (FloweringBushStemLen * 2.25) >
        }
        object {
            FloweringBush
            rotate (rand(RPlant) * 360 - 180) * y
            scale 1.7 - (rand(RPlant) * 0.4)
            translate < PorchRight + (FloweringBushStemLen * 2.25),
                        PorchBottom,
                        PorchFront - (FloweringBushStemLen * 2.25) >
        }
        object {
            FloweringBush
            rotate (rand(RPlant) * 360 - 180) * y
            scale 1.7 - (rand(RPlant) * 0.4)
            translate < PorchLeft - (FloweringBushStemLen * 2.25),
                        PorchBottom,
                        PorchFront - (FloweringBushStemLen * 2.25) >
        }
        object {
            FloweringBush
            rotate (rand(RPlant) * 360 - 180) * y
            scale 1.7 - (rand(RPlant) * 0.4)
            translate < PorchRight - (FloweringBushStemLen * 2.25),
                        PorchBottom,
                        PorchFront - (FloweringBushStemLen * 2.25) >
        }
        object {
            FloweringBush
            rotate (rand(RPlant) * 360 - 180) * y
            scale 1.7 - (rand(RPlant) * 0.4)
            translate < PorchLeft + (FloweringBushStemLen * 2.25),
                        PorchBottom,
                        PorchFront - (FloweringBushStemLen * 2.25) >
        }
    }
#end

#declare Porch =
union {
    object { PorchSlab }
    object { DoorMat }
    object { Steps }

    #if (IncludePorchFoliage)
        object { PorchFoliage }
    #end
}

#end    // _Porch_Inc_

