//////////////////////////////////////////////////////////////////////////
// Scene.inc  Copyright(c) 2003, K.E. Ayers Designs                     //
//////////////////////////////////////////////////////////////////////////
// This file constructs the scene, which is viewed through the open     //
// door -- a blue sky, with puffy clouds, a swing set and slide,  maybe //
// a tree or two.                                                       //
//////////////////////////////////////////////////////////////////////////

// This file should only be included once!
#ifndef (_Scene_Inc_)
#declare _Scene_Inc = true;

#debug "\nParsing: Scene.inc\n"

#include "SceneConstants.inc"
#include "Textures.inc"
#include "Mountains.inc"
#include "Yard.inc"


#local MountainWidScale     = SceneSkyRad * 0.0025;
#local MountainHgtScale     = SceneSkyRad * 0.0015;
#local MountainDepthScale   = SceneSkyRad * 0.00175;
#local MountainDist         = SceneSkyRad * 0.025;
#local MountainLightXOfs    = SceneSkyRad * 0.0001;
#local MountainLightYOfs    = SceneSkyRad * 0.0015;
#local MountainLightZOfs    = SceneSkyRad * 0.0015;


#declare SkyTextureScale    = SceneSkyRad * 0.006;
#declare GroundTextureScale = SceneSkyRad * 0.001;
#declare GroundGreen        = color rgb  < 0.0,  0.4,  0.0  >;
#declare GroundDarkGreen    = color rgb  < 0.1,  0.3,  0.0  >;
#declare GroundBrown        = color rgb  < 0.5,  0.4,  0.2  >;

#if (UseTransparentSky)
    #declare SkyColor           = color rgbf < 0.9, 0.9, 1.0, 1.0 >;
    #declare HorizonColor       = Clear;
    #declare CloudLightColor    = color rgbf < 0.9,  0.9,  1.0,  1.0  >;
    #declare CloudDarkColor     = color rgbf < 0.8,  0.8,  0.9,  1.0  >;

    #declare SceneSkyTexture =
    texture {
        pigment {
            radial
            color_map {
                [ 0.0   color HorizonColor ]
                [ 0.025 color SkyColor ]
                [ 0.75  color SkyColor ]
                [ 1.0   color HorizonColor ]
            }
        }
        rotate <  0, -90, 90 >
        finish { ambient 1 diffuse 0 }
    }
    texture {
        pigment {
            bozo
            turbulence 1.25
            octaves 8
            color_map {
                [0.0   color Clear ]
                [0.375 color Clear ]
                [0.5   color rgbf < 1, 1, 1, 0.7 > ]
                [0.625 color Clear ]
                [1.0   color Clear ]
            }
        }
        rotate <  63, 31, 73 >
        scale SkyTextureScale
        finish { ambient 1 diffuse 0 }
    }
#else
    #declare SkyColor           = color rgb  < 0.2,  0.2,  0.55 >;
    #declare HorizonColor       = color rgb  < 0.55, 0.55, 1.0  >;
    #declare CloudLightColor    = color rgb  < 0.9,  0.9,  1.0  >;
    #declare CloudDarkColor     = color rgb  < 0.3,  0.3,  0.4  >;

    #declare SceneSkyTexture =
    texture {
        pigment {
            radial
            color_map {
                [ 0.0   color HorizonColor ]
                [ 0.025 color SkyColor ]
                [ 0.75  color SkyColor ]
                [ 1.0   color HorizonColor ]
            }
        }
        rotate <  0, -90, 90 >
        finish { ambient 1 diffuse 0 }
    }
    texture {
        pigment {
            bozo
            turbulence 1.25
            octaves 8
            color_map {
                [0.0   color Clear ]
                [0.375 color Clear ]
                [0.5   color White ]
                [0.625 color Clear ]
                [1.0   color Clear ]
            }
        }
        rotate <  63, 31, 73 >
        scale SkyTextureScale
        finish { ambient 1 diffuse 0 }
    }
#end

#declare SceneGroundTexture =
texture {
    pigment {
        bozo
        turbulence 0.6
        color_map {
            [ 0.0   color GroundGreen     ]
            [ 0.2   color GroundDarkGreen ]
            [ 0.275 color GroundGreen     ]
            [ 0.725 color GroundGreen     ]
            [ 0.9   color GroundBrown     ]
            [ 1.0   color GroundGreen     ]
        }
    }
    scale GroundTextureScale
    finish { ambient 1 diffuse 0 }
}

#local ClipXRot = 22;
#local ClipYRot = 0;
#local ClipXOfs = (WallWid - WallExt) / 2;

#declare SceneClipper =
intersection {
    plane {
        < -1, 0, 0 >, 0
        rotate < 0, -ClipXRot, 0 >
        translate < -ClipXOfs, 0, 0 >
    }
    plane {
        < 1, 0, 0 >, 0
        rotate < 0, ClipXRot, 0 >
        translate < ClipXOfs, 0, 0 >
    }
    plane {
        < 0, 1, 0 >, 0
        rotate < -ClipYRot, 0, 0 >
        translate < 0, WallHgt, 0 >
    }
    plane { <  0, -1,  0 >, 0.01 }
    plane { <  0,  0, -1 >, 0 }
}

#declare SceneSkyShape =
intersection {
    sphere { <  0,  0,  0 >, SceneSkyRad }
    object { SceneClipper }
}

#declare SceneSky =
difference {
    object { SceneSkyShape }
    object { SceneSkyShape translate < 0, -1.0, -1.0 > }
    hollow
}

#declare SceneGroundShape =
intersection {
    plane  { <  0, -1,  0 >, 0 }
    object { SceneClipper }
    plane  { <  0,  1,  0 >, 0 }
    hollow
}


#declare Scene =
union {
    object {
        SceneSky
        texture { SceneSkyTexture }
    }
    object {
        SceneGroundShape
        translate < 0, 0.01, 0 >
        texture { SceneGroundTexture }
    }
    object {
        MountainRange
        scale < MountainWidScale, MountainHgtScale, MountainDepthScale >
        translate MountainDist * z
        rotate < 0, 2.0, 0 >
    }

    object { BackyardScene }

    light_source {
        < -MountainLightXOfs, MountainLightYOfs, MountainLightZOfs >
        color rgb < 1.0, 1.0, 0.7 >
    }

    translate < (FrameLeft + FrameRight) / 2, InteriorFloorHgt - 0.02, FloorDepth >
}


#end    // _Scene_Inc_

