//////////////////////////////////////////////////////////////////////////
// Sky.inc  Copyright(c) 2003, K.E. Ayers Designs                       //
//////////////////////////////////////////////////////////////////////////
// This file constructs a star-filled nighttime sky.                    //
//////////////////////////////////////////////////////////////////////////

// This file should only be included once!
#ifndef (_Sky_Inc_)
#declare _Sky_Inc = true;

#debug "\nParsing: Sky.inc\n"

// Our stars can have one of four different colors.

#declare WhiteStar      = color rgb < 1.0,  1.0,  1.0  >;
#declare BlueStar       = color rgb < 0.75, 0.75, 1.0  >;
#declare RedStar        = color rgb < 1.0,  0.8,  0.6  >;
#declare YellowStar     = color rgb < 1.0,  1.0,  0.5  >;


// All stars are luminous.

#declare StarFinish = finish { ambient 1 diffuse 0 }


// Our stars will be positioned at random angles and distances.

#declare StarDist           = 100000;     // Nominal
#declare StarRad            = 125;
#declare NumStars           = 500;

#declare MinStarDistScale   = 0.7;
#declare MaxStarDistScale   = 2.0;
#declare MaxStarXAngle      = 30.0;     // Plus or minus.
#declare MaxStarYAngle      = 35.0;     // Plus or minus.

#declare Sky =
union {
    #local RT    = seed(0);
    #local RD    = seed(int(rand(RT) * 100));
    #local RX    = seed(int(rand(RT) * 100));
    #local RY    = seed(int(rand(RT) * 100));
    #local Num   = 1;
    #local Range = MaxStarDistScale - MinStarDistScale;

    #while (Num <= NumStars)
        #local Num       = Num + 1;
        #local Type      = rand(RT);
        #local DistScale = MinStarDistScale + rand(RD) * Range;
        #local XRot      = MaxStarXAngle * 2 * rand(RX) - MaxStarXAngle;
        #local YRot      = MaxStarYAngle * 2 * rand(RY) - MaxStarYAngle;

        #switch (Type)
            #range (0.0, 0.15)
                #local StarColor = RedStar;
            #break
            #range (0.15, 0.3)
                #local StarColor = BlueStar;
            #break
            #range (0.3, 0.45)
                #local StarColor = YellowStar;
            #break
            #else
                #local StarColor = WhiteStar;
        #end

        sphere {
            < 0, 0, 0 >, StarRad
            translate < 0, 0, DistScale * StarDist >
            rotate < XRot, YRot, 0 >
            texture { pigment { StarColor } finish { StarFinish } }
        }
    #end
}

#end    // _Sky_Inc_
