//////////////////////////////////////////////////////////////////////////
// SwingSet.inc  Copyright(c) 2003, K.E. Ayers Designs                  //
//////////////////////////////////////////////////////////////////////////
// This file constructs the swing set in the backyard scene.            //
//////////////////////////////////////////////////////////////////////////

// This file should only be included once!
#ifndef (_SwingSet_Inc_)
#declare _SwingSet_Inc_ = true;

#debug "\nParsing: SwingSet.inc\n"

#include "SceneConstants.inc"
#include "Textures.inc"


#local SeatWid              = 18;
#local SeatDepth            = 6;
#local SeatThick            = 1;
#local SeatHgt              = 18;
#local NumSeats             = 2;
#local SeatSep              = 36;
#local RopeInset            = 1;

#local LegRad               = 1.5;
#local TopRad               = 2;
#local TopThick             = 1/4;
#local BraceRad             = 3/2;
#local LegAngle             = 30;

#declare SwingSetHgt        = 84;
#declare SwingSetWid        = (NumSeats * SeatSep) + (LegRad * 6);

#local BraceHgt             = SwingSetHgt * 0.4;
#local BraceLen             = tan(radians(LegAngle)) * (SwingSetHgt - BraceHgt) * 2;

#local LegLen               = SwingSetHgt / cos(radians(LegAngle));

#local RustTexture =
texture {
    pigment { color rgb < 0.4, 0.2, 0.1 > }
    finish { ambient Ambient diffuse Diffuse }
}

#local RedEnamelTexture =
texture {
    pigment { Red }
    finish {
        ambient     Ambient
        diffuse     Diffuse
        specular    1
        roughness   0.001
        metallic
        brilliance  2
        reflection  0.1
    }
}

#local SwingSetTexture =
texture {
    granite turbulence 0.5
    texture_map {
        [ 0.0   RedEnamelTexture ]
        [ 0.3   RedEnamelTexture ]
        [ 0.4   RustTexture ]
        [ 0.5   RedEnamelTexture ]
        [ 0.6   RedEnamelTexture ]
        [ 0.7   RustTexture ]
        [ 0.8   RedEnamelTexture ]
        [ 1.1   RedEnamelTexture ]
    }
}


#local BraceTube =
cylinder {
    < 0, 0, -BraceLen / 2 >,
    < 0, 0,  BraceLen / 2 >,
    BraceRad
}

#local LegTube =
cylinder {
    < 0, -LegLen, 0 >, < 0, 0, 0 >, LegRad
}

#local SwingSetLegs =
union {
    object { LegTube rotate  LegAngle * x }
    object { LegTube rotate -LegAngle * x }
    object { BraceTube translate -(SwingSetHgt - BraceHgt) * y }
}

#local TopTube =
cylinder {
    < -SwingSetWid / 2, 0, 0 >,
    <  SwingSetWid / 2, 0, 0 >,
    TopRad
}

#local TopTubePunch =
cylinder {
    < -SwingSetWid * 0.6, -LegLen, 0 >,
    <  SwingSetWid * 0.6, 0,       0 >,
    TopRad - TopThick
}

#local SwingSetFrame =
difference {
    union {
        object { TopTube }
        object {
            SwingSetLegs
            translate  ((SwingSetWid / 2) - (2 * LegRad)) * x
        }
        object {
            SwingSetLegs
            translate  -((SwingSetWid / 2) - (2 * LegRad)) * x
        }
    }
    object { TopTubePunch }
    translate SwingSetHgt * y
    texture { SwingSetTexture scale SwingSetWid * 0.1 }
}


#local SwingRope =
cylinder {
    < 0, SwingSetHgt, 0 >, < 0, SeatHgt, 0 >, 1/2
    pigment { color rgb < 0.8, 0.7, 0.3 > }
}

#local SwingSeat =
box {
    < -SeatWid / 2, -SeatThick / 2, -SeatDepth / 2 >,
    <  SeatWid / 2,  SeatThick / 2,  SeatDepth / 2 >
    texture { FinishedLightOak }
}

#local Swing =
union {
    object { SwingRope translate  ((SeatWid / 2) - RopeInset) * x }
    object { SwingRope translate -((SeatWid / 2) - RopeInset) * x }
    object { SwingSeat translate SeatHgt * y }
}


#declare SwingSet =
union {
    object { SwingSetFrame }
    object { Swing translate  (SeatSep / 2) * x }
    object { Swing translate -(SeatSep / 2) * x }
}


#end    // #ifndef (_SwingSet_Inc_)
