//////////////////////////////////////////////////////////////////////////
// Window.inc  Copyright(c) 2003, K.E. Ayers Designs                    //
//////////////////////////////////////////////////////////////////////////
// This file constructs the windows in the front wall.                  //
//////////////////////////////////////////////////////////////////////////

// This file should only be included once!
#ifndef (_Window_Inc_)
#declare _Window_Inc_ = true;

#include "Textures.inc"
#include "SceneConstants.inc"


#declare WindowHgt          = 48;
#declare WindowWid          = 42;

#declare ShutterHgt         = WindowHgt;
#declare ShutterWid         = 12;

#declare ShutterXOfs        = 18 + ShutterWid / 2;
#declare WindowXOfs         = ShutterXOfs + (ShutterWid + WindowWid) / 2;
#declare WindowYOfs         = 24 + WindowHgt / 2;

#local ShutterThick       = 1.5;
#local ShutterFrameWid    = 1;
#local ShutterSlatWid     = 2;
#local ShutterSlatThick   = 1/8;

#local WindowFrameWid     = 3/4;
#local WindowPaneThick    = 1/8;
#local WindowFrameWid     = 3/4;
#local WindowFrameThick   = WindowPaneThick + 1/4;

#declare WindowCutout =
box {
    < -WindowWid / 2, -WindowHgt / 2, -12 >,
    <  WindowWid / 2,  WindowHgt / 2,  12 >
}


#local CurtainPigment =
pigment {
    gradient x
    color_map {
        [ 0.0   color rgb < 0.4,  0.35, 0.1  > ]
        [ 0.1   color rgb < 0.4,  0.35, 0.1  > ]
        [ 0.5   color rgb < 0.3,  0.25, 0.0  > ]
        [ 0.9   color rgb < 0.4,  0.35, 0.1  > ]
        [ 1.1   color rgb < 0.4,  0.35, 0.1  > ]
    }
    translate 0.5 * x
    scale 0.05
}
        
#local WindowPane =
box {
    < -WindowWid / 2, -WindowHgt / 2, -WindowPaneThick >,
    <  WindowWid / 2,  WindowHgt / 2,  0 >
    texture {
        pigment {
            gradient x
            pigment_map {
                [ 0.0   CurtainPigment ]
                [ 0.1   CurtainPigment ]
                [ 0.2   color rgbf < 0.1,  0.05, 0.0, 1.0  > ]
                [ 0.3   Clear ]
                [ 1.1   Clear ]
            }
        }
        scale < WindowWid * 2.01, 1, 1 >
        translate (-WindowWid / 2) * x
        finish { ambient 1.0 diffuse 0.0 }
    }
}

#local Bot      = -WindowHgt / 2;
#local Top      = Bot + WindowHgt;
#local Lft      = -WindowWid / 2;
#local Rgt      = Lft + WindowWid;
#local Frt      = -WindowFrameThick;
#local Bck      = 0;
#local CtrX     = Lft + WindowWid / 3;
#local CtrY     = (Bot + Top) / 2;
#local CtrLft   = CtrX - WindowFrameWid / 2;
#local CtrRgt   = CtrLft + WindowFrameWid;
#local CtrBot   = CtrY - WindowFrameWid / 2;
#local CtrTop   = CtrBot + WindowFrameWid;
#local Wid      = WindowFrameWid;

#local WindowFrame =
union {
    box { < Lft, Top - Wid, Frt >, < Rgt, Top, Bck > }
    box { < Lft, Bot, Frt >, < Rgt, Bot + Wid, Bck > }
    box { < Lft, Bot, Frt >, < Lft + Wid, Top, Bck > }
    box { < Rgt - Wid, Bot, Frt >, < Rgt, Top, Bck > }
    box { < Lft, CtrBot, Frt >, < Rgt, CtrTop, Bck > }
    box { < CtrLft, Bot, Frt >, < CtrRgt, Top, Bck > }
    texture {
        pigment {
            gradient x
            pigment_map {
                [ 0.0   White ]
                [ 0.1   White ]
                [ 0.3   Clear ]
                [ 1.1   Clear ]
            }
            scale < WindowWid * 2.01, 1, 1 >
            translate (-WindowWid / 2) * x
        }
        finish { ambient Ambient diffuse Diffuse }
    }
}


#macro MiteredFrameElement(Length, Width, Depth)
    intersection {
        box {
            < -Length / 2, -Width / 2, -Depth / 2 >,
            <  Length / 2,  Width / 2,  Depth / 2 >
        }
        plane {
            < -1, 0, 0 >, 0
            rotate 45 * z
            translate -(Length / 2) * x
        }
        plane {
            < 1, 0, 0 >, 0
            rotate -45 * z
            translate (Length / 2) * x
        }
    }
#end    // #macro MiteredFrameElement

#local Bot      = -ShutterHgt / 2;
#local Top      = Bot + WindowHgt;
#local Lft      = -ShutterWid / 2;
#local Rgt      = Lft + ShutterWid;
#local Frt      = -ShutterThick;
#local Bck      = 0;
#local Wid      = ShutterFrameWid;

#local Shutter =
union {
    object {
        MiteredFrameElement(ShutterWid, ShutterFrameWid, ShutterThick)
        translate < 0, Top - (Wid / 2), -ShutterThick / 2 >
        texture {
            FinishedDarkOak
            rotate 91 * y
            scale Wid * 0.2
        }
    }
    object {
        MiteredFrameElement(ShutterWid, ShutterFrameWid, ShutterThick)
        rotate 180 * z
        translate < 0, Bot + (Wid / 2), -ShutterThick / 2 >
        texture {
            FinishedDarkOak
            rotate 91 * y
            scale Wid * 0.2
        }
    }
    object {
        MiteredFrameElement(ShutterHgt, ShutterFrameWid, ShutterThick)
        rotate 90 * z
        translate < Lft + (Wid / 2), 0, -ShutterThick / 2 >
        texture {
            FinishedDarkOak
            rotate 91 * x
            scale Wid * 0.2
        }
    }
    object {
        MiteredFrameElement(ShutterHgt, ShutterFrameWid, ShutterThick)
        rotate -90 * z
        translate < Rgt - (Wid / 2), 0, -ShutterThick / 2 >
        texture {
            FinishedDarkOak
            rotate 91 * x
            scale Wid * 0.2
        }
    }

    #local Lft  = Lft + Wid;
    #local Rgt  = Rgt - Wid;
    #local Bot  = Bot + Wid;
    #local Top  = Top - Wid;
    #local YOfs = Bot + ShutterSlatWid / 2;

    #while (YOfs <= (Top - ShutterSlatWid / 2))
        box {
            < Lft, -ShutterSlatWid * 0.55, -ShutterSlatThick >,
            < Rgt,  ShutterSlatWid * 0.55,  0 >
            rotate 20 * x
            translate < 0, YOfs, Frt + ShutterSlatThick * 0.8 >
            texture {
                FinishedLightOak
                rotate 91 * y
                scale ShutterSlatWid * 0.2
            }
        }

        #local YOfs = YOfs + ShutterSlatWid;
    #end
}

#declare Window =
union {
    object { WindowPane }
    object { WindowFrame }
    object {
        Shutter
        translate -(((WindowWid + ShutterWid) * 0.5) + 1/8) * x
    }
}

#end    // _Window_Inc_
