//////////////////////////////////////////////////////////////////////////
// Yard.inc  Copyright(c) 2003, K.E. Ayers Designs                      //
//////////////////////////////////////////////////////////////////////////
// This file assembles the backyard for the scene.                      //
//////////////////////////////////////////////////////////////////////////

// This file should only be included once!
#ifndef (_Yard_Inc_)
#declare _Yard_Inc_ = true;

#debug "\nParsing: Yard.inc\n"

#include "SceneConstants.inc"
#include "PicketFence.inc"
#include "SwingSet.inc"
#include "Unicycle.inc"

#declare BackyardScene =
union {
    object {
        PicketFence
        scale 0.6
        translate < DoorXOfs, 0, 600 >
    }
    object {
        SwingSet
        scale 0.6
        rotate 45 * y
        translate < DoorXOfs + (SwingSetWid * 0.5), 0, 400 >
    }
    object {
        Unicycle
        scale 0.8
        rotate 60 * z
        rotate 60 * y
        translate < DoorXOfs - 30, 0, 150 >
    }
}

#end    // #ifndef (_Yard_Inc_)
