// Persistence of Vision Ray Tracer Scene Description File
// File: abacus.inc
// Vers: 3.5
// Desc: chinese abacus object
// Date: August 11th, 2002
// Auth: Steve Shoopak

#include "colors.inc"	
#include "textures.inc"	
#include "functions.inc"
#include "woods.inc"

#declare horizontalbar = box {
  -1,1
  scale <14.45,1,0.45>
}

#declare verticalbar = box {
  -1,1
  scale <0.45,1,7.45>
}

#declare frame = merge {
  object { horizontalbar translate   7*z scale 1.0001 }
  object { horizontalbar translate  -7*z scale 1.0002 }
  object { horizontalbar translate   2*z scale 1.0003 }
  object { verticalbar   translate  14*x scale 1.0004 }
  object { verticalbar   translate -14*x scale 1.0005 }
  texture { T_Wood6 scale 5 finish { ambient 0.5 } }
}

#declare bars = merge {
  cylinder { -y,y,1 rotate 90*x }
  #declare barcount = 1.0;
  #while (barcount<7)
    cylinder { -y,y,1 rotate 90*x translate +x*barcount*8 }
    cylinder { -y,y,1 rotate 90*x translate -x*barcount*8 }
    #declare barcount = barcount + 1;
  #end
  scale <0.25,0.25,7>
  texture { T_Wood13 finish { ambient 0.5 } }
}

#declare bead = sphere { 0,1 scale <1,1,0.5> texture { pigment { color White } } }

#declare beadrow = union {
  object { bead translate  z*6 }
  object { bead translate  z*5 }
  object { bead translate -z*6 }
  object { bead translate -z*5 }
  object { bead translate -z*4 }
  object { bead translate -z*3 }
  object { bead translate -z*2 }
}

#declare beads = merge {
  object { beadrow }
  #declare barcount = 1.0;
  #while (barcount<7)
    object { beadrow translate +x*barcount*2 }
    object { beadrow translate -x*barcount*2 }
    #declare barcount = barcount + 1;
  #end
}

#declare abacus = merge {
  object { frame }
  object { bars  }
  object { beads }
}