// Persistence of Vision Ray Tracer Scene Description File
// File: exabaco.pov
// Vers: 3.5
// Desc: Digital numbers born of the abacus through the
//       foggy window of space-time
// Date: August 28th, 2002
// Auth: Steve Shoopak

#include "colors.inc"

// radiosity (global illumination) settings
global_settings {
  radiosity {
    pretrace_start 0.08
    pretrace_end   0.04
    count 350           
    nearest_count 10    
    error_bound 5    
    recursion_limit 5  
    low_error_factor .5
    gray_threshold 0.0 
    minimum_reuse 0.015
    brightness 1       
    adc_bailout 0.01/2
    normal on          
    media on           
  }
}

#include "screen.inc"

#declare by = text {
  ttf "papyrus.ttf",
  "by Steve Shoopak (c) 2003"
  0.01,0
  texture { pigment { color White } finish { ambient 1 } }
  scale 0.05
}

Set_Camera(<0,8,0>,<0,0,1.001>,60)
Screen_Object(by,<0.05,0.05>,0,false,1)

light_source {
  0
  color 0
  translate y
}

#declare button = sphere {
  0,1
  texture {
    pigment {
      color <0,0.3,1> transmit 0.5
    }
    finish {
      ambient 0.1
      reflection 0.25
      specular 0.5
    }
  }
  scale <1,0.25,1>
}

#declare zero = light_source {
  0
  color 2
  area_light
  <0.5,0,0><0,0,0.5>
  4,4
  adaptive 0
  jitter
  circular
  orient    
  looks_like {
    union {
      torus {
        0.5,0.05
        texture {
          pigment {
            color Yellow transmit 0.25
          }
          finish {
            ambient 0.75
          }
        }
        scale <1,2,1>
      }
      torus {
        0.5,0.05
        texture {
          pigment {
            color Yellow transmit 0.25
          }
          finish {
            ambient 0.75
          }
        }
        scale <0.25,2,1>
        rotate y*30 
      }
    }
  }
}

#declare one = light_source {
  0
  color 2
  area_light
  <0.5,0,0><0,0,0.5>
  4,4
  adaptive 0
  jitter
  circular
  orient    
  looks_like {
    sphere {
      0,0.5
      texture {
        pigment {
          color Yellow transmit 0.25
        }
        finish {
          ambient 0.95
        }
      }
      scale <0.125,0.25,1.25>
    }
  }
}

#declare b0 = union {
  object { button }
  object { zero }
}

#declare b1 = union {
  object { button }
  object { one }
}

#declare b01 = union {
  object { b0 translate <-1.25,0,1.25> }
  object { b1 translate <+1.25,0,0.125> }
  translate 0
}

#include "abacus.inc"

#declare leekai = merge {
  merge {
    object { abacus translate -14.5*x }
    object { abacus translate  14.5*x }
    translate z*13.5
  }
  object { abacus scale <2,1,2> translate -8.5*z }
}

#declare under = object { leekai scale 0.1 rotate -x*20 translate -y*0 rotate x*90 translate <0,-1,0> }

object { b01 }
object { under }
plane {
  y,-1
  texture {
    pigment {
      wrinkles
    }
    finish {
      ambient 0.1
    }
  }
}