// Persistence of Vision Ray Tracer Scene Description File
// File: human_b.pov
// Vers: 3.5
// Desc: Radiosity Scene Template
// Date: 15/08/2003
// Auth: Jean-Charles Marteau
// Title : Human Body
//         IRTC 08/2003 - Surrealism

#version 3.5;

// Standard includes
#include "golds.inc"
#include "metals.inc"
#include "functions.inc"
#include "transforms.inc"
#include "shapes.inc"

#include "oeil.inc"

#declare With_Rose=off;
#declare With_Boudha=off;
#declare With_Eyes=on;
#declare With_Femme=on;

#declare area_lights=3;
#declare Nb_Epines=30;
#declare Nb_Chardon=130;

#declare With_Main_Light=on;
#declare With_Fill_Light=on;
#declare With_Back_Light=on;

global_settings {
  assumed_gamma 1.0
  max_trace_level 5
}

#default {
  texture {
    pigment {rgb 1.0 }
    finish {
      ambient 0.05
      diffuse 0.6
      specular 0.3
    }
  }
}

// ----------------------------------------

camera {
  right x*image_width/image_height
  location  <1,2.0,-2>*2.5
  look_at   <0,-0.5,-0.7>
}

#if (With_Main_Light)
  light_source {
    <20,10,-10>       // light's position
    color rgb <1, 0.9, 0.8>
    #if (area_lights > 1)
      area_light
      <2, 0, 0> <0, 0, 2> // lights spread out across this distance (x * z)
      area_lights, area_lights
      adaptive 0          // 0,1,2,3...
      jitter              // adds random softening of light
      circular            // make the shape of the light circular
      orient              // orient light
    #end
    fade_distance 25
    fade_power 2
  }
#end

#if (With_Fill_Light)
  light_source {
    <-10,17,-40>       // light's position
    color rgb <1, 1, 1>/4  // light's color
    #if (area_lights > 1)
      area_light
      <8, 0, 0> <0, 0, 8> // lights spread out across this distance (x * z)
      2,2
      adaptive 0          // 0,1,2,3...
      jitter              // adds random softening of light
      circular            // make the shape of the light circular
      orient              // orient light
    #end
  }
#end

#if (With_Back_Light)
  light_source {
    -<0,0.1,-25>       // light's position
    color rgb <1, 1, 1>  // light's color
    #if (area_lights > 1)
      area_light
      <8, 0, 0> <0, 0, 8> // lights spread out across this distance (x * z)
      2,2
      adaptive 0          // 0,1,2,3...
      jitter              // adds random softening of light
      circular            // make the shape of the light circular
      orient              // orient light
    #end
  }
#end

// ----------------------------------------

// ----------------------------------------

#declare P_Fond=pigment {
  granite
  scale 0.1
}

#declare P_Cracks=pigment {
  crackle
  turbulence 0.2
  pigment_map {
    [0.0 rgb 0.0]
    [0.007 rgb 1.0]
    [1.0 rgb 1.0]    
  }
  scale 2
}

#declare P_MCracks=pigment {
  dents
  triangle_wave
  pigment_map
  {
    [0.0 rgb 1.0]
    [0.4 rgb 1.0]
    [1.0 P_Cracks scale 3]
  }
  scale 0.8
}

#declare P_CStone=pigment {
  average
  sine_wave
  pigment_map
  {
    [1.0 P_MCracks]
    [0.17 P_Fond]
  }
  scale 0.3
}

// Pigments
#declare P_Trous=pigment {
  agate
  color_map
  {
    [0.0 rgb <1,0,0>]
    [1.0 rgb 0.3]
  }
  scale 0.01
}

#declare P_Surface=pigment {
  granite
  color_map
  {
    [0.0 rgb 0.9]
    [1.0 rgb 1]
  }
  scale 1
}

#declare P_CSurface=pigment {
  pigment_pattern { P_MCracks }
  pigment_map
  {
    [0.0 P_Trous]
    [0.1 P_Surface]
    [1.0 P_Surface]
  }
}

#declare F_Stone=function { pigment { P_CStone } };

#declare T_Stone=texture {
  normal { pigment_pattern { P_CStone } 2.0 }
}

#local Bac_A_Fleur=object {
  Supertorus (2.25, 0.25, 0.1, 0.1, 0.01, 1.5)
  translate <0,0.2-0.1,0>
  texture { T_Stone }
}

#local Sol=box {
  <-100,-0.1,-100>, <100,0,100>
  texture { T_Stone }
}

// ----------------------------------------

#if (With_Rose)
  #include "rose.inc"
  union {
    object { Fleur }
    object { CSG001 }
    rotate <-7.434449, -13.032757, -0.0>
    translate  <-5.491568, 3.957116, 27.677992>
    rotate -90*x
    rotate -90*y
    scale <0.05,0.05,0.05>
  }
#end

#macro Chardon (N, Sharpness, TheSeed)
union {
  cylinder { <0,-1.0,0>, <0,1.0,0>, 0.01 }
  union {
    #local i=0;
    #while (i<N)
      #local a1=360*rand(TheSeed);
      #local a2=360*rand(TheSeed);
      #local a3=360*rand(TheSeed);
      union {
	cone { 0, Sharpness, < 0.2,0,0>, 0 }
	cone { 0, Sharpness, <-0.2,0,0>, 0 }
	rotate <a1,a2,a3>
      }
      #local i=i+1;      
    #end
    translate <0,1,0>
  }
}
#end

#local MySeed=seed(7);

// Positionnement des chardons avec un ecart minimum.
#declare Positions=array[Nb_Chardon];

#if (With_Rose)
  #declare Positions[0]=<0,0,0>;
  #local i=1;
#else
  #local i=0;
#end

#if (With_Boudha)
  #include "boudha.inc"
  object {
    boudha
    texture { T_Copper_4A }
    scale 0.035
    rotate 130*y
    translate <1,0,4>
  }
#end

#while (i<Nb_Chardon)
  #local Pos_OK=false;
  #local Bouclage=0;
  #while (!Pos_OK & i<Nb_Chardon)
    #local Pos=
    <3.8*rand(MySeed)-1.9,
    0,
    3.8*rand(MySeed)-1.9>;
    #local j=0;
    #local Pos_OK=true;
    #while (j<i)
      #if (vlength (Pos-Positions[j])<0.18)
	#local Pos_OK=false;
	#local j=i;
      #end
      #local j=j+1;
    #end
    #local Bouclage=Bouclage+1;
    #if (Bouclage=50)
      #debug concat ("\nNb chardon effectif : ", str(i,0,0), "\n")
      #local i = Nb_Chardon;
    #end
  #end
  #if (Pos_OK)
    #declare Positions[i]=Pos;
    object { Chardon (Nb_Epines, 0.008, MySeed) translate Pos }
  #end
  #local i=i+1;
#end

#macro Pose_Oeil (From_Pos, To_Pos, OnObj, Echelle)
union {
  #local Norm=<0,0,0>;
  #local Pos=trace (OnObj, From_Pos, To_Pos, Norm);
  object { Oeil(0.8,rgb <0,0,1>, rgb <0,1,0>) rotate 75*x rotate 360*y*rand(MySeed) scale 4.5 translate <0,0.7,0> }
  object { Support_Plan translate -0.03*y }
  transform { Reorient_Trans(y, Norm) }
  scale Echelle
  translate Pos
  texture { T_Stone }
}
#end

object { Bac_A_Fleur }
object { Sol }

#if (With_Eyes)
  object { Pose_Oeil (<0,1,-1.6>,<0,-1,-1.6>, Sol, 0.4) }
  object { Pose_Oeil (<-2,10,1>,<-2,-10,1>, Sol, 0.8) }
#end

#declare T_Body=texture {
  pigment {rgbt <0,0,1,1> }
  finish {
    ambient 0.0
    diffuse 0.05
    specular 0.6
    roughness 0.005
    reflection {
      0.1, 1.0
      fresnel on
    }
    conserve_energy
  }
}

#declare I_Body=  interior {
  ior 1.5
  fade_power 1001
  fade_distance 0.9
  fade_color <0.5,0.8,0.6>
}


#declare M_Body=material {
  texture { T_Body }
  interior { I_Body }
}

#local T_Vetement=texture {
  pigment { rgb <0,0,1> }
  normal { facets scale 0.01 bump_size 0.1 }
}

#declare T_Femme=texture {
  gradient y
  texture_map {
    [0.0 T_Stone ]
    [0.4 T_Stone ]
    [0.5 T_Vetement ]
    [0.95 T_Vetement ]
    [0.97 T_Stone ]
    [1.0 T_Stone ]
  }
}

#declare M_Femme=material {
  texture { T_Femme }
  interior { I_Body }
}


// ----------------------------------------
#local Echelle=5;
#declare fn_X = function(x,y,z) { (f_noise3d(x*Echelle,y*Echelle,z*Echelle)/7 + f_piriform((y+1.5)/6, x, z, 1))*y - 0.1 }
#if (With_Femme)
  isosurface {
    function { fn_X(x, y, z) }
    contained_by { box { <-2,-1,-2>,<2,5,2> } }  // container shape
    accuracy 0.001                      // accuracy of calculation [0.001]
    max_gradient 20                      // maximum gradient the function can have [1.1]
    scale 1/2
    translate <3,-0.01,-1.5>
    material { M_Femme scale 2 }
    photons {
      target 1.0
      refraction on
      reflection on
    }
  }
#end
