// ---------------------------------- Oeil
#macro Text_Oeil(Radius, P_Iris)
texture {
    pigment {
      cylindrical
      pigment_map {
	[0.00 color rgb 1.0 ]
	[0.45 color rgb 1.0 ]
	[0.50 Pig_Iris ]
	[0.65 Pig_Iris ]
	[0.70 color rgb 0.0 ]
	[1.00 color rgb 0.0 ]
      }
      scale Radius/5
    }
    finish { ambient 0.3 }
    rotate 90*x
}
#end

#macro Oeil (Radius, Col1, Col2)

#local Pig_Iris=pigment {
    radial
    frequency 40
    turbulence 0.08
    color_map {
      [0.00 color rgb <0.0,0.0,0.0>]
      [0.01 color rgb Col1]
      [0.00 color rgb Col1]
      [0.50 color rgb Col1+0.6*Col2]
      [1.00 color rgb 0.5*Col1+0.6*Col2]
    }
  }

sphere {
  0, Radius/5
  Text_Oeil(Radius, Pig_Iris)
}
#end

// ---------------------------------- Support
#declare fn_Support = function(x,y,z) { f_sphere (x,(y+0.5)-sqrt(x*x+z*z),z,1)*y - 0.03 }

#declare Support_Plan=isosurface {
  function { fn_Support (x, y, z) }        // alternative declared function
  contained_by { sphere { 0, 2 } }  // container shape
  //threshold 0.0                     // optional threshold value for isosurface [0.0]
  accuracy 0.001                      // accuracy of calculation [0.001]
  max_gradient 20
  //evaluate 5, 1.2, 0.95             // evaluate the maximum gradient
  //max_trace 1                       // maybe increase for use in CSG [1]
  //all_intersections                 // alternative to 'max_trace'
  //open                              // remove visible container surface
}
