// Persistence of Vision Ray Tracer Scene Description File
// File: jc_noway.pov
// Vers: 3.1
// Desc: The Impossible 3D Image
// Date: 07/07/2003
// Auth: John Corraro
//

#version 3.1

#include "colors.inc"

global_settings
{
  assumed_gamma 1.0
}

// ----------------------------------------
camera
{
  location  <19.8, 5.30, -6.60>

  direction 1.5*z
  right     4/3*x
  look_at   <0.0, 2,  1.0>
}

sky_sphere
{
  pigment
  {
    color White
  }
}

 
 
 
 light_source {
    <5, 3, -12>
    color Gray50
  }

  light_source {
    <-4, 3, -2>
    color Gray10 
  }

  light_source {
    <11, 11, 10.5>
    color Gray70
  }

  light_source {
    <15, -10, 18>
    color Gray10
  }

// ----------------------------------------
plane { y, -10 
        pigment {
                checker color Red, color White
                scale <20, 20, 20>
                
        }
        translate <0. 0, -12.5>
}


 //This is the "impossible" shape
 
#declare myShape = union{

        difference{
                   box{
                       <0,0,0>  // one corner position <X1 Y1 Z1>
                       < 1,  10,  1>  // other corner position <X2 Y2 Z2>
                   } // end box
 
                   box{
                       <0,0,0>  // one corner position <X1 Y1 Z1>
                       < 3, 3, 3>  // other corner position <X2 Y2 Z2>
                       translate-<1.5, 1.5, 1.5>
                       rotate<48, 0, 0>
                       translate<.5, 10.1, 1.1>
                   } // end box
 
         } // end difference
 
         box{
             <0,0,0>  // one corner position <X1 Y1 Z1>
             < 1,  1,  10>  // other corner position <X2 Y2 Z2>
         } // end box

         box{
             <0,-.5,9>  // one corner position <X1 Y1 Z1>
             < -11.4,1,10>  // other corner position <X2 Y2 Z2>
         } // end box
    
         text {
               ttf "timrom.ttf" "John Corraro" .2, 0
               rotate <0, -90, 90>
               translate <1.3, 1.5, 8>
               scale .7
               pigment { Red }
        } // end text
 } // end union
 
 
 
 
 
 object{ myShape                        // shape 1
           pigment {color White}
           translate <2, -2.5, 0>
           rotate <0,0, -45> 
           translate -<2, -3.5, -3>
 } // end object
      

 
 object{ myShape
            pigment {color White}
            translate <-100, -10, -10>
 } // end object


 object{ myShape
            pigment {color White}
            translate <2, -2.5, 0>
            rotate <20, 10, -20> 
            translate <-110, 5, -8>
 } // end object

 
  object{ myShape
            pigment {color White}
            translate <2, -2.5, -5>
            rotate <40,20, -55> 
            translate <-50, 10.5, -1>
 } // end object
      

 object{ myShape
           pigment {color White}
           translate <2, -2.5, -5>
           rotate <20,0, -55> 
           translate <-35, 5.5, 4>
 } // end object

 object{ myShape
           pigment {color White}
           translate <2, -2.5, -0>
           rotate <15,0, -45> 
           translate <-25, 3.5, 5>
 } // end object

