
#version 3.5  ;

#include "colors.inc"
#include "functions.inc" 
#include "stones.inc"
#include "woods.inc"  
#include "skies.inc"     
#include "metals.inc"


// Majesty by chano August 2003 
//
// This image is best rendered with an aspect ratio of 3x2 - [1200x800,AA 0.2] recommended.

 
 #declare F = false;
 #declare T = true;
 #declare R = seed(1); 
 
//----------------------------Scene Variables ----------------------------  
   
 #declare players = T;  
 #declare cracklers = T; 
 #declare horizont = T; 
 #declare arcades = T;
 
 #declare floor_height = 0.25;   

//----------------------------Global Settings ----------------------------

 #declare radiosityOn = F;
 #declare photonsOn = F;
 #declare fogOn = F;   
 #declare isonoise = F;   
 #declare sunlight = T;  

 
 #declare global_diffuse = 0.7;  
 #if(radiosityOn)
 #declare global_ambient = 0.0;
 #else 
 #declare global_ambient = 0.05;
 #end
 #declare global_gradient = 4; //4
 #declare global_accuracy = 0.001; //0.0001
 
 #declare sun_location = <50, 30, -70>;    
 #declare sun_point_at = <0,0,0>;     
  
  
 #declare cam_location =  <-10,5.2,-15>; 
 #declare cam_look_at = <50,5,5>  ; 
 
 global_settings { 
  number_of_waves 10 
  assumed_gamma 0.8
  #if(photonsOn)
   max_trace_level 5
   photons {
      spacing 0.004  // higher value than 0.001 means 'lower' quality, faster parsing.
      autostop 0
      jitter 0.5
      max_trace_level 15 
    
      
  } 
  
 #end
  
  #if(radiosityOn)
    radiosity {  
    
      //settings for a very fast but smooth shading, without "dirty" spots ! 
      
      pretrace_start 0.08  // 3 pretrace subdivisions 
      pretrace_end   0.02  // max and min level :: 0.08 - 0.02
      count 200            // 500 min for good results 

      nearest_count 10   // 12  , increase if necessary
      error_bound 0.6    // 0.5 , less makes slow but more detailed edges and more dirty spots !
      recursion_limit 1  // 1   , higher slows down immensly, better leave it for caustics and photons 
      
      // leave this values 
      low_error_factor 0.2
      gray_threshold 0.0
      minimum_reuse 0.015
      brightness 1

      adc_bailout 0.01/2


  } #end


}  

 
//------------------------Texture Declaration ----------------------------------------
 
 
 

#declare rough_metal =  texture { 
        pigment { color rgb < 0.34,0.364,0.38> } 
        finish{ ambient global_ambient diffuse 0.4 specular 0.6 } 
        normal{ agate 0.2 turbulence 0.5 scale 0.1 }
        }   
            
 
#declare rough_wall =  texture { 
        pigment { color rgb <0.7,0.7,0.76> } 
        finish{ ambient global_ambient diffuse 0.8 crand 0.03 } 
        normal{ agate 0.15 turbulence 0.4 }
        }
 
 
#declare brown_soil = texture {
 
 pigment { color rgb <0.56,0.5,0.35> }
 
 finish { diffuse 0.6 ambient global_ambient  crand 0.06}
 }
 
 

#declare dark_brick= texture {
 
 pigment { color rgb <0.32,0.35,0.36> }
 
 finish { diffuse 0.6 ambient global_ambient  crand 0.01 phong 0.08}
 }
 
 
#declare bright_brick = texture {
 
 pigment { color rgb <0.96,0.96,0.98> }
 
 finish { diffuse 0.6 ambient global_ambient  crand 0.01 phong 0.08}
 }
    
           
#declare shiny_black = texture {
 
 pigment { color rgb <.1,.1,.1> }
 
 finish { diffuse 0.5 ambient global_ambient phong 0.5 phong_size 80 specular 0.3 }
}

#declare wood_finish =  finish { ambient global_ambient diffuse 0.8 specular 0.5 roughness 0.01 };

#declare bright_wood = 
   texture { pigment { P_WoodGrain3A  color_map { M_Wood3A }}  finish { wood_finish }} 
   texture { pigment { P_WoodGrain3B  color_map { M_Wood3B }}  finish { wood_finish }} ;

#declare dark_wood =
   texture {  pigment{ P_WoodGrain1A color_map { M_Wood12A }}  finish { wood_finish }}
   texture {  pigment{ P_WoodGrain1B color_map { M_Wood12B }}  finish { wood_finish }}  ;
 
 
#macro white_chess() 

texture { bright_wood   scale 4 rotate x*90 translate rand(R)*100*y}

#end


#macro black_chess() 

texture { dark_wood     scale 4 rotate x*90 translate rand(R)*100*y }   

#end     


#declare yellow_plastic = texture {
 
 pigment { color rgb <0.99,0.99,0.6> }
 
 finish { diffuse 0.7 ambient global_ambient  phong 0.5}
 }    
 
 
#declare eye_black = texture {
 
 pigment { color rgb 0 }
 
 finish { diffuse 0.0 ambient global_ambient roughness 0.001 specular 0.8 }
}

#declare eye_white = texture {
 
  pigment {
                        agate
                        turbulence 0.6
                        color_map
                           {
                            [0.0  color rgb 1]    
                            [0.97 color rgb 1]
                            [0.98 color rgb <1, 0.9, 0.9>]
                            [1.0  color rgb <0.8, 0, 0>]
                           }
                        
                                        
                        scale <.2,.2,10>
                
                      
                        
                      } 
 
 finish { diffuse 0.6 ambient global_ambient roughness 0.001 specular 0.8 }
}


#declare eye_line = texture {
 
 pigment { color rgb <0.01,0.05,0.1> }
 
 finish { diffuse 0.2 ambient global_ambient roughness 0.001 specular 0.8 }
}      


#declare eye_blue = texture {
 
  pigment {
                        ripples
                        turbulence 0.8
                        color_map
                           {
                            [0.0  color rgb <0.0, 0.1, 0.2>]
                            [0.6  color rgb <0.1, 0.2, 0.3>]
                            [0.7  color rgb <0.15, 0.2, 0.4>]
                            [0.75 color rgb <0.2, 0.3, 0.5>]
                            [1.0  color rgb <0.2, 0.35, 0.6>]
                           }
                        
                                        
                        scale 0.05 
                        
                      
                        
                      } 
 
 finish { diffuse 0.5 ambient global_ambient roughness 0.001 specular 0.8 }
} 


#declare eye_green = texture {
 
  pigment {
                        ripples
                        turbulence 0.8
                        color_map
                           {
                            [0.0  color rgb <0.0, 0.2, 0.1>]
                            [0.6  color rgb <0.1, 0.3, 0.15>]
                            [0.7  color rgb <0.15, 0.4, 0.2>]
                            [0.75 color rgb <0.2, 0.5, 0.2>]
                            [1.0  color rgb <0.2, 0.6, 0.2>]
                           }
                        
                                        
                        scale 0.05 
                        
                      
                        
                      } 
 
 finish { diffuse 0.5 ambient global_ambient roughness 0.001 specular 0.8 }
}  

     

#declare blue_eye = texture {
    
    gradient z     
    texture_map {     
   
      [0.0  eye_white]          
      [0.9  eye_white] 
        
      [0.9  eye_line]  
      [0.91 eye_line] 
      [0.93 eye_blue] 
      [0.97 eye_blue] 
      [0.98 eye_black] 
      [1.0 eye_black] 
    }    
    
    
  }
  
  
  
#declare green_eye = texture {
    
    gradient z     
    texture_map {     
   
      [0.0  eye_white]          
      [0.9  eye_white] 
        
      [0.9  eye_line]  
      [0.91 eye_line] 
      [0.93 eye_green] 
      [0.97 eye_green] 
      [0.98 eye_black] 
      [1.0 eye_black] 
    }    
    
    
  }  


//------------------------Material Declaration ----------------------------------------

#declare M_Water=    // Water material
material {
  texture {
    pigment {rgbt 0.9}
    finish {
      ambient 0.0
      diffuse 0.0
      specular 0.4
      roughness 0.004
      reflection {
        0.05, 1.0
        fresnel on
      }
      conserve_energy
    }
  }
  interior {
    ior 1.35
    fade_power 1000
    fade_distance 0.2
    fade_color <0.93,0.95,0.95>
  }
}

//standard glass material 
#declare M_Glass=    // Glass material
material {
  texture {
    pigment {rgbt <0.9,0.4,0.2,0.7>}
    finish {
      ambient 0.0
      diffuse 0.0
      specular 0.6
      roughness 0.005
      reflection {
        0.1, 0.7
        fresnel on
        }
      conserve_energy
    }
  }
  interior {
    ior 1.4
    fade_power 1001
    fade_distance 1.6
    fade_color <0.85,0.8,0.4>
  }
} 
                                                                            
//------------------Function Declaration ------------------------------  
                                                                           
                                                                            
                                                                            
 #declare fn_AgateHard= function {
        pigment {
        agate  scale 0.3
        color_map { [0 color rgb 0] [1 color rgb 1] }
        }
  }                                                                               
                                                                            

#declare crackles =function{

        pigment{
          crackle 
          turbulence 0.1
          color_map { [0 rgb 1] [1 rgb 0] }
          scale 0.5
          }
}

#declare nipples =function{

       pigment{
          leopard
          turbulence 0.25
        
          color_map { [0 rgb 1] [1 rgb 0.2] }
          scale 0.045
        }

}    

#declare spotters =function{

       pigment{
          leopard
          turbulence 0.05
        
          color_map { [0 rgb 1] [1 rgb 0.2] }
          scale 0.035
        }

}      



 

//------------------Object Declaration ------------------------------  


#declare silver_city =  height_field {  

      gif
      "hf01"
      smooth       
      water_level 0.01
      texture{ pigment {color rgb 1} finish{ phong 0.2 diffuse 0.9 ambient global_ambient} }
      
      scale <3,1,3>
           
     
    }



//                                   2       0.2
#macro iso_ground(l_depth,l_width,l_factor,r_factor,l_shift) 


#declare landscape = function {

     (f_hetero_mf(l_factor*x-l_shift,l_factor*y,l_factor*z-l_shift, 1.6, 2.4, 6, 0, 0, 0)+2)
   
     *f_ridged_mf(r_factor*x-l_shift,r_factor*y,r_factor*z-l_shift, 1.6, 2, 2, 0, 0.5, 0)
   

}


isosurface{
 
  
    function { y
          
       
            - landscape(x,y,z)   
       
    }  
   max_gradient global_gradient
   accuracy global_accuracy
   
   threshold 0
   contained_by { box { <0,3,-l_width>,<l_depth,-0.1,l_width> } }
   
  
   
   
   
}   

#end


#macro stone_brick(b_height,b_size,b_rad,b_rough) 
  
  #declare s_f = 0.1;
  #declare delta_x = rand(R)*100;
  #declare delta_y = rand(R)*100;
  #declare delta_z = rand(R)*100;
   
   isosurface{

  
    function { 
          
          f_rounded_box(x,y,z,b_rad,b_size,b_height,b_size)  
      
        
         #if(isonoise)
         - fn_AgateHard(s_f*x+delta_x,s_f*y+delta_y,s_f*z+delta_z).gray * b_rough    
         #end
      
        }

 
   max_gradient global_gradient
   accuracy global_accuracy
   contained_by { box { <-1.2*b_size,-1.2*b_height,-1.2*b_size>,<1.2*b_size,1.2*b_height,1.2*b_size> } }

   
   texture { pigment { color <0.5+ rand(R)*0.1,0.5+ rand(R)*0.1,0.5+ rand(R)*0.1>} 
                    finish{  ambient global_ambient diffuse 0.5 } 
                }
           
   texture {   
             pigment {
                        granite
                          turbulence 0.4
                          color_map
                           {[0.000, 0.154   color rgbt <0.894, 0.886, 0.886, 0.659>
                                            color rgbt <0.745, 0.745, 0.753, 0.584>]
                            [0.154, 0.308   color rgbt <0.745, 0.745, 0.753, 0.584>
                                            color rgbt <0.902, 0.902, 0.859, 0.780>]
                            [0.308, 0.444   color rgbt <0.902, 0.902, 0.859, 0.780>
                                            color rgbt <0.729, 0.706, 0.694, 0.686>]
                            [0.444, 0.615   color rgbt <0.729, 0.706, 0.694, 0.686>
                                            color rgbt <0.588, 0.592, 0.635, 0.424>]
                            [0.615, 0.803   color rgbt <0.588, 0.592, 0.635, 0.424>
                                            color rgbt <0.608, 0.616, 0.659, 0.761>]
                            [0.803, 1.001   color rgbt <0.608, 0.616, 0.659, 0.761>
                                            color rgbt <0.894, 0.886, 0.886, 0.659>]
                           }
                                        
                        scale 3
                      } 
                
                finish{  ambient global_ambient diffuse 0.5 specular 0.05} 
                        
                translate <delta_z,delta_x,delta_y>
                                
             }     
   
 }      
#end  




#macro wall_block (blocK_size) 
                    
  #declare s_f = 0.3;
  #declare delta_x = rand(R)*1000;
  #declare delta_y = rand(R)*1000;
  #declare delta_z = rand(R)*1000;
   
   isosurface{

  
    function { 
         
         -z
                 
         #if(isonoise)
         - fn_AgateHard(s_f*x+delta_x,s_f*y+delta_y,s_f*z+delta_z).gray * 0.05    
         #end
      
        }

 

   contained_by { box { <0,0,-0.2>,<blocK_size-rand(R)*0.1,blocK_size,blocK_size> } }
   
   max_gradient global_gradient
   accuracy global_accuracy   
   
   threshold rand(R)*0.15
   
   #declare color_os = rand(R)*0.2;
   texture { pigment { color <0.65 + color_os,0.62 + color_os ,0.60 + color_os>} 
            finish{  ambient global_ambient diffuse global_diffuse specular 0.1 } 
        }
   
   
 }      
#end  
                         
                         
#macro block_wall(x_count, y_count,b_size,end_piece)
    
    union{
    
    
    #if(end_piece = 0) 
        
        #declare x_count = x_count * 0.5;
        
    #end
    
    #declare yc = 0;
    #while(yc < y_count)
        #declare xc = 0;
        #while(xc < x_count)
                  
                  
            object{ wall_block(b_size) translate < xc*b_size + mod(yc,2)*b_size*0.5 , yc*b_size*1.01, 0> }   
                  
                
        #declare xc = xc + 1;
        
        #end
        
        
        #if(end_piece = 0 & mod(yc,2) = 0) 
             
            object{ wall_block(b_size) scale <0.5,1,1> translate < xc*b_size + mod(yc,2)*b_size*0.5 , yc*b_size*1.01, 0> }       
        
        #end
         
        
        
        #declare yc = yc + 1; 
    #end

    }

#end      

#macro wall_socket (s_length, s_height, s_depth,s_rad, w_depth, end_piece)

      
      difference {
         union {
                #declare rad = s_height * 0.1;
                #declare cyl = s_height - rad;
                
                box{ <0,0,0>,<s_length, s_height, s_depth> }  
                box{ <0,cyl,s_depth>,<s_length, s_height, s_depth + w_depth> }  
                
                cylinder { <0,cyl,0.1>,<s_length,cyl,0.1>, rad }
                cylinder { <0,cyl-rad*1.5,0.0>,<s_length,cyl-rad*1.5,0.0>, rad/2 }    
                cylinder { <0,rad*0.5,0.0>,<s_length,rad*0.5,0.0>, rad/2 }
                }
         
         cylinder{ <0,0,-1>,<0,0,s_depth+1>, s_rad }
         
         #if(end_piece = 0) 
                
                box { <s_length-s_rad,-1,-10>,<2*s_length,2*s_height,2*w_depth> }
         #else 
         
                cylinder{ <s_length,0,-1>,<s_length,0,s_depth+1>, s_rad }                                           
         #end                                           
         
                                                                                                             
         texture { rough_wall translate<rand(R)*100,rand(R)*100,rand(R)*100>}                                      
      
      } 


#end


#macro column (height)

        #declare delta_x = rand(R)*1000;
        #declare delta_y = rand(R)*1000;
        #declare delta_z = rand(R)*1000;
        
        
        
        lathe {
        
        
         cubic_spline
         13,
         <-5,0>,
         <0,0>,
         <0.7,0>,
         <0.8,0.0>,
         <0.8,0.2>,
         <0.7,0.5>,
         <0.4,1>,
         <0.4,height/2>,
         <0.4,height-1>,
         <0.9,height-0.5>,
         <1,height>,
         <0.4,height>,
         <-5,height>
              
         texture { pigment { color <0.8+ rand(R)*0.2,0.8+ rand(R)*0.2,0.5+ rand(R)*0.2>} 
                    finish{  ambient global_ambient diffuse global_diffuse specular 0.01 } 
                }
           
          texture {   
                pigment {
                        granite
                          turbulence 0.6
                          color_map
                           {[0.000, 0.154   color rgbt <0.894, 0.886, 0.886, 0.659>
                                            color rgbt <0.745, 0.745, 0.753, 0.584>]
                            [0.154, 0.308   color rgbt <0.745, 0.745, 0.753, 0.584>
                                            color rgbt <0.902, 0.902, 0.859, 0.780>]
                            [0.308, 0.444   color rgbt <0.902, 0.902, 0.859, 0.780>
                                            color rgbt <0.729, 0.706, 0.694, 0.686>]
                            [0.444, 0.615   color rgbt <0.729, 0.706, 0.694, 0.686>
                                            color rgbt <0.588, 0.592, 0.635, 0.424>]
                            [0.615, 0.803   color rgbt <0.588, 0.592, 0.635, 0.424>
                                            color rgbt <0.608, 0.616, 0.659, 0.761>]
                            [0.803, 1.001   color rgbt <0.608, 0.616, 0.659, 0.761>
                                            color rgbt <0.894, 0.886, 0.886, 0.659>]
                           }
                                        
                        scale 3
                      } 
                
                finish{ ambient global_ambient diffuse global_diffuse specular 0.3 }
                        
                translate <delta_z,delta_x,delta_y>
                                
             }     
              
        
           }
           
   
#end    


 


#macro floor_brick(b_height,b_size,b_rad,b_rough,b_frequency) 
  

  #declare delta_x = rand(R)*100;
  #declare delta_y = rand(R)*100;
  #declare delta_z = rand(R)*100;
   
   isosurface{

  
    function { 
          
          f_rounded_box(x,y,z,b_rad,b_size,b_height,b_size)  
      
        
         #if(isonoise)
         - fn_AgateHard(b_frequency*x+delta_x,b_frequency*y+delta_y,b_frequency*z+delta_z).gray * b_rough    
         #end
      
        }

 
   max_gradient global_gradient
   accuracy global_accuracy
   contained_by { box { <-1.2*b_size,-1.2*b_height,-1.2*b_size>,<1.2*b_size,1.2*b_height,1.2*b_size> } }

   
  
 }      
#end  



#macro brick_floor (x_count, z_count,b_size,b_height)
    
    union{
    
    
    
    #declare zc = 0;
    #while(zc < z_count)
        #declare xc = 0;
        #while(xc < x_count)
                  
            
            #declare h_rand = rand(R)*0.1;     
            object{ stone_brick(b_height+h_rand,b_size*0.9,0.1,0.1) translate < (1+2*xc)*b_size ,(h_rand+b_height)*0.5 ,(1+2*zc)*b_size> }   
                  
                
        #declare xc = xc + 1;
        
        #end
        
       #declare zc = zc + 1; 
    #end

    }

#end      


#macro striped_floor(x_count, z_count,b_size,b_height,b_stair)
    
    union{
    
    
    #declare stare_depth = 5;
    #declare hstep = stare_depth/(x_count-1);
    #declare zc = 0;
    #while(zc < z_count)
        #declare xc = 0;
        #while(xc < x_count)
                  
            
            #declare h_rand = rand(R)*0.03;     
            object{ 
                
                
                floor_brick(b_height+h_rand,b_size*0.98,0.06,0.02,0.75) 
                
                
                
                #if (mod(zc+xc,2) = 0)  texture { bright_brick }
                #else texture { dark_brick }
                #end   
                
                translate < (1+2*xc)*b_size ,(h_rand+b_height)*0.5 , -(1+2*zc)*b_size> 
                
                #if(zc = b_stair) 
                  translate -y*xc*hstep 
                #end
                
                
                }   
                  
                
        #declare xc = xc + 1;
        
        #end
        
       #declare zc = zc + 1; 
    #end

    }

#end      

#declare metal_ring = union{

        cylinder{ <0,0,-0.4>,<0,0,0>,0.1 }
        torus{ 0.4,0.15 rotate z*90 translate -0.8*z } 
        torus{ 0.7,0.12 rotate x*90 translate <0,-0.83,-0.8> }
        
        
        texture{ rough_metal }

}



#macro column_wall (sections, height, rows, rear, depth,base)
    
    #declare section = 0;
    #declare socket_length = 6;
    #declare socket_height = 4;
    #while (section <= sections)
         
         union{
                 object{ wall_socket(socket_length,socket_height,2,2,depth,sections-section) translate <socket_length*section,height+base,0>}
                 object{ block_wall(3,rows,2,sections-section) translate <socket_length*section,height+socket_height+base,0.5> }  
                 object{ block_wall(3,rear,2,sections-section) translate <socket_length*section,base,depth> }
                 object{ column(height) translate <socket_length*(0.5 + section),base,1> }
                 object{ brick_floor(3,depth/2,1,base/2) translate <socket_length*section,0,0> }
                 object{ metal_ring translate <socket_length*section ,base+5,depth> }
                 
                 box{  <0,0,0>,<socket_length,base,2> translate <socket_length*section,0,depth> texture{ rough_wall } }
            
            
         }
             
        #declare section = section + 1;   
        
            
    #end

    

#end



#macro floor_segment (f_depth,f_length,f_width,f_round)

    
    prism {
    linear_spline
    0,f_length,9, 
    
    <0 , f_depth>,
    <-f_width , f_depth>, 
    <-f_width , f_depth*f_round>,
    <-f_width*(1-f_round)+rand(R)*0.1 , 0>, 
    <0,0>,
    <f_width*(1-f_round+rand(R)*0.1) , 0>,
    <f_width , f_depth*f_round>,
    <f_width , f_depth>,
    <0 , f_depth> 
    
    
    rotate <90,90,0> 
   
    }



#end

#macro flooral (seg_width,seg_length, seg_count, seg_edge)
    
 
 #declare seg_nr = 0;
 union{
         #while(seg_nr < seg_count)
         object{ floor_segment(6,seg_length,seg_width*0.46,seg_edge)  translate z*seg_nr*seg_width }  
         #declare seg_nr = seg_nr + 1; 
         #end  
       }
#end  


#declare crackle_ball = union {



        isosurface { 
        
                function { x*x + y*y + z*z - 1.2 + crackles(x,y,z).grey*0.2 }
                max_gradient global_gradient
                contained_by{sphere{0,1.5}}
                texture{ 
                  pigment { 
                  
                        #if(sunlight)
                                color rgb <0.98,0.96,0.5>   
                        
                        #else
                                color rgbt <0.98,0.96,0.5,0.5>
                        #end
                        
                        } 
                  
                  
                  
                        finish{  ambient global_ambient diffuse 0.9 crand 0. } 
                  }
                translate y
        }                                  

        
       lathe {
        
        
         cubic_spline
         13,
         <-5,0>,
         <0,0>,
         <0.4,0.2>,
         <0.6,0.1>,
         <0.3,-0.1>,
         <0.2,-0.5>,
         <0.1,-1>,
         <0.1,-7>,
         <0.3,-7.5>,
         <0.2,-8>,
         <0.1,-8.3>,
         <0.0,-8.5>,
         <0,-8.5>
              
         texture { 
         
                  pigment { color rgb <0.1,0.1,0.2>} 
                  finish{  ambient global_ambient diffuse global_diffuse specular 0.5 } 
               
                }  
                
                
                
       }   
       
       
       #if(false)
      
              light_source {

                 <0,1,0> 
                 color rgb <0.98,0.95,0.8>  
                 fade_power 1.5
                 fade_distance 15
                 
                 
                }  
                      
                        
       #end


}
#macro nipple_tree (n_frequency,n_height)

 isosurface { 
        
        
        #declare delta_x = rand(R)*100;
        #declare delta_y = rand(R)*100;
        #declare delta_z = rand(R)*100;
        #declare tb = 0.6;  
      
        function { f_helix2 (x,y,z,0, y*y, 1/(y+1), exp(-1.5*y), 1, 1, 0) 
        
                  + f_noise3d(tb*x,tb*y,tb*z)*nipples(n_frequency*x+delta_x,n_frequency*y+delta_y,n_frequency*z+delta_z).grey/(y+1)
         }
        max_gradient global_gradient   
         accuracy global_accuracy
        contained_by{ box{<-1,0,-1>,<1,n_height,1>} }
        texture{ yellow_plastic }  
     
        scale 0.5
}   


#end



 
        
#declare big_socket = lathe {
        
        
         cubic_spline
         19,
         <-5,0.1>,
         <0,0.2>,
         <1,0.3>,
         <1.7,0.3>,
         <1.9,-0.75>,
         <1.1,-1>,
         <0.8,-2.0>,
         <2,-2.3>,
         <1,-3.0>,
         <1.5,-3.3>,
         <0.8,-4.5>,
         <0.8,-7.5>,
         <1.9,-8>,
         <2.4,-8.2>,
         <2.4,-9>,
         <1.9,-9>,
         <1.2,-9>,
         <0.0,-9>,
         <-5,-9>
                
                
}

#declare small_socket = lathe {
        
        
         cubic_spline
         15,
         <-5,0.1>,
         <0,0.2>,
         <1,0.3>,
         <1.7,0.3>,
         <1.9,-0.75>,
         <1.1,-1>,
         <0.8,-2.0>,
         <0.8,-4.5>,
         <1.9,-5>,
         <2.4,-5.2>,
         <2.4,-6>,
         <1.9,-6>,
         <1.2,-6>,
         <0.0,-6>,
         <-5,-6>
                
                
} 


#declare crown = lathe {
        
        
         cubic_spline
         11,
         <-5,-0.3>,
         <0,-0.3>,
         <1.6,-0.2>,
         <1.5,0.5>,
         <2,1>,
         <2.5,1.5>,
         <2,1.5>,
         <0.4,1.5>,
         <0.7,3>,
         <0,3.3>,
         <-5,3.3>
       
          
                
                
}        


#macro white_head(rx,ry,rz)  


union {

   difference {
         
           sphere {0,2.2  }    
           
           cylinder{ <-3,0,-2>,<3,0,-2>,1 }
           sphere { 0,2.1 }    
           
           white_chess() 
           
           translate 2.2*y 
        } 
         
        sphere {0,2 texture{ blue_eye scale -4 translate -2*z} rotate <rx,ry,rz>  translate 2.1*y  }    
 
}  

#end

#macro black_head(rx,ry,rz) 

 union {

   difference {
         
           sphere {0,2.2  }    
           
           cylinder{ <-3,0,-2>,<3,0,-2>,1 }
           sphere {0,2.1  }    
           
           black_chess() 
           
           translate 2.2*y 
        } 
         
        sphere {0,2 texture{ green_eye scale -4 translate -2*z}  rotate <rx,ry,rz>  translate 2.1*y  }    
 
} 
 
#end 
 




#macro  white_king(rx,ry,rz,rh) 

union{


        union { //head
         
                object{ white_head(rx,ry,rz) }
       
                cylinder{ <0,4.7,0>,<0,6.7,0>,0.2 white_chess() }
                cylinder{ <-1,5.7,0>,<1,5.7,0>,0.2  white_chess() }
                sphere{ <0,4.3,0>,0.5  white_chess() }
        
        
                rotate x*rh 
        }
        
        object{ big_socket   white_chess() }
      
       
        translate y*9
}  


#end

#macro white_queen(rx,ry,rz,rh) 


union{

        union { //head       
        
                object{ white_head(rx,ry,rz) }     
                
                object{ crown scale 0.5 translate y*4   white_chess()   }     
                
                rotate x*rh 
        }
        
        
        object{ big_socket   white_chess()  }
        
      
       
        translate y*9
}
#end

        
#macro  black_king(rx,ry,rz,rh) 

union{


        union { //head
         
                object{ black_head(rx,ry,rz) }
       
                cylinder{ <0,4.7,0>,<0,6.7,0>,0.2  black_chess()  }
                cylinder{ <-1,5.7,0>,<1,5.7,0>,0.2 black_chess()  }
                sphere{ <0,4.3,0>,0.5 black_chess()  }
        
        
                rotate x*rh 
        }
        
        object{ big_socket   black_chess() }

       
        translate y*9
}  
#end
       

#macro white_peasant(rx,ry,rz,rh)  

union{

        union { //head
        
                object{ white_head(rx,ry,rz) }           
                
                sphere{ <0,4.4,0>,0.4   white_chess()   }
        
                rotate x*rh 
        }    
        
        object{ small_socket  white_chess()   }
        
        translate y*6
}
#end


#macro black_peasant(rx,ry,rz,rh)  

union{

        union { //head
        
                object{ black_head(rx,ry,rz) }           
                
                sphere{ <0,4.4,0>,0.4   black_chess()  } 
                 
                rotate x*rh 
        }
        object{ small_socket  black_chess()  }
        
        translate y*6
}
#end


// making a rope between positions (x1,y1,z1) and (x2,y2,z2) with suspension a and resolution s and thickness t

#macro rope( r_x1, r_y1, r_z1, r_x2, r_y2, r_z2, r_a, r_t, r_s)
    
   #declare r_d1 = sqrt(r_x1*r_x1 + r_z1*r_z1);
   #declare r_d2 = sqrt(r_x2*r_x2 + r_z2*r_z2); 
   
   #declare r_a  = 10* r_a / abs(r_d1 - r_d2);
   
   #declare b = (r_y1 - r_y2)/(r_d1 - r_d2) - r_a*(r_d1 + r_d2);
   
   #declare c = r_y2 - b*r_d2 - r_a*r_d2*r_d2;
   
   #declare hx = (r_x2 - r_x1) / r_s;
   #declare hz = (r_z2 - r_z1) / r_s;
   #declare hd = (r_d2 - r_d1) / r_s; 
  
   
   
          
   #declare s = -1;    
   
   
   
  sphere_sweep {
  cubic_spline,
  r_s+3,
 
   #while(s <= r_s+1)
         
       #declare r_x = r_x1 + s * hx ;
       #declare r_z = r_z1 + s * hz ;  
       #declare r_d = r_d1 + s * hd ;
       
       #declare r_y =  r_a*r_d*r_d + b*r_d + c;
                              
          <r_x, r_y, r_z>, r_t                 
                                  
                         
       #declare s = s + 1;
   #end           
   
  
}    


#end 





//--------------------Object Placement -------------------------- 
 

object{ striped_floor(10, 8,2,5+floor_height,2) translate <-3,-7.5,0> }




#if(arcades)
union{ column_wall(5,8,8,7,10,0.75) }
#end

#if(horizont)
object { iso_ground(80,20,2,0.2,-50)  texture{ brown_soil } scale <6,8,6> translate <40,-5,0> }
object{ silver_city rotate -y*90 scale 5 translate <105,-3.4,-8> }
object{ nipple_tree(0.7,8)  scale 10 translate <100,-5,-25> } 
#end
  


#if(players)
        
     
        object{ white_king(5,-5,100,-5) scale 0.5  rotate 0*y translate <3,0.4,-2>} 
        object{ white_queen(5,-9,0,-9) scale 0.5  rotate 50*y translate <7,-0.75,-10>} 
        object{ white_peasant(0,0,200,0) scale 0.5  rotate 25*y translate <28,0.5,4>}
        
        object{ black_king(3,5,90,5) scale 0.4  rotate 30*y translate <11,0.4,-2.2>} 
        object{ black_peasant(3,2,7,5) scale 0.4  rotate 120*y translate <19,0.4,-14>} 
        object{ black_peasant(1,4,30,8) scale 0.4  rotate 150*y translate <11,0.4,-18>}
                   
#end





#if(cracklers)
        
        object{ rope(100,32,-25,85,30,-30,0.1,0.1,20) texture{ shiny_black } }     
        
        object{ crackle_ball  rotate <0,160,0> scale 1.0 translate <85,30,-30> } 
         
        object{ rope(85,30,-30,60,19,-30,0.1,0.1,20) texture{ shiny_black } }     
        
        object{ crackle_ball  rotate <0,80,0> scale 1.0 translate <60,19,-30> }  
               
        object{ rope(60,19,-30,20,16,-4,0.05,0.1,20) texture{ shiny_black } }    
        
        object{ crackle_ball  rotate <0,160,0> scale 1.0 translate <20,16,-4> }           
        
        object{ rope(20,16,-4,0,17,-6,0.1,0.1,20) texture{ shiny_black } }  
        
       

#end



//----------------Background, Camera and Light------------------------


sky_sphere {   S_Cloud3 rotate -10*z } 


#if(fogOn)
fog {
    distance 140
    
    #if(sunlight)
    color rgbf<0.8, 0.8, 0.6, 0.2>  
    #else
    color rgbf <0.18,0.18,0.32,0.5>   
    #end
    fog_type 2
    fog_offset -1
    fog_alt 10
}
#end        
       

#if (sunlight)     
light_source {

 sun_location  
 color rgb <0.88,0.82,0.6>  
 parallel
 point_at sun_point_at
 
 
}
#else
light_source {

  sun_location  
 color rgb <0.18,0.18,0.32>  
 parallel
 point_at sun_point_at



}
#end


camera {

location cam_location 

look_at  cam_look_at  
  
          
up <1,0,0>
right <1.5,0,0>
sky <.1,1,0>  

angle 65

}     
  
  