// Persistence of Vision Ray Tracer Scene Description File
// File: balloon.inc
// Vers: 3.5
// Desc: Contains Balloon object for cake.pov
// Date: August 24, 2003
// Auth: Philip Chan

#include "shapes.inc"

#declare B_Shape = blob {
	threshold 0.25
	sphere { <0, 1, 0>, 1, 1
			scale <0.9, 1, 0.9>
	}
	sphere { <0, 0, 0>, 1, 0.25
		scale <0.7, 2, 0.7>
	}
}

#declare B_Bottom = trace( B_Shape, -y, y );

#declare HB_text = union {
	Center_Object( text { ttf "Lcallig.ttf", "Happy", 5, 0 }, x )
	Center_Object( text { ttf "Lcallig.ttf", "Birthday!", 5, 0
			translate y*-2
			translate -x
		},
		x
	)
	scale 0.175
	translate <0, 1.1, -1>
}

#declare Balloon = union {
	difference {
		merge {
			object { B_Shape }
			cone { B_Bottom + 0.05*y, 0.01, B_Bottom - 0.035*y, 0.05 }
		}
		object { B_Shape
			scale 0.99
			translate y*0.01
		}
		pigment { colour rgbf <1, 1, 0, 0.7> }
		finish {
			ambient 0.8
			specular 0.6
			roughness 0.02
		}
		interior {
			ior 2.5
		}
	}	
	difference {
		intersection {
			union {
				object { HB_text }
				object { HB_text
					rotate y*180
				}
			}
			object { B_Shape scale 1.001 }
		}
		object { B_Shape }
	}
	pigment { colour Black }
}
