//////////////////////////////////////////////////////////////////////////
// Mirror.inc  20030816 Copyright(C) K.E. Ayers Designs, 2003           //
//                                                                      //
// A mirror hanging on the wall.                                        //
//////////////////////////////////////////////////////////////////////////

#declare MirrorFrameWidth       = 60.0;
#declare MirrorFrameHeight      = 36.0;
#declare MirrorFrameBorder      = 4.0;
#declare MirrorFrameDepth       = 1.0;

#declare MirrorXOfs  = MirrorFrameWidth  / 2 - MirrorFrameBorder;
#declare MirrorYOfs  = MirrorFrameHeight / 2 - MirrorFrameBorder;

#declare MirrorTexture  =
    texture { Polished_Chrome }

#declare MirrorFrameHorizElem =
intersection {
    plane { <  0, -1,  0 >, 0 }
    plane { <  0,  1,  0 >, 0 translate < 0, MirrorFrameBorder, 0 > }
    plane { <  0,  0, -1 >, 0 translate < 0, 0, -MirrorFrameDepth / 2 > }
    plane { <  0,  0,  1 >, 0 translate < 0, 0,  MirrorFrameDepth / 2 > }
    plane {
        < -1, 0, 0 >, 0
        rotate < 0, 0, 45 >
        translate < -(MirrorXOfs - 1/8), 0, 0 >
    }
    plane {
        <  1, 0, 0 >, 0
        rotate < 0, 0, -45 >
        translate < MirrorXOfs - 1/8, 0, 0 >
    }
    texture {
        PictureFrameTexture
        scale PaintingFrameTextureScale
        rotate < 0, 90, 0 >
    }
}

#declare MirrorFrameVertElem =
intersection {
    plane { < -1,  0,  0 >, 0 }
    plane { <  1,  0,  0 >, 0 translate < MirrorFrameBorder, 0, 0 > }
    plane { <  0,  0, -1 >, 0 translate < 0, 0, -MirrorFrameDepth / 2 > }
    plane { <  0,  0,  1 >, 0 translate < 0, 0,  MirrorFrameDepth / 2 > }
    plane {
        < 0, 1, 0 >, 0
        rotate < 0, 0, 45 >
        translate < 0, MirrorYOfs - 1/8, 0 >
    }
    plane {
        < 0, -1, 0 >, 0
        rotate < 0, 0, -45 >
        translate < 0, -(MirrorYOfs - 1/8), 0 >
    }
    texture {
        PictureFrameTexture
        scale PaintingFrameTextureScale
        rotate < 90, 0, 0 >
    }
}

#declare MirrorFrame =
union {
    object {
        MirrorFrameHorizElem
        translate < 0, MirrorYOfs, 0 >
    }
    object {
        MirrorFrameHorizElem
        scale < 1, -1, 1 >
        translate < 0, -MirrorYOfs, 0 >
    }
    object {
        MirrorFrameVertElem
        translate < MirrorXOfs, 0, 0 >
    }
    object {
        MirrorFrameVertElem
        scale < -1, 1, 1 >
        translate < -MirrorXOfs, 0, 0 >
    }
}

#declare MirrorBody =
box {
    < -MirrorXOfs, -MirrorYOfs,  0 >
    <  MirrorXOfs,  MirrorYOfs,  0 >
    texture { MirrorTexture }
    finish { Mirror }
}

#declare HangingMirror =
union {
    object { MirrorFrame }
    object { MirrorBody }
}
