//////////////////////////////////////////////////////////////////////////
// SkyLoftTextures.inc  20030816 Copyright(C) K.E. Ayers Designs, 2003  //
//                                                                      //
// The textures used in the SkyLoft.                                    //
//////////////////////////////////////////////////////////////////////////

#declare VarnishFinish =
finish {
    ambient     Ambient
    diffuse     Diffuse
    specular    0.3
    roughness   0.01
}

#declare MatteFinish =
finish {
    ambient     Ambient
    diffuse     Diffuse
    specular    0.3
    roughness   0.1
}

#declare FlatFinish =
finish {
    ambient     Ambient
    diffuse     Diffuse
    specular    0.1
    roughness   0.1
}

#declare PolishedBrassTexture =
texture {
    pigment { color rgb < 1.0, 0.9, 0.3 > }
    finish {
        ambient     Ambient
        diffuse     Diffuse
        metallic
        reflection  0.5
        specular    1.0
        roughness   0.0001
        brilliance  5.0
    }
}

#declare FlatBlackTexture =
texture {
    pigment { color rgb < 0.0, 0.0, 0.0 > }
    finish {
        ambient     Ambient
        diffuse     Diffuse
        specular    0.25
        roughness   0.1
    }
}

#declare LightOakTexture =
texture {
    pigment {
        wood
        turbulence 0.08
        color_map {
            [ 0.0, 0.8  color rgb < 0.9, 0.7, 0.4 >
                        color rgb < 0.9, 0.7, 0.4 > ]
            [ 0.8, 1.0  color rgb < 0.6, 0.4, 0.2 >
                        color rgb < 0.4, 0.3, 0.2 > ]
        }
    }
}

#declare DarkOakTexture =
texture {
    pigment {
        wood
        turbulence 0.08
        color_map {
            [ 0.0, 0.8  color rgb < 0.6, 0.4, 0.2 >
                        color rgb < 0.6, 0.4, 0.2 > ]
            [ 0.8, 1.0  color rgb < 0.2, 0.1, 0.0 >
                        color rgb < 0.0, 0.0, 0.0 > ]
        }
    }
}

#declare PolishedFinish =
finish {
    ambient     Ambient
    diffuse     Diffuse
    reflection  0.25
    specular    0.75
    roughness   0.001
}
