//////////////////////////////////////////////////////////////////////////
// Sofa.inc  20030816 Copyright(C) K.E. Ayers Designs, 2003             //
//                                                                      //
// A sofa sitting along the "side wall".                                //
//////////////////////////////////////////////////////////////////////////

#declare SofaLegHgt             = 3;
#declare SofaBaseHgt            = 10;
#declare SofaCushionHgt         = 5;
#declare SofaArmWid             = 8;
#declare SofaArmPadHgt          = SofaArmWid / 2;
#declare SofaArmHgt             = SofaBaseHgt + SofaCushionHgt;
#declare SofaLength             = 80;
#declare SofaBackHgt            = SofaArmHgt + SofaArmPadHgt + 3;
#declare SofaBackDepth          = 10;
#declare SofaHeight             = SofaBaseHgt + SofaCushionHgt + SofaBackHgt;
#declare SofaDepth              = 36;
#declare SofaSeatWid            = SofaLength - (2 * SofaArmWid);
#declare SofaSeatDepth          = SofaDepth - SofaBackDepth;
#declare SofaCushionWid         = SofaSeatWid / 2;

#declare SofaBaseColor    = color rgb < 0.0, 0.6, 0.6 >;
#declare SofaPatternColor = color rgb < 0.6, 0.0, 0.0 >;
#declare SofaBgdColor     = color rgb < 0.0, 0.0, 0.0 >;

#declare SofaTexture =
texture {
    pigment {
        marble
        turbulence 2.3
        color_map {
            [ 0.0   color SofaBgdColor ]
            [ 0.8   color SofaBaseColor ]
            [ 0.9   color SofaPatternColor ]
            [ 1.0   color SofaBgdColor ]
        }
        scale SofaLength * 0.15
    }
    finish { MatteFinish }
}

// Sofa component parts
#declare SofaArmPad =
cylinder {
    < 0, 0, -SofaDepth / 2 >
    < 0, 0,  SofaDepth / 2 >
    SofaArmPadHgt
}

#declare SofaArm =
union {
    box {
        < -SofaArmWid / 2,          0, -SofaDepth / 2 >
        <  SofaArmWid / 2, SofaArmHgt,  SofaDepth / 2 >
    }
    object { SofaArmPad translate < 0, SofaArmHgt, 0 > }
    texture { SofaTexture }
}

#declare SofaArmOfs = (SofaLength / 2) - (SofaArmWid / 2);

#declare SofaCushion =
superellipsoid { < 0.25, 0.25 >
    scale < SofaCushionWid * 0.49,
            SofaCushionHgt * 0.5,
            SofaSeatDepth * 0.52 >
    texture { SofaTexture rotate <90, 0, 0> }
}

#declare SofaCushionXOfs =  SofaCushionWid / 2;
#declare SofaCushionYOfs =  SofaBaseHgt + (SofaCushionHgt / 2);
#declare SofaCushionZOfs = -(SofaBackDepth / 2 + 1);

#declare SofaBase =
box {
    < -SofaLength / 2, 0, -SofaDepth / 2 >
    <  SofaLength / 2, SofaBaseHgt, SofaDepth / 2 >
        texture { SofaTexture }
}

#declare SofaBackPad =
cylinder {
    < -SofaLength / 2, 0, 0 >
    <  SofaLength / 2, 0, 0 >
    SofaBackDepth / 2
}

#declare SofaBack =
union {
    box {
        < -SofaLength / 2, 0, (SofaDepth / 2) - SofaBackDepth >
        <  SofaLength / 2, SofaBackHgt, SofaDepth / 2 >
    }
    object {
        SofaBackPad
        translate < 0, SofaBackHgt, (SofaDepth / 2) - (SofaBackDepth / 2) >
    }
    texture { SofaTexture }
}

// There will be a throw pillow at each end.

#declare PillowWid              = 12;
#declare PillowThick            = 8;
#declare PillowButtonRad        = 1;

#declare PillowSection =
intersection {
    cylinder {
        < -PillowWid / 2, 0, 0 >,
        <  PillowWid / 2, 0, 0 >,
        PillowWid / 4
        scale < 1, PillowThick / PillowWid, 1 >
        translate < 0, 0, PillowWid / 4  >
    }
    plane { < -1,  0,  0 >, 0 rotate < 0, -45, 0 > }
    plane { <  1,  0,  0 >, 0 rotate < 0,  45, 0 > }
}

#declare PillowBody =
union {
    object { PillowSection }
    object { PillowSection rotate < 0,  90, 0 > }
    object { PillowSection rotate < 0, 180, 0 > }
    object { PillowSection rotate < 0, 270, 0 > }
}

#declare PillowPiping =
superellipsoid {
    < 0.075, 0.075 >
    scale < PillowWid * 0.518, 0.1, PillowWid * 0.518 >
}

#declare PillowButton =
sphere {
    < 0, 0, 0 >, PillowButtonRad
    scale < 1, 0.25, 1 >
}

#declare Pillow =
union {
    object { PillowBody }
    object { PillowPiping }
    object { PillowButton translate < 0,  PillowThick * 0.1, 0 > }
    object { PillowButton translate < 0, -PillowThick * 0.1, 0 > }
    texture {
        pigment {
            bozo
            turbulence 1.5
            color_map {
                [ 0.0   color rgb < 0.3, 0.8, 0.6 > ]
                [ 0.6   color rgb < 0.3, 0.8, 0.6 > ]
                [ 0.8   color rgb < 0.5, 1.0, 0.8 > ]
                [ 1.0   color rgb < 0.3, 0.8, 0.6 > ]
            }
            scale PillowWid * 0.1
        }
        finish {
            ambient     0.1
            diffuse     0.7
            metallic
            specular    0.25
            roughness   0.05
        }
    }
}

#declare PillowXRot     = 60;
#declare PillowYRot     = 30;
#declare PillowXOfs     = SofaLength / 2 - SofaArmWid - PillowWid * 0.35;
#declare PillowYOfs     = SofaBaseHgt + SofaCushionHgt + PillowWid * 0.45;
#declare PillowZOfs     = SofaDepth / 2 - SofaBackDepth - PillowWid * 0.42;

#declare Sofa =
union {
    object { SofaBase }
    object { SofaBack }
    object { SofaArm translate < -SofaArmOfs, 0, 0 > }
    object { SofaArm translate <  SofaArmOfs, 0, 0 > }
    object {
        SofaCushion
        translate < -SofaCushionXOfs, SofaCushionYOfs, SofaCushionZOfs >
    }
    object {
        SofaCushion
        translate <  SofaCushionXOfs, SofaCushionYOfs, SofaCushionZOfs >
    }
    object {
        Pillow
        rotate < -PillowXRot, -PillowYRot, 0 >
        translate < -PillowXOfs, PillowYOfs, PillowZOfs >
    }
    object {
        Pillow
        rotate < -PillowXRot, PillowYRot, 0 >
        translate < PillowXOfs, PillowYOfs, PillowZOfs >
    }
    translate < 0, SofaLegHgt, 0 >
}