//////////////////////////////////////////////////////////////////////////
// Staircase.inc  20030816 Copyright(C) K.E. Ayers Designs, 2003        //
//                                                                      //
// A spiral staircase ascending into the loft.                          //
//////////////////////////////////////////////////////////////////////////

#declare StepRise               = 8.0;
#declare StairCenterRadius      = 18.0;
#declare StepWidth              = 30.0;
#declare StepDepth              = 12.25;
#declare StepThickness          = 1.5;
#declare StepEdgeRad            = StepThickness / 2;
#declare StaircaseRadius        = StairCenterRadius + StepWidth;
#declare NumberOfSteps          = 16;
#declare StaircaseHeight        = NumberOfSteps * StepRise;
#declare FirstStepAngle         = 180;
#declare StepAngle              = 270 / (NumberOfSteps - 1);

// One stair step.
#declare StepTreadEdge          = (StepDepth / 2.0) - StepEdgeRad;
#declare StepSurface            = StepThickness / 2.0;

#declare StairStep =
union {
    // Basic step "slab"
    box {
        < StairCenterRadius, -StepThickness / 2, -StepTreadEdge >,
        < StaircaseRadius,    StepThickness / 2,  StepTreadEdge >
    }
    // Add rounded edges to front and back.
    cylinder {
        < StairCenterRadius,   0, -StepTreadEdge >,
        < StaircaseRadius,     0, -StepTreadEdge >
        StepEdgeRad
    }
    cylinder {
        < StairCenterRadius,   0, StepTreadEdge >,
        < StaircaseRadius,     0, StepTreadEdge >
        StepEdgeRad
    }
    texture {
        LightOakTexture
        rotate < 0, 90, 0 >
        finish { VarnishFinish }
    }
}

// The hand rail support post.
#declare HandRailRad            = 1/2;
#declare HandRailJoinRad        = HandRailRad * 2.25;
#declare HandRailHgt            = 30;
#declare HandRailXOfs           = StairCenterRadius + StepWidth - 2;
#declare HandRailFlangeRad      = HandRailRad * 3;
#declare HandRailStemRad        = HandRailRad + 1/2;
#declare HandRailFlangeThick    = 3/8;
#declare HandRailStemHgt        = HandRailStemRad;

#declare HandRailPost =
union {
    // The flange which anchors the post to the step.
    cylinder {
        < HandRailXOfs, StepSurface, 0 >,
        < HandRailXOfs, StepSurface + HandRailFlangeThick, 0 >,
        HandRailFlangeRad
        texture { FlatBlackTexture }
    }
    // The flange's stem.
    cylinder {
        < HandRailXOfs, StepSurface + HandRailFlangeThick, 0 >,
        < HandRailXOfs, StepSurface + HandRailFlangeThick + HandRailStemHgt, 0 >,
        HandRailStemRad
        texture { FlatBlackTexture }
    }
    // The hand rail support post.
    cylinder {
        < HandRailXOfs, StepSurface, 0 >,
        < HandRailXOfs, HandRailHgt, 0 >,
        HandRailRad
        texture { FlatBlackTexture }
    }
    // The hand rail joint.
    sphere {
        < HandRailXOfs, HandRailHgt, 0 >, HandRailJoinRad
        texture { PolishedBrassTexture }
    }
}    

// The assembled spiral staircase.
#declare Count           = 1;
#declare RotAngle        = FirstStepAngle;
#declare StepYOfs        = 0;
#declare RailPostPos     = < HandRailXOfs, HandRailHgt, 0 >;

#declare Staircase =
union {
    #while (Count <= NumberOfSteps)
        #declare CurrRailPostPos =
                    vrotate(RailPostPos, < 0, -RotAngle, 0 >)
                        + < 0, -StepYOfs, 0 >;
        object {
            StairStep
            rotate < 0, -RotAngle, 0 >
            translate < 0, -StepYOfs, 0 >
        }
        object {
            HandRailPost
            rotate < 0, -RotAngle, 0 >
            translate < 0, -StepYOfs, 0 >
        }

        #declare RotAngle = RotAngle + StepAngle;
        #declare StepYOfs = StepYOfs + StepRise;

        // Add a section of rail going from this step down to
        // the next one ... unless this is the bottom step.
        #if (Count < NumberOfSteps)
            #declare NextRailPostPos =
                        vrotate(RailPostPos, < 0, -RotAngle, 0 >)
                            + < 0, -StepYOfs, 0 >;
            cylinder {
                CurrRailPostPos, NextRailPostPos, HandRailRad
                texture { FlatBlackTexture }
            }

            #declare CurrRailPostPos = NextRailPostPos;
        #end
        #declare Count = Count + 1;
    #end
} 