#include "functions.inc"
#include "rand.inc"
#include "math.inc"
#include "transforms.inc"


#declare t_moss=
texture {
	pigment {
		wrinkles
		turbulence 0.3 omega 0.8
		scale 0.01
		color_map {
			[0.3 rgb 0.95]
			[0.5 rgbf 0.5]
			[0.8 rgb 0.95]
		}
	}
	normal {wrinkles 1 turbulence 0.3 omega 0.8 scale 0.01}
	finish {specular 0.1 roughness 0.4}
}
#declare t_tree1=
texture {
	pigment {
		granite
		scale 0.3
		turbulence 0.2
		color_map {
			[0 rgb <0.5, 0.3, 0.2>]
			[1 rgb <0.8, 0.5, 0.3>]
		}
	}
	normal {granite turbulence 0.2 omega 0.8 scale 0.1}
	finish {specular 0.2 roughness 0.4}
}
#declare t_tree2=
texture {
	pigment {
		granite
		scale 0.3
		turbulence 0.2
		color_map {
			[0 rgb <0.5, 0.3, 0.2>*0.2]
			[1 rgb <0.8, 0.5, 0.3>*0.2]
		}
	}
	normal {granite turbulence 0.2 omega 0.8 scale 0.1}
	finish {specular 0.3 roughness 0.25}
}
#declare t_tree=
texture {
	planar
	texture_map {
		[0.95 t_tree1]
		[0.99 t_tree2]
	}
}

//#declare sd=seed(11);
#declare rlim=6;
#macro btree (rlvl, loc, rad, ht, ang, rsf, hsf, sd)
	#local c=0;
	#local maxc=ht;
	#local step=maxc/15;
	#while (c<=maxc)
		sphere {0, 1, 1
			#local xs=RRand(0.75, 1, sd);
			#local zs=RRand(0.75, 1, sd);
			#local xt=RRand(-rad*0.15, rad*0.15, sd);
			#local zt=RRand(-rad*0.15, rad*0.15, sd);
			#local r=rad*(maxc-c+1);
			scale <r*xs, r*1.2, r*zs>
			translate <xt, c, zt>
			rotate ang
			translate loc
		}
		#local c=c+step;
	#end

	#if (rlvl<rlim)
		#local xang=35;
		//#local xang=25*rlvl;
		btree (rlvl+1, vtransform (y*ht, transform {rotate ang translate loc}), rad*rsf, ht*hsf, ang/2+<xang, 0, 0>+VRand_In_Box(-15, 15, sd), hsf*RRand(0.85, 1.15, sd), rsf*RRand(0.9, 1.1, sd), sd)
		btree (rlvl+1, vtransform (y*ht*RRand(0.8, 1, sd), transform {rotate ang translate loc}), rad*rsf, ht*hsf, ang/2+<xang, 120, 0>+VRand_In_Box(-15, 15, sd), hsf*RRand(0.85, 1.15, sd), rsf*RRand(0.9, 1.1, sd), sd)
		btree (rlvl+1, vtransform (y*ht*RRand(0.6, 1, sd), transform {rotate ang translate loc}), rad*rsf, ht*hsf, ang/2+<xang, 240, 0>+VRand_In_Box(-15, 15, sd), hsf*RRand(0.85, 1.15, sd), rsf*RRand(0.9, 1.1, sd), sd)
	#end
#end



#macro square (p1, p2, p3, p4)
	triangle {p1, p2, p3}
	triangle {p2, p3, p4}
#end

#declare sd2=seed(1);
#macro moss (rlvl, loc, rad, ht, ang, rsf, hsf, sd)

	//keep random seeds the same as tree
	#local c=0;
	#local maxc=ht;
	#local step=maxc/15;
	#while (c<=maxc)
		#local xs=RRand(0.75, 1, sd);
		#local zs=RRand(0.75, 1, sd);
		#local xt=RRand(-rad*0.15, rad*0.15, sd);
		#local zt=RRand(-rad*0.15, rad*0.15, sd);
		#local r=rad*(maxc-c+1);
		#local c=c+step;
	#end

	//moss on smallest branches
	#if ((rlvl >= rlim-2)&(RRand(0, 1, sd2)<0.5))
		#local yy=ht*RRand(0.8, 1.2, sd2);
		#local step=ht/5;
		#local prevp1=vtransform(<0, ht*0.2, 0>, transform {rotate ang translate loc});
		#local prevp2=vtransform(<0, ht*0.8, 0>, transform {rotate ang translate loc});
		#while (yy>0)
			#local p3=prevp1;
			#local p4=prevp2;
			#local htf1=0.5-pow(RRand(0.1, 0.4, sd2)*yy, 0.5);
			#local htf2=0.5+pow(RRand(0.1, 0.4, sd2)*yy, 0.5);
			#local p1=vtransform(<0, ht*htf1, 0>, transform {rotate ang translate loc})-y*yy;
			#local p2=vtransform(<0, ht*htf2, 0>, transform {rotate ang translate loc})-y*yy;
			#local mid=p1+(p2-p1)/2;
			square (p1, p2, p3, p4)
			#local yy=yy-step;
		#end
	#end

	#if (rlvl<rlim)
		#local xang=35;
		//#local xang=25*rlvl;
		moss (rlvl+1, vtransform (y*ht, transform {rotate ang translate loc}), rad*rsf, ht*hsf, ang/2+<xang, 0, 0>+VRand_In_Box(-15, 15, sd), hsf*RRand(0.85, 1.15, sd), rsf*RRand(0.9, 1.1, sd), sd)
		moss (rlvl+1, vtransform (y*ht*RRand(0.8, 1, sd), transform {rotate ang translate loc}), rad*rsf, ht*hsf, ang/2+<xang, 120, 0>+VRand_In_Box(-15, 15, sd), hsf*RRand(0.85, 1.15, sd), rsf*RRand(0.9, 1.1, sd), sd)
		moss (rlvl+1, vtransform (y*ht*RRand(0.6, 1, sd), transform {rotate ang translate loc}), rad*rsf, ht*hsf, ang/2+<xang, 240, 0>+VRand_In_Box(-15, 15, sd), hsf*RRand(0.85, 1.15, sd), rsf*RRand(0.9, 1.1, sd), sd)
	#end
#end
//---------------------------------------------------------------
//---------------------------------------------------------------

camera {
	up y
	right image_width/image_height*x
	angle 40
	location <0, 0.7, -5>
	look_at y*0.75
}

light_source {<3, 5, -6> rgb 1}

sky_sphere {
	pigment {
		radial
		frequency 2
		rotate z*90
		color_map {
			[0 rgb <0.35, 0.4, 0.45>]
			[1 rgb <0.05, 0.1, 0.3>]
		}
	}
}

plane {y, 0
	pigment {rgb 0.8}
	finish {specular 0.2 roughness 0.3}
}

//btree (rlvl, loc, rad, ht, ang, rsf, hsf, sd)
union {
	#local s=1;
	blob {
		threshold 0.1
		btree (0, y*-0.3, 0.06, 1, 0, 0.5, 0.5, seed(s))
		texture {t_tree}
	}
	mesh {
		moss (0, y*-0.3, 0.06, 1, 0, 0.5, 0.5, seed(s))
		texture {t_moss}
	}
	scale 1
}
