#include "colors.inc"                 
#include "glass.inc" 
#include "skies.inc"    


background { color SkyBlue }        
                               
global_settings { assumed_gamma 3.2 }                               
                               
camera { 
        perspective
        location <5, 2, 0>
        look_at <0, 0, 0>
        angle 90
}

light_source { <10, 20, 10>*100 color White }


#macro Texture_Nails (my_cosmos)
texture {
        pigment {
                image_map {
                        jpeg my_cosmos
                        map_type 2
                }
        }        
}        
finish {
                ambient .6
                brilliance .01
                phong 1
                phong_size 5
                metallic
}                              
#end


#declare angle0 = 15;
#declare angle1 = 20;
#declare angle2 = 40;
#declare angle3 = 60;
#declare angle4 = 100;
#declare angle5 = 80;
#declare angle6 = 130;
#declare angle7 = 110;
#declare angle8 = 170;
#declare lenght = 2;

#macro XYZ (alfa, factor)
        #local XYZ_pos = array[3]
        #local XYZ_pos[0] = 0;
        #local XYZ_pos[1] = -(lenght/2)*(1+factor*cos(alfa));
        #local XYZ_pos[2] = (factor*lenght/2)*sin(alfa);        
        translate <XYZ_pos[0], XYZ_pos[1], XYZ_pos[2]>
#end         

#declare Texture_Hand = texture {
        pigment { 
                White
                filter .7
        }
        normal {
                bumps .9
        }
}

#declare Nebula_media3 = media {
        absorption rgb<.9, .9, .9>
        emission .85 
//        scattering {
//                1, .8       
//        }        
        method 2            
        density {
                cylindrical
                color_map {
                        [0.0 rgb<0, 0, 0>]
                        [0.4 rgb<0.4, 0, 0.2>*5.5]
                        [0.45 rgb<0, 0, 0>]
                        [0.5 rgb<.5, 0, .1>*9.5]
                        [0.55 rgb<0, 0, 0>]
                        [0.6 rgb<.3, 0, .1>*5.5]
                        [1.0 rgb<0, 0, 0>]
                }             
                scale 3
                warp {
                        turbulence 1.5
                        octaves 40
                        lambda 6.5
                }        
        }        
        translate <0, .4, 0>
        rotate -170*x  
}        

#declare Nebula_media4 = media {
        absorption rgb<.9, .9, .9>
        emission .85 
//        scattering {
//                1, .8       
//        }        
        method 2            
        density {
                cylindrical
                color_map {
                        [0.0 rgb<0, 0, 0>]
                        [0.4 rgb<0.2, 0, 0.5>*4.5]
                        [0.45 rgb<0, 0, 0>]
                        [0.5 rgb<.3, 0, .6>*2.5]
                        [0.55 rgb<0, 0, 0>]
                        [0.6 rgb<.3, 0, .3>*2.5]
                        [1.0 rgb<0, 0, 0>]
                }             
                scale 5
                warp {
                        turbulence 1.9
                        octaves 40
                        lambda 1.8
                }        
        }        
        translate <0, -.8, 0>
        rotate <0, 20, -10>      
}         
                
        

#declare Indice =
        blob {
                threshold 1.0
                cylinder { 
                        <0, -1, 0>, <0, 1, 0>, .7
                        strength 1.5
                }
                cylinder {      
                        <0, -1, 0>, <0, 1, 0>, .6       
                        strength 1.5      
                        scale <1, .80, 1>
                        rotate <-angle1, 0, 0>        
                        XYZ (angle1, .8)
                        translate <0, -.6, -.4>
                }
                cylinder { 
                        <0, -1, 0>, <0, 1, 0>, .5
                        strength 1.5
                        rotate <-angle1, 0, 0>
                        scale <1, .55, 1>
                        XYZ (angle2, .55) 
                        translate <0, -2.8, .7>
                }
                scale <1, 1, 1>  
                sturm
//                pigment { White }
                texture { Texture_Hand }
        }                        
        
declare Medio =
        blob {
                threshold 1.0
                cylinder { 
                        <0, -1, 0>, <0, 1, 0>, .7
                        strength 1.5
                        translate <1, 0, 0>
                }
                cylinder {      
                        <0, -1, 0>, <0, 1, 0>, .6       
                        strength 1.5      
                        scale <1, .80, 1>
                        rotate <-angle3, 0, 0>        
                        XYZ (angle3, .8)
                        translate <1, -1.6, .9>
                }
                cylinder { 
                        <0, -1, 0>, <0, 1, 0>, .5
                        strength 1.5
                        rotate <-angle4, 0, 0>
                        scale <1, .55, 1>
                        XYZ (angle4, .55) 
                        translate <1, -.7, 3>
                }                 
                scale <1.1, 1.1, 1.1>
                sturm
//                pigment { White }       
                texture { Texture_Hand }
        }                        
        
#declare Anulare =
        blob {
                threshold 1.0
                cylinder { 
                        <0, -1, 0>, <0, 1, 0>, .7
                        strength 1.5   
                        translate <2, 0, 0>
                }                       
                cylinder {      
                        <0, -1, 0>, <0, 1, 0>, .6       
                        strength 1.5      
                        scale <1, .80, 1>
                        rotate <-angle5, 0, 0>        
                        XYZ (angle5, .8)
                        translate <2, -.5, 1.7>
                }
                cylinder { 
                        <0, -1, 0>, <0, 1, 0>, .5
                        strength 1.5
                        rotate <-angle6, 0, 0>
                        scale <1, .55, 1>
                        XYZ (angle6, .55) 
                        translate <2, -.4, 3.3>
                }                 
                scale <.9, .9, .9>
                sturm            
//                pigment { White }
                texture { Texture_Hand }
        }

#declare Mignolo =
        blob {
                threshold 1.1
                cylinder { 
                        <0, -1, 0>, <0, 1, 0>, .7
                        strength 1.5   
                        translate <3, 0, 0>
                }
                cylinder {      
                        <0, -1, 0>, <0, 1, 0>, .6       
                        strength 1.5      
                        scale <1, .80, 1>
                        rotate <-angle7, 0, 0>        
                        XYZ (angle7, .8)
                        translate <3, -.9, 1.1>
                }
                cylinder { 
                        <0, -1, 0>, <0, 1, 0>, .5
                        strength 1.5
                        rotate <-angle8, 0, 0>
                        scale <1, .55, 1>
                        XYZ (angle8, .55) 
                        translate <3, 1.3, 2.15>
                }
                scale <.8, .8, .8>  
                sturm 
//                pigment { White }  
                texture { Texture_Hand }
        }

#declare Pollice =
        blob {
                threshold .6
                cylinder { 
                        <0, -1, 0>, <0, 1, 0>, .7
                        strength 1.5   
                        translate <-.8, -1.2, -.8>
                }
                cylinder {      
                        <0, -1, 0>, <0, 1, 0>, .6       
                        strength 1.5      
                        scale <1, .80, 1>
                        rotate <-angle0, 0, 0>        
                        XYZ (angle0, .8)
                        translate <-.8, -1.7 -1.2, -.3 -.8>
                }
                sturm           
                scale <.8, .8, .8>
                rotate <-60, 0, -40>   
//                pigment { White }
                texture { Texture_Hand }
        }


/*
object {
        Thumbs
//        rotate <40, -30, 40>
//        translate <-5, 0, 0>
} 
*/

#declare Nails = difference {
        cone { 
                <0, -1, 0>, 1
                <0, 1, 0>, .3
        }
        cone {
                <0, -1.2, 0>, 1
                <0, 1.2, 0>, .2
        }                      
        box {
                <-1, -1, -1>
                <1, 1, 1>       
                scale <10, 10, 2>
                rotate <15, 0, 0>
                translate <0, -2, 1>
        }
        sphere {
                <0, 0, 0>
                3                    
                scale <.1, 1, .2>
                translate <0, 0, -1.05>
                inverse
        }                
        pigment {White}
}

#declare Mignolo_ =
merge {
        object { 
                Mignolo        
                hollow
                interior {
                        media { Nebula_media3 }
                        media { Nebula_media4 }
                }
        }
        object {                             //   mignolo
                Nails                        
                Texture_Nails ( "Cosmo3.jpg" )
                scale <.3, 2, .7>                     
                rotate <-25, 180, 0>         
                translate <2.4, 2.2, 2.33>   
        }
}        
        
#declare Anulare_ = merge {         
        object { 
                Anulare 
                hollow
                interior {
                        media { Nebula_media3 }
                        media { Nebula_media4 }
                }
        }
        object {                             //   anulare
                Nails                     
                Texture_Nails ( "Cosmo1.jpg" )
                scale <.5, 2.5, .7>         
                rotate <-72, 180, 0>
                translate <1.8, .38, 5>
        }              
}        
        
#declare Medio_ = merge {       
        object { 
                Medio 
                hollow
                interior {
                        media { Nebula_media3 }
                        media { Nebula_media4 }
                }
        }
        object {                             //   medio
                Nails
                Texture_Nails ( "Cosmo2.jpg" )           
                scale <.5, 2.5, .7>         
                rotate <-90, 180, 0>
                translate <1.1, -1.74, 6.4>
        }               
}        
        
#declare Indice_ = merge {       
        object { 
                Indice 
                hollow
                interior {
                        media { Nebula_media3 scale 2 }
                        media { Nebula_media4 scale .5 }
                        media { Nebula_media3 scale 2 }
                }
        }
        object {                             //   indice
                Nails
                Texture_Nails ( "Cosmo3.jpg" )           
                scale <.5, 2.7, .7>         
                rotate <-150, 180, 0>
                translate <.0, -5.68, 3>
        }                 
}        

#declare Pollice_ = merge {
        object { 
                Pollice
                hollow
                interior {
                        media { Nebula_media3 scale .2}
                        media { Nebula_media4 }
                }
        }        
        object {                             //   pollice
                Nails                       
                Texture_Nails ( "Cosmo1.jpg" )
                scale <.6, 1.8, .7>         
                rotate <-105, 190, -90>
                translate <-1.74, -1.3, 4.2>
        }                                         
}                        

#declare Hand = union {
        object { Pollice_ translate <.3, .4, .4>}
        object { Indice_ rotate -5*z translate .15*x}
        object { Medio_ rotate -1*z}
        object { Anulare_ rotate 2*z}
        object { Mignolo_ rotate 7*z}                
        scale <.7, .7, .7>
        rotate <30, -40, 30>
        translate <-3, 3.7, 2> 
}
                              
/*
object {
        Hand          
        translate <0, 0, 0>    
} 
*/             