#include "colors.inc"                 
#include "glass.inc" 
#include "functions.inc"   

global_settings { assumed_gamma 3.2 }

background { color SkyBlue }        

camera { 
        perspective
        location <5, 2, 0>
        look_at <0, 0, 0>
        angle 90
}

light_source { <10, 20, 10>*100 color White }

#declare Nebula_media = media {
        absorption rgb<.9, .9, .9>
        emission .85 
//        scattering {
//                1, .8       
//        }        
        method 2            
        density {
                spherical
                color_map {
                        [0.0 rgb<0, 0, 0>]
                        [0.4 rgb<0.4, 0, 0.2>*8.5]
                        [0.45 rgb<0, 0, 0>]
                        [0.5 rgb<.5, 0, .1>*15.5]
                        [0.55 rgb<0, 0, 0>]
                        [0.6 rgb<.3, 0, .1>*9.5]
                        [1.0 rgb<0, 0, 0>]
                }             
                scale .9
                warp {
                        turbulence 1.5
                        octaves 40
                        lambda 6.5
                }        
        }        
        translate <0, .4, 0>
        rotate -170*x  
}        

#declare Nebula_media2 = media {
        absorption rgb<.9, .9, .9>
        emission .85 
//        scattering {
//                1, .8       
//        }        
        method 2            
        density {
                spherical
                color_map {
                        [0.0 rgb<0, 0, 0>]
                        [0.4 rgb<0.2, 0, 0.5>*8.5]
                        [0.45 rgb<0, 0, 0>]
                        [0.5 rgb<.3, 0, .6>*4.5]
                        [0.55 rgb<0, 0, 0>]
                        [0.6 rgb<.3, 0, .3>*8.5]
                        [1.0 rgb<0, 0, 0>]
                }             
                scale 1
                warp {
                        turbulence 1.9
                        octaves 40
                        lambda 1.8
                }        
        }        
        translate <0, -.8, 0>
        rotate <0, 20, -10>      
}         


#declare r = function { sqrt(pow(x,2) + pow(y,2) + pow(z,2)) }
#declare theta = function { acos(z/r(x, y, z)) }
#declare psi = function { atan(y/x) } 
#declare _Radius = function { sqrt(pow(x,2) + pow(y,2)) }
#declare _Slope = function { exp(-pow(_Radius(x, y, z),2)/.3)/4 }

#declare new_star = function {
        (pow(r(x, y, z),2) - pow(1.2,2)) +
        (z > 0)*(r(x, y, z) - sin(sqrt(pow((x*80),2) + pow((y*80),2)))/10)*_Slope(x, y, z) +
        (z > 0)*(r(x, y, z) - sin(sqrt(pow(((x-.2)*80),2) + pow(((y)*80),2)))/10)*_Slope((x-.2), (y), z) +
        (z > 0)*(r(x, y, z) - sin(sqrt(pow(((x-.2)*80),2) + pow(((y)*80),2)))/10)*_Slope((x+.2), (y), z) + 
        (z > 0)*(r(x, y, z) - sin(sqrt(pow(((x)*80),2) + pow(((y-.2)*80),2)))/10)*_Slope((x), (y-.2), z) +
        (z > 0)*(r(x, y, z) - sin(sqrt(pow(((x)*80),2) + pow(((y-.2)*80),2)))/10)*_Slope((x), (y+.2), z)
}

#declare new_ball = difference {
        isosurface {
                function { new_star (x, y, z) }
                threshold 0
//                accuracy 0.000000001
                max_gradient 4
                contained_by { sphere { <0, 0, 0>, 3 } }
                open
//                pigment {White}
                rotate <0, 90, 0>
//                hollow
        }                                               
        isosurface {
                function { f_sphere(x, y, z, .5)-f_noise3d(x*5, y*5, z*5)/5 }
                threshold 0
//                accuracy 0.0000001
                max_gradient 2
                contained_by { sphere { <0, 0, 0>, 3 } }
                open
//                pigment {White}
                scale <.8, 1, 1>*0.7
                translate <1, 0, 0>
        }
        hollow          
        interior {
                ior 1.33
                fade_distance 5
                fade_power 1
                caustics 1
                media { Nebula_media } 
                media { Nebula_media2 }
        }          
        texture {
                pigment {
                        color White
                        filter .95
                }  
        }                       
        finish {
           //     ambient .3
                diffuse .1
                specular .7
                roughness .0007
                reflection .1  
                phong .05
                phong_size .200       
        }        
/*        interior {
                ior 1.5
                fade_distance 5
                fade_power 1
                caustics 1
        }  */                        
}

#declare Nebula =  sphere { 
        <0, 0, 0>, .9
        hollow 
        scale <1, 1, 1>
        pigment {Clear}
        no_shadow
        no_reflection
        interior {
                media { Nebula_media } 
                media { Nebula_media2 }
        }        
}               

#declare new_world = union {
        object { new_ball } 
//        object { Nebula }
        rotate 70*z
}                  


object {
        new_world
        translate <0, 0, 1.5>
}        
