#include "colors.inc"                 
#include "glass.inc" 
#include "skies.inc"
#include "Hand.inc"
#include "borning_planet"

//background { color SkyBlue }        
               
global_settings {
        assumed_gamma 3.2
}        
               
camera { 
        perspective
        location <5, 2, 0>
        look_at <0, 0, 0>
        angle 90
}

light_source { <10, 20, 10>*100 color White }


// Here I declare a glass ball in which I'll put the planet

#declare Ball = difference {
         merge {
                sphere {
                        <0, 0, 0>, 1.2 
                }
                torus {
                        10, 1
                        scale <.02, .02, .02>                
                        rotate <0, 0, 90>
                        translate <0, 1.2, 0>
                }
        }                
        sphere {
                <0, 0, 0>, 1.15
        }
        texture {
                pigment {
                        color White
                        filter .90
                }
        }                         
        finish {
                ambient .1
                diffuse .1
                specular .7
                roughness .00001
                reflection .1  
                phong .001
                phong_size 200       
        }        
        interior {
                ior 1.5
                fade_distance 5
                fade_power 1
                caustics 1
        }        
}                    


// Here I declare the texture for Clouds to put layered on Earth

#declare Clouds = texture {
        pigment {
                bozo     
                noise_generator 1
                turbulence 0.3
                octaves 5
                omega 1
                lambda .1
                color_map {
                        [0.0 0.1 color rgb <0.85, 0.85, 0.85> color rgb <0.75, 0.75, 0.75>]
                        [0.1 0.5 color rgb <0.75, 0.75, 0.75> color rgbt <1, 1, 1, 1>]
                        [0.5 1.0 color rgbt <1, 1, 1, 1> color rgbt <1, 1, 1, 1>]
                }
                scale <0.2, 0.5, 0.2>
        }
}        


// Here I declare a planet

#macro Planets (my_image, my_angle, my_clouds)
        sphere {
                <0, 0, 0>, 1.
                texture {
                        pigment {
                                image_map {
                                        jpeg my_image
                                        map_type 1
                                }
                        }
                 //       normal { bumps 1 }
                }   
                #if (my_clouds) 
                        texture { Clouds }
                #end       
                rotate my_angle*y                        
        }                                 
#end                
        

#macro scheet (Angle1, Angle2, Angle3, Angle4, my_color)

#local B11=<0,Angle1,3/2>; #local B12=<1,0,3/2>; //                1 / 0
#local B13=<2,0,3/2>; #local B14=<3,Angle2,3/2>; // row 1        0 / -.5

#local B21=<0,0,2/2>; #local B22=<1,0,2/2>; //                0 / 0
#local B23=<2,0,2/2>; #local B24=<3,0,2/2>; // row 2          0 / 0

#local B31=<0,0,1/2>; #local B32=<1,0,1/2>; //                0 / 0
#local B33=<2,0,1/2>; #local B34=<3,0,1/2>; // row 3          0 / 0

#local B41=<0,Angle3,0>; #local B42=<1,0,0>; //                   .7 / 0
#local B43=<2,0,0>; #local B44=<3,Angle4,0>; // row 4             0 / .3
        
#declare Scheet_Texture_1 = texture {
        pigment {
                cylindrical
                turbulence 1.6 - 0.2*Angle2
                octaves 3 + 0.2*Angle3
                lambda 3
                translate -.5*y
                color_map {
                        [0.00 rgb<0., 0., 0.>]
                        [0.01 rgb<0., 0., 0.>]
                        [0.03 Brown/4]
                        [0.07 Yellow/3]
                        [0.15 rgb my_color]
                        [1.0 rgb my_color]
                 //       [0.85 rgb my_color]
                 //       [0.93 Yellow/3]
                 //       [0.97 Brown/4]
                 //       [0.99 rgb<0., 0., 0.>]        
                 //       [1.00 rgb<0.05, 0.05, .0>]
                }
        }        
}                                    

#declare Scheet_Texture_2 = texture {
        pigment {
                gradient y
                turbulence .5
                octaves 2
                lambda 1     
                translate <.4, 0, 0>
                color_map {
                        [0.00 rgb<0., 0., 0.>]
                        [0.04 rgb<0., 0., 0.>]
                        [0.06 Brown/4]
                        [0.10 Yellow/3]
                        [0.20 rgb my_color transmit 1.]
                        [0.50 rgb my_color transmit 1.]
                        [0.1 rgb my_color transmit 1.]
                     //   [0.95 Yellow/3]
                     //   [0.97 Brown/4]
                     //   [0.98 rgb<0., 0., 0.>]        
                     //   [1.00 rgb<0.05, 0.05, .0>] 
                }
        }
        finish {
                ambient .3
                phong 10
                phong_size 210
        }                
}               
    
    
difference {
        bicubic_patch {
                type 1 flatness 0.001
                u_steps 4 v_steps 4
                uv_vectors
                <0,0> <1,0> <1,1> <0,1>
                B11, B12, B13, B14
                B21, B22, B23, B24
                B31, B32, B33, B34
                B41, B42, B43, B44
                uv_mapping
                texture {
                        Scheet_Texture_1
//                        pigment { my_color }
                        finish {phong .006 phong_size 200}
                }
      /*          texture {
                        Scheet_Texture_2
//                        pigment { my_color }
                        finish {phong 0.6 phong_size 20}
                }  */ 
                no_shadow
        }
        cylinder {
                <2.8, -5, .75>, <2.8, 5, .75>, .1
                pigment { my_color }
        }
}
#end    
        

#macro Ticket (my_text, Angle1, Angle2, Angle3, Angle4, my_color, scala)
        #declare testo = text {
                ttf "timrom.ttf" my_text 1, 0
                pigment { Black }
                scale <scala, scala, scala>
                rotate <90, 0, 0>
                translate <0.1, 0.3, .5>
        }                    


        // Here I declare the rope

        #declare Rope =  union {
                difference {
                        torus {
                                1, 0.02
                        }
                        box {
                                <-1.2, -.8, -8>, <.82, .8, 8>
                        }
                }
                torus {
                        0.05, 0.02 
                        rotate <-45, 0, 90>
                        translate <.8, 0, .6>
                }
                torus {
                        0.08, 0.02
                        translate <.77, 0, -.63>
                }
                scale <1, 1, 1.1>
                texture {
                        pigment {
                                color Gold
                        }
                        finish {        
                                brilliance 1
                                diffuse .6
//                                ambient .3
                                reflection .5
                                metallic 1
                                specular .20
                                roughness 20
                                phong .7
                                phong_size 500
                        }        
                }                        
        }                 
        
        union {
                object {
                        Rope                               
                        rotate <0, 30, 90>
                        translate <-.95, 1.55, 1.2>
                        scale <.7, .7, .7>
                }
                object {
                        union {
                                difference {
                                        object {scheet(Angle1, Angle2, Angle3, Angle4, my_color)}
                                        object { testo }
                                } 
                                object {scheet(Angle1, Angle2, Angle3, Angle4, Black) translate <0, -0.001, 0>}
                                object {scheet(Angle1, Angle2, Angle3, Angle4, my_color) translate <0, -0.002, 0>}
                        }
                        scale <.5, .5, .5>
                        rotate <60, 200, -70>
                        translate <.1, .07, -.2>
                }
        }        
#end

 
#macro Planet_Ball (my_image, my_angle, my_clouds, my_text, Angle1, Angle2, Angle3, Angle4, my_color, scala, X_pos, Y_pos, Z_pos, X_axis, Y_axis, Z_axis)
union {
        object { Ball }
        object { Planets (my_image, my_angle, my_clouds) }        
        object {
                Ticket (my_text, Angle1, Angle2, Angle3, Angle4, my_color, scala)               
                translate <.66, -.6, -1.17>
        }
        rotate <X_axis, Y_axis, Z_axis>
        translate <X_pos, Y_pos, Z_pos>
}
#end                

/*
object {
        Ticket ("Neptune", -.1, -.5, .2, .6, White, 0.7)
        translate <.66, -.6, -1.17>
        rotate <0, -80, 0>
} 
*/
       

// The Alien Sea

#declare Threshold = .3;                                                                 
#declare Max_Gradient = tan(acos((1.2-Threshold)/1.2));
#declare Radius = function { sqrt(pow(x,2) + pow(y,2) + pow(z,2)) }
#declare Alfa = - sqrt(pow(1.2,2)+pow(1.2 - Threshold,2)) - asin(Max_Gradient);
#declare Slope = function { exp(-pow(Radius(x, y, z),2)/5)/4 }
#macro Wave (X_pos, Y_pos, Z_pos)
        function { (Radius(x - X_pos, y - Y_pos, z - Z_pos) <= sqrt(pow(1,2)+pow(1 - Threshold,2)))*(y) 
        + (Radius(x - X_pos, y - Y_pos, z - Z_pos) > sqrt(pow(1,2)+pow(1 - Threshold,2)))*(y - cos(sqrt(pow((x - X_pos)*10,2) + pow((z - Z_pos)*10,2))+Alfa)*Slope(x - X_pos, y - Y_pos, z - Z_pos)) }
#end
//#declare Waves1 = Wave(0, 0, 0)
//#declare Waves2 = Wave(2, 0, 2)
//#declare Waves3 = Wave(-3, 0, -2)
//#declare Waves = Waves1(x, y, z) + Waves2(x, y, z) + Waves3(x, y, z)        


#declare v_pos = array[7][7][7]

//                         X                               Y                               Z
#declare v_pos[0][0][0] = +1.20;  #declare v_pos[1][1][1] = 0.00;  #declare v_pos[2][2][2] = -1.50; // First Wave                     
#declare v_pos[1][0][0] = -8.00;  #declare v_pos[0][1][0] = 0.00;  #declare v_pos[0][0][1] = +9.00; // Second Wave
#declare v_pos[2][0][0] = -7.00;  #declare v_pos[0][2][0] = 0.00;  #declare v_pos[0][0][2] = -8.00; // Third Wave
#declare v_pos[3][0][0] = -8.00;  #declare v_pos[0][3][0] = 0.00;  #declare v_pos[0][0][3] = -1.00; // Forth Wave
#declare v_pos[4][0][0] = -20.00;  #declare v_pos[0][4][0] = 0.00;  #declare v_pos[0][0][4] = -10.00; // Fifth Wave
#declare v_pos[5][0][0] = -16.0;  #declare v_pos[0][5][0] = 0.00;  #declare v_pos[0][0][5] = +3.00; // Sixth Wave
#declare v_pos[6][0][0] = -30.0;  #declare v_pos[0][6][0] = 0.00;  #declare v_pos[0][0][6] = +18.0; // Seventh Wave
#declare v_pos[3][3][3] = 00.0;  #declare v_pos[4][4][4] = 0.00;  #declare v_pos[5][5][5] = +1.50; // Eight - new_world Wave


#declare Waves = 
        function { (Radius(x - v_pos[0][0][0], y - v_pos[1][1][1], z - v_pos[2][2][2]) <= sqrt(pow(1,2)-pow(1 - Threshold,2)))*(y) 
        + (Radius(x - v_pos[0][0][0], y - v_pos[1][1][1], z - v_pos[2][2][2]) > sqrt(pow(1,2)-pow(1 - Threshold,2)))*(y - cos(sqrt(pow((x - v_pos[0][0][0])*10,2) + pow((z - v_pos[2][2][2])*10,2))+Alfa)*Slope(x - v_pos[0][0][0], y - v_pos[1][1][1], z - v_pos[2][2][2]))  
        + (Radius(x - v_pos[1][0][0], y - v_pos[0][1][0], z - v_pos[0][0][1]) <= sqrt(pow(1,2)-pow(1 - Threshold,2)))*(y) 
        + (Radius(x - v_pos[1][0][0], y - v_pos[0][1][0], z - v_pos[0][0][1]) > sqrt(pow(1,2)-pow(1 - Threshold,2)))*(y - cos(sqrt(pow((x - v_pos[1][0][0])*10,2) + pow((z - v_pos[0][0][1])*10,2))+Alfa)*Slope(x - v_pos[1][0][0], y - v_pos[0][1][0], z - v_pos[0][0][1]))
        + (Radius(x - v_pos[2][0][0], y - v_pos[0][2][0], z - v_pos[0][0][2]) <= sqrt(pow(1,2)-pow(1 - Threshold,2)))*(y) 
        + (Radius(x - v_pos[2][0][0], y - v_pos[0][2][0], z - v_pos[0][0][2]) > sqrt(pow(1,2)-pow(1 - Threshold,2)))*(y - cos(sqrt(pow((x - v_pos[2][0][0])*10,2) + pow((z - v_pos[0][0][2])*10,2))+Alfa)*Slope(x - v_pos[2][0][0], y - v_pos[0][2][0], z - v_pos[0][0][2])) 
        + (Radius(x - v_pos[3][0][0], y - v_pos[0][3][0], z - v_pos[0][0][3]) <= sqrt(pow(1,2)-pow(1 - Threshold,2)))*(y) 
        + (Radius(x - v_pos[3][0][0], y - v_pos[0][3][0], z - v_pos[0][0][3]) > sqrt(pow(1,2)-pow(1 - Threshold,2)))*(y - cos(sqrt(pow((x - v_pos[3][0][0])*10,2) + pow((z - v_pos[0][0][3])*10,2))+Alfa)*Slope(x - v_pos[3][0][0], y - v_pos[0][3][0], z - v_pos[0][0][3])) 
        + (Radius(x - v_pos[4][0][0], y - v_pos[0][4][0], z - v_pos[0][0][4]) <= sqrt(pow(1,2)-pow(1 - Threshold,2)))*(y) 
        + (Radius(x - v_pos[4][0][0], y - v_pos[0][4][0], z - v_pos[0][0][4]) > sqrt(pow(1,2)-pow(1 - Threshold,2)))*(y - cos(sqrt(pow((x - v_pos[4][0][0])*10,2) + pow((z - v_pos[0][0][4])*10,2))+Alfa)*Slope(x - v_pos[4][0][0], y - v_pos[0][4][0], z - v_pos[0][0][4])) 
        + (Radius(x - v_pos[5][0][0], y - v_pos[0][5][0], z - v_pos[0][0][5]) <= sqrt(pow(1,2)-pow(1 - Threshold,2)))*(y) 
        + (Radius(x - v_pos[5][0][0], y - v_pos[0][5][0], z - v_pos[0][0][5]) > sqrt(pow(1,2)-pow(1 - Threshold,2)))*(y - cos(sqrt(pow((x - v_pos[5][0][0])*10,2) + pow((z - v_pos[0][0][5])*10,2))+Alfa)*Slope(x - v_pos[5][0][0], y - v_pos[0][5][0], z - v_pos[0][0][5])) 
        + (Radius(x - v_pos[6][0][0], y - v_pos[0][6][0], z - v_pos[0][0][6]) <= sqrt(pow(1,2)-pow(1 - Threshold,2)))*(y) 
        + (Radius(x - v_pos[6][0][0], y - v_pos[0][6][0], z - v_pos[0][0][6]) > sqrt(pow(1,2)-pow(1 - Threshold,2)))*(y - cos(sqrt(pow((x - v_pos[6][0][0])*10,2) + pow((z - v_pos[0][0][6])*10,2))+Alfa)*Slope(x - v_pos[6][0][0], y - v_pos[0][6][0], z - v_pos[0][0][6])) 
        + (Radius(x - v_pos[3][3][3], y - v_pos[4][4][4], z - v_pos[5][5][5]) <= sqrt(pow(1,2)-pow(1 - Threshold,2)))*(y) 
        + (Radius(x - v_pos[3][3][3], y - v_pos[4][4][4], z - v_pos[5][5][5]) > sqrt(pow(1,2)-pow(1 - Threshold,2)))*(y - cos(sqrt(pow((x - v_pos[3][3][3])*10,2) + pow((z - v_pos[5][5][5])*10,2))+Alfa)*Slope(x - v_pos[3][3][3], y - v_pos[4][4][4], z - v_pos[5][5][5])) }

#declare Sea =             
merge {
        plane { 
                y, -10. 
//                pigment { color White }
        }             
        isosurface {
                function { Waves(x, y, z) }
                threshold -0.4         
                accuracy 0.00001
                max_gradient 6
                open
                contained_by { box { <-50, -50, -50>, <50, 50, 50> }}                
        }        
        texture {
                pigment { 
                        SeaGreen
//                        color White
                        filter .7
                }
       //         finish {ambient .2 reflection .75 specular 1}
                normal {
                        waves .2
                        turbulence .6
                        scale 10
                        frequency 2
                        sine_wave
                }     
        } 
        interior {
                ior 1.33      
                dispersion 1.01
                dispersion_samples 10
                fade_distance 2
                fade_power 2
        }                                    
        finish  {              
                ambient .2
                brilliance .7
                conserve_energy
                reflection { 
                        0.10, 0.50
                        fresnel on
                        exponent .7
                }		
        }                      
}                

/*
sky_sphere {
        pigment { gradient x 
                color_map {
                        [0.0 color rgbt <0.7, 0.0, 1.0, .7>]
                        [1.0 color rgbt <0.3, 0.3, 0.9, .7>]
                }
        }                
        pigment {
                bozo
                turbulence .65
                lambda 2
                omega .7
                octaves 6
                color_map {
                        [0.0 0.1 color rgb <0.35, 0.35, 0.85> color rgb <0.25, 0.25, 0.75>]
                        [0.1 0.5 color rgb <0.25, 0.25, 0.75> color rgbt <1, 1, 1, 1>]
                        [0.5 1.0 color rgbt <1, 1, 1, 1> color rgbt <1, 1, 1, 1>]
                }
                scale <.2, .5, .2>
        }
        rotate 100*x
}                                                              
*/

sky_sphere {
    pigment { rgb <0.258, 0.258, 0.435> }
    pigment {
        bozo
        turbulence 1.5
        octaves 10
        omega .5
        lambda 2.5
        color_map {
            [0.0, 0.5 color rgbt<.75, .75, .75, 0>
                      color rgbt<.9, .9, .9, .9> ]
            [0.5, 0.7 color rgbt<.9, .9, .9, .9>
                      color rgbt<1, 1, 1, 1> ]
            [0.7, 1.0 color rgbt<1, 1, 1, 1>
                      color rgbt<1, 1, 1, 1> ]
        }
    scale <1, 0.3, 10>
    }
    pigment {
        bozo
        turbulence 0.6
        octaves 10
        omega .5
        lambda 2.5
        color_map {
            [0.0, 0.4 color rgbt<.75, .75, .75, 0>
                      color rgbt<.9, .9, .9, .9> ]
            [0.4, 0.7 color rgbt<.9, .9, .9, .9>
                      color rgbt<1, 1, 1, 1> ]
            [0.7, 1.0 color rgbt<1, 1, 1, 1>
                      color rgbt<1, 1, 1, 1> ]
        }
    scale <1, 0.3, 10>
    }
    pigment {
        bozo
        turbulence 0.8
        octaves 10
        omega .5
        lambda 2.5
        color_map {
            [0.0, 0.4 color rgbt<.75, .75, .75, 0>
                      color rgbt<.9, .9, .9, .9> ]
            [0.4, 0.6 color rgbt<.9, .9, .9, .9>
                      color rgbt<1, 1, 1, 1> ]
            [0.6, 1.0 color rgbt<1, 1, 1, 1>
                      color rgbt<1, 1, 1, 1> ]
        }
    scale <1, 0.3, 10>
    }
}                                                              


//  (file, rotation of the planet, clouds y/n, name of planet, so scheet, no scheet, se scheet, ne scheet, color scheet, traslation of all, rotation of all)
//


union {
        difference {
                object { Sea }
                union {
                        object { sphere { <0, 0, 0>, 1.2 } translate <v_pos[0][0][0], v_pos[1][1][1], v_pos[2][2][2]> }  
                        object { sphere { <0, 0, 0>, 1.2 } translate <v_pos[1][0][0], v_pos[0][1][0], v_pos[0][0][1]> }
                        object { sphere { <0, 0, 0>, 1.2 } translate <v_pos[2][0][0], v_pos[0][2][0], v_pos[0][0][2]> }
                        object { sphere { <0, 0, 0>, 1.2 } translate <v_pos[3][0][0], v_pos[0][3][0], v_pos[0][0][3]> }
                        object { sphere { <0, 0, 0>, 1.2 } translate <v_pos[4][0][0], v_pos[0][4][0], v_pos[0][0][4]> }
                        object { sphere { <0, 0, 0>, 1.2 } translate <v_pos[5][0][0], v_pos[0][5][0], v_pos[0][0][5]> }
                        object { sphere { <0, 0, 0>, 1.2 } translate <v_pos[6][0][0], v_pos[0][6][0], v_pos[0][0][6]> }
                        object { sphere { <0, 0, 0>, 1.2 } translate <v_pos[3][3][3], v_pos[4][4][4], v_pos[5][5][5]> } 
                }        
        }           
        object {
                Planet_Ball ("Terra.jpg", 150, 1, "Earth", 1, -.5, .7, .3, White, 1.0, v_pos[0][0][0], v_pos[1][1][1], v_pos[2][2][2], 0, -50, 0)                
        } 
        object {
                Planet_Ball ("Venere.jpg", 0, 0, "Venus", 1, -.5, .7, -.1, White, 1.0, v_pos[1][0][0], v_pos[0][1][0], v_pos[0][0][1], 20, -30, 0)                
        }                 
        object {
                Planet_Ball ("Marte.jpg", 0, 0, "Mars", -.3, .5, .2, .3, White, 1.0, v_pos[2][0][0], v_pos[0][2][0], v_pos[0][0][2], 0, -30, 30)                
        }
        object {
                Planet_Ball ("Mercurio.jpg", 0, 0, "Mercury", 1, .5, -.7, -.3, White, 0.7, v_pos[3][0][0], v_pos[0][3][0], v_pos[0][0][3], 0, -70, 0)                
        }
        object {
                Planet_Ball ("Nettuno.jpg", 0, 0, "Neptune", -.1, -.5, .2, .6, White, 0.7, v_pos[4][0][0], v_pos[0][4][0], v_pos[0][0][4], 0, -100, 0)                
        }
        object {
                Planet_Ball ("Plutone.jpg", 0, 0, "Pluton", -.8, -.5, -.7, -.3, White, 0.8, v_pos[5][0][0], v_pos[0][5][0], v_pos[0][0][5], 0, -20, 0)                
        }
        object {
                Planet_Ball ("Urano.jpg", 0, 0, "Uran", -1, .5, -.7, .8, White, 1., v_pos[6][0][0], v_pos[0][6][0], v_pos[0][0][6], 0, -130, 0)                
        } 
}      


object {
        Hand
        scale .65 
        rotate <20, 14, 0>
        translate <.7, 1.5, .55>
}



object {
        new_world
        translate <v_pos[3][3][3], v_pos[4][4][4], v_pos[5][5][5]>
}
        

// Sea

/*
sphere {
        <0, 0, 1.5>, 1.2
        pigment { Orange        
        }
}
sphere {
        <v_pos[0][0][0], v_pos[1][1][1], v_pos[2][2][2]>, 1.2
        pigment { Red        
        }
}
sphere {
        <v_pos[1][0][0], v_pos[0][1][0], v_pos[0][0][1]>, 1.2
        pigment { Blue        
        }
}
sphere {
        <v_pos[2][0][0], v_pos[0][2][0], v_pos[0][0][2]>, 1.2
        pigment { White        
        }
}
sphere {
        <v_pos[3][0][0], v_pos[0][3][0], v_pos[0][0][3]>, 1.2
        pigment { Pink        
        }
}
sphere {
        <v_pos[4][0][0], v_pos[0][4][0], v_pos[0][0][4]>, 1.2
        pigment { Yellow        
        }
}
sphere {
        <v_pos[5][0][0], v_pos[0][5][0], v_pos[0][0][5]>, 1.2
        pigment { Green        
        }
}
sphere {
        <v_pos[6][0][0], v_pos[0][6][0], v_pos[0][0][6]>, 1.2
        pigment { Black        
        }
}
*/       
 
