// Persistence of Vision Ray Tracer Scene Description File
// File: ?.pov
// Vers: 3.5
// Desc: Radiosity Scene Template
// Date: mm/dd/yy
// Auth: ?
//

#version 3.5;

// ==== Standard POV-Ray Includes ====
#include "colors.inc"	  // Standard Color definitions
#include "textures.inc"	  // Standard Texture definitions
#include "functions.inc"  // internal functions usable in user defined functions
#include "stones2.inc"                                                            


#include "skies.inc"      // Ready defined sky spheres

#declare tester=0;
// ----------------------------------------
 
#include "functions.inc" 
#declare R2 = seed(1);                                                         

#declare R3 = seed(3); 
 

global_settings {
      assumed_gamma 1
}


 
 
camera {

  location  <10,16,-27>
  look_at   <0,9,0>
  
  aperture 1/70
  focal_point<0,15.3,5> 
  blur_samples 45
}

light_source {
  <-300,300,-200>       // light's position
  color rgb <1, 1, 1>  // light's color
}   

// Create an infinite sphere around scene and allow any pigment on it
sky_sphere {
  pigment {
    gradient y
    color_map { [0.0 color rgb <0.7,0.7,1.0>] [1.0 color blue 0.5] }
  }
}


// ----------------------------------------




#include "fgrass1J.inc"


 
plane {
 y,0
 texture {                         
 
  pigment { 
   bozo 
   color_map {
    [0 color rgb <1,1,0>]
    [1 color rgb <0.6,0.3,0>]
   }
  
   turbulence 0.3   
   scale 10
  }
  
  normal {leopard 0.8 scale <20,10,10>*15 rotate <0,45,0> 
   turbulence 0.1}
  }
 
 } 
 

#declare J=80000;

#if(tester=1)
#declare J=80;
#end

#declare j=0;
#while(j<J)
#declare j=j+1;
               


object {
 Grass 
 texture{
  txtGrass 
 }            
 rotate <0,360*rand(R2),0>
 
 translate <0,0,+1.5+exp(j/8000)/50>
 rotate <0,360*rand(R3),0>
 translate <0,0,5>   
 scale <2,2,2>
}
 
 
#end  
 
#declare Grasdeckel = union {  
#declare J=10;
#declare j=-1;
#while(j<J)
#declare j=j+1;
               
#declare I=10;
#declare i=-1;
#while(i<I)
#declare i=i+1;

object {
 Grass 
 texture{
  txtGrass 
 }
 rotate <0,360*rand(R2),0>
 
 translate <0.5,0,0>*i
 translate <0,0,0.5>*j  
 
 scale <2,2,2>

}
 
#end 
#end
}

union {
object {Grasdeckel translate <0,10,0>}
object {Grasdeckel rotate <-90,0,0>}
object {Grasdeckel rotate <-90,0,0> rotate <0,90,0> translate <0,0,10>}
object {Grasdeckel rotate <-90,0,0> rotate <0,-90,0> translate <10,0,0>}  

translate <-5,0,0>
}


box {<-5,0,0><5,10,10> pigment{pigEarth}}






 
#declare Blatt_farbe1 = <0,0.8,0,0.1,0.1>  ;
#declare Blatt_farbe2 = <0.3,0.5,0,0.1,0.1> ;
#declare Blatt_farbe3 = <0.5,0.7,0,0.1,0.1>  ;
#declare Blatt_farbe4 = <0.5,0.9,0,0.1>  ;
#include "TREE.inc"

#declare B1=object {Baum1} // ca: breite:(x) [-5,5] tiefe(z): [-5,5] hhe(y) [0,10] // braucht #include "textures.inc"   

#declare Blatt_farbe1 = <0,0.8,0,0.1,0.1>  ;
#declare Blatt_farbe2 = <0.3,0.9,0,0.1,0.1> ;
#declare Blatt_farbe3 = <0.5,0.6,0,0.3,0.1>  ;
#declare Blatt_farbe4 = <0.5,0.7,0,0.1>  ;
#include "TREE2.inc"

#declare B2 = object {Baum2 } // ca: breite:(x) [-5,5] tiefe(z): [-5,5] hhe(y) [0,10] // braucht #include "textures.inc"   

#include "txttree.inc"
#declare txtTree=texture{txtTree_5}
#declare txtLeaf=texture{txtLeaf_1}
#declare Leaf=object{#include "TREE3b.inc"} 
#declare Tree1=object{#include "TREE3c.inc"

}                        
// remove the following for leafless tree or for test
#declare Foliage1=object{#include "TREE3a.inc"
        texture{txtLeaf} 
}
                                                     

#declare B3 = union{
     object{Tree1}
     object{Foliage1}
scale 1/5
}
     
#include "txttree.inc"
#declare txtTree=texture{txtTree_5}
#declare txtLeaf=texture{txtLeaf_1}
#declare Leaf=object{#include "TREE4b.inc"} 
#declare Tree1=object{#include "TREE4c.inc"

}                        
// remove the following for leafless tree or for test
#if(tester=0)

#declare Foliage1=object{#include "TREE4a.inc"
        texture{txtLeaf} 
}
#end                                                     

#declare B4 = union{
     object{Tree1}
     object{Foliage1}
scale 1/5
}
  



object {B3 translate <0,10.3,5>}

#declare R1 = seed(656);  
  

               
#declare T=0;

#declare TM=30;

#if(tester=1) 
#declare TM=3;
#end

#while(T<TM)
#declare T=T+1;

object {B1 rotate <0,360*rand(R1),0> translate <(rand(R1)-0.5)*150,0,(rand(R1)-0.2)*180>}

#end


#declare T=0;

#declare TM=40;
#if(tester=1) 
#declare TM=4;
#end

#while(T<TM)
#declare T=T+1;

object {B2 rotate <0,360*rand(R1),0> translate <(rand(R1)-0.5)*200,0,(rand(R1)-0.1)*140> }

#end



#declare T=0;
              
#declare TM=8;
#if(tester=1) 
#declare TM=1;
#end

#while(T<TM)
#declare T=T+1;

object {B4 rotate <0,360*rand(R1),0> translate <(rand(R1)-0.5)*120,0,150*(rand(R1)-0.1)>}


#end


               