#version 3.5;

                       
//rad 2BL2 = 10101 sec + 25670 sec = 9.9 hrs
                                               
// +AA.03

#include "colors.inc"
#include "stones.inc"
#include "woods.inc" 
#include "metals.inc"
#include "functions.inc" 
#include "transforms.inc"

#include "runes.inc"


#declare cm = .01;
#include "units.inc"                                                   
                                               
#declare R1 = seed(4456);
#declare PreTrace = 1;  //0 = compute radiosity only  1 = final render
#declare Rad_Quality = 2; //use 3 for final
#declare High_MSamples = 0; //0 = few media samples (faster), 1 = many media samples (slower)

#declare Colum       = 0; //0 = turn on texture
#declare Floor1      = 0;
#declare DoorSlab    = 0;
#declare Entrance    = 0;
#declare DoorWayTop  = 0;
#declare Toomb       = 0;
#declare Roof        = 0; 
#declare Bench       = 0;
#declare RearWall1   = 0; 
#declare DoorWall1   = 0;

#declare Extra       = 1;  //1 = display
#declare WindowLight = 1;
#declare SlowLight   = 1; //1 = true use without radiosity

#if (Rad_Quality < 4) #default {finish{ambient 0}} #end 

global_settings{ assumed_gamma 1
                 max_trace_level 100
                                  
#switch (Rad_Quality)
 #case (1)
  radiosity {             // --- Settings 1 (fast) ---
     #if (PreTrace = 0)
        pretrace_start 0.08
        pretrace_end   0.008
        count 50
        error_bound 0.5
        recursion_limit 2
        nearest_count 1
        gray_threshold 0
        brightness 1.0
        media on
        normal on 
        always_sample off
        save_file "BalinRad1"
     #else 
        load_file "BalinRad1"
        always_sample off
        pretrace_start 1 
        pretrace_end 1
     #end 
  }
 #break
 #case (2)
  radiosity {             // --- Settings 2 (medium quality) ---
     #if (PreTrace = 0)
        pretrace_start 0.08
        pretrace_end   0.008   //A=.01  B=.007
        count 100              //A=200  B=100
        error_bound 0.12       //A=.25  B=.15
        recursion_limit 3      //A=1    B=3
        brightness 1.0
        nearest_count 5
        media on
        normal on 
        always_sample off
        save_file "BalinRad2BL3"
     #else 
        load_file "BalinRad2BL3"
        always_sample off
        pretrace_start 1 
        pretrace_end 1
     #end 
  }
 #break
 #case (3)
  radiosity {             // --- Settings 3 (high quality) ---
     #if (PreTrace = 0)
        pretrace_start 0.08
        pretrace_end   0.008
        count 300   
        error_bound 0.08
        recursion_limit 4 
        brightness 1
        nearest_count 8
        media on
        normal on
        always_sample off
        save_file "BalinRad3"
     #else 
        load_file "BalinRad3"
        always_sample off
        pretrace_start 1 
        pretrace_end 1
     #end 
  }
 #break
 #end

}
                                                           
camera {
    angle 65
//    location <.6 * Feet, 20 * Feet, 5 * Feet> 
//    look_at <33 * Feet, 12 * Feet, 30 * Feet>
      location <.6 * Feet, 6 * Feet, 5 * Feet> 
      look_at <33 * Feet, 9.5 * Feet, 30 * Feet>
  }

#declare StainTex1= texture{
  pigment {
            bozo
            color_map {
                       [0 color rgbt <0,0,0,.5>]  
                       [1 color rgbt <1,1,1,.5>]
            } warp{turbulence 1} 
  } 
}

#declare StainTex2= texture{
  pigment {
            agate
            color_map {
                       [0 color rgbt <0,0,0,.8>]
                       [1 color rgbt <1,1,1,.8>]
            }  
  } 
}  
#declare StainTex3= texture{
  pigment {
            marble
            color_map {
                       [0 color rgbt <0,0,0,.75>]
                       [1 color rgbt <1,1,1,.75>]
            } warp{turbulence 2}  
  } 
} 
 
#declare StainTex4= texture{
  pigment {
            bozo
            color_map {
                       [0 color rgbt <0,0,0,.2>] 
                       [.5 color rgbt<0.36, 0.25, 0.20,.2> * 2]
                       [1 color rgbt <1,1,1,.2> * 2]
            } 
  } 
}  

#declare StainTex5= texture{
  pigment {
            bozo
            color_map {
                       [0 color rgbt < 0, 0, 0, .7>]
                       [1 color rgbt < 1, 1, 1, .7>] 
            } warp{turbulence .5}   
  } 
}

#declare StainTex6= texture{
  pigment {
            bozo
            color_map {
                       [0 color rgbt <.6,.6,.6,.6>]
                       [1 color rgbt <1.2,1.2,1.2,.6>] 
            }  
  } 
}

#declare F_MetalA  =
finish {
    ambient 0.35
    brilliance 2
    diffuse 0.3
    metallic
    specular 0.80
    roughness 1/20
    reflection 0.1
}
#declare P_Silver1   = color rgb <0.94, 0.93, 0.80>;
#declare T_Silver_1A = texture { pigment { P_Silver1 } finish { F_MetalA  } }

#declare WeaponTex =
material{
          texture {T_Silver_1A}
          texture{ StainTex4 scale <.2 * Feet, .2 * Feet, .2 * Feet> }
}                      


#declare SpearTex=  
material {
          texture { T_Wood3 scale 1 
          normal{spiral2 3,5 scale .09 rotate<90,0,0>}
         } 
}
                                  
#declare WallTex1=  
material {
          texture { T_Stone14 scale .3 normal{bumps 3 scale .2 no_bump_scale}} 
          texture{ StainTex1 scale <1 * Feet, 4 * Feet, 1 * Feet> }
         } 

#declare CeilingTex=
material {
          texture { T_Stone14 scale .4 normal{bumps 5 scale .03 no_bump_scale}} 
          texture{ StainTex3 scale <1 * Feet, 1.5 * Feet, 1 * Feet> }
         } 
         
#declare DoorTex=  
material {
          texture { T_Stone14 scale .3  normal{bumps 5 scale .03 no_bump_scale}} 
          texture{ StainTex5 scale <2 * Feet, 3 * Feet, 2 * Feet> }
         }
#declare DoorTex1=  
material {
          texture { T_Stone14 scale .3 }//normal{bumps 4 scale .3 no_bump_scale}} 
          texture{ StainTex6 scale <1 * Feet, 2 * Feet, 1 * Feet> }
         }
          
#declare FloorTex=  
material {
          texture { T_Stone14 scale .3 }//normal{bumps 3 scale .05 no_bump_scale}} 
          texture{ StainTex1 scale <5 * Feet, 5 * Feet, 5 * Feet> }
         } 
        
#declare BenchTex=  
material {
          texture { T_Stone20 scale .3 normal{bumps 3 scale .02 * Feet}} 
          //texture{ StainTex3 scale <5 * Feet, 5 * Feet, 5 * Feet> }
         } 
         
#declare BenchTex1=  
material {
          texture { T_Stone14 scale .45 }//normal{bumps 3 scale .05 no_bump_scale}} 
          texture{ StainTex6 scale <.2 * Feet, .2 * Feet, .2 * Feet> }
         } 


#declare fn_Pigm=function {
    pigment {
      agate
      color_map {
        [0 color rgb 0]
        [1 color rgb 1]
      }  
    } 
  }

  
#declare IsosfcFloor = 
isosurface {
    function { f_rounded_box(x/1000+.8,y/1000,z/1000+.4, .8, 1, 1, 1) + 
               fn_Pigm(x , y, z).gray*.7 }

    contained_by { box { -.5, .5 } } 
    max_gradient 9.9   //9.932                 
  } 

#declare IsosfcRoof = 
isosurface {
    function { f_rounded_box(x-.3,y-.2,z+.2, .8, 1, 1, 1) + 
               fn_Pigm(x , y, z).gray*.9 }

    contained_by { box { -.5, .5 } } 
    max_gradient 9.9                  
  } 
#declare IsosfcRoof1 = 
isosurface {
    function { f_rounded_box(x-.3,y-.2,z+.2, .8, 1, 1, 1) + 
               fn_Pigm(x , y, z).gray * .5 }

    contained_by { box { -.5, .5 } } 
    max_gradient 9.9                  
  } 

#declare IsosfcBench = 
isosurface {
    function { f_rounded_box(x,y-.1,z-.2, .8, 1, 1, 1) + 
               fn_Pigm(x , y, z).gray*.5 }

    contained_by { box { -.5, .5 } } 
    max_gradient 9.9                  
  } 

#declare IsosfcRearWall = 
isosurface {
    function { f_rounded_box(x-.3,y-.2,z+.2, .8, 1, 1, 1) + 
               fn_Pigm(x , y, z).gray*.55 }

    contained_by { box { -.5, .5 } } 
    max_gradient 9.9                    
  } 

#declare IsosfcDoorWall = 
isosurface {
    function { f_rounded_box(x+.5,y,z-.4, .8, 1, 1, 1) + 
               fn_Pigm(x , y, z).gray*.55}

    contained_by { box { -.5, .5 } } 
    max_gradient 9.9                   
  } 

#declare IsosfcDoor = 
isosurface {
    function { f_rounded_box(x,y,z, .8, 1, 1, 1) - fn_Pigm(x, y, z).gray*.5}

    contained_by { box { -1, 1 } } 
    max_gradient 9.932                 
  }

#declare Media1 = 
     media{
	scattering {3, rgb<.8,.8,1> extinction .5}    
	//absorption .9
	method 3
	intervals 1
        #if (High_MSamples) samples 35,250 #else samples 5,10 #end 
        density { gradient -y
          color_map {
                     [0.0 rgb <.1,.1,.1>]
                     [1.0 rgb <.2,.2,.2>] //.2 - .5
                    }
        } scale 20 * Feet  //20
}


#macro CobWeb1(X,Y,Z,dX,dY,dZ,N)
  #local N1 = 1;
  #local X1 = X;
  #local Y1 = Y;
  #local Z1 = Z;
  #while (N1 < N)
     #local N2 = 1;                  
     #while (N2<40)
        #local X2 = X + (rand(R1) * dX);
        #local Y2 = Y + (rand(R1) * dY);
        #local Z2 = Z + (rand(R1) * dZ);

        cylinder {
               <X1 * Feet,Y1 * Feet,Z1 * Feet>, 
               <X2 * Feet,Y2 * Feet,Z2 * Feet>, rand(R1) * .03 //.01
               pigment{color rgbt<.8,.8,.8,.9>}
               finish{ambient .2}     
        }   
        #local N2 = N2 + 1;
        #local X1 = X2;
        #local Y1 = Y2;
        #local Z1 = Z2;
     #end                     
        #local X2 = X + (rand(R1) * dX);
        #local Y2 = Y + (rand(R1) * dY);
        #local Z2 = Z + (rand(R1) * dZ);
     
     #local X1 = X2;
     #local Y1 = Y2;
     #local Z1 = Z2;
     #local N1 = N1 + 1;
  #end
     
#end 


#if (WindowLight)
//window light
light_source {
  0*x                 // light's position (translated below)
  color rgb <.8,.8,1>      // light's color
  area_light <8 * Feet, 0, 0> <0, 8 * Feet, 0> // lights spread out across this distance (x * z)
  10, 10                // total number of lights in grid (4x*4z = 16 lights)
  adaptive 0          // 0,1,2,3...
  jitter              // adds random softening of light
  circular            // make the shape of the light circular
  orient              // orient light
  translate <-50 * Feet, 63 * Feet, 25 * Feet> 
} 
                      
//media box
box{<-.5,-.5,-.5>,<.5,.5,.5>
    pigment{ rgbt<1,1,1,1>}
    scale <4 * Feet, 85 * Feet, 8 * Feet>   //z was 16
    translate<33 * Feet,0 * Feet,25 * Feet>
    Rotate_Around_Trans(<0,0,53>,<31 * Feet,0*Feet,25*Feet>)
    hollow on 
    no_shadow
    interior{media{Media1}}
} 
#end  //window light

#if (Rad_Quality < 4)

//ceiling light
light_source {
  0*x                 // light's position (translated below)
  color rgb <.6,.6,1> * 4       // light's color   
  spotlight               // this kind of light source
  area_light
  <30 * Feet, 0, 0> <0, 30 * Feet, 0> // lights spread out across this distance (x * z) was 10x10
  4, 4                // total number of lights in grid (4x*4z = 16 lights)             
  adaptive 1          // 0,1,2,3...
  jitter              // adds random softening of light
  circular            // make the shape of the light circular
  orient              // orient light
  fade_power 2
  fade_distance 30 * Feet
  translate < 35 * Feet, 60 * Feet, 25 * Feet> 
//  translate < 45 * Feet, 100 * Feet, 35 * Feet> 
  point_at <35 * Feet, 0 * Feet, 25 * Feet>      // direction of spotlight
  radius  60               // hotspot (inner, in degrees)
  tightness 10            // tightness of falloff (1...100) lower is softer, higher is tighter
  falloff 180               // intensity falloff radius (outer, in degrees)
}

//red door light
light_source {
  0*x                 // light's position (translated below)
  color rgb <1.3,0,0>       // light's color   ADDBLUE
  fade_power 2
  fade_distance 25 * Feet   //15 - 25
  translate <100 * Feet, 20 * Feet, 20 * Feet> 
}

//right light
light_source {
  0*x                 // light's position (translated below)
  color rgb <.8,.8,1> * .5     // light's color * .8
  area_light <50 * Feet, 0, 0> <0, 50 * Feet, 0> // lights spread out across this distance (x * z)
  4, 4                // total number of lights in grid (4x*4z = 16 lights)
  adaptive 1          // 0,1,2,3...
  jitter              // adds random softening of light
  circular            // make the shape of the light circular
  orient              // orient light
  translate <30 * Feet, 50 * Feet, -100 * Feet> 
} 

//front light  
light_source {
  0*x                 // light's position (translated below)
  color rgb <.8,.8,1> * .3    // light's color * .6
  area_light
  <20 * Feet, 0, 0> <0, 20 * Feet, 0> // lights spread out across this distance (x * z)
  4, 4                // total number of lights in grid (4x*4z = 16 lights)
  adaptive 1          // 0,1,2,3...
  jitter              // adds random softening of light
  circular            // make the shape of the light circular
  orient              // orient light
  translate < 1 * Feet, 35 * Feet, 30 * Feet> 
} 

#else //rad_Quality

#if (SlowLight)

//ceiling light
light_source {
  0*x                 // light's position (translated below)
  color rgb <.6,.6,1> * 4       // light's color   ADDBLUE
  spotlight               // this kind of light source
  area_light
  <30 * Feet, 0, 0> <0, 30 * Feet, 0> // lights spread out across this distance (x * z) was 10x10
  4, 4                // total number of lights in grid (4x*4z = 16 lights)           
  adaptive 1          // 0,1,2,3...
  jitter              // adds random softening of light
  circular            // make the shape of the light circular
  orient              // orient light
  fade_power 2
  fade_distance 30 * Feet
  translate < 35 * Feet, 60 * Feet, 25 * Feet> 
//  translate < 45 * Feet, 100 * Feet, 35 * Feet> 
  point_at <35 * Feet, 0 * Feet, 25 * Feet>      // direction of spotlight
  radius  60               // hotspot (inner, in degrees)
  tightness 10            // tightness of falloff (1...100) lower is softer, higher is tighter
  falloff 180               // intensity falloff radius (outer, in degrees)
}

//red door light
light_source {
  0*x                 // light's position (translated below)
  color rgb <1.3,0,0>       // light's color   ADDBLUE
  fade_power 2
  fade_distance 25 * Feet   //15 - 25
  translate <100 * Feet, 20 * Feet, 20 * Feet> 
}

//right light
light_source {
  0*x                 // light's position (translated below)
  color rgb <.8,.8,1> * .5     // light's color  * .8
  area_light <50 * Feet, 0, 0> <0, 50 * Feet, 0> // lights spread out across this distance (x * z)
  4, 4                // total number of lights in grid (4x*4z = 16 lights)
  adaptive 1          // 0,1,2,3...
  jitter              // adds random softening of light
  circular            // make the shape of the light circular
  orient              // orient light
  translate <30 * Feet, 50 * Feet, -100 * Feet> 
} 

//front light  
light_source {
  0*x                 // light's position (translated below)
  color rgb <.8,.8,1> * .3    // light's color  * .6
  area_light
  <20 * Feet, 0, 0> <0, 20 * Feet, 0> // lights spread out across this distance (x * z)
  4, 4                // total number of lights in grid (4x*4z = 16 lights)
  adaptive 1          // 0,1,2,3...
  jitter              // adds random softening of light
  circular            // make the shape of the light circular
  orient              // orient light
  translate < 1 * Feet, 35 * Feet, 30 * Feet> 
} 
#else //Slow Light

light_source {
  0*x                 // light's position (translated below)
  color rgb 1       // light's color
  translate <35 * Feet, 25 * Feet, 25 * Feet> 
} 
#end //if slowlight
#end //if rad quality



sky_sphere {
    pigment {
      gradient y
      color_map {
        [ 0.5  color Black ]
        [ 1.0  color Black ]
      }
      scale 2
      translate -1
    }
  }

#declare CutOut =
prism {
  linear_sweep 
  linear_spline                              
   -.5,         // height 1
    .5,         // height 2
   5,           // number of points
     < 2, 0>, < 1 , 1>, < -1, 1 >, < -2,  0>, < 2, 0> 
} 

#declare CutOut1 =
prism { 
  linear_spline                              
   -.5,         // height 1
    .5,         // height 2
   7,           // number of points
   <-.22 , -.3>,  < 0, -.3  >, < .2 , -.3>, 
   < .2 , .2>,  < 0, .3>, <-.2 , .2>, <-.2,-.3> 
} 


//Floor 
#if (Floor1)
   #declare Floor=
   box{<-.5,-.5,-.5>,<.5,.5,.5>
       pigment{color DarkBrown}
       scale <70 * Feet, 1 * Feet, 60 * Feet>
       translate<35 * Feet,1 * Feet,25 * Feet>
   }
#else
    #declare Floor =
    #object{IsosfcFloor 
        scale <70 * Feet,1 * Feet,60 * Feet>
//        texture{T_Stone15 scale .3}                 
        material{FloorTex translate<rand(R1)*30 * Feet,rand(R1)*3 * Feet,rand(R1)*3 * Feet>}
        translate <35 * Feet, .8 * Feet, 25 * Feet>
    }
#end 

#object{Floor }

//Rear Wall
difference{
#if (RearWall1)
    box{<-.5,-.5,-.5>,<.5,.5,.5>
        pigment{color White}
        scale <70 * Feet, 30 * Feet, 5 * Feet>
        translate<35 * Feet,16 * Feet,55 * Feet>
    }
#else
    #object{IsosfcRearWall 
        scale <70 * Feet,30 * Feet,5 * Feet>
        material{WallTex1 translate<rand(R1)*30 * Feet,rand(R1)*3 * Feet,rand(R1)*3 * Feet>}
        translate <35 * Feet, 16 * Feet, 55 * Feet>
    }
#end
    prism { 
           linear_spline                              
           -.5,         // height 1
            .5,         // height 2
           13,           // number of points
           < -1.0,  0.7>, < -0.7,  0.7 >, < -0.7,  1.0>, 
           <  0.7,  1.0>, <  0.7,  0.7 >, <  1.0,  0.7>, 
           <  1.0, -0.7>, <  1.0, -0.7 >, <  1.0, -1.0>, 
           < -0.7, -1.0>, < -0.7, -0.7 >, < -1.0, -0.7>,
           < -1.0,  0.7>
           rotate<-90,0,0>
           scale <6 * Feet, 4 * Feet, 5 * Feet>
           translate<37 * Feet,16 * Feet,53 * Feet>
} 

    cutaway_textures
}

//Door Wall
difference{
#if (DoorWall1)
    box{<-.5,-.5,-.5>,<.5,.5,.5>
        pigment{color White}
        scale <1 * Feet, 50 * Feet, 70 * Feet>
        translate<70 * Feet,26 * Feet,25 * Feet>
        finish{ambient .2}
    }  
#else
    #object{IsosfcDoorWall 
        scale <1 * Feet,50 * Feet,70 * Feet>
        material{WallTex1 translate<rand(R1)*30 * Feet,rand(R1)*3 * Feet,rand(R1)*3 * Feet>}
        translate <70 * Feet, 26 * Feet, 25 * Feet> 
        finish{ambient .4}
    }
#end
    box{<-.5,-.5,-.5>,<.5,.5,.5>
        scale <8 * Feet, 30 * Feet, 15 * Feet> 
        translate<72 * Feet, 16 * Feet, 23 * Feet>
    }      
} 

//Light Wall
difference{
    box{<-.5,-.5,-.5>,<.5,.5,.5>
        pigment{ color White }
        scale <1 * Feet, 80 * Feet, 50 * Feet>
        translate<0 * Feet,26 * Feet,30 * Feet>
    }

    box{<-.5,-.5,-.5>,<.5,.5,.5>
        pigment{color White}
        scale <4 * Feet, 8 * Feet, 12 * Feet>
        translate<0 * Feet,26 * Feet,25 * Feet>
    }
}  //difference

#include "doorway.inc"
     
//platform far bottom 
union{
difference{
#if (Bench)
        box{<-.5,-.5,-.5>,<.5,.5,.5>
            pigment{color Brown}
            scale <70 * Feet, 6 * Feet, 8 * Feet>
            translate<35 * Feet, 4 * Feet,51 * Feet>
        }
#else 
    #object{IsosfcBench
        scale <70 * Feet,6 * Feet,8 * Feet>
        material{BenchTex translate<rand(R1)*30 * Feet,rand(R1)*3 * Feet,rand(R1)*3 * Feet>}
        translate <35 * Feet, 4 * Feet, 51 * Feet>
    }
#end
    #object{CutOut  
            scale<2 * Feet, 4 * Feet, 3 * Feet>      
            rotate<-90,0,0>
            translate<36 * Feet, 3 * Feet, 48.0 * Feet>
    }
    #object{CutOut  
            scale<2 * Feet, 4 * Feet, 3 * Feet>      
            rotate<-90,0,0>
            translate<20 * Feet, 3 * Feet, 48.0 * Feet>
    }
    #object{CutOut  
            scale<2 * Feet, 4 * Feet, 3 * Feet>      
            rotate<-90,0,0>
            translate<53 * Feet, 3 * Feet, 48.0 * Feet>
    }
    cutaway_textures

}//difference 

}//union 

//top molding far top 
#if (Roof)
#declare TopMolding=
    box{<-.5,-.5,-.5>,<.5,.5,.5>
        pigment{color Green}
    }
#else
#declare TopMolding=
    #object{IsosfcRoof1 
            material{CeilingTex translate<rand(R1)*30 * Feet,rand(R1)*3 * Feet,rand(R1)*3 * Feet>}
    }
#end 

#object {
#difference{
    #if (Roof)
    #object{TopMolding 
        scale <70 * Feet, 4 * Feet, 4 * Feet>
        translate<35 * Feet, 26 * Feet,47 * Feet>
        pigment{color Green}
    }
    #else    
    #object{TopMolding 
        scale <70 * Feet, 4 * Feet, 4 * Feet>
        translate<35 * Feet, 26 * Feet,47 * Feet>
        material{CeilingTex translate<rand(R1)*30 * Feet,rand(R1)*3 * Feet,rand(R1)*3 * Feet>}
    }
    #end //if roof
    #object{A scale <.2,10,.05> rotate <90,0,0> translate <17.0 * Feet, 25.9 * Feet, 46 * Feet>} 
    #object{B scale <.2,10,.05> rotate <90,0,0> translate <18.8 * Feet, 25.9 * Feet, 46 * Feet>}   
    #object{C scale <.2,10,.05> rotate <90,0,0> translate <21.3 * Feet, 25.9 * Feet, 46 * Feet>}   
    #object{E scale <.2,10,.05> rotate <90,0,0> translate <24 * Feet, 25.9 * Feet, 46 * Feet>}   
    #object{F scale <.2,10,.05> rotate <90,0,0> translate <26 * Feet, 25.9 * Feet, 46 * Feet>}   
    #object{G scale <.2,10,.05> rotate <90,0,0> translate <29.3 * Feet, 25.9 * Feet, 46 * Feet>}   
    #object{H scale <.2,10,.05> rotate <90,0,0> translate <31 * Feet, 25.9 * Feet, 46 * Feet>}   
    #object{I scale <.2,10,.05> rotate <90,0,0> translate <33.5 * Feet, 25.9 * Feet, 46 * Feet>}   
    #object{D scale <.2,10,.05> rotate <90,0,0> translate <37 * Feet, 25.9 * Feet, 46 * Feet>}   
    #object{J scale <.2,10,.05> rotate <90,0,0> translate <39.5 * Feet, 25.9 * Feet, 46 * Feet>}   
    #object{K scale <.2,10,.05> rotate <90,0,0> translate <42 * Feet, 25.9 * Feet, 46 * Feet>}   
    #object{L scale <.2,10,.05> rotate <90,0,0> translate <43.5 * Feet, 25.9 * Feet, 46 * Feet>}   
    #object{M scale <.2,10,.05> rotate <90,0,0> translate <49 * Feet, 25.9 * Feet, 46 * Feet>}   
    #object{N scale <.2,10,.05> rotate <90,0,0> translate <53 * Feet, 25.9 * Feet, 46 * Feet>}   
    #object{H scale <.2,10,.05> rotate <90,0,0> translate <57 * Feet, 25.9 * Feet, 46 * Feet>}   
    #object{L scale <.2,10,.05> rotate <90,0,0> translate <60 * Feet, 25.9 * Feet, 46 * Feet>}   
    #object{B scale <.2,10,.05> rotate <90,0,0> translate <65 * Feet, 25.9 * Feet, 46 * Feet>}   
    cutaway_textures
}  //difference
}  //object

 
  
//Roof1
#if (Roof)
    box{<-.5,-.5,-.5>,<.5,.5,.5>
       pigment{color Blue}
       scale <70 * Feet, 10 * Feet, 2 * Feet>
       translate<35 * Feet, 32 * Feet,45 * Feet>
       Rotate_Around_Trans(<-35,0,0>,<35 * Feet,32*Feet,45*Feet>)
    } 
#else
    #object{IsosfcRoof 
        scale <70 * Feet,10 * Feet,2 * Feet>          
        translate <35 * Feet, 32 * Feet, 45 * Feet>
        Rotate_Around_Trans(<-35,0,0>,<35 * Feet,32*Feet,45*Feet>)
        material{CeilingTex translate<rand(R1)*30 * Feet,rand(R1)*3 * Feet,rand(R1)*3 * Feet>}
    }
#end

//Roof2 

#if (Roof)
    box{<-.5,-.5,-.5>,<.5,.5,.5>
        pigment{color Red}
        scale <70 * Feet, 20 * Feet, 2 * Feet>
        translate<35 * Feet, 45.5 * Feet,42.4 * Feet>
    } 
#else
    #object{IsosfcRoof 
        scale <70 * Feet,20 * Feet,2 * Feet>
        translate <35 * Feet, 45.5 * Feet, 42.4 * Feet>
        material{CeilingTex translate<rand(R1)*30 * Feet,rand(R1)*3 * Feet,rand(R1)*3 * Feet>}
    }
#end

#include "pillars.inc"

//toomb 
#declare Toomb=
union{
   box{<-.5,-.5,-.5>,<.5,.5,.5>
       scale <13.1 * Feet, .2 * Feet, 7.1 * Feet>
       translate<30 * Feet, 0.9 * Feet,24.5 * Feet>
       texture{T_Stone14 scale .3}                 
   }
   box{<-.5,-.5,-.5>,<.5,.5,.5>
       scale <13 * Feet, .2 * Feet, 7 * Feet>
       translate<30 * Feet, 1.1 * Feet,24.5 * Feet>
       texture{T_Stone14 scale .3}                 
   }
   box{<-.5,-.5,-.5>,<.5,.5,.5>
       scale <12.9 * Feet, .2 * Feet, 6.9 * Feet>
       translate<30 * Feet, 1.3 * Feet,24.5 * Feet>
       texture{T_Stone14 scale .3}                 
   }
   box{<-.5,-.5,-.5>,<.5,.5,.5>
       scale <12.7 * Feet, .2 * Feet, 6.7 * Feet>
       translate<30 * Feet, 1.5 * Feet,24.5 * Feet>
       texture{T_Stone14 scale .3}                 
   }
   box{<-.5,-.5,-.5>,<.5,.5,.5>
       scale <12.5 * Feet, .2 * Feet, 6.5 * Feet>
       translate<30 * Feet, 1.7 * Feet,24.5 * Feet>
       texture{T_Stone14 scale .3}                 
   }
   box{<-.5,-.5,-.5>,<.5,.5,.5>
       scale <12.3 * Feet, .2 * Feet, 6.3 * Feet>
       translate<30 * Feet, 1.9 * Feet,24.5 * Feet>
       texture{T_Stone14 scale .3}                 
   }
   box{<-.5,-.5,-.5>,<.5,.5,.5>
       scale <12.1 * Feet, .2 * Feet, 6.1 * Feet>
       translate<30 * Feet, 2.0 * Feet,24.5 * Feet>
       texture{T_Stone14 scale .3}                 
   }
                 
#if (Toomb)
   box{<-.5,-.5,-.5>,<.5,.5,.5>
       pigment{color Green}
       scale <12 * Feet, 3 * Feet, 6 * Feet>
       translate<30 * Feet, 3 * Feet,24.5 * Feet>
   }
   box{<-.5,-.5,-.5>,<.5,.5,.5>
       pigment{color Red}
       scale <13 * Feet, 1 * Feet, 7 * Feet>
       translate<30 * Feet, 5 * Feet,24.5 * Feet>
   }
   box{<-.5,-.5,-.5>,<.5,.5,.5>
       pigment{color White}
       scale <12 * Feet, .2 * Feet, 6 * Feet>
       translate<29.8 * Feet, 5.6 * Feet,24.5 * Feet>
   } 
#else
  #object{IsosfcPillar2 
        scale <12 * Feet,3 * Feet,6 * Feet>
//        texture{T_Stone14 scale .2}                 
        material{BenchTex translate<rand(R1)*30 * Feet,rand(R1)*3 * Feet,rand(R1)*3 * Feet>}
        translate <30 * Feet, 3 * Feet, 24.5 * Feet>
  }
  #object{IsosfcPillar3 
        scale <13 * Feet,1 * Feet,7 * Feet>
        translate <30 * Feet, 5 * Feet, 24.5 * Feet>
//        texture{T_Stone14 scale .3}                 
        material{DoorTex translate<rand(R1)*30 * Feet,rand(R1)*3 * Feet,rand(R1)*3 * Feet>}
  }
  difference{
  #object{IsosfcPillar4 
        scale <12 * Feet,.5 * Feet,6 * Feet>
        texture{T_Stone19 scale .3}                 
        translate <29.8 * Feet, 5.6 * Feet, 24.5 * Feet>
  }

  #object{F scale <.07,.2,.02> rotate <180,-90,0> translate <25 * Feet, 5.7 * Feet, 21.9 * Feet>}
  #object{I scale <.07,.2,.02> rotate <180,-90,0> translate <25 * Feet, 5.7 * Feet, 23.0 * Feet>}
  #object{C scale <.07,.2,.02> rotate <180,-90,0> translate <25 * Feet, 5.7 * Feet, 24.6 * Feet>}
  #object{A scale <.07,.2,.02> rotate <180,-90,0> translate <25 * Feet, 5.7 * Feet, 25.5 * Feet>}
  #object{M scale <.07,.2,.02> rotate <180,-90,0> translate <25 * Feet, 5.7 * Feet, 26.6 * Feet>}

  #object{G scale <.07,.2,.02> rotate <180,-90,0> translate <28 * Feet, 5.7 * Feet, 22.3 * Feet>}
  #object{N scale <.07,.2,.02> rotate <180,-90,0> translate <28 * Feet, 5.7 * Feet, 23.4 * Feet>} 
  #object{E scale <.07,.2,.02> rotate <180,-90,0> translate <28 * Feet, 5.7 * Feet, 24.8 * Feet>}
  #object{A scale <.07,.2,.02> rotate <180,-90,0> translate <28 * Feet, 5.7 * Feet, 25.6 * Feet>}
  #object{M scale <.07,.2,.02> rotate <180,-90,0> translate <28 * Feet, 5.7 * Feet, 26.6 * Feet>}

  #object{N scale <.07,.2,.02> rotate <180,-90,0> translate <29.5 * Feet, 5.7 * Feet, 22.5 * Feet>}
  #object{B scale <.07,.2,.02> rotate <180,-90,0> translate <29.5 * Feet, 5.7 * Feet, 23.8 * Feet>}   
  #object{N scale <.07,.2,.02> rotate <180,-90,0> translate <29.5 * Feet, 5.7 * Feet, 25.2 * Feet>} 
  #object{C scale <.07,.2,.02> rotate <180,-90,0> translate <29.5 * Feet, 5.7 * Feet, 26.7 * Feet>}
                   
  #object{F scale <.07,.2,.02> rotate <180,-90,0> translate <31 * Feet, 5.7 * Feet, 22.0 * Feet>}
  #object{I scale <.07,.2,.02> rotate <180,-90,0> translate <31 * Feet, 5.7 * Feet, 23.0 * Feet>}   
  #object{J scale <.07,.2,.02> rotate <180,-90,0> translate <31 * Feet, 5.7 * Feet, 24.2 * Feet>} 
  #object{K scale <.07,.2,.02> rotate <180,-90,0> translate <31 * Feet, 5.7 * Feet, 25.3 * Feet>}
  #object{I scale <.07,.2,.02> rotate <180,-90,0> translate <31 * Feet, 5.7 * Feet, 26.3 * Feet>}
                  
  #object{C scale <.07,.2,.02> rotate <180,-90,0> translate <32.5 * Feet, 5.7 * Feet, 22.2 * Feet>}
  #object{I scale <.07,.2,.02> rotate <180,-90,0> translate <32.5 * Feet, 5.7 * Feet, 23.0 * Feet>}   
  #object{J scale <.07,.2,.02> rotate <180,-90,0> translate <32.5 * Feet, 5.7 * Feet, 24.2 * Feet>} 
  #object{J scale <.07,.2,.02> rotate <180,-90,0> translate <32.5 * Feet, 5.7 * Feet, 25.3 * Feet>}
  #object{L scale <.07,.2,.02> rotate <180,-90,0> translate <32.5 * Feet, 5.7 * Feet, 26.0 * Feet>}

  #object{H scale <.07,.2,.02> rotate <180,-90,0> translate <34 * Feet, 5.7 * Feet, 22.2 * Feet>}
  #object{N scale <.07,.2,.02> rotate <180,-90,0> translate <34 * Feet, 5.7 * Feet, 23.5 * Feet>}
  
cutaway_textures

}  //difference


#end 

                                      
}

#object{Toomb scale <.8,.7,.8> translate<4*Feet,0,4*Feet> } 


#if (Extra)


CobWeb1(30 , 0 ,20.3   ,4.5 ,3.5  , 2.2  ,11) //near toomb z was 20.5 and 2 
CobWeb1(28 ,6 ,53.4 ,15 , 19 ,  3 ,28) //total alcove 


#macro Trace_It (Start, Object, Offset)  
    #local Norm = <0, 0, 0>;
    #local Pos = trace (
                  Floor,     // object to test
                  Start,           // starting point
                  -y,              // direction
                  Norm );          // normal
    #if (vlength(Norm)!=0)   // if intersection is found, normal differs from 0
        object {
          Object
          translate Pos + <0,Offset,0>
        }
    #end 
#end


Trace_It(< 40 * Feet,
           50 * Feet,
           12 * Feet>,  //36
         #object{PillarMolding 
                 rotate<0,22,0>},
         -19 * Feet
) 


Trace_It(< 30 * Feet,
           50 * Feet,
           38 * Feet>, 
         #object{TopMolding
                 scale <3 * Feet, 2 * Feet, 5 * Feet>  
                 rotate<0,30,0>
                 material{BenchTex1 translate<rand(R1)*30 * Feet,rand(R1)*3 * Feet,rand(R1)*3 * Feet>}
                },

         0 * Feet 
) 

Trace_It(< 20 * Feet,
           50 * Feet,
           40 * Feet>, 
         #object{TopMolding
                 scale <3 * Feet, 1 * Feet, 5 * Feet>  
                 rotate<0,-30,0>
                 material{BenchTex1 translate<rand(R1)*30 * Feet,rand(R1)*3 * Feet,rand(R1)*3 * Feet>}
                },

         0 * Feet 
) 

Trace_It(< 26 * Feet,
           50 * Feet,
           14 * Feet>, 
         #object{TopMolding
                 scale <4 * Feet, 3 * Feet, 2 * Feet>  
                 rotate<0, 50,0>
                 material{BenchTex1 translate<rand(R1)*30 * Feet,rand(R1)*3 * Feet,rand(R1)*3 * Feet>}
                },
         0 * Feet 
) 


#declare N = 0;
#while (N < 60)
    Trace_It(< (0 + (rand(R1) * 70)) * Feet,
               25 * Feet,
               (0 + (rand(R1) * 50)) * Feet>, 
             #object{TopMolding
                     scale <(.35 + (rand(R1) * 2)) * Feet, 
                            (.1 + (rand(R1) * 2)) * Feet, 
                            (.35 + (rand(R1) * 2))  * Feet>  
                     rotate<0, rand(R1) * 180,0>
                     material{BenchTex1 translate<rand(R1)*30 * Feet,rand(R1)*3 * Feet,rand(R1)*3 * Feet>}
                     },
             0 * Feet
    )

    Trace_It(< (0 + (rand(R1) * 70)) * Feet,
               25 * Feet,
               (5 + (rand(R1) * 40)) * Feet>,
              #object{IsosfcPillar2
                     scale <(.28 + (rand(R1) * 1.5)) * Feet, 
                            (.1 + (rand(R1) * 1.5)) * Feet, 
                            (.28 + (rand(R1) * 1.5))  * Feet>  
                     rotate<0, rand(R1) * 180, 0>
                     material{DoorTex1 translate<rand(R1)*30 * Feet,rand(R1)*3 * Feet,rand(R1)*3 * Feet>}
              },
             0 * Feet 
    )
    
    #declare N1 = 0;
    #while (N1<10)
         Trace_It(< (0 + (rand(R1) * 70)) * Feet,
                    25 * Feet,
                    (5 + (rand(R1) * 40)) * Feet>,
                   superellipsoid {
                                   <rand(R1),  // east-west exponent (0.0 ... 1.0)
                                    rand(R1)>   // north-south exponent (0.0 ... 1.0)
                          scale <(.07+(.4 * rand(R1))) * Feet, 
                                 (.07+(.2 * rand(R1))) * Feet, 
                                 (.07+(.4 * rand(R1))) * Feet>  
                          rotate<0, rand(R1) * 180, 0>
                          material{FloorTex translate<rand(R1)*30 * Feet,rand(R1)*3 * Feet,rand(R1)*3 * Feet>}
                   },
                  0 * Feet 
         )
    #declare N1 = N1 + 1;
    #end

#declare N= N + 1;
#end 

#declare Spear =
#union{
        sphere_sweep {
                       linear_spline      
                       2,
                       <0, -3 * Feet, 0>, .25 * Feet        
                       <0,  3 * Feet, 0>, .25 * Feet        
                       material{SpearTex}
                     }
        cylinder {
                   -.5*y*Feet,  .5*y*Feet,  .26 * Feet
                   translate<0,3 * Feet, 0>
                   material{WeaponTex translate<rand(R1)*30 * Feet,rand(R1)*3 * Feet,rand(R1)*3 * Feet>}
                  }

        prism {                                
                linear_sweep  
                linear_spline 
                -0.2 * Feet,        
                 0.2 * Feet,         
                3,           // number of points
                <-.5,  -.5>, <.5,  -.5>, <0, .5>
                rotate<-90,0,0>
                scale <2 * Feet,3 * Feet,2 * Feet>      
                translate<0, 4.2* Feet, 0>
                material{WeaponTex translate<rand(R1)*30 * Feet,rand(R1)*3 * Feet,rand(R1)*3 * Feet>}
        }

}
#object{Spear 
        scale <.7,.7,.7>
        rotate<0,0,-30> 
        translate<39 * Feet, 14 * Feet, 55 * Feet> //z=53.5
}

#object{Spear
        scale <.7,.7,.7>
        rotate<0,-45,90> rotate<0,-20,0> 
        translate<38 * Feet, 7.1 * Feet, 49 * Feet> 
} 

#declare Axe =
#union{
        sphere_sweep {
                       linear_spline      
                       2,
                       <0, -3 * Feet, 0>, .25 * Feet        
                       <0,  3 * Feet, 0>, .25 * Feet        
                       material{SpearTex}
                     }
        cylinder {
                   -.5*y*Feet,  .5*y*Feet,  .26 * Feet
                   translate<0,3 * Feet, 0>
                   material{WeaponTex translate<rand(R1)*30 * Feet,rand(R1)*3 * Feet,rand(R1)*3 * Feet>}
                  }
        #difference{
        prism {                                
                linear_sweep  
                linear_spline 
                -0.2 * Feet,        
                 0.2 * Feet,         
                4,           // number of points
                <-.5,  -.5>, <.5,  .5>, <-.5, .5>,<.5,-.5>
                rotate<0,0,-90>
                scale <1.5 * Feet,3 * Feet,3 * Feet>      
                translate<0, 3.2* Feet, 0>
                material{WeaponTex translate<rand(R1)*30 * Feet,rand(R1)*3 * Feet,rand(R1)*3 * Feet>}
        }
        prism {                                
                linear_sweep  
                linear_spline 
                -0.4 * Feet,        
                 0.4 * Feet,         
                4,           // number of points
                <-.5,  -.5>, <.5,  .5>, <-.5, .5>,<.5,-.5>
                rotate<0,0,-90>
                scale <.8 * Feet,1 * Feet,2 * Feet>     
                translate<0, 3.2* Feet, 0>
        }
        }  //difference

}

Trace_It(< 17 * Feet,
           50 * Feet,
           30 * Feet>, 
         #object{Axe
                 scale <.7,.7,.7>
                 rotate<30,-3,-87> rotate<-8,0,0> },
         .5 * Feet 
)  

#declare Book=
union{

   cylinder {
              -.9*z,  .9*z,  .25 
              scale  1 * Feet  //<2 * Feet, .5 * Feet, 1.5 * Feet> 
              translate<-1.4 * Feet, 0 * Feet,0 * Feet>
              texture{
                       pigment{   gradient z
                               color_map{
                                 [0 Brown]
                                 [.3 Brown]
                                 [.3 Gray70]             
                                 [1 Gray70]
                                          } 
                       }   scale .1
              }          
   } 
   #union{
            #object{IsosfcPillar4 
                    scale <3 * Feet, .5 * Feet, 2 * Feet>
                    material{SpearTex scale .08}
             }    

            #object{I 
                    scale <.4,.35,.05>*Feet 
                    rotate <180,0,0> 
                    translate <-.3 * Feet, .1 * Feet, 0 * Feet>
                    pigment{color DarkBrown}
            }             
   }//union
} //union

#object{Book
        translate<24.5 * Feet, 1.7 * Feet,20.5 * Feet>
        Rotate_Around_Trans(<-60,0,0>,<24.5 * Feet,1.7*Feet,20.5*Feet>)
       }   

#end //extra

