// Making Debris with Fractals
// ***************************
// Lutz Essers [www.viadukt.de]
//
// The debris in the picture crescent.jpg (IRTC, decay) was made 
// with a julia_fractal by using low precision and high iteration 
// values. Both due to a real nice breakup of one element into  
// several hundred pieces per fractal. In the picture "crescent"
// I have placed several hundred fractals to get these 
// dustlike structures.
//
// Here you get the basic fractal with suitable prarameters
// to play with. In the text file crescent.txt you will find 
// more information about programing the picture.


#version 3.5
global_settings { assumed_gamma 2.2 number_of_waves 10 max_trace_level 35}

//***********************

camera {
  location  <0.0, 0.0, -5.0>
  look_at   <0.0, 0.0,  0.0>
  right     x*image_width/image_height
}


#declare PREC_Debris = 3; // precision
#declare ITER_Debris = 15; // max_iteration

julia_fractal {<-0.5, 0.5, -0.5, -0.4>    
      max_iteration ITER_Debris precision PREC_Debris quaternion sqr
      pigment {color rgb 1} finish {ambient 1}}

// Hints:
// - put multiple fractals close to each other to get more density
// - try also some textures to enhance the spotted appearance 
//    e.g. pigment{bozo color_map { [0 color rgb 1][0.5 color rgb 1][0.6 color rgb 0][1 color rgb 0]} turbulence 1}scale .1 }
//    maybe you have to use rgbf values