// Persistence of Vision Ray Tracer Scene Description File
// File: earth.pov
// Vers: 3.5
// Desc: Radiosity Scene Template
// Date: 23/09/2003
// Auth: Jean-Charles Marteau
//       IRTC - October 2003 - Decay
//
// Sources for image maps : http://gw.marketingden.com/planets/planets.html

#version 3.5;

#declare With_Iso=off;
#declare With_Cut=on;
#declare With_Clouds=off;
#declare With_Cigarette=on;

#include "functions.inc"

global_settings {
  assumed_gamma 1.0
}

#default {
  texture {
    pigment {rgb 1}
    finish {
      ambient 0.1
      diffuse 0.6
    }
  }
}

// ----------------------------------------

#local Cam_Pos=<0,1.5,-4>;
#local Target_Pos=<0,1,0>;

camera {
  right x*image_width/image_height
  location  Cam_Pos
  look_at   Target_Pos
  angle 47
}

light_source {
  0*x
  color rgb 1.0
  area_light
  <8, 0, 0> <0, 0, 8>
  4, 4
  adaptive 1
  jitter
  circular
  orient
  translate <30, 50, -40>
}

// ----------------------------------------

sphere {
  <0,1000,0>, 1000
  hollow
  texture {
    pigment { rgb 4.0 }
    finish {
      ambient 0.05
      diffuse 1.0
    }
  }
}

#declare P_Earth_Map=pigment {
  image_map {
    jpeg "earthmap1k.jpg"
    map_type 1
    interpolate 4
  }      
}

#declare P_Clouds_Map=pigment {
  image_map {
    png "earthcloudmaptr.png"
    map_type 1
    interpolate 4
  }      
}

#declare P_Earth_Bumps=pigment {
  image_map {
    jpeg "earthbump1k.jpg"
    map_type 1
    interpolate 4
  }      
}

#declare F_Earth_Bumps=function { pigment { P_Earth_Bumps } };

#local Max_height=0.007;

#declare T_Earth_Finished=texture {
  material_map {
    png "earthspec1k.png"
    map_type 1
    interpolate 4
    texture {
      pigment { P_Earth_Map }
      finish {
	ambient 0.1
	phong 0.0
      }
    }
    texture {
      pigment { P_Earth_Map }
      finish {
	ambient 0.04
	phong 0.2
	phong_size 4
      }
    }
  }
}

// ----------------------------------------
// texture evoluee du centre de la terre
#declare T_Earth_Core=texture {
  pigment {
    dents
    turbulence 5.0
    color_map
    {
      [0.0 rgb <1.0, 0.4, 0.1>]
      [1.0 rgb <1.0, 0.8, 0.2>]
    }
  }
  finish { 
    ambient 1.0
    reflection { 0.1 metallic 0.3 }
  }
  scale 0.02
}

#declare T_Earth_Lava=texture {
  pigment { rgb <1.0, 0.3, 0.1> }
  finish { ambient 0.8 }
}

#declare T_Earth_Rock=texture {
  pigment {
    dents
    turbulence 0.2
    color_map {
      [0.0 rgb <0.2,0.1,0.05>]
      [1.0 rgb <0.4,0.3,0.05>]
    }
  }
  normal { granite scale 0.08 }
  scale 0.01
}

#local lim=0.04;
#declare T_Earth_Inside=texture {
  crackle
  turbulence 0.1
  texture_map {
    [0.0 T_Earth_Lava]
    [lim*0.95 T_Earth_Lava]
    [lim*1.05 T_Earth_Rock]
    [1.0 T_Earth_Rock]
  }
  scale 0.02
}

// Limite du noyau
#local limn=0.2;
#local limm=0.6;
#local liml=0.85;
#local limc=0.98;

#declare T_Earth_Full_Texture=texture {
  onion
  texture_map {
    [0.0 T_Earth_Core]
    [limn*0.9 T_Earth_Core]
    [limn*1.2 T_Earth_Inside]
    [limm T_Earth_Inside]
    [liml T_Earth_Rock]
    [limc T_Earth_Rock]
    [(limc+1.0)/2 T_Earth_Finished]
    [1.0 T_Earth_Finished]
  }
  scale 1.0+Max_height*1.01
}

// ----------------------------------------
#declare Earth=union {
  #if (With_Iso)
    isosurface {
      function { f_sphere (x,y,z,1) - F_Earth_Bumps (x,y,z).grey*Max_height }
      contained_by { box { -1.2, 1.2 } }
      accuracy 0.001
      max_gradient 4
      all_intersections
    }
  #else
    sphere {
      0, 1
    }
  #end
}

#declare Clouds=sphere {
  0, 1.0+Max_height*1.2
  hollow
  texture { P_Clouds_Map }
}

#declare Cut_box=isosurface {
  function { f_sphere (x, y, z, 0.7) + f_granite (x, y, z)/8 }
  contained_by { sphere { 0, 1 } }
  accuracy 0.001
  max_gradient 8
  all_intersections
  translate <0.3,0.5,-0.5>
  rotate 175*y
}
#declare Cut_box_Trans=isosurface {
  function { f_sphere (x, y, z, 0.7) + f_granite (x, y, z)/8 }
  contained_by { sphere { 0, 1 } }
  accuracy 0.001
  max_gradient 8
  //all_intersections
  translate <0.3,0.5,-0.5>
  rotate 175*y
}


#declare Final_Position=transform { rotate <20, 200, 0> translate <0,1,0> }

/*
#if (With_Cut)
  difference {
    object { Earth }
    object { Cut_box }
    texture { T_Earth_Full_Texture }
    transform { Final_Position }
  }
  #if (With_Clouds)
    difference {
      object { Clouds }
      object { Cut_box_Trans
	pigment { rgbt 1 }
      }
      transform { Final_Position }
    }
  #end
#else
  object { Earth
    texture { T_Earth_Full_Texture }
    transform { Final_Position }
  }
  #if (With_Clouds)
    object { Clouds
      transform { Final_Position }
    }
  #end
#end
*/

// ----------------------------------------
// Textures pour la cigarette
#declare T_Butt_Paper=texture {
  pigment 
  { 
    bozo
    turbulence 0.5
    color_map
    {
      [0.1 color rgb <1, .5, 0>*0.8 ]
      [0.6 color rgb <1, .5, 0>*0.8 ]
      [0.7 color rgb <1, 0.8, 0> ]
      [1.0 color rgb <1, 0.8, 0> ]
    }
    scale 0.015
  }
}

#declare T_Filter=texture { pigment { rgb 1.0 } }

#declare T_Butt=texture {
  cylindrical
  texture_map {
    [0.0 T_Butt_Paper scale 1/0.05]
    [0.01 T_Butt_Paper scale 1/0.05]
    [0.01 T_Filter]
    [1.0 T_Filter]
  }
  rotate 90*z
  scale 0.05
}

#declare T_Body=texture {
  pigment {
    gradient x
    triangle_wave
    color_map {
      [0.0 rgb 1.0]
      [1.0 rgb 0.9]
    }
    scale 0.008
  }
  finish {
    phong 0
  }
}

#local Ash_Level=0.03;
#declare T_Ash=texture {
  pigment {
    crackle
    color_map {
      [0.00 rgbt <0,0,0,1> ]
      [Ash_Level*0.9 rgbt <0,0,0,1> ]
      [Ash_Level*1.1 rgb 0.5 ]
      [0.70 rgbt 0.0 ]
      [1.00 rgbt 0.0 ]
    }   
  }
  scale <0.1,1,1>*0.03
}

#local P_Local_Separation=pigment {
  gradient x
  turbulence 0.03
  octaves 5.0
  color_map {
    [0.00 rgb 0.0]
    [0.84 rgb 0.0]
    [0.86 rgb 1.0]
    [1.00 rgb 1.0]    
  }
  scale <1.0,0.06,0.06>
  // Pour eviter les problemes de debordement lies a la turbulence
  translate <0.01,0,0>
}

#declare T_Body_Ash=texture {
  pigment_pattern { P_Local_Separation }
  texture_map {
    [0.0 T_Body]
    [0.85 T_Body]
    [0.86 T_Ash]
    [1.0 T_Ash]    
  }
}


#declare T_Cigarette=texture {
  gradient x
  texture_map {
    [0.0 T_Butt]
    [0.3 T_Butt]
    [0.3 T_Body_Ash]
    [1.0 T_Body_Ash]
  }
  translate <0.5,0,0>  
}

#local Lit_Cigarette=off;
// Cigarette
#local cigarette = union {
  cylinder
  {
    <-4.999, 0, 0>, <4.999, 0, 0>, 0.5
    texture { T_Cigarette scale 10 }
  }
  cylinder
  {
    <0, 0, 0>, <4.9, 0, 0>, 0.49
    texture {
      #if (Lit_Cigarette)
        pigment { rgb <1,0,0>/2 }
        finish { ambient 1.0 }
      #else
        pigment { rgb 0.2 }
      #end
    }
  }  
}

#if (With_Cigarette)
  object {
    cigarette
    rotate <0,210,20>
    scale 0.14
    translate <0.4,0.95,-0.8>
  }
#end
