// Persistence of Vision Ray Tracer Scene Description File
// File: forget.pov
// Vers: 3.5
// Desc: IRTC 2003/09 competition (Decay)
// Date: 2003/10/15
// Auth: Slawomir Szczyrba
//
#version 3.5;

#include "colors.inc"
#include "metals.inc"
#include "textures.inc"
#include "stones1.inc"
#include "lazik.inc"
#include "skies.inc"
#include "forget.inc"
#include "rad_def.inc"

global_settings {
 radiosity { Rad_Settings(Radiosity_OutdoorLQ, true, true) brightness .3}
 assumed_gamma 1.0
}

// ----------------------------------------

light_source {
  <200, 500, -50>
  color rgb <1, 1, 1>
  parallel
  point_at <0,0,0>
  photons { reflection on refraction off }
}
  

 #declare XMAX=-36;
 #declare YMAX=36.167;
 #declare ZMAX=80; //66 76

#local Cam=<XMAX,YMAX+.1,ZMAX>;
#debug concat("Cam:   <",str(Cam.x,3,2),",",str(Cam.y,3,2),",",str(Cam.z,3,2),">\n")

object { lazik scale 2 rotate <17,0,18> rotate -y*120 translate Cam+<12,-2.6,-2>}
object { Moon  translate y*.8}
object { Earth translate <400,40,130> no_shadow }

camera {      
//orthographic          
  location  <0,0,0>
  right     x*image_width/image_height
  look_at   <1, 0, 0>
  rotate -y*1
  translate Cam+z
  translate <-30,0.8,0>
  angle 29
}

