// Persistence of Vision Ray Tracer Include File
// File: lazik.inc
// Vers: 3.5
// Desc: IRTC 2003/09 competition (Decay)
// Date: 2003/09/21
// Auth: Slawomir Szczyrba
//

#include "functions.inc"
#include "kolo.inc"
#include "kabina1.inc"

#macro pile (v1,v2,r)
union {
 sphere { v1,r }
 sphere { v2,r }
 cylinder { v1,v2,r }
} 
#end
 
#declare T_Metalic = texture {
 pigment { color rgb .4 }
 finish { phong 1.8 phong_size 8 }
}

#local MapDiv=.05;
#declare T_rury =
 texture { 
  pigment {
   granite
   turbulence 0.4
   pigment_map {
    [0 rgb <1,.4,0>][1 rgb <.8,.5,0>]
   }
   scale .5
  }   
//  finish { phong 1 phong_size 20 ambient .35}
  finish { phong 1 phong_size 20 ambient 0 diffuse 2.5}
 }
 texture {
  pigment {
   agate agate_turb .7
   pigment_map {[0 rgb <1,.1,0>*.5][MapDiv rgb <1,.1,0>*.5][MapDiv rgb 0 transmit 1][1 rgb 0 transmit 1]}
   scale .5
  } 
  finish { ambient 0 }
  normal { bumps -.3 scale .00001 }
 }

#declare T_ButlaA = texture {
 pigment {
  granite
  pigment_map{ [0 rgb <.15,1,.15>][.5 rgb <.15,1,.15>][1 rgb 0]} 
  scale <.1,1,.1>
 }
 finish {phong .5 phong_size 5 ambient .07 reflection .07 diffuse 2 brilliance .9}
}

#declare T_ButlaH2 =
 texture { pigment { 
  gradient y 
  scale y*2
  turbulence .0003
  omega 1.8    
  lambda 2
  pigment_map {
   [0    color rgb 1      ]
   [0.37 color rgb 1      ]
   [0.37 color rgb <1,.3,.3>]
   [0.43 color rgb <1,.3,.3>]
   [0.43 color rgb 1      ]
   [1    color rgb 1      ]
  }   
 }  normal{ granite scale .1 bump_size .2 }  finish { ambient 0 reflection .05 } }
 texture {
  pigment {
   function { f_mesh1(x,y,z,.4,.4,1,.3,1) }
   turbulence 0.4
   omega 1   
   lambda 2   
   frequency 1 
   pigment_map {
    [0 rgbt 1]
    [.8 rgbt <0,.2,0,.7>]
    [.9 rgbt <.3,.1,.3,.8>]
    [1 rgbt <0,0,0,0>]
   }    
   scale 1
  }
  finish {phong .5 phong_size 5 ambient .3 reflection .1}
 }

#declare T_ButlaO2 =
 texture { pigment { 
  gradient y 
  scale y*2
  turbulence .0005
  omega 1.8    
  lambda 2
  pigment_map {
   [0    color rgb 1      ]
   [0.22 color rgb 1      ]
   [0.22 color rgb <.3,.3,1>]
   [0.28 color rgb <.3,.3,1>]
   [0.28 color rgb 1      ]
   [1    color rgb 1      ]
  }   
 }  normal{ granite scale .1 bump_size .2 } finish{reflection .06 }}
 texture {
  pigment {
   function { f_mesh1(x,y,z,.4,.4,1,.3,1) }
   turbulence 0.4
   omega 1   
   lambda 2   
   frequency 1 
   pigment_map {
    [0 rgbt 1]
    [.8 rgbt <0,.2,0,.7>]
    [.9 rgbt <.3,.1,.3,.8>]
    [1 rgbt <0,0,0,0>]
   }    
   scale 1
  }
  finish {phong .5 phong_size 5 ambient .3 reflection .1}
 }

#declare T_radio =
 texture { pigment { 
  gradient y 
  scale y*2
  turbulence .0005
  omega 1.8    
  lambda 2
  pigment_map {
   [0    color rgb .5 ]
   [0.43 color rgb 1  ]
   [1    color rgb 1  ]
  }   
 }  normal{ granite scale .1 bump_size .2 }  finish { ambient .1 reflection .07 } }
 texture {
  pigment {
   function { f_mesh1(x,y,z,.4,.4,1,.3,1) }
   turbulence 0.4
   omega 1   
   lambda 2   
   frequency 1 
   pigment_map {
    [0 rgbt 1]
    [.8 rgbt <0,.2,0,.7>]
    [.9 rgbt <.3,.1,.3,.8>]
    [1 rgbt <0,0,0,0>]
   }    
   scale 1
  }
  finish {phong .5 phong_size 5 ambient .3 reflection 0}
  translate -y*.6
 }

#declare T_guma = texture {
 pigment { rgb .18 }
 finish { phong 0.05 phong_size 1 ambient .3}
 normal { bumps -.3 scale .00001 }
}

#declare T_kabina =  texture {
 pigment { 
  gradient y 
  scale y*1.4
  translate y*.15
  pigment_map {
   [0    color Silver]
   [0.4  color Silver]
   [1    color rgb <1,.8,0>]
  }   
 }  
// normal{ granite scale .1 bump_size .2 }
 finish { ambient 0 diffuse 1 reflection {.7 metallic} /*brilliance .2*/ conserve_energy metallic} 
 rotate -x*30
}

#declare most = union {
 object { kolo translate <-1,0,-1>}
 object { kolo translate < 1,0,-1>}
 object { kolo translate <-1,0, 1>}
 object { kolo translate < 1,0, 1>}
 union {
  cylinder { -x   ,x   ,.05 translate < 0,0,1>}
  cylinder { -x*.3,x*.3,.1  translate < 0,0,1>}
  sphere   { 0, .1 translate < .3,0,1> }
  sphere   { 0, .1 translate <-.3,0,1> }
  cylinder { -x    ,x    ,.05 translate < 0,0,-1> }
  cylinder { -x*.15,x*.15,.1  translate < 0,0,-1> }
  sphere   { 0, .1 translate < .15,0,-1> }
  sphere   { 0, .1 translate <-.15,0,-1> }
  
  superellipsoid { <1,.4> rotate y*90 scale .1 translate < .4,0,-1>}
  superellipsoid { <1,.4> rotate y*90 scale .1 translate <-.4,0,-1>}
  
  cylinder { -z    ,z    ,.1  translate < 0,0,0> }
  texture{T_Metalic}
 } 
}

#declare rury = union {
sphere_sweep {
 linear_spline
 19
 <   0,.1, -1.2>,.05,
 < -.2,.1, -1.2>,.05,
 < -.4,.1, -1>,.05,
 < -.4,0, -.4>,.05,
 <-1.0,0, -.4>,.05,
 <-1.2,0, -.3>,.05,
 <-1.2,0,  .3>,.05,
 < -.4,.1, .4>,.05,
 < -.4,.1,1.5>,.05,
 <   0,.1,1.7>,.05,
 <  .4,.1,1.5>,.05, 
 <  .4,.1, .4>,.05,
 < 1.2,0,  .3>,.05,
 < 1.2,0, -.3>,.05,
 < 1.0,0, -.4>,.05,
 <  .4,0, -.4>,.05,
 <  .4,.1, -1>,.05,
 <  .2,.1,-1.2>,.05,
 <   0,.1, -1.2>,.05
} 
sphere_sweep {
 linear_spline
 16
 <   0,.1, -1.15>,.05,
 < -.2,.1, -1.15>,.05,
 < -.4,.1, -1>,.05,
 < -.4,0, -.4>,.05,
 <-.8,0, -.4>,.05,
 <-1,0, -.3>,.05,
 <-1,0,  .3>,.05,
 < -.4,.1, .4>,.05,
 <  .4,.1, .4>,.05,
 < 1,0,  .3>,.05,
 < 1,0, -.3>,.05,
 < .8,0, -.4>,.05,
 <  .4,0, -.4>,.05,
 <  .4,.1, -1>,.05,
 <  .2,.1,-1.15>,.05,
 <   0,.1, -1.15>,.05
 translate y*.1
}
sphere_sweep {
 linear_spline
 7
 < -.4,.2, .8>,.05,
 < -.4,.9, .8>,.05,
 < -.3,1.0,.8>,.05,
 <   0,1.2, .8>,.05,
 <  .3,1.0,.8>,.05,
 <  .4,.9, .8>,.05,
 <  .4,.2, .8>,.05
}
 sphere_sweep {
  linear_spline
  10
  < 0,.1,1.7>,.05,
  < 0,1.2,.8>,.05,
  < 0,1.4,.7>,.05,
  < 0,1.65,.2>,.05,
  < 0,1.75,-.2>,.05,
  < 0,1.7,-.4>,.05,
  < 0,1.4,-.75>,.05,
  < 0,.9,-1.15>,.05,
  < 0,.5,-1.3>,.05,
  < 0,.1,-1.25>,.05
 }
 sphere_sweep {
  linear_spline
  11
  <-.8, 0, -.4>,.05,
  <-.82,.5, -.4>,.05,
  <-.7, .9,-.4>,.05,
  <-.4,1.4,-.4>,.05,
  <-.15,1.7,-.4>,.05,
  <  0,1.7,-.4>,.05,
  < .15,1.7,-.4>,.05,
  < .4,1.4,-.4>,.05,
  < .7, .9,-.4>,.05,
  < .82,.5, -.4>,.05,
  < .8, 0, -.4>,.05
 } 
}

#declare kabina = object {
  kabina1 
  scale .3 
  rotate y*90 
  translate <0,.25,-.8>
}

#declare ladunek = union {
//butla z powietrzem
 object { pile(y*.2,y*1, .2) translate < .25,.1,1.1> texture { T_ButlaA}}
// butla z wodorem
 object { pile(y*.2,y*1, .2) translate <-.25,.1,1.1> texture { T_ButlaH2}}
//butla z tlenem 
 object { pile(y*.2,y*.5,.2) translate < .25,.15,1.5> texture { T_ButlaO2}}
//obejmy
 union {
  cylinder { 0,y*.1,.21 translate < .25,.3,1.1> }
  cylinder { 0,y*.1,.21 translate < .25,.3,1.5> }
  cylinder { 0,y*.1,.21 translate < .25,.6,1.1> }
  cylinder { 0,y*.1,.21 translate < .25,.6,1.5> }
  cylinder { 0,y*.1,.21 translate <-.25,.3,1.1> }
  cylinder { 0,y*.1,.21 translate <-.25,.6,1.1> }
  cylinder { 0,y*.1,.21 translate < .25,.9,1.1> }
  cylinder { 0,y*.1,.21 translate <-.25,.9,1.1> }
  box {<-.105,0,-.2>,<.105,.1,.2> translate < .25,.6,1.5> } 
  box {<-.105,0,-.2>,<.105,.1,.2> translate < .25,.3,1.5> } 
  box {<-.105,0,-.2>,<.105,.1,.2> translate <-.25,.3,1.1> } 
  box {<-.105,0,-.2>,<.105,.1,.2> translate <-.25,.6,1.1> } 
  box {<-.105,0,-.45>,<.105,.1,.45> rotate y*90 translate <0,.9,1.1> } 
  box { -1,1 scale <1,1,.15>*.16 translate <-.2,.3,1.47>}
  texture {T_rury scale <1,.4,1>}
 } 
 
//radio
 superellipsoid { <.2,.2> scale .15 translate <-.2,.3,1.5> texture { T_radio }}
//uchwyt anteny
 superellipsoid { <.2,.2> scale .05 translate <-.13,.42,1.63> texture{T_guma}}
 superellipsoid { <.2,.2> scale .05 translate <-.27,.42,1.63> texture{T_guma}}
//anteny 
 cylinder { 0, 2*y, .005 translate <-.14,.42,1.63> finish{ ambient .6}pigment { color rgb <0,1,.50> } texture{T_Silver_3B}}
 cylinder { 0, 2*y, .005 translate <-.26,.42,1.63> finish{ ambient .6}pigment { color rgb <0,1,.50> } texture{T_Silver_3B}}
}

#declare lazik =  union {
 object { ladunek pigment { color rgb <0,1,0> } finish { ambient .1 } }
 object { rury    texture { T_rury } }
 object { kabina  texture { T_kabina} photons { target reflection on refraction off }}  
 object { most }
}