// A long rune covered sword.
// Loosely based on StormBringer
// By Gail Shaw

#include "colors.inc"
#include "shapes.inc"
#include "shapes2.inc"

//***************Start textures**********************

#declare Brushed =
 texture {
  pigment {
   bozo
   turbulence 1.0  omega 1.0
   color_map {
     [0.00 color rgb<0.698, 0.698, 0.698>]
     [1.00 color rgb<1.000, 1.000, 1.000>]
   }
   scale <30.0, 1.0, 50.0>
 }
 finish {
   ambient 0.15
   diffuse 0.65
   brilliance 1.5
   specular 0.5    roughness 0.03
   reflection 0.1
  }
}

#declare Leather1 = texture {
    pigment {
        color VeryDarkBrown*0.6
    }
    finish {
        ambient < 0.200, 0.200, 0.200 >
        diffuse 0.50
        brilliance 1.00
        phong 0.20
        phong_size 50.00
        crand 0.100
    }
 }

//*****************End textures *********************

#declare Blade=
 difference {
  union {
   box {
    <-0.3,-6,-0.3>,<0.3,5,0.3>
   }
   object {
    Pyramid2
    rotate <0,0,180>
    scale <0.23,1,0.23>
    translate <0,-7,0>
   }
   rotate y*45
   scale <1,1,0.1>
  }
  union {
   box {
    <-0.1,-6,-0.1>,<0.1,5,0.1>
    rotate y*90
    scale <2,1,1>
    translate z*0.136
   }
   box {
    <-0.1,-6,-0.1>,<0.1,5,0.1>
    rotate y*90
    scale <2,1,1>
    translate z*-0.136
   }
  }
  texture {Brushed
           rotate <0,0,90>
          }
 }

#declare RuneBlade=
 union {
  object {Blade scale <1,1.2,1> translate y*-0.96}
  difference {
   box {
    <-0.9,4.82,-0.9>,<0.9,4,0.9>
    rotate y*45
    scale <1,1,0.04>
   }
   union {
    cone {
     <-1.6,3.68,-0.08>,1.37,<-1.6,3.68,0.0>,1.17
    }
    cone {
     <1.6,3.68,-0.08>,1.37,<1.6,3.68,0.01>,1.17
    }
    cone {
     <-1.6,3.68,0.08>,1.37,<-1.6,3.68,-0.01>,1.17
    }
    cone {
     <1.6,3.68,0.08>,1.37,<1.6,3.68,-0.01>,1.17
    }
   }
  }
  texture {Brushed
           rotate <0,0,90>
          }
 }

#declare Runes=
 union {
  union {   // Rune 1 = ???
   cylinder {
    <-0.12,3.95,0>,<-0.12,3.25,0>,0.04
   }
   cylinder {
    <-0.12,3.85,0>,<0.24,3.7,0>,0.04
   }
   cylinder {
    <-0.12,3.55,0>,<0.24,3.7,0>,0.04
   }
   scale <1,1,0.25>
  }
  union { // Rune 2 =
   cylinder {
    <-0.18,3.1,0>,<-0.18,2.4,0>,0.04
   }
   cylinder {
    <-0.18,3.1,0>,<0,2.9,0>,0.04
   }
   cylinder {
    <0,2.9,0>,<0.18,3.1,0>,0.04
   }
   cylinder {
    <-0.18,2.4,0>,<0,2.6,0>,0.04
   }
   cylinder {
    <0,2.6,0>,<0.18,2.4,0>,0.04
   }
   scale <1,1,0.25>
  }
  union { // Rune 3 =
   cylinder {
    <0,2.25,0>,<0,1.55,0>,0.04
   }
   cylinder {
    <-0.18,2.25,0>,<0,1.8,0>,0.04
   }
   cylinder {
    <0.18,2.25,0>,<0,1.8,0>,0.04
   }
   scale <1,1,0.25>
  }
  union {
   cylinder {
    <0,1.4,0>,<0,0.7,0>,0.04
   }
   cylinder {
    <0,1.4,0>,<-0.18,1,0>,0.04
   }
   cylinder {
    <0,1.4,0>,<0.18,1,0>,0.04
   }
   scale <1,1,0.25>
  }
  translate z*-0.03
 }

#declare RuneSword=
  union {
   difference {
    object {RuneBlade}
    object {Runes
            pigment { rgb <0.5,0,0> }
            finish {ambient 0.4
                    diffuse 0.2
                    reflection 0.2
                    specular 0.7
                    roughness 0.002
                    metallic
                   }
           }
   }
   cone {
    <-0.1,0,0>,0.1,<3.5,0,0>,0.03
    scale <1,2.5,1>
    rotate z*-25
    pigment {rgb <0.5,0,0>}
    finish {
     reflection 0.8
     ambient 0.1
     diffuse 0.8
     specular 0.9
     roughness 0.002
     metallic
    }
    translate y*5.2
   }
   sphere {
    <3.5,0,0>,0.25
    rotate z*-25
    pigment {rgb <0.5,0,0>}
    finish {
     reflection 0.8
     ambient 0.1
     diffuse 0.8
     specular 0.9
     roughness 0.002
     metallic
    }
    translate y*5.2
   }
   cone {
    <-0.1,0,0>,0.1,<3.5,0,0>,0.03
    scale <1,2.5,1>
    rotate z*-25
    pigment {rgb <0.5,0,0>}
    finish {
     reflection 0.8
     ambient 0
     diffuse 0.8
     specular 0.9
     roughness 0.0002
     metallic
    }
    translate y*5.2
    scale <-1,1,1>
   }
   sphere {
    <-3.5,0,0>,0.25
    rotate z*25
    pigment {rgb <0.5,0,0>}
    finish {
     reflection 0.8
     ambient 0.1
     diffuse 0.8
     specular 0.9
     roughness 0.002
     metallic
    }
    translate y*5.2
   }
   sphere {
    <0,0,0>,0.3
    scale <1.7,1.5,1>
    pigment {rgb <0.5,0,0>}
    finish {
     reflection 0.8
     ambient 0.1
     diffuse 0.8
     specular 0.9
     roughness 0.002
     metallic
    }
    translate y*5.1
   }
   cylinder {
    <0,5,0>,<0,8.5,0>,0.35
    scale <1,1,0.8>
    texture {
     pigment {rgb <0.5,0,0>}
     finish {
      reflection 0.8
      ambient 0.1
      diffuse 0.8
      specular 0.9
      roughness 0.002
      metallic
     }
    }
   }
   cylinder {
    <0,5,0>,<0,8.5,0>,0.36
    scale <1,1,0.8>
    texture {
     gradient < 1, 1, 0 >
     texture_map {
      [0.00, Leather1]
      [0.35, Leather1]
      [0.35, pigment {Clear}]
      [0.50, pigment {Clear}]
      [0.50, Leather1]
      [0.85, Leather1]
      [0.85, pigment {Clear}]
      [1.00, pigment {Clear}]
     }
     translate x*1
    }
   }
   sphere {
    <0,0,0>,0.7
    scale <1,0.7,0.6>
    translate y*8.7
    pigment {rgb <0.5,0,0>}
    finish {
     reflection 0.8
     ambient 0.1
     diffuse 0.8
     specular 0.9
     roughness 0.002
     metallic
    }
   }
  }

// uncomment below to render an image of the sword.
/*
camera {
 location <0,0,-20>
 look_at <0,0,0>
}

light_source {
 <10,4,-20>
 White
}

object { RuneSword }

plane {
 z,-130
 pigment {White}
}
*/
