// Persistence of Vision Ray Tracer Scene Description File
// File: worms.pov
// Vers: 3.5
// Desc: Radiosity Scene Template
// Date: 14/09/2003
// Auth: Jean-Charles Marteau
//       IRTC - October 2003 - Decay

#version 3.5;

#declare Ground_Qual=3;
#declare Vase_Qual=3;
#declare With_Blur=on;
#declare With_Hand=off;
#declare With_Worms=on;
#declare With_Squelette=off;
#declare With_Sword=on;

#include "functions.inc"
#include "shapes.inc"

#include "golds.inc"
#include "metals.inc"

#include "lighting.inc"

global_settings {
  assumed_gamma 1.0
  //max_trace_level 25
}

#default {
  texture {
    pigment {rgb 1}
    finish {
      ambient 0.0
      diffuse 0.6
      specular 0.3
    }
  }
}

// ----------------------------------------
#local Cam_Pos=<0.4,4.5,-7.5>*4;
#local Target_Pos=<-3,4,0>;

camera {
  right x*image_width/image_height
  location  Cam_Pos
  look_at   Target_Pos
  #if (With_Blur)
    #include "DoF.inc"
    DoF(Cam_Pos, 300, 30, Target_Pos, <0, 6.5, 6>, <0, 6.5, -5>)
    blur_samples 30
    confidence 0.97
    variance 1/300
  #end
  angle 30
}

Photo_3Lights (Cam_Pos, Target_Pos, 45, -15, 115, <1,1,1>*0.8, 3, 2, 6)

// ----------------------------------------
#local T_Pig_Dalle=pigment { 
  agate
  turbulence 0.1
  color_map {
    [0.0 rgb <0.9,0.9,0.7>]
    [0.9 rgb <0.9,0.9,0.7>]
    [1.0 rgb <0.9,0.9,0.7>*0.7]
  }
  scale 0.02
}

#local largeur = 4;
#local ecart = 0.02;
#local arrondi= 0.1;
#declare Dalle=object {
  Round_Box_Merge(<-largeur+ecart,-0.5,-largeur+ecart>, <largeur-ecart,0,largeur-ecart>, arrondi)
  texture {
    pigment { T_Pig_Dalle }
    finish {
      ambient 0
      specular 0
    }
    normal { granite 0.1 scale 0.3 }
  }
}

#declare F_Dalle = function { f_rounded_box ( x, y, z, arrondi, (largeur-ecart), 0.25, (largeur-ecart)) };

#local P_Fissure=pigment {
  gradient x
  turbulence 0.1
  octaves 7
  triangle_wave
  color_map {
    [0.000  rgb 1.0]
    [0.005 rgb 0.8]
    [0.010 rgb 0.0]
    [1.000  rgb 0.0]
  }              
  scale <10,10,3>
  translate <0.7,0,0>
  rotate <0,23,0>
}

#declare F_Fissure=function{ pigment { P_Fissure } }

#local GS = seed(1);

#if (Ground_Qual > 0)
  #local i = -3;
  #while (i < 2)
    #local j = -1;
    #while (j < 4)
      #if ((Ground_Qual > 1) & (abs (i) <= 0) & (abs (j) <= 0))
	isosurface {
	  function { F_Dalle (x,y,z)
	    #if (Ground_Qual > 2)
	    - f_granite (x/0.3,y/0.3,z/0.3)/240
	    + F_Fissure (x,y,z).grey/4
	    #end
	  }
	  contained_by { box { <-largeur,-0.3,-largeur>*2, <largeur,0.3,largeur>*2 } }
	  accuracy 0.001
	  max_gradient 4
	  texture {
	    pigment { T_Pig_Dalle }
	    finish {
	      ambient 0
	      specular 0
	    }
	  }
	  rotate <rand(GS)-0.5,0,rand(GS)-0.5> * 1
	  translate <i,0,j>*2*largeur+<0,-0.25,0>
	}
      #else
	object {
	  Dalle
	  rotate <rand(GS)-0.5,0,rand(GS)-0.5> * 1
	  translate <i,0,j>*2*largeur
	}
      #end
      #local j = j + 1;
    #end
    #local i = i + 1;
  #end
#else
  plane {
    y, -0.001
    texture {
      pigment {
        dents
        turbulence 0.2
        color_map {
	  [0.0 rgb <0.1,0.15,0.2>]
	  [1.0 rgb 0.5]
        }
      }
      scale <2,0.2,0.2>
    }
  }
#end

// ----------------------------------------
#declare T_Agate=texture {
  pigment {
    agate
    color_map {
      [0.0 rgb 0.4]
      [1.0 rgb <1.0,0.7,0.5>]
    }
  }
  finish {
    phong 0.1
  }
  scale 1/3
}

// Equations definissant le vase
#local Ray_Angle=45;

#local R=22/((2*pi)*cos(radians(Ray_Angle)));

#debug concat ("Rayon : ", str (R,0,2), "\n")

#declare fn_creneaux = function(x,y,z) { (x + abs(mod(100+(z*sin(radians(Ray_Angle))+y*cos(radians(Ray_Angle))),1)-0.5))*(1.3+x) }
#declare fn_creneaux_r = function(x,y,z) { (x + 0.5)*(1.3+x) }
#declare f_diam= function (x,y,z) { 1.6 + sin(1.5*pi*y/6.5)/1.5 }

#declare f_vase=function (x,y,z) {
  0.06
  + max (-y, y-6.5,
    #if (Vase_Qual > 1)
      fn_creneaux
    #else
      fn_creneaux_r
    #end
      (f_diam(x,y,z)*sqrt(x*x+z*z)-R, y, R*acos(x/sqrt(x*x+z*z))))
    #if (Vase_Qual > 2)
    - f_agate(x*3,y*3,z*3)/22
  #end
}

#local Vase_Pos=transform { translate <-0.6,0,0.1> };

#if (Vase_Qual >= 0)
  #declare Vase =
  #if (Vase_Qual > 0)
    isosurface {
      function { f_vase(x,y,z) }
      contained_by { box { <-5.5,0,-5.5>, <5.5,7,5.5> } }
      accuracy 0.001
      max_gradient 35
      texture { T_Agate }
    }
  #else
    #include "vase060nosmooth.inc"
    object {
      isoVase
      texture { T_Agate }
    }
  #end

  #if (Vase_Qual >= 0)
    union {
      torus {
        R-1.00, 0.08
        translate <0, 6.48, 0>
        texture { T_Gold_1C }
      }
      object { Vase }
      transform { Vase_Pos }
    }
  #end
#end

// ----------------------------------------
#if (With_Hand)
  #include "main_droite_pov.inc"
  #local Main=object {
    Main_droite
    scale 6
    translate <-0.3,-0.3,0.3>
    rotate <0,0,-90>    
    rotate <0,-90,0>
    translate <-1,6,-1>
  }
  object {
    Main
    transform { Vase_Pos }
  }
#end

// ----------------------------------------
#local T_Chair=texture {
  pigment {
    dents
    turbulence 0.2
    color_map {
      [0.0 rgb <1.0, 1.0, 0.7>]
      [0.3 rgb <1.0, 0.95, 0.75>]
      [0.5 rgb <1.0, 1.0, 0.95>*0.5]
      [1.0 rgb <1.0, 1.0, 0.95>*0.3]
    }
    scale 0.2
  }
  finish {
    phong 4
    phong_size 60
    ambient 0
  }
  normal {
    average
    normal_map {
      [1.0 gradient x 0.5 turbulence 0.5 sine_wave ]
      [1.0 gradient y 0.5 turbulence 0.5 sine_wave ]
    }
    scale 0.04
  }
}

#local T_Tete=texture {
  pigment { rgb 0.0 }
  finish { phong 3.0 phong_size 20 }
}

#if (With_Worms)
  #include "worm_pos_vase.inc"
  
  // -- Tetes
  union {
    #local i = 0;
    #while (i < Max_Worms)
      sphere { SegPos[i][0], SegRad[i][0] } //*0.6 }
      #local i = i + 1;
    #end
    texture { T_Tete }
    transform { Vase_Pos }
  }

  // -- Corps
  union {
    #local i = 0;
    #while (i < Max_Worms)
      #local j = 1;
      #while (j < Nb_Segments)
	sphere { SegPos[i][j], SegRad[i][j] }
	#local j = j + 1;
      #end
      #local i = i + 1;
    #end
    texture { T_Chair }
    transform { Vase_Pos }
  }

  #local Pos_Extra_Worm = transform { translate <3.2,6.58,-3.5> };
  #local Worm_no=2;
  #local Extra_Worm = union {
    sphere { SegPos[Worm_no][0], SegRad[Worm_no][0] * 1.0 texture { T_Tete } }
    union {
      #local j = 1;
      #while (j < Nb_Segments)
	sphere { SegPos[Worm_no][j], SegRad[Worm_no][j] }
	#local j = j + 1;
      #end
      texture { T_Chair }
    }
  }

  #local A=min_extent (Extra_Worm);
  #local B=max_extent (Extra_Worm);
  
  object {
    Extra_Worm
    translate -(A+B)/2
    transform { Pos_Extra_Worm }
    transform { Vase_Pos }
  }
#end

// ----------------------------------------
// Mur
plane {
  z, 28.5
  texture {
    pigment { rgb <0.3,0.2,0.2> }
    normal {
      average
      turbulence 0.5
      normal_map {
        [1.0 gradient x 0.5 scale 1 ]
        [1.0 granite 0.1 scale 0.1 ]
      }
    }
  }
}

box {
  <-40,0,28>, <20,2,28.5>
  texture {
    pigment { rgb 0.7 }
    normal { agate scale 0.3 }
  }
}

// ----------------------------------------
#if (With_Squelette)
  #include "squelette_pov.inc"
  object {
    Squelette
    rotate 180*y
    scale <-1,1,1>*50
    translate <-8,-1,8>
  }
#end

#if (With_Sword)
  #include "runesword.inc"
  object {
    RuneSword
    rotate 87*x+3*y
    rotate 25*y
    translate <-10, 0.4, 6>
  }
#end
