
#macro rprism(points,pat)
prism
{
    -0.1,0.1,points
#local a=0;
#while(a<360)
#local a2=a+f_bozo(a*100,pat,1)*(360/points);
#local rp=f_bozo(a*100,pat,2);
#local xp=rp*sind(a2);
#local yp=rp*cosd(a2);
    ,<xp,yp>
#local a=a+(360/points);
#end
}
#end


#declare t_boarding=
texture
{
	bozo
	scale 0.1
	texture_map
	{
		[0.0  DMFWood4 rotate <0,80,-20> translate 8 scale 0.2]
		[0.24  DMFWood4 rotate <0,80,-20> translate 8 scale 0.2]
		[0.25  pigment {Black}]
		[0.26  DMFWood4 rotate <0,80,-70> translate 2 scale 0.2]
		[0.49  DMFWood4 rotate <0,80,-70> translate 2 scale 0.2]
		[0.50  pigment {Black}]
		[0.51  DMFWood4 rotate <0,80,-30> translate 7 scale 0.2]
		[0.74  DMFWood4 rotate <0,80,-30> translate 7 scale 0.2]
		[0.75  pigment {Black}]
		[0.76  DMFWood4 rotate <0,80,20> translate 10 scale 0.2]
		[1.0  DMFWood4 rotate <0,80,20> translate 10 scale 0.2]
	}
}

#macro boarding(bw,bh,bd,pat)
box
{
	<-bw/2,-bh/2,0> <bw/2,bh/2,bd>
	texture{t_boarding translate <0,pat,pat>}
}
#end

#declare nest=
union
{
#declare i=0;
#while(i<1440)
	cylinder{<-0.5,f_bozo(i,0,0),f_bozo(0,i,0)+0.5> <0.5,f_bozo(i,0,0.15),f_bozo(0,i,0.25)+0.5> 0.02 rotate <0,i,0>}
#declare i=i+3.4;
#end
	pigment
	{
		bozo scale 0.1
		color_map
		{
			[0.0 rgb <0.6,0.4,0.2>]
			[1.0 rgb <0.3,0.2,0.1>]
		}
	}
}

#declare bird_shit=
box
{
	<0,0,0> <1,-3,1>
	pigment
	{
		function{clip(f_bozo(x*50,y*7,z*50)+0.15-f_r((x-0.1)*1.5,(y)/4,(z-0.1)*1.5),0,1)}
		color_map
		{
			[0.6 rgbf 1]
			[0.6 rgb 1]
			[0.75 rgb 1]
			[0.8 Black]
		}
	}
}


#declare internal_floor=
box
{
	<-3.9,0,2.9> <3.9,0.15,0.1>
	texture
	{
		pigment
		{
			checker
			pigment { bozo scale <50,1,1>*0.005 color_map {[0.0 Gray70] [0.5 Gray60] [0.75 color <0.5,0.2,0.2>] [1.0 color <0.6,0.1,0.1>]}}
			pigment { bozo scale <1,1,50>*0.005 color_map {[0.0 Gray80] [0.25 Gray60] [0.5 color <0.5,0.2,0.2>] [1.0 color <0.6,0.1,0.1>]}}
			scale 0.5
			rotate <0,45,0>
		}
	}
	texture
	{
		pigment
		{
			bozo scale 0.25
			color_map
			{
				[0.0 rgbt 1]
				[1.0 rgbt 0.2]
			}
		}
	}
}

#declare mold=
pigment
{
	function{ clip(f_bozo(x*4,y,z*2)*f_bozo(x,y/6,z/2)-((y-1)/3),0,1)}
	color_map
	{
		[0.0 rgbt 0.9]
//		[0.2 rgbt <0.0,0.1,0.0,0.9>]
		[0.4 rgbt <0.0,0.2,0.0,0.8>]
		[0.6 rgbt <0.0,0.3,0.0,0.5>]
		[1.0 rgb <0.1,0.4,0.1>]
	}
}

#declare brick_texture=
texture
{
	brick
	texture
	{
		pigment
		{
			bozo scale 0.05
			color_map
			{
				[0.0 rgb <0.9,0.9,0.8>]
				[0.2 rgb <0.7,0.7,0.6>]
				[0.8 rgb <0.6,0.6,0.5>]
				[0.8 rgb <0.2,0.2,0.2>]
			}
		}
		normal {bumps 0.4 scale 0.05}
	}
	texture
	{
		pigment
		{
			bozo scale <0.5,0.1,0.5>
				color_map
			{
				[0.0 rgb <0.8,0.3,0.1>]
				[0.7 rgb <0.7,0.2,0.1>]
				[1.0 rgb <0.5,0.1,0.15>]
			}
		}
		normal {bumps 0.5 scale <0.1,0.05,0.1>}
	}
	scale 0.025
}

#declare brick_building =
difference
{
	union
	{
		box {<-4,0,3> <4,3.2,0>  }
		box
		{
			<-4.001,0,3.001><4.001,3.19,-0.001>
			pigment{mold}
		}
	}
	box
	{
		<-3.8,-0.01,2.9> <3.8,3,0.25>
		pigment
		{
			bozo scale 0.25
			color_map{[0.0 rgb 0.1][0.5 rgb 0.33][1.0 rgb 0.5]}
		}
	}

	box {<-3.7,0.5,-0.1> <0,2.0,0.26>}
	box {<0.25,0.15,-0.1> <1.25,2.0,0.26>}
	box {<1.5,1.0,-0.1> <3.7,2.0,0.26>}
	texture{brick_texture}
}

#declare some_grass=
union
{
#declare i=0;
#while(i<20)
#declare gx=(f_bozo(i,0,0)-0.5)*30;
#if((gx>-4)&(gx<4))
	object{grass(f_bozo(i,1,1)*100+50,i*10) scale 0.1+f_bozo(i,2,1)*0.2 translate <gx,0,-0.04>}
#end
#declare i=i+1;
#end
}

#declare plain_building=
box
{
	<-4,0,3> <4,3,0>
	texture{brick_texture}
}

#declare brnd=seed(13611);
#declare some_bits=
union
{
#local i=0;
#while(i<25)
	object{rprism(3,rand(brnd)*10) scale (rand(brnd)+1)/8 translate <rand(brnd)*10-5,0,-rand(brnd)*rand(brnd)>  pigment {rgbf <0.9,0.9,0.9,0.2>}}
	object{rprism(4,rand(brnd)*10) scale (rand(brnd)+1)/8 translate <rand(brnd)*10-5,0,-rand(brnd)*rand(brnd)>  pigment {rgbf <0.9,0.9,0.9,0.2>}}
	object{rprism(5,rand(brnd)*10) scale (rand(brnd)+1)/5 translate <rand(brnd)*10-5,0,-rand(brnd)*rand(brnd)>  pigment {rgbf <0.9,0.9,0.9,0.2>}}
	object{rprism(4,rand(brnd)*10) scale (rand(brnd)+1)/7 translate <rand(brnd)*10-5,0,-rand(brnd)*rand(brnd)>  pigment {rgbf <1,0,0,0.2>}}
#local i=i+1;
#end
}

#declare building =
union
{
	light_source { <0,2.45,1.5> color rgb -0.5 fade_distance 2 fade_power 3}
#if(detail<2)
	object {sign translate <0,2.2,-0.2>}
#end
	object {internal_floor}
	object {brick_building}
	object {nest scale 0.1 translate <-3.9,3.175,.1>}
	object {bird_shit translate <-4.002,3.2,-0.002>}
	object {door translate <0.75,0.15,0>}
	object {window_sill1 rotate <-10,0,0> translate <-1.85,0.5,-0.02>}
	object {window_sill2 rotate <-10,0,0>translate <2.6,1.0,-0.02>}
	object {boarding(0.95,1.5,0.02,1) rotate <0,0,1> translate<-3.28,1.27,-0.02>}
	object {boarding(0.95,1.5,0.02,2) rotate <0,0,-1> translate<-2.30,1.30,-0.025>}
	object {boarding(0.95,1.5,0.02,3) rotate <0,0,-3> translate<-1.33,1.28,-0.021>}
	object {boarding(0.95,1.5,0.02,4) rotate <0,0,-2> translate<-0.35,1.30,-0.022>}

	object {boarding(1.1,1.1,0.02,1) rotate <0,0,-4> translate<2.04,1.60,-0.022>}
	object {boarding(1.1,1.1,0.02,3) rotate <-1,0,-0> translate<3.17,1.55,-0.023>}

	object {poster(0) scale <0.2,0.25,1> rotate <0,0,4> translate <-2.5,1.3,-0.026>}
	object {poster(1) scale <0.2,0.25,1> rotate <0,0,-1> translate <-1,1.3,-0.026>}
	object {pposter scale <0.2,0.25,1> rotate <0,0,1.5> translate <-2,1.21,-0.027>}
	object {some_grass}
	object {some_bits}
}

