

#macro cup(pat)
#local r1 = 0.04;
#local r2 = 0.03;
#local th = 0.001;
#local h = 0.1;
union
{
	difference
	{
		cone
		{
			<0,0,0> r2, <0,h,0> r1
			pigment
			{
				function
				{
					f_noise3d(x/0.01, y/0.005,pat ) < (f_r(x*20, (y-h/2)*10,0)+0.33)
				}
				color_map
				{
					[0.5 color White]
					[0.5 color Red]
				}
			}			
		}
		cone {<0,-th,0> r2-th, <0,h+th,0> r1-th}
	}
	torus{ r1,th*1.2 translate <0,h,0>}
	cylinder { <0,h/20,0> <0,th+h/20,0> (r2*19+r1)/20 }
	pigment {White}
	scale 2
}
#end

#macro cup_side(pat)
object{cup(pat) rotate<0,0,84> translate <0,0.06,0>}
#end
