
#declare t_wood=
texture {T_Wood7 rotate <0,90,0> scale 0.1}

#declare t_paint=
texture
{
	pigment
	{
		function{clip(0.2+y/10+f_bozo(x*10,y*4,z*10)/2+(f_bozo(x*100,y*100,z*100)-0.5)/10,0,1)}
		pigment_map
		{
			[0.3 rgbt <0.1,0.1,0.1,0.7>]
			[0.35 rgbt <0.5,0.5,0.5,0.7>]
			[0.41 rgb 0.8]
			[0.42 rgb 0.7]
			[0.42 rgb <0.8,0.2,0.2>]
			[1.0 rgb <0.8,0,0>]
		}
	}
}

#macro plank(xd,yd,zd)
box {<-xd,-yd,-zd>/2,<xd,yd,zd>/2}
#end

#declare doorh=1.8;
#declare doorw=1.0;
#declare doort=0.06;
#declare hfw=0.075;
#declare vfw=0.2;
#declare framew=0.05;
#declare framet=0.05;
#declare doorang=63;
#declare windowt=0.005;

#macro window(xw,yw,zw)
box {<-xw,-yw,-zw>/2,<xw,yw,zw>/2}
#end

#macro window_break(points,pat)
prism
{
	-0.1,0.1,points*3
#declare a=0;
#while(a<360)
#declare a2=a+f_bozo(a*100,pat,1)*(360/points);
#declare a3=a+f_bozo(a*100,pat,4)*(360/points)*4;
#declare rp=f_bozo(a*100,pat,2);
#declare xp=rp*sind(a2);
#declare yp=rp*cosd(a2);
	,<xp,yp>
#declare rp=3+f_bozo(a3*100,pat,3);
#declare xp=rp*sind(a2+1);
#declare yp=rp*cosd(a2+1);
	,<xp,yp>
#declare rp=f_bozo(a*100,pat,4);
#declare xp=rp*sind(a2+2);
#declare yp=rp*cosd(a2+2);
	,<xp,yp>
#declare a=a+(360/points);
#end
	rotate<90,0,0>
}
#end	


#declare door_frame =
union
{
	object {plank(doorh+framew*2,framew,framet) texture {t_wood} rotate<0,0,90> translate<doorw/2+framew/2,0,0> texture{ t_paint translate <1,0.2,1>}}
	object {plank(doorh+framew*2,framew,framet) texture {t_wood} rotate<0,0,90> translate<-(doorw/2+framew/2),0,0> texture{ t_paint translate <1,0.2,1>}}
	object {plank(doorw,framew,framet) texture {t_wood} translate<0,doorh/2+framew/2,0> texture{ t_paint translate <1,0.2,1>}}
	object {plank(doorw,framew,framet) texture {t_wood} translate<0,-(doorh/2+framew/2),0> texture{ t_paint translate <1,0.2,1>}}
}

#declare door2 =
union
{
	object {plank(doorh,hfw,doort) texture {t_wood} rotate <0,0,90> translate <-(doorw/2-hfw/2),0,0>  texture{ t_paint}}
	object {plank(doorh,hfw,doort) texture {t_wood} rotate <0,0,90> translate <(doorw/2-hfw/2),0,0>  texture{ t_paint}}
	object {plank(doorw-(2*hfw),vfw,doort)  texture {t_wood} translate<0,0,-0.001> texture{ t_paint}}
	object {plank(doorw-(2*hfw),vfw,doort)  texture {t_wood} translate<0,(doorh/2-vfw/2)+0.001,0.002>  texture{ t_paint}}
	object {plank(doorw-(2*hfw),vfw,doort)  texture {t_wood} translate<0,-(doorh/2-vfw/2)-0.001,-0.001>  texture{ t_paint}}

	union
	{
		difference	// bottom window
		{
			object {window(doorw-hfw,doorh/2-vfw/2,windowt) translate<0,-doorh/4,0>}
			object {window_break(8,1) scale 0.375  translate<doorw/6,-doorh/3.5,0>}
		}
		difference // top window
		{
			object {window(doorw-hfw,doorh/2-vfw/2,windowt) translate<0,doorh/4,0>}
			object {window_break(8,2) scale 0.25  translate<0,doorh/4,0>}
		}
#if(detail=0)
		interior{I_Glass1}
		finish{F_Glass5}
		pigment{Col_Glass_Old}
		normal{bozo 0.15 scale 0.25 }
#else
		pigment {rgbf 0.8}
#end
	}
	torus
	{
		0.1,0.01
		scale <1,1.75,0.7>
		rotate <0,0,90>
		translate <doorw/2-vfw/6,0,-doort>
		pigment {rgb<0.8,0.4,0.3>}
		finish {phong 0.4 phong_size 100}
		normal {bumps 0.25 scale 0.001}
	}
	translate<doorw/2,0,doort/2>
	rotate<0,doorang,0>
	translate<-doorw/2,0,-doort/2>
}

#declare door=
union
{
	object{door2}
	object{door_frame}
	translate <0,doorh/2+framew,0>
}

#declare window_sill1=
union
{
	object{plank(3.7,0.025 0.1)  texture {t_wood}  texture{ t_paint translate <3,0.2,1>}}
	object{plank(3.7,0.2, 0.025)  texture {t_wood} translate <0,0,0.05> texture{ t_paint translate <3,0.2,1>}}
}

#declare window_sill2=
union
{
	object{plank(2.2,0.025 0.1)  texture {t_wood}  texture{ t_paint translate <1,0.2,4>}}
	object{plank(2.2,0.2, 0.025)  texture {t_wood} translate <0,0,0.05> texture{ t_paint translate <1,0.2,4>}}
}

